// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanrooms

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanrooms/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of the ID namespace associations in a collaboration.
func (c *Client) ListCollaborationIdNamespaceAssociations(ctx context.Context, params *ListCollaborationIdNamespaceAssociationsInput, optFns ...func(*Options)) (*ListCollaborationIdNamespaceAssociationsOutput, error) {
	if params == nil {
		params = &ListCollaborationIdNamespaceAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCollaborationIdNamespaceAssociations", params, optFns, c.addOperationListCollaborationIdNamespaceAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCollaborationIdNamespaceAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCollaborationIdNamespaceAssociationsInput struct {

	// The unique identifier of the collaboration that contains the ID namespace
	// associations that you want to retrieve.
	//
	// This member is required.
	CollaborationIdentifier *string

	// The maximum size of the results that is returned per call. Service chooses a
	// default if it has not been set. Service may return a nextToken even if the
	// maximum results has not been met.>
	MaxResults *int32

	// The pagination token that's used to fetch the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCollaborationIdNamespaceAssociationsOutput struct {

	// The summary information of the collaboration ID namespace associations that you
	// requested.
	//
	// This member is required.
	CollaborationIdNamespaceAssociationSummaries []types.CollaborationIdNamespaceAssociationSummary

	// The token value provided to access the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCollaborationIdNamespaceAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCollaborationIdNamespaceAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCollaborationIdNamespaceAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCollaborationIdNamespaceAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListCollaborationIdNamespaceAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCollaborationIdNamespaceAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListCollaborationIdNamespaceAssociationsPaginatorOptions is the paginator
// options for ListCollaborationIdNamespaceAssociations
type ListCollaborationIdNamespaceAssociationsPaginatorOptions struct {
	// The maximum size of the results that is returned per call. Service chooses a
	// default if it has not been set. Service may return a nextToken even if the
	// maximum results has not been met.>
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCollaborationIdNamespaceAssociationsPaginator is a paginator for
// ListCollaborationIdNamespaceAssociations
type ListCollaborationIdNamespaceAssociationsPaginator struct {
	options   ListCollaborationIdNamespaceAssociationsPaginatorOptions
	client    ListCollaborationIdNamespaceAssociationsAPIClient
	params    *ListCollaborationIdNamespaceAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListCollaborationIdNamespaceAssociationsPaginator returns a new
// ListCollaborationIdNamespaceAssociationsPaginator
func NewListCollaborationIdNamespaceAssociationsPaginator(client ListCollaborationIdNamespaceAssociationsAPIClient, params *ListCollaborationIdNamespaceAssociationsInput, optFns ...func(*ListCollaborationIdNamespaceAssociationsPaginatorOptions)) *ListCollaborationIdNamespaceAssociationsPaginator {
	if params == nil {
		params = &ListCollaborationIdNamespaceAssociationsInput{}
	}

	options := ListCollaborationIdNamespaceAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCollaborationIdNamespaceAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCollaborationIdNamespaceAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCollaborationIdNamespaceAssociations page.
func (p *ListCollaborationIdNamespaceAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCollaborationIdNamespaceAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCollaborationIdNamespaceAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCollaborationIdNamespaceAssociationsAPIClient is a client that implements
// the ListCollaborationIdNamespaceAssociations operation.
type ListCollaborationIdNamespaceAssociationsAPIClient interface {
	ListCollaborationIdNamespaceAssociations(context.Context, *ListCollaborationIdNamespaceAssociationsInput, ...func(*Options)) (*ListCollaborationIdNamespaceAssociationsOutput, error)
}

var _ ListCollaborationIdNamespaceAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCollaborationIdNamespaceAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCollaborationIdNamespaceAssociations",
	}
}
