// Code generated by smithy-go-codegen DO NOT EDIT.

package codeguruprofiler

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codeguruprofiler/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Returns a list of [Recommendation]Recommendation objects that contain recommendations for a
//
// profiling group for a given time period. A list of [Anomaly]Anomaly objects that
// contains details about anomalies detected in the profiling group for the same
// time period is also returned.
//
// [Anomaly]: https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html
//
// [Recommendation]: https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html
func (c *Client) GetRecommendations(ctx context.Context, params *GetRecommendationsInput, optFns ...func(*Options)) (*GetRecommendationsOutput, error) {
	if params == nil {
		params = &GetRecommendationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetRecommendations", params, optFns, c.addOperationGetRecommendationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetRecommendationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The structure representing the GetRecommendationsRequest.
type GetRecommendationsInput struct {

	//  The start time of the profile to get analysis data about. You must specify
	// startTime and endTime . This is specified using the ISO 8601 format. For
	// example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
	// 1:15:02 PM UTC.
	//
	// This member is required.
	EndTime *time.Time

	//  The name of the profiling group to get analysis data about.
	//
	// This member is required.
	ProfilingGroupName *string

	//  The end time of the profile to get analysis data about. You must specify
	// startTime and endTime . This is specified using the ISO 8601 format. For
	// example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
	// 1:15:02 PM UTC.
	//
	// This member is required.
	StartTime *time.Time

	//  The language used to provide analysis. Specify using a string that is one of
	// the following BCP 47 language codes.
	//
	//   - de-DE - German, Germany
	//
	//   - en-GB - English, United Kingdom
	//
	//   - en-US - English, United States
	//
	//   - es-ES - Spanish, Spain
	//
	//   - fr-FR - French, France
	//
	//   - it-IT - Italian, Italy
	//
	//   - ja-JP - Japanese, Japan
	//
	//   - ko-KR - Korean, Republic of Korea
	//
	//   - pt-BR - Portugese, Brazil
	//
	//   - zh-CN - Chinese, China
	//
	//   - zh-TW - Chinese, Taiwan
	Locale *string

	noSmithyDocumentSerde
}

// The structure representing the GetRecommendationsResponse.
type GetRecommendationsOutput struct {

	//  The list of anomalies that the analysis has found for this profile.
	//
	// This member is required.
	Anomalies []types.Anomaly

	//  The end time of the profile the analysis data is about. This is specified
	// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
	// millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// This member is required.
	ProfileEndTime *time.Time

	//  The start time of the profile the analysis data is about. This is specified
	// using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
	// millisecond past June 1, 2020 1:15:02 PM UTC.
	//
	// This member is required.
	ProfileStartTime *time.Time

	// The name of the profiling group the analysis data is about.
	//
	// This member is required.
	ProfilingGroupName *string

	// The list of recommendations that the analysis found for this profile.
	//
	// This member is required.
	Recommendations []types.Recommendation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetRecommendationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetRecommendations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetRecommendations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetRecommendations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetRecommendationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetRecommendations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetRecommendations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetRecommendations",
	}
}
