// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the layout used to view data for a specific domain. This API can only
// be invoked from the Amazon Connect admin website.
func (c *Client) UpdateDomainLayout(ctx context.Context, params *UpdateDomainLayoutInput, optFns ...func(*Options)) (*UpdateDomainLayoutOutput, error) {
	if params == nil {
		params = &UpdateDomainLayoutInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateDomainLayout", params, optFns, c.addOperationUpdateDomainLayoutMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateDomainLayoutOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateDomainLayoutInput struct {

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The unique name of the layout.
	//
	// This member is required.
	LayoutDefinitionName *string

	// The description of the layout
	Description *string

	// The display name of the layout
	DisplayName *string

	// If set to true for a layout, this layout will be used by default to view data.
	// If set to false, then the layout will not be used by default, but it can be used
	// to view data by explicitly selecting it in the console.
	IsDefault bool

	// A customizable layout that can be used to view data under a Customer Profiles
	// domain.
	Layout *string

	// The type of layout that can be used to view data under a Customer Profiles
	// domain.
	LayoutType types.LayoutType

	noSmithyDocumentSerde
}

type UpdateDomainLayoutOutput struct {

	// The timestamp of when the layout was created.
	CreatedAt *time.Time

	// The description of the layout
	Description *string

	// The display name of the layout
	DisplayName *string

	// If set to true for a layout, this layout will be used by default to view data.
	// If set to false, then the layout will not be used by default, but it can be used
	// to view data by explicitly selecting it in the console.
	IsDefault bool

	// The timestamp of when the layout was most recently updated.
	LastUpdatedAt *time.Time

	// A customizable layout that can be used to view data under a Customer Profiles
	// domain.
	Layout *string

	// The unique name of the layout.
	LayoutDefinitionName *string

	// The type of layout that can be used to view data under a Customer Profiles
	// domain.
	LayoutType types.LayoutType

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	// The version used to create layout.
	Version *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateDomainLayoutMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateDomainLayout{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateDomainLayout{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateDomainLayout"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateDomainLayoutValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateDomainLayout(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateDomainLayout(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateDomainLayout",
	}
}
