// Code generated by smithy-go-codegen DO NOT EDIT.

package directoryservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/directoryservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Initiates a directory assessment to validate your self-managed AD environment
// for hybrid domain join. The assessment checks compatibility and connectivity of
// the self-managed AD environment.
//
// A directory assessment is automatically created when you create a hybrid
// directory. There are two types of assessments: CUSTOMER and SYSTEM . Your Amazon
// Web Services account has a limit of 100 CUSTOMER directory assessments.
//
// The assessment process typically takes 30 minutes or more to complete. The
// assessment process is asynchronous and you can monitor it with
// DescribeADAssessment .
//
// The InstanceIds must have a one-to-one correspondence with CustomerDnsIps ,
// meaning that if the IP address for instance i-10243410 is 10.24.34.100 and the
// IP address for instance i-10243420 is 10.24.34.200, then the input arrays must
// maintain the same order relationship, either [10.24.34.100, 10.24.34.200] paired
// with [i-10243410, i-10243420] or [10.24.34.200, 10.24.34.100] paired with
// [i-10243420, i-10243410].
//
// Note: You must provide exactly one DirectoryId or AssessmentConfiguration .
func (c *Client) StartADAssessment(ctx context.Context, params *StartADAssessmentInput, optFns ...func(*Options)) (*StartADAssessmentOutput, error) {
	if params == nil {
		params = &StartADAssessmentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartADAssessment", params, optFns, c.addOperationStartADAssessmentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartADAssessmentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartADAssessmentInput struct {

	// Configuration parameters for the directory assessment, including DNS server
	// information, domain name, Amazon VPC subnet, and Amazon Web Services System
	// Manager managed node details.
	AssessmentConfiguration *types.AssessmentConfiguration

	// The identifier of the directory for which to perform the assessment. This
	// should be an existing directory. If the assessment is not for an existing
	// directory, this parameter should be omitted.
	DirectoryId *string

	noSmithyDocumentSerde
}

type StartADAssessmentOutput struct {

	// The unique identifier of the newly started directory assessment. Use this
	// identifier to monitor assessment progress and retrieve results.
	AssessmentId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartADAssessmentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartADAssessment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartADAssessment{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartADAssessment"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartADAssessmentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartADAssessment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartADAssessment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartADAssessment",
	}
}
