// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Returns information about a specific elastic cluster.
type Cluster struct {

	// The name of the elastic cluster administrator.
	//
	// This member is required.
	AdminUserName *string

	// The authentication type for the elastic cluster.
	//
	// This member is required.
	AuthType Auth

	// The ARN identifier of the elastic cluster.
	//
	// This member is required.
	ClusterArn *string

	// The URL used to connect to the elastic cluster.
	//
	// This member is required.
	ClusterEndpoint *string

	// The name of the elastic cluster.
	//
	// This member is required.
	ClusterName *string

	// The time when the elastic cluster was created in Universal Coordinated Time
	// (UTC).
	//
	// This member is required.
	CreateTime *string

	// The KMS key identifier to use to encrypt the elastic cluster.
	//
	// This member is required.
	KmsKeyId *string

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// This member is required.
	PreferredMaintenanceWindow *string

	// The number of vCPUs assigned to each elastic cluster shard. Maximum is 64.
	// Allowed values are 2, 4, 8, 16, 32, 64.
	//
	// This member is required.
	ShardCapacity *int32

	// The number of shards assigned to the elastic cluster. Maximum is 32.
	//
	// This member is required.
	ShardCount *int32

	// The status of the elastic cluster.
	//
	// This member is required.
	Status Status

	// The Amazon EC2 subnet IDs for the elastic cluster.
	//
	// This member is required.
	SubnetIds []string

	// A list of EC2 VPC security groups associated with thie elastic cluster.
	//
	// This member is required.
	VpcSecurityGroupIds []string

	// The number of days for which automatic snapshots are retained.
	BackupRetentionPeriod *int32

	// The daily time range during which automated backups are created if automated
	// backups are enabled, as determined by backupRetentionPeriod .
	PreferredBackupWindow *string

	// The number of replica instances applying to all shards in the cluster. A
	// shardInstanceCount value of 1 means there is one writer instance, and any
	// additional instances are replicas that can be used for reads and to improve
	// availability.
	ShardInstanceCount *int32

	// The total number of shards in the cluster.
	Shards []Shard

	noSmithyDocumentSerde
}

// A list of Amazon DocumentDB elastic clusters.
type ClusterInList struct {

	// The ARN identifier of the elastic cluster.
	//
	// This member is required.
	ClusterArn *string

	// The name of the elastic cluster.
	//
	// This member is required.
	ClusterName *string

	// The status of the elastic cluster.
	//
	// This member is required.
	Status Status

	noSmithyDocumentSerde
}

// Returns information about a specific elastic cluster snapshot.
type ClusterSnapshot struct {

	// The name of the elastic cluster administrator.
	//
	// This member is required.
	AdminUserName *string

	// The ARN identifier of the elastic cluster.
	//
	// This member is required.
	ClusterArn *string

	// The time when the elastic cluster was created in Universal Coordinated Time
	// (UTC).
	//
	// This member is required.
	ClusterCreationTime *string

	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a cluster using the same Amazon account that owns this
	// KMS encryption key, you can use the KMS key alias instead of the ARN as the KMS
	// encryption key. If an encryption key is not specified here, Amazon DocumentDB
	// uses the default encryption key that KMS creates for your account. Your account
	// has a different default encryption key for each Amazon Region.
	//
	// This member is required.
	KmsKeyId *string

	// The ARN identifier of the elastic cluster snapshot.
	//
	// This member is required.
	SnapshotArn *string

	// The time when the elastic cluster snapshot was created in Universal Coordinated
	// Time (UTC).
	//
	// This member is required.
	SnapshotCreationTime *string

	// The name of the elastic cluster snapshot.
	//
	// This member is required.
	SnapshotName *string

	// The status of the elastic cluster snapshot.
	//
	// This member is required.
	Status Status

	// The Amazon EC2 subnet IDs for the elastic cluster.
	//
	// This member is required.
	SubnetIds []string

	// A list of EC2 VPC security groups to associate with the elastic cluster.
	//
	// This member is required.
	VpcSecurityGroupIds []string

	// The type of cluster snapshots to be returned. You can specify one of the
	// following values:
	//
	//   - automated - Return all cluster snapshots that Amazon DocumentDB has
	//   automatically created for your Amazon Web Services account.
	//
	//   - manual - Return all cluster snapshots that you have manually created for
	//   your Amazon Web Services account.
	SnapshotType SnapshotType

	noSmithyDocumentSerde
}

// A list of elastic cluster snapshots.
type ClusterSnapshotInList struct {

	// The ARN identifier of the elastic cluster.
	//
	// This member is required.
	ClusterArn *string

	// The ARN identifier of the elastic cluster snapshot.
	//
	// This member is required.
	SnapshotArn *string

	// The time when the elastic cluster snapshot was created in Universal Coordinated
	// Time (UTC).
	//
	// This member is required.
	SnapshotCreationTime *string

	// The name of the elastic cluster snapshot.
	//
	// This member is required.
	SnapshotName *string

	// The status of the elastic cluster snapshot.
	//
	// This member is required.
	Status Status

	noSmithyDocumentSerde
}

// Retrieves the details of maintenance actions that are pending.
type PendingMaintenanceActionDetails struct {

	// Displays the specific action of a pending maintenance action.
	//
	// This member is required.
	Action *string

	// Displays the date of the maintenance window when the action is applied. The
	// maintenance action is applied to the resource during its first maintenance
	// window after this date. If this date is specified, any NEXT_MAINTENANCE optInType
	// requests are ignored.
	AutoAppliedAfterDate *string

	// Displays the effective date when the pending maintenance action is applied to
	// the resource.
	CurrentApplyDate *string

	// Displays a description providing more detail about the maintenance action.
	Description *string

	// Displays the date when the maintenance action is automatically applied. The
	// maintenance action is applied to the resource on this date regardless of the
	// maintenance window for the resource. If this date is specified, any IMMEDIATE
	// optInType requests are ignored.
	ForcedApplyDate *string

	// Displays the type of optInType request that has been received for the resource.
	OptInStatus *string

	noSmithyDocumentSerde
}

// Provides information about a pending maintenance action for a resource.
type ResourcePendingMaintenanceAction struct {

	// Provides information about a pending maintenance action for a resource.
	PendingMaintenanceActionDetails []PendingMaintenanceActionDetails

	// The Amazon DocumentDB Amazon Resource Name (ARN) of the resource to which the
	// pending maintenance action applies.
	ResourceArn *string

	noSmithyDocumentSerde
}

// The name of the shard.
type Shard struct {

	// The time when the shard was created in Universal Coordinated Time (UTC).
	//
	// This member is required.
	CreateTime *string

	// The ID of the shard.
	//
	// This member is required.
	ShardId *string

	// The current status of the shard.
	//
	// This member is required.
	Status Status

	noSmithyDocumentSerde
}

// A specific field in which a given validation exception occurred.
type ValidationExceptionField struct {

	// An error message describing the validation exception in this field.
	//
	// This member is required.
	Message *string

	// The name of the field where the validation exception occurred.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
