// Code generated by smithy-go-codegen DO NOT EDIT.

package georoutes

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/georoutes/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// SnapToRoads matches GPS trace to roads most likely traveled on.
func (c *Client) SnapToRoads(ctx context.Context, params *SnapToRoadsInput, optFns ...func(*Options)) (*SnapToRoadsOutput, error) {
	if params == nil {
		params = &SnapToRoadsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SnapToRoads", params, optFns, c.addOperationSnapToRoadsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SnapToRoadsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SnapToRoadsInput struct {

	// List of trace points to be snapped onto the road network.
	//
	// This member is required.
	TracePoints []types.RoadSnapTracePoint

	// Optional: The API key to be used for authorization. Either an API key or valid
	// SigV4 signature must be provided when making a request.
	Key *string

	// The radius around the provided tracepoint that is considered for snapping.
	//
	// Unit: meters
	//
	// Default value: 300
	SnapRadius int64

	// Chooses what the returned SnappedGeometry format should be.
	//
	// Default Value: FlexiblePolyline
	SnappedGeometryFormat types.GeometryFormat

	// Specifies the mode of transport when calculating a route. Used in estimating
	// the speed of travel and road compatibility.
	//
	// Default Value: Car
	TravelMode types.RoadSnapTravelMode

	// Travel mode related options for the provided travel mode.
	TravelModeOptions *types.RoadSnapTravelModeOptions

	noSmithyDocumentSerde
}

type SnapToRoadsOutput struct {

	// Notices are additional information returned that indicate issues that occurred
	// during route calculation.
	//
	// This member is required.
	Notices []types.RoadSnapNotice

	// The pricing bucket for which the query is charged at.
	//
	// This member is required.
	PricingBucket *string

	// Specifies the format of the geometry returned for each leg of the route.
	//
	// This member is required.
	SnappedGeometryFormat types.GeometryFormat

	// The trace points snapped onto the road network.
	//
	// This member is required.
	SnappedTracePoints []types.RoadSnapSnappedTracePoint

	// The interpolated geometry for the snapped route onto the road network.
	SnappedGeometry *types.RoadSnapSnappedGeometry

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSnapToRoadsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSnapToRoads{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSnapToRoads{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SnapToRoads"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSnapToRoadsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSnapToRoads(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSnapToRoads(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SnapToRoads",
	}
}
