// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemakergeospatial

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/sagemakergeospatial/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpDeleteEarthObservationJob struct {
}

func (*awsRestjson1_serializeOpDeleteEarthObservationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteEarthObservationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEarthObservationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/earth-observation-jobs/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteEarthObservationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteEarthObservationJobInput(v *DeleteEarthObservationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteVectorEnrichmentJob struct {
}

func (*awsRestjson1_serializeOpDeleteVectorEnrichmentJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteVectorEnrichmentJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVectorEnrichmentJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/vector-enrichment-jobs/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteVectorEnrichmentJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteVectorEnrichmentJobInput(v *DeleteVectorEnrichmentJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpExportEarthObservationJob struct {
}

func (*awsRestjson1_serializeOpExportEarthObservationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExportEarthObservationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportEarthObservationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/export-earth-observation-job")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentExportEarthObservationJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExportEarthObservationJobInput(v *ExportEarthObservationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentExportEarthObservationJobInput(v *ExportEarthObservationJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.ExportSourceImages != nil {
		ok := object.Key("ExportSourceImages")
		ok.Boolean(*v.ExportSourceImages)
	}

	if v.OutputConfig != nil {
		ok := object.Key("OutputConfig")
		if err := awsRestjson1_serializeDocumentOutputConfigInput(v.OutputConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpExportVectorEnrichmentJob struct {
}

func (*awsRestjson1_serializeOpExportVectorEnrichmentJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExportVectorEnrichmentJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportVectorEnrichmentJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/export-vector-enrichment-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentExportVectorEnrichmentJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExportVectorEnrichmentJobInput(v *ExportVectorEnrichmentJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentExportVectorEnrichmentJobInput(v *ExportVectorEnrichmentJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.OutputConfig != nil {
		ok := object.Key("OutputConfig")
		if err := awsRestjson1_serializeDocumentExportVectorEnrichmentJobOutputConfig(v.OutputConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetEarthObservationJob struct {
}

func (*awsRestjson1_serializeOpGetEarthObservationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEarthObservationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEarthObservationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/earth-observation-jobs/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEarthObservationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEarthObservationJobInput(v *GetEarthObservationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRasterDataCollection struct {
}

func (*awsRestjson1_serializeOpGetRasterDataCollection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRasterDataCollection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRasterDataCollectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/raster-data-collection/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRasterDataCollectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRasterDataCollectionInput(v *GetRasterDataCollectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetTile struct {
}

func (*awsRestjson1_serializeOpGetTile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tile/{z}/{x}/{y}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTileInput(v *GetTileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn != nil {
		encoder.SetQuery("Arn").String(*v.Arn)
	}

	if v.ExecutionRoleArn != nil {
		encoder.SetQuery("ExecutionRoleArn").String(*v.ExecutionRoleArn)
	}

	if v.ImageAssets != nil {
		for i := range v.ImageAssets {
			encoder.AddQuery("ImageAssets").String(v.ImageAssets[i])
		}
	}

	if v.ImageMask != nil {
		encoder.SetQuery("ImageMask").Boolean(*v.ImageMask)
	}

	if len(v.OutputDataType) > 0 {
		encoder.SetQuery("OutputDataType").String(string(v.OutputDataType))
	}

	if v.OutputFormat != nil {
		encoder.SetQuery("OutputFormat").String(*v.OutputFormat)
	}

	if v.PropertyFilters != nil {
		encoder.SetQuery("PropertyFilters").String(*v.PropertyFilters)
	}

	if len(v.Target) > 0 {
		encoder.SetQuery("Target").String(string(v.Target))
	}

	if v.TimeRangeFilter != nil {
		encoder.SetQuery("TimeRangeFilter").String(*v.TimeRangeFilter)
	}

	if v.X == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member x must not be empty")}
	}
	if v.X != nil {
		if err := encoder.SetURI("x").Integer(*v.X); err != nil {
			return err
		}
	}

	if v.Y == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member y must not be empty")}
	}
	if v.Y != nil {
		if err := encoder.SetURI("y").Integer(*v.Y); err != nil {
			return err
		}
	}

	if v.Z == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member z must not be empty")}
	}
	if v.Z != nil {
		if err := encoder.SetURI("z").Integer(*v.Z); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetVectorEnrichmentJob struct {
}

func (*awsRestjson1_serializeOpGetVectorEnrichmentJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetVectorEnrichmentJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetVectorEnrichmentJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/vector-enrichment-jobs/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetVectorEnrichmentJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetVectorEnrichmentJobInput(v *GetVectorEnrichmentJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListEarthObservationJobs struct {
}

func (*awsRestjson1_serializeOpListEarthObservationJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEarthObservationJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEarthObservationJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/list-earth-observation-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListEarthObservationJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEarthObservationJobsInput(v *ListEarthObservationJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListEarthObservationJobsInput(v *ListEarthObservationJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("SortBy")
		ok.String(*v.SortBy)
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	if len(v.StatusEquals) > 0 {
		ok := object.Key("StatusEquals")
		ok.String(string(v.StatusEquals))
	}

	return nil
}

type awsRestjson1_serializeOpListRasterDataCollections struct {
}

func (*awsRestjson1_serializeOpListRasterDataCollections) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRasterDataCollections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRasterDataCollectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/raster-data-collections")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRasterDataCollectionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRasterDataCollectionsInput(v *ListRasterDataCollectionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("MaxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("NextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListVectorEnrichmentJobs struct {
}

func (*awsRestjson1_serializeOpListVectorEnrichmentJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListVectorEnrichmentJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListVectorEnrichmentJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/list-vector-enrichment-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListVectorEnrichmentJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListVectorEnrichmentJobsInput(v *ListVectorEnrichmentJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListVectorEnrichmentJobsInput(v *ListVectorEnrichmentJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("SortBy")
		ok.String(*v.SortBy)
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	if v.StatusEquals != nil {
		ok := object.Key("StatusEquals")
		ok.String(*v.StatusEquals)
	}

	return nil
}

type awsRestjson1_serializeOpSearchRasterDataCollection struct {
}

func (*awsRestjson1_serializeOpSearchRasterDataCollection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchRasterDataCollection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchRasterDataCollectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/search-raster-data-collection")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchRasterDataCollectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchRasterDataCollectionInput(v *SearchRasterDataCollectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchRasterDataCollectionInput(v *SearchRasterDataCollectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.RasterDataCollectionQuery != nil {
		ok := object.Key("RasterDataCollectionQuery")
		if err := awsRestjson1_serializeDocumentRasterDataCollectionQueryWithBandFilterInput(v.RasterDataCollectionQuery, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartEarthObservationJob struct {
}

func (*awsRestjson1_serializeOpStartEarthObservationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartEarthObservationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartEarthObservationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/earth-observation-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartEarthObservationJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartEarthObservationJobInput(v *StartEarthObservationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartEarthObservationJobInput(v *StartEarthObservationJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.InputConfig != nil {
		ok := object.Key("InputConfig")
		if err := awsRestjson1_serializeDocumentInputConfigInput(v.InputConfig, ok); err != nil {
			return err
		}
	}

	if v.JobConfig != nil {
		ok := object.Key("JobConfig")
		if err := awsRestjson1_serializeDocumentJobConfigInput(v.JobConfig, ok); err != nil {
			return err
		}
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartVectorEnrichmentJob struct {
}

func (*awsRestjson1_serializeOpStartVectorEnrichmentJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartVectorEnrichmentJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartVectorEnrichmentJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/vector-enrichment-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartVectorEnrichmentJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartVectorEnrichmentJobInput(v *StartVectorEnrichmentJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartVectorEnrichmentJobInput(v *StartVectorEnrichmentJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.ExecutionRoleArn != nil {
		ok := object.Key("ExecutionRoleArn")
		ok.String(*v.ExecutionRoleArn)
	}

	if v.InputConfig != nil {
		ok := object.Key("InputConfig")
		if err := awsRestjson1_serializeDocumentVectorEnrichmentJobInputConfig(v.InputConfig, ok); err != nil {
			return err
		}
	}

	if v.JobConfig != nil {
		ok := object.Key("JobConfig")
		if err := awsRestjson1_serializeDocumentVectorEnrichmentJobConfig(v.JobConfig, ok); err != nil {
			return err
		}
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopEarthObservationJob struct {
}

func (*awsRestjson1_serializeOpStopEarthObservationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopEarthObservationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopEarthObservationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/earth-observation-jobs/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStopEarthObservationJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopEarthObservationJobInput(v *StopEarthObservationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStopEarthObservationJobInput(v *StopEarthObservationJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	return nil
}

type awsRestjson1_serializeOpStopVectorEnrichmentJob struct {
}

func (*awsRestjson1_serializeOpStopVectorEnrichmentJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopVectorEnrichmentJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopVectorEnrichmentJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/vector-enrichment-jobs/stop")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStopVectorEnrichmentJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopVectorEnrichmentJobInput(v *StopVectorEnrichmentJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStopVectorEnrichmentJobInput(v *StopVectorEnrichmentJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAreaOfInterest(v types.AreaOfInterest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.AreaOfInterestMemberAreaOfInterestGeometry:
		av := object.Key("AreaOfInterestGeometry")
		if err := awsRestjson1_serializeDocumentAreaOfInterestGeometry(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentAreaOfInterestGeometry(v types.AreaOfInterestGeometry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.AreaOfInterestGeometryMemberMultiPolygonGeometry:
		av := object.Key("MultiPolygonGeometry")
		if err := awsRestjson1_serializeDocumentMultiPolygonGeometryInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.AreaOfInterestGeometryMemberPolygonGeometry:
		av := object.Key("PolygonGeometry")
		if err := awsRestjson1_serializeDocumentPolygonGeometryInput(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentBandMathConfigInput(v *types.BandMathConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomIndices != nil {
		ok := object.Key("CustomIndices")
		if err := awsRestjson1_serializeDocumentCustomIndicesInput(v.CustomIndices, ok); err != nil {
			return err
		}
	}

	if v.PredefinedIndices != nil {
		ok := object.Key("PredefinedIndices")
		if err := awsRestjson1_serializeDocumentStringListInput(v.PredefinedIndices, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudMaskingConfigInput(v *types.CloudMaskingConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentCloudRemovalConfigInput(v *types.CloudRemovalConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AlgorithmName) > 0 {
		ok := object.Key("AlgorithmName")
		ok.String(string(v.AlgorithmName))
	}

	if v.InterpolationValue != nil {
		ok := object.Key("InterpolationValue")
		ok.String(*v.InterpolationValue)
	}

	if v.TargetBands != nil {
		ok := object.Key("TargetBands")
		if err := awsRestjson1_serializeDocumentStringListInput(v.TargetBands, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomIndicesInput(v *types.CustomIndicesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Operations != nil {
		ok := object.Key("Operations")
		if err := awsRestjson1_serializeDocumentOperationsListInput(v.Operations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEoCloudCoverInput(v *types.EoCloudCoverInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LowerBound != nil {
		ok := object.Key("LowerBound")
		switch {
		case math.IsNaN(float64(*v.LowerBound)):
			ok.String("NaN")

		case math.IsInf(float64(*v.LowerBound), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.LowerBound), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.LowerBound)

		}
	}

	if v.UpperBound != nil {
		ok := object.Key("UpperBound")
		switch {
		case math.IsNaN(float64(*v.UpperBound)):
			ok.String("NaN")

		case math.IsInf(float64(*v.UpperBound), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.UpperBound), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.UpperBound)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentExportS3DataInput(v *types.ExportS3DataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.S3Uri != nil {
		ok := object.Key("S3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentExportVectorEnrichmentJobOutputConfig(v *types.ExportVectorEnrichmentJobOutputConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Data != nil {
		ok := object.Key("S3Data")
		if err := awsRestjson1_serializeDocumentVectorEnrichmentJobS3Data(v.S3Data, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGeoMosaicConfigInput(v *types.GeoMosaicConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AlgorithmName) > 0 {
		ok := object.Key("AlgorithmName")
		ok.String(string(v.AlgorithmName))
	}

	if v.TargetBands != nil {
		ok := object.Key("TargetBands")
		if err := awsRestjson1_serializeDocumentStringListInput(v.TargetBands, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputConfigInput(v *types.InputConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PreviousEarthObservationJobArn != nil {
		ok := object.Key("PreviousEarthObservationJobArn")
		ok.String(*v.PreviousEarthObservationJobArn)
	}

	if v.RasterDataCollectionQuery != nil {
		ok := object.Key("RasterDataCollectionQuery")
		if err := awsRestjson1_serializeDocumentRasterDataCollectionQueryInput(v.RasterDataCollectionQuery, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentJobConfigInput(v types.JobConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.JobConfigInputMemberBandMathConfig:
		av := object.Key("BandMathConfig")
		if err := awsRestjson1_serializeDocumentBandMathConfigInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobConfigInputMemberCloudMaskingConfig:
		av := object.Key("CloudMaskingConfig")
		if err := awsRestjson1_serializeDocumentCloudMaskingConfigInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobConfigInputMemberCloudRemovalConfig:
		av := object.Key("CloudRemovalConfig")
		if err := awsRestjson1_serializeDocumentCloudRemovalConfigInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobConfigInputMemberGeoMosaicConfig:
		av := object.Key("GeoMosaicConfig")
		if err := awsRestjson1_serializeDocumentGeoMosaicConfigInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobConfigInputMemberLandCoverSegmentationConfig:
		av := object.Key("LandCoverSegmentationConfig")
		if err := awsRestjson1_serializeDocumentLandCoverSegmentationConfigInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobConfigInputMemberResamplingConfig:
		av := object.Key("ResamplingConfig")
		if err := awsRestjson1_serializeDocumentResamplingConfigInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobConfigInputMemberStackConfig:
		av := object.Key("StackConfig")
		if err := awsRestjson1_serializeDocumentStackConfigInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobConfigInputMemberTemporalStatisticsConfig:
		av := object.Key("TemporalStatisticsConfig")
		if err := awsRestjson1_serializeDocumentTemporalStatisticsConfigInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.JobConfigInputMemberZonalStatisticsConfig:
		av := object.Key("ZonalStatisticsConfig")
		if err := awsRestjson1_serializeDocumentZonalStatisticsConfigInput(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentLandCoverSegmentationConfigInput(v *types.LandCoverSegmentationConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsRestjson1_serializeDocumentLandsatCloudCoverLandInput(v *types.LandsatCloudCoverLandInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LowerBound != nil {
		ok := object.Key("LowerBound")
		switch {
		case math.IsNaN(float64(*v.LowerBound)):
			ok.String("NaN")

		case math.IsInf(float64(*v.LowerBound), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.LowerBound), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.LowerBound)

		}
	}

	if v.UpperBound != nil {
		ok := object.Key("UpperBound")
		switch {
		case math.IsNaN(float64(*v.UpperBound)):
			ok.String("NaN")

		case math.IsInf(float64(*v.UpperBound), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.UpperBound), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.UpperBound)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLinearRing(v [][]float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentPosition(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLinearRings(v [][][]float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentLinearRing(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentLinearRingsList(v [][][][]float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentLinearRings(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMapMatchingConfig(v *types.MapMatchingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdAttributeName != nil {
		ok := object.Key("IdAttributeName")
		ok.String(*v.IdAttributeName)
	}

	if v.TimestampAttributeName != nil {
		ok := object.Key("TimestampAttributeName")
		ok.String(*v.TimestampAttributeName)
	}

	if v.XAttributeName != nil {
		ok := object.Key("XAttributeName")
		ok.String(*v.XAttributeName)
	}

	if v.YAttributeName != nil {
		ok := object.Key("YAttributeName")
		ok.String(*v.YAttributeName)
	}

	return nil
}

func awsRestjson1_serializeDocumentMultiPolygonGeometryInput(v *types.MultiPolygonGeometryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Coordinates != nil {
		ok := object.Key("Coordinates")
		if err := awsRestjson1_serializeDocumentLinearRingsList(v.Coordinates, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOperation(v *types.Operation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Equation != nil {
		ok := object.Key("Equation")
		ok.String(*v.Equation)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.OutputType) > 0 {
		ok := object.Key("OutputType")
		ok.String(string(v.OutputType))
	}

	return nil
}

func awsRestjson1_serializeDocumentOperationsListInput(v []types.Operation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentOperation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentOutputConfigInput(v *types.OutputConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Data != nil {
		ok := object.Key("S3Data")
		if err := awsRestjson1_serializeDocumentExportS3DataInput(v.S3Data, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputResolutionResamplingInput(v *types.OutputResolutionResamplingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserDefined != nil {
		ok := object.Key("UserDefined")
		if err := awsRestjson1_serializeDocumentUserDefined(v.UserDefined, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputResolutionStackInput(v *types.OutputResolutionStackInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Predefined) > 0 {
		ok := object.Key("Predefined")
		ok.String(string(v.Predefined))
	}

	if v.UserDefined != nil {
		ok := object.Key("UserDefined")
		if err := awsRestjson1_serializeDocumentUserDefined(v.UserDefined, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPlatformInput(v *types.PlatformInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ComparisonOperator) > 0 {
		ok := object.Key("ComparisonOperator")
		ok.String(string(v.ComparisonOperator))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentPolygonGeometryInput(v *types.PolygonGeometryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Coordinates != nil {
		ok := object.Key("Coordinates")
		if err := awsRestjson1_serializeDocumentLinearRings(v.Coordinates, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPosition(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocumentProperty(v types.Property, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PropertyMemberEoCloudCover:
		av := object.Key("EoCloudCover")
		if err := awsRestjson1_serializeDocumentEoCloudCoverInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.PropertyMemberLandsatCloudCoverLand:
		av := object.Key("LandsatCloudCoverLand")
		if err := awsRestjson1_serializeDocumentLandsatCloudCoverLandInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.PropertyMemberPlatform:
		av := object.Key("Platform")
		if err := awsRestjson1_serializeDocumentPlatformInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.PropertyMemberViewOffNadir:
		av := object.Key("ViewOffNadir")
		if err := awsRestjson1_serializeDocumentViewOffNadirInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.PropertyMemberViewSunAzimuth:
		av := object.Key("ViewSunAzimuth")
		if err := awsRestjson1_serializeDocumentViewSunAzimuthInput(&uv.Value, av); err != nil {
			return err
		}

	case *types.PropertyMemberViewSunElevation:
		av := object.Key("ViewSunElevation")
		if err := awsRestjson1_serializeDocumentViewSunElevationInput(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentPropertyFilter(v *types.PropertyFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Property != nil {
		ok := object.Key("Property")
		if err := awsRestjson1_serializeDocumentProperty(v.Property, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPropertyFilters(v *types.PropertyFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.LogicalOperator) > 0 {
		ok := object.Key("LogicalOperator")
		ok.String(string(v.LogicalOperator))
	}

	if v.Properties != nil {
		ok := object.Key("Properties")
		if err := awsRestjson1_serializeDocumentPropertyFiltersList(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPropertyFiltersList(v []types.PropertyFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPropertyFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRasterDataCollectionQueryInput(v *types.RasterDataCollectionQueryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AreaOfInterest != nil {
		ok := object.Key("AreaOfInterest")
		if err := awsRestjson1_serializeDocumentAreaOfInterest(v.AreaOfInterest, ok); err != nil {
			return err
		}
	}

	if v.PropertyFilters != nil {
		ok := object.Key("PropertyFilters")
		if err := awsRestjson1_serializeDocumentPropertyFilters(v.PropertyFilters, ok); err != nil {
			return err
		}
	}

	if v.RasterDataCollectionArn != nil {
		ok := object.Key("RasterDataCollectionArn")
		ok.String(*v.RasterDataCollectionArn)
	}

	if v.TimeRangeFilter != nil {
		ok := object.Key("TimeRangeFilter")
		if err := awsRestjson1_serializeDocumentTimeRangeFilterInput(v.TimeRangeFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRasterDataCollectionQueryWithBandFilterInput(v *types.RasterDataCollectionQueryWithBandFilterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AreaOfInterest != nil {
		ok := object.Key("AreaOfInterest")
		if err := awsRestjson1_serializeDocumentAreaOfInterest(v.AreaOfInterest, ok); err != nil {
			return err
		}
	}

	if v.BandFilter != nil {
		ok := object.Key("BandFilter")
		if err := awsRestjson1_serializeDocumentStringListInput(v.BandFilter, ok); err != nil {
			return err
		}
	}

	if v.PropertyFilters != nil {
		ok := object.Key("PropertyFilters")
		if err := awsRestjson1_serializeDocumentPropertyFilters(v.PropertyFilters, ok); err != nil {
			return err
		}
	}

	if v.TimeRangeFilter != nil {
		ok := object.Key("TimeRangeFilter")
		if err := awsRestjson1_serializeDocumentTimeRangeFilterInput(v.TimeRangeFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResamplingConfigInput(v *types.ResamplingConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AlgorithmName) > 0 {
		ok := object.Key("AlgorithmName")
		ok.String(string(v.AlgorithmName))
	}

	if v.OutputResolution != nil {
		ok := object.Key("OutputResolution")
		if err := awsRestjson1_serializeDocumentOutputResolutionResamplingInput(v.OutputResolution, ok); err != nil {
			return err
		}
	}

	if v.TargetBands != nil {
		ok := object.Key("TargetBands")
		if err := awsRestjson1_serializeDocumentStringListInput(v.TargetBands, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentReverseGeocodingConfig(v *types.ReverseGeocodingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.XAttributeName != nil {
		ok := object.Key("XAttributeName")
		ok.String(*v.XAttributeName)
	}

	if v.YAttributeName != nil {
		ok := object.Key("YAttributeName")
		ok.String(*v.YAttributeName)
	}

	return nil
}

func awsRestjson1_serializeDocumentStackConfigInput(v *types.StackConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OutputResolution != nil {
		ok := object.Key("OutputResolution")
		if err := awsRestjson1_serializeDocumentOutputResolutionStackInput(v.OutputResolution, ok); err != nil {
			return err
		}
	}

	if v.TargetBands != nil {
		ok := object.Key("TargetBands")
		if err := awsRestjson1_serializeDocumentStringListInput(v.TargetBands, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStringListInput(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTags(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTemporalStatisticsConfigInput(v *types.TemporalStatisticsConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.GroupBy) > 0 {
		ok := object.Key("GroupBy")
		ok.String(string(v.GroupBy))
	}

	if v.Statistics != nil {
		ok := object.Key("Statistics")
		if err := awsRestjson1_serializeDocumentTemporalStatisticsListInput(v.Statistics, ok); err != nil {
			return err
		}
	}

	if v.TargetBands != nil {
		ok := object.Key("TargetBands")
		if err := awsRestjson1_serializeDocumentStringListInput(v.TargetBands, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTemporalStatisticsListInput(v []types.TemporalStatistics, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentTimeRangeFilterInput(v *types.TimeRangeFilterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentUserDefined(v *types.UserDefined, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("Unit")
		ok.String(string(v.Unit))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		switch {
		case math.IsNaN(float64(*v.Value)):
			ok.String("NaN")

		case math.IsInf(float64(*v.Value), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.Value), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVectorEnrichmentJobConfig(v types.VectorEnrichmentJobConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.VectorEnrichmentJobConfigMemberMapMatchingConfig:
		av := object.Key("MapMatchingConfig")
		if err := awsRestjson1_serializeDocumentMapMatchingConfig(&uv.Value, av); err != nil {
			return err
		}

	case *types.VectorEnrichmentJobConfigMemberReverseGeocodingConfig:
		av := object.Key("ReverseGeocodingConfig")
		if err := awsRestjson1_serializeDocumentReverseGeocodingConfig(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentVectorEnrichmentJobDataSourceConfigInput(v types.VectorEnrichmentJobDataSourceConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.VectorEnrichmentJobDataSourceConfigInputMemberS3Data:
		av := object.Key("S3Data")
		if err := awsRestjson1_serializeDocumentVectorEnrichmentJobS3Data(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentVectorEnrichmentJobInputConfig(v *types.VectorEnrichmentJobInputConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceConfig != nil {
		ok := object.Key("DataSourceConfig")
		if err := awsRestjson1_serializeDocumentVectorEnrichmentJobDataSourceConfigInput(v.DataSourceConfig, ok); err != nil {
			return err
		}
	}

	if len(v.DocumentType) > 0 {
		ok := object.Key("DocumentType")
		ok.String(string(v.DocumentType))
	}

	return nil
}

func awsRestjson1_serializeDocumentVectorEnrichmentJobS3Data(v *types.VectorEnrichmentJobS3Data, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.S3Uri != nil {
		ok := object.Key("S3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentViewOffNadirInput(v *types.ViewOffNadirInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LowerBound != nil {
		ok := object.Key("LowerBound")
		switch {
		case math.IsNaN(float64(*v.LowerBound)):
			ok.String("NaN")

		case math.IsInf(float64(*v.LowerBound), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.LowerBound), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.LowerBound)

		}
	}

	if v.UpperBound != nil {
		ok := object.Key("UpperBound")
		switch {
		case math.IsNaN(float64(*v.UpperBound)):
			ok.String("NaN")

		case math.IsInf(float64(*v.UpperBound), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.UpperBound), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.UpperBound)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentViewSunAzimuthInput(v *types.ViewSunAzimuthInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LowerBound != nil {
		ok := object.Key("LowerBound")
		switch {
		case math.IsNaN(float64(*v.LowerBound)):
			ok.String("NaN")

		case math.IsInf(float64(*v.LowerBound), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.LowerBound), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.LowerBound)

		}
	}

	if v.UpperBound != nil {
		ok := object.Key("UpperBound")
		switch {
		case math.IsNaN(float64(*v.UpperBound)):
			ok.String("NaN")

		case math.IsInf(float64(*v.UpperBound), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.UpperBound), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.UpperBound)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentViewSunElevationInput(v *types.ViewSunElevationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LowerBound != nil {
		ok := object.Key("LowerBound")
		switch {
		case math.IsNaN(float64(*v.LowerBound)):
			ok.String("NaN")

		case math.IsInf(float64(*v.LowerBound), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.LowerBound), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.LowerBound)

		}
	}

	if v.UpperBound != nil {
		ok := object.Key("UpperBound")
		switch {
		case math.IsNaN(float64(*v.UpperBound)):
			ok.String("NaN")

		case math.IsInf(float64(*v.UpperBound), 1):
			ok.String("Infinity")

		case math.IsInf(float64(*v.UpperBound), -1):
			ok.String("-Infinity")

		default:
			ok.Float(*v.UpperBound)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentZonalStatisticsConfigInput(v *types.ZonalStatisticsConfigInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Statistics != nil {
		ok := object.Key("Statistics")
		if err := awsRestjson1_serializeDocumentZonalStatisticsListInput(v.Statistics, ok); err != nil {
			return err
		}
	}

	if v.TargetBands != nil {
		ok := object.Key("TargetBands")
		if err := awsRestjson1_serializeDocumentStringListInput(v.TargetBands, ok); err != nil {
			return err
		}
	}

	if v.ZoneS3Path != nil {
		ok := object.Key("ZoneS3Path")
		ok.String(*v.ZoneS3Path)
	}

	if v.ZoneS3PathKmsKeyId != nil {
		ok := object.Key("ZoneS3PathKmsKeyId")
		ok.String(*v.ZoneS3PathKmsKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentZonalStatisticsListInput(v []types.ZonalStatistics, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}
