// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An error that explains why an action did not succeed.
type ErrorReason struct {

	// Service Quotas returns the following error values:
	//
	//   - DEPENDENCY_ACCESS_DENIED_ERROR - The caller does not have the required
	//   permissions to complete the action. To resolve the error, you must have
	//   permission to access the Amazon Web Services service or quota.
	//
	//   - DEPENDENCY_THROTTLING_ERROR - The Amazon Web Services service is throttling
	//   Service Quotas.
	//
	//   - DEPENDENCY_SERVICE_ERROR - The Amazon Web Services service is not available.
	//
	//   - SERVICE_QUOTA_NOT_AVAILABLE_ERROR - There was an error in Service Quotas.
	ErrorCode ErrorCode

	// The error message.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Information about the CloudWatch metric that reflects quota usage.
type MetricInfo struct {

	// The metric dimension. This is a name/value pair that is part of the identity of
	// a metric.
	MetricDimensions map[string]string

	// The name of the metric.
	MetricName *string

	// The namespace of the metric.
	MetricNamespace *string

	// The metric statistic that we recommend you use when determining quota usage.
	MetricStatisticRecommendation *string

	noSmithyDocumentSerde
}

// A structure that describes the context for a resource-level quota. For
// resource-level quotas, such as Instances per OpenSearch Service Domain , you can
// apply the quota value at the resource-level for each OpenSearch Service Domain
// in your Amazon Web Services account. Together the attributes of this structure
// help you understand how the quota is implemented by Amazon Web Services and how
// you can manage it. For quotas such as Amazon OpenSearch Service Domains which
// can be managed at the account-level for each Amazon Web Services Region, the
// QuotaContext field is absent. See the attribute descriptions below to further
// understand how to use them.
type QuotaContextInfo struct {

	// Specifies the resource, or resources, to which the quota applies. The value for
	// this field is either an Amazon Resource Name (ARN) or *. If the value is an ARN,
	// the quota value applies to that resource. If the value is *, then the quota
	// value applies to all resources listed in the ContextScopeType field. The quota
	// value applies to all resources for which you haven’t previously applied a quota
	// value, and any new resources you create in your Amazon Web Services account.
	ContextId *string

	// Specifies the scope to which the quota value is applied. If the scope is
	// RESOURCE , the quota value is applied to each resource in the Amazon Web
	// Services account. If the scope is ACCOUNT , the quota value is applied to the
	// Amazon Web Services account.
	ContextScope QuotaContextScope

	// Specifies the resource type to which the quota can be applied.
	ContextScopeType *string

	noSmithyDocumentSerde
}

// Information about the quota period.
type QuotaPeriod struct {

	// The time unit.
	PeriodUnit PeriodUnit

	// The value associated with the reported PeriodUnit .
	PeriodValue *int32

	noSmithyDocumentSerde
}

// Information about a quota increase request.
type RequestedServiceQuotaChange struct {

	// The case ID.
	CaseId *string

	// The date and time when the quota increase request was received and the case ID
	// was created.
	Created *time.Time

	// The new, increased value for the quota.
	DesiredValue *float64

	// Indicates whether the quota is global.
	GlobalQuota bool

	// The unique identifier.
	Id *string

	// The date and time of the most recent change.
	LastUpdated *time.Time

	// The Amazon Resource Name (ARN) of the quota.
	QuotaArn *string

	// Specifies the quota identifier. To find the quota code for a specific quota,
	// use the ListServiceQuotasoperation, and look for the QuotaCode response in the output for the
	// quota you want.
	QuotaCode *string

	// The context for this service quota.
	QuotaContext *QuotaContextInfo

	// Specifies the quota name.
	QuotaName *string

	// Filters the response to return quota requests for the ACCOUNT , RESOURCE , or
	// ALL levels. ACCOUNT is the default.
	QuotaRequestedAtLevel AppliedLevelEnum

	// The IAM identity of the requester.
	Requester *string

	// Specifies the service identifier. To find the service code value for an Amazon
	// Web Services service, use the ListServicesoperation.
	ServiceCode *string

	// Specifies the service name.
	ServiceName *string

	// The state of the quota increase request.
	//
	//   - PENDING : The quota increase request is under review by Amazon Web Services.
	//
	//   - CASE_OPENED : Service Quotas opened a support case to process the quota
	//   increase request. Follow-up on the support case for more information.
	//
	//   - APPROVED : The quota increase request is approved.
	//
	//   - DENIED : The quota increase request can't be approved by Service Quotas.
	//   Contact Amazon Web Services Support for more details.
	//
	//   - NOT APPROVED : The quota increase request can't be approved by Service
	//   Quotas. Contact Amazon Web Services Support for more details.
	//
	//   - CASE_CLOSED : The support case associated with this quota increase request
	//   was closed. Check the support case correspondence for the outcome of your quota
	//   request.
	//
	//   - INVALID_REQUEST : Service Quotas couldn't process your resource-level quota
	//   increase request because the Amazon Resource Name (ARN) specified as part of the
	//   ContextId is invalid.
	Status RequestStatus

	// The unit of measurement.
	Unit *string

	noSmithyDocumentSerde
}

// Information about an Amazon Web Services service.
type ServiceInfo struct {

	// Specifies the service identifier. To find the service code value for an Amazon
	// Web Services service, use the ListServicesoperation.
	ServiceCode *string

	// Specifies the service name.
	ServiceName *string

	noSmithyDocumentSerde
}

// Information about a quota.
type ServiceQuota struct {

	// Indicates whether the quota value can be increased.
	Adjustable bool

	// The quota description.
	Description *string

	// The error code and error reason.
	ErrorReason *ErrorReason

	// Indicates whether the quota is global.
	GlobalQuota bool

	// The period of time.
	Period *QuotaPeriod

	// Filters the response to return applied quota values for the ACCOUNT , RESOURCE ,
	// or ALL levels. ACCOUNT is the default.
	QuotaAppliedAtLevel AppliedLevelEnum

	// The Amazon Resource Name (ARN) of the quota.
	QuotaArn *string

	// Specifies the quota identifier. To find the quota code for a specific quota,
	// use the ListServiceQuotasoperation, and look for the QuotaCode response in the output for the
	// quota you want.
	QuotaCode *string

	// The context for this service quota.
	QuotaContext *QuotaContextInfo

	// Specifies the quota name.
	QuotaName *string

	// Specifies the service identifier. To find the service code value for an Amazon
	// Web Services service, use the ListServicesoperation.
	ServiceCode *string

	// Specifies the service name.
	ServiceName *string

	// The unit of measurement.
	Unit *string

	// Information about the measurement.
	UsageMetric *MetricInfo

	// The quota value.
	Value *float64

	noSmithyDocumentSerde
}

// Information about a quota increase request.
type ServiceQuotaIncreaseRequestInTemplate struct {

	// The Amazon Web Services Region.
	AwsRegion *string

	// The new, increased value of the quota.
	DesiredValue *float64

	// Indicates whether the quota is global.
	GlobalQuota bool

	// Specifies the quota identifier. To find the quota code for a specific quota,
	// use the ListServiceQuotasoperation, and look for the QuotaCode response in the output for the
	// quota you want.
	QuotaCode *string

	// Specifies the quota name.
	QuotaName *string

	// Specifies the service identifier. To find the service code value for an Amazon
	// Web Services service, use the ListServicesoperation.
	ServiceCode *string

	// Specifies the service name.
	ServiceName *string

	// The unit of measurement.
	Unit *string

	noSmithyDocumentSerde
}

// A complex data type that contains a tag key and tag value.
type Tag struct {

	// A string that contains a tag key. The string length should be between 1 and 128
	// characters. Valid characters include a-z, A-Z, 0-9, space, and the special
	// characters _ - . : / = + @.
	//
	// This member is required.
	Key *string

	// A string that contains an optional tag value. The string length should be
	// between 0 and 256 characters. Valid characters include a-z, A-Z, 0-9, space, and
	// the special characters _ - . : / = + @.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
