// Code generated by smithy-go-codegen DO NOT EDIT.

package sesv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sesv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List the multi-region endpoints (global-endpoints).
//
// Only multi-region endpoints (global-endpoints) whose primary region is the
// AWS-Region where operation is executed will be listed.
func (c *Client) ListMultiRegionEndpoints(ctx context.Context, params *ListMultiRegionEndpointsInput, optFns ...func(*Options)) (*ListMultiRegionEndpointsOutput, error) {
	if params == nil {
		params = &ListMultiRegionEndpointsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMultiRegionEndpoints", params, optFns, c.addOperationListMultiRegionEndpointsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMultiRegionEndpointsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents a request to list all the multi-region endpoints (global-endpoints)
// whose primary region is the AWS-Region where operation is executed.
type ListMultiRegionEndpointsInput struct {

	// A token returned from a previous call to ListMultiRegionEndpoints to indicate
	// the position in the list of multi-region endpoints (global-endpoints).
	NextToken *string

	// The number of results to show in a single call to ListMultiRegionEndpoints . If
	// the number of results is larger than the number you specified in this parameter,
	// the response includes a NextToken element that you can use to retrieve the next
	// page of results.
	PageSize *int32

	noSmithyDocumentSerde
}

// The following elements are returned by the service.
type ListMultiRegionEndpointsOutput struct {

	// An array that contains key multi-region endpoint (global-endpoint) properties.
	MultiRegionEndpoints []types.MultiRegionEndpoint

	// A token indicating that there are additional multi-region endpoints
	// (global-endpoints) available to be listed. Pass this token to a subsequent
	// ListMultiRegionEndpoints call to retrieve the next page.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMultiRegionEndpointsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListMultiRegionEndpoints{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListMultiRegionEndpoints{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMultiRegionEndpoints"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMultiRegionEndpoints(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListMultiRegionEndpointsPaginatorOptions is the paginator options for
// ListMultiRegionEndpoints
type ListMultiRegionEndpointsPaginatorOptions struct {
	// The number of results to show in a single call to ListMultiRegionEndpoints . If
	// the number of results is larger than the number you specified in this parameter,
	// the response includes a NextToken element that you can use to retrieve the next
	// page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMultiRegionEndpointsPaginator is a paginator for ListMultiRegionEndpoints
type ListMultiRegionEndpointsPaginator struct {
	options   ListMultiRegionEndpointsPaginatorOptions
	client    ListMultiRegionEndpointsAPIClient
	params    *ListMultiRegionEndpointsInput
	nextToken *string
	firstPage bool
}

// NewListMultiRegionEndpointsPaginator returns a new
// ListMultiRegionEndpointsPaginator
func NewListMultiRegionEndpointsPaginator(client ListMultiRegionEndpointsAPIClient, params *ListMultiRegionEndpointsInput, optFns ...func(*ListMultiRegionEndpointsPaginatorOptions)) *ListMultiRegionEndpointsPaginator {
	if params == nil {
		params = &ListMultiRegionEndpointsInput{}
	}

	options := ListMultiRegionEndpointsPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMultiRegionEndpointsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMultiRegionEndpointsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMultiRegionEndpoints page.
func (p *ListMultiRegionEndpointsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMultiRegionEndpointsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListMultiRegionEndpoints(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListMultiRegionEndpointsAPIClient is a client that implements the
// ListMultiRegionEndpoints operation.
type ListMultiRegionEndpointsAPIClient interface {
	ListMultiRegionEndpoints(context.Context, *ListMultiRegionEndpointsInput, ...func(*Options)) (*ListMultiRegionEndpointsOutput, error)
}

var _ ListMultiRegionEndpointsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListMultiRegionEndpoints(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMultiRegionEndpoints",
	}
}
