require 'json'

package = JSON.parse(File.read(File.join(__dir__, '..', 'package.json')))

Pod::Spec.new do |s|
  s.name           = 'BertyBridgeExpo'
  s.version        = package['version']
  s.summary        = package['description']
  s.description    = package['description']
  s.license        = package['license']
  s.author         = package['author']
  s.homepage       = package['homepage']
  s.platforms      = {
    :ios => '15.1',
    :tvos => '15.1'
  }
  s.swift_version  = '5.4'
  s.source         = { git: 'https://github.com/berty/berty' }
  s.static_framework = true

  s.dependency 'ExpoModulesCore'
  s.dependency "OpenSSL-Universal"
  s.source_files = "**/*.{h,m,mm,swift,hpp,cpp}"
  s.libraries = 'resolv'
  s.frameworks = 'CoreBluetooth', 'MultipeerConnectivity'
  s.private_header_files = "Frameworks/**/*.h"
  s.prepare_command = 'make -C .. ios.gomobile'
  s.vendored_frameworks = "Frameworks/Bertybridge.xcframework"

  # Swift/Objective-C compatibility
  s.pod_target_xcconfig = {
    'DEFINES_MODULE' => 'YES',
    'SWIFT_COMPILATION_MODE' => 'wholemodule'
  }
end
