// SQLite Is Public Domain
// 
// All of the code and documentation in SQLite has been dedicated to the public
// domain by the authors. All code authors, and representatives of the
// companies they work for, have signed affidavits dedicating their
// contributions to the public domain and originals of those signed affidavits
// are stored in a firesafe at the main offices of Hwaci. Anyone is free to
// copy, modify, publish, use, compile, sell, or distribute the original SQLite
// code, either in source code form or as a compiled binary, for any purpose,
// commercial or non-commercial, and by any means.
// 
// The previous paragraph applies to the deliverable code and documentation in
// SQLite - those parts of the SQLite library that you actually bundle and ship
// with a larger application. Some scripts used as part of the build process
// (for example the "configure" scripts generated by autoconf) might fall under
// other open-source licenses. Nothing from these build scripts ever reaches
// the final deliverable SQLite library, however, and so the licenses
// associated with those scripts should not be a factor in assessing your
// rights to copy and use the SQLite library.
// 
// All of the deliverable code in SQLite has been written from scratch. No code
// has been taken from other projects or from the open internet. Every line of
// code can be traced back to its original author, and all of those authors
// have public domain dedications on file. So the SQLite code base is clean and
// is uncontaminated with licensed code from other projects.

// Source of this modified example program: https://sqlite.org/quickstart.html

#include <sqlite3.h>
#include <stdio.h>
#include <stdlib.h>

void errorLogCallback(void *pArg, int iErrCode, const char *zMsg){
	fprintf(stderr, "FAIL (%d) %s\n", iErrCode, zMsg);
}


static int callback(void *NotUsed, int argc, char **argv, char **azColName)
{
	int i;
	for (i = 0; i < argc; i++) {
		printf("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
	}
	return 0;
}

int main(int argc, char **argv)
{
	sqlite3 *db;
	if (sqlite3_config(SQLITE_CONFIG_LOG, errorLogCallback, NULL)) {
		fprintf(stderr, "cannot configure error log callback\n", argv[0]);
		return 1;
	}

	int rc;
	char *zErrMsg = 0;

	if (argc != 3) {
		fprintf(stderr, "Usage: %s DATABASE SQL-STATEMENT\n", argv[0]);
		return 1;
	}

	rc = sqlite3_open(argv[1], &db);
	if (rc) {
		fprintf(stderr, "Can't open database: %s\n",
			sqlite3_errmsg(db));
		sqlite3_close(db);
		return 1;
	}

	rc = sqlite3_exec(db, argv[2], callback, 0, &zErrMsg);
	if (rc != SQLITE_OK) {
		fprintf(stderr, "SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
	}
	sqlite3_close(db);
	return 0;
}
