---
title: "Gopls release v0.20.0 (forthcoming)"
---

Gopls' documentation is now available on the Go project's website at
https://go.dev/gopls. (Note: this link will not be accurate until the
completion of the release. Dueing the pre-release period, please use
https://tip.golang.org/gopls, which reflects the latest commit.)

Unlike markdown files in GitHub, these pages are crawled by Google's
web search index.

## Configuration Changes

## Navigation features

### Web-based features

### "Split package" tool

The `source.splitPackage` code action opens a web-based tool that
helps you split a package into two or more components whose
dependencies are acyclic.

To use it, name a set of components, assign each declaration to a
component, then visualize the dependencies among the components
(including whether they form a cycle).
Refresh the page each time you edit your code to see the latest
information.

<img title="Split package 'fmt'" src="../assets/splitpkg.png">

The tool makes it easy to iterate over potential decompositions
until you find one you are happy with. A future version of
the tool will automate the code transformation, but for now
you must do that step by hand.


<!--

### $feature

https://go.dev/issue#xxxxx

-->

## Editing features

## Analysis features

### `ignoredError` inlay hint

The new `ignoredError` inlay hint helps catch mistakenly discarded
errors. It inserts an `// ignore error` hint following any statement
that is a function call whose error result is implicitly ignored. For
example, this code:

```go
f.Close()
```
will appear as:
```go
f.Close() // ignore error
```

To suppress the hint, write an actual comment containing `ignore
error` following the call statement, or explictly assign the result
to a blank `_` variable. A handful of common functions such as
`fmt.Println` are excluded from the check.

Enable it using this configuration: `{"hints": {"ignoredError": true}}`.

### `unusedfunc` reports unused `type`, `var`, and `const` declarations too

<!-- golang/go#40862 -->

The
[unusedfunc](https://pkg.go.dev/golang.org/x/tools/gopls/internal/analysis/unusedfunc/)
analyzer now reports any unexported types, variables, and constants
that are unreferenced within their declaring package.
(The problem of unreferenced exported symbols can't be expressed in
the analysis framework since it depends on the entire workspace.)

## Code transformation features
