// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/chat/v1/space_notification_setting.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The notification setting types. Other types might be supported in the
// future.
type SpaceNotificationSetting_NotificationSetting int32

const (
	// Reserved.
	SpaceNotificationSetting_NOTIFICATION_SETTING_UNSPECIFIED SpaceNotificationSetting_NotificationSetting = 0
	// Notifications are triggered by @mentions, followed threads, first
	// message of new threads. All new threads are automatically followed,
	// unless manually unfollowed by the user.
	SpaceNotificationSetting_ALL SpaceNotificationSetting_NotificationSetting = 1
	// The notification is triggered by @mentions, followed threads, first
	// message of new threads. Not available for 1:1 direct messages.
	SpaceNotificationSetting_MAIN_CONVERSATIONS SpaceNotificationSetting_NotificationSetting = 2
	// The notification is triggered by @mentions, followed threads. Not
	// available for 1:1 direct messages.
	SpaceNotificationSetting_FOR_YOU SpaceNotificationSetting_NotificationSetting = 3
	// Notification is off.
	SpaceNotificationSetting_OFF SpaceNotificationSetting_NotificationSetting = 4
)

// Enum value maps for SpaceNotificationSetting_NotificationSetting.
var (
	SpaceNotificationSetting_NotificationSetting_name = map[int32]string{
		0: "NOTIFICATION_SETTING_UNSPECIFIED",
		1: "ALL",
		2: "MAIN_CONVERSATIONS",
		3: "FOR_YOU",
		4: "OFF",
	}
	SpaceNotificationSetting_NotificationSetting_value = map[string]int32{
		"NOTIFICATION_SETTING_UNSPECIFIED": 0,
		"ALL":                              1,
		"MAIN_CONVERSATIONS":               2,
		"FOR_YOU":                          3,
		"OFF":                              4,
	}
)

func (x SpaceNotificationSetting_NotificationSetting) Enum() *SpaceNotificationSetting_NotificationSetting {
	p := new(SpaceNotificationSetting_NotificationSetting)
	*p = x
	return p
}

func (x SpaceNotificationSetting_NotificationSetting) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SpaceNotificationSetting_NotificationSetting) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_space_notification_setting_proto_enumTypes[0].Descriptor()
}

func (SpaceNotificationSetting_NotificationSetting) Type() protoreflect.EnumType {
	return &file_google_chat_v1_space_notification_setting_proto_enumTypes[0]
}

func (x SpaceNotificationSetting_NotificationSetting) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SpaceNotificationSetting_NotificationSetting.Descriptor instead.
func (SpaceNotificationSetting_NotificationSetting) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_space_notification_setting_proto_rawDescGZIP(), []int{0, 0}
}

// The space notification mute setting types.
type SpaceNotificationSetting_MuteSetting int32

const (
	// Reserved.
	SpaceNotificationSetting_MUTE_SETTING_UNSPECIFIED SpaceNotificationSetting_MuteSetting = 0
	// The user will receive notifications for the space based on the
	// notification setting.
	SpaceNotificationSetting_UNMUTED SpaceNotificationSetting_MuteSetting = 1
	// The user will not receive any notifications for the space, regardless of
	// the notification setting.
	SpaceNotificationSetting_MUTED SpaceNotificationSetting_MuteSetting = 2
)

// Enum value maps for SpaceNotificationSetting_MuteSetting.
var (
	SpaceNotificationSetting_MuteSetting_name = map[int32]string{
		0: "MUTE_SETTING_UNSPECIFIED",
		1: "UNMUTED",
		2: "MUTED",
	}
	SpaceNotificationSetting_MuteSetting_value = map[string]int32{
		"MUTE_SETTING_UNSPECIFIED": 0,
		"UNMUTED":                  1,
		"MUTED":                    2,
	}
)

func (x SpaceNotificationSetting_MuteSetting) Enum() *SpaceNotificationSetting_MuteSetting {
	p := new(SpaceNotificationSetting_MuteSetting)
	*p = x
	return p
}

func (x SpaceNotificationSetting_MuteSetting) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SpaceNotificationSetting_MuteSetting) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_space_notification_setting_proto_enumTypes[1].Descriptor()
}

func (SpaceNotificationSetting_MuteSetting) Type() protoreflect.EnumType {
	return &file_google_chat_v1_space_notification_setting_proto_enumTypes[1]
}

func (x SpaceNotificationSetting_MuteSetting) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SpaceNotificationSetting_MuteSetting.Descriptor instead.
func (SpaceNotificationSetting_MuteSetting) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_space_notification_setting_proto_rawDescGZIP(), []int{0, 1}
}

// The notification setting of a user in a space.
type SpaceNotificationSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the space notification setting.
	// Format: `users/{user}/spaces/{space}/spaceNotificationSetting`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The notification setting.
	NotificationSetting *SpaceNotificationSetting_NotificationSetting `protobuf:"varint,2,opt,name=notification_setting,json=notificationSetting,proto3,enum=google.chat.v1.SpaceNotificationSetting_NotificationSetting,oneof" json:"notification_setting,omitempty"`
	// The space notification mute setting.
	MuteSetting *SpaceNotificationSetting_MuteSetting `protobuf:"varint,3,opt,name=mute_setting,json=muteSetting,proto3,enum=google.chat.v1.SpaceNotificationSetting_MuteSetting,oneof" json:"mute_setting,omitempty"`
}

func (x *SpaceNotificationSetting) Reset() {
	*x = SpaceNotificationSetting{}
	mi := &file_google_chat_v1_space_notification_setting_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpaceNotificationSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpaceNotificationSetting) ProtoMessage() {}

func (x *SpaceNotificationSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_notification_setting_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpaceNotificationSetting.ProtoReflect.Descriptor instead.
func (*SpaceNotificationSetting) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_notification_setting_proto_rawDescGZIP(), []int{0}
}

func (x *SpaceNotificationSetting) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SpaceNotificationSetting) GetNotificationSetting() SpaceNotificationSetting_NotificationSetting {
	if x != nil && x.NotificationSetting != nil {
		return *x.NotificationSetting
	}
	return SpaceNotificationSetting_NOTIFICATION_SETTING_UNSPECIFIED
}

func (x *SpaceNotificationSetting) GetMuteSetting() SpaceNotificationSetting_MuteSetting {
	if x != nil && x.MuteSetting != nil {
		return *x.MuteSetting
	}
	return SpaceNotificationSetting_MUTE_SETTING_UNSPECIFIED
}

// Request message to get space notification setting.
// Only supports getting notification setting for the calling user.
type GetSpaceNotificationSettingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: users/{user}/spaces/{space}/spaceNotificationSetting
	//
	// - `users/me/spaces/{space}/spaceNotificationSetting`, OR
	// - `users/user@example.com/spaces/{space}/spaceNotificationSetting`, OR
	// - `users/123456789/spaces/{space}/spaceNotificationSetting`.
	// Note: Only the caller's user id or email is allowed in the path.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSpaceNotificationSettingRequest) Reset() {
	*x = GetSpaceNotificationSettingRequest{}
	mi := &file_google_chat_v1_space_notification_setting_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSpaceNotificationSettingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpaceNotificationSettingRequest) ProtoMessage() {}

func (x *GetSpaceNotificationSettingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_notification_setting_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpaceNotificationSettingRequest.ProtoReflect.Descriptor instead.
func (*GetSpaceNotificationSettingRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_notification_setting_proto_rawDescGZIP(), []int{1}
}

func (x *GetSpaceNotificationSettingRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to update the space notification settings.
// Only supports updating notification setting for the calling user.
type UpdateSpaceNotificationSettingRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name for the space notification settings must be
	// populated in the form of
	// `users/{user}/spaces/{space}/spaceNotificationSetting`. Only fields
	// specified by `update_mask` are updated.
	SpaceNotificationSetting *SpaceNotificationSetting `protobuf:"bytes,1,opt,name=space_notification_setting,json=spaceNotificationSetting,proto3" json:"space_notification_setting,omitempty"`
	// Required. Supported field paths:
	//
	// - `notification_setting`
	//
	// - `mute_setting`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSpaceNotificationSettingRequest) Reset() {
	*x = UpdateSpaceNotificationSettingRequest{}
	mi := &file_google_chat_v1_space_notification_setting_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSpaceNotificationSettingRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSpaceNotificationSettingRequest) ProtoMessage() {}

func (x *UpdateSpaceNotificationSettingRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_notification_setting_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSpaceNotificationSettingRequest.ProtoReflect.Descriptor instead.
func (*UpdateSpaceNotificationSettingRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_notification_setting_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateSpaceNotificationSettingRequest) GetSpaceNotificationSetting() *SpaceNotificationSetting {
	if x != nil {
		return x.SpaceNotificationSetting
	}
	return nil
}

func (x *UpdateSpaceNotificationSettingRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

var File_google_chat_v1_space_notification_setting_proto protoreflect.FileDescriptor

var file_google_chat_v1_space_notification_setting_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xee, 0x04, 0x0a, 0x18, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x74, 0x0a, 0x14, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x48, 0x00, 0x52, 0x13, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x5c, 0x0a, 0x0c, 0x6d,
	0x75, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x4d, 0x75, 0x74, 0x65,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x48, 0x01, 0x52, 0x0b, 0x6d, 0x75, 0x74, 0x65, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x22, 0x72, 0x0a, 0x13, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x24, 0x0a, 0x20, 0x4e, 0x4f, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12,
	0x16, 0x0a, 0x12, 0x4d, 0x41, 0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4f, 0x52, 0x5f, 0x59,
	0x4f, 0x55, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x46, 0x46, 0x10, 0x04, 0x22, 0x43, 0x0a,
	0x0b, 0x4d, 0x75, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x1c, 0x0a, 0x18,
	0x4d, 0x55, 0x54, 0x45, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e,
	0x4d, 0x55, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x55, 0x54, 0x45, 0x44,
	0x10, 0x02, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x2c, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x34, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x75,
	0x73, 0x65, 0x72, 0x7d, 0x2f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x7d, 0x2f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x32, 0x18, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42,
	0x0f, 0x0a, 0x0d, 0x5f, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x22, 0x6e, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xd6, 0x01, 0x0a, 0x25, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x70, 0x61, 0x63, 0x65,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6b, 0x0a, 0x1a, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0xb6, 0x01, 0x0a, 0x12, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31,
	0x42, 0x1d, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0x3b, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0xa2,
	0x02, 0x0b, 0x44, 0x59, 0x4e, 0x41, 0x50, 0x49, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xaa, 0x02, 0x13,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x74,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70,
	0x73, 0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x73, 0x3a, 0x3a, 0x43, 0x68, 0x61, 0x74, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_chat_v1_space_notification_setting_proto_rawDescOnce sync.Once
	file_google_chat_v1_space_notification_setting_proto_rawDescData = file_google_chat_v1_space_notification_setting_proto_rawDesc
)

func file_google_chat_v1_space_notification_setting_proto_rawDescGZIP() []byte {
	file_google_chat_v1_space_notification_setting_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_space_notification_setting_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_space_notification_setting_proto_rawDescData)
	})
	return file_google_chat_v1_space_notification_setting_proto_rawDescData
}

var file_google_chat_v1_space_notification_setting_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_chat_v1_space_notification_setting_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_chat_v1_space_notification_setting_proto_goTypes = []any{
	(SpaceNotificationSetting_NotificationSetting)(0), // 0: google.chat.v1.SpaceNotificationSetting.NotificationSetting
	(SpaceNotificationSetting_MuteSetting)(0),         // 1: google.chat.v1.SpaceNotificationSetting.MuteSetting
	(*SpaceNotificationSetting)(nil),                  // 2: google.chat.v1.SpaceNotificationSetting
	(*GetSpaceNotificationSettingRequest)(nil),        // 3: google.chat.v1.GetSpaceNotificationSettingRequest
	(*UpdateSpaceNotificationSettingRequest)(nil),     // 4: google.chat.v1.UpdateSpaceNotificationSettingRequest
	(*fieldmaskpb.FieldMask)(nil),                     // 5: google.protobuf.FieldMask
}
var file_google_chat_v1_space_notification_setting_proto_depIdxs = []int32{
	0, // 0: google.chat.v1.SpaceNotificationSetting.notification_setting:type_name -> google.chat.v1.SpaceNotificationSetting.NotificationSetting
	1, // 1: google.chat.v1.SpaceNotificationSetting.mute_setting:type_name -> google.chat.v1.SpaceNotificationSetting.MuteSetting
	2, // 2: google.chat.v1.UpdateSpaceNotificationSettingRequest.space_notification_setting:type_name -> google.chat.v1.SpaceNotificationSetting
	5, // 3: google.chat.v1.UpdateSpaceNotificationSettingRequest.update_mask:type_name -> google.protobuf.FieldMask
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_chat_v1_space_notification_setting_proto_init() }
func file_google_chat_v1_space_notification_setting_proto_init() {
	if File_google_chat_v1_space_notification_setting_proto != nil {
		return
	}
	file_google_chat_v1_space_notification_setting_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_space_notification_setting_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_space_notification_setting_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_space_notification_setting_proto_depIdxs,
		EnumInfos:         file_google_chat_v1_space_notification_setting_proto_enumTypes,
		MessageInfos:      file_google_chat_v1_space_notification_setting_proto_msgTypes,
	}.Build()
	File_google_chat_v1_space_notification_setting_proto = out.File
	file_google_chat_v1_space_notification_setting_proto_rawDesc = nil
	file_google_chat_v1_space_notification_setting_proto_goTypes = nil
	file_google_chat_v1_space_notification_setting_proto_depIdxs = nil
}
