// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1beta/sample_query_set_service.proto

package discoveryenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [SampleQuerySetService.GetSampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySetService.GetSampleQuerySet]
// method.
type GetSampleQuerySetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet], such
	// as
	// `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}`.
	//
	// If the caller does not have permission to access the
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet],
	// regardless of whether or not it exists, a PERMISSION_DENIED error is
	// returned.
	//
	// If the requested
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet] does
	// not exist, a NOT_FOUND error is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSampleQuerySetRequest) Reset() {
	*x = GetSampleQuerySetRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSampleQuerySetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSampleQuerySetRequest) ProtoMessage() {}

func (x *GetSampleQuerySetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSampleQuerySetRequest.ProtoReflect.Descriptor instead.
func (*GetSampleQuerySetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetSampleQuerySetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [SampleQuerySetService.ListSampleQuerySets][google.cloud.discoveryengine.v1beta.SampleQuerySetService.ListSampleQuerySets]
// method.
type ListSampleQuerySetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent location resource name, such as
	// `projects/{project}/locations/{location}`.
	//
	// If the caller does not have permission to list
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]s under
	// this location, regardless of whether or not this location exists, a
	// `PERMISSION_DENIED` error is returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]s to
	// return. If unspecified, defaults to 100. The maximum allowed value is 1000.
	// Values above 1000 will be coerced to 1000.
	//
	// If this field is negative, an `INVALID_ARGUMENT` error is returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token
	// [ListSampleQuerySetsResponse.next_page_token][google.cloud.discoveryengine.v1beta.ListSampleQuerySetsResponse.next_page_token],
	// received from a previous
	// [SampleQuerySetService.ListSampleQuerySets][google.cloud.discoveryengine.v1beta.SampleQuerySetService.ListSampleQuerySets]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [SampleQuerySetService.ListSampleQuerySets][google.cloud.discoveryengine.v1beta.SampleQuerySetService.ListSampleQuerySets]
	// must match the call that provided the page token. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSampleQuerySetsRequest) Reset() {
	*x = ListSampleQuerySetsRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSampleQuerySetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSampleQuerySetsRequest) ProtoMessage() {}

func (x *ListSampleQuerySetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSampleQuerySetsRequest.ProtoReflect.Descriptor instead.
func (*ListSampleQuerySetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListSampleQuerySetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSampleQuerySetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSampleQuerySetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [SampleQuerySetService.ListSampleQuerySets][google.cloud.discoveryengine.v1beta.SampleQuerySetService.ListSampleQuerySets]
// method.
type ListSampleQuerySetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]s.
	SampleQuerySets []*SampleQuerySet `protobuf:"bytes,1,rep,name=sample_query_sets,json=sampleQuerySets,proto3" json:"sample_query_sets,omitempty"`
	// A token that can be sent as
	// [ListSampleQuerySetsRequest.page_token][google.cloud.discoveryengine.v1beta.ListSampleQuerySetsRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSampleQuerySetsResponse) Reset() {
	*x = ListSampleQuerySetsResponse{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSampleQuerySetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSampleQuerySetsResponse) ProtoMessage() {}

func (x *ListSampleQuerySetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSampleQuerySetsResponse.ProtoReflect.Descriptor instead.
func (*ListSampleQuerySetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListSampleQuerySetsResponse) GetSampleQuerySets() []*SampleQuerySet {
	if x != nil {
		return x.SampleQuerySets
	}
	return nil
}

func (x *ListSampleQuerySetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [SampleQuerySetService.CreateSampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySetService.CreateSampleQuerySet]
// method.
type CreateSampleQuerySetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name, such as
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet] to
	// create.
	SampleQuerySet *SampleQuerySet `protobuf:"bytes,2,opt,name=sample_query_set,json=sampleQuerySet,proto3" json:"sample_query_set,omitempty"`
	// Required. The ID to use for the
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet], which
	// will become the final component of the
	// [SampleQuerySet.name][google.cloud.discoveryengine.v1beta.SampleQuerySet.name].
	//
	// If the caller does not have permission to create the
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet],
	// regardless of whether or not it exists, a `PERMISSION_DENIED` error is
	// returned.
	//
	// This field must be unique among all
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]s with
	// the same
	// [parent][google.cloud.discoveryengine.v1beta.CreateSampleQuerySetRequest.parent].
	// Otherwise, an `ALREADY_EXISTS` error is returned.
	//
	// This field must conform to [RFC-1034](https://tools.ietf.org/html/rfc1034)
	// standard with a length limit of 63 characters. Otherwise, an
	// `INVALID_ARGUMENT` error is returned.
	SampleQuerySetId string `protobuf:"bytes,3,opt,name=sample_query_set_id,json=sampleQuerySetId,proto3" json:"sample_query_set_id,omitempty"`
}

func (x *CreateSampleQuerySetRequest) Reset() {
	*x = CreateSampleQuerySetRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSampleQuerySetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSampleQuerySetRequest) ProtoMessage() {}

func (x *CreateSampleQuerySetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSampleQuerySetRequest.ProtoReflect.Descriptor instead.
func (*CreateSampleQuerySetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateSampleQuerySetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSampleQuerySetRequest) GetSampleQuerySet() *SampleQuerySet {
	if x != nil {
		return x.SampleQuerySet
	}
	return nil
}

func (x *CreateSampleQuerySetRequest) GetSampleQuerySetId() string {
	if x != nil {
		return x.SampleQuerySetId
	}
	return ""
}

// Request message for
// [SampleQuerySetService.UpdateSampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySetService.UpdateSampleQuerySet]
// method.
type UpdateSampleQuerySetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The sample query set to update.
	//
	// If the caller does not have permission to update the
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet],
	// regardless of whether or not it exists, a `PERMISSION_DENIED` error is
	// returned.
	//
	// If the [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
	// to update does not exist a `NOT_FOUND` error is returned.
	SampleQuerySet *SampleQuerySet `protobuf:"bytes,1,opt,name=sample_query_set,json=sampleQuerySet,proto3" json:"sample_query_set,omitempty"`
	// Indicates which fields in the provided imported 'sample query set' to
	// update. If not set, will by default update all fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSampleQuerySetRequest) Reset() {
	*x = UpdateSampleQuerySetRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSampleQuerySetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSampleQuerySetRequest) ProtoMessage() {}

func (x *UpdateSampleQuerySetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSampleQuerySetRequest.ProtoReflect.Descriptor instead.
func (*UpdateSampleQuerySetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateSampleQuerySetRequest) GetSampleQuerySet() *SampleQuerySet {
	if x != nil {
		return x.SampleQuerySet
	}
	return nil
}

func (x *UpdateSampleQuerySetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [SampleQuerySetService.DeleteSampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySetService.DeleteSampleQuerySet]
// method.
type DeleteSampleQuerySetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Full resource name of
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet], such
	// as
	// `projects/{project}/locations/{location}/sampleQuerySets/{sample_query_set}`.
	//
	// If the caller does not have permission to delete the
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet],
	// regardless of whether or not it exists, a `PERMISSION_DENIED` error is
	// returned.
	//
	// If the [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
	// to delete does not exist, a `NOT_FOUND` error is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSampleQuerySetRequest) Reset() {
	*x = DeleteSampleQuerySetRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSampleQuerySetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSampleQuerySetRequest) ProtoMessage() {}

func (x *DeleteSampleQuerySetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSampleQuerySetRequest.ProtoReflect.Descriptor instead.
func (*DeleteSampleQuerySetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteSampleQuerySetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDesc = []byte{
	0x0a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73,
	0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x65, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x53, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa1,
	0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xa6, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x5f, 0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53,
	0x65, 0x74, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53,
	0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xfe, 0x01, 0x0a, 0x1b,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x62, 0x0a, 0x10, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x12, 0x32, 0x0a, 0x13, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x49, 0x64, 0x22, 0xbe, 0x01, 0x0a,
	0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x62, 0x0a, 0x10,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x68, 0x0a,
	0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2f, 0x0a, 0x2d, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x82, 0x0a, 0x0a, 0x15, 0x53, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xcf, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65,
	0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x22, 0x46, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xe2, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12,
	0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x12, 0x8e, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65,
	0x74, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x22, 0x7f, 0xda, 0x41, 0x2b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x73, 0x65, 0x74, 0x2c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x10,
	0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x74,
	0x22, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x12, 0x91, 0x02, 0x0a, 0x14, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53,
	0x65, 0x74, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x22, 0x81, 0x01, 0xda, 0x41, 0x1c, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x5c, 0x3a, 0x10, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x73, 0x65, 0x74, 0x32, 0x48, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x73, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb8, 0x01,
	0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x2a,
	0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x53, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa1, 0x02, 0x0a,
	0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x1a, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x51, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43,
	0x4f, 0x56, 0x45, 0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x23, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74,
	0x61, 0xca, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescData = file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_goTypes = []any{
	(*GetSampleQuerySetRequest)(nil),    // 0: google.cloud.discoveryengine.v1beta.GetSampleQuerySetRequest
	(*ListSampleQuerySetsRequest)(nil),  // 1: google.cloud.discoveryengine.v1beta.ListSampleQuerySetsRequest
	(*ListSampleQuerySetsResponse)(nil), // 2: google.cloud.discoveryengine.v1beta.ListSampleQuerySetsResponse
	(*CreateSampleQuerySetRequest)(nil), // 3: google.cloud.discoveryengine.v1beta.CreateSampleQuerySetRequest
	(*UpdateSampleQuerySetRequest)(nil), // 4: google.cloud.discoveryengine.v1beta.UpdateSampleQuerySetRequest
	(*DeleteSampleQuerySetRequest)(nil), // 5: google.cloud.discoveryengine.v1beta.DeleteSampleQuerySetRequest
	(*SampleQuerySet)(nil),              // 6: google.cloud.discoveryengine.v1beta.SampleQuerySet
	(*fieldmaskpb.FieldMask)(nil),       // 7: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),               // 8: google.protobuf.Empty
}
var file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_depIdxs = []int32{
	6, // 0: google.cloud.discoveryengine.v1beta.ListSampleQuerySetsResponse.sample_query_sets:type_name -> google.cloud.discoveryengine.v1beta.SampleQuerySet
	6, // 1: google.cloud.discoveryengine.v1beta.CreateSampleQuerySetRequest.sample_query_set:type_name -> google.cloud.discoveryengine.v1beta.SampleQuerySet
	6, // 2: google.cloud.discoveryengine.v1beta.UpdateSampleQuerySetRequest.sample_query_set:type_name -> google.cloud.discoveryengine.v1beta.SampleQuerySet
	7, // 3: google.cloud.discoveryengine.v1beta.UpdateSampleQuerySetRequest.update_mask:type_name -> google.protobuf.FieldMask
	0, // 4: google.cloud.discoveryengine.v1beta.SampleQuerySetService.GetSampleQuerySet:input_type -> google.cloud.discoveryengine.v1beta.GetSampleQuerySetRequest
	1, // 5: google.cloud.discoveryengine.v1beta.SampleQuerySetService.ListSampleQuerySets:input_type -> google.cloud.discoveryengine.v1beta.ListSampleQuerySetsRequest
	3, // 6: google.cloud.discoveryengine.v1beta.SampleQuerySetService.CreateSampleQuerySet:input_type -> google.cloud.discoveryengine.v1beta.CreateSampleQuerySetRequest
	4, // 7: google.cloud.discoveryengine.v1beta.SampleQuerySetService.UpdateSampleQuerySet:input_type -> google.cloud.discoveryengine.v1beta.UpdateSampleQuerySetRequest
	5, // 8: google.cloud.discoveryengine.v1beta.SampleQuerySetService.DeleteSampleQuerySet:input_type -> google.cloud.discoveryengine.v1beta.DeleteSampleQuerySetRequest
	6, // 9: google.cloud.discoveryengine.v1beta.SampleQuerySetService.GetSampleQuerySet:output_type -> google.cloud.discoveryengine.v1beta.SampleQuerySet
	2, // 10: google.cloud.discoveryengine.v1beta.SampleQuerySetService.ListSampleQuerySets:output_type -> google.cloud.discoveryengine.v1beta.ListSampleQuerySetsResponse
	6, // 11: google.cloud.discoveryengine.v1beta.SampleQuerySetService.CreateSampleQuerySet:output_type -> google.cloud.discoveryengine.v1beta.SampleQuerySet
	6, // 12: google.cloud.discoveryengine.v1beta.SampleQuerySetService.UpdateSampleQuerySet:output_type -> google.cloud.discoveryengine.v1beta.SampleQuerySet
	8, // 13: google.cloud.discoveryengine.v1beta.SampleQuerySetService.DeleteSampleQuerySet:output_type -> google.protobuf.Empty
	9, // [9:14] is the sub-list for method output_type
	4, // [4:9] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_init() }
func file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_init() {
	if File_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1beta_sample_query_set_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto = out.File
	file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1beta_sample_query_set_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SampleQuerySetServiceClient is the client API for SampleQuerySetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SampleQuerySetServiceClient interface {
	// Gets a
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
	GetSampleQuerySet(ctx context.Context, in *GetSampleQuerySetRequest, opts ...grpc.CallOption) (*SampleQuerySet, error)
	// Gets a list of
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]s.
	ListSampleQuerySets(ctx context.Context, in *ListSampleQuerySetsRequest, opts ...grpc.CallOption) (*ListSampleQuerySetsResponse, error)
	// Creates a
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
	CreateSampleQuerySet(ctx context.Context, in *CreateSampleQuerySetRequest, opts ...grpc.CallOption) (*SampleQuerySet, error)
	// Updates a
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
	UpdateSampleQuerySet(ctx context.Context, in *UpdateSampleQuerySetRequest, opts ...grpc.CallOption) (*SampleQuerySet, error)
	// Deletes a
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
	DeleteSampleQuerySet(ctx context.Context, in *DeleteSampleQuerySetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type sampleQuerySetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSampleQuerySetServiceClient(cc grpc.ClientConnInterface) SampleQuerySetServiceClient {
	return &sampleQuerySetServiceClient{cc}
}

func (c *sampleQuerySetServiceClient) GetSampleQuerySet(ctx context.Context, in *GetSampleQuerySetRequest, opts ...grpc.CallOption) (*SampleQuerySet, error) {
	out := new(SampleQuerySet)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SampleQuerySetService/GetSampleQuerySet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sampleQuerySetServiceClient) ListSampleQuerySets(ctx context.Context, in *ListSampleQuerySetsRequest, opts ...grpc.CallOption) (*ListSampleQuerySetsResponse, error) {
	out := new(ListSampleQuerySetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SampleQuerySetService/ListSampleQuerySets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sampleQuerySetServiceClient) CreateSampleQuerySet(ctx context.Context, in *CreateSampleQuerySetRequest, opts ...grpc.CallOption) (*SampleQuerySet, error) {
	out := new(SampleQuerySet)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SampleQuerySetService/CreateSampleQuerySet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sampleQuerySetServiceClient) UpdateSampleQuerySet(ctx context.Context, in *UpdateSampleQuerySetRequest, opts ...grpc.CallOption) (*SampleQuerySet, error) {
	out := new(SampleQuerySet)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SampleQuerySetService/UpdateSampleQuerySet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sampleQuerySetServiceClient) DeleteSampleQuerySet(ctx context.Context, in *DeleteSampleQuerySetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.SampleQuerySetService/DeleteSampleQuerySet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SampleQuerySetServiceServer is the server API for SampleQuerySetService service.
type SampleQuerySetServiceServer interface {
	// Gets a
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
	GetSampleQuerySet(context.Context, *GetSampleQuerySetRequest) (*SampleQuerySet, error)
	// Gets a list of
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]s.
	ListSampleQuerySets(context.Context, *ListSampleQuerySetsRequest) (*ListSampleQuerySetsResponse, error)
	// Creates a
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet]
	CreateSampleQuerySet(context.Context, *CreateSampleQuerySetRequest) (*SampleQuerySet, error)
	// Updates a
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
	UpdateSampleQuerySet(context.Context, *UpdateSampleQuerySetRequest) (*SampleQuerySet, error)
	// Deletes a
	// [SampleQuerySet][google.cloud.discoveryengine.v1beta.SampleQuerySet].
	DeleteSampleQuerySet(context.Context, *DeleteSampleQuerySetRequest) (*emptypb.Empty, error)
}

// UnimplementedSampleQuerySetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSampleQuerySetServiceServer struct {
}

func (*UnimplementedSampleQuerySetServiceServer) GetSampleQuerySet(context.Context, *GetSampleQuerySetRequest) (*SampleQuerySet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSampleQuerySet not implemented")
}
func (*UnimplementedSampleQuerySetServiceServer) ListSampleQuerySets(context.Context, *ListSampleQuerySetsRequest) (*ListSampleQuerySetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSampleQuerySets not implemented")
}
func (*UnimplementedSampleQuerySetServiceServer) CreateSampleQuerySet(context.Context, *CreateSampleQuerySetRequest) (*SampleQuerySet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSampleQuerySet not implemented")
}
func (*UnimplementedSampleQuerySetServiceServer) UpdateSampleQuerySet(context.Context, *UpdateSampleQuerySetRequest) (*SampleQuerySet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSampleQuerySet not implemented")
}
func (*UnimplementedSampleQuerySetServiceServer) DeleteSampleQuerySet(context.Context, *DeleteSampleQuerySetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSampleQuerySet not implemented")
}

func RegisterSampleQuerySetServiceServer(s *grpc.Server, srv SampleQuerySetServiceServer) {
	s.RegisterService(&_SampleQuerySetService_serviceDesc, srv)
}

func _SampleQuerySetService_GetSampleQuerySet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSampleQuerySetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SampleQuerySetServiceServer).GetSampleQuerySet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SampleQuerySetService/GetSampleQuerySet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SampleQuerySetServiceServer).GetSampleQuerySet(ctx, req.(*GetSampleQuerySetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SampleQuerySetService_ListSampleQuerySets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSampleQuerySetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SampleQuerySetServiceServer).ListSampleQuerySets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SampleQuerySetService/ListSampleQuerySets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SampleQuerySetServiceServer).ListSampleQuerySets(ctx, req.(*ListSampleQuerySetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SampleQuerySetService_CreateSampleQuerySet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSampleQuerySetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SampleQuerySetServiceServer).CreateSampleQuerySet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SampleQuerySetService/CreateSampleQuerySet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SampleQuerySetServiceServer).CreateSampleQuerySet(ctx, req.(*CreateSampleQuerySetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SampleQuerySetService_UpdateSampleQuerySet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSampleQuerySetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SampleQuerySetServiceServer).UpdateSampleQuerySet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SampleQuerySetService/UpdateSampleQuerySet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SampleQuerySetServiceServer).UpdateSampleQuerySet(ctx, req.(*UpdateSampleQuerySetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SampleQuerySetService_DeleteSampleQuerySet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSampleQuerySetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SampleQuerySetServiceServer).DeleteSampleQuerySet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.SampleQuerySetService/DeleteSampleQuerySet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SampleQuerySetServiceServer).DeleteSampleQuerySet(ctx, req.(*DeleteSampleQuerySetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SampleQuerySetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.discoveryengine.v1beta.SampleQuerySetService",
	HandlerType: (*SampleQuerySetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSampleQuerySet",
			Handler:    _SampleQuerySetService_GetSampleQuerySet_Handler,
		},
		{
			MethodName: "ListSampleQuerySets",
			Handler:    _SampleQuerySetService_ListSampleQuerySets_Handler,
		},
		{
			MethodName: "CreateSampleQuerySet",
			Handler:    _SampleQuerySetService_CreateSampleQuerySet_Handler,
		},
		{
			MethodName: "UpdateSampleQuerySet",
			Handler:    _SampleQuerySetService_UpdateSampleQuerySet_Handler,
		},
		{
			MethodName: "DeleteSampleQuerySet",
			Handler:    _SampleQuerySetService_DeleteSampleQuerySet_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/discoveryengine/v1beta/sample_query_set_service.proto",
}
