// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/financialservices/v1/engine_config.proto

package financialservicespb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The possible states of a resource.
type EngineConfig_State int32

const (
	// State is unspecified, should not occur.
	EngineConfig_STATE_UNSPECIFIED EngineConfig_State = 0
	// The resource has not finished being created.
	EngineConfig_CREATING EngineConfig_State = 1
	// The resource is active/ready to be used.
	EngineConfig_ACTIVE EngineConfig_State = 2
	// The resource is in the process of being updated.
	EngineConfig_UPDATING EngineConfig_State = 3
	// The resource is in the process of being deleted.
	EngineConfig_DELETING EngineConfig_State = 4
)

// Enum value maps for EngineConfig_State.
var (
	EngineConfig_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
	}
	EngineConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
	}
)

func (x EngineConfig_State) Enum() *EngineConfig_State {
	p := new(EngineConfig_State)
	*p = x
	return p
}

func (x EngineConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EngineConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_financialservices_v1_engine_config_proto_enumTypes[0].Descriptor()
}

func (EngineConfig_State) Type() protoreflect.EnumType {
	return &file_google_cloud_financialservices_v1_engine_config_proto_enumTypes[0]
}

func (x EngineConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EngineConfig_State.Descriptor instead.
func (EngineConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{0, 0}
}

// The type of the hyperparameter source.
type EngineConfig_HyperparameterSourceType int32

const (
	// Hyperparameter source type is unspecified, defaults to TUNING.
	EngineConfig_HYPERPARAMETER_SOURCE_TYPE_UNSPECIFIED EngineConfig_HyperparameterSourceType = 0
	// The EngineConfig creation starts a tuning job which selects the best
	// hyperparameters.
	EngineConfig_TUNING EngineConfig_HyperparameterSourceType = 1
	// The hyperparameters are inherited from another EngineConfig.
	EngineConfig_INHERITED EngineConfig_HyperparameterSourceType = 2
)

// Enum value maps for EngineConfig_HyperparameterSourceType.
var (
	EngineConfig_HyperparameterSourceType_name = map[int32]string{
		0: "HYPERPARAMETER_SOURCE_TYPE_UNSPECIFIED",
		1: "TUNING",
		2: "INHERITED",
	}
	EngineConfig_HyperparameterSourceType_value = map[string]int32{
		"HYPERPARAMETER_SOURCE_TYPE_UNSPECIFIED": 0,
		"TUNING":                                 1,
		"INHERITED":                              2,
	}
)

func (x EngineConfig_HyperparameterSourceType) Enum() *EngineConfig_HyperparameterSourceType {
	p := new(EngineConfig_HyperparameterSourceType)
	*p = x
	return p
}

func (x EngineConfig_HyperparameterSourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EngineConfig_HyperparameterSourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_financialservices_v1_engine_config_proto_enumTypes[1].Descriptor()
}

func (EngineConfig_HyperparameterSourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_financialservices_v1_engine_config_proto_enumTypes[1]
}

func (x EngineConfig_HyperparameterSourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EngineConfig_HyperparameterSourceType.Descriptor instead.
func (EngineConfig_HyperparameterSourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{0, 1}
}

// The EngineConfig resource creates the configuration for training a model.
type EngineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the EngineConfig.
	// format:
	// "/projects/{project_num}/locations/{location}/instances/{instance}/engineConfigs/{engine_config}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp of creation of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp of the most recent update of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. State of the EngineConfig (creating, active, deleting, etc.)
	State EngineConfig_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.financialservices.v1.EngineConfig_State" json:"state,omitempty"`
	// Required. The resource name of the EngineVersion used in this model tuning.
	// format:
	// "/projects/{project_num}/locations/{location}/instances/{instance}/engineVersions/{engine_version}"
	EngineVersion string `protobuf:"bytes,6,opt,name=engine_version,json=engineVersion,proto3" json:"engine_version,omitempty"`
	// Optional. Configuration for tuning in creation of the EngineConfig.
	// This field is required if `hyperparameter_source.type` is not `INHERITED`,
	// and output-only otherwise.
	Tuning *EngineConfig_Tuning `protobuf:"bytes,7,opt,name=tuning,proto3" json:"tuning,omitempty"`
	// Optional. PerformanceTarget gives information on how the tuning and
	// training will be evaluated. This field is required if
	// `hyperparameter_source.type` is not `INHERITED`, and output-only otherwise.
	PerformanceTarget *EngineConfig_PerformanceTarget `protobuf:"bytes,11,opt,name=performance_target,json=performanceTarget,proto3" json:"performance_target,omitempty"`
	// Output only. The line of business (Retail/Commercial) this engine config is
	// used for. Determined by EngineVersion, cannot be set by user.
	LineOfBusiness LineOfBusiness `protobuf:"varint,12,opt,name=line_of_business,json=lineOfBusiness,proto3,enum=google.cloud.financialservices.v1.LineOfBusiness" json:"line_of_business,omitempty"`
	// Optional. The origin of hyperparameters for the created EngineConfig. The
	// default is `TUNING`. In this case, the hyperparameters are selected as a
	// result of a
	//
	//	tuning run.
	HyperparameterSourceType EngineConfig_HyperparameterSourceType `protobuf:"varint,15,opt,name=hyperparameter_source_type,json=hyperparameterSourceType,proto3,enum=google.cloud.financialservices.v1.EngineConfig_HyperparameterSourceType" json:"hyperparameter_source_type,omitempty"`
	// Optional. Configuration of hyperparameters source EngineConfig.
	HyperparameterSource *EngineConfig_HyperparameterSource `protobuf:"bytes,16,opt,name=hyperparameter_source,json=hyperparameterSource,proto3" json:"hyperparameter_source,omitempty"`
}

func (x *EngineConfig) Reset() {
	*x = EngineConfig{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EngineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EngineConfig) ProtoMessage() {}

func (x *EngineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EngineConfig.ProtoReflect.Descriptor instead.
func (*EngineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{0}
}

func (x *EngineConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EngineConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EngineConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EngineConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EngineConfig) GetState() EngineConfig_State {
	if x != nil {
		return x.State
	}
	return EngineConfig_STATE_UNSPECIFIED
}

func (x *EngineConfig) GetEngineVersion() string {
	if x != nil {
		return x.EngineVersion
	}
	return ""
}

func (x *EngineConfig) GetTuning() *EngineConfig_Tuning {
	if x != nil {
		return x.Tuning
	}
	return nil
}

func (x *EngineConfig) GetPerformanceTarget() *EngineConfig_PerformanceTarget {
	if x != nil {
		return x.PerformanceTarget
	}
	return nil
}

func (x *EngineConfig) GetLineOfBusiness() LineOfBusiness {
	if x != nil {
		return x.LineOfBusiness
	}
	return LineOfBusiness_LINE_OF_BUSINESS_UNSPECIFIED
}

func (x *EngineConfig) GetHyperparameterSourceType() EngineConfig_HyperparameterSourceType {
	if x != nil {
		return x.HyperparameterSourceType
	}
	return EngineConfig_HYPERPARAMETER_SOURCE_TYPE_UNSPECIFIED
}

func (x *EngineConfig) GetHyperparameterSource() *EngineConfig_HyperparameterSource {
	if x != nil {
		return x.HyperparameterSource
	}
	return nil
}

// Request for retrieving a paginated list of EngineConfig resources that
// meet the specified criteria.
type ListEngineConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent of the EngineConfig is the Instance.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The number of resources to be included in the response. The response
	// contains a next_page_token, which can be used to retrieve the next page of
	// resources.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// In case of paginated results, this is the token that was returned in the
	// previous ListEngineConfigsResponse. It should be copied here to retrieve
	// the next page of resources. Empty will give the first page of
	// ListEngineConfigsRequest, and the last page will return an empty
	// page_token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Specify a filter to narrow search results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Specify a field to use for ordering.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListEngineConfigsRequest) Reset() {
	*x = ListEngineConfigsRequest{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEngineConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEngineConfigsRequest) ProtoMessage() {}

func (x *ListEngineConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEngineConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListEngineConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{1}
}

func (x *ListEngineConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEngineConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEngineConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEngineConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEngineConfigsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for retrieving a list of EngineConfigs
type ListEngineConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of EngineConfig resources
	EngineConfigs []*EngineConfig `protobuf:"bytes,1,rep,name=engine_configs,json=engineConfigs,proto3" json:"engine_configs,omitempty"`
	// This token should be passed to the next ListEngineConfigsRequest to
	// retrieve the next page of EngineConfigs (empty indicates we are done).
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListEngineConfigsResponse) Reset() {
	*x = ListEngineConfigsResponse{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEngineConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEngineConfigsResponse) ProtoMessage() {}

func (x *ListEngineConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEngineConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListEngineConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{2}
}

func (x *ListEngineConfigsResponse) GetEngineConfigs() []*EngineConfig {
	if x != nil {
		return x.EngineConfigs
	}
	return nil
}

func (x *ListEngineConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListEngineConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for retrieving a specific EngineConfig resource.
type GetEngineConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EngineConfig
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEngineConfigRequest) Reset() {
	*x = GetEngineConfigRequest{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEngineConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEngineConfigRequest) ProtoMessage() {}

func (x *GetEngineConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEngineConfigRequest.ProtoReflect.Descriptor instead.
func (*GetEngineConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{3}
}

func (x *GetEngineConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for creating an EngineConfig resource.
type CreateEngineConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent of the EngineConfig is the Instance.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource id of the EngineConfig
	EngineConfigId string `protobuf:"bytes,2,opt,name=engine_config_id,json=engineConfigId,proto3" json:"engine_config_id,omitempty"`
	// Required. The EngineConfig that will be created.
	EngineConfig *EngineConfig `protobuf:"bytes,3,opt,name=engine_config,json=engineConfig,proto3" json:"engine_config,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateEngineConfigRequest) Reset() {
	*x = CreateEngineConfigRequest{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEngineConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEngineConfigRequest) ProtoMessage() {}

func (x *CreateEngineConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEngineConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateEngineConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{4}
}

func (x *CreateEngineConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEngineConfigRequest) GetEngineConfigId() string {
	if x != nil {
		return x.EngineConfigId
	}
	return ""
}

func (x *CreateEngineConfigRequest) GetEngineConfig() *EngineConfig {
	if x != nil {
		return x.EngineConfig
	}
	return nil
}

func (x *CreateEngineConfigRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for updating an EngineConfig
type UpdateEngineConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// EngineConfig resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The new value of the EngineConfig fields that will be updated
	// according to the update_mask.
	EngineConfig *EngineConfig `protobuf:"bytes,2,opt,name=engine_config,json=engineConfig,proto3" json:"engine_config,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateEngineConfigRequest) Reset() {
	*x = UpdateEngineConfigRequest{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateEngineConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEngineConfigRequest) ProtoMessage() {}

func (x *UpdateEngineConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEngineConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateEngineConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateEngineConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateEngineConfigRequest) GetEngineConfig() *EngineConfig {
	if x != nil {
		return x.EngineConfig
	}
	return nil
}

func (x *UpdateEngineConfigRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for deleting an EngineConfig.
type DeleteEngineConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EngineConfig.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteEngineConfigRequest) Reset() {
	*x = DeleteEngineConfigRequest{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteEngineConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEngineConfigRequest) ProtoMessage() {}

func (x *DeleteEngineConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEngineConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteEngineConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteEngineConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEngineConfigRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for exporting EngineConfig metadata.
type ExportEngineConfigMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EngineConfig.
	EngineConfig string `protobuf:"bytes,1,opt,name=engine_config,json=engineConfig,proto3" json:"engine_config,omitempty"`
	// Required. BigQuery output where the metadata will be written.
	StructuredMetadataDestination *BigQueryDestination `protobuf:"bytes,2,opt,name=structured_metadata_destination,json=structuredMetadataDestination,proto3" json:"structured_metadata_destination,omitempty"`
}

func (x *ExportEngineConfigMetadataRequest) Reset() {
	*x = ExportEngineConfigMetadataRequest{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportEngineConfigMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportEngineConfigMetadataRequest) ProtoMessage() {}

func (x *ExportEngineConfigMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportEngineConfigMetadataRequest.ProtoReflect.Descriptor instead.
func (*ExportEngineConfigMetadataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{7}
}

func (x *ExportEngineConfigMetadataRequest) GetEngineConfig() string {
	if x != nil {
		return x.EngineConfig
	}
	return ""
}

func (x *ExportEngineConfigMetadataRequest) GetStructuredMetadataDestination() *BigQueryDestination {
	if x != nil {
		return x.StructuredMetadataDestination
	}
	return nil
}

// Response for exporting EngineConfig metadata.
type ExportEngineConfigMetadataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportEngineConfigMetadataResponse) Reset() {
	*x = ExportEngineConfigMetadataResponse{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportEngineConfigMetadataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportEngineConfigMetadataResponse) ProtoMessage() {}

func (x *ExportEngineConfigMetadataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportEngineConfigMetadataResponse.ProtoReflect.Descriptor instead.
func (*ExportEngineConfigMetadataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{8}
}

// The parameters needed for the tuning operation, these are used only in
// tuning and not passed on to training.
type EngineConfig_Tuning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Primary Dataset used in this model
	// tuning. For information about how primary and auxiliary datasets are
	// used, refer to the engine version's documentation.  Format:
	// "/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}"
	PrimaryDataset string `protobuf:"bytes,1,opt,name=primary_dataset,json=primaryDataset,proto3" json:"primary_dataset,omitempty"`
	// Required. End_time specifies the latest time from which labels are used
	// and from which data is used to generate features for tuning.  End_time
	// should be no later than the end of the date_range of the dataset.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *EngineConfig_Tuning) Reset() {
	*x = EngineConfig_Tuning{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EngineConfig_Tuning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EngineConfig_Tuning) ProtoMessage() {}

func (x *EngineConfig_Tuning) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EngineConfig_Tuning.ProtoReflect.Descriptor instead.
func (*EngineConfig_Tuning) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{0, 0}
}

func (x *EngineConfig_Tuning) GetPrimaryDataset() string {
	if x != nil {
		return x.PrimaryDataset
	}
	return ""
}

func (x *EngineConfig_Tuning) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// PerformanceTarget gives hints on how to evaluate the performance of a
// model.
type EngineConfig_PerformanceTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A number that gives the tuner a hint on the number of parties
	// from this data that will be investigated per period (monthly). This is
	// used to control how the model is evaluated. For example, when trying AML
	// AI for the first time, we recommend setting this to the number of parties
	// investigated in an average month, based on alerts from your existing
	// automated alerting system.
	PartyInvestigationsPerPeriodHint int64 `protobuf:"varint,1,opt,name=party_investigations_per_period_hint,json=partyInvestigationsPerPeriodHint,proto3" json:"party_investigations_per_period_hint,omitempty"`
}

func (x *EngineConfig_PerformanceTarget) Reset() {
	*x = EngineConfig_PerformanceTarget{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EngineConfig_PerformanceTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EngineConfig_PerformanceTarget) ProtoMessage() {}

func (x *EngineConfig_PerformanceTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EngineConfig_PerformanceTarget.ProtoReflect.Descriptor instead.
func (*EngineConfig_PerformanceTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{0, 1}
}

func (x *EngineConfig_PerformanceTarget) GetPartyInvestigationsPerPeriodHint() int64 {
	if x != nil {
		return x.PartyInvestigationsPerPeriodHint
	}
	return 0
}

// Parameters for bootstrapping an Engine Config with the results of another
// one.
type EngineConfig_HyperparameterSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the source EngineConfig whose outputs are
	// used. Format:
	// "/projects/{project_num}/locations/{location}/instances/{instance}/engineConfigs/{engine_config}"
	SourceEngineConfig string `protobuf:"bytes,1,opt,name=source_engine_config,json=sourceEngineConfig,proto3" json:"source_engine_config,omitempty"`
	// Output only. The resource name of the EngineVersion that was used in the
	// tuning run. Format:
	// "/projects/{project_num}/locations/{location}/instances/{instance}/engineVersions/{engine_version}"
	SourceEngineVersion string `protobuf:"bytes,2,opt,name=source_engine_version,json=sourceEngineVersion,proto3" json:"source_engine_version,omitempty"`
}

func (x *EngineConfig_HyperparameterSource) Reset() {
	*x = EngineConfig_HyperparameterSource{}
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EngineConfig_HyperparameterSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EngineConfig_HyperparameterSource) ProtoMessage() {}

func (x *EngineConfig_HyperparameterSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_engine_config_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EngineConfig_HyperparameterSource.ProtoReflect.Descriptor instead.
func (*EngineConfig_HyperparameterSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP(), []int{0, 2}
}

func (x *EngineConfig_HyperparameterSource) GetSourceEngineConfig() string {
	if x != nil {
		return x.SourceEngineConfig
	}
	return ""
}

func (x *EngineConfig_HyperparameterSource) GetSourceEngineVersion() string {
	if x != nil {
		return x.SourceEngineVersion
	}
	return ""
}

var File_google_cloud_financialservices_v1_engine_config_proto protoreflect.FileDescriptor

var file_google_cloud_financialservices_v1_engine_config_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x66, 0x5f,
	0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x8c, 0x0e, 0x0a, 0x0c, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x53, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x50, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5d, 0x0a, 0x0e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61,
	0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x06, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x75, 0x0a, 0x12, 0x70, 0x65,
	0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x6e, 0x63, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x12, 0x60, 0x0a, 0x10, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x62, 0x75, 0x73,
	0x69, 0x6e, 0x65, 0x73, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e,
	0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x6e, 0x65, 0x4f, 0x66, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x66, 0x42, 0x75, 0x73, 0x69, 0x6e,
	0x65, 0x73, 0x73, 0x12, 0x8b, 0x01, 0x0a, 0x1a, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61,
	0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x7e, 0x0a, 0x15, 0x68, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x68, 0x79, 0x70,
	0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x1a, 0x9f, 0x01, 0x0a, 0x06, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x59, 0x0a, 0x0f,
	0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x66,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x1a, 0x68, 0x0a, 0x11, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e,
	0x63, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x53, 0x0a, 0x24, 0x70, 0x61, 0x72, 0x74,
	0x79, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x73, 0x74, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x68, 0x69, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x20, 0x70, 0x61, 0x72,
	0x74, 0x79, 0x49, 0x6e, 0x76, 0x65, 0x73, 0x74, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x50, 0x65, 0x72, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x48, 0x69, 0x6e, 0x74, 0x1a, 0x86, 0x01,
	0x0a, 0x14, 0x48, 0x79, 0x70, 0x65, 0x72, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x0a,
	0x15, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x13, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x22, 0x61, 0x0a, 0x18, 0x48, 0x79, 0x70, 0x65, 0x72,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x26, 0x48, 0x59, 0x50, 0x45, 0x52, 0x50, 0x41, 0x52, 0x41,
	0x4d, 0x45, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x54, 0x55, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x49,
	0x4e, 0x48, 0x45, 0x52, 0x49, 0x54, 0x45, 0x44, 0x10, 0x02, 0x3a, 0x93, 0x01, 0xea, 0x41, 0x8f,
	0x01, 0x0a, 0x2d, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x5e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x7b, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d,
	0x22, 0xd4, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xbd, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x0e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e,
	0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x63, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69,
	0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x94, 0x02, 0x0a,
	0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x49, 0x64, 0x12, 0x59, 0x0a, 0x0d, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e,
	0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xdc, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x59, 0x0a, 0x0d, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63,
	0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x8a, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61,
	0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x85, 0x02, 0x0a, 0x21, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a, 0x0d, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0c, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x83, 0x01, 0x0a, 0x1f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e,
	0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1d, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x24, 0x0a, 0x22, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x91, 0x01,
	0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63,
	0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x66, 0x69,
	0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70,
	0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_financialservices_v1_engine_config_proto_rawDescOnce sync.Once
	file_google_cloud_financialservices_v1_engine_config_proto_rawDescData = file_google_cloud_financialservices_v1_engine_config_proto_rawDesc
)

func file_google_cloud_financialservices_v1_engine_config_proto_rawDescGZIP() []byte {
	file_google_cloud_financialservices_v1_engine_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_financialservices_v1_engine_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_financialservices_v1_engine_config_proto_rawDescData)
	})
	return file_google_cloud_financialservices_v1_engine_config_proto_rawDescData
}

var file_google_cloud_financialservices_v1_engine_config_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_financialservices_v1_engine_config_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_financialservices_v1_engine_config_proto_goTypes = []any{
	(EngineConfig_State)(0),                    // 0: google.cloud.financialservices.v1.EngineConfig.State
	(EngineConfig_HyperparameterSourceType)(0), // 1: google.cloud.financialservices.v1.EngineConfig.HyperparameterSourceType
	(*EngineConfig)(nil),                       // 2: google.cloud.financialservices.v1.EngineConfig
	(*ListEngineConfigsRequest)(nil),           // 3: google.cloud.financialservices.v1.ListEngineConfigsRequest
	(*ListEngineConfigsResponse)(nil),          // 4: google.cloud.financialservices.v1.ListEngineConfigsResponse
	(*GetEngineConfigRequest)(nil),             // 5: google.cloud.financialservices.v1.GetEngineConfigRequest
	(*CreateEngineConfigRequest)(nil),          // 6: google.cloud.financialservices.v1.CreateEngineConfigRequest
	(*UpdateEngineConfigRequest)(nil),          // 7: google.cloud.financialservices.v1.UpdateEngineConfigRequest
	(*DeleteEngineConfigRequest)(nil),          // 8: google.cloud.financialservices.v1.DeleteEngineConfigRequest
	(*ExportEngineConfigMetadataRequest)(nil),  // 9: google.cloud.financialservices.v1.ExportEngineConfigMetadataRequest
	(*ExportEngineConfigMetadataResponse)(nil), // 10: google.cloud.financialservices.v1.ExportEngineConfigMetadataResponse
	(*EngineConfig_Tuning)(nil),                // 11: google.cloud.financialservices.v1.EngineConfig.Tuning
	(*EngineConfig_PerformanceTarget)(nil),     // 12: google.cloud.financialservices.v1.EngineConfig.PerformanceTarget
	(*EngineConfig_HyperparameterSource)(nil),  // 13: google.cloud.financialservices.v1.EngineConfig.HyperparameterSource
	nil,                           // 14: google.cloud.financialservices.v1.EngineConfig.LabelsEntry
	(*timestamppb.Timestamp)(nil), // 15: google.protobuf.Timestamp
	(LineOfBusiness)(0),           // 16: google.cloud.financialservices.v1.LineOfBusiness
	(*fieldmaskpb.FieldMask)(nil), // 17: google.protobuf.FieldMask
	(*BigQueryDestination)(nil),   // 18: google.cloud.financialservices.v1.BigQueryDestination
}
var file_google_cloud_financialservices_v1_engine_config_proto_depIdxs = []int32{
	15, // 0: google.cloud.financialservices.v1.EngineConfig.create_time:type_name -> google.protobuf.Timestamp
	15, // 1: google.cloud.financialservices.v1.EngineConfig.update_time:type_name -> google.protobuf.Timestamp
	14, // 2: google.cloud.financialservices.v1.EngineConfig.labels:type_name -> google.cloud.financialservices.v1.EngineConfig.LabelsEntry
	0,  // 3: google.cloud.financialservices.v1.EngineConfig.state:type_name -> google.cloud.financialservices.v1.EngineConfig.State
	11, // 4: google.cloud.financialservices.v1.EngineConfig.tuning:type_name -> google.cloud.financialservices.v1.EngineConfig.Tuning
	12, // 5: google.cloud.financialservices.v1.EngineConfig.performance_target:type_name -> google.cloud.financialservices.v1.EngineConfig.PerformanceTarget
	16, // 6: google.cloud.financialservices.v1.EngineConfig.line_of_business:type_name -> google.cloud.financialservices.v1.LineOfBusiness
	1,  // 7: google.cloud.financialservices.v1.EngineConfig.hyperparameter_source_type:type_name -> google.cloud.financialservices.v1.EngineConfig.HyperparameterSourceType
	13, // 8: google.cloud.financialservices.v1.EngineConfig.hyperparameter_source:type_name -> google.cloud.financialservices.v1.EngineConfig.HyperparameterSource
	2,  // 9: google.cloud.financialservices.v1.ListEngineConfigsResponse.engine_configs:type_name -> google.cloud.financialservices.v1.EngineConfig
	2,  // 10: google.cloud.financialservices.v1.CreateEngineConfigRequest.engine_config:type_name -> google.cloud.financialservices.v1.EngineConfig
	17, // 11: google.cloud.financialservices.v1.UpdateEngineConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 12: google.cloud.financialservices.v1.UpdateEngineConfigRequest.engine_config:type_name -> google.cloud.financialservices.v1.EngineConfig
	18, // 13: google.cloud.financialservices.v1.ExportEngineConfigMetadataRequest.structured_metadata_destination:type_name -> google.cloud.financialservices.v1.BigQueryDestination
	15, // 14: google.cloud.financialservices.v1.EngineConfig.Tuning.end_time:type_name -> google.protobuf.Timestamp
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_financialservices_v1_engine_config_proto_init() }
func file_google_cloud_financialservices_v1_engine_config_proto_init() {
	if File_google_cloud_financialservices_v1_engine_config_proto != nil {
		return
	}
	file_google_cloud_financialservices_v1_bigquery_destination_proto_init()
	file_google_cloud_financialservices_v1_line_of_business_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_financialservices_v1_engine_config_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_financialservices_v1_engine_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_financialservices_v1_engine_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_financialservices_v1_engine_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_financialservices_v1_engine_config_proto_msgTypes,
	}.Build()
	File_google_cloud_financialservices_v1_engine_config_proto = out.File
	file_google_cloud_financialservices_v1_engine_config_proto_rawDesc = nil
	file_google_cloud_financialservices_v1_engine_config_proto_goTypes = nil
	file_google_cloud_financialservices_v1_engine_config_proto_depIdxs = nil
}
