// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/redis/cluster/v1/cloud_redis_cluster.proto

package clusterpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/anypb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Status of the PSC connection.
type PscConnectionStatus int32

const (
	// PSC connection status is not specified.
	PscConnectionStatus_PSC_CONNECTION_STATUS_UNSPECIFIED PscConnectionStatus = 0
	// The connection is active
	PscConnectionStatus_PSC_CONNECTION_STATUS_ACTIVE PscConnectionStatus = 1
	// Connection not found
	PscConnectionStatus_PSC_CONNECTION_STATUS_NOT_FOUND PscConnectionStatus = 2
)

// Enum value maps for PscConnectionStatus.
var (
	PscConnectionStatus_name = map[int32]string{
		0: "PSC_CONNECTION_STATUS_UNSPECIFIED",
		1: "PSC_CONNECTION_STATUS_ACTIVE",
		2: "PSC_CONNECTION_STATUS_NOT_FOUND",
	}
	PscConnectionStatus_value = map[string]int32{
		"PSC_CONNECTION_STATUS_UNSPECIFIED": 0,
		"PSC_CONNECTION_STATUS_ACTIVE":      1,
		"PSC_CONNECTION_STATUS_NOT_FOUND":   2,
	}
)

func (x PscConnectionStatus) Enum() *PscConnectionStatus {
	p := new(PscConnectionStatus)
	*p = x
	return p
}

func (x PscConnectionStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PscConnectionStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[0].Descriptor()
}

func (PscConnectionStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[0]
}

func (x PscConnectionStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PscConnectionStatus.Descriptor instead.
func (PscConnectionStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{0}
}

// Available authorization mode of a Redis cluster.
type AuthorizationMode int32

const (
	// Not set.
	AuthorizationMode_AUTH_MODE_UNSPECIFIED AuthorizationMode = 0
	// IAM basic authorization mode
	AuthorizationMode_AUTH_MODE_IAM_AUTH AuthorizationMode = 1
	// Authorization disabled mode
	AuthorizationMode_AUTH_MODE_DISABLED AuthorizationMode = 2
)

// Enum value maps for AuthorizationMode.
var (
	AuthorizationMode_name = map[int32]string{
		0: "AUTH_MODE_UNSPECIFIED",
		1: "AUTH_MODE_IAM_AUTH",
		2: "AUTH_MODE_DISABLED",
	}
	AuthorizationMode_value = map[string]int32{
		"AUTH_MODE_UNSPECIFIED": 0,
		"AUTH_MODE_IAM_AUTH":    1,
		"AUTH_MODE_DISABLED":    2,
	}
)

func (x AuthorizationMode) Enum() *AuthorizationMode {
	p := new(AuthorizationMode)
	*p = x
	return p
}

func (x AuthorizationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthorizationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[1].Descriptor()
}

func (AuthorizationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[1]
}

func (x AuthorizationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuthorizationMode.Descriptor instead.
func (AuthorizationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{1}
}

// NodeType of a redis cluster node,
type NodeType int32

const (
	// Node type unspecified
	NodeType_NODE_TYPE_UNSPECIFIED NodeType = 0
	// Redis shared core nano node_type.
	NodeType_REDIS_SHARED_CORE_NANO NodeType = 1
	// Redis highmem medium node_type.
	NodeType_REDIS_HIGHMEM_MEDIUM NodeType = 2
	// Redis highmem xlarge node_type.
	NodeType_REDIS_HIGHMEM_XLARGE NodeType = 3
	// Redis standard small node_type.
	NodeType_REDIS_STANDARD_SMALL NodeType = 4
)

// Enum value maps for NodeType.
var (
	NodeType_name = map[int32]string{
		0: "NODE_TYPE_UNSPECIFIED",
		1: "REDIS_SHARED_CORE_NANO",
		2: "REDIS_HIGHMEM_MEDIUM",
		3: "REDIS_HIGHMEM_XLARGE",
		4: "REDIS_STANDARD_SMALL",
	}
	NodeType_value = map[string]int32{
		"NODE_TYPE_UNSPECIFIED":  0,
		"REDIS_SHARED_CORE_NANO": 1,
		"REDIS_HIGHMEM_MEDIUM":   2,
		"REDIS_HIGHMEM_XLARGE":   3,
		"REDIS_STANDARD_SMALL":   4,
	}
)

func (x NodeType) Enum() *NodeType {
	p := new(NodeType)
	*p = x
	return p
}

func (x NodeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[2].Descriptor()
}

func (NodeType) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[2]
}

func (x NodeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeType.Descriptor instead.
func (NodeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{2}
}

// Available mode of in-transit encryption.
type TransitEncryptionMode int32

const (
	// In-transit encryption not set.
	TransitEncryptionMode_TRANSIT_ENCRYPTION_MODE_UNSPECIFIED TransitEncryptionMode = 0
	// In-transit encryption disabled.
	TransitEncryptionMode_TRANSIT_ENCRYPTION_MODE_DISABLED TransitEncryptionMode = 1
	// Use server managed encryption for in-transit encryption.
	TransitEncryptionMode_TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION TransitEncryptionMode = 2
)

// Enum value maps for TransitEncryptionMode.
var (
	TransitEncryptionMode_name = map[int32]string{
		0: "TRANSIT_ENCRYPTION_MODE_UNSPECIFIED",
		1: "TRANSIT_ENCRYPTION_MODE_DISABLED",
		2: "TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION",
	}
	TransitEncryptionMode_value = map[string]int32{
		"TRANSIT_ENCRYPTION_MODE_UNSPECIFIED":           0,
		"TRANSIT_ENCRYPTION_MODE_DISABLED":              1,
		"TRANSIT_ENCRYPTION_MODE_SERVER_AUTHENTICATION": 2,
	}
)

func (x TransitEncryptionMode) Enum() *TransitEncryptionMode {
	p := new(TransitEncryptionMode)
	*p = x
	return p
}

func (x TransitEncryptionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransitEncryptionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[3].Descriptor()
}

func (TransitEncryptionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[3]
}

func (x TransitEncryptionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransitEncryptionMode.Descriptor instead.
func (TransitEncryptionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{3}
}

// Type of a PSC connection, for cluster access purpose.
type ConnectionType int32

const (
	// Cluster endpoint Type is not set
	ConnectionType_CONNECTION_TYPE_UNSPECIFIED ConnectionType = 0
	// Cluster endpoint that will be used as for cluster topology discovery.
	ConnectionType_CONNECTION_TYPE_DISCOVERY ConnectionType = 1
	// Cluster endpoint that will be used as primary endpoint to access primary.
	ConnectionType_CONNECTION_TYPE_PRIMARY ConnectionType = 2
	// Cluster endpoint that will be used as reader endpoint to access replicas.
	ConnectionType_CONNECTION_TYPE_READER ConnectionType = 3
)

// Enum value maps for ConnectionType.
var (
	ConnectionType_name = map[int32]string{
		0: "CONNECTION_TYPE_UNSPECIFIED",
		1: "CONNECTION_TYPE_DISCOVERY",
		2: "CONNECTION_TYPE_PRIMARY",
		3: "CONNECTION_TYPE_READER",
	}
	ConnectionType_value = map[string]int32{
		"CONNECTION_TYPE_UNSPECIFIED": 0,
		"CONNECTION_TYPE_DISCOVERY":   1,
		"CONNECTION_TYPE_PRIMARY":     2,
		"CONNECTION_TYPE_READER":      3,
	}
)

func (x ConnectionType) Enum() *ConnectionType {
	p := new(ConnectionType)
	*p = x
	return p
}

func (x ConnectionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[4].Descriptor()
}

func (ConnectionType) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[4]
}

func (x ConnectionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectionType.Descriptor instead.
func (ConnectionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{4}
}

// Represents the different states of a Redis cluster.
type Cluster_State int32

const (
	// Not set.
	Cluster_STATE_UNSPECIFIED Cluster_State = 0
	// Redis cluster is being created.
	Cluster_CREATING Cluster_State = 1
	// Redis cluster has been created and is fully usable.
	Cluster_ACTIVE Cluster_State = 2
	// Redis cluster configuration is being updated.
	Cluster_UPDATING Cluster_State = 3
	// Redis cluster is being deleted.
	Cluster_DELETING Cluster_State = 4
)

// Enum value maps for Cluster_State.
var (
	Cluster_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
	}
	Cluster_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
	}
)

func (x Cluster_State) Enum() *Cluster_State {
	p := new(Cluster_State)
	*p = x
	return p
}

func (x Cluster_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[5].Descriptor()
}

func (Cluster_State) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[5]
}

func (x Cluster_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_State.Descriptor instead.
func (Cluster_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{16, 0}
}

// The automated backup mode.
type AutomatedBackupConfig_AutomatedBackupMode int32

const (
	// Default value. Automated backup config is not specified.
	AutomatedBackupConfig_AUTOMATED_BACKUP_MODE_UNSPECIFIED AutomatedBackupConfig_AutomatedBackupMode = 0
	// Automated backup config disabled.
	AutomatedBackupConfig_DISABLED AutomatedBackupConfig_AutomatedBackupMode = 1
	// Automated backup config enabled.
	AutomatedBackupConfig_ENABLED AutomatedBackupConfig_AutomatedBackupMode = 2
)

// Enum value maps for AutomatedBackupConfig_AutomatedBackupMode.
var (
	AutomatedBackupConfig_AutomatedBackupMode_name = map[int32]string{
		0: "AUTOMATED_BACKUP_MODE_UNSPECIFIED",
		1: "DISABLED",
		2: "ENABLED",
	}
	AutomatedBackupConfig_AutomatedBackupMode_value = map[string]int32{
		"AUTOMATED_BACKUP_MODE_UNSPECIFIED": 0,
		"DISABLED":                          1,
		"ENABLED":                           2,
	}
)

func (x AutomatedBackupConfig_AutomatedBackupMode) Enum() *AutomatedBackupConfig_AutomatedBackupMode {
	p := new(AutomatedBackupConfig_AutomatedBackupMode)
	*p = x
	return p
}

func (x AutomatedBackupConfig_AutomatedBackupMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutomatedBackupConfig_AutomatedBackupMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[6].Descriptor()
}

func (AutomatedBackupConfig_AutomatedBackupMode) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[6]
}

func (x AutomatedBackupConfig_AutomatedBackupMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutomatedBackupConfig_AutomatedBackupMode.Descriptor instead.
func (AutomatedBackupConfig_AutomatedBackupMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{17, 0}
}

// Type of the backup.
type Backup_BackupType int32

const (
	// The default value, not set.
	Backup_BACKUP_TYPE_UNSPECIFIED Backup_BackupType = 0
	// On-demand backup.
	Backup_ON_DEMAND Backup_BackupType = 1
	// Automated backup.
	Backup_AUTOMATED Backup_BackupType = 2
)

// Enum value maps for Backup_BackupType.
var (
	Backup_BackupType_name = map[int32]string{
		0: "BACKUP_TYPE_UNSPECIFIED",
		1: "ON_DEMAND",
		2: "AUTOMATED",
	}
	Backup_BackupType_value = map[string]int32{
		"BACKUP_TYPE_UNSPECIFIED": 0,
		"ON_DEMAND":               1,
		"AUTOMATED":               2,
	}
)

func (x Backup_BackupType) Enum() *Backup_BackupType {
	p := new(Backup_BackupType)
	*p = x
	return p
}

func (x Backup_BackupType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backup_BackupType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[7].Descriptor()
}

func (Backup_BackupType) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[7]
}

func (x Backup_BackupType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backup_BackupType.Descriptor instead.
func (Backup_BackupType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{19, 0}
}

// State of the backup.
type Backup_State int32

const (
	// The default value, not set.
	Backup_STATE_UNSPECIFIED Backup_State = 0
	// The backup is being created.
	Backup_CREATING Backup_State = 1
	// The backup is active to be used.
	Backup_ACTIVE Backup_State = 2
	// The backup is being deleted.
	Backup_DELETING Backup_State = 3
	// The backup is currently suspended due to reasons like project deletion,
	// billing account closure, etc.
	Backup_SUSPENDED Backup_State = 4
)

// Enum value maps for Backup_State.
var (
	Backup_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
		4: "SUSPENDED",
	}
	Backup_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
		"SUSPENDED":         4,
	}
)

func (x Backup_State) Enum() *Backup_State {
	p := new(Backup_State)
	*p = x
	return p
}

func (x Backup_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backup_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[8].Descriptor()
}

func (Backup_State) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[8]
}

func (x Backup_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backup_State.Descriptor instead.
func (Backup_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{19, 1}
}

// The role of the cluster in cross cluster replication.
type CrossClusterReplicationConfig_ClusterRole int32

const (
	// Cluster role is not set.
	// The behavior is equivalent to NONE.
	CrossClusterReplicationConfig_CLUSTER_ROLE_UNSPECIFIED CrossClusterReplicationConfig_ClusterRole = 0
	// This cluster does not participate in cross cluster replication. It is an
	// independent cluster and does not replicate to or from any other clusters.
	CrossClusterReplicationConfig_NONE CrossClusterReplicationConfig_ClusterRole = 1
	// A cluster that allows both reads and writes. Any data written to this
	// cluster is also replicated to the attached secondary clusters.
	CrossClusterReplicationConfig_PRIMARY CrossClusterReplicationConfig_ClusterRole = 2
	// A cluster that allows only reads and replicates data from a primary
	// cluster.
	CrossClusterReplicationConfig_SECONDARY CrossClusterReplicationConfig_ClusterRole = 3
)

// Enum value maps for CrossClusterReplicationConfig_ClusterRole.
var (
	CrossClusterReplicationConfig_ClusterRole_name = map[int32]string{
		0: "CLUSTER_ROLE_UNSPECIFIED",
		1: "NONE",
		2: "PRIMARY",
		3: "SECONDARY",
	}
	CrossClusterReplicationConfig_ClusterRole_value = map[string]int32{
		"CLUSTER_ROLE_UNSPECIFIED": 0,
		"NONE":                     1,
		"PRIMARY":                  2,
		"SECONDARY":                3,
	}
)

func (x CrossClusterReplicationConfig_ClusterRole) Enum() *CrossClusterReplicationConfig_ClusterRole {
	p := new(CrossClusterReplicationConfig_ClusterRole)
	*p = x
	return p
}

func (x CrossClusterReplicationConfig_ClusterRole) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CrossClusterReplicationConfig_ClusterRole) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[9].Descriptor()
}

func (CrossClusterReplicationConfig_ClusterRole) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[9]
}

func (x CrossClusterReplicationConfig_ClusterRole) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CrossClusterReplicationConfig_ClusterRole.Descriptor instead.
func (CrossClusterReplicationConfig_ClusterRole) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{22, 0}
}

// Available persistence modes.
type ClusterPersistenceConfig_PersistenceMode int32

const (
	// Not set.
	ClusterPersistenceConfig_PERSISTENCE_MODE_UNSPECIFIED ClusterPersistenceConfig_PersistenceMode = 0
	// Persistence is disabled, and any snapshot data is deleted.
	ClusterPersistenceConfig_DISABLED ClusterPersistenceConfig_PersistenceMode = 1
	// RDB based persistence is enabled.
	ClusterPersistenceConfig_RDB ClusterPersistenceConfig_PersistenceMode = 2
	// AOF based persistence is enabled.
	ClusterPersistenceConfig_AOF ClusterPersistenceConfig_PersistenceMode = 3
)

// Enum value maps for ClusterPersistenceConfig_PersistenceMode.
var (
	ClusterPersistenceConfig_PersistenceMode_name = map[int32]string{
		0: "PERSISTENCE_MODE_UNSPECIFIED",
		1: "DISABLED",
		2: "RDB",
		3: "AOF",
	}
	ClusterPersistenceConfig_PersistenceMode_value = map[string]int32{
		"PERSISTENCE_MODE_UNSPECIFIED": 0,
		"DISABLED":                     1,
		"RDB":                          2,
		"AOF":                          3,
	}
)

func (x ClusterPersistenceConfig_PersistenceMode) Enum() *ClusterPersistenceConfig_PersistenceMode {
	p := new(ClusterPersistenceConfig_PersistenceMode)
	*p = x
	return p
}

func (x ClusterPersistenceConfig_PersistenceMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterPersistenceConfig_PersistenceMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[10].Descriptor()
}

func (ClusterPersistenceConfig_PersistenceMode) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[10]
}

func (x ClusterPersistenceConfig_PersistenceMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterPersistenceConfig_PersistenceMode.Descriptor instead.
func (ClusterPersistenceConfig_PersistenceMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{34, 0}
}

// Available snapshot periods.
type ClusterPersistenceConfig_RDBConfig_SnapshotPeriod int32

const (
	// Not set.
	ClusterPersistenceConfig_RDBConfig_SNAPSHOT_PERIOD_UNSPECIFIED ClusterPersistenceConfig_RDBConfig_SnapshotPeriod = 0
	// One hour.
	ClusterPersistenceConfig_RDBConfig_ONE_HOUR ClusterPersistenceConfig_RDBConfig_SnapshotPeriod = 1
	// Six hours.
	ClusterPersistenceConfig_RDBConfig_SIX_HOURS ClusterPersistenceConfig_RDBConfig_SnapshotPeriod = 2
	// Twelve hours.
	ClusterPersistenceConfig_RDBConfig_TWELVE_HOURS ClusterPersistenceConfig_RDBConfig_SnapshotPeriod = 3
	// Twenty four hours.
	ClusterPersistenceConfig_RDBConfig_TWENTY_FOUR_HOURS ClusterPersistenceConfig_RDBConfig_SnapshotPeriod = 4
)

// Enum value maps for ClusterPersistenceConfig_RDBConfig_SnapshotPeriod.
var (
	ClusterPersistenceConfig_RDBConfig_SnapshotPeriod_name = map[int32]string{
		0: "SNAPSHOT_PERIOD_UNSPECIFIED",
		1: "ONE_HOUR",
		2: "SIX_HOURS",
		3: "TWELVE_HOURS",
		4: "TWENTY_FOUR_HOURS",
	}
	ClusterPersistenceConfig_RDBConfig_SnapshotPeriod_value = map[string]int32{
		"SNAPSHOT_PERIOD_UNSPECIFIED": 0,
		"ONE_HOUR":                    1,
		"SIX_HOURS":                   2,
		"TWELVE_HOURS":                3,
		"TWENTY_FOUR_HOURS":           4,
	}
)

func (x ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) Enum() *ClusterPersistenceConfig_RDBConfig_SnapshotPeriod {
	p := new(ClusterPersistenceConfig_RDBConfig_SnapshotPeriod)
	*p = x
	return p
}

func (x ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[11].Descriptor()
}

func (ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[11]
}

func (x ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterPersistenceConfig_RDBConfig_SnapshotPeriod.Descriptor instead.
func (ClusterPersistenceConfig_RDBConfig_SnapshotPeriod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{34, 0, 0}
}

// Available fsync modes.
type ClusterPersistenceConfig_AOFConfig_AppendFsync int32

const (
	// Not set. Default: EVERYSEC
	ClusterPersistenceConfig_AOFConfig_APPEND_FSYNC_UNSPECIFIED ClusterPersistenceConfig_AOFConfig_AppendFsync = 0
	// Never fsync. Normally Linux will flush data every 30 seconds with this
	// configuration, but it's up to the kernel's exact tuning.
	ClusterPersistenceConfig_AOFConfig_NO ClusterPersistenceConfig_AOFConfig_AppendFsync = 1
	// fsync every second. Fast enough, and you may lose 1 second of data if
	// there is a disaster
	ClusterPersistenceConfig_AOFConfig_EVERYSEC ClusterPersistenceConfig_AOFConfig_AppendFsync = 2
	// fsync every time new write commands are appended to the AOF. It has the
	// best data loss protection at the cost of performance
	ClusterPersistenceConfig_AOFConfig_ALWAYS ClusterPersistenceConfig_AOFConfig_AppendFsync = 3
)

// Enum value maps for ClusterPersistenceConfig_AOFConfig_AppendFsync.
var (
	ClusterPersistenceConfig_AOFConfig_AppendFsync_name = map[int32]string{
		0: "APPEND_FSYNC_UNSPECIFIED",
		1: "NO",
		2: "EVERYSEC",
		3: "ALWAYS",
	}
	ClusterPersistenceConfig_AOFConfig_AppendFsync_value = map[string]int32{
		"APPEND_FSYNC_UNSPECIFIED": 0,
		"NO":                       1,
		"EVERYSEC":                 2,
		"ALWAYS":                   3,
	}
)

func (x ClusterPersistenceConfig_AOFConfig_AppendFsync) Enum() *ClusterPersistenceConfig_AOFConfig_AppendFsync {
	p := new(ClusterPersistenceConfig_AOFConfig_AppendFsync)
	*p = x
	return p
}

func (x ClusterPersistenceConfig_AOFConfig_AppendFsync) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClusterPersistenceConfig_AOFConfig_AppendFsync) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[12].Descriptor()
}

func (ClusterPersistenceConfig_AOFConfig_AppendFsync) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[12]
}

func (x ClusterPersistenceConfig_AOFConfig_AppendFsync) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClusterPersistenceConfig_AOFConfig_AppendFsync.Descriptor instead.
func (ClusterPersistenceConfig_AOFConfig_AppendFsync) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{34, 1, 0}
}

// Defines various modes of zone distribution.
type ZoneDistributionConfig_ZoneDistributionMode int32

const (
	// Not Set. Default: MULTI_ZONE
	ZoneDistributionConfig_ZONE_DISTRIBUTION_MODE_UNSPECIFIED ZoneDistributionConfig_ZoneDistributionMode = 0
	// Distribute all resources across 3 zones picked at random, within the
	// region.
	ZoneDistributionConfig_MULTI_ZONE ZoneDistributionConfig_ZoneDistributionMode = 1
	// Distribute all resources in a single zone. The zone field must be
	// specified, when this mode is selected.
	ZoneDistributionConfig_SINGLE_ZONE ZoneDistributionConfig_ZoneDistributionMode = 2
)

// Enum value maps for ZoneDistributionConfig_ZoneDistributionMode.
var (
	ZoneDistributionConfig_ZoneDistributionMode_name = map[int32]string{
		0: "ZONE_DISTRIBUTION_MODE_UNSPECIFIED",
		1: "MULTI_ZONE",
		2: "SINGLE_ZONE",
	}
	ZoneDistributionConfig_ZoneDistributionMode_value = map[string]int32{
		"ZONE_DISTRIBUTION_MODE_UNSPECIFIED": 0,
		"MULTI_ZONE":                         1,
		"SINGLE_ZONE":                        2,
	}
)

func (x ZoneDistributionConfig_ZoneDistributionMode) Enum() *ZoneDistributionConfig_ZoneDistributionMode {
	p := new(ZoneDistributionConfig_ZoneDistributionMode)
	*p = x
	return p
}

func (x ZoneDistributionConfig_ZoneDistributionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ZoneDistributionConfig_ZoneDistributionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[13].Descriptor()
}

func (ZoneDistributionConfig_ZoneDistributionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[13]
}

func (x ZoneDistributionConfig_ZoneDistributionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ZoneDistributionConfig_ZoneDistributionMode.Descriptor instead.
func (ZoneDistributionConfig_ZoneDistributionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{35, 0}
}

// Reschedule options.
type RescheduleClusterMaintenanceRequest_RescheduleType int32

const (
	// Not set.
	RescheduleClusterMaintenanceRequest_RESCHEDULE_TYPE_UNSPECIFIED RescheduleClusterMaintenanceRequest_RescheduleType = 0
	// If the user wants to schedule the maintenance to happen now.
	RescheduleClusterMaintenanceRequest_IMMEDIATE RescheduleClusterMaintenanceRequest_RescheduleType = 1
	// If the user wants to reschedule the maintenance to a specific time.
	RescheduleClusterMaintenanceRequest_SPECIFIC_TIME RescheduleClusterMaintenanceRequest_RescheduleType = 3
)

// Enum value maps for RescheduleClusterMaintenanceRequest_RescheduleType.
var (
	RescheduleClusterMaintenanceRequest_RescheduleType_name = map[int32]string{
		0: "RESCHEDULE_TYPE_UNSPECIFIED",
		1: "IMMEDIATE",
		3: "SPECIFIC_TIME",
	}
	RescheduleClusterMaintenanceRequest_RescheduleType_value = map[string]int32{
		"RESCHEDULE_TYPE_UNSPECIFIED": 0,
		"IMMEDIATE":                   1,
		"SPECIFIC_TIME":               3,
	}
)

func (x RescheduleClusterMaintenanceRequest_RescheduleType) Enum() *RescheduleClusterMaintenanceRequest_RescheduleType {
	p := new(RescheduleClusterMaintenanceRequest_RescheduleType)
	*p = x
	return p
}

func (x RescheduleClusterMaintenanceRequest_RescheduleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RescheduleClusterMaintenanceRequest_RescheduleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[14].Descriptor()
}

func (RescheduleClusterMaintenanceRequest_RescheduleType) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[14]
}

func (x RescheduleClusterMaintenanceRequest_RescheduleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RescheduleClusterMaintenanceRequest_RescheduleType.Descriptor instead.
func (RescheduleClusterMaintenanceRequest_RescheduleType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{36, 0}
}

// Possible encryption types.
type EncryptionInfo_Type int32

const (
	// Encryption type not specified. Defaults to GOOGLE_DEFAULT_ENCRYPTION.
	EncryptionInfo_TYPE_UNSPECIFIED EncryptionInfo_Type = 0
	// The data is encrypted at rest with a key that is fully managed by Google.
	// No key version will be populated. This is the default state.
	EncryptionInfo_GOOGLE_DEFAULT_ENCRYPTION EncryptionInfo_Type = 1
	// The data is encrypted at rest with a key that is managed by the customer.
	// KMS key versions will be populated.
	EncryptionInfo_CUSTOMER_MANAGED_ENCRYPTION EncryptionInfo_Type = 2
)

// Enum value maps for EncryptionInfo_Type.
var (
	EncryptionInfo_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "GOOGLE_DEFAULT_ENCRYPTION",
		2: "CUSTOMER_MANAGED_ENCRYPTION",
	}
	EncryptionInfo_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":            0,
		"GOOGLE_DEFAULT_ENCRYPTION":   1,
		"CUSTOMER_MANAGED_ENCRYPTION": 2,
	}
)

func (x EncryptionInfo_Type) Enum() *EncryptionInfo_Type {
	p := new(EncryptionInfo_Type)
	*p = x
	return p
}

func (x EncryptionInfo_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncryptionInfo_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[15].Descriptor()
}

func (EncryptionInfo_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[15]
}

func (x EncryptionInfo_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncryptionInfo_Type.Descriptor instead.
func (EncryptionInfo_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{37, 0}
}

// The state of the KMS key perceived by the system. Refer to the public
// documentation for the impact of each state.
type EncryptionInfo_KmsKeyState int32

const (
	// The default value. This value is unused.
	EncryptionInfo_KMS_KEY_STATE_UNSPECIFIED EncryptionInfo_KmsKeyState = 0
	// The KMS key is enabled and correctly configured.
	EncryptionInfo_ENABLED EncryptionInfo_KmsKeyState = 1
	// Permission denied on the KMS key.
	EncryptionInfo_PERMISSION_DENIED EncryptionInfo_KmsKeyState = 2
	// The KMS key is disabled.
	EncryptionInfo_DISABLED EncryptionInfo_KmsKeyState = 3
	// The KMS key is destroyed.
	EncryptionInfo_DESTROYED EncryptionInfo_KmsKeyState = 4
	// The KMS key is scheduled to be destroyed.
	EncryptionInfo_DESTROY_SCHEDULED EncryptionInfo_KmsKeyState = 5
	// The EKM key is unreachable.
	EncryptionInfo_EKM_KEY_UNREACHABLE_DETECTED EncryptionInfo_KmsKeyState = 6
	// Billing is disabled for the project.
	EncryptionInfo_BILLING_DISABLED EncryptionInfo_KmsKeyState = 7
	// All other unknown failures.
	EncryptionInfo_UNKNOWN_FAILURE EncryptionInfo_KmsKeyState = 8
)

// Enum value maps for EncryptionInfo_KmsKeyState.
var (
	EncryptionInfo_KmsKeyState_name = map[int32]string{
		0: "KMS_KEY_STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "PERMISSION_DENIED",
		3: "DISABLED",
		4: "DESTROYED",
		5: "DESTROY_SCHEDULED",
		6: "EKM_KEY_UNREACHABLE_DETECTED",
		7: "BILLING_DISABLED",
		8: "UNKNOWN_FAILURE",
	}
	EncryptionInfo_KmsKeyState_value = map[string]int32{
		"KMS_KEY_STATE_UNSPECIFIED":    0,
		"ENABLED":                      1,
		"PERMISSION_DENIED":            2,
		"DISABLED":                     3,
		"DESTROYED":                    4,
		"DESTROY_SCHEDULED":            5,
		"EKM_KEY_UNREACHABLE_DETECTED": 6,
		"BILLING_DISABLED":             7,
		"UNKNOWN_FAILURE":              8,
	}
)

func (x EncryptionInfo_KmsKeyState) Enum() *EncryptionInfo_KmsKeyState {
	p := new(EncryptionInfo_KmsKeyState)
	*p = x
	return p
}

func (x EncryptionInfo_KmsKeyState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EncryptionInfo_KmsKeyState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[16].Descriptor()
}

func (EncryptionInfo_KmsKeyState) Type() protoreflect.EnumType {
	return &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes[16]
}

func (x EncryptionInfo_KmsKeyState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EncryptionInfo_KmsKeyState.Descriptor instead.
func (EncryptionInfo_KmsKeyState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{37, 1}
}

// Request for [CreateCluster][CloudRedis.CreateCluster].
type CreateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the cluster location using the form:
	//
	//	`projects/{project_id}/locations/{location_id}`
	//
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The logical name of the Redis cluster in the customer project
	// with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-63 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the customer project / location
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The cluster that is to be created.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateClusterRequest) Reset() {
	*x = CreateClusterRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateClusterRequest) ProtoMessage() {}

func (x *CreateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *CreateClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateClusterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *CreateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *CreateClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for [ListClusters][CloudRedis.ListClusters].
type ListClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the cluster location using the form:
	//
	//	`projects/{project_id}/locations/{location_id}`
	//
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 1000 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [`next_page_token`][google.cloud.redis.cluster.v1.ListClustersResponse.next_page_token]
	// to determine if there are more clusters left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `next_page_token` value returned from a previous
	// [ListClusters][CloudRedis.ListClusters] request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListClustersRequest) Reset() {
	*x = ListClustersRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersRequest) ProtoMessage() {}

func (x *ListClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersRequest.ProtoReflect.Descriptor instead.
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *ListClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for [ListClusters][CloudRedis.ListClusters].
type ListClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Redis clusters in the project in the specified location,
	// or across all locations.
	//
	// If the `location_id` in the parent field of the request is "-", all regions
	// available to the project are queried, and the results aggregated.
	// If in such an aggregated query a location is unavailable, a placeholder
	// Redis entry is included in the response with the `name` field set to a
	// value of the form
	// `projects/{project_id}/locations/{location_id}/clusters/`- and the
	// `status` field set to ERROR and `status_message` field set to "location not
	// available for ListClusters".
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListClustersResponse) Reset() {
	*x = ListClustersResponse{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersResponse) ProtoMessage() {}

func (x *ListClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersResponse.ProtoReflect.Descriptor instead.
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *ListClustersResponse) GetClusters() []*Cluster {
	if x != nil {
		return x.Clusters
	}
	return nil
}

func (x *ListClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListClustersResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for [UpdateCluster][CloudRedis.UpdateCluster].
type UpdateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field may only include these
	// fields from [Cluster][google.cloud.redis.cluster.v1.Cluster]:
	//
	//   - `size_gb`
	//   - `replica_count`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Update description.
	// Only fields specified in update_mask are updated.
	Cluster *Cluster `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateClusterRequest) Reset() {
	*x = UpdateClusterRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateClusterRequest) ProtoMessage() {}

func (x *UpdateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *UpdateClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for [GetCluster][CloudRedis.GetCluster].
type GetClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Redis cluster resource name using the form:
	//
	//	`projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
	//
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetClusterRequest) Reset() {
	*x = GetClusterRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterRequest) ProtoMessage() {}

func (x *GetClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterRequest.ProtoReflect.Descriptor instead.
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *GetClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for [DeleteCluster][CloudRedis.DeleteCluster].
type DeleteClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Redis cluster resource name using the form:
	//
	//	`projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
	//
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Idempotent request UUID.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteClusterRequest) Reset() {
	*x = DeleteClusterRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteClusterRequest) ProtoMessage() {}

func (x *DeleteClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for
// [GetClusterCertificateAuthorityRequest][CloudRedis.GetClusterCertificateAuthorityRequest].
type GetClusterCertificateAuthorityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Redis cluster certificate authority resource name using the form:
	//
	//	`projects/{project_id}/locations/{location_id}/clusters/{cluster_id}/certificateAuthority`
	//
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetClusterCertificateAuthorityRequest) Reset() {
	*x = GetClusterCertificateAuthorityRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetClusterCertificateAuthorityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterCertificateAuthorityRequest) ProtoMessage() {}

func (x *GetClusterCertificateAuthorityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterCertificateAuthorityRequest.ProtoReflect.Descriptor instead.
func (*GetClusterCertificateAuthorityRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *GetClusterCertificateAuthorityRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for [ListBackupCollections]
type ListBackupCollectionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the backupCollection location using the
	// form:
	//
	//	`projects/{project_id}/locations/{location_id}`
	//
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	//
	// If not specified, a default value of 1000 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [`next_page_token`][google.cloud.redis.cluster.v1.ListBackupCollectionsResponse.next_page_token]
	// to determine if there are more clusters left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The `next_page_token` value returned from a previous
	// [ListBackupCollections] request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBackupCollectionsRequest) Reset() {
	*x = ListBackupCollectionsRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupCollectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupCollectionsRequest) ProtoMessage() {}

func (x *ListBackupCollectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupCollectionsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupCollectionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *ListBackupCollectionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupCollectionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupCollectionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for [ListBackupCollections].
type ListBackupCollectionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of backupCollections in the project.
	//
	// If the `location_id` in the parent field of the request is "-", all regions
	// available to the project are queried, and the results aggregated.
	// If in such an aggregated query a location is unavailable, a placeholder
	// backupCollection entry is included in the response with the `name` field
	// set to a value of the form
	// `projects/{project_id}/locations/{location_id}/backupCollections/`- and the
	// `status` field set to ERROR and `status_message` field set to "location not
	// available for ListBackupCollections".
	BackupCollections []*BackupCollection `protobuf:"bytes,1,rep,name=backup_collections,json=backupCollections,proto3" json:"backup_collections,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupCollectionsResponse) Reset() {
	*x = ListBackupCollectionsResponse{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupCollectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupCollectionsResponse) ProtoMessage() {}

func (x *ListBackupCollectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupCollectionsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupCollectionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *ListBackupCollectionsResponse) GetBackupCollections() []*BackupCollection {
	if x != nil {
		return x.BackupCollections
	}
	return nil
}

func (x *ListBackupCollectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupCollectionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for [GetBackupCollection].
type GetBackupCollectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Redis backupCollection resource name using the form:
	//
	//	`projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}`
	//
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupCollectionRequest) Reset() {
	*x = GetBackupCollectionRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupCollectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupCollectionRequest) ProtoMessage() {}

func (x *GetBackupCollectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupCollectionRequest.ProtoReflect.Descriptor instead.
func (*GetBackupCollectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{9}
}

func (x *GetBackupCollectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for [ListBackups].
type ListBackupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the backupCollection using the form:
	// `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	//
	// If not specified, a default value of 1000 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [`next_page_token`][google.cloud.redis.cluster.v1.ListBackupsResponse.next_page_token]
	// to determine if there are more clusters left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The `next_page_token` value returned from a previous
	// [ListBackupCollections] request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBackupsRequest) Reset() {
	*x = ListBackupsRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsRequest) ProtoMessage() {}

func (x *ListBackupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{10}
}

func (x *ListBackupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for [ListBackups].
type ListBackupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of backups in the project.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Backups that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupsResponse) Reset() {
	*x = ListBackupsResponse{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsResponse) ProtoMessage() {}

func (x *ListBackupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{11}
}

func (x *ListBackupsResponse) GetBackups() []*Backup {
	if x != nil {
		return x.Backups
	}
	return nil
}

func (x *ListBackupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for [GetBackup].
type GetBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Redis backup resource name using the form:
	// `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}/backups/{backup_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupRequest) Reset() {
	*x = GetBackupRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupRequest) ProtoMessage() {}

func (x *GetBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupRequest.ProtoReflect.Descriptor instead.
func (*GetBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{12}
}

func (x *GetBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for [DeleteBackup].
type DeleteBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Redis backup resource name using the form:
	// `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}/backups/{backup_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Idempotent request UUID.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteBackupRequest) Reset() {
	*x = DeleteBackupRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupRequest) ProtoMessage() {}

func (x *DeleteBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBackupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for [ExportBackup].
type ExportBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specify destination to export a backup.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportBackupRequest_GcsBucket
	Destination isExportBackupRequest_Destination `protobuf_oneof:"destination"`
	// Required. Redis backup resource name using the form:
	// `projects/{project_id}/locations/{location_id}/backupCollections/{backup_collection_id}/backups/{backup_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ExportBackupRequest) Reset() {
	*x = ExportBackupRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportBackupRequest) ProtoMessage() {}

func (x *ExportBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportBackupRequest.ProtoReflect.Descriptor instead.
func (*ExportBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{14}
}

func (m *ExportBackupRequest) GetDestination() isExportBackupRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportBackupRequest) GetGcsBucket() string {
	if x, ok := x.GetDestination().(*ExportBackupRequest_GcsBucket); ok {
		return x.GcsBucket
	}
	return ""
}

func (x *ExportBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isExportBackupRequest_Destination interface {
	isExportBackupRequest_Destination()
}

type ExportBackupRequest_GcsBucket struct {
	// Google Cloud Storage bucket, like "my-bucket".
	GcsBucket string `protobuf:"bytes,3,opt,name=gcs_bucket,json=gcsBucket,proto3,oneof"`
}

func (*ExportBackupRequest_GcsBucket) isExportBackupRequest_Destination() {}

// Request for [BackupCluster].
type BackupClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Redis cluster resource name using the form:
	//
	//	`projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
	//
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. TTL for the backup to expire. Value range is 1 day to 100 years.
	// If not specified, the default value is 100 years.
	Ttl *durationpb.Duration `protobuf:"bytes,2,opt,name=ttl,proto3" json:"ttl,omitempty"`
	// Optional. The id of the backup to be created. If not specified, the
	// default value ([YYYYMMDDHHMMSS]_[Shortened Cluster UID] is used.
	BackupId *string `protobuf:"bytes,3,opt,name=backup_id,json=backupId,proto3,oneof" json:"backup_id,omitempty"`
}

func (x *BackupClusterRequest) Reset() {
	*x = BackupClusterRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupClusterRequest) ProtoMessage() {}

func (x *BackupClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupClusterRequest.ProtoReflect.Descriptor instead.
func (*BackupClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{15}
}

func (x *BackupClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BackupClusterRequest) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

func (x *BackupClusterRequest) GetBackupId() string {
	if x != nil && x.BackupId != nil {
		return *x.BackupId
	}
	return ""
}

// A cluster instance.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source to import from.
	//
	// Types that are assignable to ImportSources:
	//
	//	*Cluster_GcsSource
	//	*Cluster_ManagedBackupSource_
	ImportSources isCluster_ImportSources `protobuf_oneof:"import_sources"`
	// Required. Identifier. Unique name of the resource in this scope including
	// project and location using the form:
	//
	//	`projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp associated with the cluster creation request.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The current state of this cluster.
	// Can be CREATING, READY, UPDATING, DELETING and SUSPENDED
	State Cluster_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.redis.cluster.v1.Cluster_State" json:"state,omitempty"`
	// Output only. System assigned, unique identifier for the cluster.
	Uid string `protobuf:"bytes,5,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. The number of replica nodes per shard.
	ReplicaCount *int32 `protobuf:"varint,8,opt,name=replica_count,json=replicaCount,proto3,oneof" json:"replica_count,omitempty"`
	// Optional. The authorization mode of the Redis cluster.
	// If not provided, auth feature is disabled for the cluster.
	AuthorizationMode AuthorizationMode `protobuf:"varint,11,opt,name=authorization_mode,json=authorizationMode,proto3,enum=google.cloud.redis.cluster.v1.AuthorizationMode" json:"authorization_mode,omitempty"`
	// Optional. The in-transit encryption for the Redis cluster.
	// If not provided, encryption  is disabled for the cluster.
	TransitEncryptionMode TransitEncryptionMode `protobuf:"varint,12,opt,name=transit_encryption_mode,json=transitEncryptionMode,proto3,enum=google.cloud.redis.cluster.v1.TransitEncryptionMode" json:"transit_encryption_mode,omitempty"`
	// Output only. Redis memory size in GB for the entire cluster rounded up to
	// the next integer.
	SizeGb *int32 `protobuf:"varint,13,opt,name=size_gb,json=sizeGb,proto3,oneof" json:"size_gb,omitempty"`
	// Optional. Number of shards for the Redis cluster.
	ShardCount *int32 `protobuf:"varint,14,opt,name=shard_count,json=shardCount,proto3,oneof" json:"shard_count,omitempty"`
	// Optional. Each PscConfig configures the consumer network where IPs will
	// be designated to the cluster for client access through Private Service
	// Connect Automation. Currently, only one PscConfig is supported.
	PscConfigs []*PscConfig `protobuf:"bytes,15,rep,name=psc_configs,json=pscConfigs,proto3" json:"psc_configs,omitempty"`
	// Output only. Endpoints created on each given network, for Redis clients to
	// connect to the cluster. Currently only one discovery endpoint is supported.
	DiscoveryEndpoints []*DiscoveryEndpoint `protobuf:"bytes,16,rep,name=discovery_endpoints,json=discoveryEndpoints,proto3" json:"discovery_endpoints,omitempty"`
	// Output only. The list of PSC connections that are auto-created through
	// service connectivity automation.
	PscConnections []*PscConnection `protobuf:"bytes,17,rep,name=psc_connections,json=pscConnections,proto3" json:"psc_connections,omitempty"`
	// Output only. Additional information about the current state of the cluster.
	StateInfo *Cluster_StateInfo `protobuf:"bytes,18,opt,name=state_info,json=stateInfo,proto3" json:"state_info,omitempty"`
	// Optional. The type of a redis node in the cluster. NodeType determines the
	// underlying machine-type of a redis node.
	NodeType NodeType `protobuf:"varint,19,opt,name=node_type,json=nodeType,proto3,enum=google.cloud.redis.cluster.v1.NodeType" json:"node_type,omitempty"`
	// Optional. Persistence config (RDB, AOF) for the cluster.
	PersistenceConfig *ClusterPersistenceConfig `protobuf:"bytes,20,opt,name=persistence_config,json=persistenceConfig,proto3" json:"persistence_config,omitempty"`
	// Optional. Key/Value pairs of customer overrides for mutable Redis Configs
	RedisConfigs map[string]string `protobuf:"bytes,21,rep,name=redis_configs,json=redisConfigs,proto3" json:"redis_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Precise value of redis memory size in GB for the entire
	// cluster.
	PreciseSizeGb *float64 `protobuf:"fixed64,22,opt,name=precise_size_gb,json=preciseSizeGb,proto3,oneof" json:"precise_size_gb,omitempty"`
	// Optional. This config will be used to determine how the customer wants us
	// to distribute cluster resources within the region.
	ZoneDistributionConfig *ZoneDistributionConfig `protobuf:"bytes,23,opt,name=zone_distribution_config,json=zoneDistributionConfig,proto3" json:"zone_distribution_config,omitempty"`
	// Optional. Cross cluster replication config.
	CrossClusterReplicationConfig *CrossClusterReplicationConfig `protobuf:"bytes,24,opt,name=cross_cluster_replication_config,json=crossClusterReplicationConfig,proto3" json:"cross_cluster_replication_config,omitempty"`
	// Optional. The delete operation will fail when the value is set to true.
	DeletionProtectionEnabled *bool `protobuf:"varint,25,opt,name=deletion_protection_enabled,json=deletionProtectionEnabled,proto3,oneof" json:"deletion_protection_enabled,omitempty"`
	// Optional. ClusterMaintenancePolicy determines when to allow or deny
	// updates.
	MaintenancePolicy *ClusterMaintenancePolicy `protobuf:"bytes,26,opt,name=maintenance_policy,json=maintenancePolicy,proto3,oneof" json:"maintenance_policy,omitempty"`
	// Output only. ClusterMaintenanceSchedule Output only Published maintenance
	// schedule.
	MaintenanceSchedule *ClusterMaintenanceSchedule `protobuf:"bytes,27,opt,name=maintenance_schedule,json=maintenanceSchedule,proto3,oneof" json:"maintenance_schedule,omitempty"`
	// Output only. Service attachment details to configure Psc connections
	PscServiceAttachments []*PscServiceAttachment `protobuf:"bytes,30,rep,name=psc_service_attachments,json=pscServiceAttachments,proto3" json:"psc_service_attachments,omitempty"`
	// Optional. A list of cluster enpoints.
	ClusterEndpoints []*ClusterEndpoint `protobuf:"bytes,36,rep,name=cluster_endpoints,json=clusterEndpoints,proto3" json:"cluster_endpoints,omitempty"`
	// Optional. Output only. The backup collection full resource name. Example:
	// projects/{project}/locations/{location}/backupCollections/{collection}
	BackupCollection *string `protobuf:"bytes,39,opt,name=backup_collection,json=backupCollection,proto3,oneof" json:"backup_collection,omitempty"`
	// Optional. The KMS key used to encrypt the at-rest data of the cluster.
	KmsKey *string `protobuf:"bytes,40,opt,name=kms_key,json=kmsKey,proto3,oneof" json:"kms_key,omitempty"`
	// Optional. The automated backup config for the cluster.
	AutomatedBackupConfig *AutomatedBackupConfig `protobuf:"bytes,42,opt,name=automated_backup_config,json=automatedBackupConfig,proto3" json:"automated_backup_config,omitempty"`
	// Output only. Encryption information of the data at rest of the cluster.
	EncryptionInfo *EncryptionInfo `protobuf:"bytes,43,opt,name=encryption_info,json=encryptionInfo,proto3" json:"encryption_info,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{16}
}

func (m *Cluster) GetImportSources() isCluster_ImportSources {
	if m != nil {
		return m.ImportSources
	}
	return nil
}

func (x *Cluster) GetGcsSource() *Cluster_GcsBackupSource {
	if x, ok := x.GetImportSources().(*Cluster_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *Cluster) GetManagedBackupSource() *Cluster_ManagedBackupSource {
	if x, ok := x.GetImportSources().(*Cluster_ManagedBackupSource_); ok {
		return x.ManagedBackupSource
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Cluster) GetState() Cluster_State {
	if x != nil {
		return x.State
	}
	return Cluster_STATE_UNSPECIFIED
}

func (x *Cluster) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Cluster) GetReplicaCount() int32 {
	if x != nil && x.ReplicaCount != nil {
		return *x.ReplicaCount
	}
	return 0
}

func (x *Cluster) GetAuthorizationMode() AuthorizationMode {
	if x != nil {
		return x.AuthorizationMode
	}
	return AuthorizationMode_AUTH_MODE_UNSPECIFIED
}

func (x *Cluster) GetTransitEncryptionMode() TransitEncryptionMode {
	if x != nil {
		return x.TransitEncryptionMode
	}
	return TransitEncryptionMode_TRANSIT_ENCRYPTION_MODE_UNSPECIFIED
}

func (x *Cluster) GetSizeGb() int32 {
	if x != nil && x.SizeGb != nil {
		return *x.SizeGb
	}
	return 0
}

func (x *Cluster) GetShardCount() int32 {
	if x != nil && x.ShardCount != nil {
		return *x.ShardCount
	}
	return 0
}

func (x *Cluster) GetPscConfigs() []*PscConfig {
	if x != nil {
		return x.PscConfigs
	}
	return nil
}

func (x *Cluster) GetDiscoveryEndpoints() []*DiscoveryEndpoint {
	if x != nil {
		return x.DiscoveryEndpoints
	}
	return nil
}

func (x *Cluster) GetPscConnections() []*PscConnection {
	if x != nil {
		return x.PscConnections
	}
	return nil
}

func (x *Cluster) GetStateInfo() *Cluster_StateInfo {
	if x != nil {
		return x.StateInfo
	}
	return nil
}

func (x *Cluster) GetNodeType() NodeType {
	if x != nil {
		return x.NodeType
	}
	return NodeType_NODE_TYPE_UNSPECIFIED
}

func (x *Cluster) GetPersistenceConfig() *ClusterPersistenceConfig {
	if x != nil {
		return x.PersistenceConfig
	}
	return nil
}

func (x *Cluster) GetRedisConfigs() map[string]string {
	if x != nil {
		return x.RedisConfigs
	}
	return nil
}

func (x *Cluster) GetPreciseSizeGb() float64 {
	if x != nil && x.PreciseSizeGb != nil {
		return *x.PreciseSizeGb
	}
	return 0
}

func (x *Cluster) GetZoneDistributionConfig() *ZoneDistributionConfig {
	if x != nil {
		return x.ZoneDistributionConfig
	}
	return nil
}

func (x *Cluster) GetCrossClusterReplicationConfig() *CrossClusterReplicationConfig {
	if x != nil {
		return x.CrossClusterReplicationConfig
	}
	return nil
}

func (x *Cluster) GetDeletionProtectionEnabled() bool {
	if x != nil && x.DeletionProtectionEnabled != nil {
		return *x.DeletionProtectionEnabled
	}
	return false
}

func (x *Cluster) GetMaintenancePolicy() *ClusterMaintenancePolicy {
	if x != nil {
		return x.MaintenancePolicy
	}
	return nil
}

func (x *Cluster) GetMaintenanceSchedule() *ClusterMaintenanceSchedule {
	if x != nil {
		return x.MaintenanceSchedule
	}
	return nil
}

func (x *Cluster) GetPscServiceAttachments() []*PscServiceAttachment {
	if x != nil {
		return x.PscServiceAttachments
	}
	return nil
}

func (x *Cluster) GetClusterEndpoints() []*ClusterEndpoint {
	if x != nil {
		return x.ClusterEndpoints
	}
	return nil
}

func (x *Cluster) GetBackupCollection() string {
	if x != nil && x.BackupCollection != nil {
		return *x.BackupCollection
	}
	return ""
}

func (x *Cluster) GetKmsKey() string {
	if x != nil && x.KmsKey != nil {
		return *x.KmsKey
	}
	return ""
}

func (x *Cluster) GetAutomatedBackupConfig() *AutomatedBackupConfig {
	if x != nil {
		return x.AutomatedBackupConfig
	}
	return nil
}

func (x *Cluster) GetEncryptionInfo() *EncryptionInfo {
	if x != nil {
		return x.EncryptionInfo
	}
	return nil
}

type isCluster_ImportSources interface {
	isCluster_ImportSources()
}

type Cluster_GcsSource struct {
	// Optional. Backups stored in Cloud Storage buckets.
	// The Cloud Storage buckets need to be the same region as the clusters.
	// Read permission is required to import from the provided Cloud Storage
	// objects.
	GcsSource *Cluster_GcsBackupSource `protobuf:"bytes,34,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type Cluster_ManagedBackupSource_ struct {
	// Optional. Backups generated and managed by memorystore service.
	ManagedBackupSource *Cluster_ManagedBackupSource `protobuf:"bytes,35,opt,name=managed_backup_source,json=managedBackupSource,proto3,oneof"`
}

func (*Cluster_GcsSource) isCluster_ImportSources() {}

func (*Cluster_ManagedBackupSource_) isCluster_ImportSources() {}

// The automated backup config for a cluster.
type AutomatedBackupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The schedule of automated backups.
	//
	// Types that are assignable to Schedule:
	//
	//	*AutomatedBackupConfig_FixedFrequencySchedule_
	Schedule isAutomatedBackupConfig_Schedule `protobuf_oneof:"schedule"`
	// Optional. The automated backup mode. If the mode is disabled, the other
	// fields will be ignored.
	AutomatedBackupMode AutomatedBackupConfig_AutomatedBackupMode `protobuf:"varint,1,opt,name=automated_backup_mode,json=automatedBackupMode,proto3,enum=google.cloud.redis.cluster.v1.AutomatedBackupConfig_AutomatedBackupMode" json:"automated_backup_mode,omitempty"`
	// Optional. How long to keep automated backups before the backups are
	// deleted. The value should be between 1 day and 365 days. If not specified,
	// the default value is 35 days.
	Retention *durationpb.Duration `protobuf:"bytes,3,opt,name=retention,proto3,oneof" json:"retention,omitempty"`
}

func (x *AutomatedBackupConfig) Reset() {
	*x = AutomatedBackupConfig{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomatedBackupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomatedBackupConfig) ProtoMessage() {}

func (x *AutomatedBackupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomatedBackupConfig.ProtoReflect.Descriptor instead.
func (*AutomatedBackupConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{17}
}

func (m *AutomatedBackupConfig) GetSchedule() isAutomatedBackupConfig_Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (x *AutomatedBackupConfig) GetFixedFrequencySchedule() *AutomatedBackupConfig_FixedFrequencySchedule {
	if x, ok := x.GetSchedule().(*AutomatedBackupConfig_FixedFrequencySchedule_); ok {
		return x.FixedFrequencySchedule
	}
	return nil
}

func (x *AutomatedBackupConfig) GetAutomatedBackupMode() AutomatedBackupConfig_AutomatedBackupMode {
	if x != nil {
		return x.AutomatedBackupMode
	}
	return AutomatedBackupConfig_AUTOMATED_BACKUP_MODE_UNSPECIFIED
}

func (x *AutomatedBackupConfig) GetRetention() *durationpb.Duration {
	if x != nil {
		return x.Retention
	}
	return nil
}

type isAutomatedBackupConfig_Schedule interface {
	isAutomatedBackupConfig_Schedule()
}

type AutomatedBackupConfig_FixedFrequencySchedule_ struct {
	// Optional. Trigger automated backups at a fixed frequency.
	FixedFrequencySchedule *AutomatedBackupConfig_FixedFrequencySchedule `protobuf:"bytes,2,opt,name=fixed_frequency_schedule,json=fixedFrequencySchedule,proto3,oneof"`
}

func (*AutomatedBackupConfig_FixedFrequencySchedule_) isAutomatedBackupConfig_Schedule() {}

// BackupCollection of a cluster.
type BackupCollection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Full resource path of the backup collection.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The cluster uid of the backup collection.
	ClusterUid string `protobuf:"bytes,3,opt,name=cluster_uid,json=clusterUid,proto3" json:"cluster_uid,omitempty"`
	// Output only. The full resource path of the cluster the backup collection
	// belongs to. Example:
	// projects/{project}/locations/{location}/clusters/{cluster}
	Cluster string `protobuf:"bytes,4,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Output only. The KMS key used to encrypt the backups under this backup
	// collection.
	KmsKey string `protobuf:"bytes,5,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
	// Output only. System assigned unique identifier of the backup collection.
	Uid string `protobuf:"bytes,6,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *BackupCollection) Reset() {
	*x = BackupCollection{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupCollection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupCollection) ProtoMessage() {}

func (x *BackupCollection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupCollection.ProtoReflect.Descriptor instead.
func (*BackupCollection) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{18}
}

func (x *BackupCollection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BackupCollection) GetClusterUid() string {
	if x != nil {
		return x.ClusterUid
	}
	return ""
}

func (x *BackupCollection) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *BackupCollection) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

func (x *BackupCollection) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// Backup of a cluster.
type Backup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Full resource path of the backup. the last part of the name is
	// the backup id with the following format: [YYYYMMDDHHMMSS]_[Shorted Cluster
	// UID] OR customer specified while backup cluster. Example:
	// 20240515123000_1234
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the backup was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Cluster resource path of this backup.
	Cluster string `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Output only. Cluster uid of this backup.
	ClusterUid string `protobuf:"bytes,4,opt,name=cluster_uid,json=clusterUid,proto3" json:"cluster_uid,omitempty"`
	// Output only. Total size of the backup in bytes.
	TotalSizeBytes int64 `protobuf:"varint,5,opt,name=total_size_bytes,json=totalSizeBytes,proto3" json:"total_size_bytes,omitempty"`
	// Output only. The time when the backup will expire.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. redis-7.2, valkey-7.5
	EngineVersion string `protobuf:"bytes,7,opt,name=engine_version,json=engineVersion,proto3" json:"engine_version,omitempty"`
	// Output only. List of backup files of the backup.
	BackupFiles []*BackupFile `protobuf:"bytes,8,rep,name=backup_files,json=backupFiles,proto3" json:"backup_files,omitempty"`
	// Output only. Node type of the cluster.
	NodeType NodeType `protobuf:"varint,9,opt,name=node_type,json=nodeType,proto3,enum=google.cloud.redis.cluster.v1.NodeType" json:"node_type,omitempty"`
	// Output only. Number of replicas for the cluster.
	ReplicaCount int32 `protobuf:"varint,10,opt,name=replica_count,json=replicaCount,proto3" json:"replica_count,omitempty"`
	// Output only. Number of shards for the cluster.
	ShardCount int32 `protobuf:"varint,11,opt,name=shard_count,json=shardCount,proto3" json:"shard_count,omitempty"`
	// Output only. Type of the backup.
	BackupType Backup_BackupType `protobuf:"varint,12,opt,name=backup_type,json=backupType,proto3,enum=google.cloud.redis.cluster.v1.Backup_BackupType" json:"backup_type,omitempty"`
	// Output only. State of the backup.
	State Backup_State `protobuf:"varint,13,opt,name=state,proto3,enum=google.cloud.redis.cluster.v1.Backup_State" json:"state,omitempty"`
	// Output only. Encryption information of the backup.
	EncryptionInfo *EncryptionInfo `protobuf:"bytes,14,opt,name=encryption_info,json=encryptionInfo,proto3" json:"encryption_info,omitempty"`
	// Output only. System assigned unique identifier of the backup.
	Uid string `protobuf:"bytes,15,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *Backup) Reset() {
	*x = Backup{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Backup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backup) ProtoMessage() {}

func (x *Backup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backup.ProtoReflect.Descriptor instead.
func (*Backup) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{19}
}

func (x *Backup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Backup) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Backup) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *Backup) GetClusterUid() string {
	if x != nil {
		return x.ClusterUid
	}
	return ""
}

func (x *Backup) GetTotalSizeBytes() int64 {
	if x != nil {
		return x.TotalSizeBytes
	}
	return 0
}

func (x *Backup) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Backup) GetEngineVersion() string {
	if x != nil {
		return x.EngineVersion
	}
	return ""
}

func (x *Backup) GetBackupFiles() []*BackupFile {
	if x != nil {
		return x.BackupFiles
	}
	return nil
}

func (x *Backup) GetNodeType() NodeType {
	if x != nil {
		return x.NodeType
	}
	return NodeType_NODE_TYPE_UNSPECIFIED
}

func (x *Backup) GetReplicaCount() int32 {
	if x != nil {
		return x.ReplicaCount
	}
	return 0
}

func (x *Backup) GetShardCount() int32 {
	if x != nil {
		return x.ShardCount
	}
	return 0
}

func (x *Backup) GetBackupType() Backup_BackupType {
	if x != nil {
		return x.BackupType
	}
	return Backup_BACKUP_TYPE_UNSPECIFIED
}

func (x *Backup) GetState() Backup_State {
	if x != nil {
		return x.State
	}
	return Backup_STATE_UNSPECIFIED
}

func (x *Backup) GetEncryptionInfo() *EncryptionInfo {
	if x != nil {
		return x.EncryptionInfo
	}
	return nil
}

func (x *Backup) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// Backup is consisted of multiple backup files.
type BackupFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. e.g: <shard-id>.rdb
	FileName string `protobuf:"bytes,1,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// Output only. Size of the backup file in bytes.
	SizeBytes int64 `protobuf:"varint,2,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Output only. The time when the backup file was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *BackupFile) Reset() {
	*x = BackupFile{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupFile) ProtoMessage() {}

func (x *BackupFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupFile.ProtoReflect.Descriptor instead.
func (*BackupFile) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{20}
}

func (x *BackupFile) GetFileName() string {
	if x != nil {
		return x.FileName
	}
	return ""
}

func (x *BackupFile) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

func (x *BackupFile) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Configuration of a service attachment of the cluster, for creating PSC
// connections.
type PscServiceAttachment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Service attachment URI which your self-created PscConnection
	// should use as target
	ServiceAttachment string `protobuf:"bytes,1,opt,name=service_attachment,json=serviceAttachment,proto3" json:"service_attachment,omitempty"`
	// Output only. Type of a PSC connection targeting this service attachment.
	ConnectionType ConnectionType `protobuf:"varint,3,opt,name=connection_type,json=connectionType,proto3,enum=google.cloud.redis.cluster.v1.ConnectionType" json:"connection_type,omitempty"`
}

func (x *PscServiceAttachment) Reset() {
	*x = PscServiceAttachment{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PscServiceAttachment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PscServiceAttachment) ProtoMessage() {}

func (x *PscServiceAttachment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PscServiceAttachment.ProtoReflect.Descriptor instead.
func (*PscServiceAttachment) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{21}
}

func (x *PscServiceAttachment) GetServiceAttachment() string {
	if x != nil {
		return x.ServiceAttachment
	}
	return ""
}

func (x *PscServiceAttachment) GetConnectionType() ConnectionType {
	if x != nil {
		return x.ConnectionType
	}
	return ConnectionType_CONNECTION_TYPE_UNSPECIFIED
}

// Cross cluster replication config.
type CrossClusterReplicationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The role of the cluster in cross cluster replication.
	ClusterRole CrossClusterReplicationConfig_ClusterRole `protobuf:"varint,1,opt,name=cluster_role,json=clusterRole,proto3,enum=google.cloud.redis.cluster.v1.CrossClusterReplicationConfig_ClusterRole" json:"cluster_role,omitempty"`
	// Details of the primary cluster that is used as the replication source for
	// this secondary cluster.
	//
	// This field is only set for a secondary cluster.
	PrimaryCluster *CrossClusterReplicationConfig_RemoteCluster `protobuf:"bytes,2,opt,name=primary_cluster,json=primaryCluster,proto3" json:"primary_cluster,omitempty"`
	// List of secondary clusters that are replicating from this primary cluster.
	//
	// This field is only set for a primary cluster.
	SecondaryClusters []*CrossClusterReplicationConfig_RemoteCluster `protobuf:"bytes,3,rep,name=secondary_clusters,json=secondaryClusters,proto3" json:"secondary_clusters,omitempty"`
	// Output only. The last time cross cluster replication config was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. An output only view of all the member clusters participating
	// in the cross cluster replication. This view will be provided by every
	// member cluster irrespective of its cluster role(primary or secondary).
	//
	// A primary cluster can provide information about all the secondary clusters
	// replicating from it. However, a secondary cluster only knows about the
	// primary cluster from which it is replicating. However, for scenarios, where
	// the primary cluster is unavailable(e.g. regional outage), a GetCluster
	// request can be sent to any other member cluster and this field will list
	// all the member clusters participating in cross cluster replication.
	Membership *CrossClusterReplicationConfig_Membership `protobuf:"bytes,5,opt,name=membership,proto3" json:"membership,omitempty"`
}

func (x *CrossClusterReplicationConfig) Reset() {
	*x = CrossClusterReplicationConfig{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CrossClusterReplicationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CrossClusterReplicationConfig) ProtoMessage() {}

func (x *CrossClusterReplicationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CrossClusterReplicationConfig.ProtoReflect.Descriptor instead.
func (*CrossClusterReplicationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{22}
}

func (x *CrossClusterReplicationConfig) GetClusterRole() CrossClusterReplicationConfig_ClusterRole {
	if x != nil {
		return x.ClusterRole
	}
	return CrossClusterReplicationConfig_CLUSTER_ROLE_UNSPECIFIED
}

func (x *CrossClusterReplicationConfig) GetPrimaryCluster() *CrossClusterReplicationConfig_RemoteCluster {
	if x != nil {
		return x.PrimaryCluster
	}
	return nil
}

func (x *CrossClusterReplicationConfig) GetSecondaryClusters() []*CrossClusterReplicationConfig_RemoteCluster {
	if x != nil {
		return x.SecondaryClusters
	}
	return nil
}

func (x *CrossClusterReplicationConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CrossClusterReplicationConfig) GetMembership() *CrossClusterReplicationConfig_Membership {
	if x != nil {
		return x.Membership
	}
	return nil
}

// Maintenance policy per cluster.
type ClusterMaintenancePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time when the policy was created i.e. Maintenance Window
	// or Deny Period was assigned.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the policy was updated i.e. Maintenance Window
	// or Deny Period was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Maintenance window that is applied to resources covered by this
	// policy. Minimum 1. For the current version, the maximum number of
	// weekly_maintenance_window is expected to be one.
	WeeklyMaintenanceWindow []*ClusterWeeklyMaintenanceWindow `protobuf:"bytes,3,rep,name=weekly_maintenance_window,json=weeklyMaintenanceWindow,proto3" json:"weekly_maintenance_window,omitempty"`
}

func (x *ClusterMaintenancePolicy) Reset() {
	*x = ClusterMaintenancePolicy{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterMaintenancePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterMaintenancePolicy) ProtoMessage() {}

func (x *ClusterMaintenancePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterMaintenancePolicy.ProtoReflect.Descriptor instead.
func (*ClusterMaintenancePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{23}
}

func (x *ClusterMaintenancePolicy) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ClusterMaintenancePolicy) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ClusterMaintenancePolicy) GetWeeklyMaintenanceWindow() []*ClusterWeeklyMaintenanceWindow {
	if x != nil {
		return x.WeeklyMaintenanceWindow
	}
	return nil
}

// Time window specified for weekly operations.
type ClusterWeeklyMaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Allows to define schedule that runs specified day of the week.
	Day dayofweek.DayOfWeek `protobuf:"varint,1,opt,name=day,proto3,enum=google.type.DayOfWeek" json:"day,omitempty"`
	// Start time of the window in UTC.
	StartTime *timeofday.TimeOfDay `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *ClusterWeeklyMaintenanceWindow) Reset() {
	*x = ClusterWeeklyMaintenanceWindow{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterWeeklyMaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterWeeklyMaintenanceWindow) ProtoMessage() {}

func (x *ClusterWeeklyMaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterWeeklyMaintenanceWindow.ProtoReflect.Descriptor instead.
func (*ClusterWeeklyMaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{24}
}

func (x *ClusterWeeklyMaintenanceWindow) GetDay() dayofweek.DayOfWeek {
	if x != nil {
		return x.Day
	}
	return dayofweek.DayOfWeek(0)
}

func (x *ClusterWeeklyMaintenanceWindow) GetStartTime() *timeofday.TimeOfDay {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Upcoming maitenance schedule.
type ClusterMaintenanceSchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The start time of any upcoming scheduled maintenance for this
	// instance.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The end time of any upcoming scheduled maintenance for this
	// instance.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *ClusterMaintenanceSchedule) Reset() {
	*x = ClusterMaintenanceSchedule{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterMaintenanceSchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterMaintenanceSchedule) ProtoMessage() {}

func (x *ClusterMaintenanceSchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterMaintenanceSchedule.ProtoReflect.Descriptor instead.
func (*ClusterMaintenanceSchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{25}
}

func (x *ClusterMaintenanceSchedule) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ClusterMaintenanceSchedule) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type PscConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The network where the IP address of the discovery endpoint will
	// be reserved, in the form of
	// projects/{network_project}/global/networks/{network_id}.
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
}

func (x *PscConfig) Reset() {
	*x = PscConfig{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PscConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PscConfig) ProtoMessage() {}

func (x *PscConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PscConfig.ProtoReflect.Descriptor instead.
func (*PscConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{26}
}

func (x *PscConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

// Endpoints on each network, for Redis clients to connect to the cluster.
type DiscoveryEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Address of the exposed Redis endpoint used by clients to
	// connect to the service. The address could be either IP or hostname.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Output only. The port number of the exposed Redis endpoint.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. Customer configuration for where the endpoint is created and
	// accessed from.
	PscConfig *PscConfig `protobuf:"bytes,3,opt,name=psc_config,json=pscConfig,proto3" json:"psc_config,omitempty"`
}

func (x *DiscoveryEndpoint) Reset() {
	*x = DiscoveryEndpoint{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiscoveryEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEndpoint) ProtoMessage() {}

func (x *DiscoveryEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEndpoint.ProtoReflect.Descriptor instead.
func (*DiscoveryEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{27}
}

func (x *DiscoveryEndpoint) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *DiscoveryEndpoint) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *DiscoveryEndpoint) GetPscConfig() *PscConfig {
	if x != nil {
		return x.PscConfig
	}
	return nil
}

// Details of consumer resources in a PSC connection.
type PscConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The PSC connection id of the forwarding rule connected to the
	// service attachment.
	PscConnectionId string `protobuf:"bytes,1,opt,name=psc_connection_id,json=pscConnectionId,proto3" json:"psc_connection_id,omitempty"`
	// Required. The IP allocated on the consumer network for the PSC forwarding
	// rule.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Required. The URI of the consumer side forwarding rule.
	// Example:
	// projects/{projectNumOrId}/regions/us-east1/forwardingRules/{resourceId}.
	ForwardingRule string `protobuf:"bytes,3,opt,name=forwarding_rule,json=forwardingRule,proto3" json:"forwarding_rule,omitempty"`
	// Optional. Project ID of the consumer project where the forwarding rule is
	// created in.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The consumer network where the IP address resides, in the form of
	// projects/{project_id}/global/networks/{network_id}.
	Network string `protobuf:"bytes,5,opt,name=network,proto3" json:"network,omitempty"`
	// Required. The service attachment which is the target of the PSC connection,
	// in the form of
	// projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
	ServiceAttachment string `protobuf:"bytes,6,opt,name=service_attachment,json=serviceAttachment,proto3" json:"service_attachment,omitempty"`
	// Output only. The status of the PSC connection.
	// Please note that this value is updated periodically.
	// To get the latest status of a PSC connection, follow
	// https://cloud.google.com/vpc/docs/configure-private-service-connect-services#endpoint-details.
	PscConnectionStatus PscConnectionStatus `protobuf:"varint,8,opt,name=psc_connection_status,json=pscConnectionStatus,proto3,enum=google.cloud.redis.cluster.v1.PscConnectionStatus" json:"psc_connection_status,omitempty"`
	// Output only. Type of the PSC connection.
	ConnectionType ConnectionType `protobuf:"varint,10,opt,name=connection_type,json=connectionType,proto3,enum=google.cloud.redis.cluster.v1.ConnectionType" json:"connection_type,omitempty"`
}

func (x *PscConnection) Reset() {
	*x = PscConnection{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PscConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PscConnection) ProtoMessage() {}

func (x *PscConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PscConnection.ProtoReflect.Descriptor instead.
func (*PscConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{28}
}

func (x *PscConnection) GetPscConnectionId() string {
	if x != nil {
		return x.PscConnectionId
	}
	return ""
}

func (x *PscConnection) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *PscConnection) GetForwardingRule() string {
	if x != nil {
		return x.ForwardingRule
	}
	return ""
}

func (x *PscConnection) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *PscConnection) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *PscConnection) GetServiceAttachment() string {
	if x != nil {
		return x.ServiceAttachment
	}
	return ""
}

func (x *PscConnection) GetPscConnectionStatus() PscConnectionStatus {
	if x != nil {
		return x.PscConnectionStatus
	}
	return PscConnectionStatus_PSC_CONNECTION_STATUS_UNSPECIFIED
}

func (x *PscConnection) GetConnectionType() ConnectionType {
	if x != nil {
		return x.ConnectionType
	}
	return ConnectionType_CONNECTION_TYPE_UNSPECIFIED
}

// ClusterEndpoint consists of PSC connections that are created
// as a group in each VPC network for accessing the cluster. In each group,
// there shall be one connection for each service attachment in the cluster.
type ClusterEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A group of PSC connections. They are created in the same VPC network, one
	// for each service attachment in the cluster.
	Connections []*ConnectionDetail `protobuf:"bytes,1,rep,name=connections,proto3" json:"connections,omitempty"`
}

func (x *ClusterEndpoint) Reset() {
	*x = ClusterEndpoint{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterEndpoint) ProtoMessage() {}

func (x *ClusterEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterEndpoint.ProtoReflect.Descriptor instead.
func (*ClusterEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{29}
}

func (x *ClusterEndpoint) GetConnections() []*ConnectionDetail {
	if x != nil {
		return x.Connections
	}
	return nil
}

// Detailed information of each PSC connection.
type ConnectionDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A PSC connection to a cluster could either be created through Service
	// Connectivity Automation (auto-registered connection) during the cluster
	// creation, or it could be created by customer themselves (user-registered
	// connection).
	//
	// Types that are assignable to Connection:
	//
	//	*ConnectionDetail_PscAutoConnection
	//	*ConnectionDetail_PscConnection
	Connection isConnectionDetail_Connection `protobuf_oneof:"connection"`
}

func (x *ConnectionDetail) Reset() {
	*x = ConnectionDetail{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnectionDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionDetail) ProtoMessage() {}

func (x *ConnectionDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionDetail.ProtoReflect.Descriptor instead.
func (*ConnectionDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{30}
}

func (m *ConnectionDetail) GetConnection() isConnectionDetail_Connection {
	if m != nil {
		return m.Connection
	}
	return nil
}

func (x *ConnectionDetail) GetPscAutoConnection() *PscAutoConnection {
	if x, ok := x.GetConnection().(*ConnectionDetail_PscAutoConnection); ok {
		return x.PscAutoConnection
	}
	return nil
}

func (x *ConnectionDetail) GetPscConnection() *PscConnection {
	if x, ok := x.GetConnection().(*ConnectionDetail_PscConnection); ok {
		return x.PscConnection
	}
	return nil
}

type isConnectionDetail_Connection interface {
	isConnectionDetail_Connection()
}

type ConnectionDetail_PscAutoConnection struct {
	// Detailed information of a PSC connection that is created through
	// service connectivity automation.
	PscAutoConnection *PscAutoConnection `protobuf:"bytes,1,opt,name=psc_auto_connection,json=pscAutoConnection,proto3,oneof"`
}

type ConnectionDetail_PscConnection struct {
	// Detailed information of a PSC connection that is created by the customer
	// who owns the cluster.
	PscConnection *PscConnection `protobuf:"bytes,2,opt,name=psc_connection,json=pscConnection,proto3,oneof"`
}

func (*ConnectionDetail_PscAutoConnection) isConnectionDetail_Connection() {}

func (*ConnectionDetail_PscConnection) isConnectionDetail_Connection() {}

// Details of consumer resources in a PSC connection that is created through
// Service Connectivity Automation.
type PscAutoConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The PSC connection id of the forwarding rule connected to the
	// service attachment.
	PscConnectionId string `protobuf:"bytes,1,opt,name=psc_connection_id,json=pscConnectionId,proto3" json:"psc_connection_id,omitempty"`
	// Output only. The IP allocated on the consumer network for the PSC
	// forwarding rule.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Output only. The URI of the consumer side forwarding rule.
	// Example:
	// projects/{projectNumOrId}/regions/us-east1/forwardingRules/{resourceId}.
	ForwardingRule string `protobuf:"bytes,3,opt,name=forwarding_rule,json=forwardingRule,proto3" json:"forwarding_rule,omitempty"`
	// Required. The consumer project_id where the forwarding rule is created
	// from.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The consumer network where the IP address resides, in the form of
	// projects/{project_id}/global/networks/{network_id}.
	Network string `protobuf:"bytes,5,opt,name=network,proto3" json:"network,omitempty"`
	// Output only. The service attachment which is the target of the PSC
	// connection, in the form of
	// projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
	ServiceAttachment string `protobuf:"bytes,6,opt,name=service_attachment,json=serviceAttachment,proto3" json:"service_attachment,omitempty"`
	// Output only. The status of the PSC connection.
	// Please note that this value is updated periodically.
	// Please use Private Service Connect APIs for the latest status.
	PscConnectionStatus PscConnectionStatus `protobuf:"varint,8,opt,name=psc_connection_status,json=pscConnectionStatus,proto3,enum=google.cloud.redis.cluster.v1.PscConnectionStatus" json:"psc_connection_status,omitempty"`
	// Output only. Type of the PSC connection.
	ConnectionType ConnectionType `protobuf:"varint,9,opt,name=connection_type,json=connectionType,proto3,enum=google.cloud.redis.cluster.v1.ConnectionType" json:"connection_type,omitempty"`
}

func (x *PscAutoConnection) Reset() {
	*x = PscAutoConnection{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PscAutoConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PscAutoConnection) ProtoMessage() {}

func (x *PscAutoConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PscAutoConnection.ProtoReflect.Descriptor instead.
func (*PscAutoConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{31}
}

func (x *PscAutoConnection) GetPscConnectionId() string {
	if x != nil {
		return x.PscConnectionId
	}
	return ""
}

func (x *PscAutoConnection) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *PscAutoConnection) GetForwardingRule() string {
	if x != nil {
		return x.ForwardingRule
	}
	return ""
}

func (x *PscAutoConnection) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *PscAutoConnection) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *PscAutoConnection) GetServiceAttachment() string {
	if x != nil {
		return x.ServiceAttachment
	}
	return ""
}

func (x *PscAutoConnection) GetPscConnectionStatus() PscConnectionStatus {
	if x != nil {
		return x.PscConnectionStatus
	}
	return PscConnectionStatus_PSC_CONNECTION_STATUS_UNSPECIFIED
}

func (x *PscAutoConnection) GetConnectionType() ConnectionType {
	if x != nil {
		return x.ConnectionType
	}
	return ConnectionType_CONNECTION_TYPE_UNSPECIFIED
}

// Pre-defined metadata fields.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{32}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Redis cluster certificate authority
type CertificateAuthority struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// server ca information
	//
	// Types that are assignable to ServerCa:
	//
	//	*CertificateAuthority_ManagedServerCa
	ServerCa isCertificateAuthority_ServerCa `protobuf_oneof:"server_ca"`
	// Identifier. Unique name of the resource in this scope including project,
	// location and cluster using the form:
	//
	//	`projects/{project}/locations/{location}/clusters/{cluster}/certificateAuthority`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CertificateAuthority) Reset() {
	*x = CertificateAuthority{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateAuthority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority) ProtoMessage() {}

func (x *CertificateAuthority) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority.ProtoReflect.Descriptor instead.
func (*CertificateAuthority) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{33}
}

func (m *CertificateAuthority) GetServerCa() isCertificateAuthority_ServerCa {
	if m != nil {
		return m.ServerCa
	}
	return nil
}

func (x *CertificateAuthority) GetManagedServerCa() *CertificateAuthority_ManagedCertificateAuthority {
	if x, ok := x.GetServerCa().(*CertificateAuthority_ManagedServerCa); ok {
		return x.ManagedServerCa
	}
	return nil
}

func (x *CertificateAuthority) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isCertificateAuthority_ServerCa interface {
	isCertificateAuthority_ServerCa()
}

type CertificateAuthority_ManagedServerCa struct {
	ManagedServerCa *CertificateAuthority_ManagedCertificateAuthority `protobuf:"bytes,1,opt,name=managed_server_ca,json=managedServerCa,proto3,oneof"`
}

func (*CertificateAuthority_ManagedServerCa) isCertificateAuthority_ServerCa() {}

// Configuration of the persistence functionality.
type ClusterPersistenceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The mode of persistence.
	Mode ClusterPersistenceConfig_PersistenceMode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.redis.cluster.v1.ClusterPersistenceConfig_PersistenceMode" json:"mode,omitempty"`
	// Optional. RDB configuration. This field will be ignored if mode is not RDB.
	RdbConfig *ClusterPersistenceConfig_RDBConfig `protobuf:"bytes,2,opt,name=rdb_config,json=rdbConfig,proto3" json:"rdb_config,omitempty"`
	// Optional. AOF configuration. This field will be ignored if mode is not AOF.
	AofConfig *ClusterPersistenceConfig_AOFConfig `protobuf:"bytes,3,opt,name=aof_config,json=aofConfig,proto3" json:"aof_config,omitempty"`
}

func (x *ClusterPersistenceConfig) Reset() {
	*x = ClusterPersistenceConfig{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterPersistenceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterPersistenceConfig) ProtoMessage() {}

func (x *ClusterPersistenceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterPersistenceConfig.ProtoReflect.Descriptor instead.
func (*ClusterPersistenceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{34}
}

func (x *ClusterPersistenceConfig) GetMode() ClusterPersistenceConfig_PersistenceMode {
	if x != nil {
		return x.Mode
	}
	return ClusterPersistenceConfig_PERSISTENCE_MODE_UNSPECIFIED
}

func (x *ClusterPersistenceConfig) GetRdbConfig() *ClusterPersistenceConfig_RDBConfig {
	if x != nil {
		return x.RdbConfig
	}
	return nil
}

func (x *ClusterPersistenceConfig) GetAofConfig() *ClusterPersistenceConfig_AOFConfig {
	if x != nil {
		return x.AofConfig
	}
	return nil
}

// Zone distribution config for allocation of cluster resources.
type ZoneDistributionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The mode of zone distribution. Defaults to MULTI_ZONE, when not
	// specified.
	Mode ZoneDistributionConfig_ZoneDistributionMode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.redis.cluster.v1.ZoneDistributionConfig_ZoneDistributionMode" json:"mode,omitempty"`
	// Optional. When SINGLE ZONE distribution is selected, zone field would be
	// used to allocate all resources in that zone. This is not applicable to
	// MULTI_ZONE, and would be ignored for MULTI_ZONE clusters.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
}

func (x *ZoneDistributionConfig) Reset() {
	*x = ZoneDistributionConfig{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ZoneDistributionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZoneDistributionConfig) ProtoMessage() {}

func (x *ZoneDistributionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZoneDistributionConfig.ProtoReflect.Descriptor instead.
func (*ZoneDistributionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{35}
}

func (x *ZoneDistributionConfig) GetMode() ZoneDistributionConfig_ZoneDistributionMode {
	if x != nil {
		return x.Mode
	}
	return ZoneDistributionConfig_ZONE_DISTRIBUTION_MODE_UNSPECIFIED
}

func (x *ZoneDistributionConfig) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// Request for rescheduling a cluster maintenance.
type RescheduleClusterMaintenanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Redis Cluster instance resource name using the form:
	//
	//	`projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`
	//
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. If reschedule type is SPECIFIC_TIME, must set up schedule_time as
	// well.
	RescheduleType RescheduleClusterMaintenanceRequest_RescheduleType `protobuf:"varint,2,opt,name=reschedule_type,json=rescheduleType,proto3,enum=google.cloud.redis.cluster.v1.RescheduleClusterMaintenanceRequest_RescheduleType" json:"reschedule_type,omitempty"`
	// Optional. Timestamp when the maintenance shall be rescheduled to if
	// reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
	// example `2012-11-15T16:19:00.094Z`.
	ScheduleTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=schedule_time,json=scheduleTime,proto3" json:"schedule_time,omitempty"`
}

func (x *RescheduleClusterMaintenanceRequest) Reset() {
	*x = RescheduleClusterMaintenanceRequest{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RescheduleClusterMaintenanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RescheduleClusterMaintenanceRequest) ProtoMessage() {}

func (x *RescheduleClusterMaintenanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RescheduleClusterMaintenanceRequest.ProtoReflect.Descriptor instead.
func (*RescheduleClusterMaintenanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{36}
}

func (x *RescheduleClusterMaintenanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RescheduleClusterMaintenanceRequest) GetRescheduleType() RescheduleClusterMaintenanceRequest_RescheduleType {
	if x != nil {
		return x.RescheduleType
	}
	return RescheduleClusterMaintenanceRequest_RESCHEDULE_TYPE_UNSPECIFIED
}

func (x *RescheduleClusterMaintenanceRequest) GetScheduleTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ScheduleTime
	}
	return nil
}

// EncryptionInfo describes the encryption information of a cluster or a backup.
type EncryptionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Type of encryption.
	EncryptionType EncryptionInfo_Type `protobuf:"varint,1,opt,name=encryption_type,json=encryptionType,proto3,enum=google.cloud.redis.cluster.v1.EncryptionInfo_Type" json:"encryption_type,omitempty"`
	// Output only. KMS key versions that are being used to protect the data
	// at-rest.
	KmsKeyVersions []string `protobuf:"bytes,2,rep,name=kms_key_versions,json=kmsKeyVersions,proto3" json:"kms_key_versions,omitempty"`
	// Output only. The state of the primary version of the KMS key perceived by
	// the system. This field is not populated in backups.
	KmsKeyPrimaryState EncryptionInfo_KmsKeyState `protobuf:"varint,3,opt,name=kms_key_primary_state,json=kmsKeyPrimaryState,proto3,enum=google.cloud.redis.cluster.v1.EncryptionInfo_KmsKeyState" json:"kms_key_primary_state,omitempty"`
	// Output only. The most recent time when the encryption info was updated.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
}

func (x *EncryptionInfo) Reset() {
	*x = EncryptionInfo{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EncryptionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptionInfo) ProtoMessage() {}

func (x *EncryptionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptionInfo.ProtoReflect.Descriptor instead.
func (*EncryptionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{37}
}

func (x *EncryptionInfo) GetEncryptionType() EncryptionInfo_Type {
	if x != nil {
		return x.EncryptionType
	}
	return EncryptionInfo_TYPE_UNSPECIFIED
}

func (x *EncryptionInfo) GetKmsKeyVersions() []string {
	if x != nil {
		return x.KmsKeyVersions
	}
	return nil
}

func (x *EncryptionInfo) GetKmsKeyPrimaryState() EncryptionInfo_KmsKeyState {
	if x != nil {
		return x.KmsKeyPrimaryState
	}
	return EncryptionInfo_KMS_KEY_STATE_UNSPECIFIED
}

func (x *EncryptionInfo) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

// Represents additional information about the state of the cluster.
type Cluster_StateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Info:
	//
	//	*Cluster_StateInfo_UpdateInfo_
	Info isCluster_StateInfo_Info `protobuf_oneof:"info"`
}

func (x *Cluster_StateInfo) Reset() {
	*x = Cluster_StateInfo{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_StateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_StateInfo) ProtoMessage() {}

func (x *Cluster_StateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_StateInfo.ProtoReflect.Descriptor instead.
func (*Cluster_StateInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{16, 0}
}

func (m *Cluster_StateInfo) GetInfo() isCluster_StateInfo_Info {
	if m != nil {
		return m.Info
	}
	return nil
}

func (x *Cluster_StateInfo) GetUpdateInfo() *Cluster_StateInfo_UpdateInfo {
	if x, ok := x.GetInfo().(*Cluster_StateInfo_UpdateInfo_); ok {
		return x.UpdateInfo
	}
	return nil
}

type isCluster_StateInfo_Info interface {
	isCluster_StateInfo_Info()
}

type Cluster_StateInfo_UpdateInfo_ struct {
	// Describes ongoing update on the cluster when cluster state is UPDATING.
	UpdateInfo *Cluster_StateInfo_UpdateInfo `protobuf:"bytes,1,opt,name=update_info,json=updateInfo,proto3,oneof"`
}

func (*Cluster_StateInfo_UpdateInfo_) isCluster_StateInfo_Info() {}

// Backups stored in Cloud Storage buckets.
// The Cloud Storage buckets need to be the same region as the clusters.
type Cluster_GcsBackupSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. URIs of the GCS objects to import.
	// Example: gs://bucket1/object1, gs://bucket2/folder2/object2
	Uris []string `protobuf:"bytes,1,rep,name=uris,proto3" json:"uris,omitempty"`
}

func (x *Cluster_GcsBackupSource) Reset() {
	*x = Cluster_GcsBackupSource{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_GcsBackupSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_GcsBackupSource) ProtoMessage() {}

func (x *Cluster_GcsBackupSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_GcsBackupSource.ProtoReflect.Descriptor instead.
func (*Cluster_GcsBackupSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{16, 1}
}

func (x *Cluster_GcsBackupSource) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

// Backups that generated and managed by memorystore.
type Cluster_ManagedBackupSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Example:
	// //redis.googleapis.com/projects/{project}/locations/{location}/backupCollections/{collection}/backups/{backup}
	// A shorter version (without the prefix) of the backup name is also
	// supported, like
	// projects/{project}/locations/{location}/backupCollections/{collection}/backups/{backup_id}
	// In this case, it assumes the backup is under redis.googleapis.com.
	Backup string `protobuf:"bytes,1,opt,name=backup,proto3" json:"backup,omitempty"`
}

func (x *Cluster_ManagedBackupSource) Reset() {
	*x = Cluster_ManagedBackupSource{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_ManagedBackupSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_ManagedBackupSource) ProtoMessage() {}

func (x *Cluster_ManagedBackupSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_ManagedBackupSource.ProtoReflect.Descriptor instead.
func (*Cluster_ManagedBackupSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{16, 2}
}

func (x *Cluster_ManagedBackupSource) GetBackup() string {
	if x != nil {
		return x.Backup
	}
	return ""
}

// Represents information about an updating cluster.
type Cluster_StateInfo_UpdateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Target number of shards for redis cluster
	TargetShardCount *int32 `protobuf:"varint,1,opt,name=target_shard_count,json=targetShardCount,proto3,oneof" json:"target_shard_count,omitempty"`
	// Target number of replica nodes per shard.
	TargetReplicaCount *int32 `protobuf:"varint,2,opt,name=target_replica_count,json=targetReplicaCount,proto3,oneof" json:"target_replica_count,omitempty"`
}

func (x *Cluster_StateInfo_UpdateInfo) Reset() {
	*x = Cluster_StateInfo_UpdateInfo{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster_StateInfo_UpdateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_StateInfo_UpdateInfo) ProtoMessage() {}

func (x *Cluster_StateInfo_UpdateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_StateInfo_UpdateInfo.ProtoReflect.Descriptor instead.
func (*Cluster_StateInfo_UpdateInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{16, 0, 0}
}

func (x *Cluster_StateInfo_UpdateInfo) GetTargetShardCount() int32 {
	if x != nil && x.TargetShardCount != nil {
		return *x.TargetShardCount
	}
	return 0
}

func (x *Cluster_StateInfo_UpdateInfo) GetTargetReplicaCount() int32 {
	if x != nil && x.TargetReplicaCount != nil {
		return *x.TargetReplicaCount
	}
	return 0
}

// This schedule allows the backup to be triggered at a fixed frequency
// (currently only daily is supported).
type AutomatedBackupConfig_FixedFrequencySchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The start time of every automated backup in UTC. It must be set
	// to the start of an hour. This field is required.
	StartTime *timeofday.TimeOfDay `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3,oneof" json:"start_time,omitempty"`
}

func (x *AutomatedBackupConfig_FixedFrequencySchedule) Reset() {
	*x = AutomatedBackupConfig_FixedFrequencySchedule{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomatedBackupConfig_FixedFrequencySchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomatedBackupConfig_FixedFrequencySchedule) ProtoMessage() {}

func (x *AutomatedBackupConfig_FixedFrequencySchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomatedBackupConfig_FixedFrequencySchedule.ProtoReflect.Descriptor instead.
func (*AutomatedBackupConfig_FixedFrequencySchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{17, 0}
}

func (x *AutomatedBackupConfig_FixedFrequencySchedule) GetStartTime() *timeofday.TimeOfDay {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Details of the remote cluster associated with this cluster in a cross
// cluster replication setup.
type CrossClusterReplicationConfig_RemoteCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource path of the remote cluster in
	// the format: projects/<project>/locations/<region>/clusters/<cluster-id>
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Output only. The unique identifier of the remote cluster.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *CrossClusterReplicationConfig_RemoteCluster) Reset() {
	*x = CrossClusterReplicationConfig_RemoteCluster{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CrossClusterReplicationConfig_RemoteCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CrossClusterReplicationConfig_RemoteCluster) ProtoMessage() {}

func (x *CrossClusterReplicationConfig_RemoteCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CrossClusterReplicationConfig_RemoteCluster.ProtoReflect.Descriptor instead.
func (*CrossClusterReplicationConfig_RemoteCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{22, 0}
}

func (x *CrossClusterReplicationConfig_RemoteCluster) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *CrossClusterReplicationConfig_RemoteCluster) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// An output only view of all the member clusters participating in the cross
// cluster replication.
type CrossClusterReplicationConfig_Membership struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The primary cluster that acts as the source of replication
	// for the secondary clusters.
	PrimaryCluster *CrossClusterReplicationConfig_RemoteCluster `protobuf:"bytes,1,opt,name=primary_cluster,json=primaryCluster,proto3" json:"primary_cluster,omitempty"`
	// Output only. The list of secondary clusters replicating from the primary
	// cluster.
	SecondaryClusters []*CrossClusterReplicationConfig_RemoteCluster `protobuf:"bytes,2,rep,name=secondary_clusters,json=secondaryClusters,proto3" json:"secondary_clusters,omitempty"`
}

func (x *CrossClusterReplicationConfig_Membership) Reset() {
	*x = CrossClusterReplicationConfig_Membership{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CrossClusterReplicationConfig_Membership) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CrossClusterReplicationConfig_Membership) ProtoMessage() {}

func (x *CrossClusterReplicationConfig_Membership) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CrossClusterReplicationConfig_Membership.ProtoReflect.Descriptor instead.
func (*CrossClusterReplicationConfig_Membership) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{22, 1}
}

func (x *CrossClusterReplicationConfig_Membership) GetPrimaryCluster() *CrossClusterReplicationConfig_RemoteCluster {
	if x != nil {
		return x.PrimaryCluster
	}
	return nil
}

func (x *CrossClusterReplicationConfig_Membership) GetSecondaryClusters() []*CrossClusterReplicationConfig_RemoteCluster {
	if x != nil {
		return x.SecondaryClusters
	}
	return nil
}

type CertificateAuthority_ManagedCertificateAuthority struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The PEM encoded CA certificate chains for redis managed
	// server authentication
	CaCerts []*CertificateAuthority_ManagedCertificateAuthority_CertChain `protobuf:"bytes,1,rep,name=ca_certs,json=caCerts,proto3" json:"ca_certs,omitempty"`
}

func (x *CertificateAuthority_ManagedCertificateAuthority) Reset() {
	*x = CertificateAuthority_ManagedCertificateAuthority{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateAuthority_ManagedCertificateAuthority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_ManagedCertificateAuthority) ProtoMessage() {}

func (x *CertificateAuthority_ManagedCertificateAuthority) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_ManagedCertificateAuthority.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_ManagedCertificateAuthority) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{33, 0}
}

func (x *CertificateAuthority_ManagedCertificateAuthority) GetCaCerts() []*CertificateAuthority_ManagedCertificateAuthority_CertChain {
	if x != nil {
		return x.CaCerts
	}
	return nil
}

type CertificateAuthority_ManagedCertificateAuthority_CertChain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The certificates that form the CA chain, from leaf to root order.
	Certificates []string `protobuf:"bytes,1,rep,name=certificates,proto3" json:"certificates,omitempty"`
}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) Reset() {
	*x = CertificateAuthority_ManagedCertificateAuthority_CertChain{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_ManagedCertificateAuthority_CertChain) ProtoMessage() {}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_ManagedCertificateAuthority_CertChain.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_ManagedCertificateAuthority_CertChain) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{33, 0, 0}
}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) GetCertificates() []string {
	if x != nil {
		return x.Certificates
	}
	return nil
}

// Configuration of the RDB based persistence.
type ClusterPersistenceConfig_RDBConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Period between RDB snapshots.
	RdbSnapshotPeriod ClusterPersistenceConfig_RDBConfig_SnapshotPeriod `protobuf:"varint,1,opt,name=rdb_snapshot_period,json=rdbSnapshotPeriod,proto3,enum=google.cloud.redis.cluster.v1.ClusterPersistenceConfig_RDBConfig_SnapshotPeriod" json:"rdb_snapshot_period,omitempty"`
	// Optional. The time that the first snapshot was/will be attempted, and to
	// which future snapshots will be aligned. If not provided, the current time
	// will be used.
	RdbSnapshotStartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=rdb_snapshot_start_time,json=rdbSnapshotStartTime,proto3" json:"rdb_snapshot_start_time,omitempty"`
}

func (x *ClusterPersistenceConfig_RDBConfig) Reset() {
	*x = ClusterPersistenceConfig_RDBConfig{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterPersistenceConfig_RDBConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterPersistenceConfig_RDBConfig) ProtoMessage() {}

func (x *ClusterPersistenceConfig_RDBConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterPersistenceConfig_RDBConfig.ProtoReflect.Descriptor instead.
func (*ClusterPersistenceConfig_RDBConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{34, 0}
}

func (x *ClusterPersistenceConfig_RDBConfig) GetRdbSnapshotPeriod() ClusterPersistenceConfig_RDBConfig_SnapshotPeriod {
	if x != nil {
		return x.RdbSnapshotPeriod
	}
	return ClusterPersistenceConfig_RDBConfig_SNAPSHOT_PERIOD_UNSPECIFIED
}

func (x *ClusterPersistenceConfig_RDBConfig) GetRdbSnapshotStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RdbSnapshotStartTime
	}
	return nil
}

// Configuration of the AOF based persistence.
type ClusterPersistenceConfig_AOFConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. fsync configuration.
	AppendFsync ClusterPersistenceConfig_AOFConfig_AppendFsync `protobuf:"varint,1,opt,name=append_fsync,json=appendFsync,proto3,enum=google.cloud.redis.cluster.v1.ClusterPersistenceConfig_AOFConfig_AppendFsync" json:"append_fsync,omitempty"`
}

func (x *ClusterPersistenceConfig_AOFConfig) Reset() {
	*x = ClusterPersistenceConfig_AOFConfig{}
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterPersistenceConfig_AOFConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterPersistenceConfig_AOFConfig) ProtoMessage() {}

func (x *ClusterPersistenceConfig_AOFConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterPersistenceConfig_AOFConfig.ProtoReflect.Descriptor instead.
func (*ClusterPersistenceConfig_AOFConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP(), []int{34, 1}
}

func (x *ClusterPersistenceConfig_AOFConfig) GetAppendFsync() ClusterPersistenceConfig_AOFConfig_AppendFsync {
	if x != nil {
		return x.AppendFsync
	}
	return ClusterPersistenceConfig_AOFConfig_APPEND_FSYNC_UNSPECIFIED
}

var File_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto protoreflect.FileDescriptor

var file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x64, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x73, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61,
	0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x79, 0x6f, 0x66, 0x77, 0x65, 0x65, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xe3, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22,
	0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x45, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x94, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xa4, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x08, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xbe, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x45, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x4d, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6f, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x6e, 0x0a, 0x25, 0x47, 0x65, 0x74, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27,
	0x12, 0x25, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc9, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x12, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x5f, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1d, 0x12, 0x1b, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa0, 0x01, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x07, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x4b, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x72, 0x65, 0x64, 0x69, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x13,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x72, 0x65, 0x64, 0x69, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x7e, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1f, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb7, 0x01, 0x0a, 0x14, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x03, 0x74,
	0x74, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x25, 0x0a,
	0x09, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49,
	0x64, 0x88, 0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f,
	0x69, 0x64, 0x22, 0x80, 0x1b, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x5c,
	0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x22, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x47, 0x63, 0x73, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x75, 0x0a, 0x15,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73,
	0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x13,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69,
	0x64, 0x12, 0x2d, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52,
	0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01,
	0x12, 0x64, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69,
	0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x71, 0x0a, 0x17, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x21, 0x0a, 0x07, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x67, 0x62, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x02, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0b,
	0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x4e, 0x0a, 0x0b, 0x70, 0x73, 0x63, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69,
	0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x73, 0x63,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x73, 0x63,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x66, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x10,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12,
	0x5a, 0x0a, 0x0f, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x73, 0x63,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x54, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x49, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x6b, 0x0a, 0x12,
	0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x62, 0x0a, 0x0d, 0x72, 0x65, 0x64,
	0x69, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x72, 0x65, 0x64, 0x69, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x30, 0x0a,
	0x0f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62,
	0x18, 0x16, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x04, 0x52, 0x0d, 0x70,
	0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x88, 0x01, 0x01, 0x12,
	0x74, 0x0a, 0x18, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x7a,
	0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8a, 0x01, 0x0a, 0x20, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x1d, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x48, 0x0a, 0x1b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x19, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x05, 0x52, 0x19,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x70, 0x0a, 0x12,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x06, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x88, 0x01, 0x01, 0x12, 0x76,
	0x0a, 0x14, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69,
	0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x07, 0x52, 0x13,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x70, 0x0a, 0x17, 0x70, 0x73, 0x63, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x1e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x73, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x15, 0x70, 0x73, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x60, 0x0a, 0x11, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x24, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x62, 0x0a, 0x11, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x27, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x27,
	0x0a, 0x25, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x08, 0x52, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x47,
	0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x28, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x48, 0x09, 0x52, 0x06, 0x6b, 0x6d,
	0x73, 0x4b, 0x65, 0x79, 0x88, 0x01, 0x01, 0x12, 0x71, 0x0a, 0x17, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x15, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b, 0x0a, 0x0f, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x2b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x9c, 0x02, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5e, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0xa6, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x31, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x00, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x68, 0x61, 0x72, 0x64, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x42, 0x15,
	0x0a, 0x13, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x06,
	0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x2a, 0x0a, 0x0f, 0x47, 0x63, 0x73, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x72, 0x69,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x75, 0x72,
	0x69, 0x73, 0x1a, 0x32, 0x0a, 0x13, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x1a, 0x3f, 0x0a, 0x11, 0x52, 0x65, 0x64, 0x69, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x3a, 0x70, 0xea,
	0x41, 0x6d, 0x0a, 0x1c, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2a, 0x08, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x32, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42,
	0x10, 0x0a, 0x0e, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x42,
	0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42,
	0x12, 0x0a, 0x10, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x67, 0x62, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x6d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x6b, 0x6d,
	0x73, 0x5f, 0x6b, 0x65, 0x79, 0x22, 0xca, 0x04, 0x0a, 0x15, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x8c, 0x01, 0x0a, 0x18, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x46, 0x69, 0x78, 0x65, 0x64, 0x46, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x16, 0x66, 0x69, 0x78, 0x65, 0x64, 0x46, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x81,
	0x01, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x41, 0x0a, 0x09, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x88, 0x01, 0x01, 0x1a, 0x68, 0x0a, 0x16, 0x46, 0x69, 0x78, 0x65, 0x64, 0x46, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x3f, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x48, 0x00, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x22,
	0x57, 0x0a, 0x13, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41,
	0x54, 0x45, 0x44, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45,
	0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x42, 0x0a, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x9e, 0x03, 0x0a, 0x10, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x2c, 0x0a, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02,
	0x08, 0x01, 0x52, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x69, 0x64, 0x12, 0x3e,
	0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x24, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x42,
	0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x12, 0x1d, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x03, 0x75, 0x69,
	0x64, 0x3a, 0x9f, 0x01, 0xea, 0x41, 0x9b, 0x01, 0x0a, 0x25, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x11,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x32, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xad, 0x09, 0x0a, 0x06, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x07, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x03, 0xfa,
	0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2c, 0x0a, 0x0b, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b,
	0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x0a, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x55, 0x69, 0x64, 0x12, 0x2d, 0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a,
	0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b,
	0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x56, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x5b, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73,
	0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x1d, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41,
	0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x03, 0x75, 0x69, 0x64, 0x22, 0x47,
	0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17,
	0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x4e, 0x5f,
	0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x55, 0x54, 0x4f,
	0x4d, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x22, 0x55, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x92,
	0x01, 0xea, 0x41, 0x8e, 0x01, 0x0a, 0x1b, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x12, 0x5e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x7d, 0x2a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x32, 0x06, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x22, 0x94, 0x01, 0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x46, 0x69,
	0x6c, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73,
	0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xa7, 0x01, 0x0a, 0x14, 0x50,
	0x73, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x22, 0xed, 0x07, 0x0a, 0x1d, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6b, 0x0a, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69,
	0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x6f,
	0x73, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x6f, 0x6c, 0x65, 0x12, 0x73, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69,
	0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x6f,
	0x73, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72,
	0x79, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x79, 0x0a, 0x12, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x11, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6c, 0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x1a, 0x63, 0x0a, 0x0d, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x64, 0x69,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x1a, 0x86, 0x02, 0x0a, 0x0a, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x78, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x6d, 0x61,
	0x72, 0x79, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x7e, 0x0a, 0x12, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64,
	0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x6f, 0x73, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x22, 0x51, 0x0a, 0x0b, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x6f, 0x6c, 0x65,
	0x12, 0x1c, 0x0a, 0x18, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x52, 0x4f, 0x4c, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08,
	0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49, 0x4d,
	0x41, 0x52, 0x59, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x41,
	0x52, 0x59, 0x10, 0x03, 0x22, 0x99, 0x02, 0x0a, 0x18, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x79, 0x0a, 0x19, 0x77, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x5f,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x57, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x17, 0x77, 0x65, 0x65, 0x6b, 0x6c, 0x79, 0x4d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x22, 0x81, 0x01, 0x0a, 0x1e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x57, 0x65, 0x65, 0x6b,
	0x6c, 0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x12, 0x28, 0x0a, 0x03, 0x64, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44,
	0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x52, 0x03, 0x64, 0x61, 0x79, 0x12, 0x35, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x98, 0x01, 0x0a, 0x1a, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0x2a, 0x0a, 0x09, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x99, 0x01, 0x0a, 0x11,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x17, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x70, 0x73, 0x63,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64,
	0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x73,
	0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x73,
	0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd0, 0x04, 0x0a, 0x0d, 0x50, 0x73, 0x63, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x73, 0x63,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x73, 0x63, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x07, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x02,
	0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x02, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x56, 0x0a, 0x0f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x72, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x40, 0x0a,
	0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x5f, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x6b, 0x0a, 0x15, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5b, 0x0a,
	0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22, 0x64, 0x0a, 0x0f, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x51, 0x0a,
	0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xdb, 0x01, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x62, 0x0a, 0x13, 0x70, 0x73, 0x63, 0x5f, 0x61, 0x75, 0x74,
	0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x73, 0x63, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x70, 0x73, 0x63, 0x41, 0x75, 0x74, 0x6f, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0e, 0x70, 0x73, 0x63,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0d, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x0c, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd4,
	0x04, 0x0a, 0x11, 0x50, 0x73, 0x63, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08,
	0x02, 0x08, 0x02, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x56, 0x0a, 0x0f,
	0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x75, 0x6c, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5f, 0x0a, 0x12, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6b, 0x0a, 0x15, 0x70,
	0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x73, 0x63, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x13, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5b, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12,
	0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xb3, 0x04,
	0x0a, 0x14, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x7d, 0x0a, 0x11, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x61, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0xc4,
	0x01, 0x0a, 0x1b, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x74,
	0x0a, 0x08, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x07, 0x63, 0x61, 0x43,
	0x65, 0x72, 0x74, 0x73, 0x1a, 0x2f, 0x0a, 0x09, 0x43, 0x65, 0x72, 0x74, 0x43, 0x68, 0x61, 0x69,
	0x6e, 0x12, 0x22, 0x0a, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x73, 0x3a, 0xae, 0x01, 0xea, 0x41, 0xaa, 0x01, 0x0a, 0x29, 0x72, 0x65,
	0x64, 0x69, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2a, 0x16, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x32, 0x14, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x42, 0x0b, 0x0a, 0x09, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x5f, 0x63, 0x61, 0x22, 0xda, 0x07, 0x0a, 0x18, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50,
	0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x60, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6d, 0x6f,
	0x64, 0x65, 0x12, 0x65, 0x0a, 0x0a, 0x72, 0x64, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x65,
	0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x52, 0x44, 0x42, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x64, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x0a, 0x61, 0x6f, 0x66,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64,
	0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x4f, 0x46, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x61, 0x6f, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x1a, 0xe4, 0x02, 0x0a, 0x09, 0x52, 0x44, 0x42, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x85,
	0x01, 0x0a, 0x13, 0x72, 0x64, 0x62, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69,
	0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x44, 0x42, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x11, 0x72, 0x64, 0x62, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x56, 0x0a, 0x17, 0x72, 0x64, 0x62, 0x5f, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x72, 0x64, 0x62, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x77,
	0x0a, 0x0e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64,
	0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x5f, 0x50, 0x45, 0x52,
	0x49, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x4e, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x49, 0x58, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x02, 0x12, 0x10,
	0x0a, 0x0c, 0x54, 0x57, 0x45, 0x4c, 0x56, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x03,
	0x12, 0x15, 0x0a, 0x11, 0x54, 0x57, 0x45, 0x4e, 0x54, 0x59, 0x5f, 0x46, 0x4f, 0x55, 0x52, 0x5f,
	0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x04, 0x1a, 0xd1, 0x01, 0x0a, 0x09, 0x41, 0x4f, 0x46, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x75, 0x0a, 0x0c, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x5f,
	0x66, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73,
	0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x4f, 0x46, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41,
	0x70, 0x70, 0x65, 0x6e, 0x64, 0x46, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x46, 0x73, 0x79, 0x6e, 0x63, 0x22, 0x4d, 0x0a, 0x0b,
	0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x46, 0x73, 0x79, 0x6e, 0x63, 0x12, 0x1c, 0x0a, 0x18, 0x41,
	0x50, 0x50, 0x45, 0x4e, 0x44, 0x5f, 0x46, 0x53, 0x59, 0x4e, 0x43, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x4e, 0x4f, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x56, 0x45, 0x52, 0x59, 0x53, 0x45, 0x43, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x10, 0x03, 0x22, 0x53, 0x0a, 0x0f, 0x50,
	0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x20,
	0x0a, 0x1c, 0x50, 0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x4d, 0x4f,
	0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x07,
	0x0a, 0x03, 0x52, 0x44, 0x42, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4f, 0x46, 0x10, 0x03,
	0x22, 0xf7, 0x01, 0x0a, 0x16, 0x5a, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x63, 0x0a, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x44, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x22, 0x5f, 0x0a, 0x14, 0x5a, 0x6f, 0x6e,
	0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x26, 0x0a, 0x22, 0x5a, 0x4f, 0x4e, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x52, 0x49,
	0x42, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x55, 0x4c,
	0x54, 0x49, 0x5f, 0x5a, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x49, 0x4e,
	0x47, 0x4c, 0x45, 0x5f, 0x5a, 0x4f, 0x4e, 0x45, 0x10, 0x02, 0x22, 0xfb, 0x02, 0x0a, 0x23, 0x52,
	0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x7f, 0x0a, 0x0f,
	0x72, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72,
	0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x44, 0x0a,
	0x0d, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x53, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x53, 0x43, 0x48, 0x45, 0x44,
	0x55, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4d, 0x4d, 0x45, 0x44, 0x49,
	0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x43, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x03, 0x22, 0xbe, 0x05, 0x0a, 0x0e, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x60, 0x0a, 0x0f, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a,
	0x10, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b,
	0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x6b, 0x6d, 0x73, 0x4b, 0x65,
	0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x71, 0x0a, 0x15, 0x6b, 0x6d, 0x73,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79,
	0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x49, 0x0a, 0x10,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x5c, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f,
	0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52,
	0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0xd1, 0x01, 0x0a, 0x0b, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x4b, 0x4d, 0x53, 0x5f, 0x4b, 0x45, 0x59,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x45, 0x53, 0x54, 0x52, 0x4f,
	0x59, 0x45, 0x44, 0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x45, 0x53, 0x54, 0x52, 0x4f, 0x59,
	0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x20, 0x0a, 0x1c,
	0x45, 0x4b, 0x4d, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x55, 0x4e, 0x52, 0x45, 0x41, 0x43, 0x48, 0x41,
	0x42, 0x4c, 0x45, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x14,
	0x0a, 0x10, 0x42, 0x49, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c,
	0x45, 0x44, 0x10, 0x07, 0x12, 0x13, 0x0a, 0x0f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f,
	0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x10, 0x08, 0x2a, 0x83, 0x01, 0x0a, 0x13, 0x50, 0x73,
	0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x25, 0x0a, 0x21, 0x50, 0x53, 0x43, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x50, 0x53, 0x43, 0x5f,
	0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55,
	0x53, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x50, 0x53,
	0x43, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x55, 0x53, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x02, 0x2a,
	0x5e, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x16, 0x0a, 0x12, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x41, 0x4d,
	0x5f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x55, 0x54, 0x48, 0x5f,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x2a,
	0x8f, 0x01, 0x0a, 0x08, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15,
	0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45, 0x44, 0x49, 0x53,
	0x5f, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x52, 0x45, 0x5f, 0x4e, 0x41, 0x4e,
	0x4f, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x48, 0x49, 0x47,
	0x48, 0x4d, 0x45, 0x4d, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x18, 0x0a,
	0x14, 0x52, 0x45, 0x44, 0x49, 0x53, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x4d, 0x45, 0x4d, 0x5f, 0x58,
	0x4c, 0x41, 0x52, 0x47, 0x45, 0x10, 0x03, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x44, 0x49, 0x53,
	0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x10,
	0x04, 0x2a, 0x99, 0x01, 0x0a, 0x15, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x24, 0x0a, 0x20, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x5f,
	0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f,
	0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x31, 0x0a, 0x2d, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x49, 0x54, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x41, 0x55, 0x54,
	0x48, 0x45, 0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x2a, 0x89, 0x01,
	0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x10, 0x01,
	0x12, 0x1b, 0x0a, 0x17, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x02, 0x12, 0x1a, 0x0a,
	0x16, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x52, 0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x03, 0x32, 0x93, 0x18, 0x0a, 0x11, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x52, 0x65, 0x64, 0x69, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12,
	0xb6, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0xa3, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x22, 0x3b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e,
	0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe1,
	0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7c, 0xca, 0x41, 0x1e, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0xda, 0x41, 0x13, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3f, 0x3a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x32, 0x34, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xcf, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6a, 0xca, 0x41, 0x2c, 0x0a, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdf, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7a, 0xca, 0x41, 0x1e, 0x0a,
	0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0xda, 0x41, 0x19,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a,
	0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0xed, 0x01, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x22, 0x50, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x7d, 0x12, 0x9e, 0x02, 0x0a, 0x1c, 0x52, 0x65, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9a, 0x01, 0xca, 0x41, 0x1e,
	0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0xda, 0x41,
	0x22, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x72, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x01, 0x2a, 0x22, 0x49, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0xda, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc7, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69,
	0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc6,
	0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0xb3, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x22, 0x4e, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe0, 0x01,
	0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x7d, 0xca, 0x41, 0x2c, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x13, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x2a,
	0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xd4, 0x01, 0x0a, 0x0c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71, 0xca, 0x41, 0x1d, 0x0a, 0x06, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x01, 0x2a, 0x22,
	0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xcb, 0x01, 0x0a, 0x0d, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x66, 0xca,
	0x41, 0x1e, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x13, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a, 0x01, 0x2a,
	0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x1a, 0x48, 0xca, 0x41, 0x14, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0xff, 0x05, 0xea, 0x41, 0x6e, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x45, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65,
	0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75,
	0x6c, 0x65, 0x7d, 0xea, 0x41, 0x4e, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61,
	0x6c, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x7d, 0xea, 0x41, 0x77, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0xea, 0x41,
	0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65,
	0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67,
	0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0xea, 0x41, 0xa6, 0x01, 0x0a, 0x28, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72,
	0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f,
	0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x2f, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x7d, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2e, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x16, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x64,
	0x69, 0x73, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x65, 0x64, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x70, 0x62, 0x3b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x70, 0x62, 0xea, 0x02, 0x21,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52,
	0x65, 0x64, 0x69, 0x73, 0x3a, 0x3a, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescOnce sync.Once
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescData = file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDesc
)

func file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescGZIP() []byte {
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescOnce.Do(func() {
		file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescData)
	})
	return file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDescData
}

var file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 17)
var file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 50)
var file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_goTypes = []any{
	(PscConnectionStatus)(0),                                           // 0: google.cloud.redis.cluster.v1.PscConnectionStatus
	(AuthorizationMode)(0),                                             // 1: google.cloud.redis.cluster.v1.AuthorizationMode
	(NodeType)(0),                                                      // 2: google.cloud.redis.cluster.v1.NodeType
	(TransitEncryptionMode)(0),                                         // 3: google.cloud.redis.cluster.v1.TransitEncryptionMode
	(ConnectionType)(0),                                                // 4: google.cloud.redis.cluster.v1.ConnectionType
	(Cluster_State)(0),                                                 // 5: google.cloud.redis.cluster.v1.Cluster.State
	(AutomatedBackupConfig_AutomatedBackupMode)(0),                     // 6: google.cloud.redis.cluster.v1.AutomatedBackupConfig.AutomatedBackupMode
	(Backup_BackupType)(0),                                             // 7: google.cloud.redis.cluster.v1.Backup.BackupType
	(Backup_State)(0),                                                  // 8: google.cloud.redis.cluster.v1.Backup.State
	(CrossClusterReplicationConfig_ClusterRole)(0),                     // 9: google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.ClusterRole
	(ClusterPersistenceConfig_PersistenceMode)(0),                      // 10: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.PersistenceMode
	(ClusterPersistenceConfig_RDBConfig_SnapshotPeriod)(0),             // 11: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig.SnapshotPeriod
	(ClusterPersistenceConfig_AOFConfig_AppendFsync)(0),                // 12: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.AOFConfig.AppendFsync
	(ZoneDistributionConfig_ZoneDistributionMode)(0),                   // 13: google.cloud.redis.cluster.v1.ZoneDistributionConfig.ZoneDistributionMode
	(RescheduleClusterMaintenanceRequest_RescheduleType)(0),            // 14: google.cloud.redis.cluster.v1.RescheduleClusterMaintenanceRequest.RescheduleType
	(EncryptionInfo_Type)(0),                                           // 15: google.cloud.redis.cluster.v1.EncryptionInfo.Type
	(EncryptionInfo_KmsKeyState)(0),                                    // 16: google.cloud.redis.cluster.v1.EncryptionInfo.KmsKeyState
	(*CreateClusterRequest)(nil),                                       // 17: google.cloud.redis.cluster.v1.CreateClusterRequest
	(*ListClustersRequest)(nil),                                        // 18: google.cloud.redis.cluster.v1.ListClustersRequest
	(*ListClustersResponse)(nil),                                       // 19: google.cloud.redis.cluster.v1.ListClustersResponse
	(*UpdateClusterRequest)(nil),                                       // 20: google.cloud.redis.cluster.v1.UpdateClusterRequest
	(*GetClusterRequest)(nil),                                          // 21: google.cloud.redis.cluster.v1.GetClusterRequest
	(*DeleteClusterRequest)(nil),                                       // 22: google.cloud.redis.cluster.v1.DeleteClusterRequest
	(*GetClusterCertificateAuthorityRequest)(nil),                      // 23: google.cloud.redis.cluster.v1.GetClusterCertificateAuthorityRequest
	(*ListBackupCollectionsRequest)(nil),                               // 24: google.cloud.redis.cluster.v1.ListBackupCollectionsRequest
	(*ListBackupCollectionsResponse)(nil),                              // 25: google.cloud.redis.cluster.v1.ListBackupCollectionsResponse
	(*GetBackupCollectionRequest)(nil),                                 // 26: google.cloud.redis.cluster.v1.GetBackupCollectionRequest
	(*ListBackupsRequest)(nil),                                         // 27: google.cloud.redis.cluster.v1.ListBackupsRequest
	(*ListBackupsResponse)(nil),                                        // 28: google.cloud.redis.cluster.v1.ListBackupsResponse
	(*GetBackupRequest)(nil),                                           // 29: google.cloud.redis.cluster.v1.GetBackupRequest
	(*DeleteBackupRequest)(nil),                                        // 30: google.cloud.redis.cluster.v1.DeleteBackupRequest
	(*ExportBackupRequest)(nil),                                        // 31: google.cloud.redis.cluster.v1.ExportBackupRequest
	(*BackupClusterRequest)(nil),                                       // 32: google.cloud.redis.cluster.v1.BackupClusterRequest
	(*Cluster)(nil),                                                    // 33: google.cloud.redis.cluster.v1.Cluster
	(*AutomatedBackupConfig)(nil),                                      // 34: google.cloud.redis.cluster.v1.AutomatedBackupConfig
	(*BackupCollection)(nil),                                           // 35: google.cloud.redis.cluster.v1.BackupCollection
	(*Backup)(nil),                                                     // 36: google.cloud.redis.cluster.v1.Backup
	(*BackupFile)(nil),                                                 // 37: google.cloud.redis.cluster.v1.BackupFile
	(*PscServiceAttachment)(nil),                                       // 38: google.cloud.redis.cluster.v1.PscServiceAttachment
	(*CrossClusterReplicationConfig)(nil),                              // 39: google.cloud.redis.cluster.v1.CrossClusterReplicationConfig
	(*ClusterMaintenancePolicy)(nil),                                   // 40: google.cloud.redis.cluster.v1.ClusterMaintenancePolicy
	(*ClusterWeeklyMaintenanceWindow)(nil),                             // 41: google.cloud.redis.cluster.v1.ClusterWeeklyMaintenanceWindow
	(*ClusterMaintenanceSchedule)(nil),                                 // 42: google.cloud.redis.cluster.v1.ClusterMaintenanceSchedule
	(*PscConfig)(nil),                                                  // 43: google.cloud.redis.cluster.v1.PscConfig
	(*DiscoveryEndpoint)(nil),                                          // 44: google.cloud.redis.cluster.v1.DiscoveryEndpoint
	(*PscConnection)(nil),                                              // 45: google.cloud.redis.cluster.v1.PscConnection
	(*ClusterEndpoint)(nil),                                            // 46: google.cloud.redis.cluster.v1.ClusterEndpoint
	(*ConnectionDetail)(nil),                                           // 47: google.cloud.redis.cluster.v1.ConnectionDetail
	(*PscAutoConnection)(nil),                                          // 48: google.cloud.redis.cluster.v1.PscAutoConnection
	(*OperationMetadata)(nil),                                          // 49: google.cloud.redis.cluster.v1.OperationMetadata
	(*CertificateAuthority)(nil),                                       // 50: google.cloud.redis.cluster.v1.CertificateAuthority
	(*ClusterPersistenceConfig)(nil),                                   // 51: google.cloud.redis.cluster.v1.ClusterPersistenceConfig
	(*ZoneDistributionConfig)(nil),                                     // 52: google.cloud.redis.cluster.v1.ZoneDistributionConfig
	(*RescheduleClusterMaintenanceRequest)(nil),                        // 53: google.cloud.redis.cluster.v1.RescheduleClusterMaintenanceRequest
	(*EncryptionInfo)(nil),                                             // 54: google.cloud.redis.cluster.v1.EncryptionInfo
	(*Cluster_StateInfo)(nil),                                          // 55: google.cloud.redis.cluster.v1.Cluster.StateInfo
	(*Cluster_GcsBackupSource)(nil),                                    // 56: google.cloud.redis.cluster.v1.Cluster.GcsBackupSource
	(*Cluster_ManagedBackupSource)(nil),                                // 57: google.cloud.redis.cluster.v1.Cluster.ManagedBackupSource
	nil,                                                                // 58: google.cloud.redis.cluster.v1.Cluster.RedisConfigsEntry
	(*Cluster_StateInfo_UpdateInfo)(nil),                               // 59: google.cloud.redis.cluster.v1.Cluster.StateInfo.UpdateInfo
	(*AutomatedBackupConfig_FixedFrequencySchedule)(nil),               // 60: google.cloud.redis.cluster.v1.AutomatedBackupConfig.FixedFrequencySchedule
	(*CrossClusterReplicationConfig_RemoteCluster)(nil),                // 61: google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.RemoteCluster
	(*CrossClusterReplicationConfig_Membership)(nil),                   // 62: google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.Membership
	(*CertificateAuthority_ManagedCertificateAuthority)(nil),           // 63: google.cloud.redis.cluster.v1.CertificateAuthority.ManagedCertificateAuthority
	(*CertificateAuthority_ManagedCertificateAuthority_CertChain)(nil), // 64: google.cloud.redis.cluster.v1.CertificateAuthority.ManagedCertificateAuthority.CertChain
	(*ClusterPersistenceConfig_RDBConfig)(nil),                         // 65: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig
	(*ClusterPersistenceConfig_AOFConfig)(nil),                         // 66: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.AOFConfig
	(*fieldmaskpb.FieldMask)(nil),                                      // 67: google.protobuf.FieldMask
	(*durationpb.Duration)(nil),                                        // 68: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),                                      // 69: google.protobuf.Timestamp
	(dayofweek.DayOfWeek)(0),                                           // 70: google.type.DayOfWeek
	(*timeofday.TimeOfDay)(nil),                                        // 71: google.type.TimeOfDay
	(*longrunningpb.Operation)(nil),                                    // 72: google.longrunning.Operation
}
var file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_depIdxs = []int32{
	33, // 0: google.cloud.redis.cluster.v1.CreateClusterRequest.cluster:type_name -> google.cloud.redis.cluster.v1.Cluster
	33, // 1: google.cloud.redis.cluster.v1.ListClustersResponse.clusters:type_name -> google.cloud.redis.cluster.v1.Cluster
	67, // 2: google.cloud.redis.cluster.v1.UpdateClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	33, // 3: google.cloud.redis.cluster.v1.UpdateClusterRequest.cluster:type_name -> google.cloud.redis.cluster.v1.Cluster
	35, // 4: google.cloud.redis.cluster.v1.ListBackupCollectionsResponse.backup_collections:type_name -> google.cloud.redis.cluster.v1.BackupCollection
	36, // 5: google.cloud.redis.cluster.v1.ListBackupsResponse.backups:type_name -> google.cloud.redis.cluster.v1.Backup
	68, // 6: google.cloud.redis.cluster.v1.BackupClusterRequest.ttl:type_name -> google.protobuf.Duration
	56, // 7: google.cloud.redis.cluster.v1.Cluster.gcs_source:type_name -> google.cloud.redis.cluster.v1.Cluster.GcsBackupSource
	57, // 8: google.cloud.redis.cluster.v1.Cluster.managed_backup_source:type_name -> google.cloud.redis.cluster.v1.Cluster.ManagedBackupSource
	69, // 9: google.cloud.redis.cluster.v1.Cluster.create_time:type_name -> google.protobuf.Timestamp
	5,  // 10: google.cloud.redis.cluster.v1.Cluster.state:type_name -> google.cloud.redis.cluster.v1.Cluster.State
	1,  // 11: google.cloud.redis.cluster.v1.Cluster.authorization_mode:type_name -> google.cloud.redis.cluster.v1.AuthorizationMode
	3,  // 12: google.cloud.redis.cluster.v1.Cluster.transit_encryption_mode:type_name -> google.cloud.redis.cluster.v1.TransitEncryptionMode
	43, // 13: google.cloud.redis.cluster.v1.Cluster.psc_configs:type_name -> google.cloud.redis.cluster.v1.PscConfig
	44, // 14: google.cloud.redis.cluster.v1.Cluster.discovery_endpoints:type_name -> google.cloud.redis.cluster.v1.DiscoveryEndpoint
	45, // 15: google.cloud.redis.cluster.v1.Cluster.psc_connections:type_name -> google.cloud.redis.cluster.v1.PscConnection
	55, // 16: google.cloud.redis.cluster.v1.Cluster.state_info:type_name -> google.cloud.redis.cluster.v1.Cluster.StateInfo
	2,  // 17: google.cloud.redis.cluster.v1.Cluster.node_type:type_name -> google.cloud.redis.cluster.v1.NodeType
	51, // 18: google.cloud.redis.cluster.v1.Cluster.persistence_config:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig
	58, // 19: google.cloud.redis.cluster.v1.Cluster.redis_configs:type_name -> google.cloud.redis.cluster.v1.Cluster.RedisConfigsEntry
	52, // 20: google.cloud.redis.cluster.v1.Cluster.zone_distribution_config:type_name -> google.cloud.redis.cluster.v1.ZoneDistributionConfig
	39, // 21: google.cloud.redis.cluster.v1.Cluster.cross_cluster_replication_config:type_name -> google.cloud.redis.cluster.v1.CrossClusterReplicationConfig
	40, // 22: google.cloud.redis.cluster.v1.Cluster.maintenance_policy:type_name -> google.cloud.redis.cluster.v1.ClusterMaintenancePolicy
	42, // 23: google.cloud.redis.cluster.v1.Cluster.maintenance_schedule:type_name -> google.cloud.redis.cluster.v1.ClusterMaintenanceSchedule
	38, // 24: google.cloud.redis.cluster.v1.Cluster.psc_service_attachments:type_name -> google.cloud.redis.cluster.v1.PscServiceAttachment
	46, // 25: google.cloud.redis.cluster.v1.Cluster.cluster_endpoints:type_name -> google.cloud.redis.cluster.v1.ClusterEndpoint
	34, // 26: google.cloud.redis.cluster.v1.Cluster.automated_backup_config:type_name -> google.cloud.redis.cluster.v1.AutomatedBackupConfig
	54, // 27: google.cloud.redis.cluster.v1.Cluster.encryption_info:type_name -> google.cloud.redis.cluster.v1.EncryptionInfo
	60, // 28: google.cloud.redis.cluster.v1.AutomatedBackupConfig.fixed_frequency_schedule:type_name -> google.cloud.redis.cluster.v1.AutomatedBackupConfig.FixedFrequencySchedule
	6,  // 29: google.cloud.redis.cluster.v1.AutomatedBackupConfig.automated_backup_mode:type_name -> google.cloud.redis.cluster.v1.AutomatedBackupConfig.AutomatedBackupMode
	68, // 30: google.cloud.redis.cluster.v1.AutomatedBackupConfig.retention:type_name -> google.protobuf.Duration
	69, // 31: google.cloud.redis.cluster.v1.Backup.create_time:type_name -> google.protobuf.Timestamp
	69, // 32: google.cloud.redis.cluster.v1.Backup.expire_time:type_name -> google.protobuf.Timestamp
	37, // 33: google.cloud.redis.cluster.v1.Backup.backup_files:type_name -> google.cloud.redis.cluster.v1.BackupFile
	2,  // 34: google.cloud.redis.cluster.v1.Backup.node_type:type_name -> google.cloud.redis.cluster.v1.NodeType
	7,  // 35: google.cloud.redis.cluster.v1.Backup.backup_type:type_name -> google.cloud.redis.cluster.v1.Backup.BackupType
	8,  // 36: google.cloud.redis.cluster.v1.Backup.state:type_name -> google.cloud.redis.cluster.v1.Backup.State
	54, // 37: google.cloud.redis.cluster.v1.Backup.encryption_info:type_name -> google.cloud.redis.cluster.v1.EncryptionInfo
	69, // 38: google.cloud.redis.cluster.v1.BackupFile.create_time:type_name -> google.protobuf.Timestamp
	4,  // 39: google.cloud.redis.cluster.v1.PscServiceAttachment.connection_type:type_name -> google.cloud.redis.cluster.v1.ConnectionType
	9,  // 40: google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.cluster_role:type_name -> google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.ClusterRole
	61, // 41: google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.primary_cluster:type_name -> google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.RemoteCluster
	61, // 42: google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.secondary_clusters:type_name -> google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.RemoteCluster
	69, // 43: google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.update_time:type_name -> google.protobuf.Timestamp
	62, // 44: google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.membership:type_name -> google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.Membership
	69, // 45: google.cloud.redis.cluster.v1.ClusterMaintenancePolicy.create_time:type_name -> google.protobuf.Timestamp
	69, // 46: google.cloud.redis.cluster.v1.ClusterMaintenancePolicy.update_time:type_name -> google.protobuf.Timestamp
	41, // 47: google.cloud.redis.cluster.v1.ClusterMaintenancePolicy.weekly_maintenance_window:type_name -> google.cloud.redis.cluster.v1.ClusterWeeklyMaintenanceWindow
	70, // 48: google.cloud.redis.cluster.v1.ClusterWeeklyMaintenanceWindow.day:type_name -> google.type.DayOfWeek
	71, // 49: google.cloud.redis.cluster.v1.ClusterWeeklyMaintenanceWindow.start_time:type_name -> google.type.TimeOfDay
	69, // 50: google.cloud.redis.cluster.v1.ClusterMaintenanceSchedule.start_time:type_name -> google.protobuf.Timestamp
	69, // 51: google.cloud.redis.cluster.v1.ClusterMaintenanceSchedule.end_time:type_name -> google.protobuf.Timestamp
	43, // 52: google.cloud.redis.cluster.v1.DiscoveryEndpoint.psc_config:type_name -> google.cloud.redis.cluster.v1.PscConfig
	0,  // 53: google.cloud.redis.cluster.v1.PscConnection.psc_connection_status:type_name -> google.cloud.redis.cluster.v1.PscConnectionStatus
	4,  // 54: google.cloud.redis.cluster.v1.PscConnection.connection_type:type_name -> google.cloud.redis.cluster.v1.ConnectionType
	47, // 55: google.cloud.redis.cluster.v1.ClusterEndpoint.connections:type_name -> google.cloud.redis.cluster.v1.ConnectionDetail
	48, // 56: google.cloud.redis.cluster.v1.ConnectionDetail.psc_auto_connection:type_name -> google.cloud.redis.cluster.v1.PscAutoConnection
	45, // 57: google.cloud.redis.cluster.v1.ConnectionDetail.psc_connection:type_name -> google.cloud.redis.cluster.v1.PscConnection
	0,  // 58: google.cloud.redis.cluster.v1.PscAutoConnection.psc_connection_status:type_name -> google.cloud.redis.cluster.v1.PscConnectionStatus
	4,  // 59: google.cloud.redis.cluster.v1.PscAutoConnection.connection_type:type_name -> google.cloud.redis.cluster.v1.ConnectionType
	69, // 60: google.cloud.redis.cluster.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	69, // 61: google.cloud.redis.cluster.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	63, // 62: google.cloud.redis.cluster.v1.CertificateAuthority.managed_server_ca:type_name -> google.cloud.redis.cluster.v1.CertificateAuthority.ManagedCertificateAuthority
	10, // 63: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.mode:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig.PersistenceMode
	65, // 64: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.rdb_config:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig
	66, // 65: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.aof_config:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig.AOFConfig
	13, // 66: google.cloud.redis.cluster.v1.ZoneDistributionConfig.mode:type_name -> google.cloud.redis.cluster.v1.ZoneDistributionConfig.ZoneDistributionMode
	14, // 67: google.cloud.redis.cluster.v1.RescheduleClusterMaintenanceRequest.reschedule_type:type_name -> google.cloud.redis.cluster.v1.RescheduleClusterMaintenanceRequest.RescheduleType
	69, // 68: google.cloud.redis.cluster.v1.RescheduleClusterMaintenanceRequest.schedule_time:type_name -> google.protobuf.Timestamp
	15, // 69: google.cloud.redis.cluster.v1.EncryptionInfo.encryption_type:type_name -> google.cloud.redis.cluster.v1.EncryptionInfo.Type
	16, // 70: google.cloud.redis.cluster.v1.EncryptionInfo.kms_key_primary_state:type_name -> google.cloud.redis.cluster.v1.EncryptionInfo.KmsKeyState
	69, // 71: google.cloud.redis.cluster.v1.EncryptionInfo.last_update_time:type_name -> google.protobuf.Timestamp
	59, // 72: google.cloud.redis.cluster.v1.Cluster.StateInfo.update_info:type_name -> google.cloud.redis.cluster.v1.Cluster.StateInfo.UpdateInfo
	71, // 73: google.cloud.redis.cluster.v1.AutomatedBackupConfig.FixedFrequencySchedule.start_time:type_name -> google.type.TimeOfDay
	61, // 74: google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.Membership.primary_cluster:type_name -> google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.RemoteCluster
	61, // 75: google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.Membership.secondary_clusters:type_name -> google.cloud.redis.cluster.v1.CrossClusterReplicationConfig.RemoteCluster
	64, // 76: google.cloud.redis.cluster.v1.CertificateAuthority.ManagedCertificateAuthority.ca_certs:type_name -> google.cloud.redis.cluster.v1.CertificateAuthority.ManagedCertificateAuthority.CertChain
	11, // 77: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig.rdb_snapshot_period:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig.SnapshotPeriod
	69, // 78: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.RDBConfig.rdb_snapshot_start_time:type_name -> google.protobuf.Timestamp
	12, // 79: google.cloud.redis.cluster.v1.ClusterPersistenceConfig.AOFConfig.append_fsync:type_name -> google.cloud.redis.cluster.v1.ClusterPersistenceConfig.AOFConfig.AppendFsync
	18, // 80: google.cloud.redis.cluster.v1.CloudRedisCluster.ListClusters:input_type -> google.cloud.redis.cluster.v1.ListClustersRequest
	21, // 81: google.cloud.redis.cluster.v1.CloudRedisCluster.GetCluster:input_type -> google.cloud.redis.cluster.v1.GetClusterRequest
	20, // 82: google.cloud.redis.cluster.v1.CloudRedisCluster.UpdateCluster:input_type -> google.cloud.redis.cluster.v1.UpdateClusterRequest
	22, // 83: google.cloud.redis.cluster.v1.CloudRedisCluster.DeleteCluster:input_type -> google.cloud.redis.cluster.v1.DeleteClusterRequest
	17, // 84: google.cloud.redis.cluster.v1.CloudRedisCluster.CreateCluster:input_type -> google.cloud.redis.cluster.v1.CreateClusterRequest
	23, // 85: google.cloud.redis.cluster.v1.CloudRedisCluster.GetClusterCertificateAuthority:input_type -> google.cloud.redis.cluster.v1.GetClusterCertificateAuthorityRequest
	53, // 86: google.cloud.redis.cluster.v1.CloudRedisCluster.RescheduleClusterMaintenance:input_type -> google.cloud.redis.cluster.v1.RescheduleClusterMaintenanceRequest
	24, // 87: google.cloud.redis.cluster.v1.CloudRedisCluster.ListBackupCollections:input_type -> google.cloud.redis.cluster.v1.ListBackupCollectionsRequest
	26, // 88: google.cloud.redis.cluster.v1.CloudRedisCluster.GetBackupCollection:input_type -> google.cloud.redis.cluster.v1.GetBackupCollectionRequest
	27, // 89: google.cloud.redis.cluster.v1.CloudRedisCluster.ListBackups:input_type -> google.cloud.redis.cluster.v1.ListBackupsRequest
	29, // 90: google.cloud.redis.cluster.v1.CloudRedisCluster.GetBackup:input_type -> google.cloud.redis.cluster.v1.GetBackupRequest
	30, // 91: google.cloud.redis.cluster.v1.CloudRedisCluster.DeleteBackup:input_type -> google.cloud.redis.cluster.v1.DeleteBackupRequest
	31, // 92: google.cloud.redis.cluster.v1.CloudRedisCluster.ExportBackup:input_type -> google.cloud.redis.cluster.v1.ExportBackupRequest
	32, // 93: google.cloud.redis.cluster.v1.CloudRedisCluster.BackupCluster:input_type -> google.cloud.redis.cluster.v1.BackupClusterRequest
	19, // 94: google.cloud.redis.cluster.v1.CloudRedisCluster.ListClusters:output_type -> google.cloud.redis.cluster.v1.ListClustersResponse
	33, // 95: google.cloud.redis.cluster.v1.CloudRedisCluster.GetCluster:output_type -> google.cloud.redis.cluster.v1.Cluster
	72, // 96: google.cloud.redis.cluster.v1.CloudRedisCluster.UpdateCluster:output_type -> google.longrunning.Operation
	72, // 97: google.cloud.redis.cluster.v1.CloudRedisCluster.DeleteCluster:output_type -> google.longrunning.Operation
	72, // 98: google.cloud.redis.cluster.v1.CloudRedisCluster.CreateCluster:output_type -> google.longrunning.Operation
	50, // 99: google.cloud.redis.cluster.v1.CloudRedisCluster.GetClusterCertificateAuthority:output_type -> google.cloud.redis.cluster.v1.CertificateAuthority
	72, // 100: google.cloud.redis.cluster.v1.CloudRedisCluster.RescheduleClusterMaintenance:output_type -> google.longrunning.Operation
	25, // 101: google.cloud.redis.cluster.v1.CloudRedisCluster.ListBackupCollections:output_type -> google.cloud.redis.cluster.v1.ListBackupCollectionsResponse
	35, // 102: google.cloud.redis.cluster.v1.CloudRedisCluster.GetBackupCollection:output_type -> google.cloud.redis.cluster.v1.BackupCollection
	28, // 103: google.cloud.redis.cluster.v1.CloudRedisCluster.ListBackups:output_type -> google.cloud.redis.cluster.v1.ListBackupsResponse
	36, // 104: google.cloud.redis.cluster.v1.CloudRedisCluster.GetBackup:output_type -> google.cloud.redis.cluster.v1.Backup
	72, // 105: google.cloud.redis.cluster.v1.CloudRedisCluster.DeleteBackup:output_type -> google.longrunning.Operation
	72, // 106: google.cloud.redis.cluster.v1.CloudRedisCluster.ExportBackup:output_type -> google.longrunning.Operation
	72, // 107: google.cloud.redis.cluster.v1.CloudRedisCluster.BackupCluster:output_type -> google.longrunning.Operation
	94, // [94:108] is the sub-list for method output_type
	80, // [80:94] is the sub-list for method input_type
	80, // [80:80] is the sub-list for extension type_name
	80, // [80:80] is the sub-list for extension extendee
	0,  // [0:80] is the sub-list for field type_name
}

func init() { file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_init() }
func file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_init() {
	if File_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto != nil {
		return
	}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[14].OneofWrappers = []any{
		(*ExportBackupRequest_GcsBucket)(nil),
	}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[15].OneofWrappers = []any{}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[16].OneofWrappers = []any{
		(*Cluster_GcsSource)(nil),
		(*Cluster_ManagedBackupSource_)(nil),
	}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[17].OneofWrappers = []any{
		(*AutomatedBackupConfig_FixedFrequencySchedule_)(nil),
	}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[30].OneofWrappers = []any{
		(*ConnectionDetail_PscAutoConnection)(nil),
		(*ConnectionDetail_PscConnection)(nil),
	}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[33].OneofWrappers = []any{
		(*CertificateAuthority_ManagedServerCa)(nil),
	}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[38].OneofWrappers = []any{
		(*Cluster_StateInfo_UpdateInfo_)(nil),
	}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[42].OneofWrappers = []any{}
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes[43].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDesc,
			NumEnums:      17,
			NumMessages:   50,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_goTypes,
		DependencyIndexes: file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_depIdxs,
		EnumInfos:         file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_enumTypes,
		MessageInfos:      file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_msgTypes,
	}.Build()
	File_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto = out.File
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_rawDesc = nil
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_goTypes = nil
	file_google_cloud_redis_cluster_v1_cloud_redis_cluster_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudRedisClusterClient is the client API for CloudRedisCluster service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudRedisClusterClient interface {
	// Lists all Redis clusters owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	//
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets the details of a specific Redis cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Updates the metadata and configuration of a specific Redis cluster.
	//
	// Completed longrunning.Operation will contain the new cluster object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a specific Redis cluster. Cluster stops serving and data is
	// deleted.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a Redis cluster based on the specified properties.
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// cluster will be fully functional. The completed longrunning.Operation will
	// contain the new cluster object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the details of certificate authority information for Redis cluster.
	GetClusterCertificateAuthority(ctx context.Context, in *GetClusterCertificateAuthorityRequest, opts ...grpc.CallOption) (*CertificateAuthority, error)
	// Reschedules upcoming maintenance event.
	RescheduleClusterMaintenance(ctx context.Context, in *RescheduleClusterMaintenanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all backup collections owned by a consumer project in either the
	// specified location (region) or all locations.
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListBackupCollections(ctx context.Context, in *ListBackupCollectionsRequest, opts ...grpc.CallOption) (*ListBackupCollectionsResponse, error)
	// Get a backup collection.
	GetBackupCollection(ctx context.Context, in *GetBackupCollectionRequest, opts ...grpc.CallOption) (*BackupCollection, error)
	// Lists all backups owned by a backup collection.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Gets the details of a specific backup.
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Deletes a specific backup.
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports a specific backup to a customer target Cloud Storage URI.
	ExportBackup(ctx context.Context, in *ExportBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Backup Redis Cluster.
	// If this is the first time a backup is being created, a backup collection
	// will be created at the backend, and this backup belongs to this collection.
	// Both collection and backup will have a resource name. Backup will be
	// executed for each shard. A replica (primary if nonHA) will be selected to
	// perform the execution. Backup call will be rejected if there is an ongoing
	// backup or update operation. Be aware that during preview, if the cluster's
	// internal software version is too old, critical update will be performed
	// before actual backup. Once the internal software version is updated to the
	// minimum version required by the backup feature, subsequent backups will not
	// require critical update. After preview, there will be no critical update
	// needed for backup.
	BackupCluster(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type cloudRedisClusterClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudRedisClusterClient(cc grpc.ClientConnInterface) CloudRedisClusterClient {
	return &cloudRedisClusterClient{cc}
}

func (c *cloudRedisClusterClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/ListClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/UpdateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/CreateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) GetClusterCertificateAuthority(ctx context.Context, in *GetClusterCertificateAuthorityRequest, opts ...grpc.CallOption) (*CertificateAuthority, error) {
	out := new(CertificateAuthority)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetClusterCertificateAuthority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) RescheduleClusterMaintenance(ctx context.Context, in *RescheduleClusterMaintenanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/RescheduleClusterMaintenance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) ListBackupCollections(ctx context.Context, in *ListBackupCollectionsRequest, opts ...grpc.CallOption) (*ListBackupCollectionsResponse, error) {
	out := new(ListBackupCollectionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/ListBackupCollections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) GetBackupCollection(ctx context.Context, in *GetBackupCollectionRequest, opts ...grpc.CallOption) (*BackupCollection, error) {
	out := new(BackupCollection)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetBackupCollection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/ListBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/DeleteBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) ExportBackup(ctx context.Context, in *ExportBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/ExportBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClusterClient) BackupCluster(ctx context.Context, in *BackupClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.cluster.v1.CloudRedisCluster/BackupCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudRedisClusterServer is the server API for CloudRedisCluster service.
type CloudRedisClusterServer interface {
	// Lists all Redis clusters owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	//
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets the details of a specific Redis cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Updates the metadata and configuration of a specific Redis cluster.
	//
	// Completed longrunning.Operation will contain the new cluster object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a specific Redis cluster. Cluster stops serving and data is
	// deleted.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error)
	// Creates a Redis cluster based on the specified properties.
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// cluster will be fully functional. The completed longrunning.Operation will
	// contain the new cluster object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error)
	// Gets the details of certificate authority information for Redis cluster.
	GetClusterCertificateAuthority(context.Context, *GetClusterCertificateAuthorityRequest) (*CertificateAuthority, error)
	// Reschedules upcoming maintenance event.
	RescheduleClusterMaintenance(context.Context, *RescheduleClusterMaintenanceRequest) (*longrunningpb.Operation, error)
	// Lists all backup collections owned by a consumer project in either the
	// specified location (region) or all locations.
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListBackupCollections(context.Context, *ListBackupCollectionsRequest) (*ListBackupCollectionsResponse, error)
	// Get a backup collection.
	GetBackupCollection(context.Context, *GetBackupCollectionRequest) (*BackupCollection, error)
	// Lists all backups owned by a backup collection.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Gets the details of a specific backup.
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Deletes a specific backup.
	DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error)
	// Exports a specific backup to a customer target Cloud Storage URI.
	ExportBackup(context.Context, *ExportBackupRequest) (*longrunningpb.Operation, error)
	// Backup Redis Cluster.
	// If this is the first time a backup is being created, a backup collection
	// will be created at the backend, and this backup belongs to this collection.
	// Both collection and backup will have a resource name. Backup will be
	// executed for each shard. A replica (primary if nonHA) will be selected to
	// perform the execution. Backup call will be rejected if there is an ongoing
	// backup or update operation. Be aware that during preview, if the cluster's
	// internal software version is too old, critical update will be performed
	// before actual backup. Once the internal software version is updated to the
	// minimum version required by the backup feature, subsequent backups will not
	// require critical update. After preview, there will be no critical update
	// needed for backup.
	BackupCluster(context.Context, *BackupClusterRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCloudRedisClusterServer can be embedded to have forward compatible implementations.
type UnimplementedCloudRedisClusterServer struct {
}

func (*UnimplementedCloudRedisClusterServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (*UnimplementedCloudRedisClusterServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedCloudRedisClusterServer) UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (*UnimplementedCloudRedisClusterServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedCloudRedisClusterServer) CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (*UnimplementedCloudRedisClusterServer) GetClusterCertificateAuthority(context.Context, *GetClusterCertificateAuthorityRequest) (*CertificateAuthority, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClusterCertificateAuthority not implemented")
}
func (*UnimplementedCloudRedisClusterServer) RescheduleClusterMaintenance(context.Context, *RescheduleClusterMaintenanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RescheduleClusterMaintenance not implemented")
}
func (*UnimplementedCloudRedisClusterServer) ListBackupCollections(context.Context, *ListBackupCollectionsRequest) (*ListBackupCollectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupCollections not implemented")
}
func (*UnimplementedCloudRedisClusterServer) GetBackupCollection(context.Context, *GetBackupCollectionRequest) (*BackupCollection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupCollection not implemented")
}
func (*UnimplementedCloudRedisClusterServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (*UnimplementedCloudRedisClusterServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (*UnimplementedCloudRedisClusterServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}
func (*UnimplementedCloudRedisClusterServer) ExportBackup(context.Context, *ExportBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportBackup not implemented")
}
func (*UnimplementedCloudRedisClusterServer) BackupCluster(context.Context, *BackupClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BackupCluster not implemented")
}

func RegisterCloudRedisClusterServer(s *grpc.Server, srv CloudRedisClusterServer) {
	s.RegisterService(&_CloudRedisCluster_serviceDesc, srv)
}

func _CloudRedisCluster_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_GetClusterCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).GetClusterCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetClusterCertificateAuthority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).GetClusterCertificateAuthority(ctx, req.(*GetClusterCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_RescheduleClusterMaintenance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RescheduleClusterMaintenanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).RescheduleClusterMaintenance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/RescheduleClusterMaintenance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).RescheduleClusterMaintenance(ctx, req.(*RescheduleClusterMaintenanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_ListBackupCollections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupCollectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).ListBackupCollections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/ListBackupCollections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).ListBackupCollections(ctx, req.(*ListBackupCollectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_GetBackupCollection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupCollectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).GetBackupCollection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetBackupCollection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).GetBackupCollection(ctx, req.(*GetBackupCollectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/ListBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/GetBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/DeleteBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_ExportBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).ExportBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/ExportBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).ExportBackup(ctx, req.(*ExportBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedisCluster_BackupCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BackupClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisClusterServer).BackupCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.cluster.v1.CloudRedisCluster/BackupCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisClusterServer).BackupCluster(ctx, req.(*BackupClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudRedisCluster_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.redis.cluster.v1.CloudRedisCluster",
	HandlerType: (*CloudRedisClusterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClusters",
			Handler:    _CloudRedisCluster_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _CloudRedisCluster_GetCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _CloudRedisCluster_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _CloudRedisCluster_DeleteCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _CloudRedisCluster_CreateCluster_Handler,
		},
		{
			MethodName: "GetClusterCertificateAuthority",
			Handler:    _CloudRedisCluster_GetClusterCertificateAuthority_Handler,
		},
		{
			MethodName: "RescheduleClusterMaintenance",
			Handler:    _CloudRedisCluster_RescheduleClusterMaintenance_Handler,
		},
		{
			MethodName: "ListBackupCollections",
			Handler:    _CloudRedisCluster_ListBackupCollections_Handler,
		},
		{
			MethodName: "GetBackupCollection",
			Handler:    _CloudRedisCluster_GetBackupCollection_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _CloudRedisCluster_ListBackups_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _CloudRedisCluster_GetBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _CloudRedisCluster_DeleteBackup_Handler,
		},
		{
			MethodName: "ExportBackup",
			Handler:    _CloudRedisCluster_ExportBackup_Handler,
		},
		{
			MethodName: "BackupCluster",
			Handler:    _CloudRedisCluster_BackupCluster_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/redis/cluster/v1/cloud_redis_cluster.proto",
}
