// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/accounts/v1beta/emailpreferences.proto

package accountspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Opt in state of the email preference.
type EmailPreferences_OptInState int32

const (
	// Opt-in status is not specified.
	EmailPreferences_OPT_IN_STATE_UNSPECIFIED EmailPreferences_OptInState = 0
	// User has opted out of receiving this type of email.
	EmailPreferences_OPTED_OUT EmailPreferences_OptInState = 1
	// User has opted in to receiving this type of email.
	EmailPreferences_OPTED_IN EmailPreferences_OptInState = 2
	// User has opted in to receiving this type of email and the confirmation
	// email has been sent, but user has not yet confirmed the opt in (applies
	// only to certain countries).
	EmailPreferences_UNCONFIRMED EmailPreferences_OptInState = 3
)

// Enum value maps for EmailPreferences_OptInState.
var (
	EmailPreferences_OptInState_name = map[int32]string{
		0: "OPT_IN_STATE_UNSPECIFIED",
		1: "OPTED_OUT",
		2: "OPTED_IN",
		3: "UNCONFIRMED",
	}
	EmailPreferences_OptInState_value = map[string]int32{
		"OPT_IN_STATE_UNSPECIFIED": 0,
		"OPTED_OUT":                1,
		"OPTED_IN":                 2,
		"UNCONFIRMED":              3,
	}
)

func (x EmailPreferences_OptInState) Enum() *EmailPreferences_OptInState {
	p := new(EmailPreferences_OptInState)
	*p = x
	return p
}

func (x EmailPreferences_OptInState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EmailPreferences_OptInState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_enumTypes[0].Descriptor()
}

func (EmailPreferences_OptInState) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_enumTypes[0]
}

func (x EmailPreferences_OptInState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EmailPreferences_OptInState.Descriptor instead.
func (EmailPreferences_OptInState) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDescGZIP(), []int{0, 0}
}

// The categories of notifications the user opted into / opted out of. The email
// preferences do not include mandatory announcements as users can't opt out of
// them.
type EmailPreferences struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the EmailPreferences. The endpoint is only
	// supported for the authenticated user.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Updates on new features, tips and best practices.
	NewsAndTips EmailPreferences_OptInState `protobuf:"varint,2,opt,name=news_and_tips,json=newsAndTips,proto3,enum=google.shopping.merchant.accounts.v1beta.EmailPreferences_OptInState" json:"news_and_tips,omitempty"`
}

func (x *EmailPreferences) Reset() {
	*x = EmailPreferences{}
	mi := &file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EmailPreferences) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EmailPreferences) ProtoMessage() {}

func (x *EmailPreferences) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EmailPreferences.ProtoReflect.Descriptor instead.
func (*EmailPreferences) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDescGZIP(), []int{0}
}

func (x *EmailPreferences) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EmailPreferences) GetNewsAndTips() EmailPreferences_OptInState {
	if x != nil {
		return x.NewsAndTips
	}
	return EmailPreferences_OPT_IN_STATE_UNSPECIFIED
}

// Request message for GetEmailPreferences method.
type GetEmailPreferencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `EmailPreferences` resource.
	// Format: `accounts/{account}/users/{email}/emailPreferences`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEmailPreferencesRequest) Reset() {
	*x = GetEmailPreferencesRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEmailPreferencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEmailPreferencesRequest) ProtoMessage() {}

func (x *GetEmailPreferencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEmailPreferencesRequest.ProtoReflect.Descriptor instead.
func (*GetEmailPreferencesRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDescGZIP(), []int{1}
}

func (x *GetEmailPreferencesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdateEmailPreferences method.
type UpdateEmailPreferencesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Email Preferences to be updated.
	EmailPreferences *EmailPreferences `protobuf:"bytes,1,opt,name=email_preferences,json=emailPreferences,proto3" json:"email_preferences,omitempty"`
	// Required. List of fields being updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEmailPreferencesRequest) Reset() {
	*x = UpdateEmailPreferencesRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateEmailPreferencesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEmailPreferencesRequest) ProtoMessage() {}

func (x *UpdateEmailPreferencesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEmailPreferencesRequest.ProtoReflect.Descriptor instead.
func (*UpdateEmailPreferencesRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateEmailPreferencesRequest) GetEmailPreferences() *EmailPreferences {
	if x != nil {
		return x.EmailPreferences
	}
	return nil
}

func (x *UpdateEmailPreferencesRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

var File_google_shopping_merchant_accounts_v1beta_emailpreferences_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x80, 0x03, 0x0a, 0x10, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x6e,
	0x0a, 0x0d, 0x6e, 0x65, 0x77, 0x73, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x70, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x2e, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x6e, 0x65, 0x77, 0x73, 0x41, 0x6e, 0x64, 0x54, 0x69, 0x70, 0x73, 0x22, 0x58,
	0x0a, 0x0a, 0x4f, 0x70, 0x74, 0x49, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x18,
	0x4f, 0x50, 0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x50,
	0x54, 0x45, 0x44, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x50, 0x54,
	0x45, 0x44, 0x5f, 0x49, 0x4e, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x52, 0x4d, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x88, 0x01, 0xea, 0x41, 0x84, 0x01, 0x0a,
	0x2b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6d, 0x61, 0x69,
	0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x31, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d,
	0x2f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x7d, 0x2f, 0x65,
	0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2a,
	0x10, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x32, 0x10, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x22, 0x65, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcf, 0x01, 0x0a, 0x1d, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6c, 0x0a, 0x11,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x32, 0xf3, 0x04, 0x0a,
	0x17, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xe3, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74,
	0x45, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x45,
	0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3d, 0x12, 0x3b, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x7d, 0x12, 0xa8,
	0x02, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6d, 0x61, 0x69, 0x6c,
	0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x6d,
	0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x88,
	0x01, 0xda, 0x41, 0x1d, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x62, 0x3a, 0x11, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x32, 0x4d, 0x2f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x7d, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x42, 0x97, 0x01, 0x0a, 0x2c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x42, 0x15, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70,
	0x62, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDescData = file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDesc
)

func file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDescData)
	})
	return file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDescData
}

var file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_goTypes = []any{
	(EmailPreferences_OptInState)(0),      // 0: google.shopping.merchant.accounts.v1beta.EmailPreferences.OptInState
	(*EmailPreferences)(nil),              // 1: google.shopping.merchant.accounts.v1beta.EmailPreferences
	(*GetEmailPreferencesRequest)(nil),    // 2: google.shopping.merchant.accounts.v1beta.GetEmailPreferencesRequest
	(*UpdateEmailPreferencesRequest)(nil), // 3: google.shopping.merchant.accounts.v1beta.UpdateEmailPreferencesRequest
	(*fieldmaskpb.FieldMask)(nil),         // 4: google.protobuf.FieldMask
}
var file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_depIdxs = []int32{
	0, // 0: google.shopping.merchant.accounts.v1beta.EmailPreferences.news_and_tips:type_name -> google.shopping.merchant.accounts.v1beta.EmailPreferences.OptInState
	1, // 1: google.shopping.merchant.accounts.v1beta.UpdateEmailPreferencesRequest.email_preferences:type_name -> google.shopping.merchant.accounts.v1beta.EmailPreferences
	4, // 2: google.shopping.merchant.accounts.v1beta.UpdateEmailPreferencesRequest.update_mask:type_name -> google.protobuf.FieldMask
	2, // 3: google.shopping.merchant.accounts.v1beta.EmailPreferencesService.GetEmailPreferences:input_type -> google.shopping.merchant.accounts.v1beta.GetEmailPreferencesRequest
	3, // 4: google.shopping.merchant.accounts.v1beta.EmailPreferencesService.UpdateEmailPreferences:input_type -> google.shopping.merchant.accounts.v1beta.UpdateEmailPreferencesRequest
	1, // 5: google.shopping.merchant.accounts.v1beta.EmailPreferencesService.GetEmailPreferences:output_type -> google.shopping.merchant.accounts.v1beta.EmailPreferences
	1, // 6: google.shopping.merchant.accounts.v1beta.EmailPreferencesService.UpdateEmailPreferences:output_type -> google.shopping.merchant.accounts.v1beta.EmailPreferences
	5, // [5:7] is the sub-list for method output_type
	3, // [3:5] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_init() }
func file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_init() {
	if File_google_shopping_merchant_accounts_v1beta_emailpreferences_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_accounts_v1beta_emailpreferences_proto = out.File
	file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_rawDesc = nil
	file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_goTypes = nil
	file_google_shopping_merchant_accounts_v1beta_emailpreferences_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EmailPreferencesServiceClient is the client API for EmailPreferencesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EmailPreferencesServiceClient interface {
	// Returns the email preferences for a Merchant Center account user.
	//
	// Use the name=accounts/*/users/me/emailPreferences alias to get preferences
	// for the authenticated user.
	GetEmailPreferences(ctx context.Context, in *GetEmailPreferencesRequest, opts ...grpc.CallOption) (*EmailPreferences, error)
	// Updates the email preferences for a Merchant Center account user. MCA users
	// should specify the MCA account rather than a sub-account of the MCA.
	//
	// Preferences which are not explicitly selected in the update mask will not
	// be updated.
	//
	// It is invalid for updates to specify an UNCONFIRMED opt-in status value.
	//
	// Use the name=accounts/*/users/me/emailPreferences alias to update
	// preferences
	// for the authenticated user.
	UpdateEmailPreferences(ctx context.Context, in *UpdateEmailPreferencesRequest, opts ...grpc.CallOption) (*EmailPreferences, error)
}

type emailPreferencesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEmailPreferencesServiceClient(cc grpc.ClientConnInterface) EmailPreferencesServiceClient {
	return &emailPreferencesServiceClient{cc}
}

func (c *emailPreferencesServiceClient) GetEmailPreferences(ctx context.Context, in *GetEmailPreferencesRequest, opts ...grpc.CallOption) (*EmailPreferences, error) {
	out := new(EmailPreferences)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.EmailPreferencesService/GetEmailPreferences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *emailPreferencesServiceClient) UpdateEmailPreferences(ctx context.Context, in *UpdateEmailPreferencesRequest, opts ...grpc.CallOption) (*EmailPreferences, error) {
	out := new(EmailPreferences)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.EmailPreferencesService/UpdateEmailPreferences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EmailPreferencesServiceServer is the server API for EmailPreferencesService service.
type EmailPreferencesServiceServer interface {
	// Returns the email preferences for a Merchant Center account user.
	//
	// Use the name=accounts/*/users/me/emailPreferences alias to get preferences
	// for the authenticated user.
	GetEmailPreferences(context.Context, *GetEmailPreferencesRequest) (*EmailPreferences, error)
	// Updates the email preferences for a Merchant Center account user. MCA users
	// should specify the MCA account rather than a sub-account of the MCA.
	//
	// Preferences which are not explicitly selected in the update mask will not
	// be updated.
	//
	// It is invalid for updates to specify an UNCONFIRMED opt-in status value.
	//
	// Use the name=accounts/*/users/me/emailPreferences alias to update
	// preferences
	// for the authenticated user.
	UpdateEmailPreferences(context.Context, *UpdateEmailPreferencesRequest) (*EmailPreferences, error)
}

// UnimplementedEmailPreferencesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedEmailPreferencesServiceServer struct {
}

func (*UnimplementedEmailPreferencesServiceServer) GetEmailPreferences(context.Context, *GetEmailPreferencesRequest) (*EmailPreferences, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEmailPreferences not implemented")
}
func (*UnimplementedEmailPreferencesServiceServer) UpdateEmailPreferences(context.Context, *UpdateEmailPreferencesRequest) (*EmailPreferences, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEmailPreferences not implemented")
}

func RegisterEmailPreferencesServiceServer(s *grpc.Server, srv EmailPreferencesServiceServer) {
	s.RegisterService(&_EmailPreferencesService_serviceDesc, srv)
}

func _EmailPreferencesService_GetEmailPreferences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEmailPreferencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EmailPreferencesServiceServer).GetEmailPreferences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.EmailPreferencesService/GetEmailPreferences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EmailPreferencesServiceServer).GetEmailPreferences(ctx, req.(*GetEmailPreferencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EmailPreferencesService_UpdateEmailPreferences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEmailPreferencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EmailPreferencesServiceServer).UpdateEmailPreferences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.EmailPreferencesService/UpdateEmailPreferences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EmailPreferencesServiceServer).UpdateEmailPreferences(ctx, req.(*UpdateEmailPreferencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EmailPreferencesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.accounts.v1beta.EmailPreferencesService",
	HandlerType: (*EmailPreferencesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetEmailPreferences",
			Handler:    _EmailPreferencesService_GetEmailPreferences_Handler,
		},
		{
			MethodName: "UpdateEmailPreferences",
			Handler:    _EmailPreferencesService_UpdateEmailPreferences_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/accounts/v1beta/emailpreferences.proto",
}
