// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/accounts/v1beta/programs.proto

package accountspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible program participation states for the account.
type Program_State int32

const (
	// Default value. This value is unused.
	Program_STATE_UNSPECIFIED Program_State = 0
	// The account is not eligible to participate in the program.
	Program_NOT_ELIGIBLE Program_State = 1
	// The account is eligible to participate in the program.
	Program_ELIGIBLE Program_State = 2
	// The program is enabled for the account.
	Program_ENABLED Program_State = 3
)

// Enum value maps for Program_State.
var (
	Program_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "NOT_ELIGIBLE",
		2: "ELIGIBLE",
		3: "ENABLED",
	}
	Program_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"NOT_ELIGIBLE":      1,
		"ELIGIBLE":          2,
		"ENABLED":           3,
	}
)

func (x Program_State) Enum() *Program_State {
	p := new(Program_State)
	*p = x
	return p
}

func (x Program_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Program_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_programs_proto_enumTypes[0].Descriptor()
}

func (Program_State) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_programs_proto_enumTypes[0]
}

func (x Program_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Program_State.Descriptor instead.
func (Program_State) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescGZIP(), []int{0, 0}
}

// Defines participation in a given program for the specified account.
//
// Programs provide a mechanism for adding functionality to merchant accounts. A
// typical example of this is the [Free product
// listings](https://support.google.com/merchants/topic/9240261?ref_topic=7257954,7259405,&sjid=796648681813264022-EU)
// program, which enables products from a merchant's store to be shown across
// Google for free.
type Program struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the program.
	// Format: `accounts/{account}/programs/{program}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The URL of a Merchant Center help page describing the program.
	DocumentationUri string `protobuf:"bytes,2,opt,name=documentation_uri,json=documentationUri,proto3" json:"documentation_uri,omitempty"`
	// Output only. The participation state of the account in the program.
	State Program_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.shopping.merchant.accounts.v1beta.Program_State" json:"state,omitempty"`
	// Output only. The regions in which the account is actively participating in
	// the program. Active regions are defined as those where all program
	// requirements affecting the regions have been met.
	//
	// Region codes are defined by [CLDR](https://cldr.unicode.org/). This is
	// either a country where the program applies specifically to that country or
	// `001` when the program applies globally.
	ActiveRegionCodes []string `protobuf:"bytes,4,rep,name=active_region_codes,json=activeRegionCodes,proto3" json:"active_region_codes,omitempty"`
	// Output only. The requirements that the account has not yet satisfied that
	// are affecting participation in the program.
	UnmetRequirements []*Program_Requirement `protobuf:"bytes,5,rep,name=unmet_requirements,json=unmetRequirements,proto3" json:"unmet_requirements,omitempty"`
}

func (x *Program) Reset() {
	*x = Program{}
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Program) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Program) ProtoMessage() {}

func (x *Program) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Program.ProtoReflect.Descriptor instead.
func (*Program) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescGZIP(), []int{0}
}

func (x *Program) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Program) GetDocumentationUri() string {
	if x != nil {
		return x.DocumentationUri
	}
	return ""
}

func (x *Program) GetState() Program_State {
	if x != nil {
		return x.State
	}
	return Program_STATE_UNSPECIFIED
}

func (x *Program) GetActiveRegionCodes() []string {
	if x != nil {
		return x.ActiveRegionCodes
	}
	return nil
}

func (x *Program) GetUnmetRequirements() []*Program_Requirement {
	if x != nil {
		return x.UnmetRequirements
	}
	return nil
}

// Request message for the GetProgram method.
type GetProgramRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the program to retrieve.
	// Format: `accounts/{account}/programs/{program}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProgramRequest) Reset() {
	*x = GetProgramRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProgramRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProgramRequest) ProtoMessage() {}

func (x *GetProgramRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProgramRequest.ProtoReflect.Descriptor instead.
func (*GetProgramRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescGZIP(), []int{1}
}

func (x *GetProgramRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the ListPrograms method.
type ListProgramsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the account for which to retrieve all programs.
	// Format: `accounts/{account}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of programs to return in a single response. If
	// unspecified (or 0), a default size of 1000 is used. The maximum value is
	// 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A continuation token, received from a previous `ListPrograms`
	// call. Provide this to retrieve the next page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProgramsRequest) Reset() {
	*x = ListProgramsRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListProgramsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProgramsRequest) ProtoMessage() {}

func (x *ListProgramsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProgramsRequest.ProtoReflect.Descriptor instead.
func (*ListProgramsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescGZIP(), []int{2}
}

func (x *ListProgramsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProgramsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProgramsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the ListPrograms method.
type ListProgramsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The programs for the given account.
	Programs []*Program `protobuf:"bytes,1,rep,name=programs,proto3" json:"programs,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page. If this
	// field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProgramsResponse) Reset() {
	*x = ListProgramsResponse{}
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListProgramsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProgramsResponse) ProtoMessage() {}

func (x *ListProgramsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProgramsResponse.ProtoReflect.Descriptor instead.
func (*ListProgramsResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescGZIP(), []int{3}
}

func (x *ListProgramsResponse) GetPrograms() []*Program {
	if x != nil {
		return x.Programs
	}
	return nil
}

func (x *ListProgramsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the EnableProgram method.
type EnableProgramRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the program for which to enable participation for the
	// given account. Format: `accounts/{account}/programs/{program}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *EnableProgramRequest) Reset() {
	*x = EnableProgramRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnableProgramRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnableProgramRequest) ProtoMessage() {}

func (x *EnableProgramRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnableProgramRequest.ProtoReflect.Descriptor instead.
func (*EnableProgramRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescGZIP(), []int{4}
}

func (x *EnableProgramRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the DisableProgram method.
type DisableProgramRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the program for which to disable participation for
	// the given account. Format: `accounts/{account}/programs/{program}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DisableProgramRequest) Reset() {
	*x = DisableProgramRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisableProgramRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisableProgramRequest) ProtoMessage() {}

func (x *DisableProgramRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisableProgramRequest.ProtoReflect.Descriptor instead.
func (*DisableProgramRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescGZIP(), []int{5}
}

func (x *DisableProgramRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Defines a requirement specified for participation in the program.
type Program_Requirement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the requirement.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Output only. The URL of a help page describing the requirement.
	DocumentationUri string `protobuf:"bytes,2,opt,name=documentation_uri,json=documentationUri,proto3" json:"documentation_uri,omitempty"`
	// Output only. The regions that are currently affected by this requirement
	// not being met.
	//
	// Region codes are defined by [CLDR](https://cldr.unicode.org/). This is
	// either a country where the program applies specifically to that country
	// or `001` when the program applies globally.
	AffectedRegionCodes []string `protobuf:"bytes,3,rep,name=affected_region_codes,json=affectedRegionCodes,proto3" json:"affected_region_codes,omitempty"`
}

func (x *Program_Requirement) Reset() {
	*x = Program_Requirement{}
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Program_Requirement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Program_Requirement) ProtoMessage() {}

func (x *Program_Requirement) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Program_Requirement.ProtoReflect.Descriptor instead.
func (*Program_Requirement) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Program_Requirement) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Program_Requirement) GetDocumentationUri() string {
	if x != nil {
		return x.DocumentationUri
	}
	return ""
}

func (x *Program_Requirement) GetAffectedRegionCodes() []string {
	if x != nil {
		return x.AffectedRegionCodes
	}
	return nil
}

var File_google_shopping_merchant_accounts_v1beta_programs_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x96, 0x05, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x11, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x72, 0x69, 0x12, 0x52, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x11, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x71, 0x0a, 0x12, 0x75, 0x6e, 0x6d, 0x65, 0x74, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x75, 0x6e, 0x6d, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x93, 0x01, 0x0a, 0x0b, 0x52, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x12, 0x30, 0x0a, 0x11, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x55, 0x72, 0x69, 0x12, 0x37, 0x0a, 0x15, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x61, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x22,
	0x4b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x4c, 0x49, 0x47, 0x49, 0x42, 0x4c, 0x45, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4c, 0x49, 0x47, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12,
	0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x61, 0xea, 0x41,
	0x5e, 0x0a, 0x22, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x25, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x7d, 0x2a, 0x08, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x32, 0x07, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x22,
	0x53, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9f, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4d, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x56, 0x0a, 0x14, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x57,
	0x0a, 0x15, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x84, 0x07, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xba, 0x01, 0x0a, 0x0a,
	0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcd, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x12, 0xca, 0x01, 0x0a, 0x0d, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x22, 0x46, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x01, 0x2a, 0x22,
	0x34, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x12, 0xcd, 0x01, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x22, 0x47, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35,
	0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x8f,
	0x01, 0x0a, 0x2c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42,
	0x0d, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x4e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x70, 0x62, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70, 0x62,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescData = file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDesc
)

func file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescData)
	})
	return file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDescData
}

var file_google_shopping_merchant_accounts_v1beta_programs_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_shopping_merchant_accounts_v1beta_programs_proto_goTypes = []any{
	(Program_State)(0),            // 0: google.shopping.merchant.accounts.v1beta.Program.State
	(*Program)(nil),               // 1: google.shopping.merchant.accounts.v1beta.Program
	(*GetProgramRequest)(nil),     // 2: google.shopping.merchant.accounts.v1beta.GetProgramRequest
	(*ListProgramsRequest)(nil),   // 3: google.shopping.merchant.accounts.v1beta.ListProgramsRequest
	(*ListProgramsResponse)(nil),  // 4: google.shopping.merchant.accounts.v1beta.ListProgramsResponse
	(*EnableProgramRequest)(nil),  // 5: google.shopping.merchant.accounts.v1beta.EnableProgramRequest
	(*DisableProgramRequest)(nil), // 6: google.shopping.merchant.accounts.v1beta.DisableProgramRequest
	(*Program_Requirement)(nil),   // 7: google.shopping.merchant.accounts.v1beta.Program.Requirement
}
var file_google_shopping_merchant_accounts_v1beta_programs_proto_depIdxs = []int32{
	0, // 0: google.shopping.merchant.accounts.v1beta.Program.state:type_name -> google.shopping.merchant.accounts.v1beta.Program.State
	7, // 1: google.shopping.merchant.accounts.v1beta.Program.unmet_requirements:type_name -> google.shopping.merchant.accounts.v1beta.Program.Requirement
	1, // 2: google.shopping.merchant.accounts.v1beta.ListProgramsResponse.programs:type_name -> google.shopping.merchant.accounts.v1beta.Program
	2, // 3: google.shopping.merchant.accounts.v1beta.ProgramsService.GetProgram:input_type -> google.shopping.merchant.accounts.v1beta.GetProgramRequest
	3, // 4: google.shopping.merchant.accounts.v1beta.ProgramsService.ListPrograms:input_type -> google.shopping.merchant.accounts.v1beta.ListProgramsRequest
	5, // 5: google.shopping.merchant.accounts.v1beta.ProgramsService.EnableProgram:input_type -> google.shopping.merchant.accounts.v1beta.EnableProgramRequest
	6, // 6: google.shopping.merchant.accounts.v1beta.ProgramsService.DisableProgram:input_type -> google.shopping.merchant.accounts.v1beta.DisableProgramRequest
	1, // 7: google.shopping.merchant.accounts.v1beta.ProgramsService.GetProgram:output_type -> google.shopping.merchant.accounts.v1beta.Program
	4, // 8: google.shopping.merchant.accounts.v1beta.ProgramsService.ListPrograms:output_type -> google.shopping.merchant.accounts.v1beta.ListProgramsResponse
	1, // 9: google.shopping.merchant.accounts.v1beta.ProgramsService.EnableProgram:output_type -> google.shopping.merchant.accounts.v1beta.Program
	1, // 10: google.shopping.merchant.accounts.v1beta.ProgramsService.DisableProgram:output_type -> google.shopping.merchant.accounts.v1beta.Program
	7, // [7:11] is the sub-list for method output_type
	3, // [3:7] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_accounts_v1beta_programs_proto_init() }
func file_google_shopping_merchant_accounts_v1beta_programs_proto_init() {
	if File_google_shopping_merchant_accounts_v1beta_programs_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_accounts_v1beta_programs_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_accounts_v1beta_programs_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_accounts_v1beta_programs_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_accounts_v1beta_programs_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_accounts_v1beta_programs_proto = out.File
	file_google_shopping_merchant_accounts_v1beta_programs_proto_rawDesc = nil
	file_google_shopping_merchant_accounts_v1beta_programs_proto_goTypes = nil
	file_google_shopping_merchant_accounts_v1beta_programs_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ProgramsServiceClient is the client API for ProgramsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProgramsServiceClient interface {
	// Retrieves the specified program for the account.
	GetProgram(ctx context.Context, in *GetProgramRequest, opts ...grpc.CallOption) (*Program, error)
	// Retrieves all programs for the account.
	ListPrograms(ctx context.Context, in *ListProgramsRequest, opts ...grpc.CallOption) (*ListProgramsResponse, error)
	// Enable participation in the specified program for the account. Executing
	// this method requires admin access.
	EnableProgram(ctx context.Context, in *EnableProgramRequest, opts ...grpc.CallOption) (*Program, error)
	// Disable participation in the specified program for the account. Executing
	// this method requires admin access.
	DisableProgram(ctx context.Context, in *DisableProgramRequest, opts ...grpc.CallOption) (*Program, error)
}

type programsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewProgramsServiceClient(cc grpc.ClientConnInterface) ProgramsServiceClient {
	return &programsServiceClient{cc}
}

func (c *programsServiceClient) GetProgram(ctx context.Context, in *GetProgramRequest, opts ...grpc.CallOption) (*Program, error) {
	out := new(Program)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.ProgramsService/GetProgram", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *programsServiceClient) ListPrograms(ctx context.Context, in *ListProgramsRequest, opts ...grpc.CallOption) (*ListProgramsResponse, error) {
	out := new(ListProgramsResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.ProgramsService/ListPrograms", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *programsServiceClient) EnableProgram(ctx context.Context, in *EnableProgramRequest, opts ...grpc.CallOption) (*Program, error) {
	out := new(Program)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.ProgramsService/EnableProgram", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *programsServiceClient) DisableProgram(ctx context.Context, in *DisableProgramRequest, opts ...grpc.CallOption) (*Program, error) {
	out := new(Program)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.ProgramsService/DisableProgram", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProgramsServiceServer is the server API for ProgramsService service.
type ProgramsServiceServer interface {
	// Retrieves the specified program for the account.
	GetProgram(context.Context, *GetProgramRequest) (*Program, error)
	// Retrieves all programs for the account.
	ListPrograms(context.Context, *ListProgramsRequest) (*ListProgramsResponse, error)
	// Enable participation in the specified program for the account. Executing
	// this method requires admin access.
	EnableProgram(context.Context, *EnableProgramRequest) (*Program, error)
	// Disable participation in the specified program for the account. Executing
	// this method requires admin access.
	DisableProgram(context.Context, *DisableProgramRequest) (*Program, error)
}

// UnimplementedProgramsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedProgramsServiceServer struct {
}

func (*UnimplementedProgramsServiceServer) GetProgram(context.Context, *GetProgramRequest) (*Program, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProgram not implemented")
}
func (*UnimplementedProgramsServiceServer) ListPrograms(context.Context, *ListProgramsRequest) (*ListProgramsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrograms not implemented")
}
func (*UnimplementedProgramsServiceServer) EnableProgram(context.Context, *EnableProgramRequest) (*Program, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableProgram not implemented")
}
func (*UnimplementedProgramsServiceServer) DisableProgram(context.Context, *DisableProgramRequest) (*Program, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableProgram not implemented")
}

func RegisterProgramsServiceServer(s *grpc.Server, srv ProgramsServiceServer) {
	s.RegisterService(&_ProgramsService_serviceDesc, srv)
}

func _ProgramsService_GetProgram_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProgramRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProgramsServiceServer).GetProgram(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.ProgramsService/GetProgram",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProgramsServiceServer).GetProgram(ctx, req.(*GetProgramRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProgramsService_ListPrograms_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProgramsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProgramsServiceServer).ListPrograms(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.ProgramsService/ListPrograms",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProgramsServiceServer).ListPrograms(ctx, req.(*ListProgramsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProgramsService_EnableProgram_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableProgramRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProgramsServiceServer).EnableProgram(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.ProgramsService/EnableProgram",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProgramsServiceServer).EnableProgram(ctx, req.(*EnableProgramRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProgramsService_DisableProgram_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableProgramRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProgramsServiceServer).DisableProgram(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.ProgramsService/DisableProgram",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProgramsServiceServer).DisableProgram(ctx, req.(*DisableProgramRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProgramsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.accounts.v1beta.ProgramsService",
	HandlerType: (*ProgramsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetProgram",
			Handler:    _ProgramsService_GetProgram_Handler,
		},
		{
			MethodName: "ListPrograms",
			Handler:    _ProgramsService_ListPrograms_Handler,
		},
		{
			MethodName: "EnableProgram",
			Handler:    _ProgramsService_EnableProgram_Handler,
		},
		{
			MethodName: "DisableProgram",
			Handler:    _ProgramsService_DisableProgram_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/accounts/v1beta/programs.proto",
}
