// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/inventories/v1beta/localinventory.proto

package inventoriespb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	interval "google.golang.org/genproto/googleapis/type/interval"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Local inventory information for the product. Represents in-store information
// for a specific product at the store specified by
// [`storeCode`][google.shopping.merchant.inventories.v1beta.LocalInventory.store_code].
// For a list of all accepted attribute values, see the [local product inventory
// data specification](https://support.google.com/merchants/answer/3061342).
type LocalInventory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the `LocalInventory` resource.
	// Format:
	// `accounts/{account}/products/{product}/localInventories/{store_code}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The account that owns the product. This field will be ignored
	// if set by the client.
	Account int64 `protobuf:"varint,2,opt,name=account,proto3" json:"account,omitempty"`
	// Required. Immutable. Store code (the store ID from your Business Profile)
	// of the physical store the product is sold in. See the [Local product
	// inventory data
	// specification](https://support.google.com/merchants/answer/3061342) for
	// more information.
	StoreCode string `protobuf:"bytes,3,opt,name=store_code,json=storeCode,proto3" json:"store_code,omitempty"`
	// Price of the product at this store.
	Price *typepb.Price `protobuf:"bytes,4,opt,name=price,proto3" json:"price,omitempty"`
	// Sale price of the product at this store. Mandatory if
	// [`salePriceEffectiveDate`][google.shopping.merchant.inventories.v1beta.LocalInventory.sale_price_effective_date]
	// is defined.
	SalePrice *typepb.Price `protobuf:"bytes,5,opt,name=sale_price,json=salePrice,proto3" json:"sale_price,omitempty"`
	// The `TimePeriod` of the
	// sale at this store.
	SalePriceEffectiveDate *interval.Interval `protobuf:"bytes,6,opt,name=sale_price_effective_date,json=salePriceEffectiveDate,proto3" json:"sale_price_effective_date,omitempty"`
	// Availability of the product at this store.
	// For accepted attribute values, see the [local product inventory data
	// specification](https://support.google.com/merchants/answer/3061342)
	Availability *string `protobuf:"bytes,7,opt,name=availability,proto3,oneof" json:"availability,omitempty"`
	// Quantity of the product available at this store. Must be greater than or
	// equal to zero.
	Quantity *int64 `protobuf:"varint,8,opt,name=quantity,proto3,oneof" json:"quantity,omitempty"`
	// Supported pickup method for this product. Unless the value is `"not
	// supported"`, this field must be submitted together with
	// `pickupSla`.
	// For accepted attribute values, see the [local product inventory data
	// specification](https://support.google.com/merchants/answer/3061342)
	PickupMethod *string `protobuf:"bytes,9,opt,name=pickup_method,json=pickupMethod,proto3,oneof" json:"pickup_method,omitempty"`
	// Relative time period from the order date for an order for this product,
	// from this store, to be ready for pickup. Must be submitted with
	// `pickupMethod`.
	// For accepted attribute values, see the [local product inventory data
	// specification](https://support.google.com/merchants/answer/3061342)
	PickupSla *string `protobuf:"bytes,10,opt,name=pickup_sla,json=pickupSla,proto3,oneof" json:"pickup_sla,omitempty"`
	// Location of the product inside the store. Maximum length is 20 bytes.
	InstoreProductLocation *string `protobuf:"bytes,11,opt,name=instore_product_location,json=instoreProductLocation,proto3,oneof" json:"instore_product_location,omitempty"`
	// A list of custom (merchant-provided) attributes. You can also use
	// `CustomAttribute` to submit any attribute of the data specification in its
	// generic form.
	CustomAttributes []*typepb.CustomAttribute `protobuf:"bytes,12,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty"`
}

func (x *LocalInventory) Reset() {
	*x = LocalInventory{}
	mi := &file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalInventory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalInventory) ProtoMessage() {}

func (x *LocalInventory) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalInventory.ProtoReflect.Descriptor instead.
func (*LocalInventory) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescGZIP(), []int{0}
}

func (x *LocalInventory) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LocalInventory) GetAccount() int64 {
	if x != nil {
		return x.Account
	}
	return 0
}

func (x *LocalInventory) GetStoreCode() string {
	if x != nil {
		return x.StoreCode
	}
	return ""
}

func (x *LocalInventory) GetPrice() *typepb.Price {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *LocalInventory) GetSalePrice() *typepb.Price {
	if x != nil {
		return x.SalePrice
	}
	return nil
}

func (x *LocalInventory) GetSalePriceEffectiveDate() *interval.Interval {
	if x != nil {
		return x.SalePriceEffectiveDate
	}
	return nil
}

func (x *LocalInventory) GetAvailability() string {
	if x != nil && x.Availability != nil {
		return *x.Availability
	}
	return ""
}

func (x *LocalInventory) GetQuantity() int64 {
	if x != nil && x.Quantity != nil {
		return *x.Quantity
	}
	return 0
}

func (x *LocalInventory) GetPickupMethod() string {
	if x != nil && x.PickupMethod != nil {
		return *x.PickupMethod
	}
	return ""
}

func (x *LocalInventory) GetPickupSla() string {
	if x != nil && x.PickupSla != nil {
		return *x.PickupSla
	}
	return ""
}

func (x *LocalInventory) GetInstoreProductLocation() string {
	if x != nil && x.InstoreProductLocation != nil {
		return *x.InstoreProductLocation
	}
	return ""
}

func (x *LocalInventory) GetCustomAttributes() []*typepb.CustomAttribute {
	if x != nil {
		return x.CustomAttributes
	}
	return nil
}

// Request message for the `ListLocalInventories` method.
type ListLocalInventoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `name` of the parent product to list local inventories for.
	// Format:
	// `accounts/{account}/products/{product}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of `LocalInventory` resources for the given
	// product to return. The service returns fewer than this value if the number
	// of inventories for the given product is less that than the `pageSize`. The
	// default value is 25000. The maximum value is 25000; If a value higher than
	// the maximum is specified, then the `pageSize` will default to the maximum
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListLocalInventories` call.
	// Provide the page token to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListLocalInventories`
	// must match the call that provided the page token. The token returned as
	// [nextPageToken][google.shopping.merchant.inventories.v1beta.ListLocalInventoriesResponse.next_page_token]
	// in the response to the previous request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListLocalInventoriesRequest) Reset() {
	*x = ListLocalInventoriesRequest{}
	mi := &file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLocalInventoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLocalInventoriesRequest) ProtoMessage() {}

func (x *ListLocalInventoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLocalInventoriesRequest.ProtoReflect.Descriptor instead.
func (*ListLocalInventoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescGZIP(), []int{1}
}

func (x *ListLocalInventoriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLocalInventoriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLocalInventoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the `ListLocalInventories` method.
type ListLocalInventoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `LocalInventory` resources for the given product from the specified
	// account.
	LocalInventories []*LocalInventory `protobuf:"bytes,1,rep,name=local_inventories,json=localInventories,proto3" json:"local_inventories,omitempty"`
	// A token, which can be sent as `pageToken` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLocalInventoriesResponse) Reset() {
	*x = ListLocalInventoriesResponse{}
	mi := &file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListLocalInventoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLocalInventoriesResponse) ProtoMessage() {}

func (x *ListLocalInventoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLocalInventoriesResponse.ProtoReflect.Descriptor instead.
func (*ListLocalInventoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescGZIP(), []int{2}
}

func (x *ListLocalInventoriesResponse) GetLocalInventories() []*LocalInventory {
	if x != nil {
		return x.LocalInventories
	}
	return nil
}

func (x *ListLocalInventoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for the `InsertLocalInventory` method.
type InsertLocalInventoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account and product where this inventory will be inserted.
	// Format: `accounts/{account}/products/{product}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Local inventory information of the product. If the product
	// already has a `LocalInventory` resource for the same `storeCode`, full
	// replacement of the `LocalInventory` resource is performed.
	LocalInventory *LocalInventory `protobuf:"bytes,2,opt,name=local_inventory,json=localInventory,proto3" json:"local_inventory,omitempty"`
}

func (x *InsertLocalInventoryRequest) Reset() {
	*x = InsertLocalInventoryRequest{}
	mi := &file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InsertLocalInventoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertLocalInventoryRequest) ProtoMessage() {}

func (x *InsertLocalInventoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertLocalInventoryRequest.ProtoReflect.Descriptor instead.
func (*InsertLocalInventoryRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescGZIP(), []int{3}
}

func (x *InsertLocalInventoryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *InsertLocalInventoryRequest) GetLocalInventory() *LocalInventory {
	if x != nil {
		return x.LocalInventory
	}
	return nil
}

// Request message for the `DeleteLocalInventory` method.
type DeleteLocalInventoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the local inventory for the given product to delete.
	// Format:
	// `accounts/{account}/products/{product}/localInventories/{store_code}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteLocalInventoryRequest) Reset() {
	*x = DeleteLocalInventoryRequest{}
	mi := &file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteLocalInventoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteLocalInventoryRequest) ProtoMessage() {}

func (x *DeleteLocalInventoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteLocalInventoryRequest.ProtoReflect.Descriptor instead.
func (*DeleteLocalInventoryRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteLocalInventoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_shopping_merchant_inventories_v1beta_localinventory_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDesc = []byte{
	0x0a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x69, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xac, 0x06,
	0x0a, 0x0e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0a, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x31, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x05, 0x70, 0x72, 0x69,
	0x63, 0x65, 0x12, 0x3a, 0x0a, 0x0a, 0x73, 0x61, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72,
	0x69, 0x63, 0x65, 0x52, 0x09, 0x73, 0x61, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x63, 0x65, 0x12, 0x50,
	0x0a, 0x19, 0x73, 0x61, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52, 0x16, 0x73, 0x61, 0x6c, 0x65, 0x50, 0x72,
	0x69, 0x63, 0x65, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x61, 0x74, 0x65,
	0x12, 0x27, 0x0a, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x71, 0x75, 0x61,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x48, 0x01, 0x52, 0x08, 0x71,
	0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x70, 0x69,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x02, 0x52, 0x0c, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73,
	0x6c, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x09, 0x70, 0x69, 0x63, 0x6b,
	0x75, 0x70, 0x53, 0x6c, 0x61, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x18, 0x69, 0x6e, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x16, 0x69, 0x6e,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x0c, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x3a, 0x73, 0xea, 0x41, 0x70,
	0x0a, 0x29, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x43, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x7d,
	0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x42, 0x10,
	0x0a, 0x0e, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x6c, 0x61, 0x42,
	0x1b, 0x0a, 0x19, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x01, 0x0a,
	0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xb0, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61,
	0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x68, 0x0a, 0x11, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x69, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x10, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd3, 0x01, 0x0a, 0x1b, 0x49, 0x6e, 0x73, 0x65, 0x72,
	0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x69, 0x0a, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x64, 0x0a, 0x1b,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2b, 0x0a, 0x29, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x32, 0xb8, 0x06, 0x0a, 0x15, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65,
	0x6e, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x81, 0x02, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x69, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x12, 0x82, 0x02, 0x0a, 0x14, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79,
	0x22, 0x63, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x3a, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f,
	0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x4a, 0x2f, 0x69, 0x6e, 0x76, 0x65,
	0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x69,
	0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0xcc, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x48,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x52, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x2a,
	0x43, 0x2f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0xef, 0x01,
	0xea, 0x41, 0x4b, 0x0a, 0x22, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x25, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x7d, 0x0a, 0x2f,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x69, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42,
	0x13, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x57, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x69, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x70,
	0x62, 0x3b, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x70, 0x62, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescData = file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDesc
)

func file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescData)
	})
	return file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDescData
}

var file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_shopping_merchant_inventories_v1beta_localinventory_proto_goTypes = []any{
	(*LocalInventory)(nil),               // 0: google.shopping.merchant.inventories.v1beta.LocalInventory
	(*ListLocalInventoriesRequest)(nil),  // 1: google.shopping.merchant.inventories.v1beta.ListLocalInventoriesRequest
	(*ListLocalInventoriesResponse)(nil), // 2: google.shopping.merchant.inventories.v1beta.ListLocalInventoriesResponse
	(*InsertLocalInventoryRequest)(nil),  // 3: google.shopping.merchant.inventories.v1beta.InsertLocalInventoryRequest
	(*DeleteLocalInventoryRequest)(nil),  // 4: google.shopping.merchant.inventories.v1beta.DeleteLocalInventoryRequest
	(*typepb.Price)(nil),                 // 5: google.shopping.type.Price
	(*interval.Interval)(nil),            // 6: google.type.Interval
	(*typepb.CustomAttribute)(nil),       // 7: google.shopping.type.CustomAttribute
	(*emptypb.Empty)(nil),                // 8: google.protobuf.Empty
}
var file_google_shopping_merchant_inventories_v1beta_localinventory_proto_depIdxs = []int32{
	5, // 0: google.shopping.merchant.inventories.v1beta.LocalInventory.price:type_name -> google.shopping.type.Price
	5, // 1: google.shopping.merchant.inventories.v1beta.LocalInventory.sale_price:type_name -> google.shopping.type.Price
	6, // 2: google.shopping.merchant.inventories.v1beta.LocalInventory.sale_price_effective_date:type_name -> google.type.Interval
	7, // 3: google.shopping.merchant.inventories.v1beta.LocalInventory.custom_attributes:type_name -> google.shopping.type.CustomAttribute
	0, // 4: google.shopping.merchant.inventories.v1beta.ListLocalInventoriesResponse.local_inventories:type_name -> google.shopping.merchant.inventories.v1beta.LocalInventory
	0, // 5: google.shopping.merchant.inventories.v1beta.InsertLocalInventoryRequest.local_inventory:type_name -> google.shopping.merchant.inventories.v1beta.LocalInventory
	1, // 6: google.shopping.merchant.inventories.v1beta.LocalInventoryService.ListLocalInventories:input_type -> google.shopping.merchant.inventories.v1beta.ListLocalInventoriesRequest
	3, // 7: google.shopping.merchant.inventories.v1beta.LocalInventoryService.InsertLocalInventory:input_type -> google.shopping.merchant.inventories.v1beta.InsertLocalInventoryRequest
	4, // 8: google.shopping.merchant.inventories.v1beta.LocalInventoryService.DeleteLocalInventory:input_type -> google.shopping.merchant.inventories.v1beta.DeleteLocalInventoryRequest
	2, // 9: google.shopping.merchant.inventories.v1beta.LocalInventoryService.ListLocalInventories:output_type -> google.shopping.merchant.inventories.v1beta.ListLocalInventoriesResponse
	0, // 10: google.shopping.merchant.inventories.v1beta.LocalInventoryService.InsertLocalInventory:output_type -> google.shopping.merchant.inventories.v1beta.LocalInventory
	8, // 11: google.shopping.merchant.inventories.v1beta.LocalInventoryService.DeleteLocalInventory:output_type -> google.protobuf.Empty
	9, // [9:12] is the sub-list for method output_type
	6, // [6:9] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_inventories_v1beta_localinventory_proto_init() }
func file_google_shopping_merchant_inventories_v1beta_localinventory_proto_init() {
	if File_google_shopping_merchant_inventories_v1beta_localinventory_proto != nil {
		return
	}
	file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_inventories_v1beta_localinventory_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_inventories_v1beta_localinventory_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_inventories_v1beta_localinventory_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_inventories_v1beta_localinventory_proto = out.File
	file_google_shopping_merchant_inventories_v1beta_localinventory_proto_rawDesc = nil
	file_google_shopping_merchant_inventories_v1beta_localinventory_proto_goTypes = nil
	file_google_shopping_merchant_inventories_v1beta_localinventory_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LocalInventoryServiceClient is the client API for LocalInventoryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LocalInventoryServiceClient interface {
	// Lists the `LocalInventory` resources for the given product in your merchant
	// account. The response might contain fewer items than specified by
	// `pageSize`. If `pageToken` was returned in previous request, it can be used
	// to obtain additional results.
	//
	// `LocalInventory` resources are listed per product for a given account.
	ListLocalInventories(ctx context.Context, in *ListLocalInventoriesRequest, opts ...grpc.CallOption) (*ListLocalInventoriesResponse, error)
	// Inserts a `LocalInventory` resource to a product in your merchant
	// account.
	//
	// Replaces the full `LocalInventory` resource if an entry with the same
	// [`storeCode`][google.shopping.merchant.inventories.v1beta.LocalInventory.store_code]
	// already exists for the product.
	//
	// It might take up to 30 minutes for the new or updated `LocalInventory`
	// resource to appear in products.
	InsertLocalInventory(ctx context.Context, in *InsertLocalInventoryRequest, opts ...grpc.CallOption) (*LocalInventory, error)
	// Deletes the specified `LocalInventory` from the given product in your
	// merchant account. It might take a up to an hour for the
	// `LocalInventory` to be deleted from the specific product.
	// Once you have received a successful delete response, wait for that
	// period before attempting a delete again.
	DeleteLocalInventory(ctx context.Context, in *DeleteLocalInventoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type localInventoryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLocalInventoryServiceClient(cc grpc.ClientConnInterface) LocalInventoryServiceClient {
	return &localInventoryServiceClient{cc}
}

func (c *localInventoryServiceClient) ListLocalInventories(ctx context.Context, in *ListLocalInventoriesRequest, opts ...grpc.CallOption) (*ListLocalInventoriesResponse, error) {
	out := new(ListLocalInventoriesResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.inventories.v1beta.LocalInventoryService/ListLocalInventories", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localInventoryServiceClient) InsertLocalInventory(ctx context.Context, in *InsertLocalInventoryRequest, opts ...grpc.CallOption) (*LocalInventory, error) {
	out := new(LocalInventory)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.inventories.v1beta.LocalInventoryService/InsertLocalInventory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *localInventoryServiceClient) DeleteLocalInventory(ctx context.Context, in *DeleteLocalInventoryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.inventories.v1beta.LocalInventoryService/DeleteLocalInventory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LocalInventoryServiceServer is the server API for LocalInventoryService service.
type LocalInventoryServiceServer interface {
	// Lists the `LocalInventory` resources for the given product in your merchant
	// account. The response might contain fewer items than specified by
	// `pageSize`. If `pageToken` was returned in previous request, it can be used
	// to obtain additional results.
	//
	// `LocalInventory` resources are listed per product for a given account.
	ListLocalInventories(context.Context, *ListLocalInventoriesRequest) (*ListLocalInventoriesResponse, error)
	// Inserts a `LocalInventory` resource to a product in your merchant
	// account.
	//
	// Replaces the full `LocalInventory` resource if an entry with the same
	// [`storeCode`][google.shopping.merchant.inventories.v1beta.LocalInventory.store_code]
	// already exists for the product.
	//
	// It might take up to 30 minutes for the new or updated `LocalInventory`
	// resource to appear in products.
	InsertLocalInventory(context.Context, *InsertLocalInventoryRequest) (*LocalInventory, error)
	// Deletes the specified `LocalInventory` from the given product in your
	// merchant account. It might take a up to an hour for the
	// `LocalInventory` to be deleted from the specific product.
	// Once you have received a successful delete response, wait for that
	// period before attempting a delete again.
	DeleteLocalInventory(context.Context, *DeleteLocalInventoryRequest) (*emptypb.Empty, error)
}

// UnimplementedLocalInventoryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLocalInventoryServiceServer struct {
}

func (*UnimplementedLocalInventoryServiceServer) ListLocalInventories(context.Context, *ListLocalInventoriesRequest) (*ListLocalInventoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLocalInventories not implemented")
}
func (*UnimplementedLocalInventoryServiceServer) InsertLocalInventory(context.Context, *InsertLocalInventoryRequest) (*LocalInventory, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertLocalInventory not implemented")
}
func (*UnimplementedLocalInventoryServiceServer) DeleteLocalInventory(context.Context, *DeleteLocalInventoryRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteLocalInventory not implemented")
}

func RegisterLocalInventoryServiceServer(s *grpc.Server, srv LocalInventoryServiceServer) {
	s.RegisterService(&_LocalInventoryService_serviceDesc, srv)
}

func _LocalInventoryService_ListLocalInventories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLocalInventoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalInventoryServiceServer).ListLocalInventories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.inventories.v1beta.LocalInventoryService/ListLocalInventories",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalInventoryServiceServer).ListLocalInventories(ctx, req.(*ListLocalInventoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalInventoryService_InsertLocalInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertLocalInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalInventoryServiceServer).InsertLocalInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.inventories.v1beta.LocalInventoryService/InsertLocalInventory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalInventoryServiceServer).InsertLocalInventory(ctx, req.(*InsertLocalInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LocalInventoryService_DeleteLocalInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLocalInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LocalInventoryServiceServer).DeleteLocalInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.inventories.v1beta.LocalInventoryService/DeleteLocalInventory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LocalInventoryServiceServer).DeleteLocalInventory(ctx, req.(*DeleteLocalInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LocalInventoryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.inventories.v1beta.LocalInventoryService",
	HandlerType: (*LocalInventoryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListLocalInventories",
			Handler:    _LocalInventoryService_ListLocalInventories_Handler,
		},
		{
			MethodName: "InsertLocalInventory",
			Handler:    _LocalInventoryService_InsertLocalInventory_Handler,
		},
		{
			MethodName: "DeleteLocalInventory",
			Handler:    _LocalInventoryService_DeleteLocalInventory_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/inventories/v1beta/localinventory.proto",
}
