// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/telcoautomation/v1/telcoautomation.proto

package telcoautomationpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// BlueprintView defines the type of view of the blueprint.
type BlueprintView int32

const (
	// Unspecified enum value.
	BlueprintView_BLUEPRINT_VIEW_UNSPECIFIED BlueprintView = 0
	// View which only contains metadata.
	BlueprintView_BLUEPRINT_VIEW_BASIC BlueprintView = 1
	// View which contains metadata and files it encapsulates.
	BlueprintView_BLUEPRINT_VIEW_FULL BlueprintView = 2
)

// Enum value maps for BlueprintView.
var (
	BlueprintView_name = map[int32]string{
		0: "BLUEPRINT_VIEW_UNSPECIFIED",
		1: "BLUEPRINT_VIEW_BASIC",
		2: "BLUEPRINT_VIEW_FULL",
	}
	BlueprintView_value = map[string]int32{
		"BLUEPRINT_VIEW_UNSPECIFIED": 0,
		"BLUEPRINT_VIEW_BASIC":       1,
		"BLUEPRINT_VIEW_FULL":        2,
	}
)

func (x BlueprintView) Enum() *BlueprintView {
	p := new(BlueprintView)
	*p = x
	return p
}

func (x BlueprintView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BlueprintView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[0].Descriptor()
}

func (BlueprintView) Type() protoreflect.EnumType {
	return &file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[0]
}

func (x BlueprintView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BlueprintView.Descriptor instead.
func (BlueprintView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{0}
}

// DeploymentView defines the type of view of the deployment.
type DeploymentView int32

const (
	// Unspecified enum value.
	DeploymentView_DEPLOYMENT_VIEW_UNSPECIFIED DeploymentView = 0
	// View which only contains metadata.
	DeploymentView_DEPLOYMENT_VIEW_BASIC DeploymentView = 1
	// View which contains metadata and files it encapsulates.
	DeploymentView_DEPLOYMENT_VIEW_FULL DeploymentView = 2
)

// Enum value maps for DeploymentView.
var (
	DeploymentView_name = map[int32]string{
		0: "DEPLOYMENT_VIEW_UNSPECIFIED",
		1: "DEPLOYMENT_VIEW_BASIC",
		2: "DEPLOYMENT_VIEW_FULL",
	}
	DeploymentView_value = map[string]int32{
		"DEPLOYMENT_VIEW_UNSPECIFIED": 0,
		"DEPLOYMENT_VIEW_BASIC":       1,
		"DEPLOYMENT_VIEW_FULL":        2,
	}
)

func (x DeploymentView) Enum() *DeploymentView {
	p := new(DeploymentView)
	*p = x
	return p
}

func (x DeploymentView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeploymentView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[1].Descriptor()
}

func (DeploymentView) Type() protoreflect.EnumType {
	return &file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[1]
}

func (x DeploymentView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeploymentView.Descriptor instead.
func (DeploymentView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{1}
}

// Represent type of CR.
type ResourceType int32

const (
	// Unspecified resource type.
	ResourceType_RESOURCE_TYPE_UNSPECIFIED ResourceType = 0
	// User specified NF Deploy CR.
	ResourceType_NF_DEPLOY_RESOURCE ResourceType = 1
	// CRs that are part of a blueprint.
	ResourceType_DEPLOYMENT_RESOURCE ResourceType = 2
)

// Enum value maps for ResourceType.
var (
	ResourceType_name = map[int32]string{
		0: "RESOURCE_TYPE_UNSPECIFIED",
		1: "NF_DEPLOY_RESOURCE",
		2: "DEPLOYMENT_RESOURCE",
	}
	ResourceType_value = map[string]int32{
		"RESOURCE_TYPE_UNSPECIFIED": 0,
		"NF_DEPLOY_RESOURCE":        1,
		"DEPLOYMENT_RESOURCE":       2,
	}
)

func (x ResourceType) Enum() *ResourceType {
	p := new(ResourceType)
	*p = x
	return p
}

func (x ResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[2].Descriptor()
}

func (ResourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[2]
}

func (x ResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceType.Descriptor instead.
func (ResourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{2}
}

// Status of an entity (resource, deployment).
type Status int32

const (
	// Unknown state.
	Status_STATUS_UNSPECIFIED Status = 0
	// Under progress.
	Status_STATUS_IN_PROGRESS Status = 1
	// Running and ready to serve traffic.
	Status_STATUS_ACTIVE Status = 2
	// Failed or stalled.
	Status_STATUS_FAILED Status = 3
	// Delete in progress.
	Status_STATUS_DELETING Status = 4
	// Deleted deployment.
	Status_STATUS_DELETED Status = 5
	// NFDeploy specific status. Peering in progress.
	Status_STATUS_PEERING Status = 10
	// K8s objects such as NetworkAttachmentDefinition don't have a defined
	// status.
	Status_STATUS_NOT_APPLICABLE Status = 11
)

// Enum value maps for Status.
var (
	Status_name = map[int32]string{
		0:  "STATUS_UNSPECIFIED",
		1:  "STATUS_IN_PROGRESS",
		2:  "STATUS_ACTIVE",
		3:  "STATUS_FAILED",
		4:  "STATUS_DELETING",
		5:  "STATUS_DELETED",
		10: "STATUS_PEERING",
		11: "STATUS_NOT_APPLICABLE",
	}
	Status_value = map[string]int32{
		"STATUS_UNSPECIFIED":    0,
		"STATUS_IN_PROGRESS":    1,
		"STATUS_ACTIVE":         2,
		"STATUS_FAILED":         3,
		"STATUS_DELETING":       4,
		"STATUS_DELETED":        5,
		"STATUS_PEERING":        10,
		"STATUS_NOT_APPLICABLE": 11,
	}
)

func (x Status) Enum() *Status {
	p := new(Status)
	*p = x
	return p
}

func (x Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[3].Descriptor()
}

func (Status) Type() protoreflect.EnumType {
	return &file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[3]
}

func (x Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Status.Descriptor instead.
func (Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{3}
}

// DeploymentLevel of a blueprint signifies where the blueprint will be
// applied.
type DeploymentLevel int32

const (
	// Default unspecified deployment level.
	DeploymentLevel_DEPLOYMENT_LEVEL_UNSPECIFIED DeploymentLevel = 0
	// Blueprints at HYDRATION level cannot be used to create a Deployment
	// (A user cannot manually initate deployment of these blueprints on
	// orchestration or workload cluster).
	// These blueprints stay in a user's private catalog and are configured and
	// deployed by TNA automation.
	DeploymentLevel_HYDRATION DeploymentLevel = 1
	// Blueprints at SINGLE_DEPLOYMENT level can be
	// a) Modified in private catalog.
	// b) Used to create a deployment on orchestration cluster by the user, once
	// approved.
	DeploymentLevel_SINGLE_DEPLOYMENT DeploymentLevel = 2
	// Blueprints at MULTI_DEPLOYMENT level can be
	// a) Modified in private catalog.
	// b) Used to create a deployment on orchestration cluster which will create
	// further hydrated deployments.
	DeploymentLevel_MULTI_DEPLOYMENT DeploymentLevel = 3
	// Blueprints at WORKLOAD_CLUSTER_DEPLOYMENT level can be
	// a) Modified in private catalog.
	// b) Used to create a deployment on workload cluster by the user, once
	// approved.
	DeploymentLevel_WORKLOAD_CLUSTER_DEPLOYMENT DeploymentLevel = 4
)

// Enum value maps for DeploymentLevel.
var (
	DeploymentLevel_name = map[int32]string{
		0: "DEPLOYMENT_LEVEL_UNSPECIFIED",
		1: "HYDRATION",
		2: "SINGLE_DEPLOYMENT",
		3: "MULTI_DEPLOYMENT",
		4: "WORKLOAD_CLUSTER_DEPLOYMENT",
	}
	DeploymentLevel_value = map[string]int32{
		"DEPLOYMENT_LEVEL_UNSPECIFIED": 0,
		"HYDRATION":                    1,
		"SINGLE_DEPLOYMENT":            2,
		"MULTI_DEPLOYMENT":             3,
		"WORKLOAD_CLUSTER_DEPLOYMENT":  4,
	}
)

func (x DeploymentLevel) Enum() *DeploymentLevel {
	p := new(DeploymentLevel)
	*p = x
	return p
}

func (x DeploymentLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeploymentLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[4].Descriptor()
}

func (DeploymentLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[4]
}

func (x DeploymentLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeploymentLevel.Descriptor instead.
func (DeploymentLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{4}
}

// Possible states that the Orchestration Cluster can be in.
type OrchestrationCluster_State int32

const (
	// Unspecified state.
	OrchestrationCluster_STATE_UNSPECIFIED OrchestrationCluster_State = 0
	// OrchestrationCluster is being created.
	OrchestrationCluster_CREATING OrchestrationCluster_State = 1
	// OrchestrationCluster has been created and is ready for use.
	OrchestrationCluster_ACTIVE OrchestrationCluster_State = 2
	// OrchestrationCluster is being deleted.
	OrchestrationCluster_DELETING OrchestrationCluster_State = 3
	// OrchestrationCluster encountered an error and is in an indeterministic
	// state. User can still initiate a delete operation on this state.
	OrchestrationCluster_FAILED OrchestrationCluster_State = 4
)

// Enum value maps for OrchestrationCluster_State.
var (
	OrchestrationCluster_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
		4: "FAILED",
	}
	OrchestrationCluster_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
		"FAILED":            4,
	}
)

func (x OrchestrationCluster_State) Enum() *OrchestrationCluster_State {
	p := new(OrchestrationCluster_State)
	*p = x
	return p
}

func (x OrchestrationCluster_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OrchestrationCluster_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[5].Descriptor()
}

func (OrchestrationCluster_State) Type() protoreflect.EnumType {
	return &file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[5]
}

func (x OrchestrationCluster_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OrchestrationCluster_State.Descriptor instead.
func (OrchestrationCluster_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{0, 0}
}

// Possible states of the resource.
type EdgeSlm_State int32

const (
	// Unspecified state.
	EdgeSlm_STATE_UNSPECIFIED EdgeSlm_State = 0
	// EdgeSlm is being created.
	EdgeSlm_CREATING EdgeSlm_State = 1
	// EdgeSlm has been created and is ready for use.
	EdgeSlm_ACTIVE EdgeSlm_State = 2
	// EdgeSlm is being deleted.
	EdgeSlm_DELETING EdgeSlm_State = 3
	// EdgeSlm encountered an error and is in an indeterministic
	// state. User can still initiate a delete operation on this state.
	EdgeSlm_FAILED EdgeSlm_State = 4
)

// Enum value maps for EdgeSlm_State.
var (
	EdgeSlm_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
		4: "FAILED",
	}
	EdgeSlm_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
		"FAILED":            4,
	}
)

func (x EdgeSlm_State) Enum() *EdgeSlm_State {
	p := new(EdgeSlm_State)
	*p = x
	return p
}

func (x EdgeSlm_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EdgeSlm_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[6].Descriptor()
}

func (EdgeSlm_State) Type() protoreflect.EnumType {
	return &file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[6]
}

func (x EdgeSlm_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EdgeSlm_State.Descriptor instead.
func (EdgeSlm_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{1, 0}
}

// Workload clusters supported by TNA. New values will be added to the enum
// list as TNA adds supports for new workload clusters in future.
type EdgeSlm_WorkloadClusterType int32

const (
	// Unspecified workload cluster.
	EdgeSlm_WORKLOAD_CLUSTER_TYPE_UNSPECIFIED EdgeSlm_WorkloadClusterType = 0
	// Workload cluster is a GDCE cluster.
	EdgeSlm_GDCE EdgeSlm_WorkloadClusterType = 1
	// Workload cluster is a GKE cluster.
	EdgeSlm_GKE EdgeSlm_WorkloadClusterType = 2
)

// Enum value maps for EdgeSlm_WorkloadClusterType.
var (
	EdgeSlm_WorkloadClusterType_name = map[int32]string{
		0: "WORKLOAD_CLUSTER_TYPE_UNSPECIFIED",
		1: "GDCE",
		2: "GKE",
	}
	EdgeSlm_WorkloadClusterType_value = map[string]int32{
		"WORKLOAD_CLUSTER_TYPE_UNSPECIFIED": 0,
		"GDCE":                              1,
		"GKE":                               2,
	}
)

func (x EdgeSlm_WorkloadClusterType) Enum() *EdgeSlm_WorkloadClusterType {
	p := new(EdgeSlm_WorkloadClusterType)
	*p = x
	return p
}

func (x EdgeSlm_WorkloadClusterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EdgeSlm_WorkloadClusterType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[7].Descriptor()
}

func (EdgeSlm_WorkloadClusterType) Type() protoreflect.EnumType {
	return &file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[7]
}

func (x EdgeSlm_WorkloadClusterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EdgeSlm_WorkloadClusterType.Descriptor instead.
func (EdgeSlm_WorkloadClusterType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{1, 1}
}

// Approval state indicates the state of a Blueprint in its approval
// lifecycle.
type Blueprint_ApprovalState int32

const (
	// Unspecified state.
	Blueprint_APPROVAL_STATE_UNSPECIFIED Blueprint_ApprovalState = 0
	// A blueprint starts in DRAFT state once it is created. All edits are made
	// to the blueprint in DRAFT state.
	Blueprint_DRAFT Blueprint_ApprovalState = 1
	// When the edits are ready for review, blueprint can be proposed and moves
	// to PROPOSED state. Edits cannot be made to a blueprint in PROPOSED state.
	Blueprint_PROPOSED Blueprint_ApprovalState = 2
	// When a proposed blueprint is approved, it moves to APPROVED state. A new
	// revision is committed. The latest committed revision can be used to
	// create a deployment on Orchestration or Workload Cluster. Edits to an
	// APPROVED blueprint changes its state back to DRAFT. The last committed
	// revision of a blueprint represents its latest APPROVED state.
	Blueprint_APPROVED Blueprint_ApprovalState = 3
)

// Enum value maps for Blueprint_ApprovalState.
var (
	Blueprint_ApprovalState_name = map[int32]string{
		0: "APPROVAL_STATE_UNSPECIFIED",
		1: "DRAFT",
		2: "PROPOSED",
		3: "APPROVED",
	}
	Blueprint_ApprovalState_value = map[string]int32{
		"APPROVAL_STATE_UNSPECIFIED": 0,
		"DRAFT":                      1,
		"PROPOSED":                   2,
		"APPROVED":                   3,
	}
)

func (x Blueprint_ApprovalState) Enum() *Blueprint_ApprovalState {
	p := new(Blueprint_ApprovalState)
	*p = x
	return p
}

func (x Blueprint_ApprovalState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Blueprint_ApprovalState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[8].Descriptor()
}

func (Blueprint_ApprovalState) Type() protoreflect.EnumType {
	return &file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[8]
}

func (x Blueprint_ApprovalState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Blueprint_ApprovalState.Descriptor instead.
func (Blueprint_ApprovalState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{2, 0}
}

// State defines which state the current deployment is in.
type Deployment_State int32

const (
	// Unspecified state.
	Deployment_STATE_UNSPECIFIED Deployment_State = 0
	// A deployment starts in DRAFT state. All edits are made in DRAFT state. A
	// deployment opened for editing after applying will be in draft state,
	// while its prevision revision will be its current applied version.
	Deployment_DRAFT Deployment_State = 1
	// This state means that the contents (YAML files containing kubernetes
	// resources) of the deployment have been applied to an Orchestration or
	// Workload Cluster. A revision is created when a deployment is applied.
	// This revision will represent the latest view of what is applied on the
	// cluster until the deployment is modified and applied again, which will
	// create a new revision.
	Deployment_APPLIED Deployment_State = 2
	// A deployment in DELETING state has been marked for deletion. Its
	// deletion status can be queried using `ComputeDeploymentStatus` API. No
	// updates are allowed to a deployment in DELETING state.
	Deployment_DELETING Deployment_State = 3
)

// Enum value maps for Deployment_State.
var (
	Deployment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "DRAFT",
		2: "APPLIED",
		3: "DELETING",
	}
	Deployment_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"DRAFT":             1,
		"APPLIED":           2,
		"DELETING":          3,
	}
)

func (x Deployment_State) Enum() *Deployment_State {
	p := new(Deployment_State)
	*p = x
	return p
}

func (x Deployment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Deployment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[9].Descriptor()
}

func (Deployment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[9]
}

func (x Deployment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Deployment_State.Descriptor instead.
func (Deployment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{4, 0}
}

// State defines which state the current hydrated deployment is in.
type HydratedDeployment_State int32

const (
	// Unspecified state.
	HydratedDeployment_STATE_UNSPECIFIED HydratedDeployment_State = 0
	// A hydrated deployment starts in DRAFT state. All edits are made in DRAFT
	// state.
	HydratedDeployment_DRAFT HydratedDeployment_State = 1
	// When the edit is applied, the hydrated deployment moves to APPLIED
	// state. No changes can be made once a hydrated deployment is applied.
	HydratedDeployment_APPLIED HydratedDeployment_State = 2
)

// Enum value maps for HydratedDeployment_State.
var (
	HydratedDeployment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "DRAFT",
		2: "APPLIED",
	}
	HydratedDeployment_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"DRAFT":             1,
		"APPLIED":           2,
	}
)

func (x HydratedDeployment_State) Enum() *HydratedDeployment_State {
	p := new(HydratedDeployment_State)
	*p = x
	return p
}

func (x HydratedDeployment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HydratedDeployment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[10].Descriptor()
}

func (HydratedDeployment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes[10]
}

func (x HydratedDeployment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HydratedDeployment_State.Descriptor instead.
func (HydratedDeployment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{5, 0}
}

// Orchestration cluster represents a GKE cluster with config controller and
// TNA specific components installed on it.
type OrchestrationCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the orchestration cluster. The name of orchestration cluster cannot
	// be more than 24 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Management configuration of the underlying GKE cluster.
	ManagementConfig *ManagementConfig `protobuf:"bytes,5,opt,name=management_config,json=managementConfig,proto3" json:"management_config,omitempty"`
	// Output only. [Output only] Create time stamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Update time stamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels as key value pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Provides the TNA version installed on the cluster.
	TnaVersion string `protobuf:"bytes,6,opt,name=tna_version,json=tnaVersion,proto3" json:"tna_version,omitempty"`
	// Output only. State of the Orchestration Cluster.
	State OrchestrationCluster_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.telcoautomation.v1.OrchestrationCluster_State" json:"state,omitempty"`
}

func (x *OrchestrationCluster) Reset() {
	*x = OrchestrationCluster{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OrchestrationCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrchestrationCluster) ProtoMessage() {}

func (x *OrchestrationCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrchestrationCluster.ProtoReflect.Descriptor instead.
func (*OrchestrationCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{0}
}

func (x *OrchestrationCluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OrchestrationCluster) GetManagementConfig() *ManagementConfig {
	if x != nil {
		return x.ManagementConfig
	}
	return nil
}

func (x *OrchestrationCluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OrchestrationCluster) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *OrchestrationCluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *OrchestrationCluster) GetTnaVersion() string {
	if x != nil {
		return x.TnaVersion
	}
	return ""
}

func (x *OrchestrationCluster) GetState() OrchestrationCluster_State {
	if x != nil {
		return x.State
	}
	return OrchestrationCluster_STATE_UNSPECIFIED
}

// EdgeSlm represents an SLM instance which manages the lifecycle of edge
// components installed on Workload clusters managed by an Orchestration
// Cluster.
type EdgeSlm struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the EdgeSlm resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. Reference to the orchestration cluster on which templates for
	// this resources will be applied. This should be of format
	// projects/{project}/locations/{location}/orchestrationClusters/{orchestration_cluster}.
	OrchestrationCluster string `protobuf:"bytes,5,opt,name=orchestration_cluster,json=orchestrationCluster,proto3" json:"orchestration_cluster,omitempty"`
	// Output only. [Output only] Create time stamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Update time stamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Labels as key value pairs. The key and value should contain
	// characters which are UTF-8 compliant and less than 50 characters.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Provides the active TNA version for this resource.
	TnaVersion string `protobuf:"bytes,6,opt,name=tna_version,json=tnaVersion,proto3" json:"tna_version,omitempty"`
	// Output only. State of the EdgeSlm resource.
	State EdgeSlm_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.telcoautomation.v1.EdgeSlm_State" json:"state,omitempty"`
	// Optional. Type of workload cluster for which an EdgeSLM resource is
	// created.
	WorkloadClusterType EdgeSlm_WorkloadClusterType `protobuf:"varint,8,opt,name=workload_cluster_type,json=workloadClusterType,proto3,enum=google.cloud.telcoautomation.v1.EdgeSlm_WorkloadClusterType" json:"workload_cluster_type,omitempty"`
}

func (x *EdgeSlm) Reset() {
	*x = EdgeSlm{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EdgeSlm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EdgeSlm) ProtoMessage() {}

func (x *EdgeSlm) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EdgeSlm.ProtoReflect.Descriptor instead.
func (*EdgeSlm) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{1}
}

func (x *EdgeSlm) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EdgeSlm) GetOrchestrationCluster() string {
	if x != nil {
		return x.OrchestrationCluster
	}
	return ""
}

func (x *EdgeSlm) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EdgeSlm) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EdgeSlm) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EdgeSlm) GetTnaVersion() string {
	if x != nil {
		return x.TnaVersion
	}
	return ""
}

func (x *EdgeSlm) GetState() EdgeSlm_State {
	if x != nil {
		return x.State
	}
	return EdgeSlm_STATE_UNSPECIFIED
}

func (x *EdgeSlm) GetWorkloadClusterType() EdgeSlm_WorkloadClusterType {
	if x != nil {
		return x.WorkloadClusterType
	}
	return EdgeSlm_WORKLOAD_CLUSTER_TYPE_UNSPECIFIED
}

// A Blueprint contains a collection of kubernetes resources in the form of
// YAML files. The file contents of a blueprint are collectively known as
// package. A blueprint can be
// a) imported from TNA's public catalog
// b) modified as per a user's need
// c) proposed and approved.
// On approval, a revision of blueprint is created which can be used to
// create a deployment on Orchestration or Workload Cluster.
type Blueprint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the blueprint. If unspecified, the name will be autogenerated
	// from server side. Name of the blueprint must not contain `@` character.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Immutable. The revision ID of the blueprint.
	// A new revision is committed whenever a blueprint is approved.
	RevisionId string `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	// Required. Immutable. The public blueprint ID from which this blueprint was
	// created.
	SourceBlueprint string `protobuf:"bytes,3,opt,name=source_blueprint,json=sourceBlueprint,proto3" json:"source_blueprint,omitempty"`
	// Output only. The timestamp that the revision was created.
	RevisionCreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=revision_create_time,json=revisionCreateTime,proto3" json:"revision_create_time,omitempty"`
	// Output only. Approval state of the blueprint (DRAFT, PROPOSED, APPROVED)
	ApprovalState Blueprint_ApprovalState `protobuf:"varint,6,opt,name=approval_state,json=approvalState,proto3,enum=google.cloud.telcoautomation.v1.Blueprint_ApprovalState" json:"approval_state,omitempty"`
	// Optional. Human readable name of a Blueprint.
	DisplayName string `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Name of the repository where the blueprint files are stored.
	Repository string `protobuf:"bytes,8,opt,name=repository,proto3" json:"repository,omitempty"`
	// Optional. Files present in a blueprint.
	// When invoking UpdateBlueprint API, only the modified files should be
	// included in this. Files that are not included in the update of a blueprint
	// will not be changed.
	Files []*File `protobuf:"bytes,9,rep,name=files,proto3" json:"files,omitempty"`
	// Optional. Labels are key-value attributes that can be set on a blueprint
	// resource by the user.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Blueprint creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the blueprint was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Source provider is the author of a public blueprint, from
	// which this blueprint is created.
	SourceProvider string `protobuf:"bytes,13,opt,name=source_provider,json=sourceProvider,proto3" json:"source_provider,omitempty"`
	// Output only. DeploymentLevel of a blueprint signifies where the blueprint
	// will be applied. e.g. [HYDRATION, SINGLE_DEPLOYMENT, MULTI_DEPLOYMENT]
	DeploymentLevel DeploymentLevel `protobuf:"varint,14,opt,name=deployment_level,json=deploymentLevel,proto3,enum=google.cloud.telcoautomation.v1.DeploymentLevel" json:"deployment_level,omitempty"`
	// Output only. Indicates if the deployment created from this blueprint can be
	// rolled back.
	RollbackSupport bool `protobuf:"varint,15,opt,name=rollback_support,json=rollbackSupport,proto3" json:"rollback_support,omitempty"`
}

func (x *Blueprint) Reset() {
	*x = Blueprint{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Blueprint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Blueprint) ProtoMessage() {}

func (x *Blueprint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Blueprint.ProtoReflect.Descriptor instead.
func (*Blueprint) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{2}
}

func (x *Blueprint) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Blueprint) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

func (x *Blueprint) GetSourceBlueprint() string {
	if x != nil {
		return x.SourceBlueprint
	}
	return ""
}

func (x *Blueprint) GetRevisionCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RevisionCreateTime
	}
	return nil
}

func (x *Blueprint) GetApprovalState() Blueprint_ApprovalState {
	if x != nil {
		return x.ApprovalState
	}
	return Blueprint_APPROVAL_STATE_UNSPECIFIED
}

func (x *Blueprint) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Blueprint) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

func (x *Blueprint) GetFiles() []*File {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *Blueprint) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Blueprint) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Blueprint) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Blueprint) GetSourceProvider() string {
	if x != nil {
		return x.SourceProvider
	}
	return ""
}

func (x *Blueprint) GetDeploymentLevel() DeploymentLevel {
	if x != nil {
		return x.DeploymentLevel
	}
	return DeploymentLevel_DEPLOYMENT_LEVEL_UNSPECIFIED
}

func (x *Blueprint) GetRollbackSupport() bool {
	if x != nil {
		return x.RollbackSupport
	}
	return false
}

// A Blueprint contains a collection of kubernetes resources in the form of
// YAML files. The file contents of a blueprint are collectively known as
// package.
// Public blueprint is a TNA provided blueprint that in present in TNA's public
// catalog. A user can copy the public blueprint to their private catalog for
// further modifications.
type PublicBlueprint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the public blueprint.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The display name of the public blueprint.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description of the public blueprint.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// DeploymentLevel of a blueprint signifies where the blueprint will be
	// applied. e.g. [HYDRATION, SINGLE_DEPLOYMENT, MULTI_DEPLOYMENT]
	DeploymentLevel DeploymentLevel `protobuf:"varint,4,opt,name=deployment_level,json=deploymentLevel,proto3,enum=google.cloud.telcoautomation.v1.DeploymentLevel" json:"deployment_level,omitempty"`
	// Source provider is the author of a public blueprint. e.g. Google, vendors
	SourceProvider string `protobuf:"bytes,5,opt,name=source_provider,json=sourceProvider,proto3" json:"source_provider,omitempty"`
	// Output only. Indicates if the deployment created from this blueprint can be
	// rolled back.
	RollbackSupport bool `protobuf:"varint,15,opt,name=rollback_support,json=rollbackSupport,proto3" json:"rollback_support,omitempty"`
}

func (x *PublicBlueprint) Reset() {
	*x = PublicBlueprint{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PublicBlueprint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublicBlueprint) ProtoMessage() {}

func (x *PublicBlueprint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublicBlueprint.ProtoReflect.Descriptor instead.
func (*PublicBlueprint) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{3}
}

func (x *PublicBlueprint) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PublicBlueprint) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PublicBlueprint) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PublicBlueprint) GetDeploymentLevel() DeploymentLevel {
	if x != nil {
		return x.DeploymentLevel
	}
	return DeploymentLevel_DEPLOYMENT_LEVEL_UNSPECIFIED
}

func (x *PublicBlueprint) GetSourceProvider() string {
	if x != nil {
		return x.SourceProvider
	}
	return ""
}

func (x *PublicBlueprint) GetRollbackSupport() bool {
	if x != nil {
		return x.RollbackSupport
	}
	return false
}

// Deployment contains a collection of YAML files (This collection is also known
// as package) that can to applied on an orchestration cluster (GKE cluster with
// TNA addons) or a workload cluster.
type Deployment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the deployment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Immutable. The revision ID of the deployment.
	// A new revision is committed whenever a change in deployment is applied.
	RevisionId string `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	// Required. The blueprint revision from which this deployment was created.
	SourceBlueprintRevision string `protobuf:"bytes,3,opt,name=source_blueprint_revision,json=sourceBlueprintRevision,proto3" json:"source_blueprint_revision,omitempty"`
	// Output only. The timestamp that the revision was created.
	RevisionCreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=revision_create_time,json=revisionCreateTime,proto3" json:"revision_create_time,omitempty"`
	// Output only. State of the deployment (DRAFT, APPLIED, DELETING).
	State Deployment_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.telcoautomation.v1.Deployment_State" json:"state,omitempty"`
	// Optional. Human readable name of a Deployment.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Name of the repository where the deployment package files are
	// stored.
	Repository string `protobuf:"bytes,7,opt,name=repository,proto3" json:"repository,omitempty"`
	// Optional. Files present in a deployment.
	// When invoking UpdateDeployment API, only the modified files should be
	// included in this. Files that are not included in the update of a deployment
	// will not be changed.
	Files []*File `protobuf:"bytes,8,rep,name=files,proto3" json:"files,omitempty"`
	// Optional. Labels are key-value attributes that can be set on a deployment
	// resource by the user.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Deployment creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the deployment was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Source provider is the author of a public blueprint, from
	// which this deployment is created.
	SourceProvider string `protobuf:"bytes,12,opt,name=source_provider,json=sourceProvider,proto3" json:"source_provider,omitempty"`
	// Optional. Immutable. The WorkloadCluster on which to create the Deployment.
	// This field should only be passed when the deployment_level of the source
	// blueprint specifies deployments on workload clusters e.g.
	// WORKLOAD_CLUSTER_DEPLOYMENT.
	WorkloadCluster string `protobuf:"bytes,13,opt,name=workload_cluster,json=workloadCluster,proto3" json:"workload_cluster,omitempty"`
	// Output only. Attributes to where the deployment can inflict changes. The
	// value can only be [SINGLE_DEPLOYMENT, MULTI_DEPLOYMENT].
	DeploymentLevel DeploymentLevel `protobuf:"varint,14,opt,name=deployment_level,json=deploymentLevel,proto3,enum=google.cloud.telcoautomation.v1.DeploymentLevel" json:"deployment_level,omitempty"`
	// Output only. Indicates if the deployment can be rolled back, exported from
	// public blueprint.
	RollbackSupport bool `protobuf:"varint,15,opt,name=rollback_support,json=rollbackSupport,proto3" json:"rollback_support,omitempty"`
}

func (x *Deployment) Reset() {
	*x = Deployment{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Deployment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Deployment) ProtoMessage() {}

func (x *Deployment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Deployment.ProtoReflect.Descriptor instead.
func (*Deployment) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{4}
}

func (x *Deployment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Deployment) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

func (x *Deployment) GetSourceBlueprintRevision() string {
	if x != nil {
		return x.SourceBlueprintRevision
	}
	return ""
}

func (x *Deployment) GetRevisionCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RevisionCreateTime
	}
	return nil
}

func (x *Deployment) GetState() Deployment_State {
	if x != nil {
		return x.State
	}
	return Deployment_STATE_UNSPECIFIED
}

func (x *Deployment) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Deployment) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

func (x *Deployment) GetFiles() []*File {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *Deployment) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Deployment) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Deployment) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Deployment) GetSourceProvider() string {
	if x != nil {
		return x.SourceProvider
	}
	return ""
}

func (x *Deployment) GetWorkloadCluster() string {
	if x != nil {
		return x.WorkloadCluster
	}
	return ""
}

func (x *Deployment) GetDeploymentLevel() DeploymentLevel {
	if x != nil {
		return x.DeploymentLevel
	}
	return DeploymentLevel_DEPLOYMENT_LEVEL_UNSPECIFIED
}

func (x *Deployment) GetRollbackSupport() bool {
	if x != nil {
		return x.RollbackSupport
	}
	return false
}

// A collection of kubernetes yaml files which are deployed on a Workload
// Cluster. Hydrated Deployments are created by TNA intent based automation.
type HydratedDeployment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the hydrated deployment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. State of the hydrated deployment (DRAFT, APPLIED).
	State HydratedDeployment_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.telcoautomation.v1.HydratedDeployment_State" json:"state,omitempty"`
	// Optional. File contents of a hydrated deployment.
	// When invoking UpdateHydratedBlueprint API, only the modified files should
	// be included in this. Files that are not included in the update of a
	// hydrated deployment will not be changed.
	Files []*File `protobuf:"bytes,3,rep,name=files,proto3" json:"files,omitempty"`
	// Output only. WorkloadCluster identifies which workload cluster will the
	// hydrated deployment will be deployed on.
	WorkloadCluster string `protobuf:"bytes,4,opt,name=workload_cluster,json=workloadCluster,proto3" json:"workload_cluster,omitempty"`
}

func (x *HydratedDeployment) Reset() {
	*x = HydratedDeployment{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HydratedDeployment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HydratedDeployment) ProtoMessage() {}

func (x *HydratedDeployment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HydratedDeployment.ProtoReflect.Descriptor instead.
func (*HydratedDeployment) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{5}
}

func (x *HydratedDeployment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HydratedDeployment) GetState() HydratedDeployment_State {
	if x != nil {
		return x.State
	}
	return HydratedDeployment_STATE_UNSPECIFIED
}

func (x *HydratedDeployment) GetFiles() []*File {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *HydratedDeployment) GetWorkloadCluster() string {
	if x != nil {
		return x.WorkloadCluster
	}
	return ""
}

// Message for requesting list of OrchestrationClusters.
type ListOrchestrationClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListOrchestrationClustersRequest
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListOrchestrationClustersRequest) Reset() {
	*x = ListOrchestrationClustersRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrchestrationClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrchestrationClustersRequest) ProtoMessage() {}

func (x *ListOrchestrationClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrchestrationClustersRequest.ProtoReflect.Descriptor instead.
func (*ListOrchestrationClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{6}
}

func (x *ListOrchestrationClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOrchestrationClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOrchestrationClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListOrchestrationClustersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListOrchestrationClustersRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing OrchestrationClusters.
type ListOrchestrationClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of OrchestrationCluster
	OrchestrationClusters []*OrchestrationCluster `protobuf:"bytes,1,rep,name=orchestration_clusters,json=orchestrationClusters,proto3" json:"orchestration_clusters,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListOrchestrationClustersResponse) Reset() {
	*x = ListOrchestrationClustersResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrchestrationClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrchestrationClustersResponse) ProtoMessage() {}

func (x *ListOrchestrationClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOrchestrationClustersResponse.ProtoReflect.Descriptor instead.
func (*ListOrchestrationClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{7}
}

func (x *ListOrchestrationClustersResponse) GetOrchestrationClusters() []*OrchestrationCluster {
	if x != nil {
		return x.OrchestrationClusters
	}
	return nil
}

func (x *ListOrchestrationClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListOrchestrationClustersResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a OrchestrationCluster.
type GetOrchestrationClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOrchestrationClusterRequest) Reset() {
	*x = GetOrchestrationClusterRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrchestrationClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrchestrationClusterRequest) ProtoMessage() {}

func (x *GetOrchestrationClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOrchestrationClusterRequest.ProtoReflect.Descriptor instead.
func (*GetOrchestrationClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{8}
}

func (x *GetOrchestrationClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a OrchestrationCluster.
type CreateOrchestrationClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting object
	// If auto-generating Id server-side, remove this field and
	// orchestration_cluster_id from the method_signature of Create RPC
	OrchestrationClusterId string `protobuf:"bytes,2,opt,name=orchestration_cluster_id,json=orchestrationClusterId,proto3" json:"orchestration_cluster_id,omitempty"`
	// Required. The resource being created
	OrchestrationCluster *OrchestrationCluster `protobuf:"bytes,3,opt,name=orchestration_cluster,json=orchestrationCluster,proto3" json:"orchestration_cluster,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateOrchestrationClusterRequest) Reset() {
	*x = CreateOrchestrationClusterRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateOrchestrationClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrchestrationClusterRequest) ProtoMessage() {}

func (x *CreateOrchestrationClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOrchestrationClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateOrchestrationClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{9}
}

func (x *CreateOrchestrationClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateOrchestrationClusterRequest) GetOrchestrationClusterId() string {
	if x != nil {
		return x.OrchestrationClusterId
	}
	return ""
}

func (x *CreateOrchestrationClusterRequest) GetOrchestrationCluster() *OrchestrationCluster {
	if x != nil {
		return x.OrchestrationCluster
	}
	return nil
}

func (x *CreateOrchestrationClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting a OrchestrationCluster.
type DeleteOrchestrationClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteOrchestrationClusterRequest) Reset() {
	*x = DeleteOrchestrationClusterRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteOrchestrationClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOrchestrationClusterRequest) ProtoMessage() {}

func (x *DeleteOrchestrationClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteOrchestrationClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteOrchestrationClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteOrchestrationClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteOrchestrationClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for requesting list of EdgeSlms
type ListEdgeSlmsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListEdgeSlmsRequest
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListEdgeSlmsRequest) Reset() {
	*x = ListEdgeSlmsRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEdgeSlmsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEdgeSlmsRequest) ProtoMessage() {}

func (x *ListEdgeSlmsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEdgeSlmsRequest.ProtoReflect.Descriptor instead.
func (*ListEdgeSlmsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{11}
}

func (x *ListEdgeSlmsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEdgeSlmsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEdgeSlmsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEdgeSlmsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEdgeSlmsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing EdgeSlms.
type ListEdgeSlmsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of EdgeSlm
	EdgeSlms []*EdgeSlm `protobuf:"bytes,1,rep,name=edge_slms,json=edgeSlms,proto3" json:"edge_slms,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListEdgeSlmsResponse) Reset() {
	*x = ListEdgeSlmsResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEdgeSlmsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEdgeSlmsResponse) ProtoMessage() {}

func (x *ListEdgeSlmsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEdgeSlmsResponse.ProtoReflect.Descriptor instead.
func (*ListEdgeSlmsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{12}
}

func (x *ListEdgeSlmsResponse) GetEdgeSlms() []*EdgeSlm {
	if x != nil {
		return x.EdgeSlms
	}
	return nil
}

func (x *ListEdgeSlmsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListEdgeSlmsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a EdgeSlm.
type GetEdgeSlmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEdgeSlmRequest) Reset() {
	*x = GetEdgeSlmRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEdgeSlmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEdgeSlmRequest) ProtoMessage() {}

func (x *GetEdgeSlmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEdgeSlmRequest.ProtoReflect.Descriptor instead.
func (*GetEdgeSlmRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{13}
}

func (x *GetEdgeSlmRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a EdgeSlm.
type CreateEdgeSlmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting object
	// If auto-generating Id server-side, remove this field and
	// edge_slm_id from the method_signature of Create RPC
	EdgeSlmId string `protobuf:"bytes,2,opt,name=edge_slm_id,json=edgeSlmId,proto3" json:"edge_slm_id,omitempty"`
	// Required. The resource being created
	EdgeSlm *EdgeSlm `protobuf:"bytes,3,opt,name=edge_slm,json=edgeSlm,proto3" json:"edge_slm,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateEdgeSlmRequest) Reset() {
	*x = CreateEdgeSlmRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEdgeSlmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEdgeSlmRequest) ProtoMessage() {}

func (x *CreateEdgeSlmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEdgeSlmRequest.ProtoReflect.Descriptor instead.
func (*CreateEdgeSlmRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{14}
}

func (x *CreateEdgeSlmRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEdgeSlmRequest) GetEdgeSlmId() string {
	if x != nil {
		return x.EdgeSlmId
	}
	return ""
}

func (x *CreateEdgeSlmRequest) GetEdgeSlm() *EdgeSlm {
	if x != nil {
		return x.EdgeSlm
	}
	return nil
}

func (x *CreateEdgeSlmRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting a EdgeSlm.
type DeleteEdgeSlmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteEdgeSlmRequest) Reset() {
	*x = DeleteEdgeSlmRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteEdgeSlmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEdgeSlmRequest) ProtoMessage() {}

func (x *DeleteEdgeSlmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEdgeSlmRequest.ProtoReflect.Descriptor instead.
func (*DeleteEdgeSlmRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteEdgeSlmRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEdgeSlmRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request object for `CreateBlueprint`.
type CreateBlueprintRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of parent resource.
	// Format should be -
	// "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The name of the blueprint.
	BlueprintId string `protobuf:"bytes,2,opt,name=blueprint_id,json=blueprintId,proto3" json:"blueprint_id,omitempty"`
	// Required. The `Blueprint` to create.
	Blueprint *Blueprint `protobuf:"bytes,3,opt,name=blueprint,proto3" json:"blueprint,omitempty"`
}

func (x *CreateBlueprintRequest) Reset() {
	*x = CreateBlueprintRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateBlueprintRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBlueprintRequest) ProtoMessage() {}

func (x *CreateBlueprintRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBlueprintRequest.ProtoReflect.Descriptor instead.
func (*CreateBlueprintRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{16}
}

func (x *CreateBlueprintRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBlueprintRequest) GetBlueprintId() string {
	if x != nil {
		return x.BlueprintId
	}
	return ""
}

func (x *CreateBlueprintRequest) GetBlueprint() *Blueprint {
	if x != nil {
		return x.Blueprint
	}
	return nil
}

// Request object for `UpdateBlueprint`.
type UpdateBlueprintRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `blueprint` to update.
	Blueprint *Blueprint `protobuf:"bytes,1,opt,name=blueprint,proto3" json:"blueprint,omitempty"`
	// Required. Update mask is used to specify the fields to be overwritten in
	// the `blueprint` resource by the update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBlueprintRequest) Reset() {
	*x = UpdateBlueprintRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBlueprintRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBlueprintRequest) ProtoMessage() {}

func (x *UpdateBlueprintRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBlueprintRequest.ProtoReflect.Descriptor instead.
func (*UpdateBlueprintRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{17}
}

func (x *UpdateBlueprintRequest) GetBlueprint() *Blueprint {
	if x != nil {
		return x.Blueprint
	}
	return nil
}

func (x *UpdateBlueprintRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request object for `GetBlueprint`.
type GetBlueprintRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the blueprint.
	// Case 1: If the name provided in the request is
	// {blueprint_id}@{revision_id}, then the revision with revision_id will be
	// returned. Case 2: If the name provided in the request is {blueprint}, then
	// the current state of the blueprint is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Defines the type of view of the blueprint.
	// When field is not present BLUEPRINT_VIEW_BASIC is considered as default.
	View BlueprintView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.telcoautomation.v1.BlueprintView" json:"view,omitempty"`
}

func (x *GetBlueprintRequest) Reset() {
	*x = GetBlueprintRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBlueprintRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBlueprintRequest) ProtoMessage() {}

func (x *GetBlueprintRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBlueprintRequest.ProtoReflect.Descriptor instead.
func (*GetBlueprintRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{18}
}

func (x *GetBlueprintRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetBlueprintRequest) GetView() BlueprintView {
	if x != nil {
		return x.View
	}
	return BlueprintView_BLUEPRINT_VIEW_UNSPECIFIED
}

// Request object for `DeleteBlueprint`.
type DeleteBlueprintRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of blueprint to delete.
	// Blueprint name should be in the format {blueprint_id}, if
	// {blueprint_id}@{revision_id} is passed then the API throws invalid
	// argument.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteBlueprintRequest) Reset() {
	*x = DeleteBlueprintRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBlueprintRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBlueprintRequest) ProtoMessage() {}

func (x *DeleteBlueprintRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBlueprintRequest.ProtoReflect.Descriptor instead.
func (*DeleteBlueprintRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteBlueprintRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request object for `ListBlueprints`.
type ListBlueprintsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of parent orchestration cluster resource.
	// Format should be -
	// "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filtering only supports equality on blueprint state.
	// It should be in the form: "state = DRAFT". `OR` operator can be used to
	// get response for multiple states. e.g. "state = DRAFT OR state = PROPOSED".
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of blueprints to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, received from a previous ListBlueprints call.
	// It can be provided to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBlueprintsRequest) Reset() {
	*x = ListBlueprintsRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBlueprintsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBlueprintsRequest) ProtoMessage() {}

func (x *ListBlueprintsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBlueprintsRequest.ProtoReflect.Descriptor instead.
func (*ListBlueprintsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{20}
}

func (x *ListBlueprintsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBlueprintsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBlueprintsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBlueprintsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response object for `ListBlueprints`.
type ListBlueprintsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested blueprints.
	Blueprints []*Blueprint `protobuf:"bytes,1,rep,name=blueprints,proto3" json:"blueprints,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBlueprintsResponse) Reset() {
	*x = ListBlueprintsResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBlueprintsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBlueprintsResponse) ProtoMessage() {}

func (x *ListBlueprintsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBlueprintsResponse.ProtoReflect.Descriptor instead.
func (*ListBlueprintsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{21}
}

func (x *ListBlueprintsResponse) GetBlueprints() []*Blueprint {
	if x != nil {
		return x.Blueprints
	}
	return nil
}

func (x *ListBlueprintsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request object for `ApproveBlueprint`.
type ApproveBlueprintRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the blueprint to approve. The blueprint must be in
	// Proposed state. A new revision is committed on approval.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ApproveBlueprintRequest) Reset() {
	*x = ApproveBlueprintRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApproveBlueprintRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveBlueprintRequest) ProtoMessage() {}

func (x *ApproveBlueprintRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveBlueprintRequest.ProtoReflect.Descriptor instead.
func (*ApproveBlueprintRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{22}
}

func (x *ApproveBlueprintRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request object for `ProposeBlueprint`.
type ProposeBlueprintRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the blueprint being proposed.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ProposeBlueprintRequest) Reset() {
	*x = ProposeBlueprintRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProposeBlueprintRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProposeBlueprintRequest) ProtoMessage() {}

func (x *ProposeBlueprintRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProposeBlueprintRequest.ProtoReflect.Descriptor instead.
func (*ProposeBlueprintRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{23}
}

func (x *ProposeBlueprintRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request object for `RejectBlueprint`.
type RejectBlueprintRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the blueprint being rejected.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RejectBlueprintRequest) Reset() {
	*x = RejectBlueprintRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RejectBlueprintRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RejectBlueprintRequest) ProtoMessage() {}

func (x *RejectBlueprintRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RejectBlueprintRequest.ProtoReflect.Descriptor instead.
func (*RejectBlueprintRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{24}
}

func (x *RejectBlueprintRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request object for `ListBlueprintRevisions`.
type ListBlueprintRevisionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the blueprint to list revisions for.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The maximum number of revisions to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page token, received from a previous ListBlueprintRevisions call
	// It can be provided to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBlueprintRevisionsRequest) Reset() {
	*x = ListBlueprintRevisionsRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBlueprintRevisionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBlueprintRevisionsRequest) ProtoMessage() {}

func (x *ListBlueprintRevisionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBlueprintRevisionsRequest.ProtoReflect.Descriptor instead.
func (*ListBlueprintRevisionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{25}
}

func (x *ListBlueprintRevisionsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListBlueprintRevisionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBlueprintRevisionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response object for `ListBlueprintRevisions`.
type ListBlueprintRevisionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The revisions of the blueprint.
	Blueprints []*Blueprint `protobuf:"bytes,1,rep,name=blueprints,proto3" json:"blueprints,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBlueprintRevisionsResponse) Reset() {
	*x = ListBlueprintRevisionsResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBlueprintRevisionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBlueprintRevisionsResponse) ProtoMessage() {}

func (x *ListBlueprintRevisionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBlueprintRevisionsResponse.ProtoReflect.Descriptor instead.
func (*ListBlueprintRevisionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{26}
}

func (x *ListBlueprintRevisionsResponse) GetBlueprints() []*Blueprint {
	if x != nil {
		return x.Blueprints
	}
	return nil
}

func (x *ListBlueprintRevisionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request object for `SearchBlueprintRevisions`.
type SearchBlueprintRevisionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of parent orchestration cluster resource.
	// Format should be -
	// "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Supported queries:
	// 1. ""                       : Lists all revisions across all blueprints.
	// 2. "latest=true"            : Lists latest revisions across all blueprints.
	// 3. "name={name}"            : Lists all revisions of blueprint with name
	// {name}.
	// 4. "name={name} latest=true": Lists latest revision of blueprint with name
	// {name}
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. The maximum number of blueprints revisions to return per page.
	// max page size = 100, default page size = 20.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, received from a previous search call.
	// It can be provided to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchBlueprintRevisionsRequest) Reset() {
	*x = SearchBlueprintRevisionsRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchBlueprintRevisionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchBlueprintRevisionsRequest) ProtoMessage() {}

func (x *SearchBlueprintRevisionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchBlueprintRevisionsRequest.ProtoReflect.Descriptor instead.
func (*SearchBlueprintRevisionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{27}
}

func (x *SearchBlueprintRevisionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchBlueprintRevisionsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchBlueprintRevisionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchBlueprintRevisionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response object for `SearchBlueprintRevisions`.
type SearchBlueprintRevisionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested blueprint revisions.
	Blueprints []*Blueprint `protobuf:"bytes,1,rep,name=blueprints,proto3" json:"blueprints,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchBlueprintRevisionsResponse) Reset() {
	*x = SearchBlueprintRevisionsResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchBlueprintRevisionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchBlueprintRevisionsResponse) ProtoMessage() {}

func (x *SearchBlueprintRevisionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchBlueprintRevisionsResponse.ProtoReflect.Descriptor instead.
func (*SearchBlueprintRevisionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{28}
}

func (x *SearchBlueprintRevisionsResponse) GetBlueprints() []*Blueprint {
	if x != nil {
		return x.Blueprints
	}
	return nil
}

func (x *SearchBlueprintRevisionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request object for `DiscardBlueprintChanges`.
type DiscardBlueprintChangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the blueprint of which changes are being discarded.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DiscardBlueprintChangesRequest) Reset() {
	*x = DiscardBlueprintChangesRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiscardBlueprintChangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscardBlueprintChangesRequest) ProtoMessage() {}

func (x *DiscardBlueprintChangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscardBlueprintChangesRequest.ProtoReflect.Descriptor instead.
func (*DiscardBlueprintChangesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{29}
}

func (x *DiscardBlueprintChangesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response object for `DiscardBlueprintChanges`.
type DiscardBlueprintChangesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DiscardBlueprintChangesResponse) Reset() {
	*x = DiscardBlueprintChangesResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiscardBlueprintChangesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscardBlueprintChangesResponse) ProtoMessage() {}

func (x *DiscardBlueprintChangesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscardBlueprintChangesResponse.ProtoReflect.Descriptor instead.
func (*DiscardBlueprintChangesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{30}
}

// Request object for `ListPublicBlueprints`.
type ListPublicBlueprintsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value of public blueprint.
	// Format should be -
	// "projects/{project_id}/locations/{location_name}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPublicBlueprintsRequest) Reset() {
	*x = ListPublicBlueprintsRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPublicBlueprintsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPublicBlueprintsRequest) ProtoMessage() {}

func (x *ListPublicBlueprintsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPublicBlueprintsRequest.ProtoReflect.Descriptor instead.
func (*ListPublicBlueprintsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{31}
}

func (x *ListPublicBlueprintsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPublicBlueprintsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPublicBlueprintsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response object for `ListPublicBlueprints`.
type ListPublicBlueprintsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of public blueprints to return.
	PublicBlueprints []*PublicBlueprint `protobuf:"bytes,1,rep,name=public_blueprints,json=publicBlueprints,proto3" json:"public_blueprints,omitempty"`
	// Output only. A token identifying a page of results the server should
	// return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPublicBlueprintsResponse) Reset() {
	*x = ListPublicBlueprintsResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPublicBlueprintsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPublicBlueprintsResponse) ProtoMessage() {}

func (x *ListPublicBlueprintsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPublicBlueprintsResponse.ProtoReflect.Descriptor instead.
func (*ListPublicBlueprintsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{32}
}

func (x *ListPublicBlueprintsResponse) GetPublicBlueprints() []*PublicBlueprint {
	if x != nil {
		return x.PublicBlueprints
	}
	return nil
}

func (x *ListPublicBlueprintsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request object for `GetPublicBlueprint`.
type GetPublicBlueprintRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the public blueprint.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPublicBlueprintRequest) Reset() {
	*x = GetPublicBlueprintRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPublicBlueprintRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPublicBlueprintRequest) ProtoMessage() {}

func (x *GetPublicBlueprintRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPublicBlueprintRequest.ProtoReflect.Descriptor instead.
func (*GetPublicBlueprintRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{33}
}

func (x *GetPublicBlueprintRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request object for `CreateDeployment`.
type CreateDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of parent resource.
	// Format should be -
	// "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The name of the deployment.
	DeploymentId string `protobuf:"bytes,2,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Required. The `Deployment` to create.
	Deployment *Deployment `protobuf:"bytes,3,opt,name=deployment,proto3" json:"deployment,omitempty"`
}

func (x *CreateDeploymentRequest) Reset() {
	*x = CreateDeploymentRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeploymentRequest) ProtoMessage() {}

func (x *CreateDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeploymentRequest.ProtoReflect.Descriptor instead.
func (*CreateDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{34}
}

func (x *CreateDeploymentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDeploymentRequest) GetDeploymentId() string {
	if x != nil {
		return x.DeploymentId
	}
	return ""
}

func (x *CreateDeploymentRequest) GetDeployment() *Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

// Request object for `UpdateDeployment`.
type UpdateDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `deployment` to update.
	Deployment *Deployment `protobuf:"bytes,1,opt,name=deployment,proto3" json:"deployment,omitempty"`
	// Required. Update mask is used to specify the fields to be overwritten in
	// the `deployment` resource by the update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateDeploymentRequest) Reset() {
	*x = UpdateDeploymentRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDeploymentRequest) ProtoMessage() {}

func (x *UpdateDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDeploymentRequest.ProtoReflect.Descriptor instead.
func (*UpdateDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{35}
}

func (x *UpdateDeploymentRequest) GetDeployment() *Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

func (x *UpdateDeploymentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request object for `GetDeployment`.
type GetDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment.
	// Case 1: If the name provided in the request is
	// {deployment_id}@{revision_id}, then the revision with revision_id will be
	// returned.
	// Case 2: If the name provided in the request is {deployment}, then
	// the current state of the deployment is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Defines the type of view of the deployment.
	// When field is not present VIEW_BASIC is considered as default.
	View DeploymentView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.telcoautomation.v1.DeploymentView" json:"view,omitempty"`
}

func (x *GetDeploymentRequest) Reset() {
	*x = GetDeploymentRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeploymentRequest) ProtoMessage() {}

func (x *GetDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeploymentRequest.ProtoReflect.Descriptor instead.
func (*GetDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{36}
}

func (x *GetDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetDeploymentRequest) GetView() DeploymentView {
	if x != nil {
		return x.View
	}
	return DeploymentView_DEPLOYMENT_VIEW_UNSPECIFIED
}

// Request object for `RemoveDeployment`.
type RemoveDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of deployment to initiate delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RemoveDeploymentRequest) Reset() {
	*x = RemoveDeploymentRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveDeploymentRequest) ProtoMessage() {}

func (x *RemoveDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveDeploymentRequest.ProtoReflect.Descriptor instead.
func (*RemoveDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{37}
}

func (x *RemoveDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request object for `ListDeployments`.
type ListDeploymentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of parent orchestration cluster resource.
	// Format should be -
	// "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Filtering only supports equality on deployment state.
	// It should be in the form: "state = DRAFT". `OR` operator can be used to
	// get response for multiple states. e.g. "state = DRAFT OR state = APPLIED".
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of deployments to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, received from a previous ListDeployments call.
	// It can be provided to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDeploymentsRequest) Reset() {
	*x = ListDeploymentsRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDeploymentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeploymentsRequest) ProtoMessage() {}

func (x *ListDeploymentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeploymentsRequest.ProtoReflect.Descriptor instead.
func (*ListDeploymentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{38}
}

func (x *ListDeploymentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDeploymentsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDeploymentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDeploymentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response object for `ListDeployments`.
type ListDeploymentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested deployments.
	Deployments []*Deployment `protobuf:"bytes,1,rep,name=deployments,proto3" json:"deployments,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDeploymentsResponse) Reset() {
	*x = ListDeploymentsResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDeploymentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeploymentsResponse) ProtoMessage() {}

func (x *ListDeploymentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeploymentsResponse.ProtoReflect.Descriptor instead.
func (*ListDeploymentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{39}
}

func (x *ListDeploymentsResponse) GetDeployments() []*Deployment {
	if x != nil {
		return x.Deployments
	}
	return nil
}

func (x *ListDeploymentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for listing all revisions of a deployment.
type ListDeploymentRevisionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment to list revisions for.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The maximum number of revisions to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, received from a previous ListDeploymentRevisions
	// call Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDeploymentRevisionsRequest) Reset() {
	*x = ListDeploymentRevisionsRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDeploymentRevisionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeploymentRevisionsRequest) ProtoMessage() {}

func (x *ListDeploymentRevisionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeploymentRevisionsRequest.ProtoReflect.Descriptor instead.
func (*ListDeploymentRevisionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{40}
}

func (x *ListDeploymentRevisionsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListDeploymentRevisionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDeploymentRevisionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// List of deployment revisions for a given deployment.
type ListDeploymentRevisionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The revisions of the deployment.
	Deployments []*Deployment `protobuf:"bytes,1,rep,name=deployments,proto3" json:"deployments,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDeploymentRevisionsResponse) Reset() {
	*x = ListDeploymentRevisionsResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDeploymentRevisionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeploymentRevisionsResponse) ProtoMessage() {}

func (x *ListDeploymentRevisionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeploymentRevisionsResponse.ProtoReflect.Descriptor instead.
func (*ListDeploymentRevisionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{41}
}

func (x *ListDeploymentRevisionsResponse) GetDeployments() []*Deployment {
	if x != nil {
		return x.Deployments
	}
	return nil
}

func (x *ListDeploymentRevisionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request object for `SearchDeploymentRevisions`.
type SearchDeploymentRevisionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of parent orchestration cluster resource.
	// Format should be -
	// "projects/{project_id}/locations/{location_name}/orchestrationClusters/{orchestration_cluster}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Supported queries:
	// 1. ""                       : Lists all revisions across all deployments.
	// 2. "latest=true"            : Lists latest revisions across all
	// deployments.
	// 3. "name={name}"            : Lists all revisions of deployment with name
	// {name}.
	// 4. "name={name} latest=true": Lists latest revision of deployment with name
	// {name}
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. The maximum number of deployment revisions to return per page.
	// max page size = 100, default page size = 20.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, received from a previous search call.
	// It can be provided to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchDeploymentRevisionsRequest) Reset() {
	*x = SearchDeploymentRevisionsRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchDeploymentRevisionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchDeploymentRevisionsRequest) ProtoMessage() {}

func (x *SearchDeploymentRevisionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchDeploymentRevisionsRequest.ProtoReflect.Descriptor instead.
func (*SearchDeploymentRevisionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{42}
}

func (x *SearchDeploymentRevisionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchDeploymentRevisionsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchDeploymentRevisionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchDeploymentRevisionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response object for `SearchDeploymentRevisions`.
type SearchDeploymentRevisionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested deployment revisions.
	Deployments []*Deployment `protobuf:"bytes,1,rep,name=deployments,proto3" json:"deployments,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchDeploymentRevisionsResponse) Reset() {
	*x = SearchDeploymentRevisionsResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchDeploymentRevisionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchDeploymentRevisionsResponse) ProtoMessage() {}

func (x *SearchDeploymentRevisionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchDeploymentRevisionsResponse.ProtoReflect.Descriptor instead.
func (*SearchDeploymentRevisionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{43}
}

func (x *SearchDeploymentRevisionsResponse) GetDeployments() []*Deployment {
	if x != nil {
		return x.Deployments
	}
	return nil
}

func (x *SearchDeploymentRevisionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request object for `DiscardDeploymentChanges`.
type DiscardDeploymentChangesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment of which changes are being discarded.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DiscardDeploymentChangesRequest) Reset() {
	*x = DiscardDeploymentChangesRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiscardDeploymentChangesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscardDeploymentChangesRequest) ProtoMessage() {}

func (x *DiscardDeploymentChangesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscardDeploymentChangesRequest.ProtoReflect.Descriptor instead.
func (*DiscardDeploymentChangesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{44}
}

func (x *DiscardDeploymentChangesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response object for `DiscardDeploymentChanges`.
type DiscardDeploymentChangesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DiscardDeploymentChangesResponse) Reset() {
	*x = DiscardDeploymentChangesResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiscardDeploymentChangesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscardDeploymentChangesResponse) ProtoMessage() {}

func (x *DiscardDeploymentChangesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscardDeploymentChangesResponse.ProtoReflect.Descriptor instead.
func (*DiscardDeploymentChangesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{45}
}

// Request object for `ApplyDeployment`. The resources in given deployment
// gets applied to Orchestration Cluster. A new revision is created when a
// deployment is applied.
type ApplyDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment to apply to orchestration cluster.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ApplyDeploymentRequest) Reset() {
	*x = ApplyDeploymentRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyDeploymentRequest) ProtoMessage() {}

func (x *ApplyDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyDeploymentRequest.ProtoReflect.Descriptor instead.
func (*ApplyDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{46}
}

func (x *ApplyDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request object for `ComputeDeploymentStatus`.
type ComputeDeploymentStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment without revisionID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ComputeDeploymentStatusRequest) Reset() {
	*x = ComputeDeploymentStatusRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeDeploymentStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeDeploymentStatusRequest) ProtoMessage() {}

func (x *ComputeDeploymentStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeDeploymentStatusRequest.ProtoReflect.Descriptor instead.
func (*ComputeDeploymentStatusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{47}
}

func (x *ComputeDeploymentStatusRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response object for `ComputeDeploymentStatus`.
type ComputeDeploymentStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the deployment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Aggregated status of a deployment.
	AggregatedStatus Status `protobuf:"varint,2,opt,name=aggregated_status,json=aggregatedStatus,proto3,enum=google.cloud.telcoautomation.v1.Status" json:"aggregated_status,omitempty"`
	// Output only. Resource level status details in deployments.
	ResourceStatuses []*ResourceStatus `protobuf:"bytes,3,rep,name=resource_statuses,json=resourceStatuses,proto3" json:"resource_statuses,omitempty"`
}

func (x *ComputeDeploymentStatusResponse) Reset() {
	*x = ComputeDeploymentStatusResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeDeploymentStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeDeploymentStatusResponse) ProtoMessage() {}

func (x *ComputeDeploymentStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeDeploymentStatusResponse.ProtoReflect.Descriptor instead.
func (*ComputeDeploymentStatusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{48}
}

func (x *ComputeDeploymentStatusResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ComputeDeploymentStatusResponse) GetAggregatedStatus() Status {
	if x != nil {
		return x.AggregatedStatus
	}
	return Status_STATUS_UNSPECIFIED
}

func (x *ComputeDeploymentStatusResponse) GetResourceStatuses() []*ResourceStatus {
	if x != nil {
		return x.ResourceStatuses
	}
	return nil
}

// Request object for `RollbackDeployment`.
type RollbackDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the deployment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The revision id of deployment to roll back to.
	RevisionId string `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
}

func (x *RollbackDeploymentRequest) Reset() {
	*x = RollbackDeploymentRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RollbackDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RollbackDeploymentRequest) ProtoMessage() {}

func (x *RollbackDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RollbackDeploymentRequest.ProtoReflect.Descriptor instead.
func (*RollbackDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{49}
}

func (x *RollbackDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RollbackDeploymentRequest) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have been cancelled successfully
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{50}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Request object for `GetHydratedDeployment`.
type GetHydratedDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the hydrated deployment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetHydratedDeploymentRequest) Reset() {
	*x = GetHydratedDeploymentRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetHydratedDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetHydratedDeploymentRequest) ProtoMessage() {}

func (x *GetHydratedDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetHydratedDeploymentRequest.ProtoReflect.Descriptor instead.
func (*GetHydratedDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{51}
}

func (x *GetHydratedDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request object for `ListHydratedDeployments`.
type ListHydratedDeploymentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The deployment managing the hydrated deployments.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of hydrated deployments to return. The service
	// may return fewer than this value. If unspecified, at most 50 hydrated
	// deployments will be returned. The maximum value is 1000. Values above 1000
	// will be set to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, received from a previous ListHydratedDeployments
	// call. Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListHydratedDeploymentsRequest) Reset() {
	*x = ListHydratedDeploymentsRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListHydratedDeploymentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHydratedDeploymentsRequest) ProtoMessage() {}

func (x *ListHydratedDeploymentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHydratedDeploymentsRequest.ProtoReflect.Descriptor instead.
func (*ListHydratedDeploymentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{52}
}

func (x *ListHydratedDeploymentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListHydratedDeploymentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListHydratedDeploymentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response object for `ListHydratedDeployments`.
type ListHydratedDeploymentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of hydrated deployments.
	HydratedDeployments []*HydratedDeployment `protobuf:"bytes,1,rep,name=hydrated_deployments,json=hydratedDeployments,proto3" json:"hydrated_deployments,omitempty"`
	// A token that can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListHydratedDeploymentsResponse) Reset() {
	*x = ListHydratedDeploymentsResponse{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListHydratedDeploymentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHydratedDeploymentsResponse) ProtoMessage() {}

func (x *ListHydratedDeploymentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHydratedDeploymentsResponse.ProtoReflect.Descriptor instead.
func (*ListHydratedDeploymentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{53}
}

func (x *ListHydratedDeploymentsResponse) GetHydratedDeployments() []*HydratedDeployment {
	if x != nil {
		return x.HydratedDeployments
	}
	return nil
}

func (x *ListHydratedDeploymentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request object for `UpdateHydratedDeployment`.
type UpdateHydratedDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The hydrated deployment to update.
	HydratedDeployment *HydratedDeployment `protobuf:"bytes,1,opt,name=hydrated_deployment,json=hydratedDeployment,proto3" json:"hydrated_deployment,omitempty"`
	// Required. The list of fields to update. Update mask supports a special
	// value `*` which fully replaces (equivalent to PUT) the resource provided.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateHydratedDeploymentRequest) Reset() {
	*x = UpdateHydratedDeploymentRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateHydratedDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateHydratedDeploymentRequest) ProtoMessage() {}

func (x *UpdateHydratedDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateHydratedDeploymentRequest.ProtoReflect.Descriptor instead.
func (*UpdateHydratedDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{54}
}

func (x *UpdateHydratedDeploymentRequest) GetHydratedDeployment() *HydratedDeployment {
	if x != nil {
		return x.HydratedDeployment
	}
	return nil
}

func (x *UpdateHydratedDeploymentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for applying a hydrated deployment.
type ApplyHydratedDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the hydrated deployment to apply.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ApplyHydratedDeploymentRequest) Reset() {
	*x = ApplyHydratedDeploymentRequest{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyHydratedDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyHydratedDeploymentRequest) ProtoMessage() {}

func (x *ApplyHydratedDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyHydratedDeploymentRequest.ProtoReflect.Descriptor instead.
func (*ApplyHydratedDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{55}
}

func (x *ApplyHydratedDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Configuration of the cluster management
type ManagementConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration can be one of StandardManagementConfig
	// and FullManagementConfig
	//
	// Types that are assignable to OneofConfig:
	//
	//	*ManagementConfig_StandardManagementConfig
	//	*ManagementConfig_FullManagementConfig
	OneofConfig isManagementConfig_OneofConfig `protobuf_oneof:"oneof_config"`
}

func (x *ManagementConfig) Reset() {
	*x = ManagementConfig{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ManagementConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagementConfig) ProtoMessage() {}

func (x *ManagementConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagementConfig.ProtoReflect.Descriptor instead.
func (*ManagementConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{56}
}

func (m *ManagementConfig) GetOneofConfig() isManagementConfig_OneofConfig {
	if m != nil {
		return m.OneofConfig
	}
	return nil
}

func (x *ManagementConfig) GetStandardManagementConfig() *StandardManagementConfig {
	if x, ok := x.GetOneofConfig().(*ManagementConfig_StandardManagementConfig); ok {
		return x.StandardManagementConfig
	}
	return nil
}

func (x *ManagementConfig) GetFullManagementConfig() *FullManagementConfig {
	if x, ok := x.GetOneofConfig().(*ManagementConfig_FullManagementConfig); ok {
		return x.FullManagementConfig
	}
	return nil
}

type isManagementConfig_OneofConfig interface {
	isManagementConfig_OneofConfig()
}

type ManagementConfig_StandardManagementConfig struct {
	// Configuration of the standard (GKE) cluster management
	StandardManagementConfig *StandardManagementConfig `protobuf:"bytes,1,opt,name=standard_management_config,json=standardManagementConfig,proto3,oneof"`
}

type ManagementConfig_FullManagementConfig struct {
	// Configuration of the full (Autopilot) cluster management. Full cluster
	// management is a preview feature.
	FullManagementConfig *FullManagementConfig `protobuf:"bytes,2,opt,name=full_management_config,json=fullManagementConfig,proto3,oneof"`
}

func (*ManagementConfig_StandardManagementConfig) isManagementConfig_OneofConfig() {}

func (*ManagementConfig_FullManagementConfig) isManagementConfig_OneofConfig() {}

// Configuration of the standard (GKE) cluster management.
type StandardManagementConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the VPC Network to put the GKE cluster and nodes in. The
	// VPC will be created if it doesn't exist.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. Specifies the subnet that the interface will be part of. Network
	// key must be specified and the subnet must be a subnetwork of the specified
	// network.
	Subnet string `protobuf:"bytes,2,opt,name=subnet,proto3" json:"subnet,omitempty"`
	// Optional. The /28 network that the masters will use. It should be free
	// within the network.
	MasterIpv4CidrBlock string `protobuf:"bytes,3,opt,name=master_ipv4_cidr_block,json=masterIpv4CidrBlock,proto3" json:"master_ipv4_cidr_block,omitempty"`
	// Optional. The IP address range for the cluster pod IPs. Set to blank to
	// have a range chosen with the default size. Set to /netmask (e.g. /14) to
	// have a range chosen with a specific netmask. Set to a CIDR notation
	// (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8,
	// 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
	ClusterCidrBlock string `protobuf:"bytes,4,opt,name=cluster_cidr_block,json=clusterCidrBlock,proto3" json:"cluster_cidr_block,omitempty"`
	// Optional. The IP address range for the cluster service IPs. Set to blank to
	// have a range chosen with the default size. Set to /netmask (e.g. /14) to
	// have a range chosen with a specific netmask. Set to a CIDR notation (e.g.
	// 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8,
	// 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
	ServicesCidrBlock string `protobuf:"bytes,5,opt,name=services_cidr_block,json=servicesCidrBlock,proto3" json:"services_cidr_block,omitempty"`
	// Optional. The name of the existing secondary range in the cluster's
	// subnetwork to use for pod IP addresses. Alternatively, cluster_cidr_block
	// can be used to automatically create a GKE-managed one.
	ClusterNamedRange string `protobuf:"bytes,6,opt,name=cluster_named_range,json=clusterNamedRange,proto3" json:"cluster_named_range,omitempty"`
	// Optional. The name of the existing secondary range in the cluster's
	// subnetwork to use for service ClusterIPs. Alternatively,
	// services_cidr_block can be used to automatically create a GKE-managed one.
	ServicesNamedRange string `protobuf:"bytes,7,opt,name=services_named_range,json=servicesNamedRange,proto3" json:"services_named_range,omitempty"`
	// Optional. Master Authorized Network that supports multiple CIDR blocks.
	// Allows access to the k8s master from multiple blocks. It cannot be set at
	// the same time with the field man_block.
	MasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,8,opt,name=master_authorized_networks_config,json=masterAuthorizedNetworksConfig,proto3" json:"master_authorized_networks_config,omitempty"`
}

func (x *StandardManagementConfig) Reset() {
	*x = StandardManagementConfig{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StandardManagementConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StandardManagementConfig) ProtoMessage() {}

func (x *StandardManagementConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StandardManagementConfig.ProtoReflect.Descriptor instead.
func (*StandardManagementConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{57}
}

func (x *StandardManagementConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *StandardManagementConfig) GetSubnet() string {
	if x != nil {
		return x.Subnet
	}
	return ""
}

func (x *StandardManagementConfig) GetMasterIpv4CidrBlock() string {
	if x != nil {
		return x.MasterIpv4CidrBlock
	}
	return ""
}

func (x *StandardManagementConfig) GetClusterCidrBlock() string {
	if x != nil {
		return x.ClusterCidrBlock
	}
	return ""
}

func (x *StandardManagementConfig) GetServicesCidrBlock() string {
	if x != nil {
		return x.ServicesCidrBlock
	}
	return ""
}

func (x *StandardManagementConfig) GetClusterNamedRange() string {
	if x != nil {
		return x.ClusterNamedRange
	}
	return ""
}

func (x *StandardManagementConfig) GetServicesNamedRange() string {
	if x != nil {
		return x.ServicesNamedRange
	}
	return ""
}

func (x *StandardManagementConfig) GetMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if x != nil {
		return x.MasterAuthorizedNetworksConfig
	}
	return nil
}

// Configuration of the full (Autopilot) cluster management
type FullManagementConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the VPC Network to put the GKE cluster and nodes in. The
	// VPC will be created if it doesn't exist.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. Specifies the subnet that the interface will be part of. Network
	// key must be specified and the subnet must be a subnetwork of the specified
	// network.
	Subnet string `protobuf:"bytes,2,opt,name=subnet,proto3" json:"subnet,omitempty"`
	// Optional. The /28 network that the masters will use.
	MasterIpv4CidrBlock string `protobuf:"bytes,3,opt,name=master_ipv4_cidr_block,json=masterIpv4CidrBlock,proto3" json:"master_ipv4_cidr_block,omitempty"`
	// Optional. The IP address range for the cluster pod IPs. Set to blank to
	// have a range chosen with the default size. Set to /netmask (e.g. /14) to
	// have a range chosen with a specific netmask. Set to a CIDR notation
	// (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8,
	// 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
	ClusterCidrBlock string `protobuf:"bytes,4,opt,name=cluster_cidr_block,json=clusterCidrBlock,proto3" json:"cluster_cidr_block,omitempty"`
	// Optional. The IP address range for the cluster service IPs. Set to blank to
	// have a range chosen with the default size. Set to /netmask (e.g. /14) to
	// have a range chosen with a specific netmask. Set to a CIDR notation (e.g.
	// 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8,
	// 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
	ServicesCidrBlock string `protobuf:"bytes,5,opt,name=services_cidr_block,json=servicesCidrBlock,proto3" json:"services_cidr_block,omitempty"`
	// Optional. The name of the existing secondary range in the cluster's
	// subnetwork to use for pod IP addresses. Alternatively, cluster_cidr_block
	// can be used to automatically create a GKE-managed one.
	ClusterNamedRange string `protobuf:"bytes,6,opt,name=cluster_named_range,json=clusterNamedRange,proto3" json:"cluster_named_range,omitempty"`
	// Optional. The name of the existing secondary range in the cluster's
	// subnetwork to use for service ClusterIPs. Alternatively,
	// services_cidr_block can be used to automatically create a GKE-managed one.
	ServicesNamedRange string `protobuf:"bytes,7,opt,name=services_named_range,json=servicesNamedRange,proto3" json:"services_named_range,omitempty"`
	// Optional. Master Authorized Network that supports multiple CIDR blocks.
	// Allows access to the k8s master from multiple blocks. It cannot be set at
	// the same time with the field man_block.
	MasterAuthorizedNetworksConfig *MasterAuthorizedNetworksConfig `protobuf:"bytes,8,opt,name=master_authorized_networks_config,json=masterAuthorizedNetworksConfig,proto3" json:"master_authorized_networks_config,omitempty"`
}

func (x *FullManagementConfig) Reset() {
	*x = FullManagementConfig{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FullManagementConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FullManagementConfig) ProtoMessage() {}

func (x *FullManagementConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FullManagementConfig.ProtoReflect.Descriptor instead.
func (*FullManagementConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{58}
}

func (x *FullManagementConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *FullManagementConfig) GetSubnet() string {
	if x != nil {
		return x.Subnet
	}
	return ""
}

func (x *FullManagementConfig) GetMasterIpv4CidrBlock() string {
	if x != nil {
		return x.MasterIpv4CidrBlock
	}
	return ""
}

func (x *FullManagementConfig) GetClusterCidrBlock() string {
	if x != nil {
		return x.ClusterCidrBlock
	}
	return ""
}

func (x *FullManagementConfig) GetServicesCidrBlock() string {
	if x != nil {
		return x.ServicesCidrBlock
	}
	return ""
}

func (x *FullManagementConfig) GetClusterNamedRange() string {
	if x != nil {
		return x.ClusterNamedRange
	}
	return ""
}

func (x *FullManagementConfig) GetServicesNamedRange() string {
	if x != nil {
		return x.ServicesNamedRange
	}
	return ""
}

func (x *FullManagementConfig) GetMasterAuthorizedNetworksConfig() *MasterAuthorizedNetworksConfig {
	if x != nil {
		return x.MasterAuthorizedNetworksConfig
	}
	return nil
}

// Configuration of the Master Authorized Network that support multiple CIDRs
type MasterAuthorizedNetworksConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. cidr_blocks define up to 50 external networks that could access
	// Kubernetes master through HTTPS.
	CidrBlocks []*MasterAuthorizedNetworksConfig_CidrBlock `protobuf:"bytes,1,rep,name=cidr_blocks,json=cidrBlocks,proto3" json:"cidr_blocks,omitempty"`
}

func (x *MasterAuthorizedNetworksConfig) Reset() {
	*x = MasterAuthorizedNetworksConfig{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MasterAuthorizedNetworksConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterAuthorizedNetworksConfig) ProtoMessage() {}

func (x *MasterAuthorizedNetworksConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterAuthorizedNetworksConfig.ProtoReflect.Descriptor instead.
func (*MasterAuthorizedNetworksConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{59}
}

func (x *MasterAuthorizedNetworksConfig) GetCidrBlocks() []*MasterAuthorizedNetworksConfig_CidrBlock {
	if x != nil {
		return x.CidrBlocks
	}
	return nil
}

// File represents a yaml file present in a blueprint's package.
type File struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Path of the file in package.
	// e.g. `gdce/v1/cluster.yaml`
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Optional. The contents of a file in string format.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Optional. Signifies whether a file is marked for deletion.
	Deleted bool `protobuf:"varint,3,opt,name=deleted,proto3" json:"deleted,omitempty"`
	// Optional. Indicates whether changes are allowed to a file. If the field is
	// not set, the file cannot be edited.
	Editable bool `protobuf:"varint,4,opt,name=editable,proto3" json:"editable,omitempty"`
}

func (x *File) Reset() {
	*x = File{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *File) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*File) ProtoMessage() {}

func (x *File) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use File.ProtoReflect.Descriptor instead.
func (*File) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{60}
}

func (x *File) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *File) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *File) GetDeleted() bool {
	if x != nil {
		return x.Deleted
	}
	return false
}

func (x *File) GetEditable() bool {
	if x != nil {
		return x.Editable
	}
	return false
}

// Status of a deployment resource.
type ResourceStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Namespace of the resource.
	ResourceNamespace string `protobuf:"bytes,2,opt,name=resource_namespace,json=resourceNamespace,proto3" json:"resource_namespace,omitempty"`
	// Group to which the resource belongs to.
	Group string `protobuf:"bytes,3,opt,name=group,proto3" json:"group,omitempty"`
	// Version of the resource.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Kind of the resource.
	Kind string `protobuf:"bytes,5,opt,name=kind,proto3" json:"kind,omitempty"`
	// Output only. Resource type.
	ResourceType ResourceType `protobuf:"varint,6,opt,name=resource_type,json=resourceType,proto3,enum=google.cloud.telcoautomation.v1.ResourceType" json:"resource_type,omitempty"`
	// Output only. Status of the resource.
	Status Status `protobuf:"varint,7,opt,name=status,proto3,enum=google.cloud.telcoautomation.v1.Status" json:"status,omitempty"`
	// Output only. Detailed status of NFDeploy.
	NfDeployStatus *NFDeployStatus `protobuf:"bytes,8,opt,name=nf_deploy_status,json=nfDeployStatus,proto3" json:"nf_deploy_status,omitempty"`
}

func (x *ResourceStatus) Reset() {
	*x = ResourceStatus{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceStatus) ProtoMessage() {}

func (x *ResourceStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceStatus.ProtoReflect.Descriptor instead.
func (*ResourceStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{61}
}

func (x *ResourceStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResourceStatus) GetResourceNamespace() string {
	if x != nil {
		return x.ResourceNamespace
	}
	return ""
}

func (x *ResourceStatus) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *ResourceStatus) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ResourceStatus) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *ResourceStatus) GetResourceType() ResourceType {
	if x != nil {
		return x.ResourceType
	}
	return ResourceType_RESOURCE_TYPE_UNSPECIFIED
}

func (x *ResourceStatus) GetStatus() Status {
	if x != nil {
		return x.Status
	}
	return Status_STATUS_UNSPECIFIED
}

func (x *ResourceStatus) GetNfDeployStatus() *NFDeployStatus {
	if x != nil {
		return x.NfDeployStatus
	}
	return nil
}

// Deployment status of NFDeploy.
type NFDeployStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Total number of NFs targeted by this deployment
	TargetedNfs int32 `protobuf:"varint,1,opt,name=targeted_nfs,json=targetedNfs,proto3" json:"targeted_nfs,omitempty"`
	// Output only. Total number of NFs targeted by this deployment with a Ready
	// Condition set.
	ReadyNfs int32 `protobuf:"varint,2,opt,name=ready_nfs,json=readyNfs,proto3" json:"ready_nfs,omitempty"`
	// Output only. Per-Site Status.
	Sites []*NFDeploySiteStatus `protobuf:"bytes,3,rep,name=sites,proto3" json:"sites,omitempty"`
}

func (x *NFDeployStatus) Reset() {
	*x = NFDeployStatus{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NFDeployStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NFDeployStatus) ProtoMessage() {}

func (x *NFDeployStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NFDeployStatus.ProtoReflect.Descriptor instead.
func (*NFDeployStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{62}
}

func (x *NFDeployStatus) GetTargetedNfs() int32 {
	if x != nil {
		return x.TargetedNfs
	}
	return 0
}

func (x *NFDeployStatus) GetReadyNfs() int32 {
	if x != nil {
		return x.ReadyNfs
	}
	return 0
}

func (x *NFDeployStatus) GetSites() []*NFDeploySiteStatus {
	if x != nil {
		return x.Sites
	}
	return nil
}

// Per-Site Status.
type NFDeploySiteStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Site id.
	Site string `protobuf:"bytes,1,opt,name=site,proto3" json:"site,omitempty"`
	// Output only. If true, the Site Deletion is in progress.
	PendingDeletion bool `protobuf:"varint,2,opt,name=pending_deletion,json=pendingDeletion,proto3" json:"pending_deletion,omitempty"`
	// Output only. Hydration status.
	Hydration *HydrationStatus `protobuf:"bytes,3,opt,name=hydration,proto3" json:"hydration,omitempty"`
	// Output only. Workload status.
	Workload *WorkloadStatus `protobuf:"bytes,4,opt,name=workload,proto3" json:"workload,omitempty"`
}

func (x *NFDeploySiteStatus) Reset() {
	*x = NFDeploySiteStatus{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NFDeploySiteStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NFDeploySiteStatus) ProtoMessage() {}

func (x *NFDeploySiteStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NFDeploySiteStatus.ProtoReflect.Descriptor instead.
func (*NFDeploySiteStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{63}
}

func (x *NFDeploySiteStatus) GetSite() string {
	if x != nil {
		return x.Site
	}
	return ""
}

func (x *NFDeploySiteStatus) GetPendingDeletion() bool {
	if x != nil {
		return x.PendingDeletion
	}
	return false
}

func (x *NFDeploySiteStatus) GetHydration() *HydrationStatus {
	if x != nil {
		return x.Hydration
	}
	return nil
}

func (x *NFDeploySiteStatus) GetWorkload() *WorkloadStatus {
	if x != nil {
		return x.Workload
	}
	return nil
}

// Hydration status.
type HydrationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. SiteVersion Hydration is targeting.
	SiteVersion *SiteVersion `protobuf:"bytes,1,opt,name=site_version,json=siteVersion,proto3" json:"site_version,omitempty"`
	// Output only. Status.
	Status string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *HydrationStatus) Reset() {
	*x = HydrationStatus{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HydrationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HydrationStatus) ProtoMessage() {}

func (x *HydrationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HydrationStatus.ProtoReflect.Descriptor instead.
func (*HydrationStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{64}
}

func (x *HydrationStatus) GetSiteVersion() *SiteVersion {
	if x != nil {
		return x.SiteVersion
	}
	return nil
}

func (x *HydrationStatus) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

// SiteVersion Hydration is targeting.
type SiteVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. NF vendor.
	NfVendor string `protobuf:"bytes,1,opt,name=nf_vendor,json=nfVendor,proto3" json:"nf_vendor,omitempty"`
	// Output only. NF vendor type.
	NfType string `protobuf:"bytes,2,opt,name=nf_type,json=nfType,proto3" json:"nf_type,omitempty"`
	// Output only. NF version.
	NfVersion string `protobuf:"bytes,3,opt,name=nf_version,json=nfVersion,proto3" json:"nf_version,omitempty"`
}

func (x *SiteVersion) Reset() {
	*x = SiteVersion{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SiteVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SiteVersion) ProtoMessage() {}

func (x *SiteVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SiteVersion.ProtoReflect.Descriptor instead.
func (*SiteVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{65}
}

func (x *SiteVersion) GetNfVendor() string {
	if x != nil {
		return x.NfVendor
	}
	return ""
}

func (x *SiteVersion) GetNfType() string {
	if x != nil {
		return x.NfType
	}
	return ""
}

func (x *SiteVersion) GetNfVersion() string {
	if x != nil {
		return x.NfVersion
	}
	return ""
}

// Workload status.
type WorkloadStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. SiteVersion running in the workload cluster.
	SiteVersion *SiteVersion `protobuf:"bytes,1,opt,name=site_version,json=siteVersion,proto3" json:"site_version,omitempty"`
	// Output only. Status.
	Status string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *WorkloadStatus) Reset() {
	*x = WorkloadStatus{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkloadStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadStatus) ProtoMessage() {}

func (x *WorkloadStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadStatus.ProtoReflect.Descriptor instead.
func (*WorkloadStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{66}
}

func (x *WorkloadStatus) GetSiteVersion() *SiteVersion {
	if x != nil {
		return x.SiteVersion
	}
	return nil
}

func (x *WorkloadStatus) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

// CidrBlock contains an optional name and one CIDR block.
type MasterAuthorizedNetworksConfig_CidrBlock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. display_name is an optional field for users to identify CIDR
	// blocks.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. cidr_block must be specified in CIDR notation when using
	// master_authorized_networks_config. Currently, the user could still use
	// the deprecated man_block field, so this field is currently optional, but
	// will be required in the future.
	CidrBlock string `protobuf:"bytes,2,opt,name=cidr_block,json=cidrBlock,proto3" json:"cidr_block,omitempty"`
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) Reset() {
	*x = MasterAuthorizedNetworksConfig_CidrBlock{}
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterAuthorizedNetworksConfig_CidrBlock) ProtoMessage() {}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterAuthorizedNetworksConfig_CidrBlock.ProtoReflect.Descriptor instead.
func (*MasterAuthorizedNetworksConfig_CidrBlock) Descriptor() ([]byte, []int) {
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP(), []int{59, 0}
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *MasterAuthorizedNetworksConfig_CidrBlock) GetCidrBlock() string {
	if x != nil {
		return x.CidrBlock
	}
	return ""
}

var File_google_cloud_telcoautomation_v1_telcoautomation_proto protoreflect.FileDescriptor

var file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76,
	0x31, 0x2f, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x89, 0x06, 0x0a, 0x14, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5e, 0x0a,
	0x11, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x59, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x24, 0x0a, 0x0b,
	0x74, 0x6e, 0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x74, 0x6e, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x52, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x90, 0x01, 0xea, 0x41, 0x8c, 0x01,
	0x0a, 0x33, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x55, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6f,
	0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x22, 0xab, 0x07, 0x0a,
	0x07, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x70, 0x0a, 0x15,
	0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x05,
	0xfa, 0x41, 0x35, 0x0a, 0x33, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x14, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x74, 0x6e, 0x61, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x74, 0x6e, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x64, 0x67,
	0x65, 0x53, 0x6c, 0x6d, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x75, 0x0a, 0x15, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x52, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x22, 0x4f, 0x0a, 0x13,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x57, 0x4f, 0x52, 0x4b, 0x4c, 0x4f, 0x41, 0x44, 0x5f,
	0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x44,
	0x43, 0x45, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x47, 0x4b, 0x45, 0x10, 0x02, 0x3a, 0x7b, 0xea,
	0x41, 0x78, 0x0a, 0x26, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x12, 0x3b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x73, 0x2f, 0x7b, 0x65, 0x64,
	0x67, 0x65, 0x5f, 0x73, 0x6c, 0x6d, 0x7d, 0x2a, 0x08, 0x65, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d,
	0x73, 0x32, 0x07, 0x65, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x22, 0xa5, 0x09, 0x0a, 0x09, 0x42,
	0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0b,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x51, 0x0a, 0x14, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x64, 0x0a, 0x0e, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x2e,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x40,
	0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x12, 0x53, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x60, 0x0a, 0x10, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x2e, 0x0a, 0x10, 0x72, 0x6f, 0x6c,
	0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61,
	0x63, 0x6b, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x56, 0x0a, 0x0d, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x41,
	0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x52, 0x41, 0x46, 0x54, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x50, 0x52, 0x4f, 0x50, 0x4f, 0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c,
	0x0a, 0x08, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x03, 0x3a, 0xb3, 0x01, 0xea,
	0x41, 0xaf, 0x01, 0x0a, 0x28, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x6c, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6f, 0x72,
	0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x7d, 0x2f, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x7d, 0x2a, 0x0a, 0x62, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x32, 0x09, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x22, 0xc6, 0x03, 0x0a, 0x0f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5b, 0x0a, 0x10, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0f, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x27, 0x0a, 0x0f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x2e, 0x0a, 0x10, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x53, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0xa3, 0x01, 0xea, 0x41, 0x9f, 0x01, 0x0a, 0x2e, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x4a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75, 0x65,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6c,
	0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x7d, 0x2a, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x32, 0x0f, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x22, 0xc3, 0x09, 0x0a, 0x0a,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27,
	0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x3f, 0x0a, 0x19, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x17, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x14, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x12, 0x31, 0x0a, 0x10, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x60, 0x0a, 0x10, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x2e, 0x0a, 0x10, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x53, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x44, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x09, 0x0a, 0x05, 0x44, 0x52, 0x41, 0x46, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x41,
	0x50, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x3a, 0xb8, 0x01, 0xea, 0x41, 0xb4, 0x01, 0x0a, 0x29, 0x74,
	0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2a, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x32, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0xab, 0x04, 0x0a, 0x12, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x54, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x77, 0x6f, 0x72,
	0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x36, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x52, 0x41,
	0x46, 0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x10,
	0x02, 0x3a, 0xfb, 0x01, 0xea, 0x41, 0xf7, 0x01, 0x0a, 0x31, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x98, 0x01, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x63,
	0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x68, 0x79, 0x64,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x7b, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2a, 0x13, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x32, 0x12, 0x68, 0x79, 0x64,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0xe6, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x12, 0x33, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x63,
	0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xdb, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73,
	0x74, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6c,
	0x0a, 0x16, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x15, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x71, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x63,
	0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f,
	0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcc, 0x02, 0x0a, 0x21, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x53, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x3b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x35, 0x12, 0x33, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x18, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x16, 0x6f, 0x72, 0x63,
	0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x6f, 0x0a, 0x15, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14,
	0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x98, 0x01, 0x0a, 0x21, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x35, 0x0a, 0x33, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xcc, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x64, 0x67, 0x65,
	0x53, 0x6c, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x28, 0x12, 0x26, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0xa7, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x64, 0x67, 0x65, 0x53,
	0x6c, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x09, 0x65,
	0x64, 0x67, 0x65, 0x5f, 0x73, 0x6c, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x52, 0x08, 0x65, 0x64, 0x67, 0x65, 0x53, 0x6c,
	0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x57, 0x0a, 0x11,
	0x47, 0x65, 0x74, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf1, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0b, 0x65, 0x64, 0x67, 0x65, 0x5f, 0x73,
	0x6c, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x65, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x49, 0x64, 0x12, 0x48, 0x0a, 0x08, 0x65,
	0x64, 0x67, 0x65, 0x5f, 0x73, 0x6c, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65, 0x64,
	0x67, 0x65, 0x53, 0x6c, 0x6d, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x7e, 0x0a, 0x14, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xd9, 0x01, 0x0a, 0x16, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x26,
	0x0a, 0x0c, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x62, 0x6c, 0x75, 0x65, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x09, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75, 0x65,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x62, 0x6c, 0x75, 0x65,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x22, 0xa9, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4d, 0x0a, 0x09, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0xa4, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x47, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x5e, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x74, 0x65, 0x6c, 0x63,
	0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x6c, 0x75, 0x65, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x8c, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x62, 0x6c,
	0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x0a, 0x62, 0x6c, 0x75, 0x65,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5f,
	0x0a, 0x17, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x5f, 0x0a, 0x17, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x5e, 0x0a, 0x16, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xa1, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x94, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x62, 0x6c, 0x75, 0x65, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c,
	0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x0a, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcc, 0x01, 0x0a, 0x1f,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x96, 0x01, 0x0a, 0x20, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4a, 0x0a, 0x0a, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52,
	0x0a, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x66, 0x0a, 0x1e, 0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x42, 0x6c,
	0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x6c, 0x75, 0x65,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x21, 0x0a, 0x1f, 0x44,
	0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb3,
	0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xaa, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x11, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f,
	0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x52, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x67, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c,
	0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75, 0x65, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe0, 0x01, 0x0a, 0x17, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x28, 0x0a, 0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0a, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xad, 0x01,
	0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x0a, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xa7, 0x01,
	0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x60, 0x0a, 0x17, 0x52, 0x65, 0x6d, 0x6f, 0x76,
	0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc6, 0x01, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x90, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d,
	0x0a, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xad, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x98, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0b, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xcd, 0x01, 0x0a, 0x20, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x74,
	0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x6c,
	0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x9a, 0x01, 0x0a, 0x21, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x68, 0x0a,
	0x1f, 0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x22, 0x0a, 0x20, 0x44, 0x69, 0x73, 0x63, 0x61,
	0x72, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5f, 0x0a, 0x16, 0x41,
	0x70, 0x70, 0x6c, 0x79, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x67, 0x0a, 0x1e,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf3, 0x01, 0x0a, 0x1f, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x59, 0x0a,
	0x11, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x61, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x22, 0x88, 0x01, 0x0a, 0x19,
	0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a,
	0x29, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62,
	0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x6d,
	0x0a, 0x1c, 0x47, 0x65, 0x74, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb9, 0x01,
	0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x12, 0x31, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb1, 0x01, 0x0a, 0x1f, 0x4c, 0x69,
	0x73, 0x74, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a,
	0x14, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x79,
	0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x13, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xce, 0x01,
	0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x69, 0x0a, 0x13, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6f,
	0x0a, 0x1e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x0a, 0x31, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x8c, 0x02, 0x0a, 0x10, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x79, 0x0a, 0x1a, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64,
	0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x6e, 0x64,
	0x61, 0x72, 0x64, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x18, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x6d, 0x0a, 0x16, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x75, 0x6c, 0x6c, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x14, 0x66, 0x75, 0x6c, 0x6c, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x0e,
	0x0a, 0x0c, 0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xf6,
	0x03, 0x0a, 0x18, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x38, 0x0a, 0x16, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x12, 0x31, 0x0a, 0x12, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x69, 0x64,
	0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x69, 0x64, 0x72, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x33, 0x0a, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x33, 0x0a, 0x13, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x35,
	0x0a, 0x14, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x64,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x64,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x8f, 0x01, 0x0a, 0x21, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1e, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xf2, 0x03, 0x0a, 0x14, 0x46, 0x75, 0x6c, 0x6c,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x1d, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x1b, 0x0a, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x38, 0x0a, 0x16,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72,
	0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x13, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64,
	0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x31, 0x0a, 0x12, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x33, 0x0a, 0x13, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x33,
	0x0a, 0x13, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x5f,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x11, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x64, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x4e, 0x61, 0x6d, 0x65, 0x64, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x8f, 0x01, 0x0a, 0x21, 0x6d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1e, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xea, 0x01, 0x0a,
	0x1e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x6f, 0x0a, 0x0b, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73,
	0x1a, 0x57, 0x0a, 0x09, 0x43, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x63, 0x69, 0x64, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x22, 0x7e, 0x0a, 0x04, 0x46, 0x69, 0x6c,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x64, 0x69, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x65, 0x64, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x96, 0x03, 0x0a, 0x0e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x12, 0x57, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63,
	0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x5e, 0x0a, 0x10, 0x6e, 0x66, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63,
	0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x46, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x6e, 0x66, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x22, 0xaa, 0x01, 0x0a, 0x0e, 0x4e, 0x46, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x65,
	0x64, 0x5f, 0x6e, 0x66, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x65, 0x64, 0x4e, 0x66, 0x73, 0x12, 0x20, 0x0a,
	0x09, 0x72, 0x65, 0x61, 0x64, 0x79, 0x5f, 0x6e, 0x66, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x79, 0x4e, 0x66, 0x73, 0x12,
	0x4e, 0x0a, 0x05, 0x73, 0x69, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x46, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x53, 0x69, 0x74, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x69, 0x74, 0x65, 0x73, 0x22,
	0x84, 0x02, 0x0a, 0x12, 0x4e, 0x46, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x53, 0x69, 0x74, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x73, 0x69, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x73, 0x69, 0x74, 0x65, 0x12,
	0x2e, 0x0a, 0x10, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f,
	0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x53, 0x0a, 0x09, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x68, 0x79, 0x64, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x84, 0x01, 0x0a, 0x0f, 0x48, 0x79, 0x64, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x54, 0x0a, 0x0c, 0x73, 0x69,
	0x74, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x69, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x69, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x71, 0x0a,
	0x0b, 0x53, 0x69, 0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09,
	0x6e, 0x66, 0x5f, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6e, 0x66, 0x56, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x12, 0x1c,
	0x0a, 0x07, 0x6e, 0x66, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x6e, 0x66, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x6e, 0x66, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6e, 0x66, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x83, 0x01, 0x0a, 0x0e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x54, 0x0a, 0x0c, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x74, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x69,
	0x74, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2a, 0x62, 0x0a, 0x0d, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1e, 0x0a, 0x1a, 0x42, 0x4c, 0x55, 0x45, 0x50,
	0x52, 0x49, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x42, 0x4c, 0x55, 0x45, 0x50,
	0x52, 0x49, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10,
	0x01, 0x12, 0x17, 0x0a, 0x13, 0x42, 0x4c, 0x55, 0x45, 0x50, 0x52, 0x49, 0x4e, 0x54, 0x5f, 0x56,
	0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x2a, 0x66, 0x0a, 0x0e, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1f, 0x0a, 0x1b,
	0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a,
	0x15, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57,
	0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x44, 0x45, 0x50, 0x4c,
	0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c,
	0x10, 0x02, 0x2a, 0x5e, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x16, 0x0a, 0x12, 0x4e, 0x46, 0x5f, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x5f, 0x52,
	0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x44, 0x45, 0x50,
	0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x10, 0x02, 0x2a, 0xb6, 0x01, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a,
	0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x11, 0x0a,
	0x0d, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02,
	0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e,
	0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x0a,
	0x12, 0x19, 0x0a, 0x15, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x41,
	0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x0b, 0x2a, 0x90, 0x01, 0x0a, 0x0f,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12,
	0x20, 0x0a, 0x1c, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x45,
	0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x48, 0x59, 0x44, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x44, 0x45, 0x50, 0x4c, 0x4f,
	0x59, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x55, 0x4c, 0x54, 0x49,
	0x5f, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x1f, 0x0a,
	0x1b, 0x57, 0x4f, 0x52, 0x4b, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45,
	0x52, 0x5f, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x32, 0xec,
	0x43, 0x0a, 0x0f, 0x54, 0x65, 0x6c, 0x63, 0x6f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0xee, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x63, 0x68, 0x65,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x72,
	0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x12, 0xdb, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x63, 0x68, 0x65,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xbe, 0x02, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x63, 0x68,
	0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xbc, 0x01, 0xca, 0x41, 0x29, 0x0a, 0x14, 0x4f, 0x72, 0x63, 0x68, 0x65,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x35, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6f, 0x72, 0x63, 0x68,
	0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2c, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52,
	0x3a, 0x15, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x72, 0x63,
	0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x12, 0xf6, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x63,
	0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b,
	0x2a, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xba, 0x01, 0x0a, 0x0c,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x73, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63,
	0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x73, 0x12, 0xa7, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74,
	0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x64, 0x67,
	0x65, 0x53, 0x6c, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x64,
	0x67, 0x65, 0x53, 0x6c, 0x6d, 0x22, 0x3b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xe2, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x64, 0x67,
	0x65, 0x53, 0x6c, 0x6d, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x64, 0x67,
	0x65, 0x53, 0x6c, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7b, 0xca, 0x41, 0x1c, 0x0a,
	0x07, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x64, 0x67, 0x65, 0x5f, 0x73, 0x6c, 0x6d, 0x2c, 0x65, 0x64,
	0x67, 0x65, 0x5f, 0x73, 0x6c, 0x6d, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a,
	0x08, 0x65, 0x64, 0x67, 0x65, 0x5f, 0x73, 0x6c, 0x6d, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65,
	0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x73, 0x12, 0xcf, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x45, 0x64, 0x67, 0x65, 0x53, 0x6c, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x68, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x64,
	0x67, 0x65, 0x53, 0x6c, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf1, 0x01, 0x0a, 0x0f, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x22, 0x79, 0xda, 0x41, 0x1d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x62, 0x6c,
	0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x2c, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x09, 0x62, 0x6c, 0x75, 0x65,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x12, 0xf3, 0x01,
	0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x22, 0x7b, 0xda, 0x41, 0x15, 0x62, 0x6c, 0x75, 0x65, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x3a, 0x09, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x32, 0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72,
	0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xc7, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x42, 0x6c, 0x75, 0x65, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb9, 0x01,
	0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x48, 0x2a, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x6c, 0x75, 0x65,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xda, 0x01, 0x0a, 0x0e, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63,
	0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x6c, 0x75, 0x65, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x6c, 0x75, 0x65,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x12, 0xda, 0x01, 0x0a, 0x10, 0x41, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70,
	0x70, 0x72, 0x6f, 0x76, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x22, 0x60, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53,
	0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x6c,
	0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x12, 0xda, 0x01, 0x0a, 0x10, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x42,
	0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x65, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x22, 0x60,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x01, 0x2a,
	0x22, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x6c, 0x75, 0x65, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65,
	0x12, 0xd7, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x6c, 0x75, 0x65, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x22, 0x5f, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72,
	0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74, 0x12, 0xfe, 0x01, 0x0a, 0x16, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x6c, 0x75, 0x65,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x6c, 0x75, 0x65,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x63, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x56, 0x12, 0x54, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x8e, 0x02, 0x0a, 0x18,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6d, 0xda,
	0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x58, 0x12, 0x56, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x3a, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x92, 0x02, 0x0a,
	0x19, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x6e, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x59, 0x12, 0x57, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63,
	0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0xfe, 0x01, 0x0a, 0x17, 0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x42, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x60, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a,
	0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x69, 0x73, 0x63, 0x61,
	0x72, 0x64, 0x12, 0xda, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x45, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x12,
	0xc7, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75, 0x65, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x22, 0x43, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x36, 0x12, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x42, 0x6c, 0x75, 0x65,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf8, 0x01, 0x0a, 0x10, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x7d, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a,
	0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x47, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0xfa, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0x7f, 0xda, 0x41, 0x16, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x60, 0x3a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x52, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xcb, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xc6, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x60, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x53, 0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x12, 0xde, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63,
	0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x58, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49,
	0x12, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x82, 0x02, 0x0a, 0x17, 0x4c, 0x69,
	0x73, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x64, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x12, 0x55, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x6c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x82,
	0x02, 0x0a, 0x18, 0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69,
	0x73, 0x63, 0x61, 0x72, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x3a,
	0x01, 0x2a, 0x22, 0x4f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x69, 0x73, 0x63,
	0x61, 0x72, 0x64, 0x12, 0xd8, 0x01, 0x0a, 0x0f, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x5f, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x01, 0x2a, 0x22,
	0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x12, 0x8c,
	0x02, 0x0a, 0x17, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6e, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x61, 0x12, 0x5f, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f,
	0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0xed, 0x01,
	0x0a, 0x12, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x6e, 0xda,
	0x41, 0x10, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72,
	0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x12, 0xf9, 0x01,
	0x0a, 0x15, 0x47, 0x65, 0x74, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x48, 0x79, 0x64,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x6c, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5f, 0x12, 0x5d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63,
	0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8c, 0x02, 0x0a, 0x17, 0x4c, 0x69,
	0x73, 0x74, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x79, 0x64, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x79, 0x64,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5f, 0x12, 0x5d, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72,
	0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xc5, 0x02, 0x0a, 0x18, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x79,
	0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xb1, 0x01, 0xda,
	0x41, 0x1f, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x88, 0x01, 0x3a, 0x13, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x71, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x68, 0x79, 0x64, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x86, 0x02, 0x0a, 0x17, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74,
	0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63,
	0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x79, 0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c,
	0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x48, 0x79, 0x64, 0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x75, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x68, 0x3a, 0x01, 0x2a, 0x22, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x68, 0x79, 0x64,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x74, 0x65,
	0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xf5, 0x01,
	0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x14, 0x54, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x74, 0x65, 0x6c, 0x63, 0x6f, 0x61, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x74, 0x65, 0x6c, 0x63, 0x6f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x54, 0x65, 0x6c, 0x63,
	0x6f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x54, 0x65,
	0x6c, 0x63, 0x6f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x54, 0x65, 0x6c, 0x63, 0x6f, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescOnce sync.Once
	file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescData = file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDesc
)

func file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescGZIP() []byte {
	file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescOnce.Do(func() {
		file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescData)
	})
	return file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDescData
}

var file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes = make([]protoimpl.MessageInfo, 72)
var file_google_cloud_telcoautomation_v1_telcoautomation_proto_goTypes = []any{
	(BlueprintView)(0),                               // 0: google.cloud.telcoautomation.v1.BlueprintView
	(DeploymentView)(0),                              // 1: google.cloud.telcoautomation.v1.DeploymentView
	(ResourceType)(0),                                // 2: google.cloud.telcoautomation.v1.ResourceType
	(Status)(0),                                      // 3: google.cloud.telcoautomation.v1.Status
	(DeploymentLevel)(0),                             // 4: google.cloud.telcoautomation.v1.DeploymentLevel
	(OrchestrationCluster_State)(0),                  // 5: google.cloud.telcoautomation.v1.OrchestrationCluster.State
	(EdgeSlm_State)(0),                               // 6: google.cloud.telcoautomation.v1.EdgeSlm.State
	(EdgeSlm_WorkloadClusterType)(0),                 // 7: google.cloud.telcoautomation.v1.EdgeSlm.WorkloadClusterType
	(Blueprint_ApprovalState)(0),                     // 8: google.cloud.telcoautomation.v1.Blueprint.ApprovalState
	(Deployment_State)(0),                            // 9: google.cloud.telcoautomation.v1.Deployment.State
	(HydratedDeployment_State)(0),                    // 10: google.cloud.telcoautomation.v1.HydratedDeployment.State
	(*OrchestrationCluster)(nil),                     // 11: google.cloud.telcoautomation.v1.OrchestrationCluster
	(*EdgeSlm)(nil),                                  // 12: google.cloud.telcoautomation.v1.EdgeSlm
	(*Blueprint)(nil),                                // 13: google.cloud.telcoautomation.v1.Blueprint
	(*PublicBlueprint)(nil),                          // 14: google.cloud.telcoautomation.v1.PublicBlueprint
	(*Deployment)(nil),                               // 15: google.cloud.telcoautomation.v1.Deployment
	(*HydratedDeployment)(nil),                       // 16: google.cloud.telcoautomation.v1.HydratedDeployment
	(*ListOrchestrationClustersRequest)(nil),         // 17: google.cloud.telcoautomation.v1.ListOrchestrationClustersRequest
	(*ListOrchestrationClustersResponse)(nil),        // 18: google.cloud.telcoautomation.v1.ListOrchestrationClustersResponse
	(*GetOrchestrationClusterRequest)(nil),           // 19: google.cloud.telcoautomation.v1.GetOrchestrationClusterRequest
	(*CreateOrchestrationClusterRequest)(nil),        // 20: google.cloud.telcoautomation.v1.CreateOrchestrationClusterRequest
	(*DeleteOrchestrationClusterRequest)(nil),        // 21: google.cloud.telcoautomation.v1.DeleteOrchestrationClusterRequest
	(*ListEdgeSlmsRequest)(nil),                      // 22: google.cloud.telcoautomation.v1.ListEdgeSlmsRequest
	(*ListEdgeSlmsResponse)(nil),                     // 23: google.cloud.telcoautomation.v1.ListEdgeSlmsResponse
	(*GetEdgeSlmRequest)(nil),                        // 24: google.cloud.telcoautomation.v1.GetEdgeSlmRequest
	(*CreateEdgeSlmRequest)(nil),                     // 25: google.cloud.telcoautomation.v1.CreateEdgeSlmRequest
	(*DeleteEdgeSlmRequest)(nil),                     // 26: google.cloud.telcoautomation.v1.DeleteEdgeSlmRequest
	(*CreateBlueprintRequest)(nil),                   // 27: google.cloud.telcoautomation.v1.CreateBlueprintRequest
	(*UpdateBlueprintRequest)(nil),                   // 28: google.cloud.telcoautomation.v1.UpdateBlueprintRequest
	(*GetBlueprintRequest)(nil),                      // 29: google.cloud.telcoautomation.v1.GetBlueprintRequest
	(*DeleteBlueprintRequest)(nil),                   // 30: google.cloud.telcoautomation.v1.DeleteBlueprintRequest
	(*ListBlueprintsRequest)(nil),                    // 31: google.cloud.telcoautomation.v1.ListBlueprintsRequest
	(*ListBlueprintsResponse)(nil),                   // 32: google.cloud.telcoautomation.v1.ListBlueprintsResponse
	(*ApproveBlueprintRequest)(nil),                  // 33: google.cloud.telcoautomation.v1.ApproveBlueprintRequest
	(*ProposeBlueprintRequest)(nil),                  // 34: google.cloud.telcoautomation.v1.ProposeBlueprintRequest
	(*RejectBlueprintRequest)(nil),                   // 35: google.cloud.telcoautomation.v1.RejectBlueprintRequest
	(*ListBlueprintRevisionsRequest)(nil),            // 36: google.cloud.telcoautomation.v1.ListBlueprintRevisionsRequest
	(*ListBlueprintRevisionsResponse)(nil),           // 37: google.cloud.telcoautomation.v1.ListBlueprintRevisionsResponse
	(*SearchBlueprintRevisionsRequest)(nil),          // 38: google.cloud.telcoautomation.v1.SearchBlueprintRevisionsRequest
	(*SearchBlueprintRevisionsResponse)(nil),         // 39: google.cloud.telcoautomation.v1.SearchBlueprintRevisionsResponse
	(*DiscardBlueprintChangesRequest)(nil),           // 40: google.cloud.telcoautomation.v1.DiscardBlueprintChangesRequest
	(*DiscardBlueprintChangesResponse)(nil),          // 41: google.cloud.telcoautomation.v1.DiscardBlueprintChangesResponse
	(*ListPublicBlueprintsRequest)(nil),              // 42: google.cloud.telcoautomation.v1.ListPublicBlueprintsRequest
	(*ListPublicBlueprintsResponse)(nil),             // 43: google.cloud.telcoautomation.v1.ListPublicBlueprintsResponse
	(*GetPublicBlueprintRequest)(nil),                // 44: google.cloud.telcoautomation.v1.GetPublicBlueprintRequest
	(*CreateDeploymentRequest)(nil),                  // 45: google.cloud.telcoautomation.v1.CreateDeploymentRequest
	(*UpdateDeploymentRequest)(nil),                  // 46: google.cloud.telcoautomation.v1.UpdateDeploymentRequest
	(*GetDeploymentRequest)(nil),                     // 47: google.cloud.telcoautomation.v1.GetDeploymentRequest
	(*RemoveDeploymentRequest)(nil),                  // 48: google.cloud.telcoautomation.v1.RemoveDeploymentRequest
	(*ListDeploymentsRequest)(nil),                   // 49: google.cloud.telcoautomation.v1.ListDeploymentsRequest
	(*ListDeploymentsResponse)(nil),                  // 50: google.cloud.telcoautomation.v1.ListDeploymentsResponse
	(*ListDeploymentRevisionsRequest)(nil),           // 51: google.cloud.telcoautomation.v1.ListDeploymentRevisionsRequest
	(*ListDeploymentRevisionsResponse)(nil),          // 52: google.cloud.telcoautomation.v1.ListDeploymentRevisionsResponse
	(*SearchDeploymentRevisionsRequest)(nil),         // 53: google.cloud.telcoautomation.v1.SearchDeploymentRevisionsRequest
	(*SearchDeploymentRevisionsResponse)(nil),        // 54: google.cloud.telcoautomation.v1.SearchDeploymentRevisionsResponse
	(*DiscardDeploymentChangesRequest)(nil),          // 55: google.cloud.telcoautomation.v1.DiscardDeploymentChangesRequest
	(*DiscardDeploymentChangesResponse)(nil),         // 56: google.cloud.telcoautomation.v1.DiscardDeploymentChangesResponse
	(*ApplyDeploymentRequest)(nil),                   // 57: google.cloud.telcoautomation.v1.ApplyDeploymentRequest
	(*ComputeDeploymentStatusRequest)(nil),           // 58: google.cloud.telcoautomation.v1.ComputeDeploymentStatusRequest
	(*ComputeDeploymentStatusResponse)(nil),          // 59: google.cloud.telcoautomation.v1.ComputeDeploymentStatusResponse
	(*RollbackDeploymentRequest)(nil),                // 60: google.cloud.telcoautomation.v1.RollbackDeploymentRequest
	(*OperationMetadata)(nil),                        // 61: google.cloud.telcoautomation.v1.OperationMetadata
	(*GetHydratedDeploymentRequest)(nil),             // 62: google.cloud.telcoautomation.v1.GetHydratedDeploymentRequest
	(*ListHydratedDeploymentsRequest)(nil),           // 63: google.cloud.telcoautomation.v1.ListHydratedDeploymentsRequest
	(*ListHydratedDeploymentsResponse)(nil),          // 64: google.cloud.telcoautomation.v1.ListHydratedDeploymentsResponse
	(*UpdateHydratedDeploymentRequest)(nil),          // 65: google.cloud.telcoautomation.v1.UpdateHydratedDeploymentRequest
	(*ApplyHydratedDeploymentRequest)(nil),           // 66: google.cloud.telcoautomation.v1.ApplyHydratedDeploymentRequest
	(*ManagementConfig)(nil),                         // 67: google.cloud.telcoautomation.v1.ManagementConfig
	(*StandardManagementConfig)(nil),                 // 68: google.cloud.telcoautomation.v1.StandardManagementConfig
	(*FullManagementConfig)(nil),                     // 69: google.cloud.telcoautomation.v1.FullManagementConfig
	(*MasterAuthorizedNetworksConfig)(nil),           // 70: google.cloud.telcoautomation.v1.MasterAuthorizedNetworksConfig
	(*File)(nil),                                     // 71: google.cloud.telcoautomation.v1.File
	(*ResourceStatus)(nil),                           // 72: google.cloud.telcoautomation.v1.ResourceStatus
	(*NFDeployStatus)(nil),                           // 73: google.cloud.telcoautomation.v1.NFDeployStatus
	(*NFDeploySiteStatus)(nil),                       // 74: google.cloud.telcoautomation.v1.NFDeploySiteStatus
	(*HydrationStatus)(nil),                          // 75: google.cloud.telcoautomation.v1.HydrationStatus
	(*SiteVersion)(nil),                              // 76: google.cloud.telcoautomation.v1.SiteVersion
	(*WorkloadStatus)(nil),                           // 77: google.cloud.telcoautomation.v1.WorkloadStatus
	nil,                                              // 78: google.cloud.telcoautomation.v1.OrchestrationCluster.LabelsEntry
	nil,                                              // 79: google.cloud.telcoautomation.v1.EdgeSlm.LabelsEntry
	nil,                                              // 80: google.cloud.telcoautomation.v1.Blueprint.LabelsEntry
	nil,                                              // 81: google.cloud.telcoautomation.v1.Deployment.LabelsEntry
	(*MasterAuthorizedNetworksConfig_CidrBlock)(nil), // 82: google.cloud.telcoautomation.v1.MasterAuthorizedNetworksConfig.CidrBlock
	(*timestamppb.Timestamp)(nil),                    // 83: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                    // 84: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),                  // 85: google.longrunning.Operation
	(*emptypb.Empty)(nil),                            // 86: google.protobuf.Empty
}
var file_google_cloud_telcoautomation_v1_telcoautomation_proto_depIdxs = []int32{
	67,  // 0: google.cloud.telcoautomation.v1.OrchestrationCluster.management_config:type_name -> google.cloud.telcoautomation.v1.ManagementConfig
	83,  // 1: google.cloud.telcoautomation.v1.OrchestrationCluster.create_time:type_name -> google.protobuf.Timestamp
	83,  // 2: google.cloud.telcoautomation.v1.OrchestrationCluster.update_time:type_name -> google.protobuf.Timestamp
	78,  // 3: google.cloud.telcoautomation.v1.OrchestrationCluster.labels:type_name -> google.cloud.telcoautomation.v1.OrchestrationCluster.LabelsEntry
	5,   // 4: google.cloud.telcoautomation.v1.OrchestrationCluster.state:type_name -> google.cloud.telcoautomation.v1.OrchestrationCluster.State
	83,  // 5: google.cloud.telcoautomation.v1.EdgeSlm.create_time:type_name -> google.protobuf.Timestamp
	83,  // 6: google.cloud.telcoautomation.v1.EdgeSlm.update_time:type_name -> google.protobuf.Timestamp
	79,  // 7: google.cloud.telcoautomation.v1.EdgeSlm.labels:type_name -> google.cloud.telcoautomation.v1.EdgeSlm.LabelsEntry
	6,   // 8: google.cloud.telcoautomation.v1.EdgeSlm.state:type_name -> google.cloud.telcoautomation.v1.EdgeSlm.State
	7,   // 9: google.cloud.telcoautomation.v1.EdgeSlm.workload_cluster_type:type_name -> google.cloud.telcoautomation.v1.EdgeSlm.WorkloadClusterType
	83,  // 10: google.cloud.telcoautomation.v1.Blueprint.revision_create_time:type_name -> google.protobuf.Timestamp
	8,   // 11: google.cloud.telcoautomation.v1.Blueprint.approval_state:type_name -> google.cloud.telcoautomation.v1.Blueprint.ApprovalState
	71,  // 12: google.cloud.telcoautomation.v1.Blueprint.files:type_name -> google.cloud.telcoautomation.v1.File
	80,  // 13: google.cloud.telcoautomation.v1.Blueprint.labels:type_name -> google.cloud.telcoautomation.v1.Blueprint.LabelsEntry
	83,  // 14: google.cloud.telcoautomation.v1.Blueprint.create_time:type_name -> google.protobuf.Timestamp
	83,  // 15: google.cloud.telcoautomation.v1.Blueprint.update_time:type_name -> google.protobuf.Timestamp
	4,   // 16: google.cloud.telcoautomation.v1.Blueprint.deployment_level:type_name -> google.cloud.telcoautomation.v1.DeploymentLevel
	4,   // 17: google.cloud.telcoautomation.v1.PublicBlueprint.deployment_level:type_name -> google.cloud.telcoautomation.v1.DeploymentLevel
	83,  // 18: google.cloud.telcoautomation.v1.Deployment.revision_create_time:type_name -> google.protobuf.Timestamp
	9,   // 19: google.cloud.telcoautomation.v1.Deployment.state:type_name -> google.cloud.telcoautomation.v1.Deployment.State
	71,  // 20: google.cloud.telcoautomation.v1.Deployment.files:type_name -> google.cloud.telcoautomation.v1.File
	81,  // 21: google.cloud.telcoautomation.v1.Deployment.labels:type_name -> google.cloud.telcoautomation.v1.Deployment.LabelsEntry
	83,  // 22: google.cloud.telcoautomation.v1.Deployment.create_time:type_name -> google.protobuf.Timestamp
	83,  // 23: google.cloud.telcoautomation.v1.Deployment.update_time:type_name -> google.protobuf.Timestamp
	4,   // 24: google.cloud.telcoautomation.v1.Deployment.deployment_level:type_name -> google.cloud.telcoautomation.v1.DeploymentLevel
	10,  // 25: google.cloud.telcoautomation.v1.HydratedDeployment.state:type_name -> google.cloud.telcoautomation.v1.HydratedDeployment.State
	71,  // 26: google.cloud.telcoautomation.v1.HydratedDeployment.files:type_name -> google.cloud.telcoautomation.v1.File
	11,  // 27: google.cloud.telcoautomation.v1.ListOrchestrationClustersResponse.orchestration_clusters:type_name -> google.cloud.telcoautomation.v1.OrchestrationCluster
	11,  // 28: google.cloud.telcoautomation.v1.CreateOrchestrationClusterRequest.orchestration_cluster:type_name -> google.cloud.telcoautomation.v1.OrchestrationCluster
	12,  // 29: google.cloud.telcoautomation.v1.ListEdgeSlmsResponse.edge_slms:type_name -> google.cloud.telcoautomation.v1.EdgeSlm
	12,  // 30: google.cloud.telcoautomation.v1.CreateEdgeSlmRequest.edge_slm:type_name -> google.cloud.telcoautomation.v1.EdgeSlm
	13,  // 31: google.cloud.telcoautomation.v1.CreateBlueprintRequest.blueprint:type_name -> google.cloud.telcoautomation.v1.Blueprint
	13,  // 32: google.cloud.telcoautomation.v1.UpdateBlueprintRequest.blueprint:type_name -> google.cloud.telcoautomation.v1.Blueprint
	84,  // 33: google.cloud.telcoautomation.v1.UpdateBlueprintRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,   // 34: google.cloud.telcoautomation.v1.GetBlueprintRequest.view:type_name -> google.cloud.telcoautomation.v1.BlueprintView
	13,  // 35: google.cloud.telcoautomation.v1.ListBlueprintsResponse.blueprints:type_name -> google.cloud.telcoautomation.v1.Blueprint
	13,  // 36: google.cloud.telcoautomation.v1.ListBlueprintRevisionsResponse.blueprints:type_name -> google.cloud.telcoautomation.v1.Blueprint
	13,  // 37: google.cloud.telcoautomation.v1.SearchBlueprintRevisionsResponse.blueprints:type_name -> google.cloud.telcoautomation.v1.Blueprint
	14,  // 38: google.cloud.telcoautomation.v1.ListPublicBlueprintsResponse.public_blueprints:type_name -> google.cloud.telcoautomation.v1.PublicBlueprint
	15,  // 39: google.cloud.telcoautomation.v1.CreateDeploymentRequest.deployment:type_name -> google.cloud.telcoautomation.v1.Deployment
	15,  // 40: google.cloud.telcoautomation.v1.UpdateDeploymentRequest.deployment:type_name -> google.cloud.telcoautomation.v1.Deployment
	84,  // 41: google.cloud.telcoautomation.v1.UpdateDeploymentRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,   // 42: google.cloud.telcoautomation.v1.GetDeploymentRequest.view:type_name -> google.cloud.telcoautomation.v1.DeploymentView
	15,  // 43: google.cloud.telcoautomation.v1.ListDeploymentsResponse.deployments:type_name -> google.cloud.telcoautomation.v1.Deployment
	15,  // 44: google.cloud.telcoautomation.v1.ListDeploymentRevisionsResponse.deployments:type_name -> google.cloud.telcoautomation.v1.Deployment
	15,  // 45: google.cloud.telcoautomation.v1.SearchDeploymentRevisionsResponse.deployments:type_name -> google.cloud.telcoautomation.v1.Deployment
	3,   // 46: google.cloud.telcoautomation.v1.ComputeDeploymentStatusResponse.aggregated_status:type_name -> google.cloud.telcoautomation.v1.Status
	72,  // 47: google.cloud.telcoautomation.v1.ComputeDeploymentStatusResponse.resource_statuses:type_name -> google.cloud.telcoautomation.v1.ResourceStatus
	83,  // 48: google.cloud.telcoautomation.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	83,  // 49: google.cloud.telcoautomation.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	16,  // 50: google.cloud.telcoautomation.v1.ListHydratedDeploymentsResponse.hydrated_deployments:type_name -> google.cloud.telcoautomation.v1.HydratedDeployment
	16,  // 51: google.cloud.telcoautomation.v1.UpdateHydratedDeploymentRequest.hydrated_deployment:type_name -> google.cloud.telcoautomation.v1.HydratedDeployment
	84,  // 52: google.cloud.telcoautomation.v1.UpdateHydratedDeploymentRequest.update_mask:type_name -> google.protobuf.FieldMask
	68,  // 53: google.cloud.telcoautomation.v1.ManagementConfig.standard_management_config:type_name -> google.cloud.telcoautomation.v1.StandardManagementConfig
	69,  // 54: google.cloud.telcoautomation.v1.ManagementConfig.full_management_config:type_name -> google.cloud.telcoautomation.v1.FullManagementConfig
	70,  // 55: google.cloud.telcoautomation.v1.StandardManagementConfig.master_authorized_networks_config:type_name -> google.cloud.telcoautomation.v1.MasterAuthorizedNetworksConfig
	70,  // 56: google.cloud.telcoautomation.v1.FullManagementConfig.master_authorized_networks_config:type_name -> google.cloud.telcoautomation.v1.MasterAuthorizedNetworksConfig
	82,  // 57: google.cloud.telcoautomation.v1.MasterAuthorizedNetworksConfig.cidr_blocks:type_name -> google.cloud.telcoautomation.v1.MasterAuthorizedNetworksConfig.CidrBlock
	2,   // 58: google.cloud.telcoautomation.v1.ResourceStatus.resource_type:type_name -> google.cloud.telcoautomation.v1.ResourceType
	3,   // 59: google.cloud.telcoautomation.v1.ResourceStatus.status:type_name -> google.cloud.telcoautomation.v1.Status
	73,  // 60: google.cloud.telcoautomation.v1.ResourceStatus.nf_deploy_status:type_name -> google.cloud.telcoautomation.v1.NFDeployStatus
	74,  // 61: google.cloud.telcoautomation.v1.NFDeployStatus.sites:type_name -> google.cloud.telcoautomation.v1.NFDeploySiteStatus
	75,  // 62: google.cloud.telcoautomation.v1.NFDeploySiteStatus.hydration:type_name -> google.cloud.telcoautomation.v1.HydrationStatus
	77,  // 63: google.cloud.telcoautomation.v1.NFDeploySiteStatus.workload:type_name -> google.cloud.telcoautomation.v1.WorkloadStatus
	76,  // 64: google.cloud.telcoautomation.v1.HydrationStatus.site_version:type_name -> google.cloud.telcoautomation.v1.SiteVersion
	76,  // 65: google.cloud.telcoautomation.v1.WorkloadStatus.site_version:type_name -> google.cloud.telcoautomation.v1.SiteVersion
	17,  // 66: google.cloud.telcoautomation.v1.TelcoAutomation.ListOrchestrationClusters:input_type -> google.cloud.telcoautomation.v1.ListOrchestrationClustersRequest
	19,  // 67: google.cloud.telcoautomation.v1.TelcoAutomation.GetOrchestrationCluster:input_type -> google.cloud.telcoautomation.v1.GetOrchestrationClusterRequest
	20,  // 68: google.cloud.telcoautomation.v1.TelcoAutomation.CreateOrchestrationCluster:input_type -> google.cloud.telcoautomation.v1.CreateOrchestrationClusterRequest
	21,  // 69: google.cloud.telcoautomation.v1.TelcoAutomation.DeleteOrchestrationCluster:input_type -> google.cloud.telcoautomation.v1.DeleteOrchestrationClusterRequest
	22,  // 70: google.cloud.telcoautomation.v1.TelcoAutomation.ListEdgeSlms:input_type -> google.cloud.telcoautomation.v1.ListEdgeSlmsRequest
	24,  // 71: google.cloud.telcoautomation.v1.TelcoAutomation.GetEdgeSlm:input_type -> google.cloud.telcoautomation.v1.GetEdgeSlmRequest
	25,  // 72: google.cloud.telcoautomation.v1.TelcoAutomation.CreateEdgeSlm:input_type -> google.cloud.telcoautomation.v1.CreateEdgeSlmRequest
	26,  // 73: google.cloud.telcoautomation.v1.TelcoAutomation.DeleteEdgeSlm:input_type -> google.cloud.telcoautomation.v1.DeleteEdgeSlmRequest
	27,  // 74: google.cloud.telcoautomation.v1.TelcoAutomation.CreateBlueprint:input_type -> google.cloud.telcoautomation.v1.CreateBlueprintRequest
	28,  // 75: google.cloud.telcoautomation.v1.TelcoAutomation.UpdateBlueprint:input_type -> google.cloud.telcoautomation.v1.UpdateBlueprintRequest
	29,  // 76: google.cloud.telcoautomation.v1.TelcoAutomation.GetBlueprint:input_type -> google.cloud.telcoautomation.v1.GetBlueprintRequest
	30,  // 77: google.cloud.telcoautomation.v1.TelcoAutomation.DeleteBlueprint:input_type -> google.cloud.telcoautomation.v1.DeleteBlueprintRequest
	31,  // 78: google.cloud.telcoautomation.v1.TelcoAutomation.ListBlueprints:input_type -> google.cloud.telcoautomation.v1.ListBlueprintsRequest
	33,  // 79: google.cloud.telcoautomation.v1.TelcoAutomation.ApproveBlueprint:input_type -> google.cloud.telcoautomation.v1.ApproveBlueprintRequest
	34,  // 80: google.cloud.telcoautomation.v1.TelcoAutomation.ProposeBlueprint:input_type -> google.cloud.telcoautomation.v1.ProposeBlueprintRequest
	35,  // 81: google.cloud.telcoautomation.v1.TelcoAutomation.RejectBlueprint:input_type -> google.cloud.telcoautomation.v1.RejectBlueprintRequest
	36,  // 82: google.cloud.telcoautomation.v1.TelcoAutomation.ListBlueprintRevisions:input_type -> google.cloud.telcoautomation.v1.ListBlueprintRevisionsRequest
	38,  // 83: google.cloud.telcoautomation.v1.TelcoAutomation.SearchBlueprintRevisions:input_type -> google.cloud.telcoautomation.v1.SearchBlueprintRevisionsRequest
	53,  // 84: google.cloud.telcoautomation.v1.TelcoAutomation.SearchDeploymentRevisions:input_type -> google.cloud.telcoautomation.v1.SearchDeploymentRevisionsRequest
	40,  // 85: google.cloud.telcoautomation.v1.TelcoAutomation.DiscardBlueprintChanges:input_type -> google.cloud.telcoautomation.v1.DiscardBlueprintChangesRequest
	42,  // 86: google.cloud.telcoautomation.v1.TelcoAutomation.ListPublicBlueprints:input_type -> google.cloud.telcoautomation.v1.ListPublicBlueprintsRequest
	44,  // 87: google.cloud.telcoautomation.v1.TelcoAutomation.GetPublicBlueprint:input_type -> google.cloud.telcoautomation.v1.GetPublicBlueprintRequest
	45,  // 88: google.cloud.telcoautomation.v1.TelcoAutomation.CreateDeployment:input_type -> google.cloud.telcoautomation.v1.CreateDeploymentRequest
	46,  // 89: google.cloud.telcoautomation.v1.TelcoAutomation.UpdateDeployment:input_type -> google.cloud.telcoautomation.v1.UpdateDeploymentRequest
	47,  // 90: google.cloud.telcoautomation.v1.TelcoAutomation.GetDeployment:input_type -> google.cloud.telcoautomation.v1.GetDeploymentRequest
	48,  // 91: google.cloud.telcoautomation.v1.TelcoAutomation.RemoveDeployment:input_type -> google.cloud.telcoautomation.v1.RemoveDeploymentRequest
	49,  // 92: google.cloud.telcoautomation.v1.TelcoAutomation.ListDeployments:input_type -> google.cloud.telcoautomation.v1.ListDeploymentsRequest
	51,  // 93: google.cloud.telcoautomation.v1.TelcoAutomation.ListDeploymentRevisions:input_type -> google.cloud.telcoautomation.v1.ListDeploymentRevisionsRequest
	55,  // 94: google.cloud.telcoautomation.v1.TelcoAutomation.DiscardDeploymentChanges:input_type -> google.cloud.telcoautomation.v1.DiscardDeploymentChangesRequest
	57,  // 95: google.cloud.telcoautomation.v1.TelcoAutomation.ApplyDeployment:input_type -> google.cloud.telcoautomation.v1.ApplyDeploymentRequest
	58,  // 96: google.cloud.telcoautomation.v1.TelcoAutomation.ComputeDeploymentStatus:input_type -> google.cloud.telcoautomation.v1.ComputeDeploymentStatusRequest
	60,  // 97: google.cloud.telcoautomation.v1.TelcoAutomation.RollbackDeployment:input_type -> google.cloud.telcoautomation.v1.RollbackDeploymentRequest
	62,  // 98: google.cloud.telcoautomation.v1.TelcoAutomation.GetHydratedDeployment:input_type -> google.cloud.telcoautomation.v1.GetHydratedDeploymentRequest
	63,  // 99: google.cloud.telcoautomation.v1.TelcoAutomation.ListHydratedDeployments:input_type -> google.cloud.telcoautomation.v1.ListHydratedDeploymentsRequest
	65,  // 100: google.cloud.telcoautomation.v1.TelcoAutomation.UpdateHydratedDeployment:input_type -> google.cloud.telcoautomation.v1.UpdateHydratedDeploymentRequest
	66,  // 101: google.cloud.telcoautomation.v1.TelcoAutomation.ApplyHydratedDeployment:input_type -> google.cloud.telcoautomation.v1.ApplyHydratedDeploymentRequest
	18,  // 102: google.cloud.telcoautomation.v1.TelcoAutomation.ListOrchestrationClusters:output_type -> google.cloud.telcoautomation.v1.ListOrchestrationClustersResponse
	11,  // 103: google.cloud.telcoautomation.v1.TelcoAutomation.GetOrchestrationCluster:output_type -> google.cloud.telcoautomation.v1.OrchestrationCluster
	85,  // 104: google.cloud.telcoautomation.v1.TelcoAutomation.CreateOrchestrationCluster:output_type -> google.longrunning.Operation
	85,  // 105: google.cloud.telcoautomation.v1.TelcoAutomation.DeleteOrchestrationCluster:output_type -> google.longrunning.Operation
	23,  // 106: google.cloud.telcoautomation.v1.TelcoAutomation.ListEdgeSlms:output_type -> google.cloud.telcoautomation.v1.ListEdgeSlmsResponse
	12,  // 107: google.cloud.telcoautomation.v1.TelcoAutomation.GetEdgeSlm:output_type -> google.cloud.telcoautomation.v1.EdgeSlm
	85,  // 108: google.cloud.telcoautomation.v1.TelcoAutomation.CreateEdgeSlm:output_type -> google.longrunning.Operation
	85,  // 109: google.cloud.telcoautomation.v1.TelcoAutomation.DeleteEdgeSlm:output_type -> google.longrunning.Operation
	13,  // 110: google.cloud.telcoautomation.v1.TelcoAutomation.CreateBlueprint:output_type -> google.cloud.telcoautomation.v1.Blueprint
	13,  // 111: google.cloud.telcoautomation.v1.TelcoAutomation.UpdateBlueprint:output_type -> google.cloud.telcoautomation.v1.Blueprint
	13,  // 112: google.cloud.telcoautomation.v1.TelcoAutomation.GetBlueprint:output_type -> google.cloud.telcoautomation.v1.Blueprint
	86,  // 113: google.cloud.telcoautomation.v1.TelcoAutomation.DeleteBlueprint:output_type -> google.protobuf.Empty
	32,  // 114: google.cloud.telcoautomation.v1.TelcoAutomation.ListBlueprints:output_type -> google.cloud.telcoautomation.v1.ListBlueprintsResponse
	13,  // 115: google.cloud.telcoautomation.v1.TelcoAutomation.ApproveBlueprint:output_type -> google.cloud.telcoautomation.v1.Blueprint
	13,  // 116: google.cloud.telcoautomation.v1.TelcoAutomation.ProposeBlueprint:output_type -> google.cloud.telcoautomation.v1.Blueprint
	13,  // 117: google.cloud.telcoautomation.v1.TelcoAutomation.RejectBlueprint:output_type -> google.cloud.telcoautomation.v1.Blueprint
	37,  // 118: google.cloud.telcoautomation.v1.TelcoAutomation.ListBlueprintRevisions:output_type -> google.cloud.telcoautomation.v1.ListBlueprintRevisionsResponse
	39,  // 119: google.cloud.telcoautomation.v1.TelcoAutomation.SearchBlueprintRevisions:output_type -> google.cloud.telcoautomation.v1.SearchBlueprintRevisionsResponse
	54,  // 120: google.cloud.telcoautomation.v1.TelcoAutomation.SearchDeploymentRevisions:output_type -> google.cloud.telcoautomation.v1.SearchDeploymentRevisionsResponse
	41,  // 121: google.cloud.telcoautomation.v1.TelcoAutomation.DiscardBlueprintChanges:output_type -> google.cloud.telcoautomation.v1.DiscardBlueprintChangesResponse
	43,  // 122: google.cloud.telcoautomation.v1.TelcoAutomation.ListPublicBlueprints:output_type -> google.cloud.telcoautomation.v1.ListPublicBlueprintsResponse
	14,  // 123: google.cloud.telcoautomation.v1.TelcoAutomation.GetPublicBlueprint:output_type -> google.cloud.telcoautomation.v1.PublicBlueprint
	15,  // 124: google.cloud.telcoautomation.v1.TelcoAutomation.CreateDeployment:output_type -> google.cloud.telcoautomation.v1.Deployment
	15,  // 125: google.cloud.telcoautomation.v1.TelcoAutomation.UpdateDeployment:output_type -> google.cloud.telcoautomation.v1.Deployment
	15,  // 126: google.cloud.telcoautomation.v1.TelcoAutomation.GetDeployment:output_type -> google.cloud.telcoautomation.v1.Deployment
	86,  // 127: google.cloud.telcoautomation.v1.TelcoAutomation.RemoveDeployment:output_type -> google.protobuf.Empty
	50,  // 128: google.cloud.telcoautomation.v1.TelcoAutomation.ListDeployments:output_type -> google.cloud.telcoautomation.v1.ListDeploymentsResponse
	52,  // 129: google.cloud.telcoautomation.v1.TelcoAutomation.ListDeploymentRevisions:output_type -> google.cloud.telcoautomation.v1.ListDeploymentRevisionsResponse
	56,  // 130: google.cloud.telcoautomation.v1.TelcoAutomation.DiscardDeploymentChanges:output_type -> google.cloud.telcoautomation.v1.DiscardDeploymentChangesResponse
	15,  // 131: google.cloud.telcoautomation.v1.TelcoAutomation.ApplyDeployment:output_type -> google.cloud.telcoautomation.v1.Deployment
	59,  // 132: google.cloud.telcoautomation.v1.TelcoAutomation.ComputeDeploymentStatus:output_type -> google.cloud.telcoautomation.v1.ComputeDeploymentStatusResponse
	15,  // 133: google.cloud.telcoautomation.v1.TelcoAutomation.RollbackDeployment:output_type -> google.cloud.telcoautomation.v1.Deployment
	16,  // 134: google.cloud.telcoautomation.v1.TelcoAutomation.GetHydratedDeployment:output_type -> google.cloud.telcoautomation.v1.HydratedDeployment
	64,  // 135: google.cloud.telcoautomation.v1.TelcoAutomation.ListHydratedDeployments:output_type -> google.cloud.telcoautomation.v1.ListHydratedDeploymentsResponse
	16,  // 136: google.cloud.telcoautomation.v1.TelcoAutomation.UpdateHydratedDeployment:output_type -> google.cloud.telcoautomation.v1.HydratedDeployment
	16,  // 137: google.cloud.telcoautomation.v1.TelcoAutomation.ApplyHydratedDeployment:output_type -> google.cloud.telcoautomation.v1.HydratedDeployment
	102, // [102:138] is the sub-list for method output_type
	66,  // [66:102] is the sub-list for method input_type
	66,  // [66:66] is the sub-list for extension type_name
	66,  // [66:66] is the sub-list for extension extendee
	0,   // [0:66] is the sub-list for field type_name
}

func init() { file_google_cloud_telcoautomation_v1_telcoautomation_proto_init() }
func file_google_cloud_telcoautomation_v1_telcoautomation_proto_init() {
	if File_google_cloud_telcoautomation_v1_telcoautomation_proto != nil {
		return
	}
	file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes[56].OneofWrappers = []any{
		(*ManagementConfig_StandardManagementConfig)(nil),
		(*ManagementConfig_FullManagementConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   72,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_telcoautomation_v1_telcoautomation_proto_goTypes,
		DependencyIndexes: file_google_cloud_telcoautomation_v1_telcoautomation_proto_depIdxs,
		EnumInfos:         file_google_cloud_telcoautomation_v1_telcoautomation_proto_enumTypes,
		MessageInfos:      file_google_cloud_telcoautomation_v1_telcoautomation_proto_msgTypes,
	}.Build()
	File_google_cloud_telcoautomation_v1_telcoautomation_proto = out.File
	file_google_cloud_telcoautomation_v1_telcoautomation_proto_rawDesc = nil
	file_google_cloud_telcoautomation_v1_telcoautomation_proto_goTypes = nil
	file_google_cloud_telcoautomation_v1_telcoautomation_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TelcoAutomationClient is the client API for TelcoAutomation service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TelcoAutomationClient interface {
	// Lists OrchestrationClusters in a given project and location.
	ListOrchestrationClusters(ctx context.Context, in *ListOrchestrationClustersRequest, opts ...grpc.CallOption) (*ListOrchestrationClustersResponse, error)
	// Gets details of a single OrchestrationCluster.
	GetOrchestrationCluster(ctx context.Context, in *GetOrchestrationClusterRequest, opts ...grpc.CallOption) (*OrchestrationCluster, error)
	// Creates a new OrchestrationCluster in a given project and location.
	CreateOrchestrationCluster(ctx context.Context, in *CreateOrchestrationClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single OrchestrationCluster.
	DeleteOrchestrationCluster(ctx context.Context, in *DeleteOrchestrationClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists EdgeSlms in a given project and location.
	ListEdgeSlms(ctx context.Context, in *ListEdgeSlmsRequest, opts ...grpc.CallOption) (*ListEdgeSlmsResponse, error)
	// Gets details of a single EdgeSlm.
	GetEdgeSlm(ctx context.Context, in *GetEdgeSlmRequest, opts ...grpc.CallOption) (*EdgeSlm, error)
	// Creates a new EdgeSlm in a given project and location.
	CreateEdgeSlm(ctx context.Context, in *CreateEdgeSlmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single EdgeSlm.
	DeleteEdgeSlm(ctx context.Context, in *DeleteEdgeSlmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a blueprint.
	CreateBlueprint(ctx context.Context, in *CreateBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error)
	// Updates a blueprint.
	UpdateBlueprint(ctx context.Context, in *UpdateBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error)
	// Returns the requested blueprint.
	GetBlueprint(ctx context.Context, in *GetBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error)
	// Deletes a blueprint and all its revisions.
	DeleteBlueprint(ctx context.Context, in *DeleteBlueprintRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List all blueprints.
	ListBlueprints(ctx context.Context, in *ListBlueprintsRequest, opts ...grpc.CallOption) (*ListBlueprintsResponse, error)
	// Approves a blueprint and commits a new revision.
	ApproveBlueprint(ctx context.Context, in *ApproveBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error)
	// Proposes a blueprint for approval of changes.
	ProposeBlueprint(ctx context.Context, in *ProposeBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error)
	// Rejects a blueprint revision proposal and flips it back to Draft state.
	RejectBlueprint(ctx context.Context, in *RejectBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error)
	// List blueprint revisions of a given blueprint.
	ListBlueprintRevisions(ctx context.Context, in *ListBlueprintRevisionsRequest, opts ...grpc.CallOption) (*ListBlueprintRevisionsResponse, error)
	// Searches across blueprint revisions.
	SearchBlueprintRevisions(ctx context.Context, in *SearchBlueprintRevisionsRequest, opts ...grpc.CallOption) (*SearchBlueprintRevisionsResponse, error)
	// Searches across deployment revisions.
	SearchDeploymentRevisions(ctx context.Context, in *SearchDeploymentRevisionsRequest, opts ...grpc.CallOption) (*SearchDeploymentRevisionsResponse, error)
	// Discards the changes in a blueprint and reverts the blueprint to the last
	// approved blueprint revision. No changes take place if a blueprint does not
	// have revisions.
	DiscardBlueprintChanges(ctx context.Context, in *DiscardBlueprintChangesRequest, opts ...grpc.CallOption) (*DiscardBlueprintChangesResponse, error)
	// Lists the blueprints in TNA's public catalog. Default page size = 20,
	// Max Page Size = 100.
	ListPublicBlueprints(ctx context.Context, in *ListPublicBlueprintsRequest, opts ...grpc.CallOption) (*ListPublicBlueprintsResponse, error)
	// Returns the requested public blueprint.
	GetPublicBlueprint(ctx context.Context, in *GetPublicBlueprintRequest, opts ...grpc.CallOption) (*PublicBlueprint, error)
	// Creates a deployment.
	CreateDeployment(ctx context.Context, in *CreateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Updates a deployment.
	UpdateDeployment(ctx context.Context, in *UpdateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Returns the requested deployment.
	GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Removes the deployment by marking it as DELETING. Post which deployment and
	// it's revisions gets deleted.
	RemoveDeployment(ctx context.Context, in *RemoveDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List all deployments.
	ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error)
	// List deployment revisions of a given deployment.
	ListDeploymentRevisions(ctx context.Context, in *ListDeploymentRevisionsRequest, opts ...grpc.CallOption) (*ListDeploymentRevisionsResponse, error)
	// Discards the changes in a deployment and reverts the deployment to the last
	// approved deployment revision. No changes take place if a deployment does
	// not have revisions.
	DiscardDeploymentChanges(ctx context.Context, in *DiscardDeploymentChangesRequest, opts ...grpc.CallOption) (*DiscardDeploymentChangesResponse, error)
	// Applies the deployment's YAML files to the parent orchestration cluster.
	ApplyDeployment(ctx context.Context, in *ApplyDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Returns the requested deployment status.
	ComputeDeploymentStatus(ctx context.Context, in *ComputeDeploymentStatusRequest, opts ...grpc.CallOption) (*ComputeDeploymentStatusResponse, error)
	// Rollback the active deployment to the given past approved deployment
	// revision.
	RollbackDeployment(ctx context.Context, in *RollbackDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Returns the requested hydrated deployment.
	GetHydratedDeployment(ctx context.Context, in *GetHydratedDeploymentRequest, opts ...grpc.CallOption) (*HydratedDeployment, error)
	// List all hydrated deployments present under a deployment.
	ListHydratedDeployments(ctx context.Context, in *ListHydratedDeploymentsRequest, opts ...grpc.CallOption) (*ListHydratedDeploymentsResponse, error)
	// Updates a hydrated deployment.
	UpdateHydratedDeployment(ctx context.Context, in *UpdateHydratedDeploymentRequest, opts ...grpc.CallOption) (*HydratedDeployment, error)
	// Applies a hydrated deployment to a workload cluster.
	ApplyHydratedDeployment(ctx context.Context, in *ApplyHydratedDeploymentRequest, opts ...grpc.CallOption) (*HydratedDeployment, error)
}

type telcoAutomationClient struct {
	cc grpc.ClientConnInterface
}

func NewTelcoAutomationClient(cc grpc.ClientConnInterface) TelcoAutomationClient {
	return &telcoAutomationClient{cc}
}

func (c *telcoAutomationClient) ListOrchestrationClusters(ctx context.Context, in *ListOrchestrationClustersRequest, opts ...grpc.CallOption) (*ListOrchestrationClustersResponse, error) {
	out := new(ListOrchestrationClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ListOrchestrationClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) GetOrchestrationCluster(ctx context.Context, in *GetOrchestrationClusterRequest, opts ...grpc.CallOption) (*OrchestrationCluster, error) {
	out := new(OrchestrationCluster)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/GetOrchestrationCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) CreateOrchestrationCluster(ctx context.Context, in *CreateOrchestrationClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/CreateOrchestrationCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) DeleteOrchestrationCluster(ctx context.Context, in *DeleteOrchestrationClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/DeleteOrchestrationCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ListEdgeSlms(ctx context.Context, in *ListEdgeSlmsRequest, opts ...grpc.CallOption) (*ListEdgeSlmsResponse, error) {
	out := new(ListEdgeSlmsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ListEdgeSlms", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) GetEdgeSlm(ctx context.Context, in *GetEdgeSlmRequest, opts ...grpc.CallOption) (*EdgeSlm, error) {
	out := new(EdgeSlm)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/GetEdgeSlm", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) CreateEdgeSlm(ctx context.Context, in *CreateEdgeSlmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/CreateEdgeSlm", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) DeleteEdgeSlm(ctx context.Context, in *DeleteEdgeSlmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/DeleteEdgeSlm", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) CreateBlueprint(ctx context.Context, in *CreateBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error) {
	out := new(Blueprint)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/CreateBlueprint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) UpdateBlueprint(ctx context.Context, in *UpdateBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error) {
	out := new(Blueprint)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/UpdateBlueprint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) GetBlueprint(ctx context.Context, in *GetBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error) {
	out := new(Blueprint)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/GetBlueprint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) DeleteBlueprint(ctx context.Context, in *DeleteBlueprintRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/DeleteBlueprint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ListBlueprints(ctx context.Context, in *ListBlueprintsRequest, opts ...grpc.CallOption) (*ListBlueprintsResponse, error) {
	out := new(ListBlueprintsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ListBlueprints", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ApproveBlueprint(ctx context.Context, in *ApproveBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error) {
	out := new(Blueprint)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ApproveBlueprint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ProposeBlueprint(ctx context.Context, in *ProposeBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error) {
	out := new(Blueprint)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ProposeBlueprint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) RejectBlueprint(ctx context.Context, in *RejectBlueprintRequest, opts ...grpc.CallOption) (*Blueprint, error) {
	out := new(Blueprint)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/RejectBlueprint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ListBlueprintRevisions(ctx context.Context, in *ListBlueprintRevisionsRequest, opts ...grpc.CallOption) (*ListBlueprintRevisionsResponse, error) {
	out := new(ListBlueprintRevisionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ListBlueprintRevisions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) SearchBlueprintRevisions(ctx context.Context, in *SearchBlueprintRevisionsRequest, opts ...grpc.CallOption) (*SearchBlueprintRevisionsResponse, error) {
	out := new(SearchBlueprintRevisionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/SearchBlueprintRevisions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) SearchDeploymentRevisions(ctx context.Context, in *SearchDeploymentRevisionsRequest, opts ...grpc.CallOption) (*SearchDeploymentRevisionsResponse, error) {
	out := new(SearchDeploymentRevisionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/SearchDeploymentRevisions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) DiscardBlueprintChanges(ctx context.Context, in *DiscardBlueprintChangesRequest, opts ...grpc.CallOption) (*DiscardBlueprintChangesResponse, error) {
	out := new(DiscardBlueprintChangesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/DiscardBlueprintChanges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ListPublicBlueprints(ctx context.Context, in *ListPublicBlueprintsRequest, opts ...grpc.CallOption) (*ListPublicBlueprintsResponse, error) {
	out := new(ListPublicBlueprintsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ListPublicBlueprints", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) GetPublicBlueprint(ctx context.Context, in *GetPublicBlueprintRequest, opts ...grpc.CallOption) (*PublicBlueprint, error) {
	out := new(PublicBlueprint)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/GetPublicBlueprint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) CreateDeployment(ctx context.Context, in *CreateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/CreateDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) UpdateDeployment(ctx context.Context, in *UpdateDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/UpdateDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/GetDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) RemoveDeployment(ctx context.Context, in *RemoveDeploymentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/RemoveDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error) {
	out := new(ListDeploymentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ListDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ListDeploymentRevisions(ctx context.Context, in *ListDeploymentRevisionsRequest, opts ...grpc.CallOption) (*ListDeploymentRevisionsResponse, error) {
	out := new(ListDeploymentRevisionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ListDeploymentRevisions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) DiscardDeploymentChanges(ctx context.Context, in *DiscardDeploymentChangesRequest, opts ...grpc.CallOption) (*DiscardDeploymentChangesResponse, error) {
	out := new(DiscardDeploymentChangesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/DiscardDeploymentChanges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ApplyDeployment(ctx context.Context, in *ApplyDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ApplyDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ComputeDeploymentStatus(ctx context.Context, in *ComputeDeploymentStatusRequest, opts ...grpc.CallOption) (*ComputeDeploymentStatusResponse, error) {
	out := new(ComputeDeploymentStatusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ComputeDeploymentStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) RollbackDeployment(ctx context.Context, in *RollbackDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/RollbackDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) GetHydratedDeployment(ctx context.Context, in *GetHydratedDeploymentRequest, opts ...grpc.CallOption) (*HydratedDeployment, error) {
	out := new(HydratedDeployment)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/GetHydratedDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ListHydratedDeployments(ctx context.Context, in *ListHydratedDeploymentsRequest, opts ...grpc.CallOption) (*ListHydratedDeploymentsResponse, error) {
	out := new(ListHydratedDeploymentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ListHydratedDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) UpdateHydratedDeployment(ctx context.Context, in *UpdateHydratedDeploymentRequest, opts ...grpc.CallOption) (*HydratedDeployment, error) {
	out := new(HydratedDeployment)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/UpdateHydratedDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *telcoAutomationClient) ApplyHydratedDeployment(ctx context.Context, in *ApplyHydratedDeploymentRequest, opts ...grpc.CallOption) (*HydratedDeployment, error) {
	out := new(HydratedDeployment)
	err := c.cc.Invoke(ctx, "/google.cloud.telcoautomation.v1.TelcoAutomation/ApplyHydratedDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TelcoAutomationServer is the server API for TelcoAutomation service.
type TelcoAutomationServer interface {
	// Lists OrchestrationClusters in a given project and location.
	ListOrchestrationClusters(context.Context, *ListOrchestrationClustersRequest) (*ListOrchestrationClustersResponse, error)
	// Gets details of a single OrchestrationCluster.
	GetOrchestrationCluster(context.Context, *GetOrchestrationClusterRequest) (*OrchestrationCluster, error)
	// Creates a new OrchestrationCluster in a given project and location.
	CreateOrchestrationCluster(context.Context, *CreateOrchestrationClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a single OrchestrationCluster.
	DeleteOrchestrationCluster(context.Context, *DeleteOrchestrationClusterRequest) (*longrunningpb.Operation, error)
	// Lists EdgeSlms in a given project and location.
	ListEdgeSlms(context.Context, *ListEdgeSlmsRequest) (*ListEdgeSlmsResponse, error)
	// Gets details of a single EdgeSlm.
	GetEdgeSlm(context.Context, *GetEdgeSlmRequest) (*EdgeSlm, error)
	// Creates a new EdgeSlm in a given project and location.
	CreateEdgeSlm(context.Context, *CreateEdgeSlmRequest) (*longrunningpb.Operation, error)
	// Deletes a single EdgeSlm.
	DeleteEdgeSlm(context.Context, *DeleteEdgeSlmRequest) (*longrunningpb.Operation, error)
	// Creates a blueprint.
	CreateBlueprint(context.Context, *CreateBlueprintRequest) (*Blueprint, error)
	// Updates a blueprint.
	UpdateBlueprint(context.Context, *UpdateBlueprintRequest) (*Blueprint, error)
	// Returns the requested blueprint.
	GetBlueprint(context.Context, *GetBlueprintRequest) (*Blueprint, error)
	// Deletes a blueprint and all its revisions.
	DeleteBlueprint(context.Context, *DeleteBlueprintRequest) (*emptypb.Empty, error)
	// List all blueprints.
	ListBlueprints(context.Context, *ListBlueprintsRequest) (*ListBlueprintsResponse, error)
	// Approves a blueprint and commits a new revision.
	ApproveBlueprint(context.Context, *ApproveBlueprintRequest) (*Blueprint, error)
	// Proposes a blueprint for approval of changes.
	ProposeBlueprint(context.Context, *ProposeBlueprintRequest) (*Blueprint, error)
	// Rejects a blueprint revision proposal and flips it back to Draft state.
	RejectBlueprint(context.Context, *RejectBlueprintRequest) (*Blueprint, error)
	// List blueprint revisions of a given blueprint.
	ListBlueprintRevisions(context.Context, *ListBlueprintRevisionsRequest) (*ListBlueprintRevisionsResponse, error)
	// Searches across blueprint revisions.
	SearchBlueprintRevisions(context.Context, *SearchBlueprintRevisionsRequest) (*SearchBlueprintRevisionsResponse, error)
	// Searches across deployment revisions.
	SearchDeploymentRevisions(context.Context, *SearchDeploymentRevisionsRequest) (*SearchDeploymentRevisionsResponse, error)
	// Discards the changes in a blueprint and reverts the blueprint to the last
	// approved blueprint revision. No changes take place if a blueprint does not
	// have revisions.
	DiscardBlueprintChanges(context.Context, *DiscardBlueprintChangesRequest) (*DiscardBlueprintChangesResponse, error)
	// Lists the blueprints in TNA's public catalog. Default page size = 20,
	// Max Page Size = 100.
	ListPublicBlueprints(context.Context, *ListPublicBlueprintsRequest) (*ListPublicBlueprintsResponse, error)
	// Returns the requested public blueprint.
	GetPublicBlueprint(context.Context, *GetPublicBlueprintRequest) (*PublicBlueprint, error)
	// Creates a deployment.
	CreateDeployment(context.Context, *CreateDeploymentRequest) (*Deployment, error)
	// Updates a deployment.
	UpdateDeployment(context.Context, *UpdateDeploymentRequest) (*Deployment, error)
	// Returns the requested deployment.
	GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error)
	// Removes the deployment by marking it as DELETING. Post which deployment and
	// it's revisions gets deleted.
	RemoveDeployment(context.Context, *RemoveDeploymentRequest) (*emptypb.Empty, error)
	// List all deployments.
	ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error)
	// List deployment revisions of a given deployment.
	ListDeploymentRevisions(context.Context, *ListDeploymentRevisionsRequest) (*ListDeploymentRevisionsResponse, error)
	// Discards the changes in a deployment and reverts the deployment to the last
	// approved deployment revision. No changes take place if a deployment does
	// not have revisions.
	DiscardDeploymentChanges(context.Context, *DiscardDeploymentChangesRequest) (*DiscardDeploymentChangesResponse, error)
	// Applies the deployment's YAML files to the parent orchestration cluster.
	ApplyDeployment(context.Context, *ApplyDeploymentRequest) (*Deployment, error)
	// Returns the requested deployment status.
	ComputeDeploymentStatus(context.Context, *ComputeDeploymentStatusRequest) (*ComputeDeploymentStatusResponse, error)
	// Rollback the active deployment to the given past approved deployment
	// revision.
	RollbackDeployment(context.Context, *RollbackDeploymentRequest) (*Deployment, error)
	// Returns the requested hydrated deployment.
	GetHydratedDeployment(context.Context, *GetHydratedDeploymentRequest) (*HydratedDeployment, error)
	// List all hydrated deployments present under a deployment.
	ListHydratedDeployments(context.Context, *ListHydratedDeploymentsRequest) (*ListHydratedDeploymentsResponse, error)
	// Updates a hydrated deployment.
	UpdateHydratedDeployment(context.Context, *UpdateHydratedDeploymentRequest) (*HydratedDeployment, error)
	// Applies a hydrated deployment to a workload cluster.
	ApplyHydratedDeployment(context.Context, *ApplyHydratedDeploymentRequest) (*HydratedDeployment, error)
}

// UnimplementedTelcoAutomationServer can be embedded to have forward compatible implementations.
type UnimplementedTelcoAutomationServer struct {
}

func (*UnimplementedTelcoAutomationServer) ListOrchestrationClusters(context.Context, *ListOrchestrationClustersRequest) (*ListOrchestrationClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOrchestrationClusters not implemented")
}
func (*UnimplementedTelcoAutomationServer) GetOrchestrationCluster(context.Context, *GetOrchestrationClusterRequest) (*OrchestrationCluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrchestrationCluster not implemented")
}
func (*UnimplementedTelcoAutomationServer) CreateOrchestrationCluster(context.Context, *CreateOrchestrationClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateOrchestrationCluster not implemented")
}
func (*UnimplementedTelcoAutomationServer) DeleteOrchestrationCluster(context.Context, *DeleteOrchestrationClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteOrchestrationCluster not implemented")
}
func (*UnimplementedTelcoAutomationServer) ListEdgeSlms(context.Context, *ListEdgeSlmsRequest) (*ListEdgeSlmsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEdgeSlms not implemented")
}
func (*UnimplementedTelcoAutomationServer) GetEdgeSlm(context.Context, *GetEdgeSlmRequest) (*EdgeSlm, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEdgeSlm not implemented")
}
func (*UnimplementedTelcoAutomationServer) CreateEdgeSlm(context.Context, *CreateEdgeSlmRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEdgeSlm not implemented")
}
func (*UnimplementedTelcoAutomationServer) DeleteEdgeSlm(context.Context, *DeleteEdgeSlmRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEdgeSlm not implemented")
}
func (*UnimplementedTelcoAutomationServer) CreateBlueprint(context.Context, *CreateBlueprintRequest) (*Blueprint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBlueprint not implemented")
}
func (*UnimplementedTelcoAutomationServer) UpdateBlueprint(context.Context, *UpdateBlueprintRequest) (*Blueprint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBlueprint not implemented")
}
func (*UnimplementedTelcoAutomationServer) GetBlueprint(context.Context, *GetBlueprintRequest) (*Blueprint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBlueprint not implemented")
}
func (*UnimplementedTelcoAutomationServer) DeleteBlueprint(context.Context, *DeleteBlueprintRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBlueprint not implemented")
}
func (*UnimplementedTelcoAutomationServer) ListBlueprints(context.Context, *ListBlueprintsRequest) (*ListBlueprintsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBlueprints not implemented")
}
func (*UnimplementedTelcoAutomationServer) ApproveBlueprint(context.Context, *ApproveBlueprintRequest) (*Blueprint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApproveBlueprint not implemented")
}
func (*UnimplementedTelcoAutomationServer) ProposeBlueprint(context.Context, *ProposeBlueprintRequest) (*Blueprint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ProposeBlueprint not implemented")
}
func (*UnimplementedTelcoAutomationServer) RejectBlueprint(context.Context, *RejectBlueprintRequest) (*Blueprint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RejectBlueprint not implemented")
}
func (*UnimplementedTelcoAutomationServer) ListBlueprintRevisions(context.Context, *ListBlueprintRevisionsRequest) (*ListBlueprintRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBlueprintRevisions not implemented")
}
func (*UnimplementedTelcoAutomationServer) SearchBlueprintRevisions(context.Context, *SearchBlueprintRevisionsRequest) (*SearchBlueprintRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchBlueprintRevisions not implemented")
}
func (*UnimplementedTelcoAutomationServer) SearchDeploymentRevisions(context.Context, *SearchDeploymentRevisionsRequest) (*SearchDeploymentRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchDeploymentRevisions not implemented")
}
func (*UnimplementedTelcoAutomationServer) DiscardBlueprintChanges(context.Context, *DiscardBlueprintChangesRequest) (*DiscardBlueprintChangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiscardBlueprintChanges not implemented")
}
func (*UnimplementedTelcoAutomationServer) ListPublicBlueprints(context.Context, *ListPublicBlueprintsRequest) (*ListPublicBlueprintsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPublicBlueprints not implemented")
}
func (*UnimplementedTelcoAutomationServer) GetPublicBlueprint(context.Context, *GetPublicBlueprintRequest) (*PublicBlueprint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPublicBlueprint not implemented")
}
func (*UnimplementedTelcoAutomationServer) CreateDeployment(context.Context, *CreateDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDeployment not implemented")
}
func (*UnimplementedTelcoAutomationServer) UpdateDeployment(context.Context, *UpdateDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDeployment not implemented")
}
func (*UnimplementedTelcoAutomationServer) GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDeployment not implemented")
}
func (*UnimplementedTelcoAutomationServer) RemoveDeployment(context.Context, *RemoveDeploymentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveDeployment not implemented")
}
func (*UnimplementedTelcoAutomationServer) ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeployments not implemented")
}
func (*UnimplementedTelcoAutomationServer) ListDeploymentRevisions(context.Context, *ListDeploymentRevisionsRequest) (*ListDeploymentRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDeploymentRevisions not implemented")
}
func (*UnimplementedTelcoAutomationServer) DiscardDeploymentChanges(context.Context, *DiscardDeploymentChangesRequest) (*DiscardDeploymentChangesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiscardDeploymentChanges not implemented")
}
func (*UnimplementedTelcoAutomationServer) ApplyDeployment(context.Context, *ApplyDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyDeployment not implemented")
}
func (*UnimplementedTelcoAutomationServer) ComputeDeploymentStatus(context.Context, *ComputeDeploymentStatusRequest) (*ComputeDeploymentStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeDeploymentStatus not implemented")
}
func (*UnimplementedTelcoAutomationServer) RollbackDeployment(context.Context, *RollbackDeploymentRequest) (*Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RollbackDeployment not implemented")
}
func (*UnimplementedTelcoAutomationServer) GetHydratedDeployment(context.Context, *GetHydratedDeploymentRequest) (*HydratedDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHydratedDeployment not implemented")
}
func (*UnimplementedTelcoAutomationServer) ListHydratedDeployments(context.Context, *ListHydratedDeploymentsRequest) (*ListHydratedDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHydratedDeployments not implemented")
}
func (*UnimplementedTelcoAutomationServer) UpdateHydratedDeployment(context.Context, *UpdateHydratedDeploymentRequest) (*HydratedDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHydratedDeployment not implemented")
}
func (*UnimplementedTelcoAutomationServer) ApplyHydratedDeployment(context.Context, *ApplyHydratedDeploymentRequest) (*HydratedDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyHydratedDeployment not implemented")
}

func RegisterTelcoAutomationServer(s *grpc.Server, srv TelcoAutomationServer) {
	s.RegisterService(&_TelcoAutomation_serviceDesc, srv)
}

func _TelcoAutomation_ListOrchestrationClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOrchestrationClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ListOrchestrationClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ListOrchestrationClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ListOrchestrationClusters(ctx, req.(*ListOrchestrationClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_GetOrchestrationCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrchestrationClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).GetOrchestrationCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/GetOrchestrationCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).GetOrchestrationCluster(ctx, req.(*GetOrchestrationClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_CreateOrchestrationCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateOrchestrationClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).CreateOrchestrationCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/CreateOrchestrationCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).CreateOrchestrationCluster(ctx, req.(*CreateOrchestrationClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_DeleteOrchestrationCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOrchestrationClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).DeleteOrchestrationCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/DeleteOrchestrationCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).DeleteOrchestrationCluster(ctx, req.(*DeleteOrchestrationClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ListEdgeSlms_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEdgeSlmsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ListEdgeSlms(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ListEdgeSlms",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ListEdgeSlms(ctx, req.(*ListEdgeSlmsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_GetEdgeSlm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEdgeSlmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).GetEdgeSlm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/GetEdgeSlm",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).GetEdgeSlm(ctx, req.(*GetEdgeSlmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_CreateEdgeSlm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEdgeSlmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).CreateEdgeSlm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/CreateEdgeSlm",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).CreateEdgeSlm(ctx, req.(*CreateEdgeSlmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_DeleteEdgeSlm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEdgeSlmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).DeleteEdgeSlm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/DeleteEdgeSlm",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).DeleteEdgeSlm(ctx, req.(*DeleteEdgeSlmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_CreateBlueprint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBlueprintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).CreateBlueprint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/CreateBlueprint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).CreateBlueprint(ctx, req.(*CreateBlueprintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_UpdateBlueprint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBlueprintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).UpdateBlueprint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/UpdateBlueprint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).UpdateBlueprint(ctx, req.(*UpdateBlueprintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_GetBlueprint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBlueprintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).GetBlueprint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/GetBlueprint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).GetBlueprint(ctx, req.(*GetBlueprintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_DeleteBlueprint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBlueprintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).DeleteBlueprint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/DeleteBlueprint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).DeleteBlueprint(ctx, req.(*DeleteBlueprintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ListBlueprints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBlueprintsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ListBlueprints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ListBlueprints",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ListBlueprints(ctx, req.(*ListBlueprintsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ApproveBlueprint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveBlueprintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ApproveBlueprint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ApproveBlueprint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ApproveBlueprint(ctx, req.(*ApproveBlueprintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ProposeBlueprint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProposeBlueprintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ProposeBlueprint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ProposeBlueprint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ProposeBlueprint(ctx, req.(*ProposeBlueprintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_RejectBlueprint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RejectBlueprintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).RejectBlueprint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/RejectBlueprint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).RejectBlueprint(ctx, req.(*RejectBlueprintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ListBlueprintRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBlueprintRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ListBlueprintRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ListBlueprintRevisions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ListBlueprintRevisions(ctx, req.(*ListBlueprintRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_SearchBlueprintRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchBlueprintRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).SearchBlueprintRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/SearchBlueprintRevisions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).SearchBlueprintRevisions(ctx, req.(*SearchBlueprintRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_SearchDeploymentRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchDeploymentRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).SearchDeploymentRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/SearchDeploymentRevisions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).SearchDeploymentRevisions(ctx, req.(*SearchDeploymentRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_DiscardBlueprintChanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiscardBlueprintChangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).DiscardBlueprintChanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/DiscardBlueprintChanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).DiscardBlueprintChanges(ctx, req.(*DiscardBlueprintChangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ListPublicBlueprints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPublicBlueprintsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ListPublicBlueprints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ListPublicBlueprints",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ListPublicBlueprints(ctx, req.(*ListPublicBlueprintsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_GetPublicBlueprint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPublicBlueprintRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).GetPublicBlueprint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/GetPublicBlueprint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).GetPublicBlueprint(ctx, req.(*GetPublicBlueprintRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_CreateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).CreateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/CreateDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).CreateDeployment(ctx, req.(*CreateDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_UpdateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).UpdateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/UpdateDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).UpdateDeployment(ctx, req.(*UpdateDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_GetDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).GetDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/GetDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).GetDeployment(ctx, req.(*GetDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_RemoveDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).RemoveDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/RemoveDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).RemoveDeployment(ctx, req.(*RemoveDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ListDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeploymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ListDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ListDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ListDeployments(ctx, req.(*ListDeploymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ListDeploymentRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeploymentRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ListDeploymentRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ListDeploymentRevisions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ListDeploymentRevisions(ctx, req.(*ListDeploymentRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_DiscardDeploymentChanges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiscardDeploymentChangesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).DiscardDeploymentChanges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/DiscardDeploymentChanges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).DiscardDeploymentChanges(ctx, req.(*DiscardDeploymentChangesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ApplyDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ApplyDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ApplyDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ApplyDeployment(ctx, req.(*ApplyDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ComputeDeploymentStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeDeploymentStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ComputeDeploymentStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ComputeDeploymentStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ComputeDeploymentStatus(ctx, req.(*ComputeDeploymentStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_RollbackDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).RollbackDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/RollbackDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).RollbackDeployment(ctx, req.(*RollbackDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_GetHydratedDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHydratedDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).GetHydratedDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/GetHydratedDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).GetHydratedDeployment(ctx, req.(*GetHydratedDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ListHydratedDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHydratedDeploymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ListHydratedDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ListHydratedDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ListHydratedDeployments(ctx, req.(*ListHydratedDeploymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_UpdateHydratedDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHydratedDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).UpdateHydratedDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/UpdateHydratedDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).UpdateHydratedDeployment(ctx, req.(*UpdateHydratedDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TelcoAutomation_ApplyHydratedDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyHydratedDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TelcoAutomationServer).ApplyHydratedDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.telcoautomation.v1.TelcoAutomation/ApplyHydratedDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TelcoAutomationServer).ApplyHydratedDeployment(ctx, req.(*ApplyHydratedDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TelcoAutomation_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.telcoautomation.v1.TelcoAutomation",
	HandlerType: (*TelcoAutomationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListOrchestrationClusters",
			Handler:    _TelcoAutomation_ListOrchestrationClusters_Handler,
		},
		{
			MethodName: "GetOrchestrationCluster",
			Handler:    _TelcoAutomation_GetOrchestrationCluster_Handler,
		},
		{
			MethodName: "CreateOrchestrationCluster",
			Handler:    _TelcoAutomation_CreateOrchestrationCluster_Handler,
		},
		{
			MethodName: "DeleteOrchestrationCluster",
			Handler:    _TelcoAutomation_DeleteOrchestrationCluster_Handler,
		},
		{
			MethodName: "ListEdgeSlms",
			Handler:    _TelcoAutomation_ListEdgeSlms_Handler,
		},
		{
			MethodName: "GetEdgeSlm",
			Handler:    _TelcoAutomation_GetEdgeSlm_Handler,
		},
		{
			MethodName: "CreateEdgeSlm",
			Handler:    _TelcoAutomation_CreateEdgeSlm_Handler,
		},
		{
			MethodName: "DeleteEdgeSlm",
			Handler:    _TelcoAutomation_DeleteEdgeSlm_Handler,
		},
		{
			MethodName: "CreateBlueprint",
			Handler:    _TelcoAutomation_CreateBlueprint_Handler,
		},
		{
			MethodName: "UpdateBlueprint",
			Handler:    _TelcoAutomation_UpdateBlueprint_Handler,
		},
		{
			MethodName: "GetBlueprint",
			Handler:    _TelcoAutomation_GetBlueprint_Handler,
		},
		{
			MethodName: "DeleteBlueprint",
			Handler:    _TelcoAutomation_DeleteBlueprint_Handler,
		},
		{
			MethodName: "ListBlueprints",
			Handler:    _TelcoAutomation_ListBlueprints_Handler,
		},
		{
			MethodName: "ApproveBlueprint",
			Handler:    _TelcoAutomation_ApproveBlueprint_Handler,
		},
		{
			MethodName: "ProposeBlueprint",
			Handler:    _TelcoAutomation_ProposeBlueprint_Handler,
		},
		{
			MethodName: "RejectBlueprint",
			Handler:    _TelcoAutomation_RejectBlueprint_Handler,
		},
		{
			MethodName: "ListBlueprintRevisions",
			Handler:    _TelcoAutomation_ListBlueprintRevisions_Handler,
		},
		{
			MethodName: "SearchBlueprintRevisions",
			Handler:    _TelcoAutomation_SearchBlueprintRevisions_Handler,
		},
		{
			MethodName: "SearchDeploymentRevisions",
			Handler:    _TelcoAutomation_SearchDeploymentRevisions_Handler,
		},
		{
			MethodName: "DiscardBlueprintChanges",
			Handler:    _TelcoAutomation_DiscardBlueprintChanges_Handler,
		},
		{
			MethodName: "ListPublicBlueprints",
			Handler:    _TelcoAutomation_ListPublicBlueprints_Handler,
		},
		{
			MethodName: "GetPublicBlueprint",
			Handler:    _TelcoAutomation_GetPublicBlueprint_Handler,
		},
		{
			MethodName: "CreateDeployment",
			Handler:    _TelcoAutomation_CreateDeployment_Handler,
		},
		{
			MethodName: "UpdateDeployment",
			Handler:    _TelcoAutomation_UpdateDeployment_Handler,
		},
		{
			MethodName: "GetDeployment",
			Handler:    _TelcoAutomation_GetDeployment_Handler,
		},
		{
			MethodName: "RemoveDeployment",
			Handler:    _TelcoAutomation_RemoveDeployment_Handler,
		},
		{
			MethodName: "ListDeployments",
			Handler:    _TelcoAutomation_ListDeployments_Handler,
		},
		{
			MethodName: "ListDeploymentRevisions",
			Handler:    _TelcoAutomation_ListDeploymentRevisions_Handler,
		},
		{
			MethodName: "DiscardDeploymentChanges",
			Handler:    _TelcoAutomation_DiscardDeploymentChanges_Handler,
		},
		{
			MethodName: "ApplyDeployment",
			Handler:    _TelcoAutomation_ApplyDeployment_Handler,
		},
		{
			MethodName: "ComputeDeploymentStatus",
			Handler:    _TelcoAutomation_ComputeDeploymentStatus_Handler,
		},
		{
			MethodName: "RollbackDeployment",
			Handler:    _TelcoAutomation_RollbackDeployment_Handler,
		},
		{
			MethodName: "GetHydratedDeployment",
			Handler:    _TelcoAutomation_GetHydratedDeployment_Handler,
		},
		{
			MethodName: "ListHydratedDeployments",
			Handler:    _TelcoAutomation_ListHydratedDeployments_Handler,
		},
		{
			MethodName: "UpdateHydratedDeployment",
			Handler:    _TelcoAutomation_UpdateHydratedDeployment_Handler,
		},
		{
			MethodName: "ApplyHydratedDeployment",
			Handler:    _TelcoAutomation_ApplyHydratedDeployment_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/telcoautomation/v1/telcoautomation.proto",
}
