// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package vmmigration

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	vmmigrationpb "cloud.google.com/go/vmmigration/apiv1/vmmigrationpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListSources               []gax.CallOption
	GetSource                 []gax.CallOption
	CreateSource              []gax.CallOption
	UpdateSource              []gax.CallOption
	DeleteSource              []gax.CallOption
	FetchInventory            []gax.CallOption
	ListUtilizationReports    []gax.CallOption
	GetUtilizationReport      []gax.CallOption
	CreateUtilizationReport   []gax.CallOption
	DeleteUtilizationReport   []gax.CallOption
	ListDatacenterConnectors  []gax.CallOption
	GetDatacenterConnector    []gax.CallOption
	CreateDatacenterConnector []gax.CallOption
	DeleteDatacenterConnector []gax.CallOption
	UpgradeAppliance          []gax.CallOption
	CreateMigratingVm         []gax.CallOption
	ListMigratingVms          []gax.CallOption
	GetMigratingVm            []gax.CallOption
	UpdateMigratingVm         []gax.CallOption
	DeleteMigratingVm         []gax.CallOption
	StartMigration            []gax.CallOption
	ResumeMigration           []gax.CallOption
	PauseMigration            []gax.CallOption
	FinalizeMigration         []gax.CallOption
	CreateCloneJob            []gax.CallOption
	CancelCloneJob            []gax.CallOption
	ListCloneJobs             []gax.CallOption
	GetCloneJob               []gax.CallOption
	CreateCutoverJob          []gax.CallOption
	CancelCutoverJob          []gax.CallOption
	ListCutoverJobs           []gax.CallOption
	GetCutoverJob             []gax.CallOption
	ListGroups                []gax.CallOption
	GetGroup                  []gax.CallOption
	CreateGroup               []gax.CallOption
	UpdateGroup               []gax.CallOption
	DeleteGroup               []gax.CallOption
	AddGroupMigration         []gax.CallOption
	RemoveGroupMigration      []gax.CallOption
	ListTargetProjects        []gax.CallOption
	GetTargetProject          []gax.CallOption
	CreateTargetProject       []gax.CallOption
	UpdateTargetProject       []gax.CallOption
	DeleteTargetProject       []gax.CallOption
	ListReplicationCycles     []gax.CallOption
	GetReplicationCycle       []gax.CallOption
	GetLocation               []gax.CallOption
	ListLocations             []gax.CallOption
	CancelOperation           []gax.CallOption
	DeleteOperation           []gax.CallOption
	GetOperation              []gax.CallOption
	ListOperations            []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("vmmigration.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("vmmigration.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("vmmigration.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://vmmigration.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListSources: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateSource: []gax.CallOption{
			gax.WithTimeout(900000 * time.Millisecond),
		},
		UpdateSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		FetchInventory: []gax.CallOption{
			gax.WithTimeout(300000 * time.Millisecond),
		},
		ListUtilizationReports: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetUtilizationReport: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateUtilizationReport: []gax.CallOption{
			gax.WithTimeout(300000 * time.Millisecond),
		},
		DeleteUtilizationReport: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListDatacenterConnectors: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetDatacenterConnector: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateDatacenterConnector: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteDatacenterConnector: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpgradeAppliance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateMigratingVm: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListMigratingVms: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetMigratingVm: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateMigratingVm: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteMigratingVm: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StartMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResumeMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		PauseMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		FinalizeMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateCloneJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CancelCloneJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListCloneJobs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetCloneJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateCutoverJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CancelCutoverJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListCutoverJobs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetCutoverJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListGroups: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		AddGroupMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RemoveGroupMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListTargetProjects: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetTargetProject: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateTargetProject: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateTargetProject: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteTargetProject: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListReplicationCycles: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetReplicationCycle: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:     []gax.CallOption{},
		ListLocations:   []gax.CallOption{},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		ListSources: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateSource: []gax.CallOption{
			gax.WithTimeout(900000 * time.Millisecond),
		},
		UpdateSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteSource: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		FetchInventory: []gax.CallOption{
			gax.WithTimeout(300000 * time.Millisecond),
		},
		ListUtilizationReports: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetUtilizationReport: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateUtilizationReport: []gax.CallOption{
			gax.WithTimeout(300000 * time.Millisecond),
		},
		DeleteUtilizationReport: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListDatacenterConnectors: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetDatacenterConnector: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateDatacenterConnector: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteDatacenterConnector: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpgradeAppliance: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateMigratingVm: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListMigratingVms: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetMigratingVm: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateMigratingVm: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteMigratingVm: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StartMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResumeMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		PauseMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		FinalizeMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateCloneJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CancelCloneJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListCloneJobs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetCloneJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateCutoverJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CancelCutoverJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListCutoverJobs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetCutoverJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListGroups: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteGroup: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		AddGroupMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RemoveGroupMigration: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListTargetProjects: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetTargetProject: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateTargetProject: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateTargetProject: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteTargetProject: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListReplicationCycles: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetReplicationCycle: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:     []gax.CallOption{},
		ListLocations:   []gax.CallOption{},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from VM Migration API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListSources(context.Context, *vmmigrationpb.ListSourcesRequest, ...gax.CallOption) *SourceIterator
	GetSource(context.Context, *vmmigrationpb.GetSourceRequest, ...gax.CallOption) (*vmmigrationpb.Source, error)
	CreateSource(context.Context, *vmmigrationpb.CreateSourceRequest, ...gax.CallOption) (*CreateSourceOperation, error)
	CreateSourceOperation(name string) *CreateSourceOperation
	UpdateSource(context.Context, *vmmigrationpb.UpdateSourceRequest, ...gax.CallOption) (*UpdateSourceOperation, error)
	UpdateSourceOperation(name string) *UpdateSourceOperation
	DeleteSource(context.Context, *vmmigrationpb.DeleteSourceRequest, ...gax.CallOption) (*DeleteSourceOperation, error)
	DeleteSourceOperation(name string) *DeleteSourceOperation
	FetchInventory(context.Context, *vmmigrationpb.FetchInventoryRequest, ...gax.CallOption) (*vmmigrationpb.FetchInventoryResponse, error)
	ListUtilizationReports(context.Context, *vmmigrationpb.ListUtilizationReportsRequest, ...gax.CallOption) *UtilizationReportIterator
	GetUtilizationReport(context.Context, *vmmigrationpb.GetUtilizationReportRequest, ...gax.CallOption) (*vmmigrationpb.UtilizationReport, error)
	CreateUtilizationReport(context.Context, *vmmigrationpb.CreateUtilizationReportRequest, ...gax.CallOption) (*CreateUtilizationReportOperation, error)
	CreateUtilizationReportOperation(name string) *CreateUtilizationReportOperation
	DeleteUtilizationReport(context.Context, *vmmigrationpb.DeleteUtilizationReportRequest, ...gax.CallOption) (*DeleteUtilizationReportOperation, error)
	DeleteUtilizationReportOperation(name string) *DeleteUtilizationReportOperation
	ListDatacenterConnectors(context.Context, *vmmigrationpb.ListDatacenterConnectorsRequest, ...gax.CallOption) *DatacenterConnectorIterator
	GetDatacenterConnector(context.Context, *vmmigrationpb.GetDatacenterConnectorRequest, ...gax.CallOption) (*vmmigrationpb.DatacenterConnector, error)
	CreateDatacenterConnector(context.Context, *vmmigrationpb.CreateDatacenterConnectorRequest, ...gax.CallOption) (*CreateDatacenterConnectorOperation, error)
	CreateDatacenterConnectorOperation(name string) *CreateDatacenterConnectorOperation
	DeleteDatacenterConnector(context.Context, *vmmigrationpb.DeleteDatacenterConnectorRequest, ...gax.CallOption) (*DeleteDatacenterConnectorOperation, error)
	DeleteDatacenterConnectorOperation(name string) *DeleteDatacenterConnectorOperation
	UpgradeAppliance(context.Context, *vmmigrationpb.UpgradeApplianceRequest, ...gax.CallOption) (*UpgradeApplianceOperation, error)
	UpgradeApplianceOperation(name string) *UpgradeApplianceOperation
	CreateMigratingVm(context.Context, *vmmigrationpb.CreateMigratingVmRequest, ...gax.CallOption) (*CreateMigratingVmOperation, error)
	CreateMigratingVmOperation(name string) *CreateMigratingVmOperation
	ListMigratingVms(context.Context, *vmmigrationpb.ListMigratingVmsRequest, ...gax.CallOption) *MigratingVmIterator
	GetMigratingVm(context.Context, *vmmigrationpb.GetMigratingVmRequest, ...gax.CallOption) (*vmmigrationpb.MigratingVm, error)
	UpdateMigratingVm(context.Context, *vmmigrationpb.UpdateMigratingVmRequest, ...gax.CallOption) (*UpdateMigratingVmOperation, error)
	UpdateMigratingVmOperation(name string) *UpdateMigratingVmOperation
	DeleteMigratingVm(context.Context, *vmmigrationpb.DeleteMigratingVmRequest, ...gax.CallOption) (*DeleteMigratingVmOperation, error)
	DeleteMigratingVmOperation(name string) *DeleteMigratingVmOperation
	StartMigration(context.Context, *vmmigrationpb.StartMigrationRequest, ...gax.CallOption) (*StartMigrationOperation, error)
	StartMigrationOperation(name string) *StartMigrationOperation
	ResumeMigration(context.Context, *vmmigrationpb.ResumeMigrationRequest, ...gax.CallOption) (*ResumeMigrationOperation, error)
	ResumeMigrationOperation(name string) *ResumeMigrationOperation
	PauseMigration(context.Context, *vmmigrationpb.PauseMigrationRequest, ...gax.CallOption) (*PauseMigrationOperation, error)
	PauseMigrationOperation(name string) *PauseMigrationOperation
	FinalizeMigration(context.Context, *vmmigrationpb.FinalizeMigrationRequest, ...gax.CallOption) (*FinalizeMigrationOperation, error)
	FinalizeMigrationOperation(name string) *FinalizeMigrationOperation
	CreateCloneJob(context.Context, *vmmigrationpb.CreateCloneJobRequest, ...gax.CallOption) (*CreateCloneJobOperation, error)
	CreateCloneJobOperation(name string) *CreateCloneJobOperation
	CancelCloneJob(context.Context, *vmmigrationpb.CancelCloneJobRequest, ...gax.CallOption) (*CancelCloneJobOperation, error)
	CancelCloneJobOperation(name string) *CancelCloneJobOperation
	ListCloneJobs(context.Context, *vmmigrationpb.ListCloneJobsRequest, ...gax.CallOption) *CloneJobIterator
	GetCloneJob(context.Context, *vmmigrationpb.GetCloneJobRequest, ...gax.CallOption) (*vmmigrationpb.CloneJob, error)
	CreateCutoverJob(context.Context, *vmmigrationpb.CreateCutoverJobRequest, ...gax.CallOption) (*CreateCutoverJobOperation, error)
	CreateCutoverJobOperation(name string) *CreateCutoverJobOperation
	CancelCutoverJob(context.Context, *vmmigrationpb.CancelCutoverJobRequest, ...gax.CallOption) (*CancelCutoverJobOperation, error)
	CancelCutoverJobOperation(name string) *CancelCutoverJobOperation
	ListCutoverJobs(context.Context, *vmmigrationpb.ListCutoverJobsRequest, ...gax.CallOption) *CutoverJobIterator
	GetCutoverJob(context.Context, *vmmigrationpb.GetCutoverJobRequest, ...gax.CallOption) (*vmmigrationpb.CutoverJob, error)
	ListGroups(context.Context, *vmmigrationpb.ListGroupsRequest, ...gax.CallOption) *GroupIterator
	GetGroup(context.Context, *vmmigrationpb.GetGroupRequest, ...gax.CallOption) (*vmmigrationpb.Group, error)
	CreateGroup(context.Context, *vmmigrationpb.CreateGroupRequest, ...gax.CallOption) (*CreateGroupOperation, error)
	CreateGroupOperation(name string) *CreateGroupOperation
	UpdateGroup(context.Context, *vmmigrationpb.UpdateGroupRequest, ...gax.CallOption) (*UpdateGroupOperation, error)
	UpdateGroupOperation(name string) *UpdateGroupOperation
	DeleteGroup(context.Context, *vmmigrationpb.DeleteGroupRequest, ...gax.CallOption) (*DeleteGroupOperation, error)
	DeleteGroupOperation(name string) *DeleteGroupOperation
	AddGroupMigration(context.Context, *vmmigrationpb.AddGroupMigrationRequest, ...gax.CallOption) (*AddGroupMigrationOperation, error)
	AddGroupMigrationOperation(name string) *AddGroupMigrationOperation
	RemoveGroupMigration(context.Context, *vmmigrationpb.RemoveGroupMigrationRequest, ...gax.CallOption) (*RemoveGroupMigrationOperation, error)
	RemoveGroupMigrationOperation(name string) *RemoveGroupMigrationOperation
	ListTargetProjects(context.Context, *vmmigrationpb.ListTargetProjectsRequest, ...gax.CallOption) *TargetProjectIterator
	GetTargetProject(context.Context, *vmmigrationpb.GetTargetProjectRequest, ...gax.CallOption) (*vmmigrationpb.TargetProject, error)
	CreateTargetProject(context.Context, *vmmigrationpb.CreateTargetProjectRequest, ...gax.CallOption) (*CreateTargetProjectOperation, error)
	CreateTargetProjectOperation(name string) *CreateTargetProjectOperation
	UpdateTargetProject(context.Context, *vmmigrationpb.UpdateTargetProjectRequest, ...gax.CallOption) (*UpdateTargetProjectOperation, error)
	UpdateTargetProjectOperation(name string) *UpdateTargetProjectOperation
	DeleteTargetProject(context.Context, *vmmigrationpb.DeleteTargetProjectRequest, ...gax.CallOption) (*DeleteTargetProjectOperation, error)
	DeleteTargetProjectOperation(name string) *DeleteTargetProjectOperation
	ListReplicationCycles(context.Context, *vmmigrationpb.ListReplicationCyclesRequest, ...gax.CallOption) *ReplicationCycleIterator
	GetReplicationCycle(context.Context, *vmmigrationpb.GetReplicationCycleRequest, ...gax.CallOption) (*vmmigrationpb.ReplicationCycle, error)
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// Client is a client for interacting with VM Migration API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// VM Migration Service
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListSources lists Sources in a given project and location.
func (c *Client) ListSources(ctx context.Context, req *vmmigrationpb.ListSourcesRequest, opts ...gax.CallOption) *SourceIterator {
	return c.internalClient.ListSources(ctx, req, opts...)
}

// GetSource gets details of a single Source.
func (c *Client) GetSource(ctx context.Context, req *vmmigrationpb.GetSourceRequest, opts ...gax.CallOption) (*vmmigrationpb.Source, error) {
	return c.internalClient.GetSource(ctx, req, opts...)
}

// CreateSource creates a new Source in a given project and location.
func (c *Client) CreateSource(ctx context.Context, req *vmmigrationpb.CreateSourceRequest, opts ...gax.CallOption) (*CreateSourceOperation, error) {
	return c.internalClient.CreateSource(ctx, req, opts...)
}

// CreateSourceOperation returns a new CreateSourceOperation from a given name.
// The name must be that of a previously created CreateSourceOperation, possibly from a different process.
func (c *Client) CreateSourceOperation(name string) *CreateSourceOperation {
	return c.internalClient.CreateSourceOperation(name)
}

// UpdateSource updates the parameters of a single Source.
func (c *Client) UpdateSource(ctx context.Context, req *vmmigrationpb.UpdateSourceRequest, opts ...gax.CallOption) (*UpdateSourceOperation, error) {
	return c.internalClient.UpdateSource(ctx, req, opts...)
}

// UpdateSourceOperation returns a new UpdateSourceOperation from a given name.
// The name must be that of a previously created UpdateSourceOperation, possibly from a different process.
func (c *Client) UpdateSourceOperation(name string) *UpdateSourceOperation {
	return c.internalClient.UpdateSourceOperation(name)
}

// DeleteSource deletes a single Source.
func (c *Client) DeleteSource(ctx context.Context, req *vmmigrationpb.DeleteSourceRequest, opts ...gax.CallOption) (*DeleteSourceOperation, error) {
	return c.internalClient.DeleteSource(ctx, req, opts...)
}

// DeleteSourceOperation returns a new DeleteSourceOperation from a given name.
// The name must be that of a previously created DeleteSourceOperation, possibly from a different process.
func (c *Client) DeleteSourceOperation(name string) *DeleteSourceOperation {
	return c.internalClient.DeleteSourceOperation(name)
}

// FetchInventory list remote source’s inventory of VMs.
// The remote source is the onprem vCenter (remote in the sense it’s not in
// Compute Engine). The inventory describes the list of existing VMs in that
// source. Note that this operation lists the VMs on the remote source, as
// opposed to listing the MigratingVms resources in the vmmigration service.
func (c *Client) FetchInventory(ctx context.Context, req *vmmigrationpb.FetchInventoryRequest, opts ...gax.CallOption) (*vmmigrationpb.FetchInventoryResponse, error) {
	return c.internalClient.FetchInventory(ctx, req, opts...)
}

// ListUtilizationReports lists Utilization Reports of the given Source.
func (c *Client) ListUtilizationReports(ctx context.Context, req *vmmigrationpb.ListUtilizationReportsRequest, opts ...gax.CallOption) *UtilizationReportIterator {
	return c.internalClient.ListUtilizationReports(ctx, req, opts...)
}

// GetUtilizationReport gets a single Utilization Report.
func (c *Client) GetUtilizationReport(ctx context.Context, req *vmmigrationpb.GetUtilizationReportRequest, opts ...gax.CallOption) (*vmmigrationpb.UtilizationReport, error) {
	return c.internalClient.GetUtilizationReport(ctx, req, opts...)
}

// CreateUtilizationReport creates a new UtilizationReport.
func (c *Client) CreateUtilizationReport(ctx context.Context, req *vmmigrationpb.CreateUtilizationReportRequest, opts ...gax.CallOption) (*CreateUtilizationReportOperation, error) {
	return c.internalClient.CreateUtilizationReport(ctx, req, opts...)
}

// CreateUtilizationReportOperation returns a new CreateUtilizationReportOperation from a given name.
// The name must be that of a previously created CreateUtilizationReportOperation, possibly from a different process.
func (c *Client) CreateUtilizationReportOperation(name string) *CreateUtilizationReportOperation {
	return c.internalClient.CreateUtilizationReportOperation(name)
}

// DeleteUtilizationReport deletes a single Utilization Report.
func (c *Client) DeleteUtilizationReport(ctx context.Context, req *vmmigrationpb.DeleteUtilizationReportRequest, opts ...gax.CallOption) (*DeleteUtilizationReportOperation, error) {
	return c.internalClient.DeleteUtilizationReport(ctx, req, opts...)
}

// DeleteUtilizationReportOperation returns a new DeleteUtilizationReportOperation from a given name.
// The name must be that of a previously created DeleteUtilizationReportOperation, possibly from a different process.
func (c *Client) DeleteUtilizationReportOperation(name string) *DeleteUtilizationReportOperation {
	return c.internalClient.DeleteUtilizationReportOperation(name)
}

// ListDatacenterConnectors lists DatacenterConnectors in a given Source.
func (c *Client) ListDatacenterConnectors(ctx context.Context, req *vmmigrationpb.ListDatacenterConnectorsRequest, opts ...gax.CallOption) *DatacenterConnectorIterator {
	return c.internalClient.ListDatacenterConnectors(ctx, req, opts...)
}

// GetDatacenterConnector gets details of a single DatacenterConnector.
func (c *Client) GetDatacenterConnector(ctx context.Context, req *vmmigrationpb.GetDatacenterConnectorRequest, opts ...gax.CallOption) (*vmmigrationpb.DatacenterConnector, error) {
	return c.internalClient.GetDatacenterConnector(ctx, req, opts...)
}

// CreateDatacenterConnector creates a new DatacenterConnector in a given Source.
func (c *Client) CreateDatacenterConnector(ctx context.Context, req *vmmigrationpb.CreateDatacenterConnectorRequest, opts ...gax.CallOption) (*CreateDatacenterConnectorOperation, error) {
	return c.internalClient.CreateDatacenterConnector(ctx, req, opts...)
}

// CreateDatacenterConnectorOperation returns a new CreateDatacenterConnectorOperation from a given name.
// The name must be that of a previously created CreateDatacenterConnectorOperation, possibly from a different process.
func (c *Client) CreateDatacenterConnectorOperation(name string) *CreateDatacenterConnectorOperation {
	return c.internalClient.CreateDatacenterConnectorOperation(name)
}

// DeleteDatacenterConnector deletes a single DatacenterConnector.
func (c *Client) DeleteDatacenterConnector(ctx context.Context, req *vmmigrationpb.DeleteDatacenterConnectorRequest, opts ...gax.CallOption) (*DeleteDatacenterConnectorOperation, error) {
	return c.internalClient.DeleteDatacenterConnector(ctx, req, opts...)
}

// DeleteDatacenterConnectorOperation returns a new DeleteDatacenterConnectorOperation from a given name.
// The name must be that of a previously created DeleteDatacenterConnectorOperation, possibly from a different process.
func (c *Client) DeleteDatacenterConnectorOperation(name string) *DeleteDatacenterConnectorOperation {
	return c.internalClient.DeleteDatacenterConnectorOperation(name)
}

// UpgradeAppliance upgrades the appliance relate to this DatacenterConnector to the in-place
// updateable version.
func (c *Client) UpgradeAppliance(ctx context.Context, req *vmmigrationpb.UpgradeApplianceRequest, opts ...gax.CallOption) (*UpgradeApplianceOperation, error) {
	return c.internalClient.UpgradeAppliance(ctx, req, opts...)
}

// UpgradeApplianceOperation returns a new UpgradeApplianceOperation from a given name.
// The name must be that of a previously created UpgradeApplianceOperation, possibly from a different process.
func (c *Client) UpgradeApplianceOperation(name string) *UpgradeApplianceOperation {
	return c.internalClient.UpgradeApplianceOperation(name)
}

// CreateMigratingVm creates a new MigratingVm in a given Source.
func (c *Client) CreateMigratingVm(ctx context.Context, req *vmmigrationpb.CreateMigratingVmRequest, opts ...gax.CallOption) (*CreateMigratingVmOperation, error) {
	return c.internalClient.CreateMigratingVm(ctx, req, opts...)
}

// CreateMigratingVmOperation returns a new CreateMigratingVmOperation from a given name.
// The name must be that of a previously created CreateMigratingVmOperation, possibly from a different process.
func (c *Client) CreateMigratingVmOperation(name string) *CreateMigratingVmOperation {
	return c.internalClient.CreateMigratingVmOperation(name)
}

// ListMigratingVms lists MigratingVms in a given Source.
func (c *Client) ListMigratingVms(ctx context.Context, req *vmmigrationpb.ListMigratingVmsRequest, opts ...gax.CallOption) *MigratingVmIterator {
	return c.internalClient.ListMigratingVms(ctx, req, opts...)
}

// GetMigratingVm gets details of a single MigratingVm.
func (c *Client) GetMigratingVm(ctx context.Context, req *vmmigrationpb.GetMigratingVmRequest, opts ...gax.CallOption) (*vmmigrationpb.MigratingVm, error) {
	return c.internalClient.GetMigratingVm(ctx, req, opts...)
}

// UpdateMigratingVm updates the parameters of a single MigratingVm.
func (c *Client) UpdateMigratingVm(ctx context.Context, req *vmmigrationpb.UpdateMigratingVmRequest, opts ...gax.CallOption) (*UpdateMigratingVmOperation, error) {
	return c.internalClient.UpdateMigratingVm(ctx, req, opts...)
}

// UpdateMigratingVmOperation returns a new UpdateMigratingVmOperation from a given name.
// The name must be that of a previously created UpdateMigratingVmOperation, possibly from a different process.
func (c *Client) UpdateMigratingVmOperation(name string) *UpdateMigratingVmOperation {
	return c.internalClient.UpdateMigratingVmOperation(name)
}

// DeleteMigratingVm deletes a single MigratingVm.
func (c *Client) DeleteMigratingVm(ctx context.Context, req *vmmigrationpb.DeleteMigratingVmRequest, opts ...gax.CallOption) (*DeleteMigratingVmOperation, error) {
	return c.internalClient.DeleteMigratingVm(ctx, req, opts...)
}

// DeleteMigratingVmOperation returns a new DeleteMigratingVmOperation from a given name.
// The name must be that of a previously created DeleteMigratingVmOperation, possibly from a different process.
func (c *Client) DeleteMigratingVmOperation(name string) *DeleteMigratingVmOperation {
	return c.internalClient.DeleteMigratingVmOperation(name)
}

// StartMigration starts migration for a VM. Starts the process of uploading
// data and creating snapshots, in replication cycles scheduled by the policy.
func (c *Client) StartMigration(ctx context.Context, req *vmmigrationpb.StartMigrationRequest, opts ...gax.CallOption) (*StartMigrationOperation, error) {
	return c.internalClient.StartMigration(ctx, req, opts...)
}

// StartMigrationOperation returns a new StartMigrationOperation from a given name.
// The name must be that of a previously created StartMigrationOperation, possibly from a different process.
func (c *Client) StartMigrationOperation(name string) *StartMigrationOperation {
	return c.internalClient.StartMigrationOperation(name)
}

// ResumeMigration resumes a migration for a VM. When called on a paused migration, will start
// the process of uploading data and creating snapshots; when called on a
// completed cut-over migration, will update the migration to active state and
// start the process of uploading data and creating snapshots.
func (c *Client) ResumeMigration(ctx context.Context, req *vmmigrationpb.ResumeMigrationRequest, opts ...gax.CallOption) (*ResumeMigrationOperation, error) {
	return c.internalClient.ResumeMigration(ctx, req, opts...)
}

// ResumeMigrationOperation returns a new ResumeMigrationOperation from a given name.
// The name must be that of a previously created ResumeMigrationOperation, possibly from a different process.
func (c *Client) ResumeMigrationOperation(name string) *ResumeMigrationOperation {
	return c.internalClient.ResumeMigrationOperation(name)
}

// PauseMigration pauses a migration for a VM. If cycle tasks are running they will be
// cancelled, preserving source task data. Further replication cycles will not
// be triggered while the VM is paused.
func (c *Client) PauseMigration(ctx context.Context, req *vmmigrationpb.PauseMigrationRequest, opts ...gax.CallOption) (*PauseMigrationOperation, error) {
	return c.internalClient.PauseMigration(ctx, req, opts...)
}

// PauseMigrationOperation returns a new PauseMigrationOperation from a given name.
// The name must be that of a previously created PauseMigrationOperation, possibly from a different process.
func (c *Client) PauseMigrationOperation(name string) *PauseMigrationOperation {
	return c.internalClient.PauseMigrationOperation(name)
}

// FinalizeMigration marks a migration as completed, deleting migration resources that are no
// longer being used. Only applicable after cutover is done.
func (c *Client) FinalizeMigration(ctx context.Context, req *vmmigrationpb.FinalizeMigrationRequest, opts ...gax.CallOption) (*FinalizeMigrationOperation, error) {
	return c.internalClient.FinalizeMigration(ctx, req, opts...)
}

// FinalizeMigrationOperation returns a new FinalizeMigrationOperation from a given name.
// The name must be that of a previously created FinalizeMigrationOperation, possibly from a different process.
func (c *Client) FinalizeMigrationOperation(name string) *FinalizeMigrationOperation {
	return c.internalClient.FinalizeMigrationOperation(name)
}

// CreateCloneJob initiates a Clone of a specific migrating VM.
func (c *Client) CreateCloneJob(ctx context.Context, req *vmmigrationpb.CreateCloneJobRequest, opts ...gax.CallOption) (*CreateCloneJobOperation, error) {
	return c.internalClient.CreateCloneJob(ctx, req, opts...)
}

// CreateCloneJobOperation returns a new CreateCloneJobOperation from a given name.
// The name must be that of a previously created CreateCloneJobOperation, possibly from a different process.
func (c *Client) CreateCloneJobOperation(name string) *CreateCloneJobOperation {
	return c.internalClient.CreateCloneJobOperation(name)
}

// CancelCloneJob initiates the cancellation of a running clone job.
func (c *Client) CancelCloneJob(ctx context.Context, req *vmmigrationpb.CancelCloneJobRequest, opts ...gax.CallOption) (*CancelCloneJobOperation, error) {
	return c.internalClient.CancelCloneJob(ctx, req, opts...)
}

// CancelCloneJobOperation returns a new CancelCloneJobOperation from a given name.
// The name must be that of a previously created CancelCloneJobOperation, possibly from a different process.
func (c *Client) CancelCloneJobOperation(name string) *CancelCloneJobOperation {
	return c.internalClient.CancelCloneJobOperation(name)
}

// ListCloneJobs lists CloneJobs of a given migrating VM.
func (c *Client) ListCloneJobs(ctx context.Context, req *vmmigrationpb.ListCloneJobsRequest, opts ...gax.CallOption) *CloneJobIterator {
	return c.internalClient.ListCloneJobs(ctx, req, opts...)
}

// GetCloneJob gets details of a single CloneJob.
func (c *Client) GetCloneJob(ctx context.Context, req *vmmigrationpb.GetCloneJobRequest, opts ...gax.CallOption) (*vmmigrationpb.CloneJob, error) {
	return c.internalClient.GetCloneJob(ctx, req, opts...)
}

// CreateCutoverJob initiates a Cutover of a specific migrating VM.
// The returned LRO is completed when the cutover job resource is created
// and the job is initiated.
func (c *Client) CreateCutoverJob(ctx context.Context, req *vmmigrationpb.CreateCutoverJobRequest, opts ...gax.CallOption) (*CreateCutoverJobOperation, error) {
	return c.internalClient.CreateCutoverJob(ctx, req, opts...)
}

// CreateCutoverJobOperation returns a new CreateCutoverJobOperation from a given name.
// The name must be that of a previously created CreateCutoverJobOperation, possibly from a different process.
func (c *Client) CreateCutoverJobOperation(name string) *CreateCutoverJobOperation {
	return c.internalClient.CreateCutoverJobOperation(name)
}

// CancelCutoverJob initiates the cancellation of a running cutover job.
func (c *Client) CancelCutoverJob(ctx context.Context, req *vmmigrationpb.CancelCutoverJobRequest, opts ...gax.CallOption) (*CancelCutoverJobOperation, error) {
	return c.internalClient.CancelCutoverJob(ctx, req, opts...)
}

// CancelCutoverJobOperation returns a new CancelCutoverJobOperation from a given name.
// The name must be that of a previously created CancelCutoverJobOperation, possibly from a different process.
func (c *Client) CancelCutoverJobOperation(name string) *CancelCutoverJobOperation {
	return c.internalClient.CancelCutoverJobOperation(name)
}

// ListCutoverJobs lists CutoverJobs of a given migrating VM.
func (c *Client) ListCutoverJobs(ctx context.Context, req *vmmigrationpb.ListCutoverJobsRequest, opts ...gax.CallOption) *CutoverJobIterator {
	return c.internalClient.ListCutoverJobs(ctx, req, opts...)
}

// GetCutoverJob gets details of a single CutoverJob.
func (c *Client) GetCutoverJob(ctx context.Context, req *vmmigrationpb.GetCutoverJobRequest, opts ...gax.CallOption) (*vmmigrationpb.CutoverJob, error) {
	return c.internalClient.GetCutoverJob(ctx, req, opts...)
}

// ListGroups lists Groups in a given project and location.
func (c *Client) ListGroups(ctx context.Context, req *vmmigrationpb.ListGroupsRequest, opts ...gax.CallOption) *GroupIterator {
	return c.internalClient.ListGroups(ctx, req, opts...)
}

// GetGroup gets details of a single Group.
func (c *Client) GetGroup(ctx context.Context, req *vmmigrationpb.GetGroupRequest, opts ...gax.CallOption) (*vmmigrationpb.Group, error) {
	return c.internalClient.GetGroup(ctx, req, opts...)
}

// CreateGroup creates a new Group in a given project and location.
func (c *Client) CreateGroup(ctx context.Context, req *vmmigrationpb.CreateGroupRequest, opts ...gax.CallOption) (*CreateGroupOperation, error) {
	return c.internalClient.CreateGroup(ctx, req, opts...)
}

// CreateGroupOperation returns a new CreateGroupOperation from a given name.
// The name must be that of a previously created CreateGroupOperation, possibly from a different process.
func (c *Client) CreateGroupOperation(name string) *CreateGroupOperation {
	return c.internalClient.CreateGroupOperation(name)
}

// UpdateGroup updates the parameters of a single Group.
func (c *Client) UpdateGroup(ctx context.Context, req *vmmigrationpb.UpdateGroupRequest, opts ...gax.CallOption) (*UpdateGroupOperation, error) {
	return c.internalClient.UpdateGroup(ctx, req, opts...)
}

// UpdateGroupOperation returns a new UpdateGroupOperation from a given name.
// The name must be that of a previously created UpdateGroupOperation, possibly from a different process.
func (c *Client) UpdateGroupOperation(name string) *UpdateGroupOperation {
	return c.internalClient.UpdateGroupOperation(name)
}

// DeleteGroup deletes a single Group.
func (c *Client) DeleteGroup(ctx context.Context, req *vmmigrationpb.DeleteGroupRequest, opts ...gax.CallOption) (*DeleteGroupOperation, error) {
	return c.internalClient.DeleteGroup(ctx, req, opts...)
}

// DeleteGroupOperation returns a new DeleteGroupOperation from a given name.
// The name must be that of a previously created DeleteGroupOperation, possibly from a different process.
func (c *Client) DeleteGroupOperation(name string) *DeleteGroupOperation {
	return c.internalClient.DeleteGroupOperation(name)
}

// AddGroupMigration adds a MigratingVm to a Group.
func (c *Client) AddGroupMigration(ctx context.Context, req *vmmigrationpb.AddGroupMigrationRequest, opts ...gax.CallOption) (*AddGroupMigrationOperation, error) {
	return c.internalClient.AddGroupMigration(ctx, req, opts...)
}

// AddGroupMigrationOperation returns a new AddGroupMigrationOperation from a given name.
// The name must be that of a previously created AddGroupMigrationOperation, possibly from a different process.
func (c *Client) AddGroupMigrationOperation(name string) *AddGroupMigrationOperation {
	return c.internalClient.AddGroupMigrationOperation(name)
}

// RemoveGroupMigration removes a MigratingVm from a Group.
func (c *Client) RemoveGroupMigration(ctx context.Context, req *vmmigrationpb.RemoveGroupMigrationRequest, opts ...gax.CallOption) (*RemoveGroupMigrationOperation, error) {
	return c.internalClient.RemoveGroupMigration(ctx, req, opts...)
}

// RemoveGroupMigrationOperation returns a new RemoveGroupMigrationOperation from a given name.
// The name must be that of a previously created RemoveGroupMigrationOperation, possibly from a different process.
func (c *Client) RemoveGroupMigrationOperation(name string) *RemoveGroupMigrationOperation {
	return c.internalClient.RemoveGroupMigrationOperation(name)
}

// ListTargetProjects lists TargetProjects in a given project.
//
// NOTE: TargetProject is a global resource; hence the only supported value
// for location is global.
func (c *Client) ListTargetProjects(ctx context.Context, req *vmmigrationpb.ListTargetProjectsRequest, opts ...gax.CallOption) *TargetProjectIterator {
	return c.internalClient.ListTargetProjects(ctx, req, opts...)
}

// GetTargetProject gets details of a single TargetProject.
//
// NOTE: TargetProject is a global resource; hence the only supported value
// for location is global.
func (c *Client) GetTargetProject(ctx context.Context, req *vmmigrationpb.GetTargetProjectRequest, opts ...gax.CallOption) (*vmmigrationpb.TargetProject, error) {
	return c.internalClient.GetTargetProject(ctx, req, opts...)
}

// CreateTargetProject creates a new TargetProject in a given project.
//
// NOTE: TargetProject is a global resource; hence the only supported value
// for location is global.
func (c *Client) CreateTargetProject(ctx context.Context, req *vmmigrationpb.CreateTargetProjectRequest, opts ...gax.CallOption) (*CreateTargetProjectOperation, error) {
	return c.internalClient.CreateTargetProject(ctx, req, opts...)
}

// CreateTargetProjectOperation returns a new CreateTargetProjectOperation from a given name.
// The name must be that of a previously created CreateTargetProjectOperation, possibly from a different process.
func (c *Client) CreateTargetProjectOperation(name string) *CreateTargetProjectOperation {
	return c.internalClient.CreateTargetProjectOperation(name)
}

// UpdateTargetProject updates the parameters of a single TargetProject.
//
// NOTE: TargetProject is a global resource; hence the only supported value
// for location is global.
func (c *Client) UpdateTargetProject(ctx context.Context, req *vmmigrationpb.UpdateTargetProjectRequest, opts ...gax.CallOption) (*UpdateTargetProjectOperation, error) {
	return c.internalClient.UpdateTargetProject(ctx, req, opts...)
}

// UpdateTargetProjectOperation returns a new UpdateTargetProjectOperation from a given name.
// The name must be that of a previously created UpdateTargetProjectOperation, possibly from a different process.
func (c *Client) UpdateTargetProjectOperation(name string) *UpdateTargetProjectOperation {
	return c.internalClient.UpdateTargetProjectOperation(name)
}

// DeleteTargetProject deletes a single TargetProject.
//
// NOTE: TargetProject is a global resource; hence the only supported value
// for location is global.
func (c *Client) DeleteTargetProject(ctx context.Context, req *vmmigrationpb.DeleteTargetProjectRequest, opts ...gax.CallOption) (*DeleteTargetProjectOperation, error) {
	return c.internalClient.DeleteTargetProject(ctx, req, opts...)
}

// DeleteTargetProjectOperation returns a new DeleteTargetProjectOperation from a given name.
// The name must be that of a previously created DeleteTargetProjectOperation, possibly from a different process.
func (c *Client) DeleteTargetProjectOperation(name string) *DeleteTargetProjectOperation {
	return c.internalClient.DeleteTargetProjectOperation(name)
}

// ListReplicationCycles lists ReplicationCycles in a given MigratingVM.
func (c *Client) ListReplicationCycles(ctx context.Context, req *vmmigrationpb.ListReplicationCyclesRequest, opts ...gax.CallOption) *ReplicationCycleIterator {
	return c.internalClient.ListReplicationCycles(ctx, req, opts...)
}

// GetReplicationCycle gets details of a single ReplicationCycle.
func (c *Client) GetReplicationCycle(ctx context.Context, req *vmmigrationpb.GetReplicationCycleRequest, opts ...gax.CallOption) (*vmmigrationpb.ReplicationCycle, error) {
	return c.internalClient.GetReplicationCycle(ctx, req, opts...)
}

// GetLocation gets information about a location.
func (c *Client) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *Client) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *Client) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *Client) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *Client) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *Client) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// gRPCClient is a client for interacting with VM Migration API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client vmmigrationpb.VmMigrationClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewClient creates a new vm migration client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// VM Migration Service
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:         connPool,
		client:           vmmigrationpb.NewVmMigrationClient(connPool),
		CallOptions:      &client.CallOptions,
		logger:           internaloption.GetLogger(opts),
		operationsClient: longrunningpb.NewOperationsClient(connPool),
		locationsClient:  locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	logger *slog.Logger
}

// NewRESTClient creates a new vm migration rest client.
//
// VM Migration Service
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://vmmigration.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://vmmigration.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://vmmigration.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://vmmigration.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) ListSources(ctx context.Context, req *vmmigrationpb.ListSourcesRequest, opts ...gax.CallOption) *SourceIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListSources[0:len((*c.CallOptions).ListSources):len((*c.CallOptions).ListSources)], opts...)
	it := &SourceIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListSourcesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.Source, string, error) {
		resp := &vmmigrationpb.ListSourcesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListSources, req, settings.GRPC, c.logger, "ListSources")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSources(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetSource(ctx context.Context, req *vmmigrationpb.GetSourceRequest, opts ...gax.CallOption) (*vmmigrationpb.Source, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetSource[0:len((*c.CallOptions).GetSource):len((*c.CallOptions).GetSource)], opts...)
	var resp *vmmigrationpb.Source
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetSource, req, settings.GRPC, c.logger, "GetSource")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateSource(ctx context.Context, req *vmmigrationpb.CreateSourceRequest, opts ...gax.CallOption) (*CreateSourceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateSource[0:len((*c.CallOptions).CreateSource):len((*c.CallOptions).CreateSource)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateSource, req, settings.GRPC, c.logger, "CreateSource")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateSource(ctx context.Context, req *vmmigrationpb.UpdateSourceRequest, opts ...gax.CallOption) (*UpdateSourceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "source.name", url.QueryEscape(req.GetSource().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateSource[0:len((*c.CallOptions).UpdateSource):len((*c.CallOptions).UpdateSource)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateSource, req, settings.GRPC, c.logger, "UpdateSource")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteSource(ctx context.Context, req *vmmigrationpb.DeleteSourceRequest, opts ...gax.CallOption) (*DeleteSourceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteSource[0:len((*c.CallOptions).DeleteSource):len((*c.CallOptions).DeleteSource)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteSource, req, settings.GRPC, c.logger, "DeleteSource")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) FetchInventory(ctx context.Context, req *vmmigrationpb.FetchInventoryRequest, opts ...gax.CallOption) (*vmmigrationpb.FetchInventoryResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "source", url.QueryEscape(req.GetSource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).FetchInventory[0:len((*c.CallOptions).FetchInventory):len((*c.CallOptions).FetchInventory)], opts...)
	var resp *vmmigrationpb.FetchInventoryResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.FetchInventory, req, settings.GRPC, c.logger, "FetchInventory")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListUtilizationReports(ctx context.Context, req *vmmigrationpb.ListUtilizationReportsRequest, opts ...gax.CallOption) *UtilizationReportIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListUtilizationReports[0:len((*c.CallOptions).ListUtilizationReports):len((*c.CallOptions).ListUtilizationReports)], opts...)
	it := &UtilizationReportIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListUtilizationReportsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.UtilizationReport, string, error) {
		resp := &vmmigrationpb.ListUtilizationReportsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListUtilizationReports, req, settings.GRPC, c.logger, "ListUtilizationReports")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetUtilizationReports(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetUtilizationReport(ctx context.Context, req *vmmigrationpb.GetUtilizationReportRequest, opts ...gax.CallOption) (*vmmigrationpb.UtilizationReport, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetUtilizationReport[0:len((*c.CallOptions).GetUtilizationReport):len((*c.CallOptions).GetUtilizationReport)], opts...)
	var resp *vmmigrationpb.UtilizationReport
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetUtilizationReport, req, settings.GRPC, c.logger, "GetUtilizationReport")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateUtilizationReport(ctx context.Context, req *vmmigrationpb.CreateUtilizationReportRequest, opts ...gax.CallOption) (*CreateUtilizationReportOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateUtilizationReport[0:len((*c.CallOptions).CreateUtilizationReport):len((*c.CallOptions).CreateUtilizationReport)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateUtilizationReport, req, settings.GRPC, c.logger, "CreateUtilizationReport")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateUtilizationReportOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteUtilizationReport(ctx context.Context, req *vmmigrationpb.DeleteUtilizationReportRequest, opts ...gax.CallOption) (*DeleteUtilizationReportOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteUtilizationReport[0:len((*c.CallOptions).DeleteUtilizationReport):len((*c.CallOptions).DeleteUtilizationReport)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteUtilizationReport, req, settings.GRPC, c.logger, "DeleteUtilizationReport")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteUtilizationReportOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListDatacenterConnectors(ctx context.Context, req *vmmigrationpb.ListDatacenterConnectorsRequest, opts ...gax.CallOption) *DatacenterConnectorIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDatacenterConnectors[0:len((*c.CallOptions).ListDatacenterConnectors):len((*c.CallOptions).ListDatacenterConnectors)], opts...)
	it := &DatacenterConnectorIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListDatacenterConnectorsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.DatacenterConnector, string, error) {
		resp := &vmmigrationpb.ListDatacenterConnectorsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListDatacenterConnectors, req, settings.GRPC, c.logger, "ListDatacenterConnectors")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDatacenterConnectors(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetDatacenterConnector(ctx context.Context, req *vmmigrationpb.GetDatacenterConnectorRequest, opts ...gax.CallOption) (*vmmigrationpb.DatacenterConnector, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetDatacenterConnector[0:len((*c.CallOptions).GetDatacenterConnector):len((*c.CallOptions).GetDatacenterConnector)], opts...)
	var resp *vmmigrationpb.DatacenterConnector
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetDatacenterConnector, req, settings.GRPC, c.logger, "GetDatacenterConnector")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateDatacenterConnector(ctx context.Context, req *vmmigrationpb.CreateDatacenterConnectorRequest, opts ...gax.CallOption) (*CreateDatacenterConnectorOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateDatacenterConnector[0:len((*c.CallOptions).CreateDatacenterConnector):len((*c.CallOptions).CreateDatacenterConnector)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateDatacenterConnector, req, settings.GRPC, c.logger, "CreateDatacenterConnector")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateDatacenterConnectorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteDatacenterConnector(ctx context.Context, req *vmmigrationpb.DeleteDatacenterConnectorRequest, opts ...gax.CallOption) (*DeleteDatacenterConnectorOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteDatacenterConnector[0:len((*c.CallOptions).DeleteDatacenterConnector):len((*c.CallOptions).DeleteDatacenterConnector)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteDatacenterConnector, req, settings.GRPC, c.logger, "DeleteDatacenterConnector")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteDatacenterConnectorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpgradeAppliance(ctx context.Context, req *vmmigrationpb.UpgradeApplianceRequest, opts ...gax.CallOption) (*UpgradeApplianceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "datacenter_connector", url.QueryEscape(req.GetDatacenterConnector()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpgradeAppliance[0:len((*c.CallOptions).UpgradeAppliance):len((*c.CallOptions).UpgradeAppliance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpgradeAppliance, req, settings.GRPC, c.logger, "UpgradeAppliance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpgradeApplianceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CreateMigratingVm(ctx context.Context, req *vmmigrationpb.CreateMigratingVmRequest, opts ...gax.CallOption) (*CreateMigratingVmOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateMigratingVm[0:len((*c.CallOptions).CreateMigratingVm):len((*c.CallOptions).CreateMigratingVm)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateMigratingVm, req, settings.GRPC, c.logger, "CreateMigratingVm")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateMigratingVmOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListMigratingVms(ctx context.Context, req *vmmigrationpb.ListMigratingVmsRequest, opts ...gax.CallOption) *MigratingVmIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListMigratingVms[0:len((*c.CallOptions).ListMigratingVms):len((*c.CallOptions).ListMigratingVms)], opts...)
	it := &MigratingVmIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListMigratingVmsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.MigratingVm, string, error) {
		resp := &vmmigrationpb.ListMigratingVmsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListMigratingVms, req, settings.GRPC, c.logger, "ListMigratingVms")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetMigratingVms(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetMigratingVm(ctx context.Context, req *vmmigrationpb.GetMigratingVmRequest, opts ...gax.CallOption) (*vmmigrationpb.MigratingVm, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetMigratingVm[0:len((*c.CallOptions).GetMigratingVm):len((*c.CallOptions).GetMigratingVm)], opts...)
	var resp *vmmigrationpb.MigratingVm
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetMigratingVm, req, settings.GRPC, c.logger, "GetMigratingVm")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateMigratingVm(ctx context.Context, req *vmmigrationpb.UpdateMigratingVmRequest, opts ...gax.CallOption) (*UpdateMigratingVmOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migrating_vm.name", url.QueryEscape(req.GetMigratingVm().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateMigratingVm[0:len((*c.CallOptions).UpdateMigratingVm):len((*c.CallOptions).UpdateMigratingVm)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateMigratingVm, req, settings.GRPC, c.logger, "UpdateMigratingVm")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateMigratingVmOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteMigratingVm(ctx context.Context, req *vmmigrationpb.DeleteMigratingVmRequest, opts ...gax.CallOption) (*DeleteMigratingVmOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteMigratingVm[0:len((*c.CallOptions).DeleteMigratingVm):len((*c.CallOptions).DeleteMigratingVm)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteMigratingVm, req, settings.GRPC, c.logger, "DeleteMigratingVm")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteMigratingVmOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) StartMigration(ctx context.Context, req *vmmigrationpb.StartMigrationRequest, opts ...gax.CallOption) (*StartMigrationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migrating_vm", url.QueryEscape(req.GetMigratingVm()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StartMigration[0:len((*c.CallOptions).StartMigration):len((*c.CallOptions).StartMigration)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.StartMigration, req, settings.GRPC, c.logger, "StartMigration")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StartMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ResumeMigration(ctx context.Context, req *vmmigrationpb.ResumeMigrationRequest, opts ...gax.CallOption) (*ResumeMigrationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migrating_vm", url.QueryEscape(req.GetMigratingVm()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ResumeMigration[0:len((*c.CallOptions).ResumeMigration):len((*c.CallOptions).ResumeMigration)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ResumeMigration, req, settings.GRPC, c.logger, "ResumeMigration")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ResumeMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) PauseMigration(ctx context.Context, req *vmmigrationpb.PauseMigrationRequest, opts ...gax.CallOption) (*PauseMigrationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migrating_vm", url.QueryEscape(req.GetMigratingVm()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).PauseMigration[0:len((*c.CallOptions).PauseMigration):len((*c.CallOptions).PauseMigration)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.PauseMigration, req, settings.GRPC, c.logger, "PauseMigration")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &PauseMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) FinalizeMigration(ctx context.Context, req *vmmigrationpb.FinalizeMigrationRequest, opts ...gax.CallOption) (*FinalizeMigrationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migrating_vm", url.QueryEscape(req.GetMigratingVm()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).FinalizeMigration[0:len((*c.CallOptions).FinalizeMigration):len((*c.CallOptions).FinalizeMigration)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.FinalizeMigration, req, settings.GRPC, c.logger, "FinalizeMigration")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &FinalizeMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CreateCloneJob(ctx context.Context, req *vmmigrationpb.CreateCloneJobRequest, opts ...gax.CallOption) (*CreateCloneJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateCloneJob[0:len((*c.CallOptions).CreateCloneJob):len((*c.CallOptions).CreateCloneJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateCloneJob, req, settings.GRPC, c.logger, "CreateCloneJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateCloneJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CancelCloneJob(ctx context.Context, req *vmmigrationpb.CancelCloneJobRequest, opts ...gax.CallOption) (*CancelCloneJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelCloneJob[0:len((*c.CallOptions).CancelCloneJob):len((*c.CallOptions).CancelCloneJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CancelCloneJob, req, settings.GRPC, c.logger, "CancelCloneJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CancelCloneJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListCloneJobs(ctx context.Context, req *vmmigrationpb.ListCloneJobsRequest, opts ...gax.CallOption) *CloneJobIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListCloneJobs[0:len((*c.CallOptions).ListCloneJobs):len((*c.CallOptions).ListCloneJobs)], opts...)
	it := &CloneJobIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListCloneJobsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.CloneJob, string, error) {
		resp := &vmmigrationpb.ListCloneJobsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListCloneJobs, req, settings.GRPC, c.logger, "ListCloneJobs")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetCloneJobs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetCloneJob(ctx context.Context, req *vmmigrationpb.GetCloneJobRequest, opts ...gax.CallOption) (*vmmigrationpb.CloneJob, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetCloneJob[0:len((*c.CallOptions).GetCloneJob):len((*c.CallOptions).GetCloneJob)], opts...)
	var resp *vmmigrationpb.CloneJob
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetCloneJob, req, settings.GRPC, c.logger, "GetCloneJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateCutoverJob(ctx context.Context, req *vmmigrationpb.CreateCutoverJobRequest, opts ...gax.CallOption) (*CreateCutoverJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateCutoverJob[0:len((*c.CallOptions).CreateCutoverJob):len((*c.CallOptions).CreateCutoverJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateCutoverJob, req, settings.GRPC, c.logger, "CreateCutoverJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateCutoverJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CancelCutoverJob(ctx context.Context, req *vmmigrationpb.CancelCutoverJobRequest, opts ...gax.CallOption) (*CancelCutoverJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelCutoverJob[0:len((*c.CallOptions).CancelCutoverJob):len((*c.CallOptions).CancelCutoverJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CancelCutoverJob, req, settings.GRPC, c.logger, "CancelCutoverJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CancelCutoverJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListCutoverJobs(ctx context.Context, req *vmmigrationpb.ListCutoverJobsRequest, opts ...gax.CallOption) *CutoverJobIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListCutoverJobs[0:len((*c.CallOptions).ListCutoverJobs):len((*c.CallOptions).ListCutoverJobs)], opts...)
	it := &CutoverJobIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListCutoverJobsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.CutoverJob, string, error) {
		resp := &vmmigrationpb.ListCutoverJobsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListCutoverJobs, req, settings.GRPC, c.logger, "ListCutoverJobs")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetCutoverJobs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetCutoverJob(ctx context.Context, req *vmmigrationpb.GetCutoverJobRequest, opts ...gax.CallOption) (*vmmigrationpb.CutoverJob, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetCutoverJob[0:len((*c.CallOptions).GetCutoverJob):len((*c.CallOptions).GetCutoverJob)], opts...)
	var resp *vmmigrationpb.CutoverJob
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetCutoverJob, req, settings.GRPC, c.logger, "GetCutoverJob")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListGroups(ctx context.Context, req *vmmigrationpb.ListGroupsRequest, opts ...gax.CallOption) *GroupIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListGroups[0:len((*c.CallOptions).ListGroups):len((*c.CallOptions).ListGroups)], opts...)
	it := &GroupIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListGroupsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.Group, string, error) {
		resp := &vmmigrationpb.ListGroupsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListGroups, req, settings.GRPC, c.logger, "ListGroups")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetGroups(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetGroup(ctx context.Context, req *vmmigrationpb.GetGroupRequest, opts ...gax.CallOption) (*vmmigrationpb.Group, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetGroup[0:len((*c.CallOptions).GetGroup):len((*c.CallOptions).GetGroup)], opts...)
	var resp *vmmigrationpb.Group
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetGroup, req, settings.GRPC, c.logger, "GetGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateGroup(ctx context.Context, req *vmmigrationpb.CreateGroupRequest, opts ...gax.CallOption) (*CreateGroupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateGroup[0:len((*c.CallOptions).CreateGroup):len((*c.CallOptions).CreateGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateGroup, req, settings.GRPC, c.logger, "CreateGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateGroup(ctx context.Context, req *vmmigrationpb.UpdateGroupRequest, opts ...gax.CallOption) (*UpdateGroupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group.name", url.QueryEscape(req.GetGroup().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateGroup[0:len((*c.CallOptions).UpdateGroup):len((*c.CallOptions).UpdateGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateGroup, req, settings.GRPC, c.logger, "UpdateGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteGroup(ctx context.Context, req *vmmigrationpb.DeleteGroupRequest, opts ...gax.CallOption) (*DeleteGroupOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteGroup[0:len((*c.CallOptions).DeleteGroup):len((*c.CallOptions).DeleteGroup)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteGroup, req, settings.GRPC, c.logger, "DeleteGroup")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) AddGroupMigration(ctx context.Context, req *vmmigrationpb.AddGroupMigrationRequest, opts ...gax.CallOption) (*AddGroupMigrationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group", url.QueryEscape(req.GetGroup()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).AddGroupMigration[0:len((*c.CallOptions).AddGroupMigration):len((*c.CallOptions).AddGroupMigration)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.AddGroupMigration, req, settings.GRPC, c.logger, "AddGroupMigration")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &AddGroupMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) RemoveGroupMigration(ctx context.Context, req *vmmigrationpb.RemoveGroupMigrationRequest, opts ...gax.CallOption) (*RemoveGroupMigrationOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group", url.QueryEscape(req.GetGroup()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RemoveGroupMigration[0:len((*c.CallOptions).RemoveGroupMigration):len((*c.CallOptions).RemoveGroupMigration)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.RemoveGroupMigration, req, settings.GRPC, c.logger, "RemoveGroupMigration")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RemoveGroupMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListTargetProjects(ctx context.Context, req *vmmigrationpb.ListTargetProjectsRequest, opts ...gax.CallOption) *TargetProjectIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListTargetProjects[0:len((*c.CallOptions).ListTargetProjects):len((*c.CallOptions).ListTargetProjects)], opts...)
	it := &TargetProjectIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListTargetProjectsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.TargetProject, string, error) {
		resp := &vmmigrationpb.ListTargetProjectsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListTargetProjects, req, settings.GRPC, c.logger, "ListTargetProjects")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTargetProjects(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetTargetProject(ctx context.Context, req *vmmigrationpb.GetTargetProjectRequest, opts ...gax.CallOption) (*vmmigrationpb.TargetProject, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetTargetProject[0:len((*c.CallOptions).GetTargetProject):len((*c.CallOptions).GetTargetProject)], opts...)
	var resp *vmmigrationpb.TargetProject
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetTargetProject, req, settings.GRPC, c.logger, "GetTargetProject")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateTargetProject(ctx context.Context, req *vmmigrationpb.CreateTargetProjectRequest, opts ...gax.CallOption) (*CreateTargetProjectOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateTargetProject[0:len((*c.CallOptions).CreateTargetProject):len((*c.CallOptions).CreateTargetProject)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateTargetProject, req, settings.GRPC, c.logger, "CreateTargetProject")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateTargetProjectOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateTargetProject(ctx context.Context, req *vmmigrationpb.UpdateTargetProjectRequest, opts ...gax.CallOption) (*UpdateTargetProjectOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "target_project.name", url.QueryEscape(req.GetTargetProject().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateTargetProject[0:len((*c.CallOptions).UpdateTargetProject):len((*c.CallOptions).UpdateTargetProject)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateTargetProject, req, settings.GRPC, c.logger, "UpdateTargetProject")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateTargetProjectOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteTargetProject(ctx context.Context, req *vmmigrationpb.DeleteTargetProjectRequest, opts ...gax.CallOption) (*DeleteTargetProjectOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteTargetProject[0:len((*c.CallOptions).DeleteTargetProject):len((*c.CallOptions).DeleteTargetProject)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteTargetProject, req, settings.GRPC, c.logger, "DeleteTargetProject")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteTargetProjectOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListReplicationCycles(ctx context.Context, req *vmmigrationpb.ListReplicationCyclesRequest, opts ...gax.CallOption) *ReplicationCycleIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListReplicationCycles[0:len((*c.CallOptions).ListReplicationCycles):len((*c.CallOptions).ListReplicationCycles)], opts...)
	it := &ReplicationCycleIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListReplicationCyclesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.ReplicationCycle, string, error) {
		resp := &vmmigrationpb.ListReplicationCyclesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListReplicationCycles, req, settings.GRPC, c.logger, "ListReplicationCycles")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetReplicationCycles(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetReplicationCycle(ctx context.Context, req *vmmigrationpb.GetReplicationCycleRequest, opts ...gax.CallOption) (*vmmigrationpb.ReplicationCycle, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetReplicationCycle[0:len((*c.CallOptions).GetReplicationCycle):len((*c.CallOptions).GetReplicationCycle)], opts...)
	var resp *vmmigrationpb.ReplicationCycle
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetReplicationCycle, req, settings.GRPC, c.logger, "GetReplicationCycle")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListSources lists Sources in a given project and location.
func (c *restClient) ListSources(ctx context.Context, req *vmmigrationpb.ListSourcesRequest, opts ...gax.CallOption) *SourceIterator {
	it := &SourceIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListSourcesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.Source, string, error) {
		resp := &vmmigrationpb.ListSourcesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/sources", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListSources")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetSources(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetSource gets details of a single Source.
func (c *restClient) GetSource(ctx context.Context, req *vmmigrationpb.GetSourceRequest, opts ...gax.CallOption) (*vmmigrationpb.Source, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetSource[0:len((*c.CallOptions).GetSource):len((*c.CallOptions).GetSource)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &vmmigrationpb.Source{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetSource")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateSource creates a new Source in a given project and location.
func (c *restClient) CreateSource(ctx context.Context, req *vmmigrationpb.CreateSourceRequest, opts ...gax.CallOption) (*CreateSourceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSource()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/sources", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	params.Add("sourceId", fmt.Sprintf("%v", req.GetSourceId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateSource")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateSource updates the parameters of a single Source.
func (c *restClient) UpdateSource(ctx context.Context, req *vmmigrationpb.UpdateSourceRequest, opts ...gax.CallOption) (*UpdateSourceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetSource()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetSource().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "source.name", url.QueryEscape(req.GetSource().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateSource")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteSource deletes a single Source.
func (c *restClient) DeleteSource(ctx context.Context, req *vmmigrationpb.DeleteSourceRequest, opts ...gax.CallOption) (*DeleteSourceOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteSource")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// FetchInventory list remote source’s inventory of VMs.
// The remote source is the onprem vCenter (remote in the sense it’s not in
// Compute Engine). The inventory describes the list of existing VMs in that
// source. Note that this operation lists the VMs on the remote source, as
// opposed to listing the MigratingVms resources in the vmmigration service.
func (c *restClient) FetchInventory(ctx context.Context, req *vmmigrationpb.FetchInventoryRequest, opts ...gax.CallOption) (*vmmigrationpb.FetchInventoryResponse, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:fetchInventory", req.GetSource())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetForceRefresh() {
		params.Add("forceRefresh", fmt.Sprintf("%v", req.GetForceRefresh()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "source", url.QueryEscape(req.GetSource()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).FetchInventory[0:len((*c.CallOptions).FetchInventory):len((*c.CallOptions).FetchInventory)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &vmmigrationpb.FetchInventoryResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "FetchInventory")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListUtilizationReports lists Utilization Reports of the given Source.
func (c *restClient) ListUtilizationReports(ctx context.Context, req *vmmigrationpb.ListUtilizationReportsRequest, opts ...gax.CallOption) *UtilizationReportIterator {
	it := &UtilizationReportIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListUtilizationReportsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.UtilizationReport, string, error) {
		resp := &vmmigrationpb.ListUtilizationReportsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/utilizationReports", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		if req.GetView() != 0 {
			params.Add("view", fmt.Sprintf("%v", req.GetView()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListUtilizationReports")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetUtilizationReports(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetUtilizationReport gets a single Utilization Report.
func (c *restClient) GetUtilizationReport(ctx context.Context, req *vmmigrationpb.GetUtilizationReportRequest, opts ...gax.CallOption) (*vmmigrationpb.UtilizationReport, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetView() != 0 {
		params.Add("view", fmt.Sprintf("%v", req.GetView()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetUtilizationReport[0:len((*c.CallOptions).GetUtilizationReport):len((*c.CallOptions).GetUtilizationReport)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &vmmigrationpb.UtilizationReport{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetUtilizationReport")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateUtilizationReport creates a new UtilizationReport.
func (c *restClient) CreateUtilizationReport(ctx context.Context, req *vmmigrationpb.CreateUtilizationReportRequest, opts ...gax.CallOption) (*CreateUtilizationReportOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetUtilizationReport()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/utilizationReports", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	params.Add("utilizationReportId", fmt.Sprintf("%v", req.GetUtilizationReportId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateUtilizationReport")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateUtilizationReportOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteUtilizationReport deletes a single Utilization Report.
func (c *restClient) DeleteUtilizationReport(ctx context.Context, req *vmmigrationpb.DeleteUtilizationReportRequest, opts ...gax.CallOption) (*DeleteUtilizationReportOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteUtilizationReport")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteUtilizationReportOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListDatacenterConnectors lists DatacenterConnectors in a given Source.
func (c *restClient) ListDatacenterConnectors(ctx context.Context, req *vmmigrationpb.ListDatacenterConnectorsRequest, opts ...gax.CallOption) *DatacenterConnectorIterator {
	it := &DatacenterConnectorIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListDatacenterConnectorsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.DatacenterConnector, string, error) {
		resp := &vmmigrationpb.ListDatacenterConnectorsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/datacenterConnectors", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListDatacenterConnectors")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDatacenterConnectors(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetDatacenterConnector gets details of a single DatacenterConnector.
func (c *restClient) GetDatacenterConnector(ctx context.Context, req *vmmigrationpb.GetDatacenterConnectorRequest, opts ...gax.CallOption) (*vmmigrationpb.DatacenterConnector, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetDatacenterConnector[0:len((*c.CallOptions).GetDatacenterConnector):len((*c.CallOptions).GetDatacenterConnector)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &vmmigrationpb.DatacenterConnector{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetDatacenterConnector")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateDatacenterConnector creates a new DatacenterConnector in a given Source.
func (c *restClient) CreateDatacenterConnector(ctx context.Context, req *vmmigrationpb.CreateDatacenterConnectorRequest, opts ...gax.CallOption) (*CreateDatacenterConnectorOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDatacenterConnector()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/datacenterConnectors", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("datacenterConnectorId", fmt.Sprintf("%v", req.GetDatacenterConnectorId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateDatacenterConnector")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateDatacenterConnectorOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteDatacenterConnector deletes a single DatacenterConnector.
func (c *restClient) DeleteDatacenterConnector(ctx context.Context, req *vmmigrationpb.DeleteDatacenterConnectorRequest, opts ...gax.CallOption) (*DeleteDatacenterConnectorOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteDatacenterConnector")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteDatacenterConnectorOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpgradeAppliance upgrades the appliance relate to this DatacenterConnector to the in-place
// updateable version.
func (c *restClient) UpgradeAppliance(ctx context.Context, req *vmmigrationpb.UpgradeApplianceRequest, opts ...gax.CallOption) (*UpgradeApplianceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:upgradeAppliance", req.GetDatacenterConnector())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "datacenter_connector", url.QueryEscape(req.GetDatacenterConnector()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpgradeAppliance")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpgradeApplianceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateMigratingVm creates a new MigratingVm in a given Source.
func (c *restClient) CreateMigratingVm(ctx context.Context, req *vmmigrationpb.CreateMigratingVmRequest, opts ...gax.CallOption) (*CreateMigratingVmOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetMigratingVm()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/migratingVms", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("migratingVmId", fmt.Sprintf("%v", req.GetMigratingVmId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateMigratingVm")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateMigratingVmOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListMigratingVms lists MigratingVms in a given Source.
func (c *restClient) ListMigratingVms(ctx context.Context, req *vmmigrationpb.ListMigratingVmsRequest, opts ...gax.CallOption) *MigratingVmIterator {
	it := &MigratingVmIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListMigratingVmsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.MigratingVm, string, error) {
		resp := &vmmigrationpb.ListMigratingVmsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/migratingVms", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		if req.GetView() != 0 {
			params.Add("view", fmt.Sprintf("%v", req.GetView()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListMigratingVms")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetMigratingVms(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetMigratingVm gets details of a single MigratingVm.
func (c *restClient) GetMigratingVm(ctx context.Context, req *vmmigrationpb.GetMigratingVmRequest, opts ...gax.CallOption) (*vmmigrationpb.MigratingVm, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetView() != 0 {
		params.Add("view", fmt.Sprintf("%v", req.GetView()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetMigratingVm[0:len((*c.CallOptions).GetMigratingVm):len((*c.CallOptions).GetMigratingVm)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &vmmigrationpb.MigratingVm{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetMigratingVm")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateMigratingVm updates the parameters of a single MigratingVm.
func (c *restClient) UpdateMigratingVm(ctx context.Context, req *vmmigrationpb.UpdateMigratingVmRequest, opts ...gax.CallOption) (*UpdateMigratingVmOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetMigratingVm()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetMigratingVm().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migrating_vm.name", url.QueryEscape(req.GetMigratingVm().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateMigratingVm")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateMigratingVmOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteMigratingVm deletes a single MigratingVm.
func (c *restClient) DeleteMigratingVm(ctx context.Context, req *vmmigrationpb.DeleteMigratingVmRequest, opts ...gax.CallOption) (*DeleteMigratingVmOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteMigratingVm")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteMigratingVmOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// StartMigration starts migration for a VM. Starts the process of uploading
// data and creating snapshots, in replication cycles scheduled by the policy.
func (c *restClient) StartMigration(ctx context.Context, req *vmmigrationpb.StartMigrationRequest, opts ...gax.CallOption) (*StartMigrationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:startMigration", req.GetMigratingVm())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migrating_vm", url.QueryEscape(req.GetMigratingVm()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "StartMigration")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &StartMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ResumeMigration resumes a migration for a VM. When called on a paused migration, will start
// the process of uploading data and creating snapshots; when called on a
// completed cut-over migration, will update the migration to active state and
// start the process of uploading data and creating snapshots.
func (c *restClient) ResumeMigration(ctx context.Context, req *vmmigrationpb.ResumeMigrationRequest, opts ...gax.CallOption) (*ResumeMigrationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:resumeMigration", req.GetMigratingVm())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migrating_vm", url.QueryEscape(req.GetMigratingVm()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ResumeMigration")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ResumeMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// PauseMigration pauses a migration for a VM. If cycle tasks are running they will be
// cancelled, preserving source task data. Further replication cycles will not
// be triggered while the VM is paused.
func (c *restClient) PauseMigration(ctx context.Context, req *vmmigrationpb.PauseMigrationRequest, opts ...gax.CallOption) (*PauseMigrationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:pauseMigration", req.GetMigratingVm())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migrating_vm", url.QueryEscape(req.GetMigratingVm()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "PauseMigration")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &PauseMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// FinalizeMigration marks a migration as completed, deleting migration resources that are no
// longer being used. Only applicable after cutover is done.
func (c *restClient) FinalizeMigration(ctx context.Context, req *vmmigrationpb.FinalizeMigrationRequest, opts ...gax.CallOption) (*FinalizeMigrationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:finalizeMigration", req.GetMigratingVm())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migrating_vm", url.QueryEscape(req.GetMigratingVm()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "FinalizeMigration")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &FinalizeMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateCloneJob initiates a Clone of a specific migrating VM.
func (c *restClient) CreateCloneJob(ctx context.Context, req *vmmigrationpb.CreateCloneJobRequest, opts ...gax.CallOption) (*CreateCloneJobOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCloneJob()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/cloneJobs", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("cloneJobId", fmt.Sprintf("%v", req.GetCloneJobId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateCloneJob")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateCloneJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CancelCloneJob initiates the cancellation of a running clone job.
func (c *restClient) CancelCloneJob(ctx context.Context, req *vmmigrationpb.CancelCloneJobRequest, opts ...gax.CallOption) (*CancelCloneJobOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CancelCloneJob")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CancelCloneJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListCloneJobs lists CloneJobs of a given migrating VM.
func (c *restClient) ListCloneJobs(ctx context.Context, req *vmmigrationpb.ListCloneJobsRequest, opts ...gax.CallOption) *CloneJobIterator {
	it := &CloneJobIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListCloneJobsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.CloneJob, string, error) {
		resp := &vmmigrationpb.ListCloneJobsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/cloneJobs", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListCloneJobs")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetCloneJobs(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetCloneJob gets details of a single CloneJob.
func (c *restClient) GetCloneJob(ctx context.Context, req *vmmigrationpb.GetCloneJobRequest, opts ...gax.CallOption) (*vmmigrationpb.CloneJob, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetCloneJob[0:len((*c.CallOptions).GetCloneJob):len((*c.CallOptions).GetCloneJob)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &vmmigrationpb.CloneJob{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetCloneJob")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateCutoverJob initiates a Cutover of a specific migrating VM.
// The returned LRO is completed when the cutover job resource is created
// and the job is initiated.
func (c *restClient) CreateCutoverJob(ctx context.Context, req *vmmigrationpb.CreateCutoverJobRequest, opts ...gax.CallOption) (*CreateCutoverJobOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetCutoverJob()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/cutoverJobs", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("cutoverJobId", fmt.Sprintf("%v", req.GetCutoverJobId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateCutoverJob")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateCutoverJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CancelCutoverJob initiates the cancellation of a running cutover job.
func (c *restClient) CancelCutoverJob(ctx context.Context, req *vmmigrationpb.CancelCutoverJobRequest, opts ...gax.CallOption) (*CancelCutoverJobOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CancelCutoverJob")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CancelCutoverJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListCutoverJobs lists CutoverJobs of a given migrating VM.
func (c *restClient) ListCutoverJobs(ctx context.Context, req *vmmigrationpb.ListCutoverJobsRequest, opts ...gax.CallOption) *CutoverJobIterator {
	it := &CutoverJobIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListCutoverJobsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.CutoverJob, string, error) {
		resp := &vmmigrationpb.ListCutoverJobsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/cutoverJobs", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListCutoverJobs")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetCutoverJobs(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetCutoverJob gets details of a single CutoverJob.
func (c *restClient) GetCutoverJob(ctx context.Context, req *vmmigrationpb.GetCutoverJobRequest, opts ...gax.CallOption) (*vmmigrationpb.CutoverJob, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetCutoverJob[0:len((*c.CallOptions).GetCutoverJob):len((*c.CallOptions).GetCutoverJob)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &vmmigrationpb.CutoverJob{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetCutoverJob")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListGroups lists Groups in a given project and location.
func (c *restClient) ListGroups(ctx context.Context, req *vmmigrationpb.ListGroupsRequest, opts ...gax.CallOption) *GroupIterator {
	it := &GroupIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListGroupsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.Group, string, error) {
		resp := &vmmigrationpb.ListGroupsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/groups", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListGroups")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetGroups(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetGroup gets details of a single Group.
func (c *restClient) GetGroup(ctx context.Context, req *vmmigrationpb.GetGroupRequest, opts ...gax.CallOption) (*vmmigrationpb.Group, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetGroup[0:len((*c.CallOptions).GetGroup):len((*c.CallOptions).GetGroup)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &vmmigrationpb.Group{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetGroup")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateGroup creates a new Group in a given project and location.
func (c *restClient) CreateGroup(ctx context.Context, req *vmmigrationpb.CreateGroupRequest, opts ...gax.CallOption) (*CreateGroupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGroup()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/groups", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("groupId", fmt.Sprintf("%v", req.GetGroupId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateGroup")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateGroup updates the parameters of a single Group.
func (c *restClient) UpdateGroup(ctx context.Context, req *vmmigrationpb.UpdateGroupRequest, opts ...gax.CallOption) (*UpdateGroupOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetGroup()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetGroup().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group.name", url.QueryEscape(req.GetGroup().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateGroup")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteGroup deletes a single Group.
func (c *restClient) DeleteGroup(ctx context.Context, req *vmmigrationpb.DeleteGroupRequest, opts ...gax.CallOption) (*DeleteGroupOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteGroup")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// AddGroupMigration adds a MigratingVm to a Group.
func (c *restClient) AddGroupMigration(ctx context.Context, req *vmmigrationpb.AddGroupMigrationRequest, opts ...gax.CallOption) (*AddGroupMigrationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:addGroupMigration", req.GetGroup())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group", url.QueryEscape(req.GetGroup()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "AddGroupMigration")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &AddGroupMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// RemoveGroupMigration removes a MigratingVm from a Group.
func (c *restClient) RemoveGroupMigration(ctx context.Context, req *vmmigrationpb.RemoveGroupMigrationRequest, opts ...gax.CallOption) (*RemoveGroupMigrationOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:removeGroupMigration", req.GetGroup())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "group", url.QueryEscape(req.GetGroup()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RemoveGroupMigration")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &RemoveGroupMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListTargetProjects lists TargetProjects in a given project.
//
// NOTE: TargetProject is a global resource; hence the only supported value
// for location is global.
func (c *restClient) ListTargetProjects(ctx context.Context, req *vmmigrationpb.ListTargetProjectsRequest, opts ...gax.CallOption) *TargetProjectIterator {
	it := &TargetProjectIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListTargetProjectsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.TargetProject, string, error) {
		resp := &vmmigrationpb.ListTargetProjectsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/targetProjects", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListTargetProjects")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetTargetProjects(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetTargetProject gets details of a single TargetProject.
//
// NOTE: TargetProject is a global resource; hence the only supported value
// for location is global.
func (c *restClient) GetTargetProject(ctx context.Context, req *vmmigrationpb.GetTargetProjectRequest, opts ...gax.CallOption) (*vmmigrationpb.TargetProject, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetTargetProject[0:len((*c.CallOptions).GetTargetProject):len((*c.CallOptions).GetTargetProject)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &vmmigrationpb.TargetProject{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetTargetProject")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateTargetProject creates a new TargetProject in a given project.
//
// NOTE: TargetProject is a global resource; hence the only supported value
// for location is global.
func (c *restClient) CreateTargetProject(ctx context.Context, req *vmmigrationpb.CreateTargetProjectRequest, opts ...gax.CallOption) (*CreateTargetProjectOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTargetProject()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/targetProjects", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	params.Add("targetProjectId", fmt.Sprintf("%v", req.GetTargetProjectId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateTargetProject")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateTargetProjectOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateTargetProject updates the parameters of a single TargetProject.
//
// NOTE: TargetProject is a global resource; hence the only supported value
// for location is global.
func (c *restClient) UpdateTargetProject(ctx context.Context, req *vmmigrationpb.UpdateTargetProjectRequest, opts ...gax.CallOption) (*UpdateTargetProjectOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTargetProject()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetTargetProject().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "target_project.name", url.QueryEscape(req.GetTargetProject().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateTargetProject")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateTargetProjectOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteTargetProject deletes a single TargetProject.
//
// NOTE: TargetProject is a global resource; hence the only supported value
// for location is global.
func (c *restClient) DeleteTargetProject(ctx context.Context, req *vmmigrationpb.DeleteTargetProjectRequest, opts ...gax.CallOption) (*DeleteTargetProjectOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteTargetProject")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteTargetProjectOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListReplicationCycles lists ReplicationCycles in a given MigratingVM.
func (c *restClient) ListReplicationCycles(ctx context.Context, req *vmmigrationpb.ListReplicationCyclesRequest, opts ...gax.CallOption) *ReplicationCycleIterator {
	it := &ReplicationCycleIterator{}
	req = proto.Clone(req).(*vmmigrationpb.ListReplicationCyclesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*vmmigrationpb.ReplicationCycle, string, error) {
		resp := &vmmigrationpb.ListReplicationCyclesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/replicationCycles", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListReplicationCycles")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetReplicationCycles(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetReplicationCycle gets details of a single ReplicationCycle.
func (c *restClient) GetReplicationCycle(ctx context.Context, req *vmmigrationpb.GetReplicationCycleRequest, opts ...gax.CallOption) (*vmmigrationpb.ReplicationCycle, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetReplicationCycle[0:len((*c.CallOptions).GetReplicationCycle):len((*c.CallOptions).GetReplicationCycle)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &vmmigrationpb.ReplicationCycle{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetReplicationCycle")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetLocation gets information about a location.
func (c *restClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetLocation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *restClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/locations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListLocations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *restClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CancelOperation")
		return err
	}, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *restClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *restClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *restClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// AddGroupMigrationOperation returns a new AddGroupMigrationOperation from a given name.
// The name must be that of a previously created AddGroupMigrationOperation, possibly from a different process.
func (c *gRPCClient) AddGroupMigrationOperation(name string) *AddGroupMigrationOperation {
	return &AddGroupMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// AddGroupMigrationOperation returns a new AddGroupMigrationOperation from a given name.
// The name must be that of a previously created AddGroupMigrationOperation, possibly from a different process.
func (c *restClient) AddGroupMigrationOperation(name string) *AddGroupMigrationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &AddGroupMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CancelCloneJobOperation returns a new CancelCloneJobOperation from a given name.
// The name must be that of a previously created CancelCloneJobOperation, possibly from a different process.
func (c *gRPCClient) CancelCloneJobOperation(name string) *CancelCloneJobOperation {
	return &CancelCloneJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CancelCloneJobOperation returns a new CancelCloneJobOperation from a given name.
// The name must be that of a previously created CancelCloneJobOperation, possibly from a different process.
func (c *restClient) CancelCloneJobOperation(name string) *CancelCloneJobOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CancelCloneJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CancelCutoverJobOperation returns a new CancelCutoverJobOperation from a given name.
// The name must be that of a previously created CancelCutoverJobOperation, possibly from a different process.
func (c *gRPCClient) CancelCutoverJobOperation(name string) *CancelCutoverJobOperation {
	return &CancelCutoverJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CancelCutoverJobOperation returns a new CancelCutoverJobOperation from a given name.
// The name must be that of a previously created CancelCutoverJobOperation, possibly from a different process.
func (c *restClient) CancelCutoverJobOperation(name string) *CancelCutoverJobOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CancelCutoverJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateCloneJobOperation returns a new CreateCloneJobOperation from a given name.
// The name must be that of a previously created CreateCloneJobOperation, possibly from a different process.
func (c *gRPCClient) CreateCloneJobOperation(name string) *CreateCloneJobOperation {
	return &CreateCloneJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateCloneJobOperation returns a new CreateCloneJobOperation from a given name.
// The name must be that of a previously created CreateCloneJobOperation, possibly from a different process.
func (c *restClient) CreateCloneJobOperation(name string) *CreateCloneJobOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateCloneJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateCutoverJobOperation returns a new CreateCutoverJobOperation from a given name.
// The name must be that of a previously created CreateCutoverJobOperation, possibly from a different process.
func (c *gRPCClient) CreateCutoverJobOperation(name string) *CreateCutoverJobOperation {
	return &CreateCutoverJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateCutoverJobOperation returns a new CreateCutoverJobOperation from a given name.
// The name must be that of a previously created CreateCutoverJobOperation, possibly from a different process.
func (c *restClient) CreateCutoverJobOperation(name string) *CreateCutoverJobOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateCutoverJobOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateDatacenterConnectorOperation returns a new CreateDatacenterConnectorOperation from a given name.
// The name must be that of a previously created CreateDatacenterConnectorOperation, possibly from a different process.
func (c *gRPCClient) CreateDatacenterConnectorOperation(name string) *CreateDatacenterConnectorOperation {
	return &CreateDatacenterConnectorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateDatacenterConnectorOperation returns a new CreateDatacenterConnectorOperation from a given name.
// The name must be that of a previously created CreateDatacenterConnectorOperation, possibly from a different process.
func (c *restClient) CreateDatacenterConnectorOperation(name string) *CreateDatacenterConnectorOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateDatacenterConnectorOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateGroupOperation returns a new CreateGroupOperation from a given name.
// The name must be that of a previously created CreateGroupOperation, possibly from a different process.
func (c *gRPCClient) CreateGroupOperation(name string) *CreateGroupOperation {
	return &CreateGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateGroupOperation returns a new CreateGroupOperation from a given name.
// The name must be that of a previously created CreateGroupOperation, possibly from a different process.
func (c *restClient) CreateGroupOperation(name string) *CreateGroupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateMigratingVmOperation returns a new CreateMigratingVmOperation from a given name.
// The name must be that of a previously created CreateMigratingVmOperation, possibly from a different process.
func (c *gRPCClient) CreateMigratingVmOperation(name string) *CreateMigratingVmOperation {
	return &CreateMigratingVmOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateMigratingVmOperation returns a new CreateMigratingVmOperation from a given name.
// The name must be that of a previously created CreateMigratingVmOperation, possibly from a different process.
func (c *restClient) CreateMigratingVmOperation(name string) *CreateMigratingVmOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateMigratingVmOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateSourceOperation returns a new CreateSourceOperation from a given name.
// The name must be that of a previously created CreateSourceOperation, possibly from a different process.
func (c *gRPCClient) CreateSourceOperation(name string) *CreateSourceOperation {
	return &CreateSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateSourceOperation returns a new CreateSourceOperation from a given name.
// The name must be that of a previously created CreateSourceOperation, possibly from a different process.
func (c *restClient) CreateSourceOperation(name string) *CreateSourceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateTargetProjectOperation returns a new CreateTargetProjectOperation from a given name.
// The name must be that of a previously created CreateTargetProjectOperation, possibly from a different process.
func (c *gRPCClient) CreateTargetProjectOperation(name string) *CreateTargetProjectOperation {
	return &CreateTargetProjectOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateTargetProjectOperation returns a new CreateTargetProjectOperation from a given name.
// The name must be that of a previously created CreateTargetProjectOperation, possibly from a different process.
func (c *restClient) CreateTargetProjectOperation(name string) *CreateTargetProjectOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateTargetProjectOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateUtilizationReportOperation returns a new CreateUtilizationReportOperation from a given name.
// The name must be that of a previously created CreateUtilizationReportOperation, possibly from a different process.
func (c *gRPCClient) CreateUtilizationReportOperation(name string) *CreateUtilizationReportOperation {
	return &CreateUtilizationReportOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateUtilizationReportOperation returns a new CreateUtilizationReportOperation from a given name.
// The name must be that of a previously created CreateUtilizationReportOperation, possibly from a different process.
func (c *restClient) CreateUtilizationReportOperation(name string) *CreateUtilizationReportOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateUtilizationReportOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteDatacenterConnectorOperation returns a new DeleteDatacenterConnectorOperation from a given name.
// The name must be that of a previously created DeleteDatacenterConnectorOperation, possibly from a different process.
func (c *gRPCClient) DeleteDatacenterConnectorOperation(name string) *DeleteDatacenterConnectorOperation {
	return &DeleteDatacenterConnectorOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteDatacenterConnectorOperation returns a new DeleteDatacenterConnectorOperation from a given name.
// The name must be that of a previously created DeleteDatacenterConnectorOperation, possibly from a different process.
func (c *restClient) DeleteDatacenterConnectorOperation(name string) *DeleteDatacenterConnectorOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteDatacenterConnectorOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteGroupOperation returns a new DeleteGroupOperation from a given name.
// The name must be that of a previously created DeleteGroupOperation, possibly from a different process.
func (c *gRPCClient) DeleteGroupOperation(name string) *DeleteGroupOperation {
	return &DeleteGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteGroupOperation returns a new DeleteGroupOperation from a given name.
// The name must be that of a previously created DeleteGroupOperation, possibly from a different process.
func (c *restClient) DeleteGroupOperation(name string) *DeleteGroupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteMigratingVmOperation returns a new DeleteMigratingVmOperation from a given name.
// The name must be that of a previously created DeleteMigratingVmOperation, possibly from a different process.
func (c *gRPCClient) DeleteMigratingVmOperation(name string) *DeleteMigratingVmOperation {
	return &DeleteMigratingVmOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteMigratingVmOperation returns a new DeleteMigratingVmOperation from a given name.
// The name must be that of a previously created DeleteMigratingVmOperation, possibly from a different process.
func (c *restClient) DeleteMigratingVmOperation(name string) *DeleteMigratingVmOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteMigratingVmOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteSourceOperation returns a new DeleteSourceOperation from a given name.
// The name must be that of a previously created DeleteSourceOperation, possibly from a different process.
func (c *gRPCClient) DeleteSourceOperation(name string) *DeleteSourceOperation {
	return &DeleteSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteSourceOperation returns a new DeleteSourceOperation from a given name.
// The name must be that of a previously created DeleteSourceOperation, possibly from a different process.
func (c *restClient) DeleteSourceOperation(name string) *DeleteSourceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteTargetProjectOperation returns a new DeleteTargetProjectOperation from a given name.
// The name must be that of a previously created DeleteTargetProjectOperation, possibly from a different process.
func (c *gRPCClient) DeleteTargetProjectOperation(name string) *DeleteTargetProjectOperation {
	return &DeleteTargetProjectOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteTargetProjectOperation returns a new DeleteTargetProjectOperation from a given name.
// The name must be that of a previously created DeleteTargetProjectOperation, possibly from a different process.
func (c *restClient) DeleteTargetProjectOperation(name string) *DeleteTargetProjectOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteTargetProjectOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteUtilizationReportOperation returns a new DeleteUtilizationReportOperation from a given name.
// The name must be that of a previously created DeleteUtilizationReportOperation, possibly from a different process.
func (c *gRPCClient) DeleteUtilizationReportOperation(name string) *DeleteUtilizationReportOperation {
	return &DeleteUtilizationReportOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteUtilizationReportOperation returns a new DeleteUtilizationReportOperation from a given name.
// The name must be that of a previously created DeleteUtilizationReportOperation, possibly from a different process.
func (c *restClient) DeleteUtilizationReportOperation(name string) *DeleteUtilizationReportOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteUtilizationReportOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// FinalizeMigrationOperation returns a new FinalizeMigrationOperation from a given name.
// The name must be that of a previously created FinalizeMigrationOperation, possibly from a different process.
func (c *gRPCClient) FinalizeMigrationOperation(name string) *FinalizeMigrationOperation {
	return &FinalizeMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// FinalizeMigrationOperation returns a new FinalizeMigrationOperation from a given name.
// The name must be that of a previously created FinalizeMigrationOperation, possibly from a different process.
func (c *restClient) FinalizeMigrationOperation(name string) *FinalizeMigrationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &FinalizeMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// PauseMigrationOperation returns a new PauseMigrationOperation from a given name.
// The name must be that of a previously created PauseMigrationOperation, possibly from a different process.
func (c *gRPCClient) PauseMigrationOperation(name string) *PauseMigrationOperation {
	return &PauseMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// PauseMigrationOperation returns a new PauseMigrationOperation from a given name.
// The name must be that of a previously created PauseMigrationOperation, possibly from a different process.
func (c *restClient) PauseMigrationOperation(name string) *PauseMigrationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &PauseMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// RemoveGroupMigrationOperation returns a new RemoveGroupMigrationOperation from a given name.
// The name must be that of a previously created RemoveGroupMigrationOperation, possibly from a different process.
func (c *gRPCClient) RemoveGroupMigrationOperation(name string) *RemoveGroupMigrationOperation {
	return &RemoveGroupMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RemoveGroupMigrationOperation returns a new RemoveGroupMigrationOperation from a given name.
// The name must be that of a previously created RemoveGroupMigrationOperation, possibly from a different process.
func (c *restClient) RemoveGroupMigrationOperation(name string) *RemoveGroupMigrationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &RemoveGroupMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ResumeMigrationOperation returns a new ResumeMigrationOperation from a given name.
// The name must be that of a previously created ResumeMigrationOperation, possibly from a different process.
func (c *gRPCClient) ResumeMigrationOperation(name string) *ResumeMigrationOperation {
	return &ResumeMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ResumeMigrationOperation returns a new ResumeMigrationOperation from a given name.
// The name must be that of a previously created ResumeMigrationOperation, possibly from a different process.
func (c *restClient) ResumeMigrationOperation(name string) *ResumeMigrationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ResumeMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// StartMigrationOperation returns a new StartMigrationOperation from a given name.
// The name must be that of a previously created StartMigrationOperation, possibly from a different process.
func (c *gRPCClient) StartMigrationOperation(name string) *StartMigrationOperation {
	return &StartMigrationOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StartMigrationOperation returns a new StartMigrationOperation from a given name.
// The name must be that of a previously created StartMigrationOperation, possibly from a different process.
func (c *restClient) StartMigrationOperation(name string) *StartMigrationOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &StartMigrationOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateGroupOperation returns a new UpdateGroupOperation from a given name.
// The name must be that of a previously created UpdateGroupOperation, possibly from a different process.
func (c *gRPCClient) UpdateGroupOperation(name string) *UpdateGroupOperation {
	return &UpdateGroupOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateGroupOperation returns a new UpdateGroupOperation from a given name.
// The name must be that of a previously created UpdateGroupOperation, possibly from a different process.
func (c *restClient) UpdateGroupOperation(name string) *UpdateGroupOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateGroupOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateMigratingVmOperation returns a new UpdateMigratingVmOperation from a given name.
// The name must be that of a previously created UpdateMigratingVmOperation, possibly from a different process.
func (c *gRPCClient) UpdateMigratingVmOperation(name string) *UpdateMigratingVmOperation {
	return &UpdateMigratingVmOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateMigratingVmOperation returns a new UpdateMigratingVmOperation from a given name.
// The name must be that of a previously created UpdateMigratingVmOperation, possibly from a different process.
func (c *restClient) UpdateMigratingVmOperation(name string) *UpdateMigratingVmOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateMigratingVmOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateSourceOperation returns a new UpdateSourceOperation from a given name.
// The name must be that of a previously created UpdateSourceOperation, possibly from a different process.
func (c *gRPCClient) UpdateSourceOperation(name string) *UpdateSourceOperation {
	return &UpdateSourceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateSourceOperation returns a new UpdateSourceOperation from a given name.
// The name must be that of a previously created UpdateSourceOperation, possibly from a different process.
func (c *restClient) UpdateSourceOperation(name string) *UpdateSourceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateSourceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateTargetProjectOperation returns a new UpdateTargetProjectOperation from a given name.
// The name must be that of a previously created UpdateTargetProjectOperation, possibly from a different process.
func (c *gRPCClient) UpdateTargetProjectOperation(name string) *UpdateTargetProjectOperation {
	return &UpdateTargetProjectOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateTargetProjectOperation returns a new UpdateTargetProjectOperation from a given name.
// The name must be that of a previously created UpdateTargetProjectOperation, possibly from a different process.
func (c *restClient) UpdateTargetProjectOperation(name string) *UpdateTargetProjectOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateTargetProjectOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpgradeApplianceOperation returns a new UpgradeApplianceOperation from a given name.
// The name must be that of a previously created UpgradeApplianceOperation, possibly from a different process.
func (c *gRPCClient) UpgradeApplianceOperation(name string) *UpgradeApplianceOperation {
	return &UpgradeApplianceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpgradeApplianceOperation returns a new UpgradeApplianceOperation from a given name.
// The name must be that of a previously created UpgradeApplianceOperation, possibly from a different process.
func (c *restClient) UpgradeApplianceOperation(name string) *UpgradeApplianceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpgradeApplianceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
