// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1/featurestore_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	interval "google.golang.org/genproto/googleapis/type/interval"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [FeaturestoreService.CreateFeaturestore][google.cloud.aiplatform.v1.FeaturestoreService.CreateFeaturestore].
type CreateFeaturestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to create Featurestores.
	// Format:
	// `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Featurestore to create.
	Featurestore *Featurestore `protobuf:"bytes,2,opt,name=featurestore,proto3" json:"featurestore,omitempty"`
	// Required. The ID to use for this Featurestore, which will become the final
	// component of the Featurestore's resource name.
	//
	// This value may be up to 60 characters, and valid characters are
	// `[a-z0-9_]`. The first character cannot be a number.
	//
	// The value must be unique within the project and location.
	FeaturestoreId string `protobuf:"bytes,3,opt,name=featurestore_id,json=featurestoreId,proto3" json:"featurestore_id,omitempty"`
}

func (x *CreateFeaturestoreRequest) Reset() {
	*x = CreateFeaturestoreRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFeaturestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeaturestoreRequest) ProtoMessage() {}

func (x *CreateFeaturestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeaturestoreRequest.ProtoReflect.Descriptor instead.
func (*CreateFeaturestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateFeaturestoreRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFeaturestoreRequest) GetFeaturestore() *Featurestore {
	if x != nil {
		return x.Featurestore
	}
	return nil
}

func (x *CreateFeaturestoreRequest) GetFeaturestoreId() string {
	if x != nil {
		return x.FeaturestoreId
	}
	return ""
}

// Request message for
// [FeaturestoreService.GetFeaturestore][google.cloud.aiplatform.v1.FeaturestoreService.GetFeaturestore].
type GetFeaturestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Featurestore resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFeaturestoreRequest) Reset() {
	*x = GetFeaturestoreRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFeaturestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFeaturestoreRequest) ProtoMessage() {}

func (x *GetFeaturestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFeaturestoreRequest.ProtoReflect.Descriptor instead.
func (*GetFeaturestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetFeaturestoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [FeaturestoreService.ListFeaturestores][google.cloud.aiplatform.v1.FeaturestoreService.ListFeaturestores].
type ListFeaturestoresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to list Featurestores.
	// Format:
	// `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Lists the featurestores that match the filter expression. The following
	// fields are supported:
	//
	// * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
	// Values must be
	//
	//	in RFC 3339 format.
	//
	// * `update_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
	// Values must be
	//
	//	in RFC 3339 format.
	//
	// * `online_serving_config.fixed_node_count`: Supports `=`, `!=`, `<`, `>`,
	// `<=`, and `>=` comparisons.
	// * `labels`: Supports key-value equality and key presence.
	//
	// Examples:
	//
	//   - `create_time > "2020-01-01" OR update_time > "2020-01-01"`
	//     Featurestores created or updated after 2020-01-01.
	//   - `labels.env = "prod"`
	//     Featurestores with label "env" set to "prod".
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of Featurestores to return. The service may return fewer
	// than this value. If unspecified, at most 100 Featurestores will be
	// returned. The maximum value is 100; any value greater than 100 will be
	// coerced to 100.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [FeaturestoreService.ListFeaturestores][google.cloud.aiplatform.v1.FeaturestoreService.ListFeaturestores]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [FeaturestoreService.ListFeaturestores][google.cloud.aiplatform.v1.FeaturestoreService.ListFeaturestores]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A comma-separated list of fields to order by, sorted in ascending order.
	// Use "desc" after a field name for descending.
	// Supported Fields:
	//
	//   - `create_time`
	//   - `update_time`
	//   - `online_serving_config.fixed_node_count`
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,6,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListFeaturestoresRequest) Reset() {
	*x = ListFeaturestoresRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeaturestoresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeaturestoresRequest) ProtoMessage() {}

func (x *ListFeaturestoresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeaturestoresRequest.ProtoReflect.Descriptor instead.
func (*ListFeaturestoresRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListFeaturestoresRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFeaturestoresRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFeaturestoresRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFeaturestoresRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFeaturestoresRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListFeaturestoresRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [FeaturestoreService.ListFeaturestores][google.cloud.aiplatform.v1.FeaturestoreService.ListFeaturestores].
type ListFeaturestoresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Featurestores matching the request.
	Featurestores []*Featurestore `protobuf:"bytes,1,rep,name=featurestores,proto3" json:"featurestores,omitempty"`
	// A token, which can be sent as
	// [ListFeaturestoresRequest.page_token][google.cloud.aiplatform.v1.ListFeaturestoresRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFeaturestoresResponse) Reset() {
	*x = ListFeaturestoresResponse{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeaturestoresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeaturestoresResponse) ProtoMessage() {}

func (x *ListFeaturestoresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeaturestoresResponse.ProtoReflect.Descriptor instead.
func (*ListFeaturestoresResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListFeaturestoresResponse) GetFeaturestores() []*Featurestore {
	if x != nil {
		return x.Featurestores
	}
	return nil
}

func (x *ListFeaturestoresResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [FeaturestoreService.UpdateFeaturestore][google.cloud.aiplatform.v1.FeaturestoreService.UpdateFeaturestore].
type UpdateFeaturestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Featurestore's `name` field is used to identify the
	// Featurestore to be updated. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}`
	Featurestore *Featurestore `protobuf:"bytes,1,opt,name=featurestore,proto3" json:"featurestore,omitempty"`
	// Field mask is used to specify the fields to be overwritten in the
	// Featurestore resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then only the non-empty fields present in the
	// request will be overwritten. Set the update_mask to `*` to override all
	// fields.
	//
	// Updatable fields:
	//
	//   - `labels`
	//   - `online_serving_config.fixed_node_count`
	//   - `online_serving_config.scaling`
	//   - `online_storage_ttl_days`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFeaturestoreRequest) Reset() {
	*x = UpdateFeaturestoreRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFeaturestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFeaturestoreRequest) ProtoMessage() {}

func (x *UpdateFeaturestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFeaturestoreRequest.ProtoReflect.Descriptor instead.
func (*UpdateFeaturestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateFeaturestoreRequest) GetFeaturestore() *Featurestore {
	if x != nil {
		return x.Featurestore
	}
	return nil
}

func (x *UpdateFeaturestoreRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [FeaturestoreService.DeleteFeaturestore][google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeaturestore].
type DeleteFeaturestoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Featurestore to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, any EntityTypes and Features for this Featurestore will
	// also be deleted. (Otherwise, the request will only work if the Featurestore
	// has no EntityTypes.)
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteFeaturestoreRequest) Reset() {
	*x = DeleteFeaturestoreRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeaturestoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeaturestoreRequest) ProtoMessage() {}

func (x *DeleteFeaturestoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeaturestoreRequest.ProtoReflect.Descriptor instead.
func (*DeleteFeaturestoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteFeaturestoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteFeaturestoreRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for
// [FeaturestoreService.ImportFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.ImportFeatureValues].
type ImportFeatureValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details about the source data, including the location of the storage and
	// the format.
	//
	// Types that are assignable to Source:
	//
	//	*ImportFeatureValuesRequest_AvroSource
	//	*ImportFeatureValuesRequest_BigquerySource
	//	*ImportFeatureValuesRequest_CsvSource
	Source isImportFeatureValuesRequest_Source `protobuf_oneof:"source"`
	// Source of Feature timestamp for all Feature values of each entity.
	// Timestamps must be millisecond-aligned.
	//
	// Types that are assignable to FeatureTimeSource:
	//
	//	*ImportFeatureValuesRequest_FeatureTimeField
	//	*ImportFeatureValuesRequest_FeatureTime
	FeatureTimeSource isImportFeatureValuesRequest_FeatureTimeSource `protobuf_oneof:"feature_time_source"`
	// Required. The resource name of the EntityType grouping the Features for
	// which values are being imported. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
	EntityType string `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Source column that holds entity IDs. If not provided, entity IDs are
	// extracted from the column named entity_id.
	EntityIdField string `protobuf:"bytes,5,opt,name=entity_id_field,json=entityIdField,proto3" json:"entity_id_field,omitempty"`
	// Required. Specifications defining which Feature values to import from the
	// entity. The request fails if no feature_specs are provided, and having
	// multiple feature_specs for one Feature is not allowed.
	FeatureSpecs []*ImportFeatureValuesRequest_FeatureSpec `protobuf:"bytes,8,rep,name=feature_specs,json=featureSpecs,proto3" json:"feature_specs,omitempty"`
	// If set, data will not be imported for online serving. This
	// is typically used for backfilling, where Feature generation timestamps are
	// not in the timestamp range needed for online serving.
	DisableOnlineServing bool `protobuf:"varint,9,opt,name=disable_online_serving,json=disableOnlineServing,proto3" json:"disable_online_serving,omitempty"`
	// Specifies the number of workers that are used to write data to the
	// Featurestore. Consider the online serving capacity that you require to
	// achieve the desired import throughput without interfering with online
	// serving. The value must be positive, and less than or equal to 100.
	// If not set, defaults to using 1 worker. The low count ensures minimal
	// impact on online serving performance.
	WorkerCount int32 `protobuf:"varint,11,opt,name=worker_count,json=workerCount,proto3" json:"worker_count,omitempty"`
	// If true, API doesn't start ingestion analysis pipeline.
	DisableIngestionAnalysis bool `protobuf:"varint,12,opt,name=disable_ingestion_analysis,json=disableIngestionAnalysis,proto3" json:"disable_ingestion_analysis,omitempty"`
}

func (x *ImportFeatureValuesRequest) Reset() {
	*x = ImportFeatureValuesRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportFeatureValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportFeatureValuesRequest) ProtoMessage() {}

func (x *ImportFeatureValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportFeatureValuesRequest.ProtoReflect.Descriptor instead.
func (*ImportFeatureValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{6}
}

func (m *ImportFeatureValuesRequest) GetSource() isImportFeatureValuesRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImportFeatureValuesRequest) GetAvroSource() *AvroSource {
	if x, ok := x.GetSource().(*ImportFeatureValuesRequest_AvroSource); ok {
		return x.AvroSource
	}
	return nil
}

func (x *ImportFeatureValuesRequest) GetBigquerySource() *BigQuerySource {
	if x, ok := x.GetSource().(*ImportFeatureValuesRequest_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (x *ImportFeatureValuesRequest) GetCsvSource() *CsvSource {
	if x, ok := x.GetSource().(*ImportFeatureValuesRequest_CsvSource); ok {
		return x.CsvSource
	}
	return nil
}

func (m *ImportFeatureValuesRequest) GetFeatureTimeSource() isImportFeatureValuesRequest_FeatureTimeSource {
	if m != nil {
		return m.FeatureTimeSource
	}
	return nil
}

func (x *ImportFeatureValuesRequest) GetFeatureTimeField() string {
	if x, ok := x.GetFeatureTimeSource().(*ImportFeatureValuesRequest_FeatureTimeField); ok {
		return x.FeatureTimeField
	}
	return ""
}

func (x *ImportFeatureValuesRequest) GetFeatureTime() *timestamppb.Timestamp {
	if x, ok := x.GetFeatureTimeSource().(*ImportFeatureValuesRequest_FeatureTime); ok {
		return x.FeatureTime
	}
	return nil
}

func (x *ImportFeatureValuesRequest) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

func (x *ImportFeatureValuesRequest) GetEntityIdField() string {
	if x != nil {
		return x.EntityIdField
	}
	return ""
}

func (x *ImportFeatureValuesRequest) GetFeatureSpecs() []*ImportFeatureValuesRequest_FeatureSpec {
	if x != nil {
		return x.FeatureSpecs
	}
	return nil
}

func (x *ImportFeatureValuesRequest) GetDisableOnlineServing() bool {
	if x != nil {
		return x.DisableOnlineServing
	}
	return false
}

func (x *ImportFeatureValuesRequest) GetWorkerCount() int32 {
	if x != nil {
		return x.WorkerCount
	}
	return 0
}

func (x *ImportFeatureValuesRequest) GetDisableIngestionAnalysis() bool {
	if x != nil {
		return x.DisableIngestionAnalysis
	}
	return false
}

type isImportFeatureValuesRequest_Source interface {
	isImportFeatureValuesRequest_Source()
}

type ImportFeatureValuesRequest_AvroSource struct {
	AvroSource *AvroSource `protobuf:"bytes,2,opt,name=avro_source,json=avroSource,proto3,oneof"`
}

type ImportFeatureValuesRequest_BigquerySource struct {
	BigquerySource *BigQuerySource `protobuf:"bytes,3,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

type ImportFeatureValuesRequest_CsvSource struct {
	CsvSource *CsvSource `protobuf:"bytes,4,opt,name=csv_source,json=csvSource,proto3,oneof"`
}

func (*ImportFeatureValuesRequest_AvroSource) isImportFeatureValuesRequest_Source() {}

func (*ImportFeatureValuesRequest_BigquerySource) isImportFeatureValuesRequest_Source() {}

func (*ImportFeatureValuesRequest_CsvSource) isImportFeatureValuesRequest_Source() {}

type isImportFeatureValuesRequest_FeatureTimeSource interface {
	isImportFeatureValuesRequest_FeatureTimeSource()
}

type ImportFeatureValuesRequest_FeatureTimeField struct {
	// Source column that holds the Feature timestamp for all Feature
	// values in each entity.
	FeatureTimeField string `protobuf:"bytes,6,opt,name=feature_time_field,json=featureTimeField,proto3,oneof"`
}

type ImportFeatureValuesRequest_FeatureTime struct {
	// Single Feature timestamp for all entities being imported. The
	// timestamp must not have higher than millisecond precision.
	FeatureTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=feature_time,json=featureTime,proto3,oneof"`
}

func (*ImportFeatureValuesRequest_FeatureTimeField) isImportFeatureValuesRequest_FeatureTimeSource() {
}

func (*ImportFeatureValuesRequest_FeatureTime) isImportFeatureValuesRequest_FeatureTimeSource() {}

// Response message for
// [FeaturestoreService.ImportFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.ImportFeatureValues].
type ImportFeatureValuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of entities that have been imported by the operation.
	ImportedEntityCount int64 `protobuf:"varint,1,opt,name=imported_entity_count,json=importedEntityCount,proto3" json:"imported_entity_count,omitempty"`
	// Number of Feature values that have been imported by the operation.
	ImportedFeatureValueCount int64 `protobuf:"varint,2,opt,name=imported_feature_value_count,json=importedFeatureValueCount,proto3" json:"imported_feature_value_count,omitempty"`
	// The number of rows in input source that weren't imported due to either
	// * Not having any featureValues.
	// * Having a null entityId.
	// * Having a null timestamp.
	// * Not being parsable (applicable for CSV sources).
	InvalidRowCount int64 `protobuf:"varint,6,opt,name=invalid_row_count,json=invalidRowCount,proto3" json:"invalid_row_count,omitempty"`
	// The number rows that weren't ingested due to having feature timestamps
	// outside the retention boundary.
	TimestampOutsideRetentionRowsCount int64 `protobuf:"varint,4,opt,name=timestamp_outside_retention_rows_count,json=timestampOutsideRetentionRowsCount,proto3" json:"timestamp_outside_retention_rows_count,omitempty"`
}

func (x *ImportFeatureValuesResponse) Reset() {
	*x = ImportFeatureValuesResponse{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportFeatureValuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportFeatureValuesResponse) ProtoMessage() {}

func (x *ImportFeatureValuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportFeatureValuesResponse.ProtoReflect.Descriptor instead.
func (*ImportFeatureValuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{7}
}

func (x *ImportFeatureValuesResponse) GetImportedEntityCount() int64 {
	if x != nil {
		return x.ImportedEntityCount
	}
	return 0
}

func (x *ImportFeatureValuesResponse) GetImportedFeatureValueCount() int64 {
	if x != nil {
		return x.ImportedFeatureValueCount
	}
	return 0
}

func (x *ImportFeatureValuesResponse) GetInvalidRowCount() int64 {
	if x != nil {
		return x.InvalidRowCount
	}
	return 0
}

func (x *ImportFeatureValuesResponse) GetTimestampOutsideRetentionRowsCount() int64 {
	if x != nil {
		return x.TimestampOutsideRetentionRowsCount
	}
	return 0
}

// Request message for
// [FeaturestoreService.BatchReadFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.BatchReadFeatureValues].
type BatchReadFeatureValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ReadOption:
	//
	//	*BatchReadFeatureValuesRequest_CsvReadInstances
	//	*BatchReadFeatureValuesRequest_BigqueryReadInstances
	ReadOption isBatchReadFeatureValuesRequest_ReadOption `protobuf_oneof:"read_option"`
	// Required. The resource name of the Featurestore from which to query Feature
	// values. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}`
	Featurestore string `protobuf:"bytes,1,opt,name=featurestore,proto3" json:"featurestore,omitempty"`
	// Required. Specifies output location and format.
	Destination *FeatureValueDestination `protobuf:"bytes,4,opt,name=destination,proto3" json:"destination,omitempty"`
	// When not empty, the specified fields in the *_read_instances source will be
	// joined as-is in the output, in addition to those fields from the
	// Featurestore Entity.
	//
	// For BigQuery source, the type of the pass-through values will be
	// automatically inferred. For CSV source, the pass-through values will be
	// passed as opaque bytes.
	PassThroughFields []*BatchReadFeatureValuesRequest_PassThroughField `protobuf:"bytes,8,rep,name=pass_through_fields,json=passThroughFields,proto3" json:"pass_through_fields,omitempty"`
	// Required. Specifies EntityType grouping Features to read values of and
	// settings.
	EntityTypeSpecs []*BatchReadFeatureValuesRequest_EntityTypeSpec `protobuf:"bytes,7,rep,name=entity_type_specs,json=entityTypeSpecs,proto3" json:"entity_type_specs,omitempty"`
	// Optional. Excludes Feature values with feature generation timestamp before
	// this timestamp. If not set, retrieve oldest values kept in Feature Store.
	// Timestamp, if present, must not have higher than millisecond precision.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *BatchReadFeatureValuesRequest) Reset() {
	*x = BatchReadFeatureValuesRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchReadFeatureValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchReadFeatureValuesRequest) ProtoMessage() {}

func (x *BatchReadFeatureValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchReadFeatureValuesRequest.ProtoReflect.Descriptor instead.
func (*BatchReadFeatureValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{8}
}

func (m *BatchReadFeatureValuesRequest) GetReadOption() isBatchReadFeatureValuesRequest_ReadOption {
	if m != nil {
		return m.ReadOption
	}
	return nil
}

func (x *BatchReadFeatureValuesRequest) GetCsvReadInstances() *CsvSource {
	if x, ok := x.GetReadOption().(*BatchReadFeatureValuesRequest_CsvReadInstances); ok {
		return x.CsvReadInstances
	}
	return nil
}

func (x *BatchReadFeatureValuesRequest) GetBigqueryReadInstances() *BigQuerySource {
	if x, ok := x.GetReadOption().(*BatchReadFeatureValuesRequest_BigqueryReadInstances); ok {
		return x.BigqueryReadInstances
	}
	return nil
}

func (x *BatchReadFeatureValuesRequest) GetFeaturestore() string {
	if x != nil {
		return x.Featurestore
	}
	return ""
}

func (x *BatchReadFeatureValuesRequest) GetDestination() *FeatureValueDestination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *BatchReadFeatureValuesRequest) GetPassThroughFields() []*BatchReadFeatureValuesRequest_PassThroughField {
	if x != nil {
		return x.PassThroughFields
	}
	return nil
}

func (x *BatchReadFeatureValuesRequest) GetEntityTypeSpecs() []*BatchReadFeatureValuesRequest_EntityTypeSpec {
	if x != nil {
		return x.EntityTypeSpecs
	}
	return nil
}

func (x *BatchReadFeatureValuesRequest) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

type isBatchReadFeatureValuesRequest_ReadOption interface {
	isBatchReadFeatureValuesRequest_ReadOption()
}

type BatchReadFeatureValuesRequest_CsvReadInstances struct {
	// Each read instance consists of exactly one read timestamp and one or more
	// entity IDs identifying entities of the corresponding EntityTypes whose
	// Features are requested.
	//
	// Each output instance contains Feature values of requested entities
	// concatenated together as of the read time.
	//
	// An example read instance may be `foo_entity_id, bar_entity_id,
	// 2020-01-01T10:00:00.123Z`.
	//
	// An example output instance may be `foo_entity_id, bar_entity_id,
	// 2020-01-01T10:00:00.123Z, foo_entity_feature1_value,
	// bar_entity_feature2_value`.
	//
	// Timestamp in each read instance must be millisecond-aligned.
	//
	// `csv_read_instances` are read instances stored in a plain-text CSV file.
	// The header should be:
	//
	//	[ENTITY_TYPE_ID1], [ENTITY_TYPE_ID2], ..., timestamp
	//
	// The columns can be in any order.
	//
	// Values in the timestamp column must use the RFC 3339 format, e.g.
	// `2012-07-30T10:43:17.123Z`.
	CsvReadInstances *CsvSource `protobuf:"bytes,3,opt,name=csv_read_instances,json=csvReadInstances,proto3,oneof"`
}

type BatchReadFeatureValuesRequest_BigqueryReadInstances struct {
	// Similar to csv_read_instances, but from BigQuery source.
	BigqueryReadInstances *BigQuerySource `protobuf:"bytes,5,opt,name=bigquery_read_instances,json=bigqueryReadInstances,proto3,oneof"`
}

func (*BatchReadFeatureValuesRequest_CsvReadInstances) isBatchReadFeatureValuesRequest_ReadOption() {}

func (*BatchReadFeatureValuesRequest_BigqueryReadInstances) isBatchReadFeatureValuesRequest_ReadOption() {
}

// Request message for
// [FeaturestoreService.ExportFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.ExportFeatureValues].
type ExportFeatureValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The mode in which Feature values are exported.
	//
	// Types that are assignable to Mode:
	//
	//	*ExportFeatureValuesRequest_SnapshotExport_
	//	*ExportFeatureValuesRequest_FullExport_
	Mode isExportFeatureValuesRequest_Mode `protobuf_oneof:"mode"`
	// Required. The resource name of the EntityType from which to export Feature
	// values. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
	EntityType string `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Required. Specifies destination location and format.
	Destination *FeatureValueDestination `protobuf:"bytes,4,opt,name=destination,proto3" json:"destination,omitempty"`
	// Required. Selects Features to export values of.
	FeatureSelector *FeatureSelector `protobuf:"bytes,5,opt,name=feature_selector,json=featureSelector,proto3" json:"feature_selector,omitempty"`
	// Per-Feature export settings.
	Settings []*DestinationFeatureSetting `protobuf:"bytes,6,rep,name=settings,proto3" json:"settings,omitempty"`
}

func (x *ExportFeatureValuesRequest) Reset() {
	*x = ExportFeatureValuesRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportFeatureValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportFeatureValuesRequest) ProtoMessage() {}

func (x *ExportFeatureValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportFeatureValuesRequest.ProtoReflect.Descriptor instead.
func (*ExportFeatureValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{9}
}

func (m *ExportFeatureValuesRequest) GetMode() isExportFeatureValuesRequest_Mode {
	if m != nil {
		return m.Mode
	}
	return nil
}

func (x *ExportFeatureValuesRequest) GetSnapshotExport() *ExportFeatureValuesRequest_SnapshotExport {
	if x, ok := x.GetMode().(*ExportFeatureValuesRequest_SnapshotExport_); ok {
		return x.SnapshotExport
	}
	return nil
}

func (x *ExportFeatureValuesRequest) GetFullExport() *ExportFeatureValuesRequest_FullExport {
	if x, ok := x.GetMode().(*ExportFeatureValuesRequest_FullExport_); ok {
		return x.FullExport
	}
	return nil
}

func (x *ExportFeatureValuesRequest) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

func (x *ExportFeatureValuesRequest) GetDestination() *FeatureValueDestination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *ExportFeatureValuesRequest) GetFeatureSelector() *FeatureSelector {
	if x != nil {
		return x.FeatureSelector
	}
	return nil
}

func (x *ExportFeatureValuesRequest) GetSettings() []*DestinationFeatureSetting {
	if x != nil {
		return x.Settings
	}
	return nil
}

type isExportFeatureValuesRequest_Mode interface {
	isExportFeatureValuesRequest_Mode()
}

type ExportFeatureValuesRequest_SnapshotExport_ struct {
	// Exports the latest Feature values of all entities of the EntityType
	// within a time range.
	SnapshotExport *ExportFeatureValuesRequest_SnapshotExport `protobuf:"bytes,3,opt,name=snapshot_export,json=snapshotExport,proto3,oneof"`
}

type ExportFeatureValuesRequest_FullExport_ struct {
	// Exports all historical values of all entities of the EntityType within a
	// time range
	FullExport *ExportFeatureValuesRequest_FullExport `protobuf:"bytes,7,opt,name=full_export,json=fullExport,proto3,oneof"`
}

func (*ExportFeatureValuesRequest_SnapshotExport_) isExportFeatureValuesRequest_Mode() {}

func (*ExportFeatureValuesRequest_FullExport_) isExportFeatureValuesRequest_Mode() {}

type DestinationFeatureSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Feature to apply the setting to.
	FeatureId string `protobuf:"bytes,1,opt,name=feature_id,json=featureId,proto3" json:"feature_id,omitempty"`
	// Specify the field name in the export destination. If not specified,
	// Feature ID is used.
	DestinationField string `protobuf:"bytes,2,opt,name=destination_field,json=destinationField,proto3" json:"destination_field,omitempty"`
}

func (x *DestinationFeatureSetting) Reset() {
	*x = DestinationFeatureSetting{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DestinationFeatureSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationFeatureSetting) ProtoMessage() {}

func (x *DestinationFeatureSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationFeatureSetting.ProtoReflect.Descriptor instead.
func (*DestinationFeatureSetting) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{10}
}

func (x *DestinationFeatureSetting) GetFeatureId() string {
	if x != nil {
		return x.FeatureId
	}
	return ""
}

func (x *DestinationFeatureSetting) GetDestinationField() string {
	if x != nil {
		return x.DestinationField
	}
	return ""
}

// A destination location for Feature values and format.
type FeatureValueDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Destination:
	//
	//	*FeatureValueDestination_BigqueryDestination
	//	*FeatureValueDestination_TfrecordDestination
	//	*FeatureValueDestination_CsvDestination
	Destination isFeatureValueDestination_Destination `protobuf_oneof:"destination"`
}

func (x *FeatureValueDestination) Reset() {
	*x = FeatureValueDestination{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureValueDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureValueDestination) ProtoMessage() {}

func (x *FeatureValueDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureValueDestination.ProtoReflect.Descriptor instead.
func (*FeatureValueDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{11}
}

func (m *FeatureValueDestination) GetDestination() isFeatureValueDestination_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *FeatureValueDestination) GetBigqueryDestination() *BigQueryDestination {
	if x, ok := x.GetDestination().(*FeatureValueDestination_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

func (x *FeatureValueDestination) GetTfrecordDestination() *TFRecordDestination {
	if x, ok := x.GetDestination().(*FeatureValueDestination_TfrecordDestination); ok {
		return x.TfrecordDestination
	}
	return nil
}

func (x *FeatureValueDestination) GetCsvDestination() *CsvDestination {
	if x, ok := x.GetDestination().(*FeatureValueDestination_CsvDestination); ok {
		return x.CsvDestination
	}
	return nil
}

type isFeatureValueDestination_Destination interface {
	isFeatureValueDestination_Destination()
}

type FeatureValueDestination_BigqueryDestination struct {
	// Output in BigQuery format.
	// [BigQueryDestination.output_uri][google.cloud.aiplatform.v1.BigQueryDestination.output_uri]
	// in
	// [FeatureValueDestination.bigquery_destination][google.cloud.aiplatform.v1.FeatureValueDestination.bigquery_destination]
	// must refer to a table.
	BigqueryDestination *BigQueryDestination `protobuf:"bytes,1,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

type FeatureValueDestination_TfrecordDestination struct {
	// Output in TFRecord format.
	//
	// Below are the mapping from Feature value type
	// in Featurestore to Feature value type in TFRecord:
	//
	//	Value type in Featurestore                 | Value type in TFRecord
	//	DOUBLE, DOUBLE_ARRAY                       | FLOAT_LIST
	//	INT64, INT64_ARRAY                         | INT64_LIST
	//	STRING, STRING_ARRAY, BYTES                | BYTES_LIST
	//	true -> byte_string("true"), false -> byte_string("false")
	//	BOOL, BOOL_ARRAY (true, false)             | BYTES_LIST
	TfrecordDestination *TFRecordDestination `protobuf:"bytes,2,opt,name=tfrecord_destination,json=tfrecordDestination,proto3,oneof"`
}

type FeatureValueDestination_CsvDestination struct {
	// Output in CSV format. Array Feature value types are not allowed in CSV
	// format.
	CsvDestination *CsvDestination `protobuf:"bytes,3,opt,name=csv_destination,json=csvDestination,proto3,oneof"`
}

func (*FeatureValueDestination_BigqueryDestination) isFeatureValueDestination_Destination() {}

func (*FeatureValueDestination_TfrecordDestination) isFeatureValueDestination_Destination() {}

func (*FeatureValueDestination_CsvDestination) isFeatureValueDestination_Destination() {}

// Response message for
// [FeaturestoreService.ExportFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.ExportFeatureValues].
type ExportFeatureValuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportFeatureValuesResponse) Reset() {
	*x = ExportFeatureValuesResponse{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportFeatureValuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportFeatureValuesResponse) ProtoMessage() {}

func (x *ExportFeatureValuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportFeatureValuesResponse.ProtoReflect.Descriptor instead.
func (*ExportFeatureValuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{12}
}

// Response message for
// [FeaturestoreService.BatchReadFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.BatchReadFeatureValues].
type BatchReadFeatureValuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BatchReadFeatureValuesResponse) Reset() {
	*x = BatchReadFeatureValuesResponse{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchReadFeatureValuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchReadFeatureValuesResponse) ProtoMessage() {}

func (x *BatchReadFeatureValuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchReadFeatureValuesResponse.ProtoReflect.Descriptor instead.
func (*BatchReadFeatureValuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{13}
}

// Request message for
// [FeaturestoreService.CreateEntityType][google.cloud.aiplatform.v1.FeaturestoreService.CreateEntityType].
type CreateEntityTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Featurestore to create EntityTypes.
	// Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The EntityType to create.
	EntityType *EntityType `protobuf:"bytes,2,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Required. The ID to use for the EntityType, which will become the final
	// component of the EntityType's resource name.
	//
	// This value may be up to 60 characters, and valid characters are
	// `[a-z0-9_]`. The first character cannot be a number.
	//
	// The value must be unique within a featurestore.
	EntityTypeId string `protobuf:"bytes,3,opt,name=entity_type_id,json=entityTypeId,proto3" json:"entity_type_id,omitempty"`
}

func (x *CreateEntityTypeRequest) Reset() {
	*x = CreateEntityTypeRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEntityTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntityTypeRequest) ProtoMessage() {}

func (x *CreateEntityTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntityTypeRequest.ProtoReflect.Descriptor instead.
func (*CreateEntityTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{14}
}

func (x *CreateEntityTypeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntityTypeRequest) GetEntityType() *EntityType {
	if x != nil {
		return x.EntityType
	}
	return nil
}

func (x *CreateEntityTypeRequest) GetEntityTypeId() string {
	if x != nil {
		return x.EntityTypeId
	}
	return ""
}

// Request message for
// [FeaturestoreService.GetEntityType][google.cloud.aiplatform.v1.FeaturestoreService.GetEntityType].
type GetEntityTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the EntityType resource.
	// Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntityTypeRequest) Reset() {
	*x = GetEntityTypeRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEntityTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntityTypeRequest) ProtoMessage() {}

func (x *GetEntityTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntityTypeRequest.ProtoReflect.Descriptor instead.
func (*GetEntityTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{15}
}

func (x *GetEntityTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [FeaturestoreService.ListEntityTypes][google.cloud.aiplatform.v1.FeaturestoreService.ListEntityTypes].
type ListEntityTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Featurestore to list EntityTypes.
	// Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Lists the EntityTypes that match the filter expression. The following
	// filters are supported:
	//
	// * `create_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
	// Values must be in RFC 3339 format.
	// * `update_time`: Supports `=`, `!=`, `<`, `>`, `>=`, and `<=` comparisons.
	// Values must be in RFC 3339 format.
	// * `labels`: Supports key-value equality as well as key presence.
	//
	// Examples:
	//
	//   - `create_time > \"2020-01-31T15:30:00.000000Z\" OR
	//     update_time > \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created
	//     or updated after 2020-01-31T15:30:00.000000Z.
	//   - `labels.active = yes AND labels.env = prod` --> EntityTypes having both
	//     (active: yes) and (env: prod) labels.
	//   - `labels.env: *` --> Any EntityType which has a label with 'env' as the
	//     key.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of EntityTypes to return. The service may return fewer
	// than this value. If unspecified, at most 1000 EntityTypes will be returned.
	// The maximum value is 1000; any value greater than 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [FeaturestoreService.ListEntityTypes][google.cloud.aiplatform.v1.FeaturestoreService.ListEntityTypes]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [FeaturestoreService.ListEntityTypes][google.cloud.aiplatform.v1.FeaturestoreService.ListEntityTypes]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A comma-separated list of fields to order by, sorted in ascending order.
	// Use "desc" after a field name for descending.
	//
	// Supported fields:
	//
	//   - `entity_type_id`
	//   - `create_time`
	//   - `update_time`
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,6,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *ListEntityTypesRequest) Reset() {
	*x = ListEntityTypesRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntityTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntityTypesRequest) ProtoMessage() {}

func (x *ListEntityTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntityTypesRequest.ProtoReflect.Descriptor instead.
func (*ListEntityTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{16}
}

func (x *ListEntityTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntityTypesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEntityTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntityTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntityTypesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListEntityTypesRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Response message for
// [FeaturestoreService.ListEntityTypes][google.cloud.aiplatform.v1.FeaturestoreService.ListEntityTypes].
type ListEntityTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The EntityTypes matching the request.
	EntityTypes []*EntityType `protobuf:"bytes,1,rep,name=entity_types,json=entityTypes,proto3" json:"entity_types,omitempty"`
	// A token, which can be sent as
	// [ListEntityTypesRequest.page_token][google.cloud.aiplatform.v1.ListEntityTypesRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntityTypesResponse) Reset() {
	*x = ListEntityTypesResponse{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntityTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntityTypesResponse) ProtoMessage() {}

func (x *ListEntityTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntityTypesResponse.ProtoReflect.Descriptor instead.
func (*ListEntityTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{17}
}

func (x *ListEntityTypesResponse) GetEntityTypes() []*EntityType {
	if x != nil {
		return x.EntityTypes
	}
	return nil
}

func (x *ListEntityTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [FeaturestoreService.UpdateEntityType][google.cloud.aiplatform.v1.FeaturestoreService.UpdateEntityType].
type UpdateEntityTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The EntityType's `name` field is used to identify the EntityType
	// to be updated. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
	EntityType *EntityType `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Field mask is used to specify the fields to be overwritten in the
	// EntityType resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then only the non-empty fields present in the
	// request will be overwritten. Set the update_mask to `*` to override all
	// fields.
	//
	// Updatable fields:
	//
	//   - `description`
	//   - `labels`
	//   - `monitoring_config.snapshot_analysis.disabled`
	//   - `monitoring_config.snapshot_analysis.monitoring_interval_days`
	//   - `monitoring_config.snapshot_analysis.staleness_days`
	//   - `monitoring_config.import_features_analysis.state`
	//   - `monitoring_config.import_features_analysis.anomaly_detection_baseline`
	//   - `monitoring_config.numerical_threshold_config.value`
	//   - `monitoring_config.categorical_threshold_config.value`
	//   - `offline_storage_ttl_days`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEntityTypeRequest) Reset() {
	*x = UpdateEntityTypeRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateEntityTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntityTypeRequest) ProtoMessage() {}

func (x *UpdateEntityTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntityTypeRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntityTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{18}
}

func (x *UpdateEntityTypeRequest) GetEntityType() *EntityType {
	if x != nil {
		return x.EntityType
	}
	return nil
}

func (x *UpdateEntityTypeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [FeaturestoreService.DeleteEntityType][google.cloud.aiplatform.v1.FeaturestoreService.DeleteEntityType].
type DeleteEntityTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the EntityType to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, any Features for this EntityType will also be deleted.
	// (Otherwise, the request will only work if the EntityType has no Features.)
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteEntityTypeRequest) Reset() {
	*x = DeleteEntityTypeRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteEntityTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntityTypeRequest) ProtoMessage() {}

func (x *DeleteEntityTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntityTypeRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntityTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteEntityTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEntityTypeRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for
// [FeaturestoreService.CreateFeature][google.cloud.aiplatform.v1.FeaturestoreService.CreateFeature].
// Request message for
// [FeatureRegistryService.CreateFeature][google.cloud.aiplatform.v1.FeatureRegistryService.CreateFeature].
type CreateFeatureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntityType or FeatureGroup to create a
	// Feature. Format for entity_type as parent:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
	// Format for feature_group as parent:
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Feature to create.
	Feature *Feature `protobuf:"bytes,2,opt,name=feature,proto3" json:"feature,omitempty"`
	// Required. The ID to use for the Feature, which will become the final
	// component of the Feature's resource name.
	//
	// This value may be up to 128 characters, and valid characters are
	// `[a-z0-9_]`. The first character cannot be a number.
	//
	// The value must be unique within an EntityType/FeatureGroup.
	FeatureId string `protobuf:"bytes,3,opt,name=feature_id,json=featureId,proto3" json:"feature_id,omitempty"`
}

func (x *CreateFeatureRequest) Reset() {
	*x = CreateFeatureRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFeatureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeatureRequest) ProtoMessage() {}

func (x *CreateFeatureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeatureRequest.ProtoReflect.Descriptor instead.
func (*CreateFeatureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{20}
}

func (x *CreateFeatureRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFeatureRequest) GetFeature() *Feature {
	if x != nil {
		return x.Feature
	}
	return nil
}

func (x *CreateFeatureRequest) GetFeatureId() string {
	if x != nil {
		return x.FeatureId
	}
	return ""
}

// Request message for
// [FeaturestoreService.BatchCreateFeatures][google.cloud.aiplatform.v1.FeaturestoreService.BatchCreateFeatures].
// Request message for
// [FeatureRegistryService.BatchCreateFeatures][google.cloud.aiplatform.v1.FeatureRegistryService.BatchCreateFeatures].
type BatchCreateFeaturesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntityType/FeatureGroup to create the
	// batch of Features under. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request message specifying the Features to create. All
	// Features must be created under the same parent EntityType / FeatureGroup.
	// The `parent` field in each child request message can be omitted. If
	// `parent` is set in a child request, then the value must match the `parent`
	// value in this request message.
	Requests []*CreateFeatureRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateFeaturesRequest) Reset() {
	*x = BatchCreateFeaturesRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchCreateFeaturesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateFeaturesRequest) ProtoMessage() {}

func (x *BatchCreateFeaturesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateFeaturesRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateFeaturesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{21}
}

func (x *BatchCreateFeaturesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateFeaturesRequest) GetRequests() []*CreateFeatureRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Response message for
// [FeaturestoreService.BatchCreateFeatures][google.cloud.aiplatform.v1.FeaturestoreService.BatchCreateFeatures].
type BatchCreateFeaturesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Features created.
	Features []*Feature `protobuf:"bytes,1,rep,name=features,proto3" json:"features,omitempty"`
}

func (x *BatchCreateFeaturesResponse) Reset() {
	*x = BatchCreateFeaturesResponse{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchCreateFeaturesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateFeaturesResponse) ProtoMessage() {}

func (x *BatchCreateFeaturesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateFeaturesResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateFeaturesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{22}
}

func (x *BatchCreateFeaturesResponse) GetFeatures() []*Feature {
	if x != nil {
		return x.Features
	}
	return nil
}

// Request message for
// [FeaturestoreService.GetFeature][google.cloud.aiplatform.v1.FeaturestoreService.GetFeature].
// Request message for
// [FeatureRegistryService.GetFeature][google.cloud.aiplatform.v1.FeatureRegistryService.GetFeature].
type GetFeatureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Feature resource.
	// Format for entity_type as parent:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
	// Format for feature_group as parent:
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFeatureRequest) Reset() {
	*x = GetFeatureRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFeatureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFeatureRequest) ProtoMessage() {}

func (x *GetFeatureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFeatureRequest.ProtoReflect.Descriptor instead.
func (*GetFeatureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{23}
}

func (x *GetFeatureRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [FeaturestoreService.ListFeatures][google.cloud.aiplatform.v1.FeaturestoreService.ListFeatures].
// Request message for
// [FeatureRegistryService.ListFeatures][google.cloud.aiplatform.v1.FeatureRegistryService.ListFeatures].
type ListFeaturesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to list Features.
	// Format for entity_type as parent:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}`
	// Format for feature_group as parent:
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Lists the Features that match the filter expression. The following
	// filters are supported:
	//
	// * `value_type`: Supports = and != comparisons.
	// * `create_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
	// be in RFC 3339 format.
	// * `update_time`: Supports =, !=, <, >, >=, and <= comparisons. Values must
	// be in RFC 3339 format.
	// * `labels`: Supports key-value equality as well as key presence.
	//
	// Examples:
	//
	//   - `value_type = DOUBLE` --> Features whose type is DOUBLE.
	//   - `create_time > \"2020-01-31T15:30:00.000000Z\" OR
	//     update_time > \"2020-01-31T15:30:00.000000Z\"` --> EntityTypes created
	//     or updated after 2020-01-31T15:30:00.000000Z.
	//   - `labels.active = yes AND labels.env = prod` --> Features having both
	//     (active: yes) and (env: prod) labels.
	//   - `labels.env: *` --> Any Feature which has a label with 'env' as the
	//     key.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of Features to return. The service may return fewer
	// than this value. If unspecified, at most 1000 Features will be returned.
	// The maximum value is 1000; any value greater than 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [FeaturestoreService.ListFeatures][google.cloud.aiplatform.v1.FeaturestoreService.ListFeatures]
	// call or
	// [FeatureRegistryService.ListFeatures][google.cloud.aiplatform.v1.FeatureRegistryService.ListFeatures]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [FeaturestoreService.ListFeatures][google.cloud.aiplatform.v1.FeaturestoreService.ListFeatures]
	// or
	// [FeatureRegistryService.ListFeatures][google.cloud.aiplatform.v1.FeatureRegistryService.ListFeatures]
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A comma-separated list of fields to order by, sorted in ascending order.
	// Use "desc" after a field name for descending.
	// Supported fields:
	//
	//   - `feature_id`
	//   - `value_type` (Not supported for FeatureRegistry Feature)
	//   - `create_time`
	//   - `update_time`
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Mask specifying which fields to read.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,6,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	// Only applicable for Vertex AI Feature Store (Legacy).
	// If set, return the most recent
	// [ListFeaturesRequest.latest_stats_count][google.cloud.aiplatform.v1.ListFeaturesRequest.latest_stats_count]
	// of stats for each Feature in response. Valid value is [0, 10]. If number of
	// stats exists <
	// [ListFeaturesRequest.latest_stats_count][google.cloud.aiplatform.v1.ListFeaturesRequest.latest_stats_count],
	// return all existing stats.
	LatestStatsCount int32 `protobuf:"varint,7,opt,name=latest_stats_count,json=latestStatsCount,proto3" json:"latest_stats_count,omitempty"`
}

func (x *ListFeaturesRequest) Reset() {
	*x = ListFeaturesRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeaturesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeaturesRequest) ProtoMessage() {}

func (x *ListFeaturesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeaturesRequest.ProtoReflect.Descriptor instead.
func (*ListFeaturesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{24}
}

func (x *ListFeaturesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFeaturesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListFeaturesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFeaturesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListFeaturesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListFeaturesRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

func (x *ListFeaturesRequest) GetLatestStatsCount() int32 {
	if x != nil {
		return x.LatestStatsCount
	}
	return 0
}

// Response message for
// [FeaturestoreService.ListFeatures][google.cloud.aiplatform.v1.FeaturestoreService.ListFeatures].
// Response message for
// [FeatureRegistryService.ListFeatures][google.cloud.aiplatform.v1.FeatureRegistryService.ListFeatures].
type ListFeaturesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Features matching the request.
	Features []*Feature `protobuf:"bytes,1,rep,name=features,proto3" json:"features,omitempty"`
	// A token, which can be sent as
	// [ListFeaturesRequest.page_token][google.cloud.aiplatform.v1.ListFeaturesRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListFeaturesResponse) Reset() {
	*x = ListFeaturesResponse{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListFeaturesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeaturesResponse) ProtoMessage() {}

func (x *ListFeaturesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeaturesResponse.ProtoReflect.Descriptor instead.
func (*ListFeaturesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{25}
}

func (x *ListFeaturesResponse) GetFeatures() []*Feature {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *ListFeaturesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures].
type SearchFeaturesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to search Features.
	// Format:
	// `projects/{project}/locations/{location}`
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Query string that is a conjunction of field-restricted queries and/or
	// field-restricted filters.  Field-restricted queries and filters can be
	// combined using `AND` to form a conjunction.
	//
	// A field query is in the form FIELD:QUERY. This implicitly checks if QUERY
	// exists as a substring within Feature's FIELD. The QUERY
	// and the FIELD are converted to a sequence of words (i.e. tokens) for
	// comparison. This is done by:
	//
	//   - Removing leading/trailing whitespace and tokenizing the search value.
	//     Characters that are not one of alphanumeric `[a-zA-Z0-9]`, underscore
	//     `_`, or asterisk `*` are treated as delimiters for tokens. `*` is treated
	//     as a wildcard that matches characters within a token.
	//   - Ignoring case.
	//   - Prepending an asterisk to the first and appending an asterisk to the
	//     last token in QUERY.
	//
	// A QUERY must be either a singular token or a phrase. A phrase is one or
	// multiple words enclosed in double quotation marks ("). With phrases, the
	// order of the words is important. Words in the phrase must be matching in
	// order and consecutively.
	//
	// Supported FIELDs for field-restricted queries:
	//
	// * `feature_id`
	// * `description`
	// * `entity_type_id`
	//
	// Examples:
	//
	// * `feature_id: foo` --> Matches a Feature with ID containing the substring
	// `foo` (eg. `foo`, `foofeature`, `barfoo`).
	// * `feature_id: foo*feature` --> Matches a Feature with ID containing the
	// substring `foo*feature` (eg. `foobarfeature`).
	// * `feature_id: foo AND description: bar` --> Matches a Feature with ID
	// containing the substring `foo` and description containing the substring
	// `bar`.
	//
	// Besides field queries, the following exact-match filters are
	// supported. The exact-match filters do not support wildcards. Unlike
	// field-restricted queries, exact-match filters are case-sensitive.
	//
	// * `feature_id`: Supports = comparisons.
	// * `description`: Supports = comparisons. Multi-token filters should be
	// enclosed in quotes.
	// * `entity_type_id`: Supports = comparisons.
	// * `value_type`: Supports = and != comparisons.
	// * `labels`: Supports key-value equality as well as key presence.
	// * `featurestore_id`: Supports = comparisons.
	//
	// Examples:
	//
	// * `description = "foo bar"` --> Any Feature with description exactly equal
	// to `foo bar`
	//   - `value_type = DOUBLE` --> Features whose type is DOUBLE.
	//   - `labels.active = yes AND labels.env = prod` --> Features having both
	//     (active: yes) and (env: prod) labels.
	//   - `labels.env: *` --> Any Feature which has a label with `env` as the
	//     key.
	Query string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// The maximum number of Features to return. The service may return fewer
	// than this value. If unspecified, at most 100 Features will be returned.
	// The maximum value is 100; any value greater than 100 will be coerced to
	// 100.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures],
	// except `page_size`, must match the call that provided the page token.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchFeaturesRequest) Reset() {
	*x = SearchFeaturesRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchFeaturesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchFeaturesRequest) ProtoMessage() {}

func (x *SearchFeaturesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchFeaturesRequest.ProtoReflect.Descriptor instead.
func (*SearchFeaturesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{26}
}

func (x *SearchFeaturesRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *SearchFeaturesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchFeaturesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchFeaturesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [FeaturestoreService.SearchFeatures][google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures].
type SearchFeaturesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Features matching the request.
	//
	// Fields returned:
	//
	//   - `name`
	//   - `description`
	//   - `labels`
	//   - `create_time`
	//   - `update_time`
	Features []*Feature `protobuf:"bytes,1,rep,name=features,proto3" json:"features,omitempty"`
	// A token, which can be sent as
	// [SearchFeaturesRequest.page_token][google.cloud.aiplatform.v1.SearchFeaturesRequest.page_token]
	// to retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchFeaturesResponse) Reset() {
	*x = SearchFeaturesResponse{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchFeaturesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchFeaturesResponse) ProtoMessage() {}

func (x *SearchFeaturesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchFeaturesResponse.ProtoReflect.Descriptor instead.
func (*SearchFeaturesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{27}
}

func (x *SearchFeaturesResponse) GetFeatures() []*Feature {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *SearchFeaturesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [FeaturestoreService.UpdateFeature][google.cloud.aiplatform.v1.FeaturestoreService.UpdateFeature].
// Request message for
// [FeatureRegistryService.UpdateFeature][google.cloud.aiplatform.v1.FeatureRegistryService.UpdateFeature].
type UpdateFeatureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Feature's `name` field is used to identify the Feature to be
	// updated.
	// Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
	Feature *Feature `protobuf:"bytes,1,opt,name=feature,proto3" json:"feature,omitempty"`
	// Field mask is used to specify the fields to be overwritten in the
	// Features resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then only the non-empty fields present in the
	// request will be overwritten. Set the update_mask to `*` to override all
	// fields.
	//
	// Updatable fields:
	//
	//   - `description`
	//   - `labels`
	//   - `disable_monitoring` (Not supported for FeatureRegistryService Feature)
	//   - `point_of_contact` (Not supported for FeaturestoreService FeatureStore)
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFeatureRequest) Reset() {
	*x = UpdateFeatureRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFeatureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFeatureRequest) ProtoMessage() {}

func (x *UpdateFeatureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFeatureRequest.ProtoReflect.Descriptor instead.
func (*UpdateFeatureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{28}
}

func (x *UpdateFeatureRequest) GetFeature() *Feature {
	if x != nil {
		return x.Feature
	}
	return nil
}

func (x *UpdateFeatureRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// [FeaturestoreService.DeleteFeature][google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeature].
// Request message for
// [FeatureRegistryService.DeleteFeature][google.cloud.aiplatform.v1.FeatureRegistryService.DeleteFeature].
type DeleteFeatureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Features to be deleted.
	// Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}`
	// `projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFeatureRequest) Reset() {
	*x = DeleteFeatureRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeatureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeatureRequest) ProtoMessage() {}

func (x *DeleteFeatureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeatureRequest.ProtoReflect.Descriptor instead.
func (*DeleteFeatureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{29}
}

func (x *DeleteFeatureRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Details of operations that perform create Featurestore.
type CreateFeaturestoreOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for Featurestore.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateFeaturestoreOperationMetadata) Reset() {
	*x = CreateFeaturestoreOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFeaturestoreOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeaturestoreOperationMetadata) ProtoMessage() {}

func (x *CreateFeaturestoreOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeaturestoreOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateFeaturestoreOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{30}
}

func (x *CreateFeaturestoreOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Details of operations that perform update Featurestore.
type UpdateFeaturestoreOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for Featurestore.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *UpdateFeaturestoreOperationMetadata) Reset() {
	*x = UpdateFeaturestoreOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateFeaturestoreOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFeaturestoreOperationMetadata) ProtoMessage() {}

func (x *UpdateFeaturestoreOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFeaturestoreOperationMetadata.ProtoReflect.Descriptor instead.
func (*UpdateFeaturestoreOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{31}
}

func (x *UpdateFeaturestoreOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Details of operations that perform import Feature values.
type ImportFeatureValuesOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for Featurestore import Feature values.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
	// Number of entities that have been imported by the operation.
	ImportedEntityCount int64 `protobuf:"varint,2,opt,name=imported_entity_count,json=importedEntityCount,proto3" json:"imported_entity_count,omitempty"`
	// Number of Feature values that have been imported by the operation.
	ImportedFeatureValueCount int64 `protobuf:"varint,3,opt,name=imported_feature_value_count,json=importedFeatureValueCount,proto3" json:"imported_feature_value_count,omitempty"`
	// The source URI from where Feature values are imported.
	SourceUris []string `protobuf:"bytes,4,rep,name=source_uris,json=sourceUris,proto3" json:"source_uris,omitempty"`
	// The number of rows in input source that weren't imported due to either
	// * Not having any featureValues.
	// * Having a null entityId.
	// * Having a null timestamp.
	// * Not being parsable (applicable for CSV sources).
	InvalidRowCount int64 `protobuf:"varint,6,opt,name=invalid_row_count,json=invalidRowCount,proto3" json:"invalid_row_count,omitempty"`
	// The number rows that weren't ingested due to having timestamps outside the
	// retention boundary.
	TimestampOutsideRetentionRowsCount int64 `protobuf:"varint,7,opt,name=timestamp_outside_retention_rows_count,json=timestampOutsideRetentionRowsCount,proto3" json:"timestamp_outside_retention_rows_count,omitempty"`
	// List of ImportFeatureValues operations running under a single EntityType
	// that are blocking this operation.
	BlockingOperationIds []int64 `protobuf:"varint,8,rep,packed,name=blocking_operation_ids,json=blockingOperationIds,proto3" json:"blocking_operation_ids,omitempty"`
}

func (x *ImportFeatureValuesOperationMetadata) Reset() {
	*x = ImportFeatureValuesOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportFeatureValuesOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportFeatureValuesOperationMetadata) ProtoMessage() {}

func (x *ImportFeatureValuesOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportFeatureValuesOperationMetadata.ProtoReflect.Descriptor instead.
func (*ImportFeatureValuesOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{32}
}

func (x *ImportFeatureValuesOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

func (x *ImportFeatureValuesOperationMetadata) GetImportedEntityCount() int64 {
	if x != nil {
		return x.ImportedEntityCount
	}
	return 0
}

func (x *ImportFeatureValuesOperationMetadata) GetImportedFeatureValueCount() int64 {
	if x != nil {
		return x.ImportedFeatureValueCount
	}
	return 0
}

func (x *ImportFeatureValuesOperationMetadata) GetSourceUris() []string {
	if x != nil {
		return x.SourceUris
	}
	return nil
}

func (x *ImportFeatureValuesOperationMetadata) GetInvalidRowCount() int64 {
	if x != nil {
		return x.InvalidRowCount
	}
	return 0
}

func (x *ImportFeatureValuesOperationMetadata) GetTimestampOutsideRetentionRowsCount() int64 {
	if x != nil {
		return x.TimestampOutsideRetentionRowsCount
	}
	return 0
}

func (x *ImportFeatureValuesOperationMetadata) GetBlockingOperationIds() []int64 {
	if x != nil {
		return x.BlockingOperationIds
	}
	return nil
}

// Details of operations that exports Features values.
type ExportFeatureValuesOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for Featurestore export Feature values.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *ExportFeatureValuesOperationMetadata) Reset() {
	*x = ExportFeatureValuesOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportFeatureValuesOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportFeatureValuesOperationMetadata) ProtoMessage() {}

func (x *ExportFeatureValuesOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportFeatureValuesOperationMetadata.ProtoReflect.Descriptor instead.
func (*ExportFeatureValuesOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{33}
}

func (x *ExportFeatureValuesOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Details of operations that batch reads Feature values.
type BatchReadFeatureValuesOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for Featurestore batch read Features values.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *BatchReadFeatureValuesOperationMetadata) Reset() {
	*x = BatchReadFeatureValuesOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchReadFeatureValuesOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchReadFeatureValuesOperationMetadata) ProtoMessage() {}

func (x *BatchReadFeatureValuesOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchReadFeatureValuesOperationMetadata.ProtoReflect.Descriptor instead.
func (*BatchReadFeatureValuesOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{34}
}

func (x *BatchReadFeatureValuesOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Details of operations that delete Feature values.
type DeleteFeatureValuesOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for Featurestore delete Features values.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *DeleteFeatureValuesOperationMetadata) Reset() {
	*x = DeleteFeatureValuesOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeatureValuesOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeatureValuesOperationMetadata) ProtoMessage() {}

func (x *DeleteFeatureValuesOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeatureValuesOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteFeatureValuesOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{35}
}

func (x *DeleteFeatureValuesOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Details of operations that perform create EntityType.
type CreateEntityTypeOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for EntityType.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateEntityTypeOperationMetadata) Reset() {
	*x = CreateEntityTypeOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEntityTypeOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntityTypeOperationMetadata) ProtoMessage() {}

func (x *CreateEntityTypeOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntityTypeOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateEntityTypeOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{36}
}

func (x *CreateEntityTypeOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Details of operations that perform create Feature.
type CreateFeatureOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for Feature.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateFeatureOperationMetadata) Reset() {
	*x = CreateFeatureOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateFeatureOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeatureOperationMetadata) ProtoMessage() {}

func (x *CreateFeatureOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeatureOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateFeatureOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{37}
}

func (x *CreateFeatureOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Details of operations that perform batch create Features.
type BatchCreateFeaturesOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for Feature.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *BatchCreateFeaturesOperationMetadata) Reset() {
	*x = BatchCreateFeaturesOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchCreateFeaturesOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateFeaturesOperationMetadata) ProtoMessage() {}

func (x *BatchCreateFeaturesOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateFeaturesOperationMetadata.ProtoReflect.Descriptor instead.
func (*BatchCreateFeaturesOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{38}
}

func (x *BatchCreateFeaturesOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [FeaturestoreService.DeleteFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeatureValues].
type DeleteFeatureValuesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines options to select feature values to be deleted.
	//
	// Types that are assignable to DeleteOption:
	//
	//	*DeleteFeatureValuesRequest_SelectEntity_
	//	*DeleteFeatureValuesRequest_SelectTimeRangeAndFeature_
	DeleteOption isDeleteFeatureValuesRequest_DeleteOption `protobuf_oneof:"DeleteOption"`
	// Required. The resource name of the EntityType grouping the Features for
	// which values are being deleted from. Format:
	// `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`
	EntityType string `protobuf:"bytes,1,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
}

func (x *DeleteFeatureValuesRequest) Reset() {
	*x = DeleteFeatureValuesRequest{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeatureValuesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeatureValuesRequest) ProtoMessage() {}

func (x *DeleteFeatureValuesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeatureValuesRequest.ProtoReflect.Descriptor instead.
func (*DeleteFeatureValuesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{39}
}

func (m *DeleteFeatureValuesRequest) GetDeleteOption() isDeleteFeatureValuesRequest_DeleteOption {
	if m != nil {
		return m.DeleteOption
	}
	return nil
}

func (x *DeleteFeatureValuesRequest) GetSelectEntity() *DeleteFeatureValuesRequest_SelectEntity {
	if x, ok := x.GetDeleteOption().(*DeleteFeatureValuesRequest_SelectEntity_); ok {
		return x.SelectEntity
	}
	return nil
}

func (x *DeleteFeatureValuesRequest) GetSelectTimeRangeAndFeature() *DeleteFeatureValuesRequest_SelectTimeRangeAndFeature {
	if x, ok := x.GetDeleteOption().(*DeleteFeatureValuesRequest_SelectTimeRangeAndFeature_); ok {
		return x.SelectTimeRangeAndFeature
	}
	return nil
}

func (x *DeleteFeatureValuesRequest) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

type isDeleteFeatureValuesRequest_DeleteOption interface {
	isDeleteFeatureValuesRequest_DeleteOption()
}

type DeleteFeatureValuesRequest_SelectEntity_ struct {
	// Select feature values to be deleted by specifying entities.
	SelectEntity *DeleteFeatureValuesRequest_SelectEntity `protobuf:"bytes,2,opt,name=select_entity,json=selectEntity,proto3,oneof"`
}

type DeleteFeatureValuesRequest_SelectTimeRangeAndFeature_ struct {
	// Select feature values to be deleted by specifying time range and
	// features.
	SelectTimeRangeAndFeature *DeleteFeatureValuesRequest_SelectTimeRangeAndFeature `protobuf:"bytes,3,opt,name=select_time_range_and_feature,json=selectTimeRangeAndFeature,proto3,oneof"`
}

func (*DeleteFeatureValuesRequest_SelectEntity_) isDeleteFeatureValuesRequest_DeleteOption() {}

func (*DeleteFeatureValuesRequest_SelectTimeRangeAndFeature_) isDeleteFeatureValuesRequest_DeleteOption() {
}

// Response message for
// [FeaturestoreService.DeleteFeatureValues][google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeatureValues].
type DeleteFeatureValuesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Response based on which delete option is specified in the
	// request
	//
	// Types that are assignable to Response:
	//
	//	*DeleteFeatureValuesResponse_SelectEntity_
	//	*DeleteFeatureValuesResponse_SelectTimeRangeAndFeature_
	Response isDeleteFeatureValuesResponse_Response `protobuf_oneof:"response"`
}

func (x *DeleteFeatureValuesResponse) Reset() {
	*x = DeleteFeatureValuesResponse{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeatureValuesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeatureValuesResponse) ProtoMessage() {}

func (x *DeleteFeatureValuesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeatureValuesResponse.ProtoReflect.Descriptor instead.
func (*DeleteFeatureValuesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{40}
}

func (m *DeleteFeatureValuesResponse) GetResponse() isDeleteFeatureValuesResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *DeleteFeatureValuesResponse) GetSelectEntity() *DeleteFeatureValuesResponse_SelectEntity {
	if x, ok := x.GetResponse().(*DeleteFeatureValuesResponse_SelectEntity_); ok {
		return x.SelectEntity
	}
	return nil
}

func (x *DeleteFeatureValuesResponse) GetSelectTimeRangeAndFeature() *DeleteFeatureValuesResponse_SelectTimeRangeAndFeature {
	if x, ok := x.GetResponse().(*DeleteFeatureValuesResponse_SelectTimeRangeAndFeature_); ok {
		return x.SelectTimeRangeAndFeature
	}
	return nil
}

type isDeleteFeatureValuesResponse_Response interface {
	isDeleteFeatureValuesResponse_Response()
}

type DeleteFeatureValuesResponse_SelectEntity_ struct {
	// Response for request specifying the entities to delete
	SelectEntity *DeleteFeatureValuesResponse_SelectEntity `protobuf:"bytes,1,opt,name=select_entity,json=selectEntity,proto3,oneof"`
}

type DeleteFeatureValuesResponse_SelectTimeRangeAndFeature_ struct {
	// Response for request specifying time range and feature
	SelectTimeRangeAndFeature *DeleteFeatureValuesResponse_SelectTimeRangeAndFeature `protobuf:"bytes,2,opt,name=select_time_range_and_feature,json=selectTimeRangeAndFeature,proto3,oneof"`
}

func (*DeleteFeatureValuesResponse_SelectEntity_) isDeleteFeatureValuesResponse_Response() {}

func (*DeleteFeatureValuesResponse_SelectTimeRangeAndFeature_) isDeleteFeatureValuesResponse_Response() {
}

// Selector for entityId. Getting ids from the given source.
type EntityIdSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details about the source data, including the location of the storage and
	// the format.
	//
	// Types that are assignable to EntityIdsSource:
	//
	//	*EntityIdSelector_CsvSource
	EntityIdsSource isEntityIdSelector_EntityIdsSource `protobuf_oneof:"EntityIdsSource"`
	// Source column that holds entity IDs. If not provided, entity IDs are
	// extracted from the column named entity_id.
	EntityIdField string `protobuf:"bytes,5,opt,name=entity_id_field,json=entityIdField,proto3" json:"entity_id_field,omitempty"`
}

func (x *EntityIdSelector) Reset() {
	*x = EntityIdSelector{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntityIdSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityIdSelector) ProtoMessage() {}

func (x *EntityIdSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityIdSelector.ProtoReflect.Descriptor instead.
func (*EntityIdSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{41}
}

func (m *EntityIdSelector) GetEntityIdsSource() isEntityIdSelector_EntityIdsSource {
	if m != nil {
		return m.EntityIdsSource
	}
	return nil
}

func (x *EntityIdSelector) GetCsvSource() *CsvSource {
	if x, ok := x.GetEntityIdsSource().(*EntityIdSelector_CsvSource); ok {
		return x.CsvSource
	}
	return nil
}

func (x *EntityIdSelector) GetEntityIdField() string {
	if x != nil {
		return x.EntityIdField
	}
	return ""
}

type isEntityIdSelector_EntityIdsSource interface {
	isEntityIdSelector_EntityIdsSource()
}

type EntityIdSelector_CsvSource struct {
	// Source of Csv
	CsvSource *CsvSource `protobuf:"bytes,3,opt,name=csv_source,json=csvSource,proto3,oneof"`
}

func (*EntityIdSelector_CsvSource) isEntityIdSelector_EntityIdsSource() {}

// Defines the Feature value(s) to import.
type ImportFeatureValuesRequest_FeatureSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the Feature to import values of. This Feature must exist
	// in the target EntityType, or the request will fail.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Source column to get the Feature values from. If not set, uses the column
	// with the same name as the Feature ID.
	SourceField string `protobuf:"bytes,2,opt,name=source_field,json=sourceField,proto3" json:"source_field,omitempty"`
}

func (x *ImportFeatureValuesRequest_FeatureSpec) Reset() {
	*x = ImportFeatureValuesRequest_FeatureSpec{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportFeatureValuesRequest_FeatureSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportFeatureValuesRequest_FeatureSpec) ProtoMessage() {}

func (x *ImportFeatureValuesRequest_FeatureSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportFeatureValuesRequest_FeatureSpec.ProtoReflect.Descriptor instead.
func (*ImportFeatureValuesRequest_FeatureSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{6, 0}
}

func (x *ImportFeatureValuesRequest_FeatureSpec) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ImportFeatureValuesRequest_FeatureSpec) GetSourceField() string {
	if x != nil {
		return x.SourceField
	}
	return ""
}

// Describe pass-through fields in read_instance source.
type BatchReadFeatureValuesRequest_PassThroughField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the field in the CSV header or the name of the
	// column in BigQuery table. The naming restriction is the same as
	// [Feature.name][google.cloud.aiplatform.v1.Feature.name].
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
}

func (x *BatchReadFeatureValuesRequest_PassThroughField) Reset() {
	*x = BatchReadFeatureValuesRequest_PassThroughField{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchReadFeatureValuesRequest_PassThroughField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchReadFeatureValuesRequest_PassThroughField) ProtoMessage() {}

func (x *BatchReadFeatureValuesRequest_PassThroughField) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchReadFeatureValuesRequest_PassThroughField.ProtoReflect.Descriptor instead.
func (*BatchReadFeatureValuesRequest_PassThroughField) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{8, 0}
}

func (x *BatchReadFeatureValuesRequest_PassThroughField) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

// Selects Features of an EntityType to read values of and specifies read
// settings.
type BatchReadFeatureValuesRequest_EntityTypeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the EntityType to select Features. The EntityType id is
	// the
	// [entity_type_id][google.cloud.aiplatform.v1.CreateEntityTypeRequest.entity_type_id]
	// specified during EntityType creation.
	EntityTypeId string `protobuf:"bytes,1,opt,name=entity_type_id,json=entityTypeId,proto3" json:"entity_type_id,omitempty"`
	// Required. Selectors choosing which Feature values to read from the
	// EntityType.
	FeatureSelector *FeatureSelector `protobuf:"bytes,2,opt,name=feature_selector,json=featureSelector,proto3" json:"feature_selector,omitempty"`
	// Per-Feature settings for the batch read.
	Settings []*DestinationFeatureSetting `protobuf:"bytes,3,rep,name=settings,proto3" json:"settings,omitempty"`
}

func (x *BatchReadFeatureValuesRequest_EntityTypeSpec) Reset() {
	*x = BatchReadFeatureValuesRequest_EntityTypeSpec{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchReadFeatureValuesRequest_EntityTypeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchReadFeatureValuesRequest_EntityTypeSpec) ProtoMessage() {}

func (x *BatchReadFeatureValuesRequest_EntityTypeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchReadFeatureValuesRequest_EntityTypeSpec.ProtoReflect.Descriptor instead.
func (*BatchReadFeatureValuesRequest_EntityTypeSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{8, 1}
}

func (x *BatchReadFeatureValuesRequest_EntityTypeSpec) GetEntityTypeId() string {
	if x != nil {
		return x.EntityTypeId
	}
	return ""
}

func (x *BatchReadFeatureValuesRequest_EntityTypeSpec) GetFeatureSelector() *FeatureSelector {
	if x != nil {
		return x.FeatureSelector
	}
	return nil
}

func (x *BatchReadFeatureValuesRequest_EntityTypeSpec) GetSettings() []*DestinationFeatureSetting {
	if x != nil {
		return x.Settings
	}
	return nil
}

// Describes exporting the latest Feature values of all entities of the
// EntityType between [start_time, snapshot_time].
type ExportFeatureValuesRequest_SnapshotExport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exports Feature values as of this timestamp. If not set,
	// retrieve values as of now. Timestamp, if present, must not have higher
	// than millisecond precision.
	SnapshotTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=snapshot_time,json=snapshotTime,proto3" json:"snapshot_time,omitempty"`
	// Excludes Feature values with feature generation timestamp before this
	// timestamp. If not set, retrieve oldest values kept in Feature Store.
	// Timestamp, if present, must not have higher than millisecond precision.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *ExportFeatureValuesRequest_SnapshotExport) Reset() {
	*x = ExportFeatureValuesRequest_SnapshotExport{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportFeatureValuesRequest_SnapshotExport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportFeatureValuesRequest_SnapshotExport) ProtoMessage() {}

func (x *ExportFeatureValuesRequest_SnapshotExport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportFeatureValuesRequest_SnapshotExport.ProtoReflect.Descriptor instead.
func (*ExportFeatureValuesRequest_SnapshotExport) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{9, 0}
}

func (x *ExportFeatureValuesRequest_SnapshotExport) GetSnapshotTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SnapshotTime
	}
	return nil
}

func (x *ExportFeatureValuesRequest_SnapshotExport) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Describes exporting all historical Feature values of all entities of the
// EntityType between [start_time, end_time].
type ExportFeatureValuesRequest_FullExport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Excludes Feature values with feature generation timestamp before this
	// timestamp. If not set, retrieve oldest values kept in Feature Store.
	// Timestamp, if present, must not have higher than millisecond precision.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Exports Feature values as of this timestamp. If not set,
	// retrieve values as of now. Timestamp, if present, must not have higher
	// than millisecond precision.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *ExportFeatureValuesRequest_FullExport) Reset() {
	*x = ExportFeatureValuesRequest_FullExport{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportFeatureValuesRequest_FullExport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportFeatureValuesRequest_FullExport) ProtoMessage() {}

func (x *ExportFeatureValuesRequest_FullExport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportFeatureValuesRequest_FullExport.ProtoReflect.Descriptor instead.
func (*ExportFeatureValuesRequest_FullExport) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{9, 1}
}

func (x *ExportFeatureValuesRequest_FullExport) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ExportFeatureValuesRequest_FullExport) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Message to select entity.
// If an entity id is selected, all the feature values corresponding to the
// entity id will be deleted, including the entityId.
type DeleteFeatureValuesRequest_SelectEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Selectors choosing feature values of which entity id to be
	// deleted from the EntityType.
	EntityIdSelector *EntityIdSelector `protobuf:"bytes,1,opt,name=entity_id_selector,json=entityIdSelector,proto3" json:"entity_id_selector,omitempty"`
}

func (x *DeleteFeatureValuesRequest_SelectEntity) Reset() {
	*x = DeleteFeatureValuesRequest_SelectEntity{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeatureValuesRequest_SelectEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeatureValuesRequest_SelectEntity) ProtoMessage() {}

func (x *DeleteFeatureValuesRequest_SelectEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeatureValuesRequest_SelectEntity.ProtoReflect.Descriptor instead.
func (*DeleteFeatureValuesRequest_SelectEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{39, 0}
}

func (x *DeleteFeatureValuesRequest_SelectEntity) GetEntityIdSelector() *EntityIdSelector {
	if x != nil {
		return x.EntityIdSelector
	}
	return nil
}

// Message to select time range and feature.
// Values of the selected feature generated within an inclusive time range
// will be deleted. Using this option permanently deletes the feature values
// from the specified feature IDs within the specified time range.
// This might include data from the online storage. If you want to retain
// any deleted historical data in the online storage, you must re-ingest it.
type DeleteFeatureValuesRequest_SelectTimeRangeAndFeature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Select feature generated within a half-inclusive time range.
	// The time range is lower inclusive and upper exclusive.
	TimeRange *interval.Interval `protobuf:"bytes,1,opt,name=time_range,json=timeRange,proto3" json:"time_range,omitempty"`
	// Required. Selectors choosing which feature values to be deleted from the
	// EntityType.
	FeatureSelector *FeatureSelector `protobuf:"bytes,2,opt,name=feature_selector,json=featureSelector,proto3" json:"feature_selector,omitempty"`
	// If set, data will not be deleted from online storage.
	// When time range is older than the data in online storage, setting this to
	// be true will make the deletion have no impact on online serving.
	SkipOnlineStorageDelete bool `protobuf:"varint,3,opt,name=skip_online_storage_delete,json=skipOnlineStorageDelete,proto3" json:"skip_online_storage_delete,omitempty"`
}

func (x *DeleteFeatureValuesRequest_SelectTimeRangeAndFeature) Reset() {
	*x = DeleteFeatureValuesRequest_SelectTimeRangeAndFeature{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeatureValuesRequest_SelectTimeRangeAndFeature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeatureValuesRequest_SelectTimeRangeAndFeature) ProtoMessage() {}

func (x *DeleteFeatureValuesRequest_SelectTimeRangeAndFeature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeatureValuesRequest_SelectTimeRangeAndFeature.ProtoReflect.Descriptor instead.
func (*DeleteFeatureValuesRequest_SelectTimeRangeAndFeature) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{39, 1}
}

func (x *DeleteFeatureValuesRequest_SelectTimeRangeAndFeature) GetTimeRange() *interval.Interval {
	if x != nil {
		return x.TimeRange
	}
	return nil
}

func (x *DeleteFeatureValuesRequest_SelectTimeRangeAndFeature) GetFeatureSelector() *FeatureSelector {
	if x != nil {
		return x.FeatureSelector
	}
	return nil
}

func (x *DeleteFeatureValuesRequest_SelectTimeRangeAndFeature) GetSkipOnlineStorageDelete() bool {
	if x != nil {
		return x.SkipOnlineStorageDelete
	}
	return false
}

// Response message if the request uses the SelectEntity option.
type DeleteFeatureValuesResponse_SelectEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The count of deleted entity rows in the offline storage.
	// Each row corresponds to the combination of an entity ID and a timestamp.
	// One entity ID can have multiple rows in the offline storage.
	OfflineStorageDeletedEntityRowCount int64 `protobuf:"varint,1,opt,name=offline_storage_deleted_entity_row_count,json=offlineStorageDeletedEntityRowCount,proto3" json:"offline_storage_deleted_entity_row_count,omitempty"`
	// The count of deleted entities in the online storage.
	// Each entity ID corresponds to one entity.
	OnlineStorageDeletedEntityCount int64 `protobuf:"varint,2,opt,name=online_storage_deleted_entity_count,json=onlineStorageDeletedEntityCount,proto3" json:"online_storage_deleted_entity_count,omitempty"`
}

func (x *DeleteFeatureValuesResponse_SelectEntity) Reset() {
	*x = DeleteFeatureValuesResponse_SelectEntity{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeatureValuesResponse_SelectEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeatureValuesResponse_SelectEntity) ProtoMessage() {}

func (x *DeleteFeatureValuesResponse_SelectEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeatureValuesResponse_SelectEntity.ProtoReflect.Descriptor instead.
func (*DeleteFeatureValuesResponse_SelectEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{40, 0}
}

func (x *DeleteFeatureValuesResponse_SelectEntity) GetOfflineStorageDeletedEntityRowCount() int64 {
	if x != nil {
		return x.OfflineStorageDeletedEntityRowCount
	}
	return 0
}

func (x *DeleteFeatureValuesResponse_SelectEntity) GetOnlineStorageDeletedEntityCount() int64 {
	if x != nil {
		return x.OnlineStorageDeletedEntityCount
	}
	return 0
}

// Response message if the request uses the SelectTimeRangeAndFeature option.
type DeleteFeatureValuesResponse_SelectTimeRangeAndFeature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The count of the features or columns impacted.
	// This is the same as the feature count in the request.
	ImpactedFeatureCount int64 `protobuf:"varint,1,opt,name=impacted_feature_count,json=impactedFeatureCount,proto3" json:"impacted_feature_count,omitempty"`
	// The count of modified entity rows in the offline storage.
	// Each row corresponds to the combination of an entity ID and a timestamp.
	// One entity ID can have multiple rows in the offline storage.
	// Within each row, only the features specified in the request are
	// deleted.
	OfflineStorageModifiedEntityRowCount int64 `protobuf:"varint,2,opt,name=offline_storage_modified_entity_row_count,json=offlineStorageModifiedEntityRowCount,proto3" json:"offline_storage_modified_entity_row_count,omitempty"`
	// The count of modified entities in the online storage.
	// Each entity ID corresponds to one entity.
	// Within each entity, only the features specified in the request are
	// deleted.
	OnlineStorageModifiedEntityCount int64 `protobuf:"varint,3,opt,name=online_storage_modified_entity_count,json=onlineStorageModifiedEntityCount,proto3" json:"online_storage_modified_entity_count,omitempty"`
}

func (x *DeleteFeatureValuesResponse_SelectTimeRangeAndFeature) Reset() {
	*x = DeleteFeatureValuesResponse_SelectTimeRangeAndFeature{}
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteFeatureValuesResponse_SelectTimeRangeAndFeature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeatureValuesResponse_SelectTimeRangeAndFeature) ProtoMessage() {}

func (x *DeleteFeatureValuesResponse_SelectTimeRangeAndFeature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeatureValuesResponse_SelectTimeRangeAndFeature.ProtoReflect.Descriptor instead.
func (*DeleteFeatureValuesResponse_SelectTimeRangeAndFeature) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP(), []int{40, 1}
}

func (x *DeleteFeatureValuesResponse_SelectTimeRangeAndFeature) GetImpactedFeatureCount() int64 {
	if x != nil {
		return x.ImpactedFeatureCount
	}
	return 0
}

func (x *DeleteFeatureValuesResponse_SelectTimeRangeAndFeature) GetOfflineStorageModifiedEntityRowCount() int64 {
	if x != nil {
		return x.OfflineStorageModifiedEntityRowCount
	}
	return 0
}

func (x *DeleteFeatureValuesResponse_SelectTimeRangeAndFeature) GetOnlineStorageModifiedEntityCount() int64 {
	if x != nil {
		return x.OnlineStorageModifiedEntityCount
	}
	return 0
}

var File_google_cloud_aiplatform_v1_featurestore_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6f, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xe4, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x22, 0x5c, 0x0a, 0x16, 0x47, 0x65, 0x74,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8a, 0x02, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x37, 0x0a, 0x09, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x93, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x52, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xab, 0x01, 0x0a, 0x19, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x75, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22,
	0xdb, 0x06, 0x0a, 0x1a, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x0b, 0x61, 0x76, 0x72, 0x6f, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x76, 0x72, 0x6f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x61,
	0x76, 0x72, 0x6f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x55, 0x0a, 0x0f, 0x62, 0x69, 0x67,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00,
	0x52, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x46, 0x0a, 0x0a, 0x63, 0x73, 0x76, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x73, 0x76, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x63,
	0x73, 0x76, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2e, 0x0a, 0x12, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x10, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3f, 0x0a, 0x0c, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x01, 0x52, 0x0b, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x69, 0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x12, 0x6c, 0x0a, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x34,
	0x0a, 0x16, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x6e, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x1a, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x1a, 0x45, 0x0a, 0x0b, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x08, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x92, 0x02,
	0x0a, 0x1b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a,
	0x15, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x3f, 0x0a, 0x1c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x72, 0x6f,
	0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x69,
	0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x52,
	0x0a, 0x26, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x6f, 0x75, 0x74, 0x73,
	0x69, 0x64, 0x65, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x6f,
	0x77, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x22,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4f, 0x75, 0x74, 0x73, 0x69, 0x64, 0x65,
	0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x22, 0xf8, 0x07, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x12, 0x63, 0x73, 0x76, 0x5f, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x73,
	0x76, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x10, 0x63, 0x73, 0x76, 0x52, 0x65,
	0x61, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x17, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x15, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x61, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x52, 0x0a, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a,
	0x26, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x5a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x7a, 0x0a, 0x13, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67,
	0x68, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x50, 0x61, 0x73, 0x73, 0x54, 0x68,
	0x72, 0x6f, 0x75, 0x67, 0x68, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x11, 0x70, 0x61, 0x73, 0x73,
	0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x79, 0x0a,
	0x11, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x36, 0x0a, 0x10, 0x50, 0x61, 0x73, 0x73,
	0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x22, 0x0a, 0x0a,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65,
	0x1a, 0xeb, 0x01, 0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x29, 0x0a, 0x0e, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12, 0x5b,
	0x0a, 0x10, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x51, 0x0a, 0x08, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x0d,
	0x0a, 0x0b, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe6, 0x06,
	0x0a, 0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x70, 0x0a, 0x0f,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x48, 0x00, 0x52, 0x0e,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x64,
	0x0a, 0x0b, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x75, 0x6c, 0x6c,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x66, 0x75, 0x6c, 0x6c, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5b, 0x0a, 0x10, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x51, 0x0a, 0x08,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a,
	0x8c, 0x01, 0x0a, 0x0e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x3f, 0x0a, 0x0d, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x7e,
	0x0a, 0x0a, 0x46, 0x75, 0x6c, 0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x39, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x06,
	0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22, 0x6c, 0x0a, 0x19, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x22, 0xcb, 0x02, 0x0a, 0x17, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x64, 0x0a, 0x14, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x14, 0x74, 0x66, 0x72, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x46, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x74, 0x66, 0x72, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0f,
	0x63, 0x73, 0x76, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x73, 0x76, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x73, 0x76, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x1d, 0x0a, 0x1b, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x20, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xd5, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x29, 0x0a, 0x0e, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x22, 0x58, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x86, 0x02, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x8c,
	0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0c, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01,
	0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x0b, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x71, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xc1, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x07, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x49, 0x64, 0x22, 0xb2, 0x01, 0x0a, 0x1a,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x12, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a,
	0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x22, 0x5e, 0x0a, 0x1b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3f, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x22, 0x52, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xae, 0x02, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x37,
	0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x08, 0x72,
	0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x2c, 0x0a, 0x12, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x7f, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a,
	0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb0, 0x01, 0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x81, 0x01, 0x0a, 0x16, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x08, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x97, 0x01,
	0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x07, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x55, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x86,
	0x01, 0x0a, 0x23, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x86, 0x01, 0x0a, 0x23, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x22, 0xd3, 0x03, 0x0a, 0x24, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3f,
	0x0a, 0x1c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x73,
	0x12, 0x2a, 0x0a, 0x11, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x72, 0x6f, 0x77, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x69, 0x6e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x26,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x6f, 0x75, 0x74, 0x73, 0x69, 0x64,
	0x65, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x6f, 0x77, 0x73,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x22, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4f, 0x75, 0x74, 0x73, 0x69, 0x64, 0x65, 0x52, 0x65,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x77, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x34, 0x0a, 0x16, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x03,
	0x52, 0x14, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x22, 0x87, 0x01, 0x0a, 0x24, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x22, 0x8a, 0x01, 0x0a, 0x27, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x10,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x87, 0x01,
	0x0a, 0x24, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x84, 0x01, 0x0a, 0x21, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a,
	0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x81,
	0x01, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0x87, 0x01, 0x0a, 0x24, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a, 0x10, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xe2, 0x05, 0x0a,
	0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6a, 0x0a, 0x0d, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x94, 0x01, 0x0a, 0x1d, 0x73, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x61, 0x6e,
	0x64, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x6e, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x48, 0x00, 0x52, 0x19, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x41, 0x6e, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x4d,
	0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x6f, 0x0a,
	0x0c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x5f, 0x0a,
	0x12, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0xf0,
	0x01, 0x0a, 0x19, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x41, 0x6e, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x39, 0x0a, 0x0a,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x12, 0x3b, 0x0a, 0x1a, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x6f, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x73, 0x6b, 0x69, 0x70, 0x4f, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x42, 0x0e, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xe1, 0x05, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x6b, 0x0a, 0x0d, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00,
	0x52, 0x0c, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x95,
	0x01, 0x0a, 0x1d, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41,
	0x6e, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x48, 0x00, 0x52, 0x19, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x41, 0x6e, 0x64, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x1a, 0xb3, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x55, 0x0a, 0x28, 0x6f, 0x66, 0x66, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x23, 0x6f, 0x66, 0x66, 0x6c, 0x69,
	0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4c,
	0x0a, 0x23, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1f, 0x6f, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xfa, 0x01, 0x0a,
	0x19, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x41, 0x6e, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x69, 0x6d,
	0x70, 0x61, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x69, 0x6d, 0x70, 0x61,
	0x63, 0x74, 0x65, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x57, 0x0a, 0x29, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x24, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x52, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x24, 0x6f, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x69,
	0x66, 0x69, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x20, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x10, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x49, 0x64, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x46, 0x0a, 0x0a, 0x63, 0x73,
	0x76, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x73, 0x76, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x63, 0x73, 0x76, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x5f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x49, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x42, 0x11, 0x0a, 0x0f, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x32, 0xe6, 0x29,
	0x0a, 0x13, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xa6, 0x02, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xb9, 0x01, 0xca, 0x41, 0x33, 0x0a, 0x0c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x23, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x3a, 0x0c, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xb1,
	0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12,
	0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xc4, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x92, 0x02, 0x0a, 0x12, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa5, 0x01, 0xca, 0x41, 0x33, 0x0a, 0x0c, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x23, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x18, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e,
	0x3a, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x32, 0x3e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xed,
	0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0xca, 0x41,
	0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xda, 0x41, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x2c,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa8,
	0x02, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbf, 0x01, 0xca, 0x41, 0x2f, 0x0a, 0x0a, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x0b, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xb9, 0x01, 0x0a, 0x0d, 0x47, 0x65,
	0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcc, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x50, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0xeb, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0x7a, 0xda, 0x41, 0x17, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x32, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xf7, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8e, 0x01, 0xca, 0x41,
	0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xda, 0x41, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x2c,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x2a, 0x3f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x97, 0x02, 0x0a,
	0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xb4, 0x01, 0xca, 0x41, 0x29, 0x0a, 0x07, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x1e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0xda,
	0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x2c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x55, 0x3a, 0x07, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x4a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0xa8, 0x02, 0x0a, 0x13, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb9, 0x01, 0xca, 0x41, 0x43, 0x0a, 0x1b, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x3a, 0x01, 0x2a, 0x22, 0x56, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x12, 0xbb, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x22, 0x59, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xce, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x5b, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4c, 0x12, 0x4a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x12, 0xe1, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x79, 0xda, 0x41, 0x13, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x3a, 0x07, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x32, 0x52, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xef, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x2a, 0x4a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa8, 0x02, 0x0a, 0x13, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb9, 0x01, 0xca, 0x41, 0x43, 0x0a, 0x1b, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x5f, 0x3a, 0x01, 0x2a, 0x22, 0x5a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0xab, 0x02, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb6, 0x01, 0xca, 0x41, 0x49, 0x0a, 0x1e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65,
	0x61, 0x64, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0xa8, 0x02, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb9,
	0x01, 0xca, 0x41, 0x43, 0x0a, 0x1b, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x24, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5f, 0x3a, 0x01, 0x2a, 0x22, 0x5a,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0xa8, 0x02, 0x0a, 0x13, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb9, 0x01, 0xca, 0x41, 0x43, 0x0a,
	0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x24, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5f, 0x3a, 0x01, 0x2a, 0x22, 0x5a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0xdf, 0x01, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x66, 0xda, 0x41, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x0e, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd6, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x18, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescData = file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes = make([]protoimpl.MessageInfo, 51)
var file_google_cloud_aiplatform_v1_featurestore_service_proto_goTypes = []any{
	(*CreateFeaturestoreRequest)(nil),                             // 0: google.cloud.aiplatform.v1.CreateFeaturestoreRequest
	(*GetFeaturestoreRequest)(nil),                                // 1: google.cloud.aiplatform.v1.GetFeaturestoreRequest
	(*ListFeaturestoresRequest)(nil),                              // 2: google.cloud.aiplatform.v1.ListFeaturestoresRequest
	(*ListFeaturestoresResponse)(nil),                             // 3: google.cloud.aiplatform.v1.ListFeaturestoresResponse
	(*UpdateFeaturestoreRequest)(nil),                             // 4: google.cloud.aiplatform.v1.UpdateFeaturestoreRequest
	(*DeleteFeaturestoreRequest)(nil),                             // 5: google.cloud.aiplatform.v1.DeleteFeaturestoreRequest
	(*ImportFeatureValuesRequest)(nil),                            // 6: google.cloud.aiplatform.v1.ImportFeatureValuesRequest
	(*ImportFeatureValuesResponse)(nil),                           // 7: google.cloud.aiplatform.v1.ImportFeatureValuesResponse
	(*BatchReadFeatureValuesRequest)(nil),                         // 8: google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest
	(*ExportFeatureValuesRequest)(nil),                            // 9: google.cloud.aiplatform.v1.ExportFeatureValuesRequest
	(*DestinationFeatureSetting)(nil),                             // 10: google.cloud.aiplatform.v1.DestinationFeatureSetting
	(*FeatureValueDestination)(nil),                               // 11: google.cloud.aiplatform.v1.FeatureValueDestination
	(*ExportFeatureValuesResponse)(nil),                           // 12: google.cloud.aiplatform.v1.ExportFeatureValuesResponse
	(*BatchReadFeatureValuesResponse)(nil),                        // 13: google.cloud.aiplatform.v1.BatchReadFeatureValuesResponse
	(*CreateEntityTypeRequest)(nil),                               // 14: google.cloud.aiplatform.v1.CreateEntityTypeRequest
	(*GetEntityTypeRequest)(nil),                                  // 15: google.cloud.aiplatform.v1.GetEntityTypeRequest
	(*ListEntityTypesRequest)(nil),                                // 16: google.cloud.aiplatform.v1.ListEntityTypesRequest
	(*ListEntityTypesResponse)(nil),                               // 17: google.cloud.aiplatform.v1.ListEntityTypesResponse
	(*UpdateEntityTypeRequest)(nil),                               // 18: google.cloud.aiplatform.v1.UpdateEntityTypeRequest
	(*DeleteEntityTypeRequest)(nil),                               // 19: google.cloud.aiplatform.v1.DeleteEntityTypeRequest
	(*CreateFeatureRequest)(nil),                                  // 20: google.cloud.aiplatform.v1.CreateFeatureRequest
	(*BatchCreateFeaturesRequest)(nil),                            // 21: google.cloud.aiplatform.v1.BatchCreateFeaturesRequest
	(*BatchCreateFeaturesResponse)(nil),                           // 22: google.cloud.aiplatform.v1.BatchCreateFeaturesResponse
	(*GetFeatureRequest)(nil),                                     // 23: google.cloud.aiplatform.v1.GetFeatureRequest
	(*ListFeaturesRequest)(nil),                                   // 24: google.cloud.aiplatform.v1.ListFeaturesRequest
	(*ListFeaturesResponse)(nil),                                  // 25: google.cloud.aiplatform.v1.ListFeaturesResponse
	(*SearchFeaturesRequest)(nil),                                 // 26: google.cloud.aiplatform.v1.SearchFeaturesRequest
	(*SearchFeaturesResponse)(nil),                                // 27: google.cloud.aiplatform.v1.SearchFeaturesResponse
	(*UpdateFeatureRequest)(nil),                                  // 28: google.cloud.aiplatform.v1.UpdateFeatureRequest
	(*DeleteFeatureRequest)(nil),                                  // 29: google.cloud.aiplatform.v1.DeleteFeatureRequest
	(*CreateFeaturestoreOperationMetadata)(nil),                   // 30: google.cloud.aiplatform.v1.CreateFeaturestoreOperationMetadata
	(*UpdateFeaturestoreOperationMetadata)(nil),                   // 31: google.cloud.aiplatform.v1.UpdateFeaturestoreOperationMetadata
	(*ImportFeatureValuesOperationMetadata)(nil),                  // 32: google.cloud.aiplatform.v1.ImportFeatureValuesOperationMetadata
	(*ExportFeatureValuesOperationMetadata)(nil),                  // 33: google.cloud.aiplatform.v1.ExportFeatureValuesOperationMetadata
	(*BatchReadFeatureValuesOperationMetadata)(nil),               // 34: google.cloud.aiplatform.v1.BatchReadFeatureValuesOperationMetadata
	(*DeleteFeatureValuesOperationMetadata)(nil),                  // 35: google.cloud.aiplatform.v1.DeleteFeatureValuesOperationMetadata
	(*CreateEntityTypeOperationMetadata)(nil),                     // 36: google.cloud.aiplatform.v1.CreateEntityTypeOperationMetadata
	(*CreateFeatureOperationMetadata)(nil),                        // 37: google.cloud.aiplatform.v1.CreateFeatureOperationMetadata
	(*BatchCreateFeaturesOperationMetadata)(nil),                  // 38: google.cloud.aiplatform.v1.BatchCreateFeaturesOperationMetadata
	(*DeleteFeatureValuesRequest)(nil),                            // 39: google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
	(*DeleteFeatureValuesResponse)(nil),                           // 40: google.cloud.aiplatform.v1.DeleteFeatureValuesResponse
	(*EntityIdSelector)(nil),                                      // 41: google.cloud.aiplatform.v1.EntityIdSelector
	(*ImportFeatureValuesRequest_FeatureSpec)(nil),                // 42: google.cloud.aiplatform.v1.ImportFeatureValuesRequest.FeatureSpec
	(*BatchReadFeatureValuesRequest_PassThroughField)(nil),        // 43: google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.PassThroughField
	(*BatchReadFeatureValuesRequest_EntityTypeSpec)(nil),          // 44: google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.EntityTypeSpec
	(*ExportFeatureValuesRequest_SnapshotExport)(nil),             // 45: google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
	(*ExportFeatureValuesRequest_FullExport)(nil),                 // 46: google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
	(*DeleteFeatureValuesRequest_SelectEntity)(nil),               // 47: google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
	(*DeleteFeatureValuesRequest_SelectTimeRangeAndFeature)(nil),  // 48: google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
	(*DeleteFeatureValuesResponse_SelectEntity)(nil),              // 49: google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
	(*DeleteFeatureValuesResponse_SelectTimeRangeAndFeature)(nil), // 50: google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
	(*Featurestore)(nil),                                          // 51: google.cloud.aiplatform.v1.Featurestore
	(*fieldmaskpb.FieldMask)(nil),                                 // 52: google.protobuf.FieldMask
	(*AvroSource)(nil),                                            // 53: google.cloud.aiplatform.v1.AvroSource
	(*BigQuerySource)(nil),                                        // 54: google.cloud.aiplatform.v1.BigQuerySource
	(*CsvSource)(nil),                                             // 55: google.cloud.aiplatform.v1.CsvSource
	(*timestamppb.Timestamp)(nil),                                 // 56: google.protobuf.Timestamp
	(*FeatureSelector)(nil),                                       // 57: google.cloud.aiplatform.v1.FeatureSelector
	(*BigQueryDestination)(nil),                                   // 58: google.cloud.aiplatform.v1.BigQueryDestination
	(*TFRecordDestination)(nil),                                   // 59: google.cloud.aiplatform.v1.TFRecordDestination
	(*CsvDestination)(nil),                                        // 60: google.cloud.aiplatform.v1.CsvDestination
	(*EntityType)(nil),                                            // 61: google.cloud.aiplatform.v1.EntityType
	(*Feature)(nil),                                               // 62: google.cloud.aiplatform.v1.Feature
	(*GenericOperationMetadata)(nil),                              // 63: google.cloud.aiplatform.v1.GenericOperationMetadata
	(*interval.Interval)(nil),                                     // 64: google.type.Interval
	(*longrunningpb.Operation)(nil),                               // 65: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1_featurestore_service_proto_depIdxs = []int32{
	51, // 0: google.cloud.aiplatform.v1.CreateFeaturestoreRequest.featurestore:type_name -> google.cloud.aiplatform.v1.Featurestore
	52, // 1: google.cloud.aiplatform.v1.ListFeaturestoresRequest.read_mask:type_name -> google.protobuf.FieldMask
	51, // 2: google.cloud.aiplatform.v1.ListFeaturestoresResponse.featurestores:type_name -> google.cloud.aiplatform.v1.Featurestore
	51, // 3: google.cloud.aiplatform.v1.UpdateFeaturestoreRequest.featurestore:type_name -> google.cloud.aiplatform.v1.Featurestore
	52, // 4: google.cloud.aiplatform.v1.UpdateFeaturestoreRequest.update_mask:type_name -> google.protobuf.FieldMask
	53, // 5: google.cloud.aiplatform.v1.ImportFeatureValuesRequest.avro_source:type_name -> google.cloud.aiplatform.v1.AvroSource
	54, // 6: google.cloud.aiplatform.v1.ImportFeatureValuesRequest.bigquery_source:type_name -> google.cloud.aiplatform.v1.BigQuerySource
	55, // 7: google.cloud.aiplatform.v1.ImportFeatureValuesRequest.csv_source:type_name -> google.cloud.aiplatform.v1.CsvSource
	56, // 8: google.cloud.aiplatform.v1.ImportFeatureValuesRequest.feature_time:type_name -> google.protobuf.Timestamp
	42, // 9: google.cloud.aiplatform.v1.ImportFeatureValuesRequest.feature_specs:type_name -> google.cloud.aiplatform.v1.ImportFeatureValuesRequest.FeatureSpec
	55, // 10: google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.csv_read_instances:type_name -> google.cloud.aiplatform.v1.CsvSource
	54, // 11: google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.bigquery_read_instances:type_name -> google.cloud.aiplatform.v1.BigQuerySource
	11, // 12: google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.destination:type_name -> google.cloud.aiplatform.v1.FeatureValueDestination
	43, // 13: google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.pass_through_fields:type_name -> google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.PassThroughField
	44, // 14: google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.entity_type_specs:type_name -> google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.EntityTypeSpec
	56, // 15: google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.start_time:type_name -> google.protobuf.Timestamp
	45, // 16: google.cloud.aiplatform.v1.ExportFeatureValuesRequest.snapshot_export:type_name -> google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport
	46, // 17: google.cloud.aiplatform.v1.ExportFeatureValuesRequest.full_export:type_name -> google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport
	11, // 18: google.cloud.aiplatform.v1.ExportFeatureValuesRequest.destination:type_name -> google.cloud.aiplatform.v1.FeatureValueDestination
	57, // 19: google.cloud.aiplatform.v1.ExportFeatureValuesRequest.feature_selector:type_name -> google.cloud.aiplatform.v1.FeatureSelector
	10, // 20: google.cloud.aiplatform.v1.ExportFeatureValuesRequest.settings:type_name -> google.cloud.aiplatform.v1.DestinationFeatureSetting
	58, // 21: google.cloud.aiplatform.v1.FeatureValueDestination.bigquery_destination:type_name -> google.cloud.aiplatform.v1.BigQueryDestination
	59, // 22: google.cloud.aiplatform.v1.FeatureValueDestination.tfrecord_destination:type_name -> google.cloud.aiplatform.v1.TFRecordDestination
	60, // 23: google.cloud.aiplatform.v1.FeatureValueDestination.csv_destination:type_name -> google.cloud.aiplatform.v1.CsvDestination
	61, // 24: google.cloud.aiplatform.v1.CreateEntityTypeRequest.entity_type:type_name -> google.cloud.aiplatform.v1.EntityType
	52, // 25: google.cloud.aiplatform.v1.ListEntityTypesRequest.read_mask:type_name -> google.protobuf.FieldMask
	61, // 26: google.cloud.aiplatform.v1.ListEntityTypesResponse.entity_types:type_name -> google.cloud.aiplatform.v1.EntityType
	61, // 27: google.cloud.aiplatform.v1.UpdateEntityTypeRequest.entity_type:type_name -> google.cloud.aiplatform.v1.EntityType
	52, // 28: google.cloud.aiplatform.v1.UpdateEntityTypeRequest.update_mask:type_name -> google.protobuf.FieldMask
	62, // 29: google.cloud.aiplatform.v1.CreateFeatureRequest.feature:type_name -> google.cloud.aiplatform.v1.Feature
	20, // 30: google.cloud.aiplatform.v1.BatchCreateFeaturesRequest.requests:type_name -> google.cloud.aiplatform.v1.CreateFeatureRequest
	62, // 31: google.cloud.aiplatform.v1.BatchCreateFeaturesResponse.features:type_name -> google.cloud.aiplatform.v1.Feature
	52, // 32: google.cloud.aiplatform.v1.ListFeaturesRequest.read_mask:type_name -> google.protobuf.FieldMask
	62, // 33: google.cloud.aiplatform.v1.ListFeaturesResponse.features:type_name -> google.cloud.aiplatform.v1.Feature
	62, // 34: google.cloud.aiplatform.v1.SearchFeaturesResponse.features:type_name -> google.cloud.aiplatform.v1.Feature
	62, // 35: google.cloud.aiplatform.v1.UpdateFeatureRequest.feature:type_name -> google.cloud.aiplatform.v1.Feature
	52, // 36: google.cloud.aiplatform.v1.UpdateFeatureRequest.update_mask:type_name -> google.protobuf.FieldMask
	63, // 37: google.cloud.aiplatform.v1.CreateFeaturestoreOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	63, // 38: google.cloud.aiplatform.v1.UpdateFeaturestoreOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	63, // 39: google.cloud.aiplatform.v1.ImportFeatureValuesOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	63, // 40: google.cloud.aiplatform.v1.ExportFeatureValuesOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	63, // 41: google.cloud.aiplatform.v1.BatchReadFeatureValuesOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	63, // 42: google.cloud.aiplatform.v1.DeleteFeatureValuesOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	63, // 43: google.cloud.aiplatform.v1.CreateEntityTypeOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	63, // 44: google.cloud.aiplatform.v1.CreateFeatureOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	63, // 45: google.cloud.aiplatform.v1.BatchCreateFeaturesOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	47, // 46: google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.select_entity:type_name -> google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity
	48, // 47: google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.select_time_range_and_feature:type_name -> google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature
	49, // 48: google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.select_entity:type_name -> google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectEntity
	50, // 49: google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.select_time_range_and_feature:type_name -> google.cloud.aiplatform.v1.DeleteFeatureValuesResponse.SelectTimeRangeAndFeature
	55, // 50: google.cloud.aiplatform.v1.EntityIdSelector.csv_source:type_name -> google.cloud.aiplatform.v1.CsvSource
	57, // 51: google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.EntityTypeSpec.feature_selector:type_name -> google.cloud.aiplatform.v1.FeatureSelector
	10, // 52: google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest.EntityTypeSpec.settings:type_name -> google.cloud.aiplatform.v1.DestinationFeatureSetting
	56, // 53: google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.snapshot_time:type_name -> google.protobuf.Timestamp
	56, // 54: google.cloud.aiplatform.v1.ExportFeatureValuesRequest.SnapshotExport.start_time:type_name -> google.protobuf.Timestamp
	56, // 55: google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.start_time:type_name -> google.protobuf.Timestamp
	56, // 56: google.cloud.aiplatform.v1.ExportFeatureValuesRequest.FullExport.end_time:type_name -> google.protobuf.Timestamp
	41, // 57: google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectEntity.entity_id_selector:type_name -> google.cloud.aiplatform.v1.EntityIdSelector
	64, // 58: google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature.time_range:type_name -> google.type.Interval
	57, // 59: google.cloud.aiplatform.v1.DeleteFeatureValuesRequest.SelectTimeRangeAndFeature.feature_selector:type_name -> google.cloud.aiplatform.v1.FeatureSelector
	0,  // 60: google.cloud.aiplatform.v1.FeaturestoreService.CreateFeaturestore:input_type -> google.cloud.aiplatform.v1.CreateFeaturestoreRequest
	1,  // 61: google.cloud.aiplatform.v1.FeaturestoreService.GetFeaturestore:input_type -> google.cloud.aiplatform.v1.GetFeaturestoreRequest
	2,  // 62: google.cloud.aiplatform.v1.FeaturestoreService.ListFeaturestores:input_type -> google.cloud.aiplatform.v1.ListFeaturestoresRequest
	4,  // 63: google.cloud.aiplatform.v1.FeaturestoreService.UpdateFeaturestore:input_type -> google.cloud.aiplatform.v1.UpdateFeaturestoreRequest
	5,  // 64: google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeaturestore:input_type -> google.cloud.aiplatform.v1.DeleteFeaturestoreRequest
	14, // 65: google.cloud.aiplatform.v1.FeaturestoreService.CreateEntityType:input_type -> google.cloud.aiplatform.v1.CreateEntityTypeRequest
	15, // 66: google.cloud.aiplatform.v1.FeaturestoreService.GetEntityType:input_type -> google.cloud.aiplatform.v1.GetEntityTypeRequest
	16, // 67: google.cloud.aiplatform.v1.FeaturestoreService.ListEntityTypes:input_type -> google.cloud.aiplatform.v1.ListEntityTypesRequest
	18, // 68: google.cloud.aiplatform.v1.FeaturestoreService.UpdateEntityType:input_type -> google.cloud.aiplatform.v1.UpdateEntityTypeRequest
	19, // 69: google.cloud.aiplatform.v1.FeaturestoreService.DeleteEntityType:input_type -> google.cloud.aiplatform.v1.DeleteEntityTypeRequest
	20, // 70: google.cloud.aiplatform.v1.FeaturestoreService.CreateFeature:input_type -> google.cloud.aiplatform.v1.CreateFeatureRequest
	21, // 71: google.cloud.aiplatform.v1.FeaturestoreService.BatchCreateFeatures:input_type -> google.cloud.aiplatform.v1.BatchCreateFeaturesRequest
	23, // 72: google.cloud.aiplatform.v1.FeaturestoreService.GetFeature:input_type -> google.cloud.aiplatform.v1.GetFeatureRequest
	24, // 73: google.cloud.aiplatform.v1.FeaturestoreService.ListFeatures:input_type -> google.cloud.aiplatform.v1.ListFeaturesRequest
	28, // 74: google.cloud.aiplatform.v1.FeaturestoreService.UpdateFeature:input_type -> google.cloud.aiplatform.v1.UpdateFeatureRequest
	29, // 75: google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeature:input_type -> google.cloud.aiplatform.v1.DeleteFeatureRequest
	6,  // 76: google.cloud.aiplatform.v1.FeaturestoreService.ImportFeatureValues:input_type -> google.cloud.aiplatform.v1.ImportFeatureValuesRequest
	8,  // 77: google.cloud.aiplatform.v1.FeaturestoreService.BatchReadFeatureValues:input_type -> google.cloud.aiplatform.v1.BatchReadFeatureValuesRequest
	9,  // 78: google.cloud.aiplatform.v1.FeaturestoreService.ExportFeatureValues:input_type -> google.cloud.aiplatform.v1.ExportFeatureValuesRequest
	39, // 79: google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeatureValues:input_type -> google.cloud.aiplatform.v1.DeleteFeatureValuesRequest
	26, // 80: google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures:input_type -> google.cloud.aiplatform.v1.SearchFeaturesRequest
	65, // 81: google.cloud.aiplatform.v1.FeaturestoreService.CreateFeaturestore:output_type -> google.longrunning.Operation
	51, // 82: google.cloud.aiplatform.v1.FeaturestoreService.GetFeaturestore:output_type -> google.cloud.aiplatform.v1.Featurestore
	3,  // 83: google.cloud.aiplatform.v1.FeaturestoreService.ListFeaturestores:output_type -> google.cloud.aiplatform.v1.ListFeaturestoresResponse
	65, // 84: google.cloud.aiplatform.v1.FeaturestoreService.UpdateFeaturestore:output_type -> google.longrunning.Operation
	65, // 85: google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeaturestore:output_type -> google.longrunning.Operation
	65, // 86: google.cloud.aiplatform.v1.FeaturestoreService.CreateEntityType:output_type -> google.longrunning.Operation
	61, // 87: google.cloud.aiplatform.v1.FeaturestoreService.GetEntityType:output_type -> google.cloud.aiplatform.v1.EntityType
	17, // 88: google.cloud.aiplatform.v1.FeaturestoreService.ListEntityTypes:output_type -> google.cloud.aiplatform.v1.ListEntityTypesResponse
	61, // 89: google.cloud.aiplatform.v1.FeaturestoreService.UpdateEntityType:output_type -> google.cloud.aiplatform.v1.EntityType
	65, // 90: google.cloud.aiplatform.v1.FeaturestoreService.DeleteEntityType:output_type -> google.longrunning.Operation
	65, // 91: google.cloud.aiplatform.v1.FeaturestoreService.CreateFeature:output_type -> google.longrunning.Operation
	65, // 92: google.cloud.aiplatform.v1.FeaturestoreService.BatchCreateFeatures:output_type -> google.longrunning.Operation
	62, // 93: google.cloud.aiplatform.v1.FeaturestoreService.GetFeature:output_type -> google.cloud.aiplatform.v1.Feature
	25, // 94: google.cloud.aiplatform.v1.FeaturestoreService.ListFeatures:output_type -> google.cloud.aiplatform.v1.ListFeaturesResponse
	62, // 95: google.cloud.aiplatform.v1.FeaturestoreService.UpdateFeature:output_type -> google.cloud.aiplatform.v1.Feature
	65, // 96: google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeature:output_type -> google.longrunning.Operation
	65, // 97: google.cloud.aiplatform.v1.FeaturestoreService.ImportFeatureValues:output_type -> google.longrunning.Operation
	65, // 98: google.cloud.aiplatform.v1.FeaturestoreService.BatchReadFeatureValues:output_type -> google.longrunning.Operation
	65, // 99: google.cloud.aiplatform.v1.FeaturestoreService.ExportFeatureValues:output_type -> google.longrunning.Operation
	65, // 100: google.cloud.aiplatform.v1.FeaturestoreService.DeleteFeatureValues:output_type -> google.longrunning.Operation
	27, // 101: google.cloud.aiplatform.v1.FeaturestoreService.SearchFeatures:output_type -> google.cloud.aiplatform.v1.SearchFeaturesResponse
	81, // [81:102] is the sub-list for method output_type
	60, // [60:81] is the sub-list for method input_type
	60, // [60:60] is the sub-list for extension type_name
	60, // [60:60] is the sub-list for extension extendee
	0,  // [0:60] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_featurestore_service_proto_init() }
func file_google_cloud_aiplatform_v1_featurestore_service_proto_init() {
	if File_google_cloud_aiplatform_v1_featurestore_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_entity_type_proto_init()
	file_google_cloud_aiplatform_v1_feature_proto_init()
	file_google_cloud_aiplatform_v1_feature_selector_proto_init()
	file_google_cloud_aiplatform_v1_featurestore_proto_init()
	file_google_cloud_aiplatform_v1_io_proto_init()
	file_google_cloud_aiplatform_v1_operation_proto_init()
	file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[6].OneofWrappers = []any{
		(*ImportFeatureValuesRequest_AvroSource)(nil),
		(*ImportFeatureValuesRequest_BigquerySource)(nil),
		(*ImportFeatureValuesRequest_CsvSource)(nil),
		(*ImportFeatureValuesRequest_FeatureTimeField)(nil),
		(*ImportFeatureValuesRequest_FeatureTime)(nil),
	}
	file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[8].OneofWrappers = []any{
		(*BatchReadFeatureValuesRequest_CsvReadInstances)(nil),
		(*BatchReadFeatureValuesRequest_BigqueryReadInstances)(nil),
	}
	file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[9].OneofWrappers = []any{
		(*ExportFeatureValuesRequest_SnapshotExport_)(nil),
		(*ExportFeatureValuesRequest_FullExport_)(nil),
	}
	file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[11].OneofWrappers = []any{
		(*FeatureValueDestination_BigqueryDestination)(nil),
		(*FeatureValueDestination_TfrecordDestination)(nil),
		(*FeatureValueDestination_CsvDestination)(nil),
	}
	file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[39].OneofWrappers = []any{
		(*DeleteFeatureValuesRequest_SelectEntity_)(nil),
		(*DeleteFeatureValuesRequest_SelectTimeRangeAndFeature_)(nil),
	}
	file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[40].OneofWrappers = []any{
		(*DeleteFeatureValuesResponse_SelectEntity_)(nil),
		(*DeleteFeatureValuesResponse_SelectTimeRangeAndFeature_)(nil),
	}
	file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes[41].OneofWrappers = []any{
		(*EntityIdSelector_CsvSource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   51,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_featurestore_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_featurestore_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_featurestore_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_featurestore_service_proto = out.File
	file_google_cloud_aiplatform_v1_featurestore_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_featurestore_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_featurestore_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// FeaturestoreServiceClient is the client API for FeaturestoreService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FeaturestoreServiceClient interface {
	// Creates a new Featurestore in a given project and location.
	CreateFeaturestore(ctx context.Context, in *CreateFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single Featurestore.
	GetFeaturestore(ctx context.Context, in *GetFeaturestoreRequest, opts ...grpc.CallOption) (*Featurestore, error)
	// Lists Featurestores in a given project and location.
	ListFeaturestores(ctx context.Context, in *ListFeaturestoresRequest, opts ...grpc.CallOption) (*ListFeaturestoresResponse, error)
	// Updates the parameters of a single Featurestore.
	UpdateFeaturestore(ctx context.Context, in *UpdateFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Featurestore. The Featurestore must not contain any
	// EntityTypes or `force` must be set to true for the request to succeed.
	DeleteFeaturestore(ctx context.Context, in *DeleteFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new EntityType in a given Featurestore.
	CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single EntityType.
	GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Lists EntityTypes in a given Featurestore.
	ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error)
	// Updates the parameters of a single EntityType.
	UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Deletes a single EntityType. The EntityType must not have any Features
	// or `force` must be set to true for the request to succeed.
	DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new Feature in a given EntityType.
	CreateFeature(ctx context.Context, in *CreateFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a batch of Features in a given EntityType.
	BatchCreateFeatures(ctx context.Context, in *BatchCreateFeaturesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single Feature.
	GetFeature(ctx context.Context, in *GetFeatureRequest, opts ...grpc.CallOption) (*Feature, error)
	// Lists Features in a given EntityType.
	ListFeatures(ctx context.Context, in *ListFeaturesRequest, opts ...grpc.CallOption) (*ListFeaturesResponse, error)
	// Updates the parameters of a single Feature.
	UpdateFeature(ctx context.Context, in *UpdateFeatureRequest, opts ...grpc.CallOption) (*Feature, error)
	// Deletes a single Feature.
	DeleteFeature(ctx context.Context, in *DeleteFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports Feature values into the Featurestore from a source storage.
	//
	// The progress of the import is tracked by the returned operation. The
	// imported features are guaranteed to be visible to subsequent read
	// operations after the operation is marked as successfully done.
	//
	// If an import operation fails, the Feature values returned from
	// reads and exports may be inconsistent. If consistency is
	// required, the caller must retry the same import request again and wait till
	// the new operation returned is marked as successfully done.
	//
	// There are also scenarios where the caller can cause inconsistency.
	//
	//   - Source data for import contains multiple distinct Feature values for
	//     the same entity ID and timestamp.
	//   - Source is modified during an import. This includes adding, updating, or
	//     removing source data and/or metadata. Examples of updating metadata
	//     include but are not limited to changing storage location, storage class,
	//     or retention policy.
	//   - Online serving cluster is under-provisioned.
	ImportFeatureValues(ctx context.Context, in *ImportFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Batch reads Feature values from a Featurestore.
	//
	// This API enables batch reading Feature values, where each read
	// instance in the batch may read Feature values of entities from one or
	// more EntityTypes. Point-in-time correctness is guaranteed for Feature
	// values of each read instance as of each instance's read timestamp.
	BatchReadFeatureValues(ctx context.Context, in *BatchReadFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports Feature values from all the entities of a target EntityType.
	ExportFeatureValues(ctx context.Context, in *ExportFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete Feature values from Featurestore.
	//
	// The progress of the deletion is tracked by the returned operation. The
	// deleted feature values are guaranteed to be invisible to subsequent read
	// operations after the operation is marked as successfully done.
	//
	// If a delete feature values operation fails, the feature values
	// returned from reads and exports may be inconsistent. If consistency is
	// required, the caller must retry the same delete request again and wait till
	// the new operation returned is marked as successfully done.
	DeleteFeatureValues(ctx context.Context, in *DeleteFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Searches Features matching a query in a given project.
	SearchFeatures(ctx context.Context, in *SearchFeaturesRequest, opts ...grpc.CallOption) (*SearchFeaturesResponse, error)
}

type featurestoreServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewFeaturestoreServiceClient(cc grpc.ClientConnInterface) FeaturestoreServiceClient {
	return &featurestoreServiceClient{cc}
}

func (c *featurestoreServiceClient) CreateFeaturestore(ctx context.Context, in *CreateFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/CreateFeaturestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) GetFeaturestore(ctx context.Context, in *GetFeaturestoreRequest, opts ...grpc.CallOption) (*Featurestore, error) {
	out := new(Featurestore)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/GetFeaturestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) ListFeaturestores(ctx context.Context, in *ListFeaturestoresRequest, opts ...grpc.CallOption) (*ListFeaturestoresResponse, error) {
	out := new(ListFeaturestoresResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/ListFeaturestores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) UpdateFeaturestore(ctx context.Context, in *UpdateFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/UpdateFeaturestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) DeleteFeaturestore(ctx context.Context, in *DeleteFeaturestoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/DeleteFeaturestore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/CreateEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/GetEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error) {
	out := new(ListEntityTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/ListEntityTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/UpdateEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/DeleteEntityType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) CreateFeature(ctx context.Context, in *CreateFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/CreateFeature", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) BatchCreateFeatures(ctx context.Context, in *BatchCreateFeaturesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/BatchCreateFeatures", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) GetFeature(ctx context.Context, in *GetFeatureRequest, opts ...grpc.CallOption) (*Feature, error) {
	out := new(Feature)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/GetFeature", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) ListFeatures(ctx context.Context, in *ListFeaturesRequest, opts ...grpc.CallOption) (*ListFeaturesResponse, error) {
	out := new(ListFeaturesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/ListFeatures", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) UpdateFeature(ctx context.Context, in *UpdateFeatureRequest, opts ...grpc.CallOption) (*Feature, error) {
	out := new(Feature)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/UpdateFeature", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) DeleteFeature(ctx context.Context, in *DeleteFeatureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/DeleteFeature", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) ImportFeatureValues(ctx context.Context, in *ImportFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/ImportFeatureValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) BatchReadFeatureValues(ctx context.Context, in *BatchReadFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/BatchReadFeatureValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) ExportFeatureValues(ctx context.Context, in *ExportFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/ExportFeatureValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) DeleteFeatureValues(ctx context.Context, in *DeleteFeatureValuesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/DeleteFeatureValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *featurestoreServiceClient) SearchFeatures(ctx context.Context, in *SearchFeaturesRequest, opts ...grpc.CallOption) (*SearchFeaturesResponse, error) {
	out := new(SearchFeaturesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.FeaturestoreService/SearchFeatures", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FeaturestoreServiceServer is the server API for FeaturestoreService service.
type FeaturestoreServiceServer interface {
	// Creates a new Featurestore in a given project and location.
	CreateFeaturestore(context.Context, *CreateFeaturestoreRequest) (*longrunningpb.Operation, error)
	// Gets details of a single Featurestore.
	GetFeaturestore(context.Context, *GetFeaturestoreRequest) (*Featurestore, error)
	// Lists Featurestores in a given project and location.
	ListFeaturestores(context.Context, *ListFeaturestoresRequest) (*ListFeaturestoresResponse, error)
	// Updates the parameters of a single Featurestore.
	UpdateFeaturestore(context.Context, *UpdateFeaturestoreRequest) (*longrunningpb.Operation, error)
	// Deletes a single Featurestore. The Featurestore must not contain any
	// EntityTypes or `force` must be set to true for the request to succeed.
	DeleteFeaturestore(context.Context, *DeleteFeaturestoreRequest) (*longrunningpb.Operation, error)
	// Creates a new EntityType in a given Featurestore.
	CreateEntityType(context.Context, *CreateEntityTypeRequest) (*longrunningpb.Operation, error)
	// Gets details of a single EntityType.
	GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error)
	// Lists EntityTypes in a given Featurestore.
	ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error)
	// Updates the parameters of a single EntityType.
	UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error)
	// Deletes a single EntityType. The EntityType must not have any Features
	// or `force` must be set to true for the request to succeed.
	DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*longrunningpb.Operation, error)
	// Creates a new Feature in a given EntityType.
	CreateFeature(context.Context, *CreateFeatureRequest) (*longrunningpb.Operation, error)
	// Creates a batch of Features in a given EntityType.
	BatchCreateFeatures(context.Context, *BatchCreateFeaturesRequest) (*longrunningpb.Operation, error)
	// Gets details of a single Feature.
	GetFeature(context.Context, *GetFeatureRequest) (*Feature, error)
	// Lists Features in a given EntityType.
	ListFeatures(context.Context, *ListFeaturesRequest) (*ListFeaturesResponse, error)
	// Updates the parameters of a single Feature.
	UpdateFeature(context.Context, *UpdateFeatureRequest) (*Feature, error)
	// Deletes a single Feature.
	DeleteFeature(context.Context, *DeleteFeatureRequest) (*longrunningpb.Operation, error)
	// Imports Feature values into the Featurestore from a source storage.
	//
	// The progress of the import is tracked by the returned operation. The
	// imported features are guaranteed to be visible to subsequent read
	// operations after the operation is marked as successfully done.
	//
	// If an import operation fails, the Feature values returned from
	// reads and exports may be inconsistent. If consistency is
	// required, the caller must retry the same import request again and wait till
	// the new operation returned is marked as successfully done.
	//
	// There are also scenarios where the caller can cause inconsistency.
	//
	//   - Source data for import contains multiple distinct Feature values for
	//     the same entity ID and timestamp.
	//   - Source is modified during an import. This includes adding, updating, or
	//     removing source data and/or metadata. Examples of updating metadata
	//     include but are not limited to changing storage location, storage class,
	//     or retention policy.
	//   - Online serving cluster is under-provisioned.
	ImportFeatureValues(context.Context, *ImportFeatureValuesRequest) (*longrunningpb.Operation, error)
	// Batch reads Feature values from a Featurestore.
	//
	// This API enables batch reading Feature values, where each read
	// instance in the batch may read Feature values of entities from one or
	// more EntityTypes. Point-in-time correctness is guaranteed for Feature
	// values of each read instance as of each instance's read timestamp.
	BatchReadFeatureValues(context.Context, *BatchReadFeatureValuesRequest) (*longrunningpb.Operation, error)
	// Exports Feature values from all the entities of a target EntityType.
	ExportFeatureValues(context.Context, *ExportFeatureValuesRequest) (*longrunningpb.Operation, error)
	// Delete Feature values from Featurestore.
	//
	// The progress of the deletion is tracked by the returned operation. The
	// deleted feature values are guaranteed to be invisible to subsequent read
	// operations after the operation is marked as successfully done.
	//
	// If a delete feature values operation fails, the feature values
	// returned from reads and exports may be inconsistent. If consistency is
	// required, the caller must retry the same delete request again and wait till
	// the new operation returned is marked as successfully done.
	DeleteFeatureValues(context.Context, *DeleteFeatureValuesRequest) (*longrunningpb.Operation, error)
	// Searches Features matching a query in a given project.
	SearchFeatures(context.Context, *SearchFeaturesRequest) (*SearchFeaturesResponse, error)
}

// UnimplementedFeaturestoreServiceServer can be embedded to have forward compatible implementations.
type UnimplementedFeaturestoreServiceServer struct {
}

func (*UnimplementedFeaturestoreServiceServer) CreateFeaturestore(context.Context, *CreateFeaturestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeaturestore not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) GetFeaturestore(context.Context, *GetFeaturestoreRequest) (*Featurestore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeaturestore not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) ListFeaturestores(context.Context, *ListFeaturestoresRequest) (*ListFeaturestoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeaturestores not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) UpdateFeaturestore(context.Context, *UpdateFeaturestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeaturestore not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) DeleteFeaturestore(context.Context, *DeleteFeaturestoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeaturestore not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) CreateEntityType(context.Context, *CreateEntityTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntityType not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntityType not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntityTypes not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntityType not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntityType not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) CreateFeature(context.Context, *CreateFeatureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeature not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) BatchCreateFeatures(context.Context, *BatchCreateFeaturesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateFeatures not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) GetFeature(context.Context, *GetFeatureRequest) (*Feature, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeature not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) ListFeatures(context.Context, *ListFeaturesRequest) (*ListFeaturesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeatures not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) UpdateFeature(context.Context, *UpdateFeatureRequest) (*Feature, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeature not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) DeleteFeature(context.Context, *DeleteFeatureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeature not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) ImportFeatureValues(context.Context, *ImportFeatureValuesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportFeatureValues not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) BatchReadFeatureValues(context.Context, *BatchReadFeatureValuesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchReadFeatureValues not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) ExportFeatureValues(context.Context, *ExportFeatureValuesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportFeatureValues not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) DeleteFeatureValues(context.Context, *DeleteFeatureValuesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeatureValues not implemented")
}
func (*UnimplementedFeaturestoreServiceServer) SearchFeatures(context.Context, *SearchFeaturesRequest) (*SearchFeaturesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchFeatures not implemented")
}

func RegisterFeaturestoreServiceServer(s *grpc.Server, srv FeaturestoreServiceServer) {
	s.RegisterService(&_FeaturestoreService_serviceDesc, srv)
}

func _FeaturestoreService_CreateFeaturestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeaturestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).CreateFeaturestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/CreateFeaturestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).CreateFeaturestore(ctx, req.(*CreateFeaturestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_GetFeaturestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeaturestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).GetFeaturestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/GetFeaturestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).GetFeaturestore(ctx, req.(*GetFeaturestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_ListFeaturestores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeaturestoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).ListFeaturestores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/ListFeaturestores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).ListFeaturestores(ctx, req.(*ListFeaturestoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_UpdateFeaturestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeaturestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).UpdateFeaturestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/UpdateFeaturestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).UpdateFeaturestore(ctx, req.(*UpdateFeaturestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_DeleteFeaturestore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeaturestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).DeleteFeaturestore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/DeleteFeaturestore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).DeleteFeaturestore(ctx, req.(*DeleteFeaturestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_CreateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).CreateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/CreateEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).CreateEntityType(ctx, req.(*CreateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_GetEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).GetEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/GetEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).GetEntityType(ctx, req.(*GetEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_ListEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).ListEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/ListEntityTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).ListEntityTypes(ctx, req.(*ListEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_UpdateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).UpdateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/UpdateEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).UpdateEntityType(ctx, req.(*UpdateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_DeleteEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).DeleteEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/DeleteEntityType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).DeleteEntityType(ctx, req.(*DeleteEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_CreateFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).CreateFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/CreateFeature",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).CreateFeature(ctx, req.(*CreateFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_BatchCreateFeatures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateFeaturesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).BatchCreateFeatures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/BatchCreateFeatures",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).BatchCreateFeatures(ctx, req.(*BatchCreateFeaturesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_GetFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).GetFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/GetFeature",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).GetFeature(ctx, req.(*GetFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_ListFeatures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeaturesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).ListFeatures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/ListFeatures",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).ListFeatures(ctx, req.(*ListFeaturesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_UpdateFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).UpdateFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/UpdateFeature",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).UpdateFeature(ctx, req.(*UpdateFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_DeleteFeature_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeatureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).DeleteFeature(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/DeleteFeature",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).DeleteFeature(ctx, req.(*DeleteFeatureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_ImportFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).ImportFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/ImportFeatureValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).ImportFeatureValues(ctx, req.(*ImportFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_BatchReadFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchReadFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).BatchReadFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/BatchReadFeatureValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).BatchReadFeatureValues(ctx, req.(*BatchReadFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_ExportFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).ExportFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/ExportFeatureValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).ExportFeatureValues(ctx, req.(*ExportFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_DeleteFeatureValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeatureValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).DeleteFeatureValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/DeleteFeatureValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).DeleteFeatureValues(ctx, req.(*DeleteFeatureValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FeaturestoreService_SearchFeatures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchFeaturesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FeaturestoreServiceServer).SearchFeatures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.FeaturestoreService/SearchFeatures",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FeaturestoreServiceServer).SearchFeatures(ctx, req.(*SearchFeaturesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FeaturestoreService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.FeaturestoreService",
	HandlerType: (*FeaturestoreServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateFeaturestore",
			Handler:    _FeaturestoreService_CreateFeaturestore_Handler,
		},
		{
			MethodName: "GetFeaturestore",
			Handler:    _FeaturestoreService_GetFeaturestore_Handler,
		},
		{
			MethodName: "ListFeaturestores",
			Handler:    _FeaturestoreService_ListFeaturestores_Handler,
		},
		{
			MethodName: "UpdateFeaturestore",
			Handler:    _FeaturestoreService_UpdateFeaturestore_Handler,
		},
		{
			MethodName: "DeleteFeaturestore",
			Handler:    _FeaturestoreService_DeleteFeaturestore_Handler,
		},
		{
			MethodName: "CreateEntityType",
			Handler:    _FeaturestoreService_CreateEntityType_Handler,
		},
		{
			MethodName: "GetEntityType",
			Handler:    _FeaturestoreService_GetEntityType_Handler,
		},
		{
			MethodName: "ListEntityTypes",
			Handler:    _FeaturestoreService_ListEntityTypes_Handler,
		},
		{
			MethodName: "UpdateEntityType",
			Handler:    _FeaturestoreService_UpdateEntityType_Handler,
		},
		{
			MethodName: "DeleteEntityType",
			Handler:    _FeaturestoreService_DeleteEntityType_Handler,
		},
		{
			MethodName: "CreateFeature",
			Handler:    _FeaturestoreService_CreateFeature_Handler,
		},
		{
			MethodName: "BatchCreateFeatures",
			Handler:    _FeaturestoreService_BatchCreateFeatures_Handler,
		},
		{
			MethodName: "GetFeature",
			Handler:    _FeaturestoreService_GetFeature_Handler,
		},
		{
			MethodName: "ListFeatures",
			Handler:    _FeaturestoreService_ListFeatures_Handler,
		},
		{
			MethodName: "UpdateFeature",
			Handler:    _FeaturestoreService_UpdateFeature_Handler,
		},
		{
			MethodName: "DeleteFeature",
			Handler:    _FeaturestoreService_DeleteFeature_Handler,
		},
		{
			MethodName: "ImportFeatureValues",
			Handler:    _FeaturestoreService_ImportFeatureValues_Handler,
		},
		{
			MethodName: "BatchReadFeatureValues",
			Handler:    _FeaturestoreService_BatchReadFeatureValues_Handler,
		},
		{
			MethodName: "ExportFeatureValues",
			Handler:    _FeaturestoreService_ExportFeatureValues_Handler,
		},
		{
			MethodName: "DeleteFeatureValues",
			Handler:    _FeaturestoreService_DeleteFeatureValues_Handler,
		},
		{
			MethodName: "SearchFeatures",
			Handler:    _FeaturestoreService_SearchFeatures_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/featurestore_service.proto",
}
