// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/chat/v1/widgets.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The set of supported icons.
type WidgetMarkup_Icon int32

const (
	WidgetMarkup_ICON_UNSPECIFIED         WidgetMarkup_Icon = 0
	WidgetMarkup_AIRPLANE                 WidgetMarkup_Icon = 1
	WidgetMarkup_BOOKMARK                 WidgetMarkup_Icon = 26
	WidgetMarkup_BUS                      WidgetMarkup_Icon = 25
	WidgetMarkup_CAR                      WidgetMarkup_Icon = 9
	WidgetMarkup_CLOCK                    WidgetMarkup_Icon = 2
	WidgetMarkup_CONFIRMATION_NUMBER_ICON WidgetMarkup_Icon = 12
	WidgetMarkup_DOLLAR                   WidgetMarkup_Icon = 14
	WidgetMarkup_DESCRIPTION              WidgetMarkup_Icon = 27
	WidgetMarkup_EMAIL                    WidgetMarkup_Icon = 10
	WidgetMarkup_EVENT_PERFORMER          WidgetMarkup_Icon = 20
	WidgetMarkup_EVENT_SEAT               WidgetMarkup_Icon = 21
	WidgetMarkup_FLIGHT_ARRIVAL           WidgetMarkup_Icon = 16
	WidgetMarkup_FLIGHT_DEPARTURE         WidgetMarkup_Icon = 15
	WidgetMarkup_HOTEL                    WidgetMarkup_Icon = 6
	WidgetMarkup_HOTEL_ROOM_TYPE          WidgetMarkup_Icon = 17
	WidgetMarkup_INVITE                   WidgetMarkup_Icon = 19
	WidgetMarkup_MAP_PIN                  WidgetMarkup_Icon = 3
	WidgetMarkup_MEMBERSHIP               WidgetMarkup_Icon = 24
	WidgetMarkup_MULTIPLE_PEOPLE          WidgetMarkup_Icon = 18
	WidgetMarkup_OFFER                    WidgetMarkup_Icon = 30
	WidgetMarkup_PERSON                   WidgetMarkup_Icon = 11
	WidgetMarkup_PHONE                    WidgetMarkup_Icon = 13
	WidgetMarkup_RESTAURANT_ICON          WidgetMarkup_Icon = 7
	WidgetMarkup_SHOPPING_CART            WidgetMarkup_Icon = 8
	WidgetMarkup_STAR                     WidgetMarkup_Icon = 5
	WidgetMarkup_STORE                    WidgetMarkup_Icon = 22
	WidgetMarkup_TICKET                   WidgetMarkup_Icon = 4
	WidgetMarkup_TRAIN                    WidgetMarkup_Icon = 23
	WidgetMarkup_VIDEO_CAMERA             WidgetMarkup_Icon = 28
	WidgetMarkup_VIDEO_PLAY               WidgetMarkup_Icon = 29
)

// Enum value maps for WidgetMarkup_Icon.
var (
	WidgetMarkup_Icon_name = map[int32]string{
		0:  "ICON_UNSPECIFIED",
		1:  "AIRPLANE",
		26: "BOOKMARK",
		25: "BUS",
		9:  "CAR",
		2:  "CLOCK",
		12: "CONFIRMATION_NUMBER_ICON",
		14: "DOLLAR",
		27: "DESCRIPTION",
		10: "EMAIL",
		20: "EVENT_PERFORMER",
		21: "EVENT_SEAT",
		16: "FLIGHT_ARRIVAL",
		15: "FLIGHT_DEPARTURE",
		6:  "HOTEL",
		17: "HOTEL_ROOM_TYPE",
		19: "INVITE",
		3:  "MAP_PIN",
		24: "MEMBERSHIP",
		18: "MULTIPLE_PEOPLE",
		30: "OFFER",
		11: "PERSON",
		13: "PHONE",
		7:  "RESTAURANT_ICON",
		8:  "SHOPPING_CART",
		5:  "STAR",
		22: "STORE",
		4:  "TICKET",
		23: "TRAIN",
		28: "VIDEO_CAMERA",
		29: "VIDEO_PLAY",
	}
	WidgetMarkup_Icon_value = map[string]int32{
		"ICON_UNSPECIFIED":         0,
		"AIRPLANE":                 1,
		"BOOKMARK":                 26,
		"BUS":                      25,
		"CAR":                      9,
		"CLOCK":                    2,
		"CONFIRMATION_NUMBER_ICON": 12,
		"DOLLAR":                   14,
		"DESCRIPTION":              27,
		"EMAIL":                    10,
		"EVENT_PERFORMER":          20,
		"EVENT_SEAT":               21,
		"FLIGHT_ARRIVAL":           16,
		"FLIGHT_DEPARTURE":         15,
		"HOTEL":                    6,
		"HOTEL_ROOM_TYPE":          17,
		"INVITE":                   19,
		"MAP_PIN":                  3,
		"MEMBERSHIP":               24,
		"MULTIPLE_PEOPLE":          18,
		"OFFER":                    30,
		"PERSON":                   11,
		"PHONE":                    13,
		"RESTAURANT_ICON":          7,
		"SHOPPING_CART":            8,
		"STAR":                     5,
		"STORE":                    22,
		"TICKET":                   4,
		"TRAIN":                    23,
		"VIDEO_CAMERA":             28,
		"VIDEO_PLAY":               29,
	}
)

func (x WidgetMarkup_Icon) Enum() *WidgetMarkup_Icon {
	p := new(WidgetMarkup_Icon)
	*p = x
	return p
}

func (x WidgetMarkup_Icon) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WidgetMarkup_Icon) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_widgets_proto_enumTypes[0].Descriptor()
}

func (WidgetMarkup_Icon) Type() protoreflect.EnumType {
	return &file_google_chat_v1_widgets_proto_enumTypes[0]
}

func (x WidgetMarkup_Icon) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WidgetMarkup_Icon.Descriptor instead.
func (WidgetMarkup_Icon) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0, 0}
}

// A widget is a UI element that presents text and images.
type WidgetMarkup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A `WidgetMarkup` can only have one of the following items. You can use
	// multiple `WidgetMarkup` fields to display more items.
	//
	// Types that are assignable to Data:
	//
	//	*WidgetMarkup_TextParagraph_
	//	*WidgetMarkup_Image_
	//	*WidgetMarkup_KeyValue_
	Data isWidgetMarkup_Data `protobuf_oneof:"data"`
	// A list of buttons. Buttons is also `oneof data` and only one of these
	// fields should be set.
	Buttons []*WidgetMarkup_Button `protobuf:"bytes,6,rep,name=buttons,proto3" json:"buttons,omitempty"`
}

func (x *WidgetMarkup) Reset() {
	*x = WidgetMarkup{}
	mi := &file_google_chat_v1_widgets_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WidgetMarkup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WidgetMarkup) ProtoMessage() {}

func (x *WidgetMarkup) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_widgets_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WidgetMarkup.ProtoReflect.Descriptor instead.
func (*WidgetMarkup) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0}
}

func (m *WidgetMarkup) GetData() isWidgetMarkup_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *WidgetMarkup) GetTextParagraph() *WidgetMarkup_TextParagraph {
	if x, ok := x.GetData().(*WidgetMarkup_TextParagraph_); ok {
		return x.TextParagraph
	}
	return nil
}

func (x *WidgetMarkup) GetImage() *WidgetMarkup_Image {
	if x, ok := x.GetData().(*WidgetMarkup_Image_); ok {
		return x.Image
	}
	return nil
}

func (x *WidgetMarkup) GetKeyValue() *WidgetMarkup_KeyValue {
	if x, ok := x.GetData().(*WidgetMarkup_KeyValue_); ok {
		return x.KeyValue
	}
	return nil
}

func (x *WidgetMarkup) GetButtons() []*WidgetMarkup_Button {
	if x != nil {
		return x.Buttons
	}
	return nil
}

type isWidgetMarkup_Data interface {
	isWidgetMarkup_Data()
}

type WidgetMarkup_TextParagraph_ struct {
	// Display a text paragraph in this widget.
	TextParagraph *WidgetMarkup_TextParagraph `protobuf:"bytes,1,opt,name=text_paragraph,json=textParagraph,proto3,oneof"`
}

type WidgetMarkup_Image_ struct {
	// Display an image in this widget.
	Image *WidgetMarkup_Image `protobuf:"bytes,2,opt,name=image,proto3,oneof"`
}

type WidgetMarkup_KeyValue_ struct {
	// Display a key value item in this widget.
	KeyValue *WidgetMarkup_KeyValue `protobuf:"bytes,3,opt,name=key_value,json=keyValue,proto3,oneof"`
}

func (*WidgetMarkup_TextParagraph_) isWidgetMarkup_Data() {}

func (*WidgetMarkup_Image_) isWidgetMarkup_Data() {}

func (*WidgetMarkup_KeyValue_) isWidgetMarkup_Data() {}

// A paragraph of text. Formatted text supported. For more information
// about formatting text, see
// [Formatting text in Google Chat
// apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
// and
// [Formatting
// text in Google Workspace
// Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
type WidgetMarkup_TextParagraph struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *WidgetMarkup_TextParagraph) Reset() {
	*x = WidgetMarkup_TextParagraph{}
	mi := &file_google_chat_v1_widgets_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WidgetMarkup_TextParagraph) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WidgetMarkup_TextParagraph) ProtoMessage() {}

func (x *WidgetMarkup_TextParagraph) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_widgets_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WidgetMarkup_TextParagraph.ProtoReflect.Descriptor instead.
func (*WidgetMarkup_TextParagraph) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0, 0}
}

func (x *WidgetMarkup_TextParagraph) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// A button. Can be a text button or an image button.
type WidgetMarkup_Button struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*WidgetMarkup_Button_TextButton
	//	*WidgetMarkup_Button_ImageButton
	Type isWidgetMarkup_Button_Type `protobuf_oneof:"type"`
}

func (x *WidgetMarkup_Button) Reset() {
	*x = WidgetMarkup_Button{}
	mi := &file_google_chat_v1_widgets_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WidgetMarkup_Button) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WidgetMarkup_Button) ProtoMessage() {}

func (x *WidgetMarkup_Button) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_widgets_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WidgetMarkup_Button.ProtoReflect.Descriptor instead.
func (*WidgetMarkup_Button) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0, 1}
}

func (m *WidgetMarkup_Button) GetType() isWidgetMarkup_Button_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *WidgetMarkup_Button) GetTextButton() *WidgetMarkup_TextButton {
	if x, ok := x.GetType().(*WidgetMarkup_Button_TextButton); ok {
		return x.TextButton
	}
	return nil
}

func (x *WidgetMarkup_Button) GetImageButton() *WidgetMarkup_ImageButton {
	if x, ok := x.GetType().(*WidgetMarkup_Button_ImageButton); ok {
		return x.ImageButton
	}
	return nil
}

type isWidgetMarkup_Button_Type interface {
	isWidgetMarkup_Button_Type()
}

type WidgetMarkup_Button_TextButton struct {
	// A button with text and `onclick` action.
	TextButton *WidgetMarkup_TextButton `protobuf:"bytes,1,opt,name=text_button,json=textButton,proto3,oneof"`
}

type WidgetMarkup_Button_ImageButton struct {
	// A button with image and `onclick` action.
	ImageButton *WidgetMarkup_ImageButton `protobuf:"bytes,2,opt,name=image_button,json=imageButton,proto3,oneof"`
}

func (*WidgetMarkup_Button_TextButton) isWidgetMarkup_Button_Type() {}

func (*WidgetMarkup_Button_ImageButton) isWidgetMarkup_Button_Type() {}

// A button with text and `onclick` action.
type WidgetMarkup_TextButton struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text of the button.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The `onclick` action of the button.
	OnClick *WidgetMarkup_OnClick `protobuf:"bytes,2,opt,name=on_click,json=onClick,proto3" json:"on_click,omitempty"`
}

func (x *WidgetMarkup_TextButton) Reset() {
	*x = WidgetMarkup_TextButton{}
	mi := &file_google_chat_v1_widgets_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WidgetMarkup_TextButton) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WidgetMarkup_TextButton) ProtoMessage() {}

func (x *WidgetMarkup_TextButton) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_widgets_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WidgetMarkup_TextButton.ProtoReflect.Descriptor instead.
func (*WidgetMarkup_TextButton) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0, 2}
}

func (x *WidgetMarkup_TextButton) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *WidgetMarkup_TextButton) GetOnClick() *WidgetMarkup_OnClick {
	if x != nil {
		return x.OnClick
	}
	return nil
}

// A UI element contains a key (label) and a value (content). This
// element can also contain some actions such as `onclick` button.
type WidgetMarkup_KeyValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// At least one of icons, `top_label` and `bottom_label` must be defined.
	//
	// Types that are assignable to Icons:
	//
	//	*WidgetMarkup_KeyValue_Icon
	//	*WidgetMarkup_KeyValue_IconUrl
	Icons isWidgetMarkup_KeyValue_Icons `protobuf_oneof:"icons"`
	// The text of the top label. Formatted text supported. For more information
	// about formatting text, see
	// [Formatting text in Google Chat
	// apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
	// and
	// [Formatting
	// text in Google Workspace
	// Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
	TopLabel string `protobuf:"bytes,3,opt,name=top_label,json=topLabel,proto3" json:"top_label,omitempty"`
	// The text of the content. Formatted text supported and always required.
	// For more information
	// about formatting text, see
	// [Formatting text in Google Chat
	// apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
	// and
	// [Formatting
	// text in Google Workspace
	// Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
	Content string `protobuf:"bytes,4,opt,name=content,proto3" json:"content,omitempty"`
	// If the content should be multiline.
	ContentMultiline bool `protobuf:"varint,9,opt,name=content_multiline,json=contentMultiline,proto3" json:"content_multiline,omitempty"`
	// The text of the bottom label. Formatted text supported. For more
	// information about formatting text, see [Formatting text in Google Chat
	// apps](https://developers.google.com/workspace/chat/format-messages#card-formatting)
	// and
	// [Formatting
	// text in Google Workspace
	// Add-ons](https://developers.google.com/apps-script/add-ons/concepts/widgets#text_formatting).
	BottomLabel string `protobuf:"bytes,5,opt,name=bottom_label,json=bottomLabel,proto3" json:"bottom_label,omitempty"`
	// The `onclick` action. Only the top label, bottom label, and content
	// region are clickable.
	OnClick *WidgetMarkup_OnClick `protobuf:"bytes,6,opt,name=on_click,json=onClick,proto3" json:"on_click,omitempty"`
	// A control widget. You can set either `button` or `switch_widget`,
	// but not both.
	//
	// Types that are assignable to Control:
	//
	//	*WidgetMarkup_KeyValue_Button
	Control isWidgetMarkup_KeyValue_Control `protobuf_oneof:"control"`
}

func (x *WidgetMarkup_KeyValue) Reset() {
	*x = WidgetMarkup_KeyValue{}
	mi := &file_google_chat_v1_widgets_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WidgetMarkup_KeyValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WidgetMarkup_KeyValue) ProtoMessage() {}

func (x *WidgetMarkup_KeyValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_widgets_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WidgetMarkup_KeyValue.ProtoReflect.Descriptor instead.
func (*WidgetMarkup_KeyValue) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0, 3}
}

func (m *WidgetMarkup_KeyValue) GetIcons() isWidgetMarkup_KeyValue_Icons {
	if m != nil {
		return m.Icons
	}
	return nil
}

func (x *WidgetMarkup_KeyValue) GetIcon() WidgetMarkup_Icon {
	if x, ok := x.GetIcons().(*WidgetMarkup_KeyValue_Icon); ok {
		return x.Icon
	}
	return WidgetMarkup_ICON_UNSPECIFIED
}

func (x *WidgetMarkup_KeyValue) GetIconUrl() string {
	if x, ok := x.GetIcons().(*WidgetMarkup_KeyValue_IconUrl); ok {
		return x.IconUrl
	}
	return ""
}

func (x *WidgetMarkup_KeyValue) GetTopLabel() string {
	if x != nil {
		return x.TopLabel
	}
	return ""
}

func (x *WidgetMarkup_KeyValue) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *WidgetMarkup_KeyValue) GetContentMultiline() bool {
	if x != nil {
		return x.ContentMultiline
	}
	return false
}

func (x *WidgetMarkup_KeyValue) GetBottomLabel() string {
	if x != nil {
		return x.BottomLabel
	}
	return ""
}

func (x *WidgetMarkup_KeyValue) GetOnClick() *WidgetMarkup_OnClick {
	if x != nil {
		return x.OnClick
	}
	return nil
}

func (m *WidgetMarkup_KeyValue) GetControl() isWidgetMarkup_KeyValue_Control {
	if m != nil {
		return m.Control
	}
	return nil
}

func (x *WidgetMarkup_KeyValue) GetButton() *WidgetMarkup_Button {
	if x, ok := x.GetControl().(*WidgetMarkup_KeyValue_Button); ok {
		return x.Button
	}
	return nil
}

type isWidgetMarkup_KeyValue_Icons interface {
	isWidgetMarkup_KeyValue_Icons()
}

type WidgetMarkup_KeyValue_Icon struct {
	// An enum value that's replaced by the Chat API with the
	// corresponding icon image.
	Icon WidgetMarkup_Icon `protobuf:"varint,1,opt,name=icon,proto3,enum=google.chat.v1.WidgetMarkup_Icon,oneof"`
}

type WidgetMarkup_KeyValue_IconUrl struct {
	// The icon specified by a URL.
	IconUrl string `protobuf:"bytes,2,opt,name=icon_url,json=iconUrl,proto3,oneof"`
}

func (*WidgetMarkup_KeyValue_Icon) isWidgetMarkup_KeyValue_Icons() {}

func (*WidgetMarkup_KeyValue_IconUrl) isWidgetMarkup_KeyValue_Icons() {}

type isWidgetMarkup_KeyValue_Control interface {
	isWidgetMarkup_KeyValue_Control()
}

type WidgetMarkup_KeyValue_Button struct {
	// A button that can be clicked to trigger an action.
	Button *WidgetMarkup_Button `protobuf:"bytes,7,opt,name=button,proto3,oneof"`
}

func (*WidgetMarkup_KeyValue_Button) isWidgetMarkup_KeyValue_Control() {}

// An image that's specified by a URL and can have an `onclick` action.
type WidgetMarkup_Image struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL of the image.
	ImageUrl string `protobuf:"bytes,1,opt,name=image_url,json=imageUrl,proto3" json:"image_url,omitempty"`
	// The `onclick` action.
	OnClick *WidgetMarkup_OnClick `protobuf:"bytes,2,opt,name=on_click,json=onClick,proto3" json:"on_click,omitempty"`
	// The aspect ratio of this image (width and height). This field lets you
	// reserve the right height for the image while waiting for it to load.
	// It's not meant to override the built-in aspect ratio of the image.
	// If unset, the server fills it by prefetching the image.
	AspectRatio float64 `protobuf:"fixed64,3,opt,name=aspect_ratio,json=aspectRatio,proto3" json:"aspect_ratio,omitempty"`
}

func (x *WidgetMarkup_Image) Reset() {
	*x = WidgetMarkup_Image{}
	mi := &file_google_chat_v1_widgets_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WidgetMarkup_Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WidgetMarkup_Image) ProtoMessage() {}

func (x *WidgetMarkup_Image) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_widgets_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WidgetMarkup_Image.ProtoReflect.Descriptor instead.
func (*WidgetMarkup_Image) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0, 4}
}

func (x *WidgetMarkup_Image) GetImageUrl() string {
	if x != nil {
		return x.ImageUrl
	}
	return ""
}

func (x *WidgetMarkup_Image) GetOnClick() *WidgetMarkup_OnClick {
	if x != nil {
		return x.OnClick
	}
	return nil
}

func (x *WidgetMarkup_Image) GetAspectRatio() float64 {
	if x != nil {
		return x.AspectRatio
	}
	return 0
}

// An image button with an `onclick` action.
type WidgetMarkup_ImageButton struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The icon can be specified by an `Icon` `enum` or a URL.
	//
	// Types that are assignable to Icons:
	//
	//	*WidgetMarkup_ImageButton_Icon
	//	*WidgetMarkup_ImageButton_IconUrl
	Icons isWidgetMarkup_ImageButton_Icons `protobuf_oneof:"icons"`
	// The `onclick` action.
	OnClick *WidgetMarkup_OnClick `protobuf:"bytes,2,opt,name=on_click,json=onClick,proto3" json:"on_click,omitempty"`
	// The name of this `image_button` that's used for accessibility.
	// Default value is provided if this name isn't specified.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *WidgetMarkup_ImageButton) Reset() {
	*x = WidgetMarkup_ImageButton{}
	mi := &file_google_chat_v1_widgets_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WidgetMarkup_ImageButton) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WidgetMarkup_ImageButton) ProtoMessage() {}

func (x *WidgetMarkup_ImageButton) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_widgets_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WidgetMarkup_ImageButton.ProtoReflect.Descriptor instead.
func (*WidgetMarkup_ImageButton) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0, 5}
}

func (m *WidgetMarkup_ImageButton) GetIcons() isWidgetMarkup_ImageButton_Icons {
	if m != nil {
		return m.Icons
	}
	return nil
}

func (x *WidgetMarkup_ImageButton) GetIcon() WidgetMarkup_Icon {
	if x, ok := x.GetIcons().(*WidgetMarkup_ImageButton_Icon); ok {
		return x.Icon
	}
	return WidgetMarkup_ICON_UNSPECIFIED
}

func (x *WidgetMarkup_ImageButton) GetIconUrl() string {
	if x, ok := x.GetIcons().(*WidgetMarkup_ImageButton_IconUrl); ok {
		return x.IconUrl
	}
	return ""
}

func (x *WidgetMarkup_ImageButton) GetOnClick() *WidgetMarkup_OnClick {
	if x != nil {
		return x.OnClick
	}
	return nil
}

func (x *WidgetMarkup_ImageButton) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isWidgetMarkup_ImageButton_Icons interface {
	isWidgetMarkup_ImageButton_Icons()
}

type WidgetMarkup_ImageButton_Icon struct {
	// The icon specified by an `enum` that indices to an icon provided by
	// Chat API.
	Icon WidgetMarkup_Icon `protobuf:"varint,1,opt,name=icon,proto3,enum=google.chat.v1.WidgetMarkup_Icon,oneof"`
}

type WidgetMarkup_ImageButton_IconUrl struct {
	// The icon specified by a URL.
	IconUrl string `protobuf:"bytes,3,opt,name=icon_url,json=iconUrl,proto3,oneof"`
}

func (*WidgetMarkup_ImageButton_Icon) isWidgetMarkup_ImageButton_Icons() {}

func (*WidgetMarkup_ImageButton_IconUrl) isWidgetMarkup_ImageButton_Icons() {}

// An `onclick` action (for example, open a link).
type WidgetMarkup_OnClick struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Data:
	//
	//	*WidgetMarkup_OnClick_Action
	//	*WidgetMarkup_OnClick_OpenLink
	Data isWidgetMarkup_OnClick_Data `protobuf_oneof:"data"`
}

func (x *WidgetMarkup_OnClick) Reset() {
	*x = WidgetMarkup_OnClick{}
	mi := &file_google_chat_v1_widgets_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WidgetMarkup_OnClick) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WidgetMarkup_OnClick) ProtoMessage() {}

func (x *WidgetMarkup_OnClick) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_widgets_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WidgetMarkup_OnClick.ProtoReflect.Descriptor instead.
func (*WidgetMarkup_OnClick) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0, 6}
}

func (m *WidgetMarkup_OnClick) GetData() isWidgetMarkup_OnClick_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *WidgetMarkup_OnClick) GetAction() *WidgetMarkup_FormAction {
	if x, ok := x.GetData().(*WidgetMarkup_OnClick_Action); ok {
		return x.Action
	}
	return nil
}

func (x *WidgetMarkup_OnClick) GetOpenLink() *WidgetMarkup_OpenLink {
	if x, ok := x.GetData().(*WidgetMarkup_OnClick_OpenLink); ok {
		return x.OpenLink
	}
	return nil
}

type isWidgetMarkup_OnClick_Data interface {
	isWidgetMarkup_OnClick_Data()
}

type WidgetMarkup_OnClick_Action struct {
	// A form action is triggered by this `onclick` action if specified.
	Action *WidgetMarkup_FormAction `protobuf:"bytes,1,opt,name=action,proto3,oneof"`
}

type WidgetMarkup_OnClick_OpenLink struct {
	// This `onclick` action triggers an open link action if specified.
	OpenLink *WidgetMarkup_OpenLink `protobuf:"bytes,2,opt,name=open_link,json=openLink,proto3,oneof"`
}

func (*WidgetMarkup_OnClick_Action) isWidgetMarkup_OnClick_Data() {}

func (*WidgetMarkup_OnClick_OpenLink) isWidgetMarkup_OnClick_Data() {}

// A link that opens a new window.
type WidgetMarkup_OpenLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL to open.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *WidgetMarkup_OpenLink) Reset() {
	*x = WidgetMarkup_OpenLink{}
	mi := &file_google_chat_v1_widgets_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WidgetMarkup_OpenLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WidgetMarkup_OpenLink) ProtoMessage() {}

func (x *WidgetMarkup_OpenLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_widgets_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WidgetMarkup_OpenLink.ProtoReflect.Descriptor instead.
func (*WidgetMarkup_OpenLink) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0, 7}
}

func (x *WidgetMarkup_OpenLink) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// A form action describes the behavior when the form is submitted.
// For example, you can invoke Apps Script to handle the form.
type WidgetMarkup_FormAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The method name is used to identify which part of the form triggered the
	// form submission. This information is echoed back to the Chat app as part
	// of the card click event. You can use the same method name for several
	// elements that trigger a common behavior.
	ActionMethodName string `protobuf:"bytes,1,opt,name=action_method_name,json=actionMethodName,proto3" json:"action_method_name,omitempty"`
	// List of action parameters.
	Parameters []*WidgetMarkup_FormAction_ActionParameter `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *WidgetMarkup_FormAction) Reset() {
	*x = WidgetMarkup_FormAction{}
	mi := &file_google_chat_v1_widgets_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WidgetMarkup_FormAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WidgetMarkup_FormAction) ProtoMessage() {}

func (x *WidgetMarkup_FormAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_widgets_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WidgetMarkup_FormAction.ProtoReflect.Descriptor instead.
func (*WidgetMarkup_FormAction) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0, 8}
}

func (x *WidgetMarkup_FormAction) GetActionMethodName() string {
	if x != nil {
		return x.ActionMethodName
	}
	return ""
}

func (x *WidgetMarkup_FormAction) GetParameters() []*WidgetMarkup_FormAction_ActionParameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// List of string parameters to supply when the action method is invoked.
// For example, consider three snooze buttons: snooze now, snooze one day,
// snooze next week. You might use `action method = snooze()`, passing the
// snooze type and snooze time in the list of string parameters.
type WidgetMarkup_FormAction_ActionParameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the parameter for the action script.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value of the parameter.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *WidgetMarkup_FormAction_ActionParameter) Reset() {
	*x = WidgetMarkup_FormAction_ActionParameter{}
	mi := &file_google_chat_v1_widgets_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WidgetMarkup_FormAction_ActionParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WidgetMarkup_FormAction_ActionParameter) ProtoMessage() {}

func (x *WidgetMarkup_FormAction_ActionParameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_widgets_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WidgetMarkup_FormAction_ActionParameter.ProtoReflect.Descriptor instead.
func (*WidgetMarkup_FormAction_ActionParameter) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_widgets_proto_rawDescGZIP(), []int{0, 8, 0}
}

func (x *WidgetMarkup_FormAction_ActionParameter) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *WidgetMarkup_FormAction_ActionParameter) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_google_chat_v1_widgets_proto protoreflect.FileDescriptor

var file_google_chat_v1_widgets_proto_rawDesc = []byte{
	0x0a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x22, 0x9e,
	0x11, 0x0a, 0x0c, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x12,
	0x53, 0x0a, 0x0e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d,
	0x61, 0x72, 0x6b, 0x75, 0x70, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x50, 0x61, 0x72, 0x61, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x65, 0x78, 0x74, 0x50, 0x61, 0x72, 0x61, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x12, 0x3a, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x75,
	0x70, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x12, 0x44, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x75,
	0x70, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x08, 0x6b, 0x65,
	0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3d, 0x0a, 0x07, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d,
	0x61, 0x72, 0x6b, 0x75, 0x70, 0x2e, 0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x52, 0x07, 0x62, 0x75,
	0x74, 0x74, 0x6f, 0x6e, 0x73, 0x1a, 0x23, 0x0a, 0x0d, 0x54, 0x65, 0x78, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x67, 0x72, 0x61, 0x70, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x1a, 0xab, 0x01, 0x0a, 0x06, 0x42,
	0x75, 0x74, 0x74, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x62, 0x75,
	0x74, 0x74, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67,
	0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x42, 0x75, 0x74,
	0x74, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x42, 0x75, 0x74, 0x74, 0x6f,
	0x6e, 0x12, 0x4d, 0x0a, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x75, 0x74, 0x74, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d,
	0x61, 0x72, 0x6b, 0x75, 0x70, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x75, 0x74, 0x74, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e,
	0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x61, 0x0a, 0x0a, 0x54, 0x65, 0x78, 0x74,
	0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x3f, 0x0a, 0x08, 0x6f, 0x6e,
	0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69,
	0x64, 0x67, 0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x2e, 0x4f, 0x6e, 0x43, 0x6c, 0x69,
	0x63, 0x6b, 0x52, 0x07, 0x6f, 0x6e, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x1a, 0xfb, 0x02, 0x0a, 0x08,
	0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x37, 0x0a, 0x04, 0x69, 0x63, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x61,
	0x72, 0x6b, 0x75, 0x70, 0x2e, 0x49, 0x63, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x04, 0x69, 0x63, 0x6f,
	0x6e, 0x12, 0x1b, 0x0a, 0x08, 0x69, 0x63, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x07, 0x69, 0x63, 0x6f, 0x6e, 0x55, 0x72, 0x6c, 0x12, 0x1b,
	0x0a, 0x09, 0x74, 0x6f, 0x70, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x74, 0x6f, 0x70, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x6c, 0x69,
	0x6e, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x3f, 0x0a, 0x08, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x69, 0x63,
	0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d,
	0x61, 0x72, 0x6b, 0x75, 0x70, 0x2e, 0x4f, 0x6e, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x52, 0x07, 0x6f,
	0x6e, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x12, 0x3d, 0x0a, 0x06, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x61,
	0x72, 0x6b, 0x75, 0x70, 0x2e, 0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x06, 0x62,
	0x75, 0x74, 0x74, 0x6f, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x69, 0x63, 0x6f, 0x6e, 0x73, 0x42, 0x09,
	0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x1a, 0x88, 0x01, 0x0a, 0x05, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x6c,
	0x12, 0x3f, 0x0a, 0x08, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70,
	0x2e, 0x4f, 0x6e, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x52, 0x07, 0x6f, 0x6e, 0x43, 0x6c, 0x69, 0x63,
	0x6b, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x52,
	0x61, 0x74, 0x69, 0x6f, 0x1a, 0xc1, 0x01, 0x0a, 0x0b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x75,
	0x74, 0x74, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x04, 0x69, 0x63, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70,
	0x2e, 0x49, 0x63, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x04, 0x69, 0x63, 0x6f, 0x6e, 0x12, 0x1b, 0x0a,
	0x08, 0x69, 0x63, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x07, 0x69, 0x63, 0x6f, 0x6e, 0x55, 0x72, 0x6c, 0x12, 0x3f, 0x0a, 0x08, 0x6f, 0x6e,
	0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69,
	0x64, 0x67, 0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x2e, 0x4f, 0x6e, 0x43, 0x6c, 0x69,
	0x63, 0x6b, 0x52, 0x07, 0x6f, 0x6e, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42,
	0x07, 0x0a, 0x05, 0x69, 0x63, 0x6f, 0x6e, 0x73, 0x1a, 0x9a, 0x01, 0x0a, 0x07, 0x4f, 0x6e, 0x43,
	0x6c, 0x69, 0x63, 0x6b, 0x12, 0x41, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b,
	0x75, 0x70, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x6e, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67,
	0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x4c, 0x69, 0x6e,
	0x6b, 0x48, 0x00, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x6e, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x06, 0x0a,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x1c, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x6e, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x75, 0x72, 0x6c, 0x1a, 0xce, 0x01, 0x0a, 0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x57, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x61, 0x72, 0x6b,
	0x75, 0x70, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0a, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x39, 0x0a, 0x0f, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0xe0, 0x03, 0x0a, 0x04, 0x49, 0x63, 0x6f, 0x6e, 0x12, 0x14, 0x0a,
	0x10, 0x49, 0x43, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x49, 0x52, 0x50, 0x4c, 0x41, 0x4e, 0x45, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x42, 0x4f, 0x4f, 0x4b, 0x4d, 0x41, 0x52, 0x4b, 0x10, 0x1a, 0x12,
	0x07, 0x0a, 0x03, 0x42, 0x55, 0x53, 0x10, 0x19, 0x12, 0x07, 0x0a, 0x03, 0x43, 0x41, 0x52, 0x10,
	0x09, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x4c, 0x4f, 0x43, 0x4b, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x55, 0x4d,
	0x42, 0x45, 0x52, 0x5f, 0x49, 0x43, 0x4f, 0x4e, 0x10, 0x0c, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f,
	0x4c, 0x4c, 0x41, 0x52, 0x10, 0x0e, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x53, 0x43, 0x52, 0x49,
	0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x1b, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x4d, 0x41, 0x49, 0x4c,
	0x10, 0x0a, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x45, 0x52, 0x46,
	0x4f, 0x52, 0x4d, 0x45, 0x52, 0x10, 0x14, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x56, 0x45, 0x4e, 0x54,
	0x5f, 0x53, 0x45, 0x41, 0x54, 0x10, 0x15, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x4c, 0x49, 0x47, 0x48,
	0x54, 0x5f, 0x41, 0x52, 0x52, 0x49, 0x56, 0x41, 0x4c, 0x10, 0x10, 0x12, 0x14, 0x0a, 0x10, 0x46,
	0x4c, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x44, 0x45, 0x50, 0x41, 0x52, 0x54, 0x55, 0x52, 0x45, 0x10,
	0x0f, 0x12, 0x09, 0x0a, 0x05, 0x48, 0x4f, 0x54, 0x45, 0x4c, 0x10, 0x06, 0x12, 0x13, 0x0a, 0x0f,
	0x48, 0x4f, 0x54, 0x45, 0x4c, 0x5f, 0x52, 0x4f, 0x4f, 0x4d, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10,
	0x11, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x56, 0x49, 0x54, 0x45, 0x10, 0x13, 0x12, 0x0b, 0x0a,
	0x07, 0x4d, 0x41, 0x50, 0x5f, 0x50, 0x49, 0x4e, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x45,
	0x4d, 0x42, 0x45, 0x52, 0x53, 0x48, 0x49, 0x50, 0x10, 0x18, 0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x55,
	0x4c, 0x54, 0x49, 0x50, 0x4c, 0x45, 0x5f, 0x50, 0x45, 0x4f, 0x50, 0x4c, 0x45, 0x10, 0x12, 0x12,
	0x09, 0x0a, 0x05, 0x4f, 0x46, 0x46, 0x45, 0x52, 0x10, 0x1e, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x45,
	0x52, 0x53, 0x4f, 0x4e, 0x10, 0x0b, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x48, 0x4f, 0x4e, 0x45, 0x10,
	0x0d, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x53, 0x54, 0x41, 0x55, 0x52, 0x41, 0x4e, 0x54, 0x5f,
	0x49, 0x43, 0x4f, 0x4e, 0x10, 0x07, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x48, 0x4f, 0x50, 0x50, 0x49,
	0x4e, 0x47, 0x5f, 0x43, 0x41, 0x52, 0x54, 0x10, 0x08, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x54, 0x41,
	0x52, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10, 0x16, 0x12, 0x0a,
	0x0a, 0x06, 0x54, 0x49, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x52,
	0x41, 0x49, 0x4e, 0x10, 0x17, 0x12, 0x10, 0x0a, 0x0c, 0x56, 0x49, 0x44, 0x45, 0x4f, 0x5f, 0x43,
	0x41, 0x4d, 0x45, 0x52, 0x41, 0x10, 0x1c, 0x12, 0x0e, 0x0a, 0x0a, 0x56, 0x49, 0x44, 0x45, 0x4f,
	0x5f, 0x50, 0x4c, 0x41, 0x59, 0x10, 0x1d, 0x42, 0x06, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x42,
	0xa5, 0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x68, 0x61, 0x74,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0x3b, 0x63, 0x68,
	0x61, 0x74, 0x70, 0x62, 0xa2, 0x02, 0x0b, 0x44, 0x59, 0x4e, 0x41, 0x50, 0x49, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73,
	0x2e, 0x43, 0x68, 0x61, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02,
	0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x73, 0x3a, 0x3a, 0x43,
	0x68, 0x61, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_chat_v1_widgets_proto_rawDescOnce sync.Once
	file_google_chat_v1_widgets_proto_rawDescData = file_google_chat_v1_widgets_proto_rawDesc
)

func file_google_chat_v1_widgets_proto_rawDescGZIP() []byte {
	file_google_chat_v1_widgets_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_widgets_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_widgets_proto_rawDescData)
	})
	return file_google_chat_v1_widgets_proto_rawDescData
}

var file_google_chat_v1_widgets_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_chat_v1_widgets_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_chat_v1_widgets_proto_goTypes = []any{
	(WidgetMarkup_Icon)(0),                          // 0: google.chat.v1.WidgetMarkup.Icon
	(*WidgetMarkup)(nil),                            // 1: google.chat.v1.WidgetMarkup
	(*WidgetMarkup_TextParagraph)(nil),              // 2: google.chat.v1.WidgetMarkup.TextParagraph
	(*WidgetMarkup_Button)(nil),                     // 3: google.chat.v1.WidgetMarkup.Button
	(*WidgetMarkup_TextButton)(nil),                 // 4: google.chat.v1.WidgetMarkup.TextButton
	(*WidgetMarkup_KeyValue)(nil),                   // 5: google.chat.v1.WidgetMarkup.KeyValue
	(*WidgetMarkup_Image)(nil),                      // 6: google.chat.v1.WidgetMarkup.Image
	(*WidgetMarkup_ImageButton)(nil),                // 7: google.chat.v1.WidgetMarkup.ImageButton
	(*WidgetMarkup_OnClick)(nil),                    // 8: google.chat.v1.WidgetMarkup.OnClick
	(*WidgetMarkup_OpenLink)(nil),                   // 9: google.chat.v1.WidgetMarkup.OpenLink
	(*WidgetMarkup_FormAction)(nil),                 // 10: google.chat.v1.WidgetMarkup.FormAction
	(*WidgetMarkup_FormAction_ActionParameter)(nil), // 11: google.chat.v1.WidgetMarkup.FormAction.ActionParameter
}
var file_google_chat_v1_widgets_proto_depIdxs = []int32{
	2,  // 0: google.chat.v1.WidgetMarkup.text_paragraph:type_name -> google.chat.v1.WidgetMarkup.TextParagraph
	6,  // 1: google.chat.v1.WidgetMarkup.image:type_name -> google.chat.v1.WidgetMarkup.Image
	5,  // 2: google.chat.v1.WidgetMarkup.key_value:type_name -> google.chat.v1.WidgetMarkup.KeyValue
	3,  // 3: google.chat.v1.WidgetMarkup.buttons:type_name -> google.chat.v1.WidgetMarkup.Button
	4,  // 4: google.chat.v1.WidgetMarkup.Button.text_button:type_name -> google.chat.v1.WidgetMarkup.TextButton
	7,  // 5: google.chat.v1.WidgetMarkup.Button.image_button:type_name -> google.chat.v1.WidgetMarkup.ImageButton
	8,  // 6: google.chat.v1.WidgetMarkup.TextButton.on_click:type_name -> google.chat.v1.WidgetMarkup.OnClick
	0,  // 7: google.chat.v1.WidgetMarkup.KeyValue.icon:type_name -> google.chat.v1.WidgetMarkup.Icon
	8,  // 8: google.chat.v1.WidgetMarkup.KeyValue.on_click:type_name -> google.chat.v1.WidgetMarkup.OnClick
	3,  // 9: google.chat.v1.WidgetMarkup.KeyValue.button:type_name -> google.chat.v1.WidgetMarkup.Button
	8,  // 10: google.chat.v1.WidgetMarkup.Image.on_click:type_name -> google.chat.v1.WidgetMarkup.OnClick
	0,  // 11: google.chat.v1.WidgetMarkup.ImageButton.icon:type_name -> google.chat.v1.WidgetMarkup.Icon
	8,  // 12: google.chat.v1.WidgetMarkup.ImageButton.on_click:type_name -> google.chat.v1.WidgetMarkup.OnClick
	10, // 13: google.chat.v1.WidgetMarkup.OnClick.action:type_name -> google.chat.v1.WidgetMarkup.FormAction
	9,  // 14: google.chat.v1.WidgetMarkup.OnClick.open_link:type_name -> google.chat.v1.WidgetMarkup.OpenLink
	11, // 15: google.chat.v1.WidgetMarkup.FormAction.parameters:type_name -> google.chat.v1.WidgetMarkup.FormAction.ActionParameter
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_chat_v1_widgets_proto_init() }
func file_google_chat_v1_widgets_proto_init() {
	if File_google_chat_v1_widgets_proto != nil {
		return
	}
	file_google_chat_v1_widgets_proto_msgTypes[0].OneofWrappers = []any{
		(*WidgetMarkup_TextParagraph_)(nil),
		(*WidgetMarkup_Image_)(nil),
		(*WidgetMarkup_KeyValue_)(nil),
	}
	file_google_chat_v1_widgets_proto_msgTypes[2].OneofWrappers = []any{
		(*WidgetMarkup_Button_TextButton)(nil),
		(*WidgetMarkup_Button_ImageButton)(nil),
	}
	file_google_chat_v1_widgets_proto_msgTypes[4].OneofWrappers = []any{
		(*WidgetMarkup_KeyValue_Icon)(nil),
		(*WidgetMarkup_KeyValue_IconUrl)(nil),
		(*WidgetMarkup_KeyValue_Button)(nil),
	}
	file_google_chat_v1_widgets_proto_msgTypes[6].OneofWrappers = []any{
		(*WidgetMarkup_ImageButton_Icon)(nil),
		(*WidgetMarkup_ImageButton_IconUrl)(nil),
	}
	file_google_chat_v1_widgets_proto_msgTypes[7].OneofWrappers = []any{
		(*WidgetMarkup_OnClick_Action)(nil),
		(*WidgetMarkup_OnClick_OpenLink)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_widgets_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_widgets_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_widgets_proto_depIdxs,
		EnumInfos:         file_google_chat_v1_widgets_proto_enumTypes,
		MessageInfos:      file_google_chat_v1_widgets_proto_msgTypes,
	}.Build()
	File_google_chat_v1_widgets_proto = out.File
	file_google_chat_v1_widgets_proto_rawDesc = nil
	file_google_chat_v1_widgets_proto_goTypes = nil
	file_google_chat_v1_widgets_proto_depIdxs = nil
}
