// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package procurement

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"

	procurementpb "cloud.google.com/go/commerce/consumer/procurement/apiv1/procurementpb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newLicenseManagementClientHook clientHook

// LicenseManagementCallOptions contains the retry settings for each method of LicenseManagementClient.
type LicenseManagementCallOptions struct {
	GetLicensePool         []gax.CallOption
	UpdateLicensePool      []gax.CallOption
	Assign                 []gax.CallOption
	Unassign               []gax.CallOption
	EnumerateLicensedUsers []gax.CallOption
	GetOperation           []gax.CallOption
}

func defaultLicenseManagementGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("cloudcommerceconsumerprocurement.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("cloudcommerceconsumerprocurement.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("cloudcommerceconsumerprocurement.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://cloudcommerceconsumerprocurement.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultLicenseManagementCallOptions() *LicenseManagementCallOptions {
	return &LicenseManagementCallOptions{
		GetLicensePool:         []gax.CallOption{},
		UpdateLicensePool:      []gax.CallOption{},
		Assign:                 []gax.CallOption{},
		Unassign:               []gax.CallOption{},
		EnumerateLicensedUsers: []gax.CallOption{},
		GetOperation:           []gax.CallOption{},
	}
}

func defaultLicenseManagementRESTCallOptions() *LicenseManagementCallOptions {
	return &LicenseManagementCallOptions{
		GetLicensePool:         []gax.CallOption{},
		UpdateLicensePool:      []gax.CallOption{},
		Assign:                 []gax.CallOption{},
		Unassign:               []gax.CallOption{},
		EnumerateLicensedUsers: []gax.CallOption{},
		GetOperation:           []gax.CallOption{},
	}
}

// internalLicenseManagementClient is an interface that defines the methods available from Cloud Commerce Consumer Procurement API.
type internalLicenseManagementClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	GetLicensePool(context.Context, *procurementpb.GetLicensePoolRequest, ...gax.CallOption) (*procurementpb.LicensePool, error)
	UpdateLicensePool(context.Context, *procurementpb.UpdateLicensePoolRequest, ...gax.CallOption) (*procurementpb.LicensePool, error)
	Assign(context.Context, *procurementpb.AssignRequest, ...gax.CallOption) (*procurementpb.AssignResponse, error)
	Unassign(context.Context, *procurementpb.UnassignRequest, ...gax.CallOption) (*procurementpb.UnassignResponse, error)
	EnumerateLicensedUsers(context.Context, *procurementpb.EnumerateLicensedUsersRequest, ...gax.CallOption) *LicensedUserIterator
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
}

// LicenseManagementClient is a client for interacting with Cloud Commerce Consumer Procurement API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service for managing licenses.
type LicenseManagementClient struct {
	// The internal transport-dependent client.
	internalClient internalLicenseManagementClient

	// The call options for this service.
	CallOptions *LicenseManagementCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *LicenseManagementClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *LicenseManagementClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *LicenseManagementClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// GetLicensePool gets the license pool.
func (c *LicenseManagementClient) GetLicensePool(ctx context.Context, req *procurementpb.GetLicensePoolRequest, opts ...gax.CallOption) (*procurementpb.LicensePool, error) {
	return c.internalClient.GetLicensePool(ctx, req, opts...)
}

// UpdateLicensePool updates the license pool if one exists for this Order.
func (c *LicenseManagementClient) UpdateLicensePool(ctx context.Context, req *procurementpb.UpdateLicensePoolRequest, opts ...gax.CallOption) (*procurementpb.LicensePool, error) {
	return c.internalClient.UpdateLicensePool(ctx, req, opts...)
}

// Assign assigns a license to a user.
func (c *LicenseManagementClient) Assign(ctx context.Context, req *procurementpb.AssignRequest, opts ...gax.CallOption) (*procurementpb.AssignResponse, error) {
	return c.internalClient.Assign(ctx, req, opts...)
}

// Unassign unassigns a license from a user.
func (c *LicenseManagementClient) Unassign(ctx context.Context, req *procurementpb.UnassignRequest, opts ...gax.CallOption) (*procurementpb.UnassignResponse, error) {
	return c.internalClient.Unassign(ctx, req, opts...)
}

// EnumerateLicensedUsers enumerates all users assigned a license.
func (c *LicenseManagementClient) EnumerateLicensedUsers(ctx context.Context, req *procurementpb.EnumerateLicensedUsersRequest, opts ...gax.CallOption) *LicensedUserIterator {
	return c.internalClient.EnumerateLicensedUsers(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *LicenseManagementClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// licenseManagementGRPCClient is a client for interacting with Cloud Commerce Consumer Procurement API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type licenseManagementGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing LicenseManagementClient
	CallOptions **LicenseManagementCallOptions

	// The gRPC API client.
	licenseManagementClient procurementpb.LicenseManagementServiceClient

	operationsClient longrunningpb.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewLicenseManagementClient creates a new license management service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service for managing licenses.
func NewLicenseManagementClient(ctx context.Context, opts ...option.ClientOption) (*LicenseManagementClient, error) {
	clientOpts := defaultLicenseManagementGRPCClientOptions()
	if newLicenseManagementClientHook != nil {
		hookOpts, err := newLicenseManagementClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := LicenseManagementClient{CallOptions: defaultLicenseManagementCallOptions()}

	c := &licenseManagementGRPCClient{
		connPool:                connPool,
		licenseManagementClient: procurementpb.NewLicenseManagementServiceClient(connPool),
		CallOptions:             &client.CallOptions,
		logger:                  internaloption.GetLogger(opts),
		operationsClient:        longrunningpb.NewOperationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *licenseManagementGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *licenseManagementGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *licenseManagementGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type licenseManagementRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing LicenseManagementClient
	CallOptions **LicenseManagementCallOptions

	logger *slog.Logger
}

// NewLicenseManagementRESTClient creates a new license management service rest client.
//
// Service for managing licenses.
func NewLicenseManagementRESTClient(ctx context.Context, opts ...option.ClientOption) (*LicenseManagementClient, error) {
	clientOpts := append(defaultLicenseManagementRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultLicenseManagementRESTCallOptions()
	c := &licenseManagementRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	return &LicenseManagementClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultLicenseManagementRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://cloudcommerceconsumerprocurement.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://cloudcommerceconsumerprocurement.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://cloudcommerceconsumerprocurement.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://cloudcommerceconsumerprocurement.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *licenseManagementRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *licenseManagementRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *licenseManagementRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *licenseManagementGRPCClient) GetLicensePool(ctx context.Context, req *procurementpb.GetLicensePoolRequest, opts ...gax.CallOption) (*procurementpb.LicensePool, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLicensePool[0:len((*c.CallOptions).GetLicensePool):len((*c.CallOptions).GetLicensePool)], opts...)
	var resp *procurementpb.LicensePool
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.licenseManagementClient.GetLicensePool, req, settings.GRPC, c.logger, "GetLicensePool")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *licenseManagementGRPCClient) UpdateLicensePool(ctx context.Context, req *procurementpb.UpdateLicensePoolRequest, opts ...gax.CallOption) (*procurementpb.LicensePool, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "license_pool.name", url.QueryEscape(req.GetLicensePool().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateLicensePool[0:len((*c.CallOptions).UpdateLicensePool):len((*c.CallOptions).UpdateLicensePool)], opts...)
	var resp *procurementpb.LicensePool
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.licenseManagementClient.UpdateLicensePool, req, settings.GRPC, c.logger, "UpdateLicensePool")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *licenseManagementGRPCClient) Assign(ctx context.Context, req *procurementpb.AssignRequest, opts ...gax.CallOption) (*procurementpb.AssignResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).Assign[0:len((*c.CallOptions).Assign):len((*c.CallOptions).Assign)], opts...)
	var resp *procurementpb.AssignResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.licenseManagementClient.Assign, req, settings.GRPC, c.logger, "Assign")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *licenseManagementGRPCClient) Unassign(ctx context.Context, req *procurementpb.UnassignRequest, opts ...gax.CallOption) (*procurementpb.UnassignResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).Unassign[0:len((*c.CallOptions).Unassign):len((*c.CallOptions).Unassign)], opts...)
	var resp *procurementpb.UnassignResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.licenseManagementClient.Unassign, req, settings.GRPC, c.logger, "Unassign")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *licenseManagementGRPCClient) EnumerateLicensedUsers(ctx context.Context, req *procurementpb.EnumerateLicensedUsersRequest, opts ...gax.CallOption) *LicensedUserIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).EnumerateLicensedUsers[0:len((*c.CallOptions).EnumerateLicensedUsers):len((*c.CallOptions).EnumerateLicensedUsers)], opts...)
	it := &LicensedUserIterator{}
	req = proto.Clone(req).(*procurementpb.EnumerateLicensedUsersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*procurementpb.LicensedUser, string, error) {
		resp := &procurementpb.EnumerateLicensedUsersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.licenseManagementClient.EnumerateLicensedUsers, req, settings.GRPC, c.logger, "EnumerateLicensedUsers")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLicensedUsers(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *licenseManagementGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// GetLicensePool gets the license pool.
func (c *licenseManagementRESTClient) GetLicensePool(ctx context.Context, req *procurementpb.GetLicensePoolRequest, opts ...gax.CallOption) (*procurementpb.LicensePool, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLicensePool[0:len((*c.CallOptions).GetLicensePool):len((*c.CallOptions).GetLicensePool)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &procurementpb.LicensePool{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetLicensePool")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateLicensePool updates the license pool if one exists for this Order.
func (c *licenseManagementRESTClient) UpdateLicensePool(ctx context.Context, req *procurementpb.UpdateLicensePoolRequest, opts ...gax.CallOption) (*procurementpb.LicensePool, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetLicensePool()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetLicensePool().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "license_pool.name", url.QueryEscape(req.GetLicensePool().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateLicensePool[0:len((*c.CallOptions).UpdateLicensePool):len((*c.CallOptions).UpdateLicensePool)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &procurementpb.LicensePool{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateLicensePool")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// Assign assigns a license to a user.
func (c *licenseManagementRESTClient) Assign(ctx context.Context, req *procurementpb.AssignRequest, opts ...gax.CallOption) (*procurementpb.AssignResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:assign", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).Assign[0:len((*c.CallOptions).Assign):len((*c.CallOptions).Assign)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &procurementpb.AssignResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "Assign")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// Unassign unassigns a license from a user.
func (c *licenseManagementRESTClient) Unassign(ctx context.Context, req *procurementpb.UnassignRequest, opts ...gax.CallOption) (*procurementpb.UnassignResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:unassign", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).Unassign[0:len((*c.CallOptions).Unassign):len((*c.CallOptions).Unassign)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &procurementpb.UnassignResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "Unassign")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// EnumerateLicensedUsers enumerates all users assigned a license.
func (c *licenseManagementRESTClient) EnumerateLicensedUsers(ctx context.Context, req *procurementpb.EnumerateLicensedUsersRequest, opts ...gax.CallOption) *LicensedUserIterator {
	it := &LicensedUserIterator{}
	req = proto.Clone(req).(*procurementpb.EnumerateLicensedUsersRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*procurementpb.LicensedUser, string, error) {
		resp := &procurementpb.EnumerateLicensedUsersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v:enumerateLicensedUsers", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "EnumerateLicensedUsers")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLicensedUsers(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *licenseManagementRESTClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
