// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/documentai/v1/evaluation.proto

package documentaipb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A type that determines how metrics should be interpreted.
type Evaluation_MultiConfidenceMetrics_MetricsType int32

const (
	// The metrics type is unspecified. By default, metrics without a
	// particular specification are for leaf entity types (i.e., top-level
	// entity types without child types, or child types which are not
	// parent types themselves).
	Evaluation_MultiConfidenceMetrics_METRICS_TYPE_UNSPECIFIED Evaluation_MultiConfidenceMetrics_MetricsType = 0
	// Indicates whether metrics for this particular label type represent an
	// aggregate of metrics for other types instead of being based on actual
	// TP/FP/FN values for the label type. Metrics for parent (i.e., non-leaf)
	// entity types are an aggregate of metrics for their children.
	Evaluation_MultiConfidenceMetrics_AGGREGATE Evaluation_MultiConfidenceMetrics_MetricsType = 1
)

// Enum value maps for Evaluation_MultiConfidenceMetrics_MetricsType.
var (
	Evaluation_MultiConfidenceMetrics_MetricsType_name = map[int32]string{
		0: "METRICS_TYPE_UNSPECIFIED",
		1: "AGGREGATE",
	}
	Evaluation_MultiConfidenceMetrics_MetricsType_value = map[string]int32{
		"METRICS_TYPE_UNSPECIFIED": 0,
		"AGGREGATE":                1,
	}
)

func (x Evaluation_MultiConfidenceMetrics_MetricsType) Enum() *Evaluation_MultiConfidenceMetrics_MetricsType {
	p := new(Evaluation_MultiConfidenceMetrics_MetricsType)
	*p = x
	return p
}

func (x Evaluation_MultiConfidenceMetrics_MetricsType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Evaluation_MultiConfidenceMetrics_MetricsType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_evaluation_proto_enumTypes[0].Descriptor()
}

func (Evaluation_MultiConfidenceMetrics_MetricsType) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_evaluation_proto_enumTypes[0]
}

func (x Evaluation_MultiConfidenceMetrics_MetricsType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Evaluation_MultiConfidenceMetrics_MetricsType.Descriptor instead.
func (Evaluation_MultiConfidenceMetrics_MetricsType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_evaluation_proto_rawDescGZIP(), []int{1, 3, 0}
}

// Gives a short summary of an evaluation, and links to the evaluation itself.
type EvaluationReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Long Running Operation for the evaluation.
	Operation string `protobuf:"bytes,1,opt,name=operation,proto3" json:"operation,omitempty"`
	// The resource name of the evaluation.
	Evaluation string `protobuf:"bytes,2,opt,name=evaluation,proto3" json:"evaluation,omitempty"`
	// An aggregate of the statistics for the evaluation with fuzzy matching on.
	AggregateMetrics *Evaluation_Metrics `protobuf:"bytes,4,opt,name=aggregate_metrics,json=aggregateMetrics,proto3" json:"aggregate_metrics,omitempty"`
	// An aggregate of the statistics for the evaluation with fuzzy matching off.
	AggregateMetricsExact *Evaluation_Metrics `protobuf:"bytes,5,opt,name=aggregate_metrics_exact,json=aggregateMetricsExact,proto3" json:"aggregate_metrics_exact,omitempty"`
}

func (x *EvaluationReference) Reset() {
	*x = EvaluationReference{}
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EvaluationReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluationReference) ProtoMessage() {}

func (x *EvaluationReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluationReference.ProtoReflect.Descriptor instead.
func (*EvaluationReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_evaluation_proto_rawDescGZIP(), []int{0}
}

func (x *EvaluationReference) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *EvaluationReference) GetEvaluation() string {
	if x != nil {
		return x.Evaluation
	}
	return ""
}

func (x *EvaluationReference) GetAggregateMetrics() *Evaluation_Metrics {
	if x != nil {
		return x.AggregateMetrics
	}
	return nil
}

func (x *EvaluationReference) GetAggregateMetricsExact() *Evaluation_Metrics {
	if x != nil {
		return x.AggregateMetricsExact
	}
	return nil
}

// An evaluation of a ProcessorVersion's performance.
type Evaluation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the evaluation.
	// Format:
	// `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}/evaluations/{evaluation}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The time that the evaluation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Counters for the documents used in the evaluation.
	DocumentCounters *Evaluation_Counters `protobuf:"bytes,5,opt,name=document_counters,json=documentCounters,proto3" json:"document_counters,omitempty"`
	// Metrics for all the entities in aggregate.
	AllEntitiesMetrics *Evaluation_MultiConfidenceMetrics `protobuf:"bytes,3,opt,name=all_entities_metrics,json=allEntitiesMetrics,proto3" json:"all_entities_metrics,omitempty"`
	// Metrics across confidence levels, for different entities.
	EntityMetrics map[string]*Evaluation_MultiConfidenceMetrics `protobuf:"bytes,4,rep,name=entity_metrics,json=entityMetrics,proto3" json:"entity_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The KMS key name used for encryption.
	KmsKeyName string `protobuf:"bytes,6,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// The KMS key version with which data is encrypted.
	KmsKeyVersionName string `protobuf:"bytes,7,opt,name=kms_key_version_name,json=kmsKeyVersionName,proto3" json:"kms_key_version_name,omitempty"`
}

func (x *Evaluation) Reset() {
	*x = Evaluation{}
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Evaluation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Evaluation) ProtoMessage() {}

func (x *Evaluation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Evaluation.ProtoReflect.Descriptor instead.
func (*Evaluation) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_evaluation_proto_rawDescGZIP(), []int{1}
}

func (x *Evaluation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Evaluation) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Evaluation) GetDocumentCounters() *Evaluation_Counters {
	if x != nil {
		return x.DocumentCounters
	}
	return nil
}

func (x *Evaluation) GetAllEntitiesMetrics() *Evaluation_MultiConfidenceMetrics {
	if x != nil {
		return x.AllEntitiesMetrics
	}
	return nil
}

func (x *Evaluation) GetEntityMetrics() map[string]*Evaluation_MultiConfidenceMetrics {
	if x != nil {
		return x.EntityMetrics
	}
	return nil
}

func (x *Evaluation) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *Evaluation) GetKmsKeyVersionName() string {
	if x != nil {
		return x.KmsKeyVersionName
	}
	return ""
}

// Evaluation counters for the documents that were used.
type Evaluation_Counters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How many documents were sent for evaluation.
	InputDocumentsCount int32 `protobuf:"varint,1,opt,name=input_documents_count,json=inputDocumentsCount,proto3" json:"input_documents_count,omitempty"`
	// How many documents were not included in the evaluation as they didn't
	// pass validation.
	InvalidDocumentsCount int32 `protobuf:"varint,2,opt,name=invalid_documents_count,json=invalidDocumentsCount,proto3" json:"invalid_documents_count,omitempty"`
	// How many documents were not included in the evaluation as Document AI
	// failed to process them.
	FailedDocumentsCount int32 `protobuf:"varint,3,opt,name=failed_documents_count,json=failedDocumentsCount,proto3" json:"failed_documents_count,omitempty"`
	// How many documents were used in the evaluation.
	EvaluatedDocumentsCount int32 `protobuf:"varint,4,opt,name=evaluated_documents_count,json=evaluatedDocumentsCount,proto3" json:"evaluated_documents_count,omitempty"`
}

func (x *Evaluation_Counters) Reset() {
	*x = Evaluation_Counters{}
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Evaluation_Counters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Evaluation_Counters) ProtoMessage() {}

func (x *Evaluation_Counters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Evaluation_Counters.ProtoReflect.Descriptor instead.
func (*Evaluation_Counters) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_evaluation_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Evaluation_Counters) GetInputDocumentsCount() int32 {
	if x != nil {
		return x.InputDocumentsCount
	}
	return 0
}

func (x *Evaluation_Counters) GetInvalidDocumentsCount() int32 {
	if x != nil {
		return x.InvalidDocumentsCount
	}
	return 0
}

func (x *Evaluation_Counters) GetFailedDocumentsCount() int32 {
	if x != nil {
		return x.FailedDocumentsCount
	}
	return 0
}

func (x *Evaluation_Counters) GetEvaluatedDocumentsCount() int32 {
	if x != nil {
		return x.EvaluatedDocumentsCount
	}
	return 0
}

// Evaluation metrics, either in aggregate or about a specific entity.
type Evaluation_Metrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The calculated precision.
	Precision float32 `protobuf:"fixed32,1,opt,name=precision,proto3" json:"precision,omitempty"`
	// The calculated recall.
	Recall float32 `protobuf:"fixed32,2,opt,name=recall,proto3" json:"recall,omitempty"`
	// The calculated f1 score.
	F1Score float32 `protobuf:"fixed32,3,opt,name=f1_score,json=f1Score,proto3" json:"f1_score,omitempty"`
	// The amount of occurrences in predicted documents.
	PredictedOccurrencesCount int32 `protobuf:"varint,4,opt,name=predicted_occurrences_count,json=predictedOccurrencesCount,proto3" json:"predicted_occurrences_count,omitempty"`
	// The amount of occurrences in ground truth documents.
	GroundTruthOccurrencesCount int32 `protobuf:"varint,5,opt,name=ground_truth_occurrences_count,json=groundTruthOccurrencesCount,proto3" json:"ground_truth_occurrences_count,omitempty"`
	// The amount of documents with a predicted occurrence.
	PredictedDocumentCount int32 `protobuf:"varint,10,opt,name=predicted_document_count,json=predictedDocumentCount,proto3" json:"predicted_document_count,omitempty"`
	// The amount of documents with a ground truth occurrence.
	GroundTruthDocumentCount int32 `protobuf:"varint,11,opt,name=ground_truth_document_count,json=groundTruthDocumentCount,proto3" json:"ground_truth_document_count,omitempty"`
	// The amount of true positives.
	TruePositivesCount int32 `protobuf:"varint,6,opt,name=true_positives_count,json=truePositivesCount,proto3" json:"true_positives_count,omitempty"`
	// The amount of false positives.
	FalsePositivesCount int32 `protobuf:"varint,7,opt,name=false_positives_count,json=falsePositivesCount,proto3" json:"false_positives_count,omitempty"`
	// The amount of false negatives.
	FalseNegativesCount int32 `protobuf:"varint,8,opt,name=false_negatives_count,json=falseNegativesCount,proto3" json:"false_negatives_count,omitempty"`
	// The amount of documents that had an occurrence of this label.
	TotalDocumentsCount int32 `protobuf:"varint,9,opt,name=total_documents_count,json=totalDocumentsCount,proto3" json:"total_documents_count,omitempty"`
}

func (x *Evaluation_Metrics) Reset() {
	*x = Evaluation_Metrics{}
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Evaluation_Metrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Evaluation_Metrics) ProtoMessage() {}

func (x *Evaluation_Metrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Evaluation_Metrics.ProtoReflect.Descriptor instead.
func (*Evaluation_Metrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_evaluation_proto_rawDescGZIP(), []int{1, 1}
}

func (x *Evaluation_Metrics) GetPrecision() float32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

func (x *Evaluation_Metrics) GetRecall() float32 {
	if x != nil {
		return x.Recall
	}
	return 0
}

func (x *Evaluation_Metrics) GetF1Score() float32 {
	if x != nil {
		return x.F1Score
	}
	return 0
}

func (x *Evaluation_Metrics) GetPredictedOccurrencesCount() int32 {
	if x != nil {
		return x.PredictedOccurrencesCount
	}
	return 0
}

func (x *Evaluation_Metrics) GetGroundTruthOccurrencesCount() int32 {
	if x != nil {
		return x.GroundTruthOccurrencesCount
	}
	return 0
}

func (x *Evaluation_Metrics) GetPredictedDocumentCount() int32 {
	if x != nil {
		return x.PredictedDocumentCount
	}
	return 0
}

func (x *Evaluation_Metrics) GetGroundTruthDocumentCount() int32 {
	if x != nil {
		return x.GroundTruthDocumentCount
	}
	return 0
}

func (x *Evaluation_Metrics) GetTruePositivesCount() int32 {
	if x != nil {
		return x.TruePositivesCount
	}
	return 0
}

func (x *Evaluation_Metrics) GetFalsePositivesCount() int32 {
	if x != nil {
		return x.FalsePositivesCount
	}
	return 0
}

func (x *Evaluation_Metrics) GetFalseNegativesCount() int32 {
	if x != nil {
		return x.FalseNegativesCount
	}
	return 0
}

func (x *Evaluation_Metrics) GetTotalDocumentsCount() int32 {
	if x != nil {
		return x.TotalDocumentsCount
	}
	return 0
}

// Evaluations metrics, at a specific confidence level.
type Evaluation_ConfidenceLevelMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The confidence level.
	ConfidenceLevel float32 `protobuf:"fixed32,1,opt,name=confidence_level,json=confidenceLevel,proto3" json:"confidence_level,omitempty"`
	// The metrics at the specific confidence level.
	Metrics *Evaluation_Metrics `protobuf:"bytes,2,opt,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *Evaluation_ConfidenceLevelMetrics) Reset() {
	*x = Evaluation_ConfidenceLevelMetrics{}
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Evaluation_ConfidenceLevelMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Evaluation_ConfidenceLevelMetrics) ProtoMessage() {}

func (x *Evaluation_ConfidenceLevelMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Evaluation_ConfidenceLevelMetrics.ProtoReflect.Descriptor instead.
func (*Evaluation_ConfidenceLevelMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_evaluation_proto_rawDescGZIP(), []int{1, 2}
}

func (x *Evaluation_ConfidenceLevelMetrics) GetConfidenceLevel() float32 {
	if x != nil {
		return x.ConfidenceLevel
	}
	return 0
}

func (x *Evaluation_ConfidenceLevelMetrics) GetMetrics() *Evaluation_Metrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Metrics across multiple confidence levels.
type Evaluation_MultiConfidenceMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metrics across confidence levels with fuzzy matching enabled.
	ConfidenceLevelMetrics []*Evaluation_ConfidenceLevelMetrics `protobuf:"bytes,1,rep,name=confidence_level_metrics,json=confidenceLevelMetrics,proto3" json:"confidence_level_metrics,omitempty"`
	// Metrics across confidence levels with only exact matching.
	ConfidenceLevelMetricsExact []*Evaluation_ConfidenceLevelMetrics `protobuf:"bytes,4,rep,name=confidence_level_metrics_exact,json=confidenceLevelMetricsExact,proto3" json:"confidence_level_metrics_exact,omitempty"`
	// The calculated area under the precision recall curve (AUPRC), computed by
	// integrating over all confidence thresholds.
	Auprc float32 `protobuf:"fixed32,2,opt,name=auprc,proto3" json:"auprc,omitempty"`
	// The Estimated Calibration Error (ECE) of the confidence of the predicted
	// entities.
	EstimatedCalibrationError float32 `protobuf:"fixed32,3,opt,name=estimated_calibration_error,json=estimatedCalibrationError,proto3" json:"estimated_calibration_error,omitempty"`
	// The AUPRC for metrics with fuzzy matching disabled, i.e., exact matching
	// only.
	AuprcExact float32 `protobuf:"fixed32,5,opt,name=auprc_exact,json=auprcExact,proto3" json:"auprc_exact,omitempty"`
	// The ECE for the predicted entities with fuzzy matching disabled, i.e.,
	// exact matching only.
	EstimatedCalibrationErrorExact float32 `protobuf:"fixed32,6,opt,name=estimated_calibration_error_exact,json=estimatedCalibrationErrorExact,proto3" json:"estimated_calibration_error_exact,omitempty"`
	// The metrics type for the label.
	MetricsType Evaluation_MultiConfidenceMetrics_MetricsType `protobuf:"varint,7,opt,name=metrics_type,json=metricsType,proto3,enum=google.cloud.documentai.v1.Evaluation_MultiConfidenceMetrics_MetricsType" json:"metrics_type,omitempty"`
}

func (x *Evaluation_MultiConfidenceMetrics) Reset() {
	*x = Evaluation_MultiConfidenceMetrics{}
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Evaluation_MultiConfidenceMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Evaluation_MultiConfidenceMetrics) ProtoMessage() {}

func (x *Evaluation_MultiConfidenceMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_evaluation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Evaluation_MultiConfidenceMetrics.ProtoReflect.Descriptor instead.
func (*Evaluation_MultiConfidenceMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_evaluation_proto_rawDescGZIP(), []int{1, 3}
}

func (x *Evaluation_MultiConfidenceMetrics) GetConfidenceLevelMetrics() []*Evaluation_ConfidenceLevelMetrics {
	if x != nil {
		return x.ConfidenceLevelMetrics
	}
	return nil
}

func (x *Evaluation_MultiConfidenceMetrics) GetConfidenceLevelMetricsExact() []*Evaluation_ConfidenceLevelMetrics {
	if x != nil {
		return x.ConfidenceLevelMetricsExact
	}
	return nil
}

func (x *Evaluation_MultiConfidenceMetrics) GetAuprc() float32 {
	if x != nil {
		return x.Auprc
	}
	return 0
}

func (x *Evaluation_MultiConfidenceMetrics) GetEstimatedCalibrationError() float32 {
	if x != nil {
		return x.EstimatedCalibrationError
	}
	return 0
}

func (x *Evaluation_MultiConfidenceMetrics) GetAuprcExact() float32 {
	if x != nil {
		return x.AuprcExact
	}
	return 0
}

func (x *Evaluation_MultiConfidenceMetrics) GetEstimatedCalibrationErrorExact() float32 {
	if x != nil {
		return x.EstimatedCalibrationErrorExact
	}
	return 0
}

func (x *Evaluation_MultiConfidenceMetrics) GetMetricsType() Evaluation_MultiConfidenceMetrics_MetricsType {
	if x != nil {
		return x.MetricsType
	}
	return Evaluation_MultiConfidenceMetrics_METRICS_TYPE_UNSPECIFIED
}

var File_google_cloud_documentai_v1_evaluation_proto protoreflect.FileDescriptor

var file_google_cloud_documentai_v1_evaluation_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc3, 0x02, 0x0a, 0x13, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0a, 0x65,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x11, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x52, 0x10, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x66, 0x0a, 0x17, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f, 0x65, 0x78, 0x61, 0x63, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x52, 0x15, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x78, 0x61, 0x63, 0x74, 0x22, 0xb7, 0x12, 0x0a, 0x0a,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3b,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x11, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x52, 0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x6f, 0x0a, 0x14, 0x61, 0x6c, 0x6c,
	0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x12, 0x61, 0x6c, 0x6c, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x60, 0x0a, 0x0e, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x20, 0x0a, 0x0c,
	0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f,
	0x0a, 0x14, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6b, 0x6d,
	0x73, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a,
	0xe8, 0x01, 0x0a, 0x08, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x32, 0x0a, 0x15,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x36, 0x0a, 0x17, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x15, 0x69, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x66, 0x61, 0x69, 0x6c,
	0x65, 0x64, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3a,
	0x0a, 0x19, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x17, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xa6, 0x04, 0x0a, 0x07, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x06, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x12, 0x19, 0x0a, 0x08,
	0x66, 0x31, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x07,
	0x66, 0x31, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x3e, 0x0a, 0x1b, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x65, 0x64, 0x5f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x19, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x43, 0x0a, 0x1e, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x5f, 0x74, 0x72, 0x75, 0x74, 0x68, 0x5f, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x1b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x54, 0x72, 0x75, 0x74, 0x68, 0x4f, 0x63, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x18,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x16,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x1b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x5f, 0x74, 0x72, 0x75, 0x74, 0x68, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x18, 0x67, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x54, 0x72, 0x75, 0x74, 0x68, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x72, 0x75, 0x65, 0x5f, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x12, 0x74, 0x72, 0x75, 0x65, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x66, 0x61, 0x6c, 0x73, 0x65,
	0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x50, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x66,
	0x61, 0x6c, 0x73, 0x65, 0x5f, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x66, 0x61, 0x6c, 0x73,
	0x65, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x32, 0x0a, 0x15, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x1a, 0x8d, 0x01, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e,
	0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x29,
	0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x48, 0x0a, 0x07, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x1a, 0x82, 0x05, 0x0a, 0x16, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x77,
	0x0a, 0x18, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x16, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x82, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x5f, 0x65, 0x78, 0x61, 0x63, 0x74, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76,
	0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x1b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x78, 0x61, 0x63, 0x74, 0x12, 0x14, 0x0a, 0x05,
	0x61, 0x75, 0x70, 0x72, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x61, 0x75, 0x70,
	0x72, 0x63, 0x12, 0x3e, 0x0a, 0x1b, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x63, 0x61, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x19, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74,
	0x65, 0x64, 0x43, 0x61, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x70, 0x72, 0x63, 0x5f, 0x65, 0x78, 0x61, 0x63,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x61, 0x75, 0x70, 0x72, 0x63, 0x45, 0x78,
	0x61, 0x63, 0x74, 0x12, 0x49, 0x0a, 0x21, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x63, 0x61, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x5f, 0x65, 0x78, 0x61, 0x63, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x52, 0x1e,
	0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6c, 0x69, 0x62, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x45, 0x78, 0x61, 0x63, 0x74, 0x12, 0x6c,
	0x0a, 0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x75, 0x6c,
	0x74, 0x69, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x54, 0x79, 0x70, 0x65, 0x22, 0x3a, 0x0a, 0x0b,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4d,
	0x45, 0x54, 0x52, 0x49, 0x43, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x47, 0x47,
	0x52, 0x45, 0x47, 0x41, 0x54, 0x45, 0x10, 0x01, 0x1a, 0x7f, 0x0a, 0x12, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x53, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xa9, 0x01, 0xea, 0x41, 0xa5, 0x01,
	0x0a, 0x24, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x61, 0x6c,
	0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0xd2, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x42, 0x14, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x41, 0x69, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x01,
	0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x70, 0x62, 0x3b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x70, 0x62,
	0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_documentai_v1_evaluation_proto_rawDescOnce sync.Once
	file_google_cloud_documentai_v1_evaluation_proto_rawDescData = file_google_cloud_documentai_v1_evaluation_proto_rawDesc
)

func file_google_cloud_documentai_v1_evaluation_proto_rawDescGZIP() []byte {
	file_google_cloud_documentai_v1_evaluation_proto_rawDescOnce.Do(func() {
		file_google_cloud_documentai_v1_evaluation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_documentai_v1_evaluation_proto_rawDescData)
	})
	return file_google_cloud_documentai_v1_evaluation_proto_rawDescData
}

var file_google_cloud_documentai_v1_evaluation_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_documentai_v1_evaluation_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_documentai_v1_evaluation_proto_goTypes = []any{
	(Evaluation_MultiConfidenceMetrics_MetricsType)(0), // 0: google.cloud.documentai.v1.Evaluation.MultiConfidenceMetrics.MetricsType
	(*EvaluationReference)(nil),                        // 1: google.cloud.documentai.v1.EvaluationReference
	(*Evaluation)(nil),                                 // 2: google.cloud.documentai.v1.Evaluation
	(*Evaluation_Counters)(nil),                        // 3: google.cloud.documentai.v1.Evaluation.Counters
	(*Evaluation_Metrics)(nil),                         // 4: google.cloud.documentai.v1.Evaluation.Metrics
	(*Evaluation_ConfidenceLevelMetrics)(nil),          // 5: google.cloud.documentai.v1.Evaluation.ConfidenceLevelMetrics
	(*Evaluation_MultiConfidenceMetrics)(nil),          // 6: google.cloud.documentai.v1.Evaluation.MultiConfidenceMetrics
	nil,                           // 7: google.cloud.documentai.v1.Evaluation.EntityMetricsEntry
	(*timestamppb.Timestamp)(nil), // 8: google.protobuf.Timestamp
}
var file_google_cloud_documentai_v1_evaluation_proto_depIdxs = []int32{
	4,  // 0: google.cloud.documentai.v1.EvaluationReference.aggregate_metrics:type_name -> google.cloud.documentai.v1.Evaluation.Metrics
	4,  // 1: google.cloud.documentai.v1.EvaluationReference.aggregate_metrics_exact:type_name -> google.cloud.documentai.v1.Evaluation.Metrics
	8,  // 2: google.cloud.documentai.v1.Evaluation.create_time:type_name -> google.protobuf.Timestamp
	3,  // 3: google.cloud.documentai.v1.Evaluation.document_counters:type_name -> google.cloud.documentai.v1.Evaluation.Counters
	6,  // 4: google.cloud.documentai.v1.Evaluation.all_entities_metrics:type_name -> google.cloud.documentai.v1.Evaluation.MultiConfidenceMetrics
	7,  // 5: google.cloud.documentai.v1.Evaluation.entity_metrics:type_name -> google.cloud.documentai.v1.Evaluation.EntityMetricsEntry
	4,  // 6: google.cloud.documentai.v1.Evaluation.ConfidenceLevelMetrics.metrics:type_name -> google.cloud.documentai.v1.Evaluation.Metrics
	5,  // 7: google.cloud.documentai.v1.Evaluation.MultiConfidenceMetrics.confidence_level_metrics:type_name -> google.cloud.documentai.v1.Evaluation.ConfidenceLevelMetrics
	5,  // 8: google.cloud.documentai.v1.Evaluation.MultiConfidenceMetrics.confidence_level_metrics_exact:type_name -> google.cloud.documentai.v1.Evaluation.ConfidenceLevelMetrics
	0,  // 9: google.cloud.documentai.v1.Evaluation.MultiConfidenceMetrics.metrics_type:type_name -> google.cloud.documentai.v1.Evaluation.MultiConfidenceMetrics.MetricsType
	6,  // 10: google.cloud.documentai.v1.Evaluation.EntityMetricsEntry.value:type_name -> google.cloud.documentai.v1.Evaluation.MultiConfidenceMetrics
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_documentai_v1_evaluation_proto_init() }
func file_google_cloud_documentai_v1_evaluation_proto_init() {
	if File_google_cloud_documentai_v1_evaluation_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_documentai_v1_evaluation_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_documentai_v1_evaluation_proto_goTypes,
		DependencyIndexes: file_google_cloud_documentai_v1_evaluation_proto_depIdxs,
		EnumInfos:         file_google_cloud_documentai_v1_evaluation_proto_enumTypes,
		MessageInfos:      file_google_cloud_documentai_v1_evaluation_proto_msgTypes,
	}.Build()
	File_google_cloud_documentai_v1_evaluation_proto = out.File
	file_google_cloud_documentai_v1_evaluation_proto_rawDesc = nil
	file_google_cloud_documentai_v1_evaluation_proto_goTypes = nil
	file_google_cloud_documentai_v1_evaluation_proto_depIdxs = nil
}
