// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/oracledatabase/v1/autonomous_database.proto

package oracledatabasepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	dayofweek "google.golang.org/genproto/googleapis/type/dayofweek"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of wallet generation.
type GenerateType int32

const (
	// Default unspecified value.
	GenerateType_GENERATE_TYPE_UNSPECIFIED GenerateType = 0
	// Used to generate wallet for all databases in the region.
	GenerateType_ALL GenerateType = 1
	// Used to generate wallet for a single database.
	GenerateType_SINGLE GenerateType = 2
)

// Enum value maps for GenerateType.
var (
	GenerateType_name = map[int32]string{
		0: "GENERATE_TYPE_UNSPECIFIED",
		1: "ALL",
		2: "SINGLE",
	}
	GenerateType_value = map[string]int32{
		"GENERATE_TYPE_UNSPECIFIED": 0,
		"ALL":                       1,
		"SINGLE":                    2,
	}
)

func (x GenerateType) Enum() *GenerateType {
	p := new(GenerateType)
	*p = x
	return p
}

func (x GenerateType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[0].Descriptor()
}

func (GenerateType) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[0]
}

func (x GenerateType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateType.Descriptor instead.
func (GenerateType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{0}
}

// The various lifecycle states of the Autonomous Database.
type State int32

const (
	// Default unspecified value.
	State_STATE_UNSPECIFIED State = 0
	// Indicates that the Autonomous Database is in provisioning state.
	State_PROVISIONING State = 1
	// Indicates that the Autonomous Database is in available state.
	State_AVAILABLE State = 2
	// Indicates that the Autonomous Database is in stopping state.
	State_STOPPING State = 3
	// Indicates that the Autonomous Database is in stopped state.
	State_STOPPED State = 4
	// Indicates that the Autonomous Database is in starting state.
	State_STARTING State = 5
	// Indicates that the Autonomous Database is in terminating state.
	State_TERMINATING State = 6
	// Indicates that the Autonomous Database is in terminated state.
	State_TERMINATED State = 7
	// Indicates that the Autonomous Database is in unavailable state.
	State_UNAVAILABLE State = 8
	// Indicates that the Autonomous Database restore is in progress.
	State_RESTORE_IN_PROGRESS State = 9
	// Indicates that the Autonomous Database failed to restore.
	State_RESTORE_FAILED State = 10
	// Indicates that the Autonomous Database backup is in progress.
	State_BACKUP_IN_PROGRESS State = 11
	// Indicates that the Autonomous Database scale is in progress.
	State_SCALE_IN_PROGRESS State = 12
	// Indicates that the Autonomous Database is available but needs attention
	// state.
	State_AVAILABLE_NEEDS_ATTENTION State = 13
	// Indicates that the Autonomous Database is in updating state.
	State_UPDATING State = 14
	// Indicates that the Autonomous Database's maintenance is in progress state.
	State_MAINTENANCE_IN_PROGRESS State = 15
	// Indicates that the Autonomous Database is in restarting state.
	State_RESTARTING State = 16
	// Indicates that the Autonomous Database is in recreating state.
	State_RECREATING State = 17
	// Indicates that the Autonomous Database's role change is in progress state.
	State_ROLE_CHANGE_IN_PROGRESS State = 18
	// Indicates that the Autonomous Database is in upgrading state.
	State_UPGRADING State = 19
	// Indicates that the Autonomous Database is in inaccessible state.
	State_INACCESSIBLE State = 20
	// Indicates that the Autonomous Database is in standby state.
	State_STANDBY State = 21
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "PROVISIONING",
		2:  "AVAILABLE",
		3:  "STOPPING",
		4:  "STOPPED",
		5:  "STARTING",
		6:  "TERMINATING",
		7:  "TERMINATED",
		8:  "UNAVAILABLE",
		9:  "RESTORE_IN_PROGRESS",
		10: "RESTORE_FAILED",
		11: "BACKUP_IN_PROGRESS",
		12: "SCALE_IN_PROGRESS",
		13: "AVAILABLE_NEEDS_ATTENTION",
		14: "UPDATING",
		15: "MAINTENANCE_IN_PROGRESS",
		16: "RESTARTING",
		17: "RECREATING",
		18: "ROLE_CHANGE_IN_PROGRESS",
		19: "UPGRADING",
		20: "INACCESSIBLE",
		21: "STANDBY",
	}
	State_value = map[string]int32{
		"STATE_UNSPECIFIED":         0,
		"PROVISIONING":              1,
		"AVAILABLE":                 2,
		"STOPPING":                  3,
		"STOPPED":                   4,
		"STARTING":                  5,
		"TERMINATING":               6,
		"TERMINATED":                7,
		"UNAVAILABLE":               8,
		"RESTORE_IN_PROGRESS":       9,
		"RESTORE_FAILED":            10,
		"BACKUP_IN_PROGRESS":        11,
		"SCALE_IN_PROGRESS":         12,
		"AVAILABLE_NEEDS_ATTENTION": 13,
		"UPDATING":                  14,
		"MAINTENANCE_IN_PROGRESS":   15,
		"RESTARTING":                16,
		"RECREATING":                17,
		"ROLE_CHANGE_IN_PROGRESS":   18,
		"UPGRADING":                 19,
		"INACCESSIBLE":              20,
		"STANDBY":                   21,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[1].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[1]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1}
}

// The state of the Operations Insights for this Autonomous Database.
type OperationsInsightsState int32

const (
	// Default unspecified value.
	OperationsInsightsState_OPERATIONS_INSIGHTS_STATE_UNSPECIFIED OperationsInsightsState = 0
	// Enabling status for operation insights.
	OperationsInsightsState_ENABLING OperationsInsightsState = 1
	// Enabled status for operation insights.
	OperationsInsightsState_ENABLED OperationsInsightsState = 2
	// Disabling status for operation insights.
	OperationsInsightsState_DISABLING OperationsInsightsState = 3
	// Not Enabled status for operation insights.
	OperationsInsightsState_NOT_ENABLED OperationsInsightsState = 4
	// Failed enabling status for operation insights.
	OperationsInsightsState_FAILED_ENABLING OperationsInsightsState = 5
	// Failed disabling status for operation insights.
	OperationsInsightsState_FAILED_DISABLING OperationsInsightsState = 6
)

// Enum value maps for OperationsInsightsState.
var (
	OperationsInsightsState_name = map[int32]string{
		0: "OPERATIONS_INSIGHTS_STATE_UNSPECIFIED",
		1: "ENABLING",
		2: "ENABLED",
		3: "DISABLING",
		4: "NOT_ENABLED",
		5: "FAILED_ENABLING",
		6: "FAILED_DISABLING",
	}
	OperationsInsightsState_value = map[string]int32{
		"OPERATIONS_INSIGHTS_STATE_UNSPECIFIED": 0,
		"ENABLING":                              1,
		"ENABLED":                               2,
		"DISABLING":                             3,
		"NOT_ENABLED":                           4,
		"FAILED_ENABLING":                       5,
		"FAILED_DISABLING":                      6,
	}
)

func (x OperationsInsightsState) Enum() *OperationsInsightsState {
	p := new(OperationsInsightsState)
	*p = x
	return p
}

func (x OperationsInsightsState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationsInsightsState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[2].Descriptor()
}

func (OperationsInsightsState) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[2]
}

func (x OperationsInsightsState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationsInsightsState.Descriptor instead.
func (OperationsInsightsState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{2}
}

// The various states available for the Autonomous Database workload type.
type DBWorkload int32

const (
	// Default unspecified value.
	DBWorkload_DB_WORKLOAD_UNSPECIFIED DBWorkload = 0
	// Autonomous Transaction Processing database.
	DBWorkload_OLTP DBWorkload = 1
	// Autonomous Data Warehouse database.
	DBWorkload_DW DBWorkload = 2
	// Autonomous JSON Database.
	DBWorkload_AJD DBWorkload = 3
	// Autonomous Database with the Oracle APEX Application Development workload
	// type.
	DBWorkload_APEX DBWorkload = 4
)

// Enum value maps for DBWorkload.
var (
	DBWorkload_name = map[int32]string{
		0: "DB_WORKLOAD_UNSPECIFIED",
		1: "OLTP",
		2: "DW",
		3: "AJD",
		4: "APEX",
	}
	DBWorkload_value = map[string]int32{
		"DB_WORKLOAD_UNSPECIFIED": 0,
		"OLTP":                    1,
		"DW":                      2,
		"AJD":                     3,
		"APEX":                    4,
	}
)

func (x DBWorkload) Enum() *DBWorkload {
	p := new(DBWorkload)
	*p = x
	return p
}

func (x DBWorkload) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DBWorkload) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[3].Descriptor()
}

func (DBWorkload) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[3]
}

func (x DBWorkload) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DBWorkload.Descriptor instead.
func (DBWorkload) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{3}
}

// The editions available for the Autonomous Database.
type AutonomousDatabaseProperties_DatabaseEdition int32

const (
	// Default unspecified value.
	AutonomousDatabaseProperties_DATABASE_EDITION_UNSPECIFIED AutonomousDatabaseProperties_DatabaseEdition = 0
	// Standard Database Edition
	AutonomousDatabaseProperties_STANDARD_EDITION AutonomousDatabaseProperties_DatabaseEdition = 1
	// Enterprise Database Edition
	AutonomousDatabaseProperties_ENTERPRISE_EDITION AutonomousDatabaseProperties_DatabaseEdition = 2
)

// Enum value maps for AutonomousDatabaseProperties_DatabaseEdition.
var (
	AutonomousDatabaseProperties_DatabaseEdition_name = map[int32]string{
		0: "DATABASE_EDITION_UNSPECIFIED",
		1: "STANDARD_EDITION",
		2: "ENTERPRISE_EDITION",
	}
	AutonomousDatabaseProperties_DatabaseEdition_value = map[string]int32{
		"DATABASE_EDITION_UNSPECIFIED": 0,
		"STANDARD_EDITION":             1,
		"ENTERPRISE_EDITION":           2,
	}
)

func (x AutonomousDatabaseProperties_DatabaseEdition) Enum() *AutonomousDatabaseProperties_DatabaseEdition {
	p := new(AutonomousDatabaseProperties_DatabaseEdition)
	*p = x
	return p
}

func (x AutonomousDatabaseProperties_DatabaseEdition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseProperties_DatabaseEdition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[4].Descriptor()
}

func (AutonomousDatabaseProperties_DatabaseEdition) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[4]
}

func (x AutonomousDatabaseProperties_DatabaseEdition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseProperties_DatabaseEdition.Descriptor instead.
func (AutonomousDatabaseProperties_DatabaseEdition) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1, 0}
}

// The license types available for the Autonomous Database.
type AutonomousDatabaseProperties_LicenseType int32

const (
	// Unspecified
	AutonomousDatabaseProperties_LICENSE_TYPE_UNSPECIFIED AutonomousDatabaseProperties_LicenseType = 0
	// License included part of offer
	AutonomousDatabaseProperties_LICENSE_INCLUDED AutonomousDatabaseProperties_LicenseType = 1
	// Bring your own license
	AutonomousDatabaseProperties_BRING_YOUR_OWN_LICENSE AutonomousDatabaseProperties_LicenseType = 2
)

// Enum value maps for AutonomousDatabaseProperties_LicenseType.
var (
	AutonomousDatabaseProperties_LicenseType_name = map[int32]string{
		0: "LICENSE_TYPE_UNSPECIFIED",
		1: "LICENSE_INCLUDED",
		2: "BRING_YOUR_OWN_LICENSE",
	}
	AutonomousDatabaseProperties_LicenseType_value = map[string]int32{
		"LICENSE_TYPE_UNSPECIFIED": 0,
		"LICENSE_INCLUDED":         1,
		"BRING_YOUR_OWN_LICENSE":   2,
	}
)

func (x AutonomousDatabaseProperties_LicenseType) Enum() *AutonomousDatabaseProperties_LicenseType {
	p := new(AutonomousDatabaseProperties_LicenseType)
	*p = x
	return p
}

func (x AutonomousDatabaseProperties_LicenseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseProperties_LicenseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[5].Descriptor()
}

func (AutonomousDatabaseProperties_LicenseType) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[5]
}

func (x AutonomousDatabaseProperties_LicenseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseProperties_LicenseType.Descriptor instead.
func (AutonomousDatabaseProperties_LicenseType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1, 1}
}

// The available maintenance schedules for the Autonomous Database.
type AutonomousDatabaseProperties_MaintenanceScheduleType int32

const (
	// Default unspecified value.
	AutonomousDatabaseProperties_MAINTENANCE_SCHEDULE_TYPE_UNSPECIFIED AutonomousDatabaseProperties_MaintenanceScheduleType = 0
	// An EARLY maintenance schedule patches the database before
	// the regular scheduled maintenance.
	AutonomousDatabaseProperties_EARLY AutonomousDatabaseProperties_MaintenanceScheduleType = 1
	// A REGULAR maintenance schedule follows the normal maintenance cycle.
	AutonomousDatabaseProperties_REGULAR AutonomousDatabaseProperties_MaintenanceScheduleType = 2
)

// Enum value maps for AutonomousDatabaseProperties_MaintenanceScheduleType.
var (
	AutonomousDatabaseProperties_MaintenanceScheduleType_name = map[int32]string{
		0: "MAINTENANCE_SCHEDULE_TYPE_UNSPECIFIED",
		1: "EARLY",
		2: "REGULAR",
	}
	AutonomousDatabaseProperties_MaintenanceScheduleType_value = map[string]int32{
		"MAINTENANCE_SCHEDULE_TYPE_UNSPECIFIED": 0,
		"EARLY":                                 1,
		"REGULAR":                               2,
	}
)

func (x AutonomousDatabaseProperties_MaintenanceScheduleType) Enum() *AutonomousDatabaseProperties_MaintenanceScheduleType {
	p := new(AutonomousDatabaseProperties_MaintenanceScheduleType)
	*p = x
	return p
}

func (x AutonomousDatabaseProperties_MaintenanceScheduleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseProperties_MaintenanceScheduleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[6].Descriptor()
}

func (AutonomousDatabaseProperties_MaintenanceScheduleType) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[6]
}

func (x AutonomousDatabaseProperties_MaintenanceScheduleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseProperties_MaintenanceScheduleType.Descriptor instead.
func (AutonomousDatabaseProperties_MaintenanceScheduleType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1, 2}
}

// The types of local disaster recovery available for an Autonomous Database.
type AutonomousDatabaseProperties_LocalDisasterRecoveryType int32

const (
	// Default unspecified value.
	AutonomousDatabaseProperties_LOCAL_DISASTER_RECOVERY_TYPE_UNSPECIFIED AutonomousDatabaseProperties_LocalDisasterRecoveryType = 0
	// Autonomous Data Guard recovery.
	AutonomousDatabaseProperties_ADG AutonomousDatabaseProperties_LocalDisasterRecoveryType = 1
	// Backup based recovery.
	AutonomousDatabaseProperties_BACKUP_BASED AutonomousDatabaseProperties_LocalDisasterRecoveryType = 2
)

// Enum value maps for AutonomousDatabaseProperties_LocalDisasterRecoveryType.
var (
	AutonomousDatabaseProperties_LocalDisasterRecoveryType_name = map[int32]string{
		0: "LOCAL_DISASTER_RECOVERY_TYPE_UNSPECIFIED",
		1: "ADG",
		2: "BACKUP_BASED",
	}
	AutonomousDatabaseProperties_LocalDisasterRecoveryType_value = map[string]int32{
		"LOCAL_DISASTER_RECOVERY_TYPE_UNSPECIFIED": 0,
		"ADG":          1,
		"BACKUP_BASED": 2,
	}
)

func (x AutonomousDatabaseProperties_LocalDisasterRecoveryType) Enum() *AutonomousDatabaseProperties_LocalDisasterRecoveryType {
	p := new(AutonomousDatabaseProperties_LocalDisasterRecoveryType)
	*p = x
	return p
}

func (x AutonomousDatabaseProperties_LocalDisasterRecoveryType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseProperties_LocalDisasterRecoveryType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[7].Descriptor()
}

func (AutonomousDatabaseProperties_LocalDisasterRecoveryType) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[7]
}

func (x AutonomousDatabaseProperties_LocalDisasterRecoveryType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseProperties_LocalDisasterRecoveryType.Descriptor instead.
func (AutonomousDatabaseProperties_LocalDisasterRecoveryType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1, 3}
}

// Varies states of the Data Safe registration for the Autonomous Database.
type AutonomousDatabaseProperties_DataSafeState int32

const (
	// Default unspecified value.
	AutonomousDatabaseProperties_DATA_SAFE_STATE_UNSPECIFIED AutonomousDatabaseProperties_DataSafeState = 0
	// Registering data safe state.
	AutonomousDatabaseProperties_REGISTERING AutonomousDatabaseProperties_DataSafeState = 1
	// Registered data safe state.
	AutonomousDatabaseProperties_REGISTERED AutonomousDatabaseProperties_DataSafeState = 2
	// Deregistering data safe state.
	AutonomousDatabaseProperties_DEREGISTERING AutonomousDatabaseProperties_DataSafeState = 3
	// Not registered data safe state.
	AutonomousDatabaseProperties_NOT_REGISTERED AutonomousDatabaseProperties_DataSafeState = 4
	// Failed data safe state.
	AutonomousDatabaseProperties_FAILED AutonomousDatabaseProperties_DataSafeState = 5
)

// Enum value maps for AutonomousDatabaseProperties_DataSafeState.
var (
	AutonomousDatabaseProperties_DataSafeState_name = map[int32]string{
		0: "DATA_SAFE_STATE_UNSPECIFIED",
		1: "REGISTERING",
		2: "REGISTERED",
		3: "DEREGISTERING",
		4: "NOT_REGISTERED",
		5: "FAILED",
	}
	AutonomousDatabaseProperties_DataSafeState_value = map[string]int32{
		"DATA_SAFE_STATE_UNSPECIFIED": 0,
		"REGISTERING":                 1,
		"REGISTERED":                  2,
		"DEREGISTERING":               3,
		"NOT_REGISTERED":              4,
		"FAILED":                      5,
	}
)

func (x AutonomousDatabaseProperties_DataSafeState) Enum() *AutonomousDatabaseProperties_DataSafeState {
	p := new(AutonomousDatabaseProperties_DataSafeState)
	*p = x
	return p
}

func (x AutonomousDatabaseProperties_DataSafeState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseProperties_DataSafeState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[8].Descriptor()
}

func (AutonomousDatabaseProperties_DataSafeState) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[8]
}

func (x AutonomousDatabaseProperties_DataSafeState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseProperties_DataSafeState.Descriptor instead.
func (AutonomousDatabaseProperties_DataSafeState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1, 4}
}

// The different states of database management for an Autonomous Database.
type AutonomousDatabaseProperties_DatabaseManagementState int32

const (
	// Default unspecified value.
	AutonomousDatabaseProperties_DATABASE_MANAGEMENT_STATE_UNSPECIFIED AutonomousDatabaseProperties_DatabaseManagementState = 0
	// Enabling Database Management state
	AutonomousDatabaseProperties_ENABLING AutonomousDatabaseProperties_DatabaseManagementState = 1
	// Enabled Database Management state
	AutonomousDatabaseProperties_ENABLED AutonomousDatabaseProperties_DatabaseManagementState = 2
	// Disabling Database Management state
	AutonomousDatabaseProperties_DISABLING AutonomousDatabaseProperties_DatabaseManagementState = 3
	// Not Enabled Database Management state
	AutonomousDatabaseProperties_NOT_ENABLED AutonomousDatabaseProperties_DatabaseManagementState = 4
	// Failed enabling Database Management state
	AutonomousDatabaseProperties_FAILED_ENABLING AutonomousDatabaseProperties_DatabaseManagementState = 5
	// Failed disabling Database Management state
	AutonomousDatabaseProperties_FAILED_DISABLING AutonomousDatabaseProperties_DatabaseManagementState = 6
)

// Enum value maps for AutonomousDatabaseProperties_DatabaseManagementState.
var (
	AutonomousDatabaseProperties_DatabaseManagementState_name = map[int32]string{
		0: "DATABASE_MANAGEMENT_STATE_UNSPECIFIED",
		1: "ENABLING",
		2: "ENABLED",
		3: "DISABLING",
		4: "NOT_ENABLED",
		5: "FAILED_ENABLING",
		6: "FAILED_DISABLING",
	}
	AutonomousDatabaseProperties_DatabaseManagementState_value = map[string]int32{
		"DATABASE_MANAGEMENT_STATE_UNSPECIFIED": 0,
		"ENABLING":                              1,
		"ENABLED":                               2,
		"DISABLING":                             3,
		"NOT_ENABLED":                           4,
		"FAILED_ENABLING":                       5,
		"FAILED_DISABLING":                      6,
	}
)

func (x AutonomousDatabaseProperties_DatabaseManagementState) Enum() *AutonomousDatabaseProperties_DatabaseManagementState {
	p := new(AutonomousDatabaseProperties_DatabaseManagementState)
	*p = x
	return p
}

func (x AutonomousDatabaseProperties_DatabaseManagementState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseProperties_DatabaseManagementState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[9].Descriptor()
}

func (AutonomousDatabaseProperties_DatabaseManagementState) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[9]
}

func (x AutonomousDatabaseProperties_DatabaseManagementState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseProperties_DatabaseManagementState.Descriptor instead.
func (AutonomousDatabaseProperties_DatabaseManagementState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1, 5}
}

// This field indicates the modes of an Autonomous Database.
type AutonomousDatabaseProperties_OpenMode int32

const (
	// Default unspecified value.
	AutonomousDatabaseProperties_OPEN_MODE_UNSPECIFIED AutonomousDatabaseProperties_OpenMode = 0
	// Read Only Mode
	AutonomousDatabaseProperties_READ_ONLY AutonomousDatabaseProperties_OpenMode = 1
	// Read Write Mode
	AutonomousDatabaseProperties_READ_WRITE AutonomousDatabaseProperties_OpenMode = 2
)

// Enum value maps for AutonomousDatabaseProperties_OpenMode.
var (
	AutonomousDatabaseProperties_OpenMode_name = map[int32]string{
		0: "OPEN_MODE_UNSPECIFIED",
		1: "READ_ONLY",
		2: "READ_WRITE",
	}
	AutonomousDatabaseProperties_OpenMode_value = map[string]int32{
		"OPEN_MODE_UNSPECIFIED": 0,
		"READ_ONLY":             1,
		"READ_WRITE":            2,
	}
)

func (x AutonomousDatabaseProperties_OpenMode) Enum() *AutonomousDatabaseProperties_OpenMode {
	p := new(AutonomousDatabaseProperties_OpenMode)
	*p = x
	return p
}

func (x AutonomousDatabaseProperties_OpenMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseProperties_OpenMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[10].Descriptor()
}

func (AutonomousDatabaseProperties_OpenMode) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[10]
}

func (x AutonomousDatabaseProperties_OpenMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseProperties_OpenMode.Descriptor instead.
func (AutonomousDatabaseProperties_OpenMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1, 6}
}

// The types of permission levels for an Autonomous Database.
type AutonomousDatabaseProperties_PermissionLevel int32

const (
	// Default unspecified value.
	AutonomousDatabaseProperties_PERMISSION_LEVEL_UNSPECIFIED AutonomousDatabaseProperties_PermissionLevel = 0
	// Restricted mode allows access only by admin users.
	AutonomousDatabaseProperties_RESTRICTED AutonomousDatabaseProperties_PermissionLevel = 1
	// Normal access.
	AutonomousDatabaseProperties_UNRESTRICTED AutonomousDatabaseProperties_PermissionLevel = 2
)

// Enum value maps for AutonomousDatabaseProperties_PermissionLevel.
var (
	AutonomousDatabaseProperties_PermissionLevel_name = map[int32]string{
		0: "PERMISSION_LEVEL_UNSPECIFIED",
		1: "RESTRICTED",
		2: "UNRESTRICTED",
	}
	AutonomousDatabaseProperties_PermissionLevel_value = map[string]int32{
		"PERMISSION_LEVEL_UNSPECIFIED": 0,
		"RESTRICTED":                   1,
		"UNRESTRICTED":                 2,
	}
)

func (x AutonomousDatabaseProperties_PermissionLevel) Enum() *AutonomousDatabaseProperties_PermissionLevel {
	p := new(AutonomousDatabaseProperties_PermissionLevel)
	*p = x
	return p
}

func (x AutonomousDatabaseProperties_PermissionLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseProperties_PermissionLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[11].Descriptor()
}

func (AutonomousDatabaseProperties_PermissionLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[11]
}

func (x AutonomousDatabaseProperties_PermissionLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseProperties_PermissionLevel.Descriptor instead.
func (AutonomousDatabaseProperties_PermissionLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1, 7}
}

// The refresh mode of the cloned Autonomous Database.
type AutonomousDatabaseProperties_RefreshableMode int32

const (
	// The default unspecified value.
	AutonomousDatabaseProperties_REFRESHABLE_MODE_UNSPECIFIED AutonomousDatabaseProperties_RefreshableMode = 0
	// AUTOMATIC indicates that the cloned database is automatically
	// refreshed with data from the source Autonomous Database.
	AutonomousDatabaseProperties_AUTOMATIC AutonomousDatabaseProperties_RefreshableMode = 1
	// MANUAL indicates that the cloned database is manually refreshed with
	// data from the source Autonomous Database.
	AutonomousDatabaseProperties_MANUAL AutonomousDatabaseProperties_RefreshableMode = 2
)

// Enum value maps for AutonomousDatabaseProperties_RefreshableMode.
var (
	AutonomousDatabaseProperties_RefreshableMode_name = map[int32]string{
		0: "REFRESHABLE_MODE_UNSPECIFIED",
		1: "AUTOMATIC",
		2: "MANUAL",
	}
	AutonomousDatabaseProperties_RefreshableMode_value = map[string]int32{
		"REFRESHABLE_MODE_UNSPECIFIED": 0,
		"AUTOMATIC":                    1,
		"MANUAL":                       2,
	}
)

func (x AutonomousDatabaseProperties_RefreshableMode) Enum() *AutonomousDatabaseProperties_RefreshableMode {
	p := new(AutonomousDatabaseProperties_RefreshableMode)
	*p = x
	return p
}

func (x AutonomousDatabaseProperties_RefreshableMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseProperties_RefreshableMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[12].Descriptor()
}

func (AutonomousDatabaseProperties_RefreshableMode) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[12]
}

func (x AutonomousDatabaseProperties_RefreshableMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseProperties_RefreshableMode.Descriptor instead.
func (AutonomousDatabaseProperties_RefreshableMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1, 8}
}

// The refresh state of the cloned Autonomous Database.
type AutonomousDatabaseProperties_RefreshableState int32

const (
	// Default unspecified value.
	AutonomousDatabaseProperties_REFRESHABLE_STATE_UNSPECIFIED AutonomousDatabaseProperties_RefreshableState = 0
	// Refreshing
	AutonomousDatabaseProperties_REFRESHING AutonomousDatabaseProperties_RefreshableState = 1
	// Not refreshed
	AutonomousDatabaseProperties_NOT_REFRESHING AutonomousDatabaseProperties_RefreshableState = 2
)

// Enum value maps for AutonomousDatabaseProperties_RefreshableState.
var (
	AutonomousDatabaseProperties_RefreshableState_name = map[int32]string{
		0: "REFRESHABLE_STATE_UNSPECIFIED",
		1: "REFRESHING",
		2: "NOT_REFRESHING",
	}
	AutonomousDatabaseProperties_RefreshableState_value = map[string]int32{
		"REFRESHABLE_STATE_UNSPECIFIED": 0,
		"REFRESHING":                    1,
		"NOT_REFRESHING":                2,
	}
)

func (x AutonomousDatabaseProperties_RefreshableState) Enum() *AutonomousDatabaseProperties_RefreshableState {
	p := new(AutonomousDatabaseProperties_RefreshableState)
	*p = x
	return p
}

func (x AutonomousDatabaseProperties_RefreshableState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseProperties_RefreshableState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[13].Descriptor()
}

func (AutonomousDatabaseProperties_RefreshableState) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[13]
}

func (x AutonomousDatabaseProperties_RefreshableState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseProperties_RefreshableState.Descriptor instead.
func (AutonomousDatabaseProperties_RefreshableState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1, 9}
}

// The Data Guard role of the Autonomous Database.
type AutonomousDatabaseProperties_Role int32

const (
	// Default unspecified value.
	AutonomousDatabaseProperties_ROLE_UNSPECIFIED AutonomousDatabaseProperties_Role = 0
	// Primary role
	AutonomousDatabaseProperties_PRIMARY AutonomousDatabaseProperties_Role = 1
	// Standby role
	AutonomousDatabaseProperties_STANDBY AutonomousDatabaseProperties_Role = 2
	// Disabled standby role
	AutonomousDatabaseProperties_DISABLED_STANDBY AutonomousDatabaseProperties_Role = 3
	// Backup copy role
	AutonomousDatabaseProperties_BACKUP_COPY AutonomousDatabaseProperties_Role = 4
	// Snapshot standby role
	AutonomousDatabaseProperties_SNAPSHOT_STANDBY AutonomousDatabaseProperties_Role = 5
)

// Enum value maps for AutonomousDatabaseProperties_Role.
var (
	AutonomousDatabaseProperties_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "PRIMARY",
		2: "STANDBY",
		3: "DISABLED_STANDBY",
		4: "BACKUP_COPY",
		5: "SNAPSHOT_STANDBY",
	}
	AutonomousDatabaseProperties_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"PRIMARY":          1,
		"STANDBY":          2,
		"DISABLED_STANDBY": 3,
		"BACKUP_COPY":      4,
		"SNAPSHOT_STANDBY": 5,
	}
)

func (x AutonomousDatabaseProperties_Role) Enum() *AutonomousDatabaseProperties_Role {
	p := new(AutonomousDatabaseProperties_Role)
	*p = x
	return p
}

func (x AutonomousDatabaseProperties_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseProperties_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[14].Descriptor()
}

func (AutonomousDatabaseProperties_Role) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[14]
}

func (x AutonomousDatabaseProperties_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseProperties_Role.Descriptor instead.
func (AutonomousDatabaseProperties_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1, 10}
}

// The various consumer groups available in the connection string profile.
type DatabaseConnectionStringProfile_ConsumerGroup int32

const (
	// Default unspecified value.
	DatabaseConnectionStringProfile_CONSUMER_GROUP_UNSPECIFIED DatabaseConnectionStringProfile_ConsumerGroup = 0
	// High consumer group.
	DatabaseConnectionStringProfile_HIGH DatabaseConnectionStringProfile_ConsumerGroup = 1
	// Medium consumer group.
	DatabaseConnectionStringProfile_MEDIUM DatabaseConnectionStringProfile_ConsumerGroup = 2
	// Low consumer group.
	DatabaseConnectionStringProfile_LOW DatabaseConnectionStringProfile_ConsumerGroup = 3
	// TP consumer group.
	DatabaseConnectionStringProfile_TP DatabaseConnectionStringProfile_ConsumerGroup = 4
	// TPURGENT consumer group.
	DatabaseConnectionStringProfile_TPURGENT DatabaseConnectionStringProfile_ConsumerGroup = 5
)

// Enum value maps for DatabaseConnectionStringProfile_ConsumerGroup.
var (
	DatabaseConnectionStringProfile_ConsumerGroup_name = map[int32]string{
		0: "CONSUMER_GROUP_UNSPECIFIED",
		1: "HIGH",
		2: "MEDIUM",
		3: "LOW",
		4: "TP",
		5: "TPURGENT",
	}
	DatabaseConnectionStringProfile_ConsumerGroup_value = map[string]int32{
		"CONSUMER_GROUP_UNSPECIFIED": 0,
		"HIGH":                       1,
		"MEDIUM":                     2,
		"LOW":                        3,
		"TP":                         4,
		"TPURGENT":                   5,
	}
)

func (x DatabaseConnectionStringProfile_ConsumerGroup) Enum() *DatabaseConnectionStringProfile_ConsumerGroup {
	p := new(DatabaseConnectionStringProfile_ConsumerGroup)
	*p = x
	return p
}

func (x DatabaseConnectionStringProfile_ConsumerGroup) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseConnectionStringProfile_ConsumerGroup) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[15].Descriptor()
}

func (DatabaseConnectionStringProfile_ConsumerGroup) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[15]
}

func (x DatabaseConnectionStringProfile_ConsumerGroup) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseConnectionStringProfile_ConsumerGroup.Descriptor instead.
func (DatabaseConnectionStringProfile_ConsumerGroup) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{4, 0}
}

// The host name format being used in the connection string.
type DatabaseConnectionStringProfile_HostFormat int32

const (
	// Default unspecified value.
	DatabaseConnectionStringProfile_HOST_FORMAT_UNSPECIFIED DatabaseConnectionStringProfile_HostFormat = 0
	// FQDN
	DatabaseConnectionStringProfile_FQDN DatabaseConnectionStringProfile_HostFormat = 1
	// IP
	DatabaseConnectionStringProfile_IP DatabaseConnectionStringProfile_HostFormat = 2
)

// Enum value maps for DatabaseConnectionStringProfile_HostFormat.
var (
	DatabaseConnectionStringProfile_HostFormat_name = map[int32]string{
		0: "HOST_FORMAT_UNSPECIFIED",
		1: "FQDN",
		2: "IP",
	}
	DatabaseConnectionStringProfile_HostFormat_value = map[string]int32{
		"HOST_FORMAT_UNSPECIFIED": 0,
		"FQDN":                    1,
		"IP":                      2,
	}
)

func (x DatabaseConnectionStringProfile_HostFormat) Enum() *DatabaseConnectionStringProfile_HostFormat {
	p := new(DatabaseConnectionStringProfile_HostFormat)
	*p = x
	return p
}

func (x DatabaseConnectionStringProfile_HostFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseConnectionStringProfile_HostFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[16].Descriptor()
}

func (DatabaseConnectionStringProfile_HostFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[16]
}

func (x DatabaseConnectionStringProfile_HostFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseConnectionStringProfile_HostFormat.Descriptor instead.
func (DatabaseConnectionStringProfile_HostFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{4, 1}
}

// The protocol being used by the connection.
type DatabaseConnectionStringProfile_Protocol int32

const (
	// Default unspecified value.
	DatabaseConnectionStringProfile_PROTOCOL_UNSPECIFIED DatabaseConnectionStringProfile_Protocol = 0
	// Tcp
	DatabaseConnectionStringProfile_TCP DatabaseConnectionStringProfile_Protocol = 1
	// Tcps
	DatabaseConnectionStringProfile_TCPS DatabaseConnectionStringProfile_Protocol = 2
)

// Enum value maps for DatabaseConnectionStringProfile_Protocol.
var (
	DatabaseConnectionStringProfile_Protocol_name = map[int32]string{
		0: "PROTOCOL_UNSPECIFIED",
		1: "TCP",
		2: "TCPS",
	}
	DatabaseConnectionStringProfile_Protocol_value = map[string]int32{
		"PROTOCOL_UNSPECIFIED": 0,
		"TCP":                  1,
		"TCPS":                 2,
	}
)

func (x DatabaseConnectionStringProfile_Protocol) Enum() *DatabaseConnectionStringProfile_Protocol {
	p := new(DatabaseConnectionStringProfile_Protocol)
	*p = x
	return p
}

func (x DatabaseConnectionStringProfile_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseConnectionStringProfile_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[17].Descriptor()
}

func (DatabaseConnectionStringProfile_Protocol) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[17]
}

func (x DatabaseConnectionStringProfile_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseConnectionStringProfile_Protocol.Descriptor instead.
func (DatabaseConnectionStringProfile_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{4, 2}
}

// The session mode of the connection.
type DatabaseConnectionStringProfile_SessionMode int32

const (
	// Default unspecified value.
	DatabaseConnectionStringProfile_SESSION_MODE_UNSPECIFIED DatabaseConnectionStringProfile_SessionMode = 0
	// Direct
	DatabaseConnectionStringProfile_DIRECT DatabaseConnectionStringProfile_SessionMode = 1
	// Indirect
	DatabaseConnectionStringProfile_INDIRECT DatabaseConnectionStringProfile_SessionMode = 2
)

// Enum value maps for DatabaseConnectionStringProfile_SessionMode.
var (
	DatabaseConnectionStringProfile_SessionMode_name = map[int32]string{
		0: "SESSION_MODE_UNSPECIFIED",
		1: "DIRECT",
		2: "INDIRECT",
	}
	DatabaseConnectionStringProfile_SessionMode_value = map[string]int32{
		"SESSION_MODE_UNSPECIFIED": 0,
		"DIRECT":                   1,
		"INDIRECT":                 2,
	}
)

func (x DatabaseConnectionStringProfile_SessionMode) Enum() *DatabaseConnectionStringProfile_SessionMode {
	p := new(DatabaseConnectionStringProfile_SessionMode)
	*p = x
	return p
}

func (x DatabaseConnectionStringProfile_SessionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseConnectionStringProfile_SessionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[18].Descriptor()
}

func (DatabaseConnectionStringProfile_SessionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[18]
}

func (x DatabaseConnectionStringProfile_SessionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseConnectionStringProfile_SessionMode.Descriptor instead.
func (DatabaseConnectionStringProfile_SessionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{4, 3}
}

// Specifies syntax of the connection string.
type DatabaseConnectionStringProfile_SyntaxFormat int32

const (
	// Default unspecified value.
	DatabaseConnectionStringProfile_SYNTAX_FORMAT_UNSPECIFIED DatabaseConnectionStringProfile_SyntaxFormat = 0
	// Long
	DatabaseConnectionStringProfile_LONG DatabaseConnectionStringProfile_SyntaxFormat = 1
	// Ezconnect
	DatabaseConnectionStringProfile_EZCONNECT DatabaseConnectionStringProfile_SyntaxFormat = 2
	// Ezconnectplus
	DatabaseConnectionStringProfile_EZCONNECTPLUS DatabaseConnectionStringProfile_SyntaxFormat = 3
)

// Enum value maps for DatabaseConnectionStringProfile_SyntaxFormat.
var (
	DatabaseConnectionStringProfile_SyntaxFormat_name = map[int32]string{
		0: "SYNTAX_FORMAT_UNSPECIFIED",
		1: "LONG",
		2: "EZCONNECT",
		3: "EZCONNECTPLUS",
	}
	DatabaseConnectionStringProfile_SyntaxFormat_value = map[string]int32{
		"SYNTAX_FORMAT_UNSPECIFIED": 0,
		"LONG":                      1,
		"EZCONNECT":                 2,
		"EZCONNECTPLUS":             3,
	}
)

func (x DatabaseConnectionStringProfile_SyntaxFormat) Enum() *DatabaseConnectionStringProfile_SyntaxFormat {
	p := new(DatabaseConnectionStringProfile_SyntaxFormat)
	*p = x
	return p
}

func (x DatabaseConnectionStringProfile_SyntaxFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseConnectionStringProfile_SyntaxFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[19].Descriptor()
}

func (DatabaseConnectionStringProfile_SyntaxFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[19]
}

func (x DatabaseConnectionStringProfile_SyntaxFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseConnectionStringProfile_SyntaxFormat.Descriptor instead.
func (DatabaseConnectionStringProfile_SyntaxFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{4, 4}
}

// This field indicates the TLS authentication type of the connection.
type DatabaseConnectionStringProfile_TLSAuthentication int32

const (
	// Default unspecified value.
	DatabaseConnectionStringProfile_TLS_AUTHENTICATION_UNSPECIFIED DatabaseConnectionStringProfile_TLSAuthentication = 0
	// Server
	DatabaseConnectionStringProfile_SERVER DatabaseConnectionStringProfile_TLSAuthentication = 1
	// Mutual
	DatabaseConnectionStringProfile_MUTUAL DatabaseConnectionStringProfile_TLSAuthentication = 2
)

// Enum value maps for DatabaseConnectionStringProfile_TLSAuthentication.
var (
	DatabaseConnectionStringProfile_TLSAuthentication_name = map[int32]string{
		0: "TLS_AUTHENTICATION_UNSPECIFIED",
		1: "SERVER",
		2: "MUTUAL",
	}
	DatabaseConnectionStringProfile_TLSAuthentication_value = map[string]int32{
		"TLS_AUTHENTICATION_UNSPECIFIED": 0,
		"SERVER":                         1,
		"MUTUAL":                         2,
	}
)

func (x DatabaseConnectionStringProfile_TLSAuthentication) Enum() *DatabaseConnectionStringProfile_TLSAuthentication {
	p := new(DatabaseConnectionStringProfile_TLSAuthentication)
	*p = x
	return p
}

func (x DatabaseConnectionStringProfile_TLSAuthentication) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseConnectionStringProfile_TLSAuthentication) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[20].Descriptor()
}

func (DatabaseConnectionStringProfile_TLSAuthentication) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes[20]
}

func (x DatabaseConnectionStringProfile_TLSAuthentication) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseConnectionStringProfile_TLSAuthentication.Descriptor instead.
func (DatabaseConnectionStringProfile_TLSAuthentication) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{4, 5}
}

// Details of the Autonomous Database resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabase/
type AutonomousDatabase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the Autonomous Database resource in the following
	// format:
	// projects/{project}/locations/{region}/autonomousDatabases/{autonomous_database}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The name of the Autonomous Database. The database name must be
	// unique in the project. The name must begin with a letter and can contain a
	// maximum of 30 alphanumeric characters.
	Database string `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	// Optional. The display name for the Autonomous Database. The name does not
	// have to be unique within your project.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The ID of the subscription entitlement associated with the
	// Autonomous Database.
	EntitlementId string `protobuf:"bytes,5,opt,name=entitlement_id,json=entitlementId,proto3" json:"entitlement_id,omitempty"`
	// Optional. The password for the default ADMIN user.
	AdminPassword string `protobuf:"bytes,6,opt,name=admin_password,json=adminPassword,proto3" json:"admin_password,omitempty"`
	// Optional. The properties of the Autonomous Database.
	Properties *AutonomousDatabaseProperties `protobuf:"bytes,7,opt,name=properties,proto3" json:"properties,omitempty"`
	// Optional. The labels or tags associated with the Autonomous Database.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The name of the VPC network used by the Autonomous Database in
	// the following format: projects/{project}/global/networks/{network}
	Network string `protobuf:"bytes,9,opt,name=network,proto3" json:"network,omitempty"`
	// Required. The subnet CIDR range for the Autonmous Database.
	Cidr string `protobuf:"bytes,10,opt,name=cidr,proto3" json:"cidr,omitempty"`
	// Output only. The date and time that the Autonomous Database was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *AutonomousDatabase) Reset() {
	*x = AutonomousDatabase{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutonomousDatabase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutonomousDatabase) ProtoMessage() {}

func (x *AutonomousDatabase) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutonomousDatabase.ProtoReflect.Descriptor instead.
func (*AutonomousDatabase) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{0}
}

func (x *AutonomousDatabase) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AutonomousDatabase) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *AutonomousDatabase) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AutonomousDatabase) GetEntitlementId() string {
	if x != nil {
		return x.EntitlementId
	}
	return ""
}

func (x *AutonomousDatabase) GetAdminPassword() string {
	if x != nil {
		return x.AdminPassword
	}
	return ""
}

func (x *AutonomousDatabase) GetProperties() *AutonomousDatabaseProperties {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *AutonomousDatabase) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AutonomousDatabase) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *AutonomousDatabase) GetCidr() string {
	if x != nil {
		return x.Cidr
	}
	return ""
}

func (x *AutonomousDatabase) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// The properties of an Autonomous Database.
type AutonomousDatabaseProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. OCID of the Autonomous Database.
	// https://docs.oracle.com/en-us/iaas/Content/General/Concepts/identifiers.htm#Oracle
	Ocid string `protobuf:"bytes,1,opt,name=ocid,proto3" json:"ocid,omitempty"`
	// Optional. The number of compute servers for the Autonomous Database.
	ComputeCount float32 `protobuf:"fixed32,2,opt,name=compute_count,json=computeCount,proto3" json:"compute_count,omitempty"`
	// Optional. The number of CPU cores to be made available to the database.
	CpuCoreCount int32 `protobuf:"varint,3,opt,name=cpu_core_count,json=cpuCoreCount,proto3" json:"cpu_core_count,omitempty"`
	// Optional. The size of the data stored in the database, in terabytes.
	DataStorageSizeTb int32 `protobuf:"varint,4,opt,name=data_storage_size_tb,json=dataStorageSizeTb,proto3" json:"data_storage_size_tb,omitempty"`
	// Optional. The size of the data stored in the database, in gigabytes.
	DataStorageSizeGb int32 `protobuf:"varint,63,opt,name=data_storage_size_gb,json=dataStorageSizeGb,proto3" json:"data_storage_size_gb,omitempty"`
	// Required. The workload type of the Autonomous Database.
	DbWorkload DBWorkload `protobuf:"varint,5,opt,name=db_workload,json=dbWorkload,proto3,enum=google.cloud.oracledatabase.v1.DBWorkload" json:"db_workload,omitempty"`
	// Optional. The edition of the Autonomous Databases.
	DbEdition AutonomousDatabaseProperties_DatabaseEdition `protobuf:"varint,6,opt,name=db_edition,json=dbEdition,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseProperties_DatabaseEdition" json:"db_edition,omitempty"`
	// Optional. The character set for the Autonomous Database. The default is
	// AL32UTF8.
	CharacterSet string `protobuf:"bytes,8,opt,name=character_set,json=characterSet,proto3" json:"character_set,omitempty"`
	// Optional. The national character set for the Autonomous Database. The
	// default is AL16UTF16.
	NCharacterSet string `protobuf:"bytes,9,opt,name=n_character_set,json=nCharacterSet,proto3" json:"n_character_set,omitempty"`
	// Optional. The private endpoint IP address for the Autonomous Database.
	PrivateEndpointIp string `protobuf:"bytes,10,opt,name=private_endpoint_ip,json=privateEndpointIp,proto3" json:"private_endpoint_ip,omitempty"`
	// Optional. The private endpoint label for the Autonomous Database.
	PrivateEndpointLabel string `protobuf:"bytes,11,opt,name=private_endpoint_label,json=privateEndpointLabel,proto3" json:"private_endpoint_label,omitempty"`
	// Optional. The Oracle Database version for the Autonomous Database.
	DbVersion string `protobuf:"bytes,12,opt,name=db_version,json=dbVersion,proto3" json:"db_version,omitempty"`
	// Optional. This field indicates if auto scaling is enabled for the
	// Autonomous Database CPU core count.
	IsAutoScalingEnabled bool `protobuf:"varint,14,opt,name=is_auto_scaling_enabled,json=isAutoScalingEnabled,proto3" json:"is_auto_scaling_enabled,omitempty"`
	// Optional. This field indicates if auto scaling is enabled for the
	// Autonomous Database storage.
	IsStorageAutoScalingEnabled bool `protobuf:"varint,15,opt,name=is_storage_auto_scaling_enabled,json=isStorageAutoScalingEnabled,proto3" json:"is_storage_auto_scaling_enabled,omitempty"`
	// Required. The license type used for the Autonomous Database.
	LicenseType AutonomousDatabaseProperties_LicenseType `protobuf:"varint,16,opt,name=license_type,json=licenseType,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseProperties_LicenseType" json:"license_type,omitempty"`
	// Optional. The list of customer contacts.
	CustomerContacts []*CustomerContact `protobuf:"bytes,17,rep,name=customer_contacts,json=customerContacts,proto3" json:"customer_contacts,omitempty"`
	// Optional. The ID of the Oracle Cloud Infrastructure vault secret.
	SecretId string `protobuf:"bytes,18,opt,name=secret_id,json=secretId,proto3" json:"secret_id,omitempty"`
	// Optional. The ID of the Oracle Cloud Infrastructure vault.
	VaultId string `protobuf:"bytes,19,opt,name=vault_id,json=vaultId,proto3" json:"vault_id,omitempty"`
	// Optional. The maintenance schedule of the Autonomous Database.
	MaintenanceScheduleType AutonomousDatabaseProperties_MaintenanceScheduleType `protobuf:"varint,20,opt,name=maintenance_schedule_type,json=maintenanceScheduleType,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseProperties_MaintenanceScheduleType" json:"maintenance_schedule_type,omitempty"`
	// Optional. This field specifies if the Autonomous Database requires mTLS
	// connections.
	MtlsConnectionRequired bool `protobuf:"varint,34,opt,name=mtls_connection_required,json=mtlsConnectionRequired,proto3" json:"mtls_connection_required,omitempty"`
	// Optional. The retention period for the Autonomous Database. This field is
	// specified in days, can range from 1 day to 60 days, and has a default value
	// of 60 days.
	BackupRetentionPeriodDays int32 `protobuf:"varint,57,opt,name=backup_retention_period_days,json=backupRetentionPeriodDays,proto3" json:"backup_retention_period_days,omitempty"`
	// Output only. The amount of storage currently being used for user and system
	// data, in terabytes.
	ActualUsedDataStorageSizeTb float64 `protobuf:"fixed64,21,opt,name=actual_used_data_storage_size_tb,json=actualUsedDataStorageSizeTb,proto3" json:"actual_used_data_storage_size_tb,omitempty"`
	// Output only. The amount of storage currently allocated for the database
	// tables and billed for, rounded up in terabytes.
	AllocatedStorageSizeTb float64 `protobuf:"fixed64,22,opt,name=allocated_storage_size_tb,json=allocatedStorageSizeTb,proto3" json:"allocated_storage_size_tb,omitempty"`
	// Output only. The details for the Oracle APEX Application Development.
	ApexDetails *AutonomousDatabaseApex `protobuf:"bytes,23,opt,name=apex_details,json=apexDetails,proto3" json:"apex_details,omitempty"`
	// Output only. This field indicates the status of Data Guard and Access
	// control for the Autonomous Database. The field's value is null if Data
	// Guard is disabled or Access Control is disabled. The field's value is TRUE
	// if both Data Guard and Access Control are enabled, and the Autonomous
	// Database is using primary IP access control list (ACL) for standby. The
	// field's value is FALSE if both Data Guard and Access Control are enabled,
	// and the Autonomous Database is using a different IP access control list
	// (ACL) for standby compared to primary.
	ArePrimaryAllowlistedIpsUsed *bool `protobuf:"varint,24,opt,name=are_primary_allowlisted_ips_used,json=arePrimaryAllowlistedIpsUsed,proto3,oneof" json:"are_primary_allowlisted_ips_used,omitempty"`
	// Output only. The details of the current lifestyle state of the Autonomous
	// Database.
	LifecycleDetails string `protobuf:"bytes,25,opt,name=lifecycle_details,json=lifecycleDetails,proto3" json:"lifecycle_details,omitempty"`
	// Output only. The current lifecycle state of the Autonomous Database.
	State State `protobuf:"varint,26,opt,name=state,proto3,enum=google.cloud.oracledatabase.v1.State" json:"state,omitempty"`
	// Output only. The Autonomous Container Database OCID.
	AutonomousContainerDatabaseId string `protobuf:"bytes,27,opt,name=autonomous_container_database_id,json=autonomousContainerDatabaseId,proto3" json:"autonomous_container_database_id,omitempty"`
	// Output only. The list of available Oracle Database upgrade versions for an
	// Autonomous Database.
	AvailableUpgradeVersions []string `protobuf:"bytes,28,rep,name=available_upgrade_versions,json=availableUpgradeVersions,proto3" json:"available_upgrade_versions,omitempty"`
	// Output only. The connection strings used to connect to an Autonomous
	// Database.
	ConnectionStrings *AutonomousDatabaseConnectionStrings `protobuf:"bytes,29,opt,name=connection_strings,json=connectionStrings,proto3" json:"connection_strings,omitempty"`
	// Output only. The Oracle Connection URLs for an Autonomous Database.
	ConnectionUrls *AutonomousDatabaseConnectionUrls `protobuf:"bytes,30,opt,name=connection_urls,json=connectionUrls,proto3" json:"connection_urls,omitempty"`
	// Output only. This field indicates the number of seconds of data loss during
	// a Data Guard failover.
	FailedDataRecoveryDuration *durationpb.Duration `protobuf:"bytes,31,opt,name=failed_data_recovery_duration,json=failedDataRecoveryDuration,proto3" json:"failed_data_recovery_duration,omitempty"`
	// Output only. The memory assigned to in-memory tables in an Autonomous
	// Database.
	MemoryTableGbs int32 `protobuf:"varint,32,opt,name=memory_table_gbs,json=memoryTableGbs,proto3" json:"memory_table_gbs,omitempty"`
	// Output only. This field indicates whether the Autonomous Database has local
	// (in-region) Data Guard enabled.
	IsLocalDataGuardEnabled bool `protobuf:"varint,33,opt,name=is_local_data_guard_enabled,json=isLocalDataGuardEnabled,proto3" json:"is_local_data_guard_enabled,omitempty"`
	// Output only. This field indicates the maximum data loss limit for an
	// Autonomous Database, in seconds.
	LocalAdgAutoFailoverMaxDataLossLimit int32 `protobuf:"varint,35,opt,name=local_adg_auto_failover_max_data_loss_limit,json=localAdgAutoFailoverMaxDataLossLimit,proto3" json:"local_adg_auto_failover_max_data_loss_limit,omitempty"`
	// Output only. The details of the Autonomous Data Guard standby database.
	LocalStandbyDb *AutonomousDatabaseStandbySummary `protobuf:"bytes,36,opt,name=local_standby_db,json=localStandbyDb,proto3" json:"local_standby_db,omitempty"`
	// Output only. The amount of memory enabled per ECPU, in gigabytes.
	MemoryPerOracleComputeUnitGbs int32 `protobuf:"varint,37,opt,name=memory_per_oracle_compute_unit_gbs,json=memoryPerOracleComputeUnitGbs,proto3" json:"memory_per_oracle_compute_unit_gbs,omitempty"`
	// Output only. This field indicates the local disaster recovery (DR) type of
	// an Autonomous Database.
	LocalDisasterRecoveryType AutonomousDatabaseProperties_LocalDisasterRecoveryType `protobuf:"varint,38,opt,name=local_disaster_recovery_type,json=localDisasterRecoveryType,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseProperties_LocalDisasterRecoveryType" json:"local_disaster_recovery_type,omitempty"`
	// Output only. The current state of the Data Safe registration for the
	// Autonomous Database.
	DataSafeState AutonomousDatabaseProperties_DataSafeState `protobuf:"varint,39,opt,name=data_safe_state,json=dataSafeState,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseProperties_DataSafeState" json:"data_safe_state,omitempty"`
	// Output only. The current state of database management for the Autonomous
	// Database.
	DatabaseManagementState AutonomousDatabaseProperties_DatabaseManagementState `protobuf:"varint,40,opt,name=database_management_state,json=databaseManagementState,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseProperties_DatabaseManagementState" json:"database_management_state,omitempty"`
	// Output only. This field indicates the current mode of the Autonomous
	// Database.
	OpenMode AutonomousDatabaseProperties_OpenMode `protobuf:"varint,41,opt,name=open_mode,json=openMode,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseProperties_OpenMode" json:"open_mode,omitempty"`
	// Output only. This field indicates the state of Operations Insights for the
	// Autonomous Database.
	OperationsInsightsState OperationsInsightsState `protobuf:"varint,42,opt,name=operations_insights_state,json=operationsInsightsState,proto3,enum=google.cloud.oracledatabase.v1.OperationsInsightsState" json:"operations_insights_state,omitempty"`
	// Output only. The list of OCIDs of standby databases located in Autonomous
	// Data Guard remote regions that are associated with the source database.
	PeerDbIds []string `protobuf:"bytes,43,rep,name=peer_db_ids,json=peerDbIds,proto3" json:"peer_db_ids,omitempty"`
	// Output only. The permission level of the Autonomous Database.
	PermissionLevel AutonomousDatabaseProperties_PermissionLevel `protobuf:"varint,44,opt,name=permission_level,json=permissionLevel,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseProperties_PermissionLevel" json:"permission_level,omitempty"`
	// Output only. The private endpoint for the Autonomous Database.
	PrivateEndpoint string `protobuf:"bytes,45,opt,name=private_endpoint,json=privateEndpoint,proto3" json:"private_endpoint,omitempty"`
	// Output only. The refresh mode of the cloned Autonomous Database.
	RefreshableMode AutonomousDatabaseProperties_RefreshableMode `protobuf:"varint,46,opt,name=refreshable_mode,json=refreshableMode,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseProperties_RefreshableMode" json:"refreshable_mode,omitempty"`
	// Output only. The refresh State of the clone.
	RefreshableState AutonomousDatabaseProperties_RefreshableState `protobuf:"varint,47,opt,name=refreshable_state,json=refreshableState,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseProperties_RefreshableState" json:"refreshable_state,omitempty"`
	// Output only. The Data Guard role of the Autonomous Database.
	Role AutonomousDatabaseProperties_Role `protobuf:"varint,48,opt,name=role,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseProperties_Role" json:"role,omitempty"`
	// Output only. The list and details of the scheduled operations of the
	// Autonomous Database.
	ScheduledOperationDetails []*ScheduledOperationDetails `protobuf:"bytes,64,rep,name=scheduled_operation_details,json=scheduledOperationDetails,proto3" json:"scheduled_operation_details,omitempty"`
	// Output only. The SQL Web Developer URL for the Autonomous Database.
	SqlWebDeveloperUrl string `protobuf:"bytes,50,opt,name=sql_web_developer_url,json=sqlWebDeveloperUrl,proto3" json:"sql_web_developer_url,omitempty"`
	// Output only. The list of available regions that can be used to create a
	// clone for the Autonomous Database.
	SupportedCloneRegions []string `protobuf:"bytes,51,rep,name=supported_clone_regions,json=supportedCloneRegions,proto3" json:"supported_clone_regions,omitempty"`
	// Output only. The storage space used by Autonomous Database, in gigabytes.
	UsedDataStorageSizeTbs int32 `protobuf:"varint,53,opt,name=used_data_storage_size_tbs,json=usedDataStorageSizeTbs,proto3" json:"used_data_storage_size_tbs,omitempty"`
	// Output only. The Oracle Cloud Infrastructure link for the Autonomous
	// Database.
	OciUrl string `protobuf:"bytes,54,opt,name=oci_url,json=ociUrl,proto3" json:"oci_url,omitempty"`
	// Output only. The storage space used by automatic backups of Autonomous
	// Database, in gigabytes.
	TotalAutoBackupStorageSizeGbs float32 `protobuf:"fixed32,59,opt,name=total_auto_backup_storage_size_gbs,json=totalAutoBackupStorageSizeGbs,proto3" json:"total_auto_backup_storage_size_gbs,omitempty"`
	// Output only. The long term backup schedule of the Autonomous Database.
	NextLongTermBackupTime *timestamppb.Timestamp `protobuf:"bytes,60,opt,name=next_long_term_backup_time,json=nextLongTermBackupTime,proto3" json:"next_long_term_backup_time,omitempty"`
	// Output only. The date and time when maintenance will begin.
	MaintenanceBeginTime *timestamppb.Timestamp `protobuf:"bytes,65,opt,name=maintenance_begin_time,json=maintenanceBeginTime,proto3" json:"maintenance_begin_time,omitempty"`
	// Output only. The date and time when maintenance will end.
	MaintenanceEndTime *timestamppb.Timestamp `protobuf:"bytes,66,opt,name=maintenance_end_time,json=maintenanceEndTime,proto3" json:"maintenance_end_time,omitempty"`
}

func (x *AutonomousDatabaseProperties) Reset() {
	*x = AutonomousDatabaseProperties{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutonomousDatabaseProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutonomousDatabaseProperties) ProtoMessage() {}

func (x *AutonomousDatabaseProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutonomousDatabaseProperties.ProtoReflect.Descriptor instead.
func (*AutonomousDatabaseProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{1}
}

func (x *AutonomousDatabaseProperties) GetOcid() string {
	if x != nil {
		return x.Ocid
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetComputeCount() float32 {
	if x != nil {
		return x.ComputeCount
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetCpuCoreCount() int32 {
	if x != nil {
		return x.CpuCoreCount
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetDataStorageSizeTb() int32 {
	if x != nil {
		return x.DataStorageSizeTb
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetDataStorageSizeGb() int32 {
	if x != nil {
		return x.DataStorageSizeGb
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetDbWorkload() DBWorkload {
	if x != nil {
		return x.DbWorkload
	}
	return DBWorkload_DB_WORKLOAD_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetDbEdition() AutonomousDatabaseProperties_DatabaseEdition {
	if x != nil {
		return x.DbEdition
	}
	return AutonomousDatabaseProperties_DATABASE_EDITION_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetCharacterSet() string {
	if x != nil {
		return x.CharacterSet
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetNCharacterSet() string {
	if x != nil {
		return x.NCharacterSet
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetPrivateEndpointIp() string {
	if x != nil {
		return x.PrivateEndpointIp
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetPrivateEndpointLabel() string {
	if x != nil {
		return x.PrivateEndpointLabel
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetDbVersion() string {
	if x != nil {
		return x.DbVersion
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetIsAutoScalingEnabled() bool {
	if x != nil {
		return x.IsAutoScalingEnabled
	}
	return false
}

func (x *AutonomousDatabaseProperties) GetIsStorageAutoScalingEnabled() bool {
	if x != nil {
		return x.IsStorageAutoScalingEnabled
	}
	return false
}

func (x *AutonomousDatabaseProperties) GetLicenseType() AutonomousDatabaseProperties_LicenseType {
	if x != nil {
		return x.LicenseType
	}
	return AutonomousDatabaseProperties_LICENSE_TYPE_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetCustomerContacts() []*CustomerContact {
	if x != nil {
		return x.CustomerContacts
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetSecretId() string {
	if x != nil {
		return x.SecretId
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetVaultId() string {
	if x != nil {
		return x.VaultId
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetMaintenanceScheduleType() AutonomousDatabaseProperties_MaintenanceScheduleType {
	if x != nil {
		return x.MaintenanceScheduleType
	}
	return AutonomousDatabaseProperties_MAINTENANCE_SCHEDULE_TYPE_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetMtlsConnectionRequired() bool {
	if x != nil {
		return x.MtlsConnectionRequired
	}
	return false
}

func (x *AutonomousDatabaseProperties) GetBackupRetentionPeriodDays() int32 {
	if x != nil {
		return x.BackupRetentionPeriodDays
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetActualUsedDataStorageSizeTb() float64 {
	if x != nil {
		return x.ActualUsedDataStorageSizeTb
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetAllocatedStorageSizeTb() float64 {
	if x != nil {
		return x.AllocatedStorageSizeTb
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetApexDetails() *AutonomousDatabaseApex {
	if x != nil {
		return x.ApexDetails
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetArePrimaryAllowlistedIpsUsed() bool {
	if x != nil && x.ArePrimaryAllowlistedIpsUsed != nil {
		return *x.ArePrimaryAllowlistedIpsUsed
	}
	return false
}

func (x *AutonomousDatabaseProperties) GetLifecycleDetails() string {
	if x != nil {
		return x.LifecycleDetails
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetAutonomousContainerDatabaseId() string {
	if x != nil {
		return x.AutonomousContainerDatabaseId
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetAvailableUpgradeVersions() []string {
	if x != nil {
		return x.AvailableUpgradeVersions
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetConnectionStrings() *AutonomousDatabaseConnectionStrings {
	if x != nil {
		return x.ConnectionStrings
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetConnectionUrls() *AutonomousDatabaseConnectionUrls {
	if x != nil {
		return x.ConnectionUrls
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetFailedDataRecoveryDuration() *durationpb.Duration {
	if x != nil {
		return x.FailedDataRecoveryDuration
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetMemoryTableGbs() int32 {
	if x != nil {
		return x.MemoryTableGbs
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetIsLocalDataGuardEnabled() bool {
	if x != nil {
		return x.IsLocalDataGuardEnabled
	}
	return false
}

func (x *AutonomousDatabaseProperties) GetLocalAdgAutoFailoverMaxDataLossLimit() int32 {
	if x != nil {
		return x.LocalAdgAutoFailoverMaxDataLossLimit
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetLocalStandbyDb() *AutonomousDatabaseStandbySummary {
	if x != nil {
		return x.LocalStandbyDb
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetMemoryPerOracleComputeUnitGbs() int32 {
	if x != nil {
		return x.MemoryPerOracleComputeUnitGbs
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetLocalDisasterRecoveryType() AutonomousDatabaseProperties_LocalDisasterRecoveryType {
	if x != nil {
		return x.LocalDisasterRecoveryType
	}
	return AutonomousDatabaseProperties_LOCAL_DISASTER_RECOVERY_TYPE_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetDataSafeState() AutonomousDatabaseProperties_DataSafeState {
	if x != nil {
		return x.DataSafeState
	}
	return AutonomousDatabaseProperties_DATA_SAFE_STATE_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetDatabaseManagementState() AutonomousDatabaseProperties_DatabaseManagementState {
	if x != nil {
		return x.DatabaseManagementState
	}
	return AutonomousDatabaseProperties_DATABASE_MANAGEMENT_STATE_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetOpenMode() AutonomousDatabaseProperties_OpenMode {
	if x != nil {
		return x.OpenMode
	}
	return AutonomousDatabaseProperties_OPEN_MODE_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetOperationsInsightsState() OperationsInsightsState {
	if x != nil {
		return x.OperationsInsightsState
	}
	return OperationsInsightsState_OPERATIONS_INSIGHTS_STATE_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetPeerDbIds() []string {
	if x != nil {
		return x.PeerDbIds
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetPermissionLevel() AutonomousDatabaseProperties_PermissionLevel {
	if x != nil {
		return x.PermissionLevel
	}
	return AutonomousDatabaseProperties_PERMISSION_LEVEL_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetPrivateEndpoint() string {
	if x != nil {
		return x.PrivateEndpoint
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetRefreshableMode() AutonomousDatabaseProperties_RefreshableMode {
	if x != nil {
		return x.RefreshableMode
	}
	return AutonomousDatabaseProperties_REFRESHABLE_MODE_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetRefreshableState() AutonomousDatabaseProperties_RefreshableState {
	if x != nil {
		return x.RefreshableState
	}
	return AutonomousDatabaseProperties_REFRESHABLE_STATE_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetRole() AutonomousDatabaseProperties_Role {
	if x != nil {
		return x.Role
	}
	return AutonomousDatabaseProperties_ROLE_UNSPECIFIED
}

func (x *AutonomousDatabaseProperties) GetScheduledOperationDetails() []*ScheduledOperationDetails {
	if x != nil {
		return x.ScheduledOperationDetails
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetSqlWebDeveloperUrl() string {
	if x != nil {
		return x.SqlWebDeveloperUrl
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetSupportedCloneRegions() []string {
	if x != nil {
		return x.SupportedCloneRegions
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetUsedDataStorageSizeTbs() int32 {
	if x != nil {
		return x.UsedDataStorageSizeTbs
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetOciUrl() string {
	if x != nil {
		return x.OciUrl
	}
	return ""
}

func (x *AutonomousDatabaseProperties) GetTotalAutoBackupStorageSizeGbs() float32 {
	if x != nil {
		return x.TotalAutoBackupStorageSizeGbs
	}
	return 0
}

func (x *AutonomousDatabaseProperties) GetNextLongTermBackupTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextLongTermBackupTime
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetMaintenanceBeginTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MaintenanceBeginTime
	}
	return nil
}

func (x *AutonomousDatabaseProperties) GetMaintenanceEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MaintenanceEndTime
	}
	return nil
}

// Oracle APEX Application Development.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseApex
type AutonomousDatabaseApex struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The Oracle APEX Application Development version.
	ApexVersion string `protobuf:"bytes,1,opt,name=apex_version,json=apexVersion,proto3" json:"apex_version,omitempty"`
	// Output only. The Oracle REST Data Services (ORDS) version.
	OrdsVersion string `protobuf:"bytes,2,opt,name=ords_version,json=ordsVersion,proto3" json:"ords_version,omitempty"`
}

func (x *AutonomousDatabaseApex) Reset() {
	*x = AutonomousDatabaseApex{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutonomousDatabaseApex) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutonomousDatabaseApex) ProtoMessage() {}

func (x *AutonomousDatabaseApex) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutonomousDatabaseApex.ProtoReflect.Descriptor instead.
func (*AutonomousDatabaseApex) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{2}
}

func (x *AutonomousDatabaseApex) GetApexVersion() string {
	if x != nil {
		return x.ApexVersion
	}
	return ""
}

func (x *AutonomousDatabaseApex) GetOrdsVersion() string {
	if x != nil {
		return x.OrdsVersion
	}
	return ""
}

// The connection string used to connect to the Autonomous Database.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseConnectionStrings
type AutonomousDatabaseConnectionStrings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Returns all connection strings that can be used to connect to
	// the Autonomous Database.
	AllConnectionStrings *AllConnectionStrings `protobuf:"bytes,1,opt,name=all_connection_strings,json=allConnectionStrings,proto3" json:"all_connection_strings,omitempty"`
	// Output only. The database service provides the least level of resources to
	// each SQL statement, but supports the most number of concurrent SQL
	// statements.
	Dedicated string `protobuf:"bytes,2,opt,name=dedicated,proto3" json:"dedicated,omitempty"`
	// Output only. The database service provides the highest level of resources
	// to each SQL statement.
	High string `protobuf:"bytes,3,opt,name=high,proto3" json:"high,omitempty"`
	// Output only. The database service provides the least level of resources to
	// each SQL statement.
	Low string `protobuf:"bytes,4,opt,name=low,proto3" json:"low,omitempty"`
	// Output only. The database service provides a lower level of resources to
	// each SQL statement.
	Medium string `protobuf:"bytes,5,opt,name=medium,proto3" json:"medium,omitempty"`
	// Output only. A list of connection string profiles to allow clients to
	// group, filter, and select values based on the structured metadata.
	Profiles []*DatabaseConnectionStringProfile `protobuf:"bytes,6,rep,name=profiles,proto3" json:"profiles,omitempty"`
}

func (x *AutonomousDatabaseConnectionStrings) Reset() {
	*x = AutonomousDatabaseConnectionStrings{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutonomousDatabaseConnectionStrings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutonomousDatabaseConnectionStrings) ProtoMessage() {}

func (x *AutonomousDatabaseConnectionStrings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutonomousDatabaseConnectionStrings.ProtoReflect.Descriptor instead.
func (*AutonomousDatabaseConnectionStrings) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{3}
}

func (x *AutonomousDatabaseConnectionStrings) GetAllConnectionStrings() *AllConnectionStrings {
	if x != nil {
		return x.AllConnectionStrings
	}
	return nil
}

func (x *AutonomousDatabaseConnectionStrings) GetDedicated() string {
	if x != nil {
		return x.Dedicated
	}
	return ""
}

func (x *AutonomousDatabaseConnectionStrings) GetHigh() string {
	if x != nil {
		return x.High
	}
	return ""
}

func (x *AutonomousDatabaseConnectionStrings) GetLow() string {
	if x != nil {
		return x.Low
	}
	return ""
}

func (x *AutonomousDatabaseConnectionStrings) GetMedium() string {
	if x != nil {
		return x.Medium
	}
	return ""
}

func (x *AutonomousDatabaseConnectionStrings) GetProfiles() []*DatabaseConnectionStringProfile {
	if x != nil {
		return x.Profiles
	}
	return nil
}

// The connection string profile to allow clients to group.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/DatabaseConnectionStringProfile
type DatabaseConnectionStringProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The current consumer group being used by the connection.
	ConsumerGroup DatabaseConnectionStringProfile_ConsumerGroup `protobuf:"varint,1,opt,name=consumer_group,json=consumerGroup,proto3,enum=google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile_ConsumerGroup" json:"consumer_group,omitempty"`
	// Output only. The display name for the database connection.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The host name format being currently used in connection
	// string.
	HostFormat DatabaseConnectionStringProfile_HostFormat `protobuf:"varint,3,opt,name=host_format,json=hostFormat,proto3,enum=google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile_HostFormat" json:"host_format,omitempty"`
	// Output only. This field indicates if the connection string is regional and
	// is only applicable for cross-region Data Guard.
	IsRegional bool `protobuf:"varint,4,opt,name=is_regional,json=isRegional,proto3" json:"is_regional,omitempty"`
	// Output only. The protocol being used by the connection.
	Protocol DatabaseConnectionStringProfile_Protocol `protobuf:"varint,5,opt,name=protocol,proto3,enum=google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile_Protocol" json:"protocol,omitempty"`
	// Output only. The current session mode of the connection.
	SessionMode DatabaseConnectionStringProfile_SessionMode `protobuf:"varint,6,opt,name=session_mode,json=sessionMode,proto3,enum=google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile_SessionMode" json:"session_mode,omitempty"`
	// Output only. The syntax of the connection string.
	SyntaxFormat DatabaseConnectionStringProfile_SyntaxFormat `protobuf:"varint,7,opt,name=syntax_format,json=syntaxFormat,proto3,enum=google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile_SyntaxFormat" json:"syntax_format,omitempty"`
	// Output only. This field indicates the TLS authentication type of the
	// connection.
	TlsAuthentication DatabaseConnectionStringProfile_TLSAuthentication `protobuf:"varint,8,opt,name=tls_authentication,json=tlsAuthentication,proto3,enum=google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile_TLSAuthentication" json:"tls_authentication,omitempty"`
	// Output only. The value of the connection string.
	Value string `protobuf:"bytes,9,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DatabaseConnectionStringProfile) Reset() {
	*x = DatabaseConnectionStringProfile{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatabaseConnectionStringProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseConnectionStringProfile) ProtoMessage() {}

func (x *DatabaseConnectionStringProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseConnectionStringProfile.ProtoReflect.Descriptor instead.
func (*DatabaseConnectionStringProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{4}
}

func (x *DatabaseConnectionStringProfile) GetConsumerGroup() DatabaseConnectionStringProfile_ConsumerGroup {
	if x != nil {
		return x.ConsumerGroup
	}
	return DatabaseConnectionStringProfile_CONSUMER_GROUP_UNSPECIFIED
}

func (x *DatabaseConnectionStringProfile) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *DatabaseConnectionStringProfile) GetHostFormat() DatabaseConnectionStringProfile_HostFormat {
	if x != nil {
		return x.HostFormat
	}
	return DatabaseConnectionStringProfile_HOST_FORMAT_UNSPECIFIED
}

func (x *DatabaseConnectionStringProfile) GetIsRegional() bool {
	if x != nil {
		return x.IsRegional
	}
	return false
}

func (x *DatabaseConnectionStringProfile) GetProtocol() DatabaseConnectionStringProfile_Protocol {
	if x != nil {
		return x.Protocol
	}
	return DatabaseConnectionStringProfile_PROTOCOL_UNSPECIFIED
}

func (x *DatabaseConnectionStringProfile) GetSessionMode() DatabaseConnectionStringProfile_SessionMode {
	if x != nil {
		return x.SessionMode
	}
	return DatabaseConnectionStringProfile_SESSION_MODE_UNSPECIFIED
}

func (x *DatabaseConnectionStringProfile) GetSyntaxFormat() DatabaseConnectionStringProfile_SyntaxFormat {
	if x != nil {
		return x.SyntaxFormat
	}
	return DatabaseConnectionStringProfile_SYNTAX_FORMAT_UNSPECIFIED
}

func (x *DatabaseConnectionStringProfile) GetTlsAuthentication() DatabaseConnectionStringProfile_TLSAuthentication {
	if x != nil {
		return x.TlsAuthentication
	}
	return DatabaseConnectionStringProfile_TLS_AUTHENTICATION_UNSPECIFIED
}

func (x *DatabaseConnectionStringProfile) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A list of all connection strings that can be used to connect to the
// Autonomous Database.
type AllConnectionStrings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The database service provides the highest level of resources
	// to each SQL statement.
	High string `protobuf:"bytes,1,opt,name=high,proto3" json:"high,omitempty"`
	// Output only. The database service provides the least level of resources to
	// each SQL statement.
	Low string `protobuf:"bytes,2,opt,name=low,proto3" json:"low,omitempty"`
	// Output only. The database service provides a lower level of resources to
	// each SQL statement.
	Medium string `protobuf:"bytes,3,opt,name=medium,proto3" json:"medium,omitempty"`
}

func (x *AllConnectionStrings) Reset() {
	*x = AllConnectionStrings{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllConnectionStrings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllConnectionStrings) ProtoMessage() {}

func (x *AllConnectionStrings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllConnectionStrings.ProtoReflect.Descriptor instead.
func (*AllConnectionStrings) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{5}
}

func (x *AllConnectionStrings) GetHigh() string {
	if x != nil {
		return x.High
	}
	return ""
}

func (x *AllConnectionStrings) GetLow() string {
	if x != nil {
		return x.Low
	}
	return ""
}

func (x *AllConnectionStrings) GetMedium() string {
	if x != nil {
		return x.Medium
	}
	return ""
}

// The URLs for accessing Oracle Application Express (APEX) and SQL Developer
// Web with a browser from a Compute instance.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseConnectionUrls
type AutonomousDatabaseConnectionUrls struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Oracle Application Express (APEX) URL.
	ApexUri string `protobuf:"bytes,1,opt,name=apex_uri,json=apexUri,proto3" json:"apex_uri,omitempty"`
	// Output only. The URL of the Database Transforms for the Autonomous
	// Database.
	DatabaseTransformsUri string `protobuf:"bytes,2,opt,name=database_transforms_uri,json=databaseTransformsUri,proto3" json:"database_transforms_uri,omitempty"`
	// Output only. The URL of the Graph Studio for the Autonomous Database.
	GraphStudioUri string `protobuf:"bytes,3,opt,name=graph_studio_uri,json=graphStudioUri,proto3" json:"graph_studio_uri,omitempty"`
	// Output only. The URL of the Oracle Machine Learning (OML) Notebook for the
	// Autonomous Database.
	MachineLearningNotebookUri string `protobuf:"bytes,4,opt,name=machine_learning_notebook_uri,json=machineLearningNotebookUri,proto3" json:"machine_learning_notebook_uri,omitempty"`
	// Output only. The URL of Machine Learning user management the Autonomous
	// Database.
	MachineLearningUserManagementUri string `protobuf:"bytes,5,opt,name=machine_learning_user_management_uri,json=machineLearningUserManagementUri,proto3" json:"machine_learning_user_management_uri,omitempty"`
	// Output only. The URL of the MongoDB API for the Autonomous Database.
	MongoDbUri string `protobuf:"bytes,6,opt,name=mongo_db_uri,json=mongoDbUri,proto3" json:"mongo_db_uri,omitempty"`
	// Output only. The Oracle REST Data Services (ORDS) URL of the Web Access for
	// the Autonomous Database.
	OrdsUri string `protobuf:"bytes,7,opt,name=ords_uri,json=ordsUri,proto3" json:"ords_uri,omitempty"`
	// Output only. The URL of the Oracle SQL Developer Web for the Autonomous
	// Database.
	SqlDevWebUri string `protobuf:"bytes,8,opt,name=sql_dev_web_uri,json=sqlDevWebUri,proto3" json:"sql_dev_web_uri,omitempty"`
}

func (x *AutonomousDatabaseConnectionUrls) Reset() {
	*x = AutonomousDatabaseConnectionUrls{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutonomousDatabaseConnectionUrls) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutonomousDatabaseConnectionUrls) ProtoMessage() {}

func (x *AutonomousDatabaseConnectionUrls) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutonomousDatabaseConnectionUrls.ProtoReflect.Descriptor instead.
func (*AutonomousDatabaseConnectionUrls) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{6}
}

func (x *AutonomousDatabaseConnectionUrls) GetApexUri() string {
	if x != nil {
		return x.ApexUri
	}
	return ""
}

func (x *AutonomousDatabaseConnectionUrls) GetDatabaseTransformsUri() string {
	if x != nil {
		return x.DatabaseTransformsUri
	}
	return ""
}

func (x *AutonomousDatabaseConnectionUrls) GetGraphStudioUri() string {
	if x != nil {
		return x.GraphStudioUri
	}
	return ""
}

func (x *AutonomousDatabaseConnectionUrls) GetMachineLearningNotebookUri() string {
	if x != nil {
		return x.MachineLearningNotebookUri
	}
	return ""
}

func (x *AutonomousDatabaseConnectionUrls) GetMachineLearningUserManagementUri() string {
	if x != nil {
		return x.MachineLearningUserManagementUri
	}
	return ""
}

func (x *AutonomousDatabaseConnectionUrls) GetMongoDbUri() string {
	if x != nil {
		return x.MongoDbUri
	}
	return ""
}

func (x *AutonomousDatabaseConnectionUrls) GetOrdsUri() string {
	if x != nil {
		return x.OrdsUri
	}
	return ""
}

func (x *AutonomousDatabaseConnectionUrls) GetSqlDevWebUri() string {
	if x != nil {
		return x.SqlDevWebUri
	}
	return ""
}

// Autonomous Data Guard standby database details.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/AutonomousDatabaseStandbySummary
type AutonomousDatabaseStandbySummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The amount of time, in seconds, that the data of the standby
	// database lags in comparison to the data of the primary database.
	LagTimeDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=lag_time_duration,json=lagTimeDuration,proto3" json:"lag_time_duration,omitempty"`
	// Output only. The additional details about the current lifecycle state of
	// the Autonomous Database.
	LifecycleDetails string `protobuf:"bytes,2,opt,name=lifecycle_details,json=lifecycleDetails,proto3" json:"lifecycle_details,omitempty"`
	// Output only. The current lifecycle state of the Autonomous Database.
	State State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.oracledatabase.v1.State" json:"state,omitempty"`
	// Output only. The date and time the Autonomous Data Guard role was switched
	// for the standby Autonomous Database.
	DataGuardRoleChangedTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=data_guard_role_changed_time,json=dataGuardRoleChangedTime,proto3" json:"data_guard_role_changed_time,omitempty"`
	// Output only. The date and time the Disaster Recovery role was switched for
	// the standby Autonomous Database.
	DisasterRecoveryRoleChangedTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=disaster_recovery_role_changed_time,json=disasterRecoveryRoleChangedTime,proto3" json:"disaster_recovery_role_changed_time,omitempty"`
}

func (x *AutonomousDatabaseStandbySummary) Reset() {
	*x = AutonomousDatabaseStandbySummary{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutonomousDatabaseStandbySummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutonomousDatabaseStandbySummary) ProtoMessage() {}

func (x *AutonomousDatabaseStandbySummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutonomousDatabaseStandbySummary.ProtoReflect.Descriptor instead.
func (*AutonomousDatabaseStandbySummary) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{7}
}

func (x *AutonomousDatabaseStandbySummary) GetLagTimeDuration() *durationpb.Duration {
	if x != nil {
		return x.LagTimeDuration
	}
	return nil
}

func (x *AutonomousDatabaseStandbySummary) GetLifecycleDetails() string {
	if x != nil {
		return x.LifecycleDetails
	}
	return ""
}

func (x *AutonomousDatabaseStandbySummary) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *AutonomousDatabaseStandbySummary) GetDataGuardRoleChangedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DataGuardRoleChangedTime
	}
	return nil
}

func (x *AutonomousDatabaseStandbySummary) GetDisasterRecoveryRoleChangedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DisasterRecoveryRoleChangedTime
	}
	return nil
}

// Details of scheduled operation.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/datatypes/ScheduledOperationDetails
type ScheduledOperationDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Day of week.
	DayOfWeek dayofweek.DayOfWeek `protobuf:"varint,1,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.type.DayOfWeek" json:"day_of_week,omitempty"`
	// Output only. Auto start time.
	StartTime *timeofday.TimeOfDay `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Auto stop time.
	StopTime *timeofday.TimeOfDay `protobuf:"bytes,5,opt,name=stop_time,json=stopTime,proto3" json:"stop_time,omitempty"`
}

func (x *ScheduledOperationDetails) Reset() {
	*x = ScheduledOperationDetails{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScheduledOperationDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScheduledOperationDetails) ProtoMessage() {}

func (x *ScheduledOperationDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScheduledOperationDetails.ProtoReflect.Descriptor instead.
func (*ScheduledOperationDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP(), []int{8}
}

func (x *ScheduledOperationDetails) GetDayOfWeek() dayofweek.DayOfWeek {
	if x != nil {
		return x.DayOfWeek
	}
	return dayofweek.DayOfWeek(0)
}

func (x *ScheduledOperationDetails) GetStartTime() *timeofday.TimeOfDay {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ScheduledOperationDetails) GetStopTime() *timeofday.TimeOfDay {
	if x != nil {
		return x.StopTime
	}
	return nil
}

var File_google_cloud_oracledatabase_v1_autonomous_database_proto protoreflect.FileDescriptor

var file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x64, 0x61, 0x79, 0x6f, 0x66, 0x77, 0x65, 0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x9b,
	0x06, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f,
	0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12,
	0x61, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x5b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x17, 0x0a, 0x04, 0x63, 0x69, 0x64, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x63, 0x69, 0x64, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xb2, 0x01, 0xea, 0x41, 0xae, 0x01, 0x0a, 0x30,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75,
	0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x7b, 0x61,
	0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x7d, 0x2a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x32, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x22, 0x8c, 0x2d, 0x0a,
	0x1c, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x17, 0x0a,
	0x04, 0x6f, 0x63, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6f, 0x63, 0x69, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x29, 0x0a, 0x0e, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63,
	0x70, 0x75, 0x43, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x14, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x74, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x54,
	0x62, 0x12, 0x34, 0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x3f, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x50, 0x0a, 0x0b, 0x64, 0x62, 0x5f, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x42,
	0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64,
	0x62, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x70, 0x0a, 0x0a, 0x64, 0x62, 0x5f,
	0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x64, 0x62, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x63,
	0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
	0x65, 0x72, 0x53, 0x65, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61,
	0x63, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53,
	0x65, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x70, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x70, 0x12, 0x39, 0x0a, 0x16, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x12, 0x22, 0x0a, 0x0a, 0x64, 0x62, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x64, 0x62, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x17, 0x69, 0x73, 0x5f, 0x61, 0x75, 0x74,
	0x6f, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x69, 0x73,
	0x41, 0x75, 0x74, 0x6f, 0x53, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x49, 0x0a, 0x1f, 0x69, 0x73, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x1b, 0x69, 0x73, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x53,
	0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x70, 0x0a,
	0x0c, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2e, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x61, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x76, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x61, 0x75,
	0x6c, 0x74, 0x49, 0x64, 0x12, 0x95, 0x01, 0x0a, 0x19, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x17, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3d, 0x0a, 0x18,
	0x6d, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x22, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x16, 0x6d, 0x74, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x44, 0x0a, 0x1c, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x39, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x44, 0x61, 0x79,
	0x73, 0x12, 0x4a, 0x0a, 0x20, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x64,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x74, 0x62, 0x18, 0x15, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x1b, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x54, 0x62, 0x12, 0x3e, 0x0a,
	0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x74, 0x62, 0x18, 0x16, 0x20, 0x01, 0x28, 0x01,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x54, 0x62, 0x12, 0x5e, 0x0a,
	0x0c, 0x61, 0x70, 0x65, 0x78, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x17, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x41, 0x70, 0x65, 0x78, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x61, 0x70, 0x65, 0x78, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x50, 0x0a,
	0x20, 0x61, 0x72, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x73, 0x5f, 0x75, 0x73, 0x65,
	0x64, 0x18, 0x18, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1c,
	0x61, 0x72, 0x65, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x6c,
	0x69, 0x73, 0x74, 0x65, 0x64, 0x49, 0x70, 0x73, 0x55, 0x73, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x30, 0x0a, 0x11, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x4c, 0x0a, 0x20, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x1d, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49,
	0x64, 0x12, 0x41, 0x0a, 0x1a, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x75,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x1c, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x61, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x77, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x6e, 0x0a,
	0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x6c, 0x73,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f,
	0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x55, 0x72, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x61, 0x0a,
	0x1d, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1f,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x67, 0x62, 0x73, 0x18, 0x20, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x47, 0x62, 0x73, 0x12,
	0x41, 0x0a, 0x1b, 0x69, 0x73, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x67, 0x75, 0x61, 0x72, 0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x21,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x69, 0x73, 0x4c, 0x6f, 0x63,
	0x61, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x47, 0x75, 0x61, 0x72, 0x64, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x12, 0x5e, 0x0a, 0x2b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x67, 0x5f,
	0x61, 0x75, 0x74, 0x6f, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6d, 0x61,
	0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x6f, 0x73, 0x73, 0x5f, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x18, 0x23, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x24, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x41, 0x64, 0x67, 0x41, 0x75, 0x74, 0x6f, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76,
	0x65, 0x72, 0x4d, 0x61, 0x78, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x6f, 0x73, 0x73, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x12, 0x6f, 0x0a, 0x10, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x6e,
	0x64, 0x62, 0x79, 0x5f, 0x64, 0x62, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75,
	0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x53, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x62,
	0x79, 0x44, 0x62, 0x12, 0x4e, 0x0a, 0x22, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x70, 0x65,
	0x72, 0x5f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x5f, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x67, 0x62, 0x73, 0x18, 0x25, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x1d, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x50, 0x65, 0x72, 0x4f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x55, 0x6e, 0x69, 0x74,
	0x47, 0x62, 0x73, 0x12, 0x9c, 0x01, 0x0a, 0x1c, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x64, 0x69,
	0x73, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x69,
	0x73, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x69,
	0x73, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x77, 0x0a, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x61, 0x66, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x61,
	0x66, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x61, 0x66, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x95, 0x01, 0x0a, 0x19,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x67, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x29, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f,
	0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x78, 0x0a, 0x19,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x49, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0b, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x64,
	0x62, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x2b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x09, 0x70, 0x65, 0x65, 0x72, 0x44, 0x62, 0x49, 0x64, 0x73, 0x12, 0x7c, 0x0a, 0x10, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18,
	0x2c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x2d, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x7c, 0x0a, 0x10, 0x72, 0x65, 0x66,
	0x72, 0x65, 0x73, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x2e, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x2e, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x7f, 0x0a, 0x11, 0x72, 0x65, 0x66, 0x72, 0x65,
	0x73, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x2f, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2e, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5a, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65,
	0x18, 0x30, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f,
	0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x72, 0x6f, 0x6c, 0x65, 0x12, 0x7e, 0x0a, 0x1b, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x40, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x36, 0x0a, 0x15, 0x73, 0x71, 0x6c, 0x5f, 0x77, 0x65, 0x62, 0x5f,
	0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x32, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x73, 0x71, 0x6c, 0x57, 0x65, 0x62,
	0x44, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x55, 0x72, 0x6c, 0x12, 0x3b, 0x0a, 0x17,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x33, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x6c, 0x6f,
	0x6e, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x0a, 0x1a, 0x75, 0x73, 0x65,
	0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x74, 0x62, 0x73, 0x18, 0x35, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x16, 0x75, 0x73, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x54, 0x62, 0x73, 0x12, 0x1c, 0x0a, 0x07, 0x6f, 0x63,
	0x69, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x36, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x6f, 0x63, 0x69, 0x55, 0x72, 0x6c, 0x12, 0x4e, 0x0a, 0x22, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x73, 0x18, 0x3b,
	0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1d, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x41, 0x75, 0x74, 0x6f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x73, 0x12, 0x5b, 0x0a, 0x1a, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x6e,
	0x65, 0x78, 0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x54, 0x65, 0x72, 0x6d, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x16, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x41, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x42, 0x65, 0x67, 0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x14,
	0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x42, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x6d, 0x61, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22,
	0x61, 0x0a, 0x0f, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45,
	0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44,
	0x5f, 0x45, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x45, 0x4e,
	0x54, 0x45, 0x52, 0x50, 0x52, 0x49, 0x53, 0x45, 0x5f, 0x45, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x02, 0x22, 0x5d, 0x0a, 0x0b, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x14, 0x0a, 0x10, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55,
	0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x59,
	0x4f, 0x55, 0x52, 0x5f, 0x4f, 0x57, 0x4e, 0x5f, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x10,
	0x02, 0x22, 0x5c, 0x0a, 0x17, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x29, 0x0a, 0x25,
	0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x43, 0x48, 0x45,
	0x44, 0x55, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x41, 0x52, 0x4c, 0x59,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x47, 0x55, 0x4c, 0x41, 0x52, 0x10, 0x02, 0x22,
	0x64, 0x0a, 0x19, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x69, 0x73, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x28,
	0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x52,
	0x45, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x44,
	0x47, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x42, 0x41,
	0x53, 0x45, 0x44, 0x10, 0x02, 0x22, 0x84, 0x01, 0x0a, 0x0d, 0x44, 0x61, 0x74, 0x61, 0x53, 0x61,
	0x66, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x41, 0x54, 0x41, 0x5f,
	0x53, 0x41, 0x46, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x47, 0x49,
	0x53, 0x54, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x47,
	0x49, 0x53, 0x54, 0x45, 0x52, 0x45, 0x44, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x45, 0x52,
	0x45, 0x47, 0x49, 0x53, 0x54, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e,
	0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x45, 0x52, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x22, 0xaa, 0x01, 0x0a,
	0x17, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x29, 0x0a, 0x25, 0x44, 0x41, 0x54, 0x41,
	0x42, 0x41, 0x53, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d,
	0x0a, 0x09, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0f, 0x0a,
	0x0b, 0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x13,
	0x0a, 0x0f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x49, 0x4e,
	0x47, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f, 0x44, 0x49,
	0x53, 0x41, 0x42, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x22, 0x44, 0x0a, 0x08, 0x4f, 0x70, 0x65,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x50, 0x45, 0x4e, 0x5f, 0x4d, 0x4f,
	0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x02, 0x22,
	0x55, 0x0a, 0x0f, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x12, 0x20, 0x0a, 0x1c, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x4e, 0x52, 0x45, 0x53, 0x54, 0x52, 0x49,
	0x43, 0x54, 0x45, 0x44, 0x10, 0x02, 0x22, 0x4e, 0x0a, 0x0f, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x46,
	0x52, 0x45, 0x53, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41,
	0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x43, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41,
	0x4e, 0x55, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x59, 0x0a, 0x10, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x45,
	0x46, 0x52, 0x45, 0x53, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a,
	0x0a, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53, 0x48, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x12, 0x0a,
	0x0e, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x46, 0x52, 0x45, 0x53, 0x48, 0x49, 0x4e, 0x47, 0x10,
	0x02, 0x22, 0x73, 0x0a, 0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x4c,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x53, 0x54, 0x41, 0x4e, 0x44, 0x42, 0x59, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x42, 0x59, 0x10, 0x03, 0x12,
	0x0f, 0x0a, 0x0b, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x43, 0x4f, 0x50, 0x59, 0x10, 0x04,
	0x12, 0x14, 0x0a, 0x10, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x5f, 0x53, 0x54, 0x41,
	0x4e, 0x44, 0x42, 0x59, 0x10, 0x05, 0x42, 0x23, 0x0a, 0x21, 0x5f, 0x61, 0x72, 0x65, 0x5f, 0x70,
	0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x6c, 0x69, 0x73, 0x74,
	0x65, 0x64, 0x5f, 0x69, 0x70, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x22, 0x68, 0x0a, 0x16, 0x41,
	0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x41, 0x70, 0x65, 0x78, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x70, 0x65, 0x78, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x61, 0x70, 0x65, 0x78, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a,
	0x0c, 0x6f, 0x72, 0x64, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6f, 0x72, 0x64, 0x73, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xe8, 0x02, 0x0a, 0x23, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x6f, 0x0a,
	0x16, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x21,
	0x0a, 0x09, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x12, 0x17, 0x0a, 0x04, 0x68, 0x69, 0x67, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x68, 0x69, 0x67, 0x68, 0x12, 0x15, 0x0a, 0x03, 0x6c, 0x6f,
	0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x6c, 0x6f,
	0x77, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x12, 0x60,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x22, 0xa6, 0x0a, 0x0a, 0x1f, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x79, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x70, 0x0a, 0x0b, 0x68, 0x6f, 0x73, 0x74, 0x5f,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x48, 0x6f,
	0x73, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x68,
	0x6f, 0x73, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x73, 0x5f,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x69, 0x73, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x12,
	0x69, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x73, 0x0a, 0x0c, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x76, 0x0a, 0x0d, 0x73, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x53, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x79, 0x6e, 0x74, 0x61,
	0x78, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x85, 0x01, 0x0a, 0x12, 0x74, 0x6c, 0x73, 0x5f,
	0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x54, 0x4c, 0x53, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x74, 0x6c,
	0x73, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x64, 0x0a, 0x0d, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1e, 0x0a, 0x1a, 0x43,
	0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x52, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x48,
	0x49, 0x47, 0x48, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10,
	0x02, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x03, 0x12, 0x06, 0x0a, 0x02, 0x54, 0x50,
	0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x50, 0x55, 0x52, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x05,
	0x22, 0x3b, 0x0a, 0x0a, 0x48, 0x6f, 0x73, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1b,
	0x0a, 0x17, 0x48, 0x4f, 0x53, 0x54, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46,
	0x51, 0x44, 0x4e, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x49, 0x50, 0x10, 0x02, 0x22, 0x37, 0x0a,
	0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x52, 0x4f,
	0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x43, 0x50, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x54, 0x43, 0x50, 0x53, 0x10, 0x02, 0x22, 0x45, 0x0a, 0x0b, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x10, 0x02, 0x22, 0x59, 0x0a,
	0x0c, 0x53, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1d, 0x0a,
	0x19, 0x53, 0x59, 0x4e, 0x54, 0x41, 0x58, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x4c, 0x4f, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x5a, 0x43, 0x4f, 0x4e, 0x4e,
	0x45, 0x43, 0x54, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x45, 0x5a, 0x43, 0x4f, 0x4e, 0x4e, 0x45,
	0x43, 0x54, 0x50, 0x4c, 0x55, 0x53, 0x10, 0x03, 0x22, 0x4f, 0x0a, 0x11, 0x54, 0x4c, 0x53, 0x41,
	0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a,
	0x1e, 0x54, 0x4c, 0x53, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x45, 0x4e, 0x54, 0x49, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x4d, 0x55, 0x54, 0x55, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x63, 0x0a, 0x14, 0x41, 0x6c, 0x6c,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x17, 0x0a, 0x04, 0x68, 0x69, 0x67, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x68, 0x69, 0x67, 0x68, 0x12, 0x15, 0x0a, 0x03, 0x6c, 0x6f,
	0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x6c, 0x6f,
	0x77, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x22, 0xbe,
	0x03, 0x0a, 0x20, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x55,
	0x72, 0x6c, 0x73, 0x12, 0x1e, 0x0a, 0x08, 0x61, 0x70, 0x65, 0x78, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61, 0x70, 0x65, 0x78,
	0x55, 0x72, 0x69, 0x12, 0x3b, 0x0a, 0x17, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x55, 0x72, 0x69,
	0x12, 0x2d, 0x0a, 0x10, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x73, 0x74, 0x75, 0x64, 0x69, 0x6f,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x53, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x55, 0x72, 0x69, 0x12,
	0x46, 0x0a, 0x1d, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x6c, 0x65, 0x61, 0x72, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x6d, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x65, 0x4c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x53, 0x0a, 0x24, 0x6d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x5f, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x20, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x4c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x55, 0x73, 0x65, 0x72, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x25, 0x0a, 0x0c,
	0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x5f, 0x64, 0x62, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x67, 0x6f, 0x44, 0x62,
	0x55, 0x72, 0x69, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x73,
	0x55, 0x72, 0x69, 0x12, 0x2a, 0x0a, 0x0f, 0x73, 0x71, 0x6c, 0x5f, 0x64, 0x65, 0x76, 0x5f, 0x77,
	0x65, 0x62, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x73, 0x71, 0x6c, 0x44, 0x65, 0x76, 0x57, 0x65, 0x62, 0x55, 0x72, 0x69, 0x22,
	0xb2, 0x03, 0x0a, 0x20, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x62, 0x79, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x12, 0x4a, 0x0a, 0x11, 0x6c, 0x61, 0x67, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0f, 0x6c, 0x61, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x30, 0x0a, 0x11, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x10, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x5f, 0x0a, 0x1c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x67, 0x75, 0x61,
	0x72, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x64, 0x61, 0x74,
	0x61, 0x47, 0x75, 0x61, 0x72, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6d, 0x0a, 0x23, 0x64, 0x69, 0x73, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x1f, 0x64, 0x69, 0x73, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x52, 0x6f, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0xce, 0x01, 0x0a, 0x19, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x64, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x12,
	0x3a, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x09, 0x73,
	0x74, 0x6f, 0x70, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x74, 0x6f,
	0x70, 0x54, 0x69, 0x6d, 0x65, 0x2a, 0x42, 0x0a, 0x0c, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x10, 0x02, 0x2a, 0xab, 0x03, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52,
	0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x53,
	0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f,
	0x50, 0x50, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41,
	0x54, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c,
	0x41, 0x42, 0x4c, 0x45, 0x10, 0x08, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52,
	0x45, 0x5f, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x09, 0x12,
	0x12, 0x0a, 0x0e, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x0a, 0x12, 0x16, 0x0a, 0x12, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x49, 0x4e,
	0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x0b, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x43, 0x41, 0x4c, 0x45, 0x5f, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53,
	0x10, 0x0c, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x5f,
	0x4e, 0x45, 0x45, 0x44, 0x53, 0x5f, 0x41, 0x54, 0x54, 0x45, 0x4e, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x0d, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0e, 0x12,
	0x1b, 0x0a, 0x17, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x49,
	0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x0f, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x10, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x45, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x11, 0x12, 0x1b, 0x0a, 0x17,
	0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x5f, 0x49, 0x4e, 0x5f, 0x50,
	0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x12, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x50, 0x47,
	0x52, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x13, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x41, 0x43,
	0x43, 0x45, 0x53, 0x53, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x14, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54,
	0x41, 0x4e, 0x44, 0x42, 0x59, 0x10, 0x15, 0x2a, 0xaa, 0x01, 0x0a, 0x17, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x29, 0x0a, 0x25, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x53, 0x5f, 0x49, 0x4e, 0x53, 0x49, 0x47, 0x48, 0x54, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x54, 0x5f,
	0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x14,
	0x0a, 0x10, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x49,
	0x4e, 0x47, 0x10, 0x06, 0x2a, 0x4e, 0x0a, 0x0a, 0x44, 0x42, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x42, 0x5f, 0x57, 0x4f, 0x52, 0x4b, 0x4c, 0x4f, 0x41,
	0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x08, 0x0a, 0x04, 0x4f, 0x4c, 0x54, 0x50, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x44, 0x57, 0x10,
	0x02, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4a, 0x44, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x41, 0x50,
	0x45, 0x58, 0x10, 0x04, 0x42, 0xf1, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x17, 0x41, 0x75, 0x74,
	0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70,
	0x62, 0x3b, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x70, 0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescOnce sync.Once
	file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescData = file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDesc
)

func file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescGZIP() []byte {
	file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescOnce.Do(func() {
		file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescData)
	})
	return file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDescData
}

var file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes = make([]protoimpl.EnumInfo, 21)
var file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_oracledatabase_v1_autonomous_database_proto_goTypes = []any{
	(GenerateType)(0),            // 0: google.cloud.oracledatabase.v1.GenerateType
	(State)(0),                   // 1: google.cloud.oracledatabase.v1.State
	(OperationsInsightsState)(0), // 2: google.cloud.oracledatabase.v1.OperationsInsightsState
	(DBWorkload)(0),              // 3: google.cloud.oracledatabase.v1.DBWorkload
	(AutonomousDatabaseProperties_DatabaseEdition)(0),           // 4: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DatabaseEdition
	(AutonomousDatabaseProperties_LicenseType)(0),               // 5: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.LicenseType
	(AutonomousDatabaseProperties_MaintenanceScheduleType)(0),   // 6: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.MaintenanceScheduleType
	(AutonomousDatabaseProperties_LocalDisasterRecoveryType)(0), // 7: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.LocalDisasterRecoveryType
	(AutonomousDatabaseProperties_DataSafeState)(0),             // 8: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DataSafeState
	(AutonomousDatabaseProperties_DatabaseManagementState)(0),   // 9: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DatabaseManagementState
	(AutonomousDatabaseProperties_OpenMode)(0),                  // 10: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.OpenMode
	(AutonomousDatabaseProperties_PermissionLevel)(0),           // 11: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.PermissionLevel
	(AutonomousDatabaseProperties_RefreshableMode)(0),           // 12: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.RefreshableMode
	(AutonomousDatabaseProperties_RefreshableState)(0),          // 13: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.RefreshableState
	(AutonomousDatabaseProperties_Role)(0),                      // 14: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.Role
	(DatabaseConnectionStringProfile_ConsumerGroup)(0),          // 15: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.ConsumerGroup
	(DatabaseConnectionStringProfile_HostFormat)(0),             // 16: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.HostFormat
	(DatabaseConnectionStringProfile_Protocol)(0),               // 17: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.Protocol
	(DatabaseConnectionStringProfile_SessionMode)(0),            // 18: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.SessionMode
	(DatabaseConnectionStringProfile_SyntaxFormat)(0),           // 19: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.SyntaxFormat
	(DatabaseConnectionStringProfile_TLSAuthentication)(0),      // 20: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.TLSAuthentication
	(*AutonomousDatabase)(nil),                                  // 21: google.cloud.oracledatabase.v1.AutonomousDatabase
	(*AutonomousDatabaseProperties)(nil),                        // 22: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties
	(*AutonomousDatabaseApex)(nil),                              // 23: google.cloud.oracledatabase.v1.AutonomousDatabaseApex
	(*AutonomousDatabaseConnectionStrings)(nil),                 // 24: google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionStrings
	(*DatabaseConnectionStringProfile)(nil),                     // 25: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile
	(*AllConnectionStrings)(nil),                                // 26: google.cloud.oracledatabase.v1.AllConnectionStrings
	(*AutonomousDatabaseConnectionUrls)(nil),                    // 27: google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionUrls
	(*AutonomousDatabaseStandbySummary)(nil),                    // 28: google.cloud.oracledatabase.v1.AutonomousDatabaseStandbySummary
	(*ScheduledOperationDetails)(nil),                           // 29: google.cloud.oracledatabase.v1.ScheduledOperationDetails
	nil,                                                         // 30: google.cloud.oracledatabase.v1.AutonomousDatabase.LabelsEntry
	(*timestamppb.Timestamp)(nil),                               // 31: google.protobuf.Timestamp
	(*CustomerContact)(nil),                                     // 32: google.cloud.oracledatabase.v1.CustomerContact
	(*durationpb.Duration)(nil),                                 // 33: google.protobuf.Duration
	(dayofweek.DayOfWeek)(0),                                    // 34: google.type.DayOfWeek
	(*timeofday.TimeOfDay)(nil),                                 // 35: google.type.TimeOfDay
}
var file_google_cloud_oracledatabase_v1_autonomous_database_proto_depIdxs = []int32{
	22, // 0: google.cloud.oracledatabase.v1.AutonomousDatabase.properties:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties
	30, // 1: google.cloud.oracledatabase.v1.AutonomousDatabase.labels:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabase.LabelsEntry
	31, // 2: google.cloud.oracledatabase.v1.AutonomousDatabase.create_time:type_name -> google.protobuf.Timestamp
	3,  // 3: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.db_workload:type_name -> google.cloud.oracledatabase.v1.DBWorkload
	4,  // 4: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.db_edition:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DatabaseEdition
	5,  // 5: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.license_type:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.LicenseType
	32, // 6: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.customer_contacts:type_name -> google.cloud.oracledatabase.v1.CustomerContact
	6,  // 7: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.maintenance_schedule_type:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.MaintenanceScheduleType
	23, // 8: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.apex_details:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseApex
	1,  // 9: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.state:type_name -> google.cloud.oracledatabase.v1.State
	24, // 10: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.connection_strings:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionStrings
	27, // 11: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.connection_urls:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionUrls
	33, // 12: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.failed_data_recovery_duration:type_name -> google.protobuf.Duration
	28, // 13: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.local_standby_db:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseStandbySummary
	7,  // 14: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.local_disaster_recovery_type:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.LocalDisasterRecoveryType
	8,  // 15: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.data_safe_state:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DataSafeState
	9,  // 16: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.database_management_state:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.DatabaseManagementState
	10, // 17: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.open_mode:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.OpenMode
	2,  // 18: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.operations_insights_state:type_name -> google.cloud.oracledatabase.v1.OperationsInsightsState
	11, // 19: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.permission_level:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.PermissionLevel
	12, // 20: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.refreshable_mode:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.RefreshableMode
	13, // 21: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.refreshable_state:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.RefreshableState
	14, // 22: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.role:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.Role
	29, // 23: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.scheduled_operation_details:type_name -> google.cloud.oracledatabase.v1.ScheduledOperationDetails
	31, // 24: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.next_long_term_backup_time:type_name -> google.protobuf.Timestamp
	31, // 25: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.maintenance_begin_time:type_name -> google.protobuf.Timestamp
	31, // 26: google.cloud.oracledatabase.v1.AutonomousDatabaseProperties.maintenance_end_time:type_name -> google.protobuf.Timestamp
	26, // 27: google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionStrings.all_connection_strings:type_name -> google.cloud.oracledatabase.v1.AllConnectionStrings
	25, // 28: google.cloud.oracledatabase.v1.AutonomousDatabaseConnectionStrings.profiles:type_name -> google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile
	15, // 29: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.consumer_group:type_name -> google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.ConsumerGroup
	16, // 30: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.host_format:type_name -> google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.HostFormat
	17, // 31: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.protocol:type_name -> google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.Protocol
	18, // 32: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.session_mode:type_name -> google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.SessionMode
	19, // 33: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.syntax_format:type_name -> google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.SyntaxFormat
	20, // 34: google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.tls_authentication:type_name -> google.cloud.oracledatabase.v1.DatabaseConnectionStringProfile.TLSAuthentication
	33, // 35: google.cloud.oracledatabase.v1.AutonomousDatabaseStandbySummary.lag_time_duration:type_name -> google.protobuf.Duration
	1,  // 36: google.cloud.oracledatabase.v1.AutonomousDatabaseStandbySummary.state:type_name -> google.cloud.oracledatabase.v1.State
	31, // 37: google.cloud.oracledatabase.v1.AutonomousDatabaseStandbySummary.data_guard_role_changed_time:type_name -> google.protobuf.Timestamp
	31, // 38: google.cloud.oracledatabase.v1.AutonomousDatabaseStandbySummary.disaster_recovery_role_changed_time:type_name -> google.protobuf.Timestamp
	34, // 39: google.cloud.oracledatabase.v1.ScheduledOperationDetails.day_of_week:type_name -> google.type.DayOfWeek
	35, // 40: google.cloud.oracledatabase.v1.ScheduledOperationDetails.start_time:type_name -> google.type.TimeOfDay
	35, // 41: google.cloud.oracledatabase.v1.ScheduledOperationDetails.stop_time:type_name -> google.type.TimeOfDay
	42, // [42:42] is the sub-list for method output_type
	42, // [42:42] is the sub-list for method input_type
	42, // [42:42] is the sub-list for extension type_name
	42, // [42:42] is the sub-list for extension extendee
	0,  // [0:42] is the sub-list for field type_name
}

func init() { file_google_cloud_oracledatabase_v1_autonomous_database_proto_init() }
func file_google_cloud_oracledatabase_v1_autonomous_database_proto_init() {
	if File_google_cloud_oracledatabase_v1_autonomous_database_proto != nil {
		return
	}
	file_google_cloud_oracledatabase_v1_common_proto_init()
	file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes[1].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDesc,
			NumEnums:      21,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_oracledatabase_v1_autonomous_database_proto_goTypes,
		DependencyIndexes: file_google_cloud_oracledatabase_v1_autonomous_database_proto_depIdxs,
		EnumInfos:         file_google_cloud_oracledatabase_v1_autonomous_database_proto_enumTypes,
		MessageInfos:      file_google_cloud_oracledatabase_v1_autonomous_database_proto_msgTypes,
	}.Build()
	File_google_cloud_oracledatabase_v1_autonomous_database_proto = out.File
	file_google_cloud_oracledatabase_v1_autonomous_database_proto_rawDesc = nil
	file_google_cloud_oracledatabase_v1_autonomous_database_proto_goTypes = nil
	file_google_cloud_oracledatabase_v1_autonomous_database_proto_depIdxs = nil
}
