// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/css/v1/accounts.proto

package csspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The account type.
type Account_AccountType int32

const (
	// Unknown account type.
	Account_ACCOUNT_TYPE_UNSPECIFIED Account_AccountType = 0
	// CSS group account.
	Account_CSS_GROUP Account_AccountType = 1
	// CSS domain account.
	Account_CSS_DOMAIN Account_AccountType = 2
	// MC Primary CSS MCA account.
	Account_MC_PRIMARY_CSS_MCA Account_AccountType = 3
	// MC CSS MCA account.
	Account_MC_CSS_MCA Account_AccountType = 4
	// MC Marketplace MCA account.
	Account_MC_MARKETPLACE_MCA Account_AccountType = 5
	// MC Other MCA account.
	Account_MC_OTHER_MCA Account_AccountType = 6
	// MC Standalone account.
	Account_MC_STANDALONE Account_AccountType = 7
	// MC MCA sub-account.
	Account_MC_MCA_SUBACCOUNT Account_AccountType = 8
)

// Enum value maps for Account_AccountType.
var (
	Account_AccountType_name = map[int32]string{
		0: "ACCOUNT_TYPE_UNSPECIFIED",
		1: "CSS_GROUP",
		2: "CSS_DOMAIN",
		3: "MC_PRIMARY_CSS_MCA",
		4: "MC_CSS_MCA",
		5: "MC_MARKETPLACE_MCA",
		6: "MC_OTHER_MCA",
		7: "MC_STANDALONE",
		8: "MC_MCA_SUBACCOUNT",
	}
	Account_AccountType_value = map[string]int32{
		"ACCOUNT_TYPE_UNSPECIFIED": 0,
		"CSS_GROUP":                1,
		"CSS_DOMAIN":               2,
		"MC_PRIMARY_CSS_MCA":       3,
		"MC_CSS_MCA":               4,
		"MC_MARKETPLACE_MCA":       5,
		"MC_OTHER_MCA":             6,
		"MC_STANDALONE":            7,
		"MC_MCA_SUBACCOUNT":        8,
	}
)

func (x Account_AccountType) Enum() *Account_AccountType {
	p := new(Account_AccountType)
	*p = x
	return p
}

func (x Account_AccountType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Account_AccountType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_css_v1_accounts_proto_enumTypes[0].Descriptor()
}

func (Account_AccountType) Type() protoreflect.EnumType {
	return &file_google_shopping_css_v1_accounts_proto_enumTypes[0]
}

func (x Account_AccountType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Account_AccountType.Descriptor instead.
func (Account_AccountType) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_proto_rawDescGZIP(), []int{4, 0}
}

// The request message for the `ListChildAccounts` method.
type ListChildAccountsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent account. Must be a CSS group or domain.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// If set, only the MC accounts with the given label ID will be returned.
	LabelId *int64 `protobuf:"varint,2,opt,name=label_id,json=labelId,proto3,oneof" json:"label_id,omitempty"`
	// If set, only the MC accounts with the given name (case sensitive) will be
	// returned.
	FullName *string `protobuf:"bytes,3,opt,name=full_name,json=fullName,proto3,oneof" json:"full_name,omitempty"`
	// Optional. The maximum number of accounts to return. The service may return
	// fewer than this value. If unspecified, at most 50 accounts will be
	// returned. The maximum value is 100; values above 100 will be coerced to
	// 100.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListChildAccounts` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListChildAccounts` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListChildAccountsRequest) Reset() {
	*x = ListChildAccountsRequest{}
	mi := &file_google_shopping_css_v1_accounts_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListChildAccountsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChildAccountsRequest) ProtoMessage() {}

func (x *ListChildAccountsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_accounts_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChildAccountsRequest.ProtoReflect.Descriptor instead.
func (*ListChildAccountsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_proto_rawDescGZIP(), []int{0}
}

func (x *ListChildAccountsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListChildAccountsRequest) GetLabelId() int64 {
	if x != nil && x.LabelId != nil {
		return *x.LabelId
	}
	return 0
}

func (x *ListChildAccountsRequest) GetFullName() string {
	if x != nil && x.FullName != nil {
		return *x.FullName
	}
	return ""
}

func (x *ListChildAccountsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListChildAccountsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the `ListChildAccounts` method.
type ListChildAccountsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CSS/MC accounts returned for the specified CSS parent account.
	Accounts []*Account `protobuf:"bytes,1,rep,name=accounts,proto3" json:"accounts,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListChildAccountsResponse) Reset() {
	*x = ListChildAccountsResponse{}
	mi := &file_google_shopping_css_v1_accounts_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListChildAccountsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListChildAccountsResponse) ProtoMessage() {}

func (x *ListChildAccountsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_accounts_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListChildAccountsResponse.ProtoReflect.Descriptor instead.
func (*ListChildAccountsResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_proto_rawDescGZIP(), []int{1}
}

func (x *ListChildAccountsResponse) GetAccounts() []*Account {
	if x != nil {
		return x.Accounts
	}
	return nil
}

func (x *ListChildAccountsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for the `GetAccount` method.
type GetAccountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the managed CSS/MC account.
	// Format: accounts/{account}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Only required when retrieving MC account information.
	// The CSS domain that is the parent resource of the MC account.
	// Format: accounts/{account}
	Parent *string `protobuf:"bytes,2,opt,name=parent,proto3,oneof" json:"parent,omitempty"`
}

func (x *GetAccountRequest) Reset() {
	*x = GetAccountRequest{}
	mi := &file_google_shopping_css_v1_accounts_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAccountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAccountRequest) ProtoMessage() {}

func (x *GetAccountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_accounts_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAccountRequest.ProtoReflect.Descriptor instead.
func (*GetAccountRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_proto_rawDescGZIP(), []int{2}
}

func (x *GetAccountRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetAccountRequest) GetParent() string {
	if x != nil && x.Parent != nil {
		return *x.Parent
	}
	return ""
}

// The request message for the `UpdateLabels` method.
type UpdateAccountLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The label resource name.
	// Format: accounts/{account}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The list of label IDs to overwrite the existing account label IDs.
	// If the list is empty, all currently assigned label IDs will be deleted.
	LabelIds []int64 `protobuf:"varint,2,rep,packed,name=label_ids,json=labelIds,proto3" json:"label_ids,omitempty"`
	// Optional. Only required when updating MC account labels.
	// The CSS domain that is the parent resource of the MC account.
	// Format: accounts/{account}
	Parent *string `protobuf:"bytes,3,opt,name=parent,proto3,oneof" json:"parent,omitempty"`
}

func (x *UpdateAccountLabelsRequest) Reset() {
	*x = UpdateAccountLabelsRequest{}
	mi := &file_google_shopping_css_v1_accounts_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAccountLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccountLabelsRequest) ProtoMessage() {}

func (x *UpdateAccountLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_accounts_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccountLabelsRequest.ProtoReflect.Descriptor instead.
func (*UpdateAccountLabelsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_proto_rawDescGZIP(), []int{3}
}

func (x *UpdateAccountLabelsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateAccountLabelsRequest) GetLabelIds() []int64 {
	if x != nil {
		return x.LabelIds
	}
	return nil
}

func (x *UpdateAccountLabelsRequest) GetParent() string {
	if x != nil && x.Parent != nil {
		return *x.Parent
	}
	return ""
}

// Information about CSS/MC account.
type Account struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The label resource name.
	// Format: accounts/{account}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Immutable. The CSS/MC account's full name.
	FullName string `protobuf:"bytes,2,opt,name=full_name,json=fullName,proto3" json:"full_name,omitempty"`
	// The CSS/MC account's short display name.
	DisplayName *string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3,oneof" json:"display_name,omitempty"`
	// Output only. Immutable. The CSS/MC account's homepage.
	HomepageUri *string `protobuf:"bytes,4,opt,name=homepage_uri,json=homepageUri,proto3,oneof" json:"homepage_uri,omitempty"`
	// The CSS/MC account's parent resource. CSS group for CSS domains; CSS
	// domain for MC accounts. Returned only if the user has access to the
	// parent account.
	Parent *string `protobuf:"bytes,5,opt,name=parent,proto3,oneof" json:"parent,omitempty"`
	// Manually created label IDs assigned to the CSS/MC account by a CSS parent
	// account.
	LabelIds []int64 `protobuf:"varint,6,rep,packed,name=label_ids,json=labelIds,proto3" json:"label_ids,omitempty"`
	// Automatically created label IDs assigned to the MC account by
	// CSS Center.
	AutomaticLabelIds []int64 `protobuf:"varint,7,rep,packed,name=automatic_label_ids,json=automaticLabelIds,proto3" json:"automatic_label_ids,omitempty"`
	// Output only. The type of this account.
	AccountType Account_AccountType `protobuf:"varint,8,opt,name=account_type,json=accountType,proto3,enum=google.shopping.css.v1.Account_AccountType" json:"account_type,omitempty"`
}

func (x *Account) Reset() {
	*x = Account{}
	mi := &file_google_shopping_css_v1_accounts_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Account) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Account) ProtoMessage() {}

func (x *Account) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_css_v1_accounts_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Account.ProtoReflect.Descriptor instead.
func (*Account) Descriptor() ([]byte, []int) {
	return file_google_shopping_css_v1_accounts_proto_rawDescGZIP(), []int{4}
}

func (x *Account) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Account) GetFullName() string {
	if x != nil {
		return x.FullName
	}
	return ""
}

func (x *Account) GetDisplayName() string {
	if x != nil && x.DisplayName != nil {
		return *x.DisplayName
	}
	return ""
}

func (x *Account) GetHomepageUri() string {
	if x != nil && x.HomepageUri != nil {
		return *x.HomepageUri
	}
	return ""
}

func (x *Account) GetParent() string {
	if x != nil && x.Parent != nil {
		return *x.Parent
	}
	return ""
}

func (x *Account) GetLabelIds() []int64 {
	if x != nil {
		return x.LabelIds
	}
	return nil
}

func (x *Account) GetAutomaticLabelIds() []int64 {
	if x != nil {
		return x.AutomaticLabelIds
	}
	return nil
}

func (x *Account) GetAccountType() Account_AccountType {
	if x != nil {
		return x.AccountType
	}
	return Account_ACCOUNT_TYPE_UNSPECIFIED
}

var File_google_shopping_css_v1_accounts_proto protoreflect.FileDescriptor

var file_google_shopping_css_v1_accounts_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x63, 0x73, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xf9, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x69, 0x6c, 0x64,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x63, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52,
	0x07, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x09, 0x66,
	0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01,
	0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x69, 0x64,
	0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x80,
	0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x08,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x97, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x63,
	0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x22, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x63, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01,
	0x42, 0x09, 0x0a, 0x07, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xbd, 0x01, 0x0a, 0x1a,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c,
	0x0a, 0x1a, 0x63, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x03, 0x52, 0x08, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x49, 0x64, 0x73, 0x12,
	0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x22, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x63, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01,
	0x42, 0x09, 0x0a, 0x07, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x97, 0x05, 0x0a, 0x07,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x09, 0x66,
	0x75, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06,
	0xe0, 0x41, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x08, 0x66, 0x75, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a, 0x0c, 0x68, 0x6f, 0x6d, 0x65,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06,
	0xe0, 0x41, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x01, 0x52, 0x0b, 0x68, 0x6f, 0x6d, 0x65, 0x70, 0x61,
	0x67, 0x65, 0x55, 0x72, 0x69, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x03, 0x52, 0x08, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x49,
	0x64, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x03, 0x52,
	0x11, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x49,
	0x64, 0x73, 0x12, 0x53, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0xc6, 0x01, 0x0a, 0x0b, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x43, 0x43, 0x4f, 0x55,
	0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x53, 0x53, 0x5f, 0x47, 0x52, 0x4f,
	0x55, 0x50, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x53, 0x53, 0x5f, 0x44, 0x4f, 0x4d, 0x41,
	0x49, 0x4e, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x43, 0x5f, 0x50, 0x52, 0x49, 0x4d, 0x41,
	0x52, 0x59, 0x5f, 0x43, 0x53, 0x53, 0x5f, 0x4d, 0x43, 0x41, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a,
	0x4d, 0x43, 0x5f, 0x43, 0x53, 0x53, 0x5f, 0x4d, 0x43, 0x41, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12,
	0x4d, 0x43, 0x5f, 0x4d, 0x41, 0x52, 0x4b, 0x45, 0x54, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x5f, 0x4d,
	0x43, 0x41, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x43, 0x5f, 0x4f, 0x54, 0x48, 0x45, 0x52,
	0x5f, 0x4d, 0x43, 0x41, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x43, 0x5f, 0x53, 0x54, 0x41,
	0x4e, 0x44, 0x41, 0x4c, 0x4f, 0x4e, 0x45, 0x10, 0x07, 0x12, 0x15, 0x0a, 0x11, 0x4d, 0x43, 0x5f,
	0x4d, 0x43, 0x41, 0x5f, 0x53, 0x55, 0x42, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x08,
	0x3a, 0x46, 0xea, 0x41, 0x43, 0x0a, 0x1a, 0x63, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x12, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2a, 0x08, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x32,
	0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x68, 0x6f,
	0x6d, 0x65, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x32, 0xa5, 0x04, 0x0a, 0x0f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb4, 0x01, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x68, 0x69,
	0x6c, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x68, 0x69, 0x6c, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c,
	0x69, 0x73, 0x74, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x12, 0x7e, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x24, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x12, 0x15, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x99, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x34, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x27, 0x3a, 0x01, 0x2a, 0x22, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x3f, 0xca, 0x41,
	0x12, 0x63, 0x73, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0xaf, 0x01,
	0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x63, 0x73, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x63, 0x73, 0x73, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x73, 0x73, 0x70, 0x62, 0x3b, 0x63, 0x73, 0x73, 0x70,
	0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x53, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x43, 0x73, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5c, 0x43, 0x73, 0x73,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x53, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x43, 0x73, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_css_v1_accounts_proto_rawDescOnce sync.Once
	file_google_shopping_css_v1_accounts_proto_rawDescData = file_google_shopping_css_v1_accounts_proto_rawDesc
)

func file_google_shopping_css_v1_accounts_proto_rawDescGZIP() []byte {
	file_google_shopping_css_v1_accounts_proto_rawDescOnce.Do(func() {
		file_google_shopping_css_v1_accounts_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_css_v1_accounts_proto_rawDescData)
	})
	return file_google_shopping_css_v1_accounts_proto_rawDescData
}

var file_google_shopping_css_v1_accounts_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_shopping_css_v1_accounts_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_shopping_css_v1_accounts_proto_goTypes = []any{
	(Account_AccountType)(0),           // 0: google.shopping.css.v1.Account.AccountType
	(*ListChildAccountsRequest)(nil),   // 1: google.shopping.css.v1.ListChildAccountsRequest
	(*ListChildAccountsResponse)(nil),  // 2: google.shopping.css.v1.ListChildAccountsResponse
	(*GetAccountRequest)(nil),          // 3: google.shopping.css.v1.GetAccountRequest
	(*UpdateAccountLabelsRequest)(nil), // 4: google.shopping.css.v1.UpdateAccountLabelsRequest
	(*Account)(nil),                    // 5: google.shopping.css.v1.Account
}
var file_google_shopping_css_v1_accounts_proto_depIdxs = []int32{
	5, // 0: google.shopping.css.v1.ListChildAccountsResponse.accounts:type_name -> google.shopping.css.v1.Account
	0, // 1: google.shopping.css.v1.Account.account_type:type_name -> google.shopping.css.v1.Account.AccountType
	1, // 2: google.shopping.css.v1.AccountsService.ListChildAccounts:input_type -> google.shopping.css.v1.ListChildAccountsRequest
	3, // 3: google.shopping.css.v1.AccountsService.GetAccount:input_type -> google.shopping.css.v1.GetAccountRequest
	4, // 4: google.shopping.css.v1.AccountsService.UpdateLabels:input_type -> google.shopping.css.v1.UpdateAccountLabelsRequest
	2, // 5: google.shopping.css.v1.AccountsService.ListChildAccounts:output_type -> google.shopping.css.v1.ListChildAccountsResponse
	5, // 6: google.shopping.css.v1.AccountsService.GetAccount:output_type -> google.shopping.css.v1.Account
	5, // 7: google.shopping.css.v1.AccountsService.UpdateLabels:output_type -> google.shopping.css.v1.Account
	5, // [5:8] is the sub-list for method output_type
	2, // [2:5] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_shopping_css_v1_accounts_proto_init() }
func file_google_shopping_css_v1_accounts_proto_init() {
	if File_google_shopping_css_v1_accounts_proto != nil {
		return
	}
	file_google_shopping_css_v1_accounts_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_shopping_css_v1_accounts_proto_msgTypes[2].OneofWrappers = []any{}
	file_google_shopping_css_v1_accounts_proto_msgTypes[3].OneofWrappers = []any{}
	file_google_shopping_css_v1_accounts_proto_msgTypes[4].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_css_v1_accounts_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_css_v1_accounts_proto_goTypes,
		DependencyIndexes: file_google_shopping_css_v1_accounts_proto_depIdxs,
		EnumInfos:         file_google_shopping_css_v1_accounts_proto_enumTypes,
		MessageInfos:      file_google_shopping_css_v1_accounts_proto_msgTypes,
	}.Build()
	File_google_shopping_css_v1_accounts_proto = out.File
	file_google_shopping_css_v1_accounts_proto_rawDesc = nil
	file_google_shopping_css_v1_accounts_proto_goTypes = nil
	file_google_shopping_css_v1_accounts_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AccountsServiceClient is the client API for AccountsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AccountsServiceClient interface {
	// Lists all the accounts under the specified CSS account ID, and
	// optionally filters by label ID and account name.
	ListChildAccounts(ctx context.Context, in *ListChildAccountsRequest, opts ...grpc.CallOption) (*ListChildAccountsResponse, error)
	// Retrieves a single CSS/MC account by ID.
	GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error)
	// Updates labels assigned to CSS/MC accounts by a CSS domain.
	UpdateLabels(ctx context.Context, in *UpdateAccountLabelsRequest, opts ...grpc.CallOption) (*Account, error)
}

type accountsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAccountsServiceClient(cc grpc.ClientConnInterface) AccountsServiceClient {
	return &accountsServiceClient{cc}
}

func (c *accountsServiceClient) ListChildAccounts(ctx context.Context, in *ListChildAccountsRequest, opts ...grpc.CallOption) (*ListChildAccountsResponse, error) {
	out := new(ListChildAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.css.v1.AccountsService/ListChildAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accountsServiceClient) GetAccount(ctx context.Context, in *GetAccountRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.shopping.css.v1.AccountsService/GetAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accountsServiceClient) UpdateLabels(ctx context.Context, in *UpdateAccountLabelsRequest, opts ...grpc.CallOption) (*Account, error) {
	out := new(Account)
	err := c.cc.Invoke(ctx, "/google.shopping.css.v1.AccountsService/UpdateLabels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AccountsServiceServer is the server API for AccountsService service.
type AccountsServiceServer interface {
	// Lists all the accounts under the specified CSS account ID, and
	// optionally filters by label ID and account name.
	ListChildAccounts(context.Context, *ListChildAccountsRequest) (*ListChildAccountsResponse, error)
	// Retrieves a single CSS/MC account by ID.
	GetAccount(context.Context, *GetAccountRequest) (*Account, error)
	// Updates labels assigned to CSS/MC accounts by a CSS domain.
	UpdateLabels(context.Context, *UpdateAccountLabelsRequest) (*Account, error)
}

// UnimplementedAccountsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAccountsServiceServer struct {
}

func (*UnimplementedAccountsServiceServer) ListChildAccounts(context.Context, *ListChildAccountsRequest) (*ListChildAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChildAccounts not implemented")
}
func (*UnimplementedAccountsServiceServer) GetAccount(context.Context, *GetAccountRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccount not implemented")
}
func (*UnimplementedAccountsServiceServer) UpdateLabels(context.Context, *UpdateAccountLabelsRequest) (*Account, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLabels not implemented")
}

func RegisterAccountsServiceServer(s *grpc.Server, srv AccountsServiceServer) {
	s.RegisterService(&_AccountsService_serviceDesc, srv)
}

func _AccountsService_ListChildAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChildAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountsServiceServer).ListChildAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.css.v1.AccountsService/ListChildAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountsServiceServer).ListChildAccounts(ctx, req.(*ListChildAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccountsService_GetAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountsServiceServer).GetAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.css.v1.AccountsService/GetAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountsServiceServer).GetAccount(ctx, req.(*GetAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccountsService_UpdateLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccountLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountsServiceServer).UpdateLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.css.v1.AccountsService/UpdateLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountsServiceServer).UpdateLabels(ctx, req.(*UpdateAccountLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AccountsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.css.v1.AccountsService",
	HandlerType: (*AccountsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListChildAccounts",
			Handler:    _AccountsService_ListChildAccounts_Handler,
		},
		{
			MethodName: "GetAccount",
			Handler:    _AccountsService_GetAccount_Handler,
		},
		{
			MethodName: "UpdateLabels",
			Handler:    _AccountsService_UpdateLabels_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/css/v1/accounts.proto",
}
