// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/accounts/v1beta/online_return_policy.proto

package accountspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The available return methods.
type OnlineReturnPolicy_ReturnMethod int32

const (
	// Default value. This value is unused.
	OnlineReturnPolicy_RETURN_METHOD_UNSPECIFIED OnlineReturnPolicy_ReturnMethod = 0
	// Return by mail.
	OnlineReturnPolicy_BY_MAIL OnlineReturnPolicy_ReturnMethod = 1
	// Return in store.
	OnlineReturnPolicy_IN_STORE OnlineReturnPolicy_ReturnMethod = 2
	// Return at a kiosk.
	OnlineReturnPolicy_AT_A_KIOSK OnlineReturnPolicy_ReturnMethod = 3
)

// Enum value maps for OnlineReturnPolicy_ReturnMethod.
var (
	OnlineReturnPolicy_ReturnMethod_name = map[int32]string{
		0: "RETURN_METHOD_UNSPECIFIED",
		1: "BY_MAIL",
		2: "IN_STORE",
		3: "AT_A_KIOSK",
	}
	OnlineReturnPolicy_ReturnMethod_value = map[string]int32{
		"RETURN_METHOD_UNSPECIFIED": 0,
		"BY_MAIL":                   1,
		"IN_STORE":                  2,
		"AT_A_KIOSK":                3,
	}
)

func (x OnlineReturnPolicy_ReturnMethod) Enum() *OnlineReturnPolicy_ReturnMethod {
	p := new(OnlineReturnPolicy_ReturnMethod)
	*p = x
	return p
}

func (x OnlineReturnPolicy_ReturnMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OnlineReturnPolicy_ReturnMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_enumTypes[0].Descriptor()
}

func (OnlineReturnPolicy_ReturnMethod) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_enumTypes[0]
}

func (x OnlineReturnPolicy_ReturnMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OnlineReturnPolicy_ReturnMethod.Descriptor instead.
func (OnlineReturnPolicy_ReturnMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{3, 0}
}

// The available item conditions.
type OnlineReturnPolicy_ItemCondition int32

const (
	// Default value. This value is unused.
	OnlineReturnPolicy_ITEM_CONDITION_UNSPECIFIED OnlineReturnPolicy_ItemCondition = 0
	// New.
	OnlineReturnPolicy_NEW OnlineReturnPolicy_ItemCondition = 1
	// Used.
	OnlineReturnPolicy_USED OnlineReturnPolicy_ItemCondition = 2
)

// Enum value maps for OnlineReturnPolicy_ItemCondition.
var (
	OnlineReturnPolicy_ItemCondition_name = map[int32]string{
		0: "ITEM_CONDITION_UNSPECIFIED",
		1: "NEW",
		2: "USED",
	}
	OnlineReturnPolicy_ItemCondition_value = map[string]int32{
		"ITEM_CONDITION_UNSPECIFIED": 0,
		"NEW":                        1,
		"USED":                       2,
	}
)

func (x OnlineReturnPolicy_ItemCondition) Enum() *OnlineReturnPolicy_ItemCondition {
	p := new(OnlineReturnPolicy_ItemCondition)
	*p = x
	return p
}

func (x OnlineReturnPolicy_ItemCondition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OnlineReturnPolicy_ItemCondition) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_enumTypes[1].Descriptor()
}

func (OnlineReturnPolicy_ItemCondition) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_enumTypes[1]
}

func (x OnlineReturnPolicy_ItemCondition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OnlineReturnPolicy_ItemCondition.Descriptor instead.
func (OnlineReturnPolicy_ItemCondition) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{3, 1}
}

// Return shipping fee types.
type OnlineReturnPolicy_ReturnShippingFee_Type int32

const (
	// Default value. This value is unused.
	OnlineReturnPolicy_ReturnShippingFee_TYPE_UNSPECIFIED OnlineReturnPolicy_ReturnShippingFee_Type = 0
	// The return shipping fee is a fixed value.
	OnlineReturnPolicy_ReturnShippingFee_FIXED OnlineReturnPolicy_ReturnShippingFee_Type = 1
	// Customers will pay the actual return shipping fee.
	OnlineReturnPolicy_ReturnShippingFee_CUSTOMER_PAYING_ACTUAL_FEE OnlineReturnPolicy_ReturnShippingFee_Type = 2
)

// Enum value maps for OnlineReturnPolicy_ReturnShippingFee_Type.
var (
	OnlineReturnPolicy_ReturnShippingFee_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "FIXED",
		2: "CUSTOMER_PAYING_ACTUAL_FEE",
	}
	OnlineReturnPolicy_ReturnShippingFee_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":           0,
		"FIXED":                      1,
		"CUSTOMER_PAYING_ACTUAL_FEE": 2,
	}
)

func (x OnlineReturnPolicy_ReturnShippingFee_Type) Enum() *OnlineReturnPolicy_ReturnShippingFee_Type {
	p := new(OnlineReturnPolicy_ReturnShippingFee_Type)
	*p = x
	return p
}

func (x OnlineReturnPolicy_ReturnShippingFee_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OnlineReturnPolicy_ReturnShippingFee_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_enumTypes[2].Descriptor()
}

func (OnlineReturnPolicy_ReturnShippingFee_Type) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_enumTypes[2]
}

func (x OnlineReturnPolicy_ReturnShippingFee_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OnlineReturnPolicy_ReturnShippingFee_Type.Descriptor instead.
func (OnlineReturnPolicy_ReturnShippingFee_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{3, 0, 0}
}

// Return policy types.
type OnlineReturnPolicy_Policy_Type int32

const (
	// Default value. This value is unused.
	OnlineReturnPolicy_Policy_TYPE_UNSPECIFIED OnlineReturnPolicy_Policy_Type = 0
	// The number of days within which a return is valid after delivery.
	OnlineReturnPolicy_Policy_NUMBER_OF_DAYS_AFTER_DELIVERY OnlineReturnPolicy_Policy_Type = 1
	// No returns.
	OnlineReturnPolicy_Policy_NO_RETURNS OnlineReturnPolicy_Policy_Type = 2
	// Life time returns.
	OnlineReturnPolicy_Policy_LIFETIME_RETURNS OnlineReturnPolicy_Policy_Type = 3
)

// Enum value maps for OnlineReturnPolicy_Policy_Type.
var (
	OnlineReturnPolicy_Policy_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "NUMBER_OF_DAYS_AFTER_DELIVERY",
		2: "NO_RETURNS",
		3: "LIFETIME_RETURNS",
	}
	OnlineReturnPolicy_Policy_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":              0,
		"NUMBER_OF_DAYS_AFTER_DELIVERY": 1,
		"NO_RETURNS":                    2,
		"LIFETIME_RETURNS":              3,
	}
)

func (x OnlineReturnPolicy_Policy_Type) Enum() *OnlineReturnPolicy_Policy_Type {
	p := new(OnlineReturnPolicy_Policy_Type)
	*p = x
	return p
}

func (x OnlineReturnPolicy_Policy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OnlineReturnPolicy_Policy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_enumTypes[3].Descriptor()
}

func (OnlineReturnPolicy_Policy_Type) Type() protoreflect.EnumType {
	return &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_enumTypes[3]
}

func (x OnlineReturnPolicy_Policy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OnlineReturnPolicy_Policy_Type.Descriptor instead.
func (OnlineReturnPolicy_Policy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{3, 2, 0}
}

// Request message for the `GetOnlineReturnPolicy` method.
type GetOnlineReturnPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the return policy to retrieve.
	// Format: `accounts/{account}/onlineReturnPolicies/{return_policy}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOnlineReturnPolicyRequest) Reset() {
	*x = GetOnlineReturnPolicyRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOnlineReturnPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOnlineReturnPolicyRequest) ProtoMessage() {}

func (x *GetOnlineReturnPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOnlineReturnPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetOnlineReturnPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{0}
}

func (x *GetOnlineReturnPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `ListOnlineReturnPolicies` method.
type ListOnlineReturnPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The business account for which to list return policies.
	// Format: `accounts/{account}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of `OnlineReturnPolicy` resources to return.
	// The service returns fewer than this value if the number of return policies
	// for the given merchant is less that than the `pageSize`. The default value
	// is 10. The maximum value is 100; If a value higher than the maximum is
	// specified, then the `pageSize` will default to the maximum
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListOnlineReturnPolicies`
	// call. Provide the page token to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListOnlineReturnPolicies` must match the call that provided the page
	// token. The token returned as
	// [nextPageToken][google.shopping.merchant.accounts.v1beta.ListOnlineReturnPoliciesResponse.next_page_token]
	// in the response to the previous request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListOnlineReturnPoliciesRequest) Reset() {
	*x = ListOnlineReturnPoliciesRequest{}
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOnlineReturnPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOnlineReturnPoliciesRequest) ProtoMessage() {}

func (x *ListOnlineReturnPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOnlineReturnPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListOnlineReturnPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{1}
}

func (x *ListOnlineReturnPoliciesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOnlineReturnPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOnlineReturnPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the `ListOnlineReturnPolicies` method.
type ListOnlineReturnPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The retrieved return policies.
	OnlineReturnPolicies []*OnlineReturnPolicy `protobuf:"bytes,1,rep,name=online_return_policies,json=onlineReturnPolicies,proto3" json:"online_return_policies,omitempty"`
	// A token, which can be sent as `pageToken` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListOnlineReturnPoliciesResponse) Reset() {
	*x = ListOnlineReturnPoliciesResponse{}
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOnlineReturnPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOnlineReturnPoliciesResponse) ProtoMessage() {}

func (x *ListOnlineReturnPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOnlineReturnPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListOnlineReturnPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{2}
}

func (x *ListOnlineReturnPoliciesResponse) GetOnlineReturnPolicies() []*OnlineReturnPolicy {
	if x != nil {
		return x.OnlineReturnPolicies
	}
	return nil
}

func (x *ListOnlineReturnPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// [Online return policy](https://support.google.com/merchants/answer/10220642)
// object. This is currently used to represent return policies for ads and free
// listings programs.
type OnlineReturnPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the `OnlineReturnPolicy` resource.
	// Format: `accounts/{account}/onlineReturnPolicies/{return_policy}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Return policy ID generated by Google.
	ReturnPolicyId string `protobuf:"bytes,2,opt,name=return_policy_id,json=returnPolicyId,proto3" json:"return_policy_id,omitempty"`
	// Required. Immutable. This field represents the unique user-defined label of
	// the return policy. It is important to note that the same label cannot be
	// used in different return policies for the same country. Unless a product
	// specifies a specific label attribute, policies will be automatically
	// labeled as 'default'. To assign a custom return policy to certain product
	// groups, follow the instructions provided in the [Return policy label]
	// (https://support.google.com/merchants/answer/9445425).
	// The label can contain up to 50 characters.
	Label string `protobuf:"bytes,3,opt,name=label,proto3" json:"label,omitempty"`
	// Required. Immutable. The countries of sale where the return policy applies.
	// The values must be a valid 2 letter ISO 3166 code.
	Countries []string `protobuf:"bytes,4,rep,name=countries,proto3" json:"countries,omitempty"`
	// The return policy.
	Policy *OnlineReturnPolicy_Policy `protobuf:"bytes,5,opt,name=policy,proto3" json:"policy,omitempty"`
	// Optional. Overrides to the general policy for orders placed during a
	// specific set of time intervals.
	SeasonalOverrides []*OnlineReturnPolicy_SeasonalOverride `protobuf:"bytes,14,rep,name=seasonal_overrides,json=seasonalOverrides,proto3" json:"seasonal_overrides,omitempty"`
	// The restocking fee that applies to all return reason categories. This would
	// be treated as a free restocking fee if the value is not set.
	RestockingFee *OnlineReturnPolicy_RestockingFee `protobuf:"bytes,6,opt,name=restocking_fee,json=restockingFee,proto3" json:"restocking_fee,omitempty"`
	// The return methods of how customers can return an item. This value is
	// required to not be empty unless the type of return policy is noReturns.
	ReturnMethods []OnlineReturnPolicy_ReturnMethod `protobuf:"varint,7,rep,packed,name=return_methods,json=returnMethods,proto3,enum=google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy_ReturnMethod" json:"return_methods,omitempty"`
	// The item conditions accepted for returns must not be empty unless the type
	// of return policy is 'noReturns'.
	ItemConditions []OnlineReturnPolicy_ItemCondition `protobuf:"varint,8,rep,packed,name=item_conditions,json=itemConditions,proto3,enum=google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy_ItemCondition" json:"item_conditions,omitempty"`
	// The return shipping fee. Should be set only when customer need to download
	// and print the return label.
	ReturnShippingFee *OnlineReturnPolicy_ReturnShippingFee `protobuf:"bytes,9,opt,name=return_shipping_fee,json=returnShippingFee,proto3" json:"return_shipping_fee,omitempty"`
	// Required. The return policy uri. This can used by Google to do a sanity
	// check for the policy. It must be a valid URL.
	ReturnPolicyUri string `protobuf:"bytes,10,opt,name=return_policy_uri,json=returnPolicyUri,proto3" json:"return_policy_uri,omitempty"`
	// This field specifies if merchant only accepts defective products for
	// returns, and this field is required.
	AcceptDefectiveOnly *bool `protobuf:"varint,11,opt,name=accept_defective_only,json=acceptDefectiveOnly,proto3,oneof" json:"accept_defective_only,omitempty"`
	// The field specifies the number of days it takes for merchants to process
	// refunds, field is optional.
	ProcessRefundDays *int32 `protobuf:"varint,12,opt,name=process_refund_days,json=processRefundDays,proto3,oneof" json:"process_refund_days,omitempty"`
	// This field specifies if merchant allows customers to exchange products,
	// this field is required.
	AcceptExchange *bool `protobuf:"varint,13,opt,name=accept_exchange,json=acceptExchange,proto3,oneof" json:"accept_exchange,omitempty"`
}

func (x *OnlineReturnPolicy) Reset() {
	*x = OnlineReturnPolicy{}
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnlineReturnPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnlineReturnPolicy) ProtoMessage() {}

func (x *OnlineReturnPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnlineReturnPolicy.ProtoReflect.Descriptor instead.
func (*OnlineReturnPolicy) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{3}
}

func (x *OnlineReturnPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OnlineReturnPolicy) GetReturnPolicyId() string {
	if x != nil {
		return x.ReturnPolicyId
	}
	return ""
}

func (x *OnlineReturnPolicy) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *OnlineReturnPolicy) GetCountries() []string {
	if x != nil {
		return x.Countries
	}
	return nil
}

func (x *OnlineReturnPolicy) GetPolicy() *OnlineReturnPolicy_Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *OnlineReturnPolicy) GetSeasonalOverrides() []*OnlineReturnPolicy_SeasonalOverride {
	if x != nil {
		return x.SeasonalOverrides
	}
	return nil
}

func (x *OnlineReturnPolicy) GetRestockingFee() *OnlineReturnPolicy_RestockingFee {
	if x != nil {
		return x.RestockingFee
	}
	return nil
}

func (x *OnlineReturnPolicy) GetReturnMethods() []OnlineReturnPolicy_ReturnMethod {
	if x != nil {
		return x.ReturnMethods
	}
	return nil
}

func (x *OnlineReturnPolicy) GetItemConditions() []OnlineReturnPolicy_ItemCondition {
	if x != nil {
		return x.ItemConditions
	}
	return nil
}

func (x *OnlineReturnPolicy) GetReturnShippingFee() *OnlineReturnPolicy_ReturnShippingFee {
	if x != nil {
		return x.ReturnShippingFee
	}
	return nil
}

func (x *OnlineReturnPolicy) GetReturnPolicyUri() string {
	if x != nil {
		return x.ReturnPolicyUri
	}
	return ""
}

func (x *OnlineReturnPolicy) GetAcceptDefectiveOnly() bool {
	if x != nil && x.AcceptDefectiveOnly != nil {
		return *x.AcceptDefectiveOnly
	}
	return false
}

func (x *OnlineReturnPolicy) GetProcessRefundDays() int32 {
	if x != nil && x.ProcessRefundDays != nil {
		return *x.ProcessRefundDays
	}
	return 0
}

func (x *OnlineReturnPolicy) GetAcceptExchange() bool {
	if x != nil && x.AcceptExchange != nil {
		return *x.AcceptExchange
	}
	return false
}

// The return shipping fee. This can either be a fixed fee or a boolean to
// indicate that the customer pays the actual shipping cost.
type OnlineReturnPolicy_ReturnShippingFee struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Type of return shipping fee.
	Type OnlineReturnPolicy_ReturnShippingFee_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy_ReturnShippingFee_Type" json:"type,omitempty"`
	// Fixed return shipping fee amount. This value is only applicable when type
	// is `FIXED`. We will treat the return shipping fee as free if type is
	// `FIXED` and this value is not set.
	FixedFee *typepb.Price `protobuf:"bytes,2,opt,name=fixed_fee,json=fixedFee,proto3" json:"fixed_fee,omitempty"`
}

func (x *OnlineReturnPolicy_ReturnShippingFee) Reset() {
	*x = OnlineReturnPolicy_ReturnShippingFee{}
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnlineReturnPolicy_ReturnShippingFee) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnlineReturnPolicy_ReturnShippingFee) ProtoMessage() {}

func (x *OnlineReturnPolicy_ReturnShippingFee) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnlineReturnPolicy_ReturnShippingFee.ProtoReflect.Descriptor instead.
func (*OnlineReturnPolicy_ReturnShippingFee) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{3, 0}
}

func (x *OnlineReturnPolicy_ReturnShippingFee) GetType() OnlineReturnPolicy_ReturnShippingFee_Type {
	if x != nil {
		return x.Type
	}
	return OnlineReturnPolicy_ReturnShippingFee_TYPE_UNSPECIFIED
}

func (x *OnlineReturnPolicy_ReturnShippingFee) GetFixedFee() *typepb.Price {
	if x != nil {
		return x.FixedFee
	}
	return nil
}

// The restocking fee. This can be a flat fee or a micro percent.
type OnlineReturnPolicy_RestockingFee struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*OnlineReturnPolicy_RestockingFee_FixedFee
	//	*OnlineReturnPolicy_RestockingFee_MicroPercent
	Type isOnlineReturnPolicy_RestockingFee_Type `protobuf_oneof:"type"`
}

func (x *OnlineReturnPolicy_RestockingFee) Reset() {
	*x = OnlineReturnPolicy_RestockingFee{}
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnlineReturnPolicy_RestockingFee) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnlineReturnPolicy_RestockingFee) ProtoMessage() {}

func (x *OnlineReturnPolicy_RestockingFee) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnlineReturnPolicy_RestockingFee.ProtoReflect.Descriptor instead.
func (*OnlineReturnPolicy_RestockingFee) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{3, 1}
}

func (m *OnlineReturnPolicy_RestockingFee) GetType() isOnlineReturnPolicy_RestockingFee_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *OnlineReturnPolicy_RestockingFee) GetFixedFee() *typepb.Price {
	if x, ok := x.GetType().(*OnlineReturnPolicy_RestockingFee_FixedFee); ok {
		return x.FixedFee
	}
	return nil
}

func (x *OnlineReturnPolicy_RestockingFee) GetMicroPercent() int32 {
	if x, ok := x.GetType().(*OnlineReturnPolicy_RestockingFee_MicroPercent); ok {
		return x.MicroPercent
	}
	return 0
}

type isOnlineReturnPolicy_RestockingFee_Type interface {
	isOnlineReturnPolicy_RestockingFee_Type()
}

type OnlineReturnPolicy_RestockingFee_FixedFee struct {
	// Fixed restocking fee.
	FixedFee *typepb.Price `protobuf:"bytes,1,opt,name=fixed_fee,json=fixedFee,proto3,oneof"`
}

type OnlineReturnPolicy_RestockingFee_MicroPercent struct {
	// Percent of total price in micros. 15,000,000 means 15% of the total
	// price would be charged.
	MicroPercent int32 `protobuf:"varint,2,opt,name=micro_percent,json=microPercent,proto3,oneof"`
}

func (*OnlineReturnPolicy_RestockingFee_FixedFee) isOnlineReturnPolicy_RestockingFee_Type() {}

func (*OnlineReturnPolicy_RestockingFee_MicroPercent) isOnlineReturnPolicy_RestockingFee_Type() {}

// The available policies.
type OnlineReturnPolicy_Policy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Policy type.
	Type OnlineReturnPolicy_Policy_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy_Policy_Type" json:"type,omitempty"`
	// The number of days items can be returned after delivery, where one day
	// is defined as 24 hours after the delivery timestamp. Required for
	// `NUMBER_OF_DAYS_AFTER_DELIVERY` returns.
	Days int64 `protobuf:"varint,2,opt,name=days,proto3" json:"days,omitempty"`
}

func (x *OnlineReturnPolicy_Policy) Reset() {
	*x = OnlineReturnPolicy_Policy{}
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnlineReturnPolicy_Policy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnlineReturnPolicy_Policy) ProtoMessage() {}

func (x *OnlineReturnPolicy_Policy) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnlineReturnPolicy_Policy.ProtoReflect.Descriptor instead.
func (*OnlineReturnPolicy_Policy) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{3, 2}
}

func (x *OnlineReturnPolicy_Policy) GetType() OnlineReturnPolicy_Policy_Type {
	if x != nil {
		return x.Type
	}
	return OnlineReturnPolicy_Policy_TYPE_UNSPECIFIED
}

func (x *OnlineReturnPolicy_Policy) GetDays() int64 {
	if x != nil {
		return x.Days
	}
	return 0
}

type OnlineReturnPolicy_SeasonalOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ReturnWindow: Specifies either a fixed return date or the number of
	// days (from the delivery date) until which a product can be returned.
	// [Merchant Return Days](https://schema.org/merchantReturnDays)
	//
	// Types that are assignable to ReturnWindow:
	//
	//	*OnlineReturnPolicy_SeasonalOverride_ReturnDays
	//	*OnlineReturnPolicy_SeasonalOverride_ReturnUntilDate
	ReturnWindow isOnlineReturnPolicy_SeasonalOverride_ReturnWindow `protobuf_oneof:"return_window"`
	// Required. Display name of this seasonal override in Merchant Center.
	Label string `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	// Required. Defines the date range when this seasonal override applies.
	// Both start_date and end_date are inclusive.
	// The dates of the seasonal overrides should not overlap.
	StartDate *date.Date `protobuf:"bytes,2,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Required. seasonal override end date (inclusive).
	EndDate *date.Date `protobuf:"bytes,3,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
}

func (x *OnlineReturnPolicy_SeasonalOverride) Reset() {
	*x = OnlineReturnPolicy_SeasonalOverride{}
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OnlineReturnPolicy_SeasonalOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnlineReturnPolicy_SeasonalOverride) ProtoMessage() {}

func (x *OnlineReturnPolicy_SeasonalOverride) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnlineReturnPolicy_SeasonalOverride.ProtoReflect.Descriptor instead.
func (*OnlineReturnPolicy_SeasonalOverride) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP(), []int{3, 3}
}

func (m *OnlineReturnPolicy_SeasonalOverride) GetReturnWindow() isOnlineReturnPolicy_SeasonalOverride_ReturnWindow {
	if m != nil {
		return m.ReturnWindow
	}
	return nil
}

func (x *OnlineReturnPolicy_SeasonalOverride) GetReturnDays() int32 {
	if x, ok := x.GetReturnWindow().(*OnlineReturnPolicy_SeasonalOverride_ReturnDays); ok {
		return x.ReturnDays
	}
	return 0
}

func (x *OnlineReturnPolicy_SeasonalOverride) GetReturnUntilDate() *date.Date {
	if x, ok := x.GetReturnWindow().(*OnlineReturnPolicy_SeasonalOverride_ReturnUntilDate); ok {
		return x.ReturnUntilDate
	}
	return nil
}

func (x *OnlineReturnPolicy_SeasonalOverride) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *OnlineReturnPolicy_SeasonalOverride) GetStartDate() *date.Date {
	if x != nil {
		return x.StartDate
	}
	return nil
}

func (x *OnlineReturnPolicy_SeasonalOverride) GetEndDate() *date.Date {
	if x != nil {
		return x.EndDate
	}
	return nil
}

type isOnlineReturnPolicy_SeasonalOverride_ReturnWindow interface {
	isOnlineReturnPolicy_SeasonalOverride_ReturnWindow()
}

type OnlineReturnPolicy_SeasonalOverride_ReturnDays struct {
	// Number of days (from the delivery date) that the product can be
	// returned.
	ReturnDays int32 `protobuf:"varint,5,opt,name=return_days,json=returnDays,proto3,oneof"`
}

type OnlineReturnPolicy_SeasonalOverride_ReturnUntilDate struct {
	// Fixed end date until which the product can be returned.
	ReturnUntilDate *date.Date `protobuf:"bytes,6,opt,name=return_until_date,json=returnUntilDate,proto3,oneof"`
}

func (*OnlineReturnPolicy_SeasonalOverride_ReturnDays) isOnlineReturnPolicy_SeasonalOverride_ReturnWindow() {
}

func (*OnlineReturnPolicy_SeasonalOverride_ReturnUntilDate) isOnlineReturnPolicy_SeasonalOverride_ReturnWindow() {
}

var File_google_shopping_merchant_accounts_v1beta_online_return_policy_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDesc = []byte{
	0x0a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x69, 0x0a, 0x1c,
	0x47, 0x65, 0x74, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2f, 0x0a, 0x2d, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f,
	0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb6, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xbe, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x72, 0x0a, 0x16, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f,
	0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x14, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x9b, 0x12, 0x0a, 0x12, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75,
	0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x2d, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64,
	0x12, 0x1c, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x24,
	0x0a, 0x09, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x81, 0x01, 0x0a, 0x12, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x53, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x11, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x71, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x63, 0x6b,
	0x69, 0x6e, 0x67, 0x5f, 0x66, 0x65, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x46, 0x65, 0x65, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x63, 0x6b, 0x69, 0x6e, 0x67, 0x46, 0x65, 0x65, 0x12, 0x70, 0x0a, 0x0e, 0x72, 0x65, 0x74, 0x75,
	0x72, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0d, 0x72, 0x65, 0x74,
	0x75, 0x72, 0x6e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x73, 0x0a, 0x0f, 0x69, 0x74,
	0x65, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f,
	0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0e, 0x69, 0x74, 0x65, 0x6d, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x7e, 0x0a, 0x13, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x73, 0x68, 0x69, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x5f, 0x66, 0x65, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65,
	0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x65, 0x74, 0x75, 0x72,
	0x6e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x46, 0x65, 0x65, 0x52, 0x11, 0x72, 0x65,
	0x74, 0x75, 0x72, 0x6e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x46, 0x65, 0x65, 0x12,
	0x2f, 0x0a, 0x11, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0f, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x55, 0x72, 0x69,
	0x12, 0x37, 0x0a, 0x15, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x00, 0x52, 0x13, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x44, 0x65, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x66, 0x75, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x79, 0x73,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x66, 0x75, 0x6e, 0x64, 0x44, 0x61, 0x79, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2c,
	0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x70,
	0x74, 0x45, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x88, 0x01, 0x01, 0x1a, 0x84, 0x02, 0x0a,
	0x11, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x46,
	0x65, 0x65, 0x12, 0x6c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x6e, 0x6c, 0x69,
	0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x53, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x46, 0x65, 0x65,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x38, 0x0a, 0x09, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x66, 0x65, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65,
	0x52, 0x08, 0x66, 0x69, 0x78, 0x65, 0x64, 0x46, 0x65, 0x65, 0x22, 0x47, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x49, 0x58, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f,
	0x50, 0x41, 0x59, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x43, 0x54, 0x55, 0x41, 0x4c, 0x5f, 0x46, 0x45,
	0x45, 0x10, 0x02, 0x1a, 0x7a, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x63, 0x6b, 0x69, 0x6e,
	0x67, 0x46, 0x65, 0x65, 0x12, 0x3a, 0x0a, 0x09, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x66, 0x65,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50,
	0x72, 0x69, 0x63, 0x65, 0x48, 0x00, 0x52, 0x08, 0x66, 0x69, 0x78, 0x65, 0x64, 0x46, 0x65, 0x65,
	0x12, 0x25, 0x0a, 0x0d, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x69, 0x63, 0x72, 0x6f,
	0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a,
	0xe1, 0x01, 0x0a, 0x06, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5c, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x79, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x64, 0x61, 0x79, 0x73, 0x22, 0x65, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x4e, 0x55,
	0x4d, 0x42, 0x45, 0x52, 0x5f, 0x4f, 0x46, 0x5f, 0x44, 0x41, 0x59, 0x53, 0x5f, 0x41, 0x46, 0x54,
	0x45, 0x52, 0x5f, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0e, 0x0a,
	0x0a, 0x4e, 0x4f, 0x5f, 0x52, 0x45, 0x54, 0x55, 0x52, 0x4e, 0x53, 0x10, 0x02, 0x12, 0x14, 0x0a,
	0x10, 0x4c, 0x49, 0x46, 0x45, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x52, 0x45, 0x54, 0x55, 0x52, 0x4e,
	0x53, 0x10, 0x03, 0x1a, 0x8c, 0x02, 0x0a, 0x10, 0x53, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x6c,
	0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x72, 0x65, 0x74, 0x75,
	0x72, 0x6e, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52,
	0x0a, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x44, 0x61, 0x79, 0x73, 0x12, 0x3f, 0x0a, 0x11, 0x72,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x72, 0x65, 0x74,
	0x75, 0x72, 0x6e, 0x55, 0x6e, 0x74, 0x69, 0x6c, 0x44, 0x61, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x05,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x35, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x31,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74,
	0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x22, 0x58, 0x0a, 0x0c, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x54, 0x55, 0x52, 0x4e, 0x5f, 0x4d, 0x45, 0x54,
	0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x59, 0x5f, 0x4d, 0x41, 0x49, 0x4c, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x49, 0x4e, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a,
	0x41, 0x54, 0x5f, 0x41, 0x5f, 0x4b, 0x49, 0x4f, 0x53, 0x4b, 0x10, 0x03, 0x22, 0x42, 0x0a, 0x0d,
	0x49, 0x74, 0x65, 0x6d, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a,
	0x1a, 0x49, 0x54, 0x45, 0x4d, 0x5f, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a,
	0x03, 0x4e, 0x45, 0x57, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x55, 0x53, 0x45, 0x44, 0x10, 0x02,
	0x3a, 0x96, 0x01, 0xea, 0x41, 0x92, 0x01, 0x0a, 0x2d, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x37, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f,
	0x7b, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x2a,
	0x14, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x32, 0x12, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74,
	0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x61, 0x63,
	0x63, 0x65, 0x70, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x72, 0x65, 0x66, 0x75, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x5f, 0x65, 0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x32,
	0xce, 0x04, 0x0a, 0x19, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xe7, 0x01,
	0x0a, 0x15, 0x47, 0x65, 0x74, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75,
	0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4f, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x48, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfd, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x12, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f,
	0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x42, 0x99, 0x01, 0x0a, 0x2c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x42, 0x17, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70,
	0x62, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescData = file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDesc
)

func file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescData)
	})
	return file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDescData
}

var file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_goTypes = []any{
	(OnlineReturnPolicy_ReturnMethod)(0),           // 0: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.ReturnMethod
	(OnlineReturnPolicy_ItemCondition)(0),          // 1: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.ItemCondition
	(OnlineReturnPolicy_ReturnShippingFee_Type)(0), // 2: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.ReturnShippingFee.Type
	(OnlineReturnPolicy_Policy_Type)(0),            // 3: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.Policy.Type
	(*GetOnlineReturnPolicyRequest)(nil),           // 4: google.shopping.merchant.accounts.v1beta.GetOnlineReturnPolicyRequest
	(*ListOnlineReturnPoliciesRequest)(nil),        // 5: google.shopping.merchant.accounts.v1beta.ListOnlineReturnPoliciesRequest
	(*ListOnlineReturnPoliciesResponse)(nil),       // 6: google.shopping.merchant.accounts.v1beta.ListOnlineReturnPoliciesResponse
	(*OnlineReturnPolicy)(nil),                     // 7: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy
	(*OnlineReturnPolicy_ReturnShippingFee)(nil),   // 8: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.ReturnShippingFee
	(*OnlineReturnPolicy_RestockingFee)(nil),       // 9: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.RestockingFee
	(*OnlineReturnPolicy_Policy)(nil),              // 10: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.Policy
	(*OnlineReturnPolicy_SeasonalOverride)(nil),    // 11: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.SeasonalOverride
	(*typepb.Price)(nil),                           // 12: google.shopping.type.Price
	(*date.Date)(nil),                              // 13: google.type.Date
}
var file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_depIdxs = []int32{
	7,  // 0: google.shopping.merchant.accounts.v1beta.ListOnlineReturnPoliciesResponse.online_return_policies:type_name -> google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy
	10, // 1: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.policy:type_name -> google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.Policy
	11, // 2: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.seasonal_overrides:type_name -> google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.SeasonalOverride
	9,  // 3: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.restocking_fee:type_name -> google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.RestockingFee
	0,  // 4: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.return_methods:type_name -> google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.ReturnMethod
	1,  // 5: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.item_conditions:type_name -> google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.ItemCondition
	8,  // 6: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.return_shipping_fee:type_name -> google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.ReturnShippingFee
	2,  // 7: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.ReturnShippingFee.type:type_name -> google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.ReturnShippingFee.Type
	12, // 8: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.ReturnShippingFee.fixed_fee:type_name -> google.shopping.type.Price
	12, // 9: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.RestockingFee.fixed_fee:type_name -> google.shopping.type.Price
	3,  // 10: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.Policy.type:type_name -> google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.Policy.Type
	13, // 11: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.SeasonalOverride.return_until_date:type_name -> google.type.Date
	13, // 12: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.SeasonalOverride.start_date:type_name -> google.type.Date
	13, // 13: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy.SeasonalOverride.end_date:type_name -> google.type.Date
	4,  // 14: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicyService.GetOnlineReturnPolicy:input_type -> google.shopping.merchant.accounts.v1beta.GetOnlineReturnPolicyRequest
	5,  // 15: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicyService.ListOnlineReturnPolicies:input_type -> google.shopping.merchant.accounts.v1beta.ListOnlineReturnPoliciesRequest
	7,  // 16: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicyService.GetOnlineReturnPolicy:output_type -> google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy
	6,  // 17: google.shopping.merchant.accounts.v1beta.OnlineReturnPolicyService.ListOnlineReturnPolicies:output_type -> google.shopping.merchant.accounts.v1beta.ListOnlineReturnPoliciesResponse
	16, // [16:18] is the sub-list for method output_type
	14, // [14:16] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_init() }
func file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_init() {
	if File_google_shopping_merchant_accounts_v1beta_online_return_policy_proto != nil {
		return
	}
	file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[3].OneofWrappers = []any{}
	file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[5].OneofWrappers = []any{
		(*OnlineReturnPolicy_RestockingFee_FixedFee)(nil),
		(*OnlineReturnPolicy_RestockingFee_MicroPercent)(nil),
	}
	file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes[7].OneofWrappers = []any{
		(*OnlineReturnPolicy_SeasonalOverride_ReturnDays)(nil),
		(*OnlineReturnPolicy_SeasonalOverride_ReturnUntilDate)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_depIdxs,
		EnumInfos:         file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_enumTypes,
		MessageInfos:      file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_accounts_v1beta_online_return_policy_proto = out.File
	file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_rawDesc = nil
	file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_goTypes = nil
	file_google_shopping_merchant_accounts_v1beta_online_return_policy_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// OnlineReturnPolicyServiceClient is the client API for OnlineReturnPolicyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type OnlineReturnPolicyServiceClient interface {
	// Gets an existing return policy for a given business.
	GetOnlineReturnPolicy(ctx context.Context, in *GetOnlineReturnPolicyRequest, opts ...grpc.CallOption) (*OnlineReturnPolicy, error)
	// Lists all existing return policies for a given business.
	ListOnlineReturnPolicies(ctx context.Context, in *ListOnlineReturnPoliciesRequest, opts ...grpc.CallOption) (*ListOnlineReturnPoliciesResponse, error)
}

type onlineReturnPolicyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewOnlineReturnPolicyServiceClient(cc grpc.ClientConnInterface) OnlineReturnPolicyServiceClient {
	return &onlineReturnPolicyServiceClient{cc}
}

func (c *onlineReturnPolicyServiceClient) GetOnlineReturnPolicy(ctx context.Context, in *GetOnlineReturnPolicyRequest, opts ...grpc.CallOption) (*OnlineReturnPolicy, error) {
	out := new(OnlineReturnPolicy)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.OnlineReturnPolicyService/GetOnlineReturnPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *onlineReturnPolicyServiceClient) ListOnlineReturnPolicies(ctx context.Context, in *ListOnlineReturnPoliciesRequest, opts ...grpc.CallOption) (*ListOnlineReturnPoliciesResponse, error) {
	out := new(ListOnlineReturnPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.OnlineReturnPolicyService/ListOnlineReturnPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OnlineReturnPolicyServiceServer is the server API for OnlineReturnPolicyService service.
type OnlineReturnPolicyServiceServer interface {
	// Gets an existing return policy for a given business.
	GetOnlineReturnPolicy(context.Context, *GetOnlineReturnPolicyRequest) (*OnlineReturnPolicy, error)
	// Lists all existing return policies for a given business.
	ListOnlineReturnPolicies(context.Context, *ListOnlineReturnPoliciesRequest) (*ListOnlineReturnPoliciesResponse, error)
}

// UnimplementedOnlineReturnPolicyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedOnlineReturnPolicyServiceServer struct {
}

func (*UnimplementedOnlineReturnPolicyServiceServer) GetOnlineReturnPolicy(context.Context, *GetOnlineReturnPolicyRequest) (*OnlineReturnPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOnlineReturnPolicy not implemented")
}
func (*UnimplementedOnlineReturnPolicyServiceServer) ListOnlineReturnPolicies(context.Context, *ListOnlineReturnPoliciesRequest) (*ListOnlineReturnPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOnlineReturnPolicies not implemented")
}

func RegisterOnlineReturnPolicyServiceServer(s *grpc.Server, srv OnlineReturnPolicyServiceServer) {
	s.RegisterService(&_OnlineReturnPolicyService_serviceDesc, srv)
}

func _OnlineReturnPolicyService_GetOnlineReturnPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOnlineReturnPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OnlineReturnPolicyServiceServer).GetOnlineReturnPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.OnlineReturnPolicyService/GetOnlineReturnPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OnlineReturnPolicyServiceServer).GetOnlineReturnPolicy(ctx, req.(*GetOnlineReturnPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OnlineReturnPolicyService_ListOnlineReturnPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOnlineReturnPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OnlineReturnPolicyServiceServer).ListOnlineReturnPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.OnlineReturnPolicyService/ListOnlineReturnPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OnlineReturnPolicyServiceServer).ListOnlineReturnPolicies(ctx, req.(*ListOnlineReturnPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OnlineReturnPolicyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.accounts.v1beta.OnlineReturnPolicyService",
	HandlerType: (*OnlineReturnPolicyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetOnlineReturnPolicy",
			Handler:    _OnlineReturnPolicyService_GetOnlineReturnPolicy_Handler,
		},
		{
			MethodName: "ListOnlineReturnPolicies",
			Handler:    _OnlineReturnPolicyService_ListOnlineReturnPolicies_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/accounts/v1beta/online_return_policy.proto",
}
