// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/video/transcoder/v1/resources.proto

package transcoderpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of the job.
type Job_ProcessingState int32

const (
	// The processing state is not specified.
	Job_PROCESSING_STATE_UNSPECIFIED Job_ProcessingState = 0
	// The job is enqueued and will be picked up for processing soon.
	Job_PENDING Job_ProcessingState = 1
	// The job is being processed.
	Job_RUNNING Job_ProcessingState = 2
	// The job has been completed successfully.
	Job_SUCCEEDED Job_ProcessingState = 3
	// The job has failed. For additional information, see `failure_reason` and
	// `failure_details`
	Job_FAILED Job_ProcessingState = 4
)

// Enum value maps for Job_ProcessingState.
var (
	Job_ProcessingState_name = map[int32]string{
		0: "PROCESSING_STATE_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "FAILED",
	}
	Job_ProcessingState_value = map[string]int32{
		"PROCESSING_STATE_UNSPECIFIED": 0,
		"PENDING":                      1,
		"RUNNING":                      2,
		"SUCCEEDED":                    3,
		"FAILED":                       4,
	}
)

func (x Job_ProcessingState) Enum() *Job_ProcessingState {
	p := new(Job_ProcessingState)
	*p = x
	return p
}

func (x Job_ProcessingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Job_ProcessingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[0].Descriptor()
}

func (Job_ProcessingState) Type() protoreflect.EnumType {
	return &file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[0]
}

func (x Job_ProcessingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Job_ProcessingState.Descriptor instead.
func (Job_ProcessingState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

// The processing mode of the job.
type Job_ProcessingMode int32

const (
	// The job processing mode is not specified.
	Job_PROCESSING_MODE_UNSPECIFIED Job_ProcessingMode = 0
	// The job processing mode is interactive mode.
	// Interactive job will either be ran or rejected if quota does not allow
	// for it.
	Job_PROCESSING_MODE_INTERACTIVE Job_ProcessingMode = 1
	// The job processing mode is batch mode.
	// Batch mode allows queuing of jobs.
	Job_PROCESSING_MODE_BATCH Job_ProcessingMode = 2
)

// Enum value maps for Job_ProcessingMode.
var (
	Job_ProcessingMode_name = map[int32]string{
		0: "PROCESSING_MODE_UNSPECIFIED",
		1: "PROCESSING_MODE_INTERACTIVE",
		2: "PROCESSING_MODE_BATCH",
	}
	Job_ProcessingMode_value = map[string]int32{
		"PROCESSING_MODE_UNSPECIFIED": 0,
		"PROCESSING_MODE_INTERACTIVE": 1,
		"PROCESSING_MODE_BATCH":       2,
	}
)

func (x Job_ProcessingMode) Enum() *Job_ProcessingMode {
	p := new(Job_ProcessingMode)
	*p = x
	return p
}

func (x Job_ProcessingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Job_ProcessingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[1].Descriptor()
}

func (Job_ProcessingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[1]
}

func (x Job_ProcessingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Job_ProcessingMode.Descriptor instead.
func (Job_ProcessingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{0, 1}
}

// The optimization strategy of the job. The default is `AUTODETECT`.
type Job_OptimizationStrategy int32

const (
	// The optimization strategy is not specified.
	Job_OPTIMIZATION_STRATEGY_UNSPECIFIED Job_OptimizationStrategy = 0
	// Prioritize job processing speed.
	Job_AUTODETECT Job_OptimizationStrategy = 1
	// Disable all optimizations.
	Job_DISABLED Job_OptimizationStrategy = 2
)

// Enum value maps for Job_OptimizationStrategy.
var (
	Job_OptimizationStrategy_name = map[int32]string{
		0: "OPTIMIZATION_STRATEGY_UNSPECIFIED",
		1: "AUTODETECT",
		2: "DISABLED",
	}
	Job_OptimizationStrategy_value = map[string]int32{
		"OPTIMIZATION_STRATEGY_UNSPECIFIED": 0,
		"AUTODETECT":                        1,
		"DISABLED":                          2,
	}
)

func (x Job_OptimizationStrategy) Enum() *Job_OptimizationStrategy {
	p := new(Job_OptimizationStrategy)
	*p = x
	return p
}

func (x Job_OptimizationStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Job_OptimizationStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[2].Descriptor()
}

func (Job_OptimizationStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[2]
}

func (x Job_OptimizationStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Job_OptimizationStrategy.Descriptor instead.
func (Job_OptimizationStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{0, 2}
}

// The manifest type, which corresponds to the adaptive streaming format used.
type Manifest_ManifestType int32

const (
	// The manifest type is not specified.
	Manifest_MANIFEST_TYPE_UNSPECIFIED Manifest_ManifestType = 0
	// Create an HLS manifest. The corresponding file extension is `.m3u8`.
	Manifest_HLS Manifest_ManifestType = 1
	// Create an MPEG-DASH manifest. The corresponding file extension is `.mpd`.
	Manifest_DASH Manifest_ManifestType = 2
)

// Enum value maps for Manifest_ManifestType.
var (
	Manifest_ManifestType_name = map[int32]string{
		0: "MANIFEST_TYPE_UNSPECIFIED",
		1: "HLS",
		2: "DASH",
	}
	Manifest_ManifestType_value = map[string]int32{
		"MANIFEST_TYPE_UNSPECIFIED": 0,
		"HLS":                       1,
		"DASH":                      2,
	}
)

func (x Manifest_ManifestType) Enum() *Manifest_ManifestType {
	p := new(Manifest_ManifestType)
	*p = x
	return p
}

func (x Manifest_ManifestType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Manifest_ManifestType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[3].Descriptor()
}

func (Manifest_ManifestType) Type() protoreflect.EnumType {
	return &file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[3]
}

func (x Manifest_ManifestType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Manifest_ManifestType.Descriptor instead.
func (Manifest_ManifestType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{9, 0}
}

// The segment reference scheme for a `DASH` manifest.
type Manifest_DashConfig_SegmentReferenceScheme int32

const (
	// The segment reference scheme is not specified.
	Manifest_DashConfig_SEGMENT_REFERENCE_SCHEME_UNSPECIFIED Manifest_DashConfig_SegmentReferenceScheme = 0
	// Lists the URLs of media files for each segment.
	Manifest_DashConfig_SEGMENT_LIST Manifest_DashConfig_SegmentReferenceScheme = 1
	// Lists each segment from a template with $Number$ variable.
	Manifest_DashConfig_SEGMENT_TEMPLATE_NUMBER Manifest_DashConfig_SegmentReferenceScheme = 2
)

// Enum value maps for Manifest_DashConfig_SegmentReferenceScheme.
var (
	Manifest_DashConfig_SegmentReferenceScheme_name = map[int32]string{
		0: "SEGMENT_REFERENCE_SCHEME_UNSPECIFIED",
		1: "SEGMENT_LIST",
		2: "SEGMENT_TEMPLATE_NUMBER",
	}
	Manifest_DashConfig_SegmentReferenceScheme_value = map[string]int32{
		"SEGMENT_REFERENCE_SCHEME_UNSPECIFIED": 0,
		"SEGMENT_LIST":                         1,
		"SEGMENT_TEMPLATE_NUMBER":              2,
	}
)

func (x Manifest_DashConfig_SegmentReferenceScheme) Enum() *Manifest_DashConfig_SegmentReferenceScheme {
	p := new(Manifest_DashConfig_SegmentReferenceScheme)
	*p = x
	return p
}

func (x Manifest_DashConfig_SegmentReferenceScheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Manifest_DashConfig_SegmentReferenceScheme) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[4].Descriptor()
}

func (Manifest_DashConfig_SegmentReferenceScheme) Type() protoreflect.EnumType {
	return &file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[4]
}

func (x Manifest_DashConfig_SegmentReferenceScheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Manifest_DashConfig_SegmentReferenceScheme.Descriptor instead.
func (Manifest_DashConfig_SegmentReferenceScheme) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{9, 0, 0}
}

// Fade type for the overlay: `FADE_IN` or `FADE_OUT`.
type Overlay_FadeType int32

const (
	// The fade type is not specified.
	Overlay_FADE_TYPE_UNSPECIFIED Overlay_FadeType = 0
	// Fade the overlay object into view.
	Overlay_FADE_IN Overlay_FadeType = 1
	// Fade the overlay object out of view.
	Overlay_FADE_OUT Overlay_FadeType = 2
)

// Enum value maps for Overlay_FadeType.
var (
	Overlay_FadeType_name = map[int32]string{
		0: "FADE_TYPE_UNSPECIFIED",
		1: "FADE_IN",
		2: "FADE_OUT",
	}
	Overlay_FadeType_value = map[string]int32{
		"FADE_TYPE_UNSPECIFIED": 0,
		"FADE_IN":               1,
		"FADE_OUT":              2,
	}
)

func (x Overlay_FadeType) Enum() *Overlay_FadeType {
	p := new(Overlay_FadeType)
	*p = x
	return p
}

func (x Overlay_FadeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Overlay_FadeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[5].Descriptor()
}

func (Overlay_FadeType) Type() protoreflect.EnumType {
	return &file_google_cloud_video_transcoder_v1_resources_proto_enumTypes[5]
}

func (x Overlay_FadeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Overlay_FadeType.Descriptor instead.
func (Overlay_FadeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{12, 0}
}

// Transcoding job resource.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the job.
	// Format: `projects/{project_number}/locations/{location}/jobs/{job}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Input only. Specify the `input_uri` to populate empty `uri` fields in each
	// element of `Job.config.inputs` or `JobTemplate.config.inputs` when using
	// template. URI of the media. Input files must be at least 5 seconds in
	// duration and stored in Cloud Storage (for example,
	// `gs://bucket/inputs/file.mp4`). See [Supported input and output
	// formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
	InputUri string `protobuf:"bytes,2,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Input only. Specify the `output_uri` to populate an empty
	// `Job.config.output.uri` or `JobTemplate.config.output.uri` when using
	// template. URI for the output file(s). For example,
	// `gs://my-bucket/outputs/`. See [Supported input and output
	// formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
	OutputUri string `protobuf:"bytes,3,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Specify the `job_config` for the transcoding job. If you don't specify the
	// `job_config`, the API selects `templateId`; this template ID is set to
	// `preset/web-hd` by default. When you use a `template_id` to create a job,
	// the `Job.config` is populated by the `JobTemplate.config`.<br>
	//
	// Types that are assignable to JobConfig:
	//
	//	*Job_TemplateId
	//	*Job_Config
	JobConfig isJob_JobConfig `protobuf_oneof:"job_config"`
	// Output only. The current state of the job.
	State Job_ProcessingState `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.video.transcoder.v1.Job_ProcessingState" json:"state,omitempty"`
	// Output only. The time the job was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the transcoding started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time the transcoding finished.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Job time to live value in days, which will be effective after job
	// completion. Job should be deleted automatically after the given TTL. Enter
	// a value between 1 and 90. The default is 30.
	TtlAfterCompletionDays int32 `protobuf:"varint,15,opt,name=ttl_after_completion_days,json=ttlAfterCompletionDays,proto3" json:"ttl_after_completion_days,omitempty"`
	// The labels associated with this job. You can use these to organize and
	// group your jobs.
	Labels map[string]string `protobuf:"bytes,16,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. An error object that describes the reason for the failure.
	// This property is always present when `state` is `FAILED`.
	Error *status.Status `protobuf:"bytes,17,opt,name=error,proto3" json:"error,omitempty"`
	// The processing mode of the job.
	// The default is `PROCESSING_MODE_INTERACTIVE`.
	Mode Job_ProcessingMode `protobuf:"varint,20,opt,name=mode,proto3,enum=google.cloud.video.transcoder.v1.Job_ProcessingMode" json:"mode,omitempty"`
	// The processing priority of a batch job.
	// This field can only be set for batch mode jobs. The default value is 0.
	// This value cannot be negative. Higher values correspond to higher
	// priorities for the job.
	BatchModePriority int32 `protobuf:"varint,21,opt,name=batch_mode_priority,json=batchModePriority,proto3" json:"batch_mode_priority,omitempty"`
	// Optional. The optimization strategy of the job. The default is
	// `AUTODETECT`.
	Optimization Job_OptimizationStrategy `protobuf:"varint,22,opt,name=optimization,proto3,enum=google.cloud.video.transcoder.v1.Job_OptimizationStrategy" json:"optimization,omitempty"`
}

func (x *Job) Reset() {
	*x = Job{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Job) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Job) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

func (x *Job) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

func (m *Job) GetJobConfig() isJob_JobConfig {
	if m != nil {
		return m.JobConfig
	}
	return nil
}

func (x *Job) GetTemplateId() string {
	if x, ok := x.GetJobConfig().(*Job_TemplateId); ok {
		return x.TemplateId
	}
	return ""
}

func (x *Job) GetConfig() *JobConfig {
	if x, ok := x.GetJobConfig().(*Job_Config); ok {
		return x.Config
	}
	return nil
}

func (x *Job) GetState() Job_ProcessingState {
	if x != nil {
		return x.State
	}
	return Job_PROCESSING_STATE_UNSPECIFIED
}

func (x *Job) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Job) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Job) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Job) GetTtlAfterCompletionDays() int32 {
	if x != nil {
		return x.TtlAfterCompletionDays
	}
	return 0
}

func (x *Job) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Job) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *Job) GetMode() Job_ProcessingMode {
	if x != nil {
		return x.Mode
	}
	return Job_PROCESSING_MODE_UNSPECIFIED
}

func (x *Job) GetBatchModePriority() int32 {
	if x != nil {
		return x.BatchModePriority
	}
	return 0
}

func (x *Job) GetOptimization() Job_OptimizationStrategy {
	if x != nil {
		return x.Optimization
	}
	return Job_OPTIMIZATION_STRATEGY_UNSPECIFIED
}

type isJob_JobConfig interface {
	isJob_JobConfig()
}

type Job_TemplateId struct {
	// Input only. Specify the `template_id` to use for populating `Job.config`.
	// The default is `preset/web-hd`, which is the only supported preset.
	//
	// User defined JobTemplate: `{job_template_id}`
	TemplateId string `protobuf:"bytes,4,opt,name=template_id,json=templateId,proto3,oneof"`
}

type Job_Config struct {
	// The configuration for this job.
	Config *JobConfig `protobuf:"bytes,5,opt,name=config,proto3,oneof"`
}

func (*Job_TemplateId) isJob_JobConfig() {}

func (*Job_Config) isJob_JobConfig() {}

// Transcoding job template resource.
type JobTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the job template.
	// Format:
	// `projects/{project_number}/locations/{location}/jobTemplates/{job_template}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The configuration for this template.
	Config *JobConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// The labels associated with this job template. You can use these to organize
	// and group your job templates.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *JobTemplate) Reset() {
	*x = JobTemplate{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JobTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobTemplate) ProtoMessage() {}

func (x *JobTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobTemplate.ProtoReflect.Descriptor instead.
func (*JobTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *JobTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *JobTemplate) GetConfig() *JobConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *JobTemplate) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Job configuration
type JobConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of input assets stored in Cloud Storage.
	Inputs []*Input `protobuf:"bytes,1,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// List of `Edit atom`s. Defines the ultimate timeline of the resulting
	// file or manifest.
	EditList []*EditAtom `protobuf:"bytes,2,rep,name=edit_list,json=editList,proto3" json:"edit_list,omitempty"`
	// List of elementary streams.
	ElementaryStreams []*ElementaryStream `protobuf:"bytes,3,rep,name=elementary_streams,json=elementaryStreams,proto3" json:"elementary_streams,omitempty"`
	// List of multiplexing settings for output streams.
	MuxStreams []*MuxStream `protobuf:"bytes,4,rep,name=mux_streams,json=muxStreams,proto3" json:"mux_streams,omitempty"`
	// List of output manifests.
	Manifests []*Manifest `protobuf:"bytes,5,rep,name=manifests,proto3" json:"manifests,omitempty"`
	// Output configuration.
	Output *Output `protobuf:"bytes,6,opt,name=output,proto3" json:"output,omitempty"`
	// List of ad breaks. Specifies where to insert ad break tags in the output
	// manifests.
	AdBreaks []*AdBreak `protobuf:"bytes,7,rep,name=ad_breaks,json=adBreaks,proto3" json:"ad_breaks,omitempty"`
	// Destination on Pub/Sub.
	PubsubDestination *PubsubDestination `protobuf:"bytes,8,opt,name=pubsub_destination,json=pubsubDestination,proto3" json:"pubsub_destination,omitempty"`
	// List of output sprite sheets.
	// Spritesheets require at least one VideoStream in the Jobconfig.
	SpriteSheets []*SpriteSheet `protobuf:"bytes,9,rep,name=sprite_sheets,json=spriteSheets,proto3" json:"sprite_sheets,omitempty"`
	// List of overlays on the output video, in descending Z-order.
	Overlays []*Overlay `protobuf:"bytes,10,rep,name=overlays,proto3" json:"overlays,omitempty"`
	// List of encryption configurations for the content.
	// Each configuration has an ID. Specify this ID in the
	// [MuxStream.encryption_id][google.cloud.video.transcoder.v1.MuxStream.encryption_id]
	// field to indicate the configuration to use for that `MuxStream` output.
	Encryptions []*Encryption `protobuf:"bytes,11,rep,name=encryptions,proto3" json:"encryptions,omitempty"`
}

func (x *JobConfig) Reset() {
	*x = JobConfig{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JobConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobConfig) ProtoMessage() {}

func (x *JobConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobConfig.ProtoReflect.Descriptor instead.
func (*JobConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *JobConfig) GetInputs() []*Input {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *JobConfig) GetEditList() []*EditAtom {
	if x != nil {
		return x.EditList
	}
	return nil
}

func (x *JobConfig) GetElementaryStreams() []*ElementaryStream {
	if x != nil {
		return x.ElementaryStreams
	}
	return nil
}

func (x *JobConfig) GetMuxStreams() []*MuxStream {
	if x != nil {
		return x.MuxStreams
	}
	return nil
}

func (x *JobConfig) GetManifests() []*Manifest {
	if x != nil {
		return x.Manifests
	}
	return nil
}

func (x *JobConfig) GetOutput() *Output {
	if x != nil {
		return x.Output
	}
	return nil
}

func (x *JobConfig) GetAdBreaks() []*AdBreak {
	if x != nil {
		return x.AdBreaks
	}
	return nil
}

func (x *JobConfig) GetPubsubDestination() *PubsubDestination {
	if x != nil {
		return x.PubsubDestination
	}
	return nil
}

func (x *JobConfig) GetSpriteSheets() []*SpriteSheet {
	if x != nil {
		return x.SpriteSheets
	}
	return nil
}

func (x *JobConfig) GetOverlays() []*Overlay {
	if x != nil {
		return x.Overlays
	}
	return nil
}

func (x *JobConfig) GetEncryptions() []*Encryption {
	if x != nil {
		return x.Encryptions
	}
	return nil
}

// Input asset.
type Input struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this input. Must be specified when using advanced
	// mapping and edit lists.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// URI of the media. Input files must be at least 5 seconds in duration and
	// stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`).
	// If empty, the value is populated from `Job.input_uri`. See
	// [Supported input and output
	// formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Preprocessing configurations.
	PreprocessingConfig *PreprocessingConfig `protobuf:"bytes,3,opt,name=preprocessing_config,json=preprocessingConfig,proto3" json:"preprocessing_config,omitempty"`
}

func (x *Input) Reset() {
	*x = Input{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Input) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Input) ProtoMessage() {}

func (x *Input) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Input.ProtoReflect.Descriptor instead.
func (*Input) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *Input) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Input) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Input) GetPreprocessingConfig() *PreprocessingConfig {
	if x != nil {
		return x.PreprocessingConfig
	}
	return nil
}

// Location of output file(s) in a Cloud Storage bucket.
type Output struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI for the output file(s). For example, `gs://my-bucket/outputs/`.
	// If empty, the value is populated from `Job.output_uri`. See
	// [Supported input and output
	// formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Output) Reset() {
	*x = Output{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Output) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Output) ProtoMessage() {}

func (x *Output) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Output.ProtoReflect.Descriptor instead.
func (*Output) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *Output) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Edit atom.
type EditAtom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this atom. Must be specified when using advanced
	// mapping.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// List of `Input.key`s identifying files that should be used in this atom.
	// The listed `inputs` must have the same timeline.
	Inputs []string `protobuf:"bytes,2,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// End time in seconds for the atom, relative to the input file timeline.
	// When `end_time_offset` is not specified, the `inputs` are used until
	// the end of the atom.
	EndTimeOffset *durationpb.Duration `protobuf:"bytes,3,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	// Start time in seconds for the atom, relative to the input file timeline.
	// The default is `0s`.
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,4,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
}

func (x *EditAtom) Reset() {
	*x = EditAtom{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EditAtom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EditAtom) ProtoMessage() {}

func (x *EditAtom) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EditAtom.ProtoReflect.Descriptor instead.
func (*EditAtom) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *EditAtom) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *EditAtom) GetInputs() []string {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *EditAtom) GetEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.EndTimeOffset
	}
	return nil
}

func (x *EditAtom) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

// Ad break.
type AdBreak struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start time in seconds for the ad break, relative to the output file
	// timeline. The default is `0s`.
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
}

func (x *AdBreak) Reset() {
	*x = AdBreak{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdBreak) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdBreak) ProtoMessage() {}

func (x *AdBreak) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdBreak.ProtoReflect.Descriptor instead.
func (*AdBreak) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *AdBreak) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

// Encoding of an input file such as an audio, video, or text track.
// Elementary streams must be packaged before
// mapping and sharing between different output formats.
type ElementaryStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this elementary stream.
	Key string `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	// Encoding of an audio, video, or text track.
	//
	// Types that are assignable to ElementaryStream:
	//
	//	*ElementaryStream_VideoStream
	//	*ElementaryStream_AudioStream
	//	*ElementaryStream_TextStream
	ElementaryStream isElementaryStream_ElementaryStream `protobuf_oneof:"elementary_stream"`
}

func (x *ElementaryStream) Reset() {
	*x = ElementaryStream{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ElementaryStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ElementaryStream) ProtoMessage() {}

func (x *ElementaryStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ElementaryStream.ProtoReflect.Descriptor instead.
func (*ElementaryStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *ElementaryStream) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (m *ElementaryStream) GetElementaryStream() isElementaryStream_ElementaryStream {
	if m != nil {
		return m.ElementaryStream
	}
	return nil
}

func (x *ElementaryStream) GetVideoStream() *VideoStream {
	if x, ok := x.GetElementaryStream().(*ElementaryStream_VideoStream); ok {
		return x.VideoStream
	}
	return nil
}

func (x *ElementaryStream) GetAudioStream() *AudioStream {
	if x, ok := x.GetElementaryStream().(*ElementaryStream_AudioStream); ok {
		return x.AudioStream
	}
	return nil
}

func (x *ElementaryStream) GetTextStream() *TextStream {
	if x, ok := x.GetElementaryStream().(*ElementaryStream_TextStream); ok {
		return x.TextStream
	}
	return nil
}

type isElementaryStream_ElementaryStream interface {
	isElementaryStream_ElementaryStream()
}

type ElementaryStream_VideoStream struct {
	// Encoding of a video stream.
	VideoStream *VideoStream `protobuf:"bytes,1,opt,name=video_stream,json=videoStream,proto3,oneof"`
}

type ElementaryStream_AudioStream struct {
	// Encoding of an audio stream.
	AudioStream *AudioStream `protobuf:"bytes,2,opt,name=audio_stream,json=audioStream,proto3,oneof"`
}

type ElementaryStream_TextStream struct {
	// Encoding of a text stream. For example, closed captions or subtitles.
	TextStream *TextStream `protobuf:"bytes,3,opt,name=text_stream,json=textStream,proto3,oneof"`
}

func (*ElementaryStream_VideoStream) isElementaryStream_ElementaryStream() {}

func (*ElementaryStream_AudioStream) isElementaryStream_ElementaryStream() {}

func (*ElementaryStream_TextStream) isElementaryStream_ElementaryStream() {}

// Multiplexing settings for output stream.
type MuxStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this multiplexed stream. HLS media manifests will be
	// named `MuxStream.key` with the `.m3u8` extension suffix.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The name of the generated file. The default is `MuxStream.key` with the
	// extension suffix corresponding to the `MuxStream.container`.
	//
	// Individual segments also have an incremental 10-digit zero-padded suffix
	// starting from 0 before the extension, such as `mux_stream0000000123.ts`.
	FileName string `protobuf:"bytes,2,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// The container format. The default is `mp4`
	//
	// Supported container formats:
	//
	// - `ts`
	// - `fmp4`- the corresponding file extension is `.m4s`
	// - `mp4`
	// - `vtt`
	//
	// See also:
	// [Supported input and output
	// formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
	Container string `protobuf:"bytes,3,opt,name=container,proto3" json:"container,omitempty"`
	// List of `ElementaryStream.key`s multiplexed in this stream.
	ElementaryStreams []string `protobuf:"bytes,4,rep,name=elementary_streams,json=elementaryStreams,proto3" json:"elementary_streams,omitempty"`
	// Segment settings for `ts`, `fmp4` and `vtt`.
	SegmentSettings *SegmentSettings `protobuf:"bytes,5,opt,name=segment_settings,json=segmentSettings,proto3" json:"segment_settings,omitempty"`
	// Identifier of the encryption configuration to use. If omitted, output will
	// be unencrypted.
	EncryptionId string `protobuf:"bytes,7,opt,name=encryption_id,json=encryptionId,proto3" json:"encryption_id,omitempty"`
}

func (x *MuxStream) Reset() {
	*x = MuxStream{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MuxStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuxStream) ProtoMessage() {}

func (x *MuxStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuxStream.ProtoReflect.Descriptor instead.
func (*MuxStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *MuxStream) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *MuxStream) GetFileName() string {
	if x != nil {
		return x.FileName
	}
	return ""
}

func (x *MuxStream) GetContainer() string {
	if x != nil {
		return x.Container
	}
	return ""
}

func (x *MuxStream) GetElementaryStreams() []string {
	if x != nil {
		return x.ElementaryStreams
	}
	return nil
}

func (x *MuxStream) GetSegmentSettings() *SegmentSettings {
	if x != nil {
		return x.SegmentSettings
	}
	return nil
}

func (x *MuxStream) GetEncryptionId() string {
	if x != nil {
		return x.EncryptionId
	}
	return ""
}

// Manifest configuration.
type Manifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the generated file. The default is `manifest` with the
	// extension suffix corresponding to the `Manifest.type`.
	FileName string `protobuf:"bytes,1,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// Required. Type of the manifest.
	Type Manifest_ManifestType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.video.transcoder.v1.Manifest_ManifestType" json:"type,omitempty"`
	// Required. List of user given `MuxStream.key`s that should appear in this
	// manifest.
	//
	// When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
	// and `.m3u8` extension is generated for each element of the
	// `Manifest.mux_streams`.
	MuxStreams []string `protobuf:"bytes,3,rep,name=mux_streams,json=muxStreams,proto3" json:"mux_streams,omitempty"`
	// Specifies the manifest configuration.
	//
	// Types that are assignable to ManifestConfig:
	//
	//	*Manifest_Dash
	ManifestConfig isManifest_ManifestConfig `protobuf_oneof:"manifest_config"`
}

func (x *Manifest) Reset() {
	*x = Manifest{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Manifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Manifest) ProtoMessage() {}

func (x *Manifest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Manifest.ProtoReflect.Descriptor instead.
func (*Manifest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{9}
}

func (x *Manifest) GetFileName() string {
	if x != nil {
		return x.FileName
	}
	return ""
}

func (x *Manifest) GetType() Manifest_ManifestType {
	if x != nil {
		return x.Type
	}
	return Manifest_MANIFEST_TYPE_UNSPECIFIED
}

func (x *Manifest) GetMuxStreams() []string {
	if x != nil {
		return x.MuxStreams
	}
	return nil
}

func (m *Manifest) GetManifestConfig() isManifest_ManifestConfig {
	if m != nil {
		return m.ManifestConfig
	}
	return nil
}

func (x *Manifest) GetDash() *Manifest_DashConfig {
	if x, ok := x.GetManifestConfig().(*Manifest_Dash); ok {
		return x.Dash
	}
	return nil
}

type isManifest_ManifestConfig interface {
	isManifest_ManifestConfig()
}

type Manifest_Dash struct {
	// `DASH` manifest configuration.
	Dash *Manifest_DashConfig `protobuf:"bytes,4,opt,name=dash,proto3,oneof"`
}

func (*Manifest_Dash) isManifest_ManifestConfig() {}

// A Pub/Sub destination.
type PubsubDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Pub/Sub topic to publish job completion notification
	// to. For example: `projects/{project}/topics/{topic}`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *PubsubDestination) Reset() {
	*x = PubsubDestination{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PubsubDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubsubDestination) ProtoMessage() {}

func (x *PubsubDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubsubDestination.ProtoReflect.Descriptor instead.
func (*PubsubDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{10}
}

func (x *PubsubDestination) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// Sprite sheet configuration.
type SpriteSheet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Format type. The default is `jpeg`.
	//
	// Supported formats:
	//
	// - `jpeg`
	Format string `protobuf:"bytes,1,opt,name=format,proto3" json:"format,omitempty"`
	// Required. File name prefix for the generated sprite sheets.
	//
	// Each sprite sheet has an incremental 10-digit zero-padded suffix starting
	// from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
	FilePrefix string `protobuf:"bytes,2,opt,name=file_prefix,json=filePrefix,proto3" json:"file_prefix,omitempty"`
	// Required. The width of sprite in pixels. Must be an even integer. To
	// preserve the source aspect ratio, set the
	// [SpriteSheet.sprite_width_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_width_pixels]
	// field or the
	// [SpriteSheet.sprite_height_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_height_pixels]
	// field, but not both (the API will automatically calculate the missing
	// field).
	//
	// For portrait videos that contain horizontal ASR and rotation metadata,
	// provide the width, in pixels, per the horizontal ASR. The API calculates
	// the height per the horizontal ASR. The API detects any rotation metadata
	// and swaps the requested height and width for the output.
	SpriteWidthPixels int32 `protobuf:"varint,3,opt,name=sprite_width_pixels,json=spriteWidthPixels,proto3" json:"sprite_width_pixels,omitempty"`
	// Required. The height of sprite in pixels. Must be an even integer. To
	// preserve the source aspect ratio, set the
	// [SpriteSheet.sprite_height_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_height_pixels]
	// field or the
	// [SpriteSheet.sprite_width_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_width_pixels]
	// field, but not both (the API will automatically calculate the missing
	// field).
	//
	// For portrait videos that contain horizontal ASR and rotation metadata,
	// provide the height, in pixels, per the horizontal ASR. The API calculates
	// the width per the horizontal ASR. The API detects any rotation metadata
	// and swaps the requested height and width for the output.
	SpriteHeightPixels int32 `protobuf:"varint,4,opt,name=sprite_height_pixels,json=spriteHeightPixels,proto3" json:"sprite_height_pixels,omitempty"`
	// The maximum number of sprites per row in a sprite sheet. The default is 0,
	// which indicates no maximum limit.
	ColumnCount int32 `protobuf:"varint,5,opt,name=column_count,json=columnCount,proto3" json:"column_count,omitempty"`
	// The maximum number of rows per sprite sheet. When the sprite sheet is full,
	// a new sprite sheet is created. The default is 0, which indicates no maximum
	// limit.
	RowCount int32 `protobuf:"varint,6,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// Start time in seconds, relative to the output file timeline. Determines the
	// first sprite to pick. The default is `0s`.
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,7,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// End time in seconds, relative to the output file timeline. When
	// `end_time_offset` is not specified, the sprites are generated until the end
	// of the output file.
	EndTimeOffset *durationpb.Duration `protobuf:"bytes,8,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	// Specify either total number of sprites or interval to create sprites.
	//
	// Types that are assignable to ExtractionStrategy:
	//
	//	*SpriteSheet_TotalCount
	//	*SpriteSheet_Interval
	ExtractionStrategy isSpriteSheet_ExtractionStrategy `protobuf_oneof:"extraction_strategy"`
	// The quality of the generated sprite sheet. Enter a value between 1
	// and 100, where 1 is the lowest quality and 100 is the highest quality.
	// The default is 100. A high quality value corresponds to a low image data
	// compression ratio.
	Quality int32 `protobuf:"varint,11,opt,name=quality,proto3" json:"quality,omitempty"`
}

func (x *SpriteSheet) Reset() {
	*x = SpriteSheet{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpriteSheet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpriteSheet) ProtoMessage() {}

func (x *SpriteSheet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpriteSheet.ProtoReflect.Descriptor instead.
func (*SpriteSheet) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{11}
}

func (x *SpriteSheet) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *SpriteSheet) GetFilePrefix() string {
	if x != nil {
		return x.FilePrefix
	}
	return ""
}

func (x *SpriteSheet) GetSpriteWidthPixels() int32 {
	if x != nil {
		return x.SpriteWidthPixels
	}
	return 0
}

func (x *SpriteSheet) GetSpriteHeightPixels() int32 {
	if x != nil {
		return x.SpriteHeightPixels
	}
	return 0
}

func (x *SpriteSheet) GetColumnCount() int32 {
	if x != nil {
		return x.ColumnCount
	}
	return 0
}

func (x *SpriteSheet) GetRowCount() int32 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *SpriteSheet) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

func (x *SpriteSheet) GetEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.EndTimeOffset
	}
	return nil
}

func (m *SpriteSheet) GetExtractionStrategy() isSpriteSheet_ExtractionStrategy {
	if m != nil {
		return m.ExtractionStrategy
	}
	return nil
}

func (x *SpriteSheet) GetTotalCount() int32 {
	if x, ok := x.GetExtractionStrategy().(*SpriteSheet_TotalCount); ok {
		return x.TotalCount
	}
	return 0
}

func (x *SpriteSheet) GetInterval() *durationpb.Duration {
	if x, ok := x.GetExtractionStrategy().(*SpriteSheet_Interval); ok {
		return x.Interval
	}
	return nil
}

func (x *SpriteSheet) GetQuality() int32 {
	if x != nil {
		return x.Quality
	}
	return 0
}

type isSpriteSheet_ExtractionStrategy interface {
	isSpriteSheet_ExtractionStrategy()
}

type SpriteSheet_TotalCount struct {
	// Total number of sprites. Create the specified number of sprites
	// distributed evenly across the timeline of the output media. The default
	// is 100.
	TotalCount int32 `protobuf:"varint,9,opt,name=total_count,json=totalCount,proto3,oneof"`
}

type SpriteSheet_Interval struct {
	// Starting from `0s`, create sprites at regular intervals. Specify the
	// interval value in seconds.
	Interval *durationpb.Duration `protobuf:"bytes,10,opt,name=interval,proto3,oneof"`
}

func (*SpriteSheet_TotalCount) isSpriteSheet_ExtractionStrategy() {}

func (*SpriteSheet_Interval) isSpriteSheet_ExtractionStrategy() {}

// Overlay configuration.
type Overlay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Image overlay.
	Image *Overlay_Image `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// List of Animations. The list should be chronological, without any time
	// overlap.
	Animations []*Overlay_Animation `protobuf:"bytes,2,rep,name=animations,proto3" json:"animations,omitempty"`
}

func (x *Overlay) Reset() {
	*x = Overlay{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Overlay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay) ProtoMessage() {}

func (x *Overlay) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay.ProtoReflect.Descriptor instead.
func (*Overlay) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{12}
}

func (x *Overlay) GetImage() *Overlay_Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *Overlay) GetAnimations() []*Overlay_Animation {
	if x != nil {
		return x.Animations
	}
	return nil
}

// Preprocessing configurations.
type PreprocessingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Color preprocessing configuration.
	Color *PreprocessingConfig_Color `protobuf:"bytes,1,opt,name=color,proto3" json:"color,omitempty"`
	// Denoise preprocessing configuration.
	Denoise *PreprocessingConfig_Denoise `protobuf:"bytes,2,opt,name=denoise,proto3" json:"denoise,omitempty"`
	// Deblock preprocessing configuration.
	Deblock *PreprocessingConfig_Deblock `protobuf:"bytes,3,opt,name=deblock,proto3" json:"deblock,omitempty"`
	// Audio preprocessing configuration.
	Audio *PreprocessingConfig_Audio `protobuf:"bytes,4,opt,name=audio,proto3" json:"audio,omitempty"`
	// Specify the video cropping configuration.
	Crop *PreprocessingConfig_Crop `protobuf:"bytes,5,opt,name=crop,proto3" json:"crop,omitempty"`
	// Specify the video pad filter configuration.
	Pad *PreprocessingConfig_Pad `protobuf:"bytes,6,opt,name=pad,proto3" json:"pad,omitempty"`
	// Specify the video deinterlace configuration.
	Deinterlace *PreprocessingConfig_Deinterlace `protobuf:"bytes,7,opt,name=deinterlace,proto3" json:"deinterlace,omitempty"`
}

func (x *PreprocessingConfig) Reset() {
	*x = PreprocessingConfig{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreprocessingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig) ProtoMessage() {}

func (x *PreprocessingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{13}
}

func (x *PreprocessingConfig) GetColor() *PreprocessingConfig_Color {
	if x != nil {
		return x.Color
	}
	return nil
}

func (x *PreprocessingConfig) GetDenoise() *PreprocessingConfig_Denoise {
	if x != nil {
		return x.Denoise
	}
	return nil
}

func (x *PreprocessingConfig) GetDeblock() *PreprocessingConfig_Deblock {
	if x != nil {
		return x.Deblock
	}
	return nil
}

func (x *PreprocessingConfig) GetAudio() *PreprocessingConfig_Audio {
	if x != nil {
		return x.Audio
	}
	return nil
}

func (x *PreprocessingConfig) GetCrop() *PreprocessingConfig_Crop {
	if x != nil {
		return x.Crop
	}
	return nil
}

func (x *PreprocessingConfig) GetPad() *PreprocessingConfig_Pad {
	if x != nil {
		return x.Pad
	}
	return nil
}

func (x *PreprocessingConfig) GetDeinterlace() *PreprocessingConfig_Deinterlace {
	if x != nil {
		return x.Deinterlace
	}
	return nil
}

// Video stream resource.
type VideoStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Codec settings can be h264, h265, or vp9.
	//
	// Types that are assignable to CodecSettings:
	//
	//	*VideoStream_H264
	//	*VideoStream_H265
	//	*VideoStream_Vp9
	CodecSettings isVideoStream_CodecSettings `protobuf_oneof:"codec_settings"`
}

func (x *VideoStream) Reset() {
	*x = VideoStream{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoStream) ProtoMessage() {}

func (x *VideoStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoStream.ProtoReflect.Descriptor instead.
func (*VideoStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{14}
}

func (m *VideoStream) GetCodecSettings() isVideoStream_CodecSettings {
	if m != nil {
		return m.CodecSettings
	}
	return nil
}

func (x *VideoStream) GetH264() *VideoStream_H264CodecSettings {
	if x, ok := x.GetCodecSettings().(*VideoStream_H264); ok {
		return x.H264
	}
	return nil
}

func (x *VideoStream) GetH265() *VideoStream_H265CodecSettings {
	if x, ok := x.GetCodecSettings().(*VideoStream_H265); ok {
		return x.H265
	}
	return nil
}

func (x *VideoStream) GetVp9() *VideoStream_Vp9CodecSettings {
	if x, ok := x.GetCodecSettings().(*VideoStream_Vp9); ok {
		return x.Vp9
	}
	return nil
}

type isVideoStream_CodecSettings interface {
	isVideoStream_CodecSettings()
}

type VideoStream_H264 struct {
	// H264 codec settings.
	H264 *VideoStream_H264CodecSettings `protobuf:"bytes,1,opt,name=h264,proto3,oneof"`
}

type VideoStream_H265 struct {
	// H265 codec settings.
	H265 *VideoStream_H265CodecSettings `protobuf:"bytes,2,opt,name=h265,proto3,oneof"`
}

type VideoStream_Vp9 struct {
	// VP9 codec settings.
	Vp9 *VideoStream_Vp9CodecSettings `protobuf:"bytes,3,opt,name=vp9,proto3,oneof"`
}

func (*VideoStream_H264) isVideoStream_CodecSettings() {}

func (*VideoStream_H265) isVideoStream_CodecSettings() {}

func (*VideoStream_Vp9) isVideoStream_CodecSettings() {}

// Audio stream resource.
type AudioStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The codec for this audio stream. The default is `aac`.
	//
	// Supported audio codecs:
	//
	// - `aac`
	// - `aac-he`
	// - `aac-he-v2`
	// - `mp3`
	// - `ac3`
	// - `eac3`
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// Required. Audio bitrate in bits per second. Must be between 1 and
	// 10,000,000.
	BitrateBps int32 `protobuf:"varint,2,opt,name=bitrate_bps,json=bitrateBps,proto3" json:"bitrate_bps,omitempty"`
	// Number of audio channels. Must be between 1 and 6. The default is 2.
	ChannelCount int32 `protobuf:"varint,3,opt,name=channel_count,json=channelCount,proto3" json:"channel_count,omitempty"`
	// A list of channel names specifying layout of the audio channels.
	// This only affects the metadata embedded in the container headers, if
	// supported by the specified format. The default is `["fl", "fr"]`.
	//
	// Supported channel names:
	//
	// - `fl` - Front left channel
	// - `fr` - Front right channel
	// - `sl` - Side left channel
	// - `sr` - Side right channel
	// - `fc` - Front center channel
	// - `lfe` - Low frequency
	ChannelLayout []string `protobuf:"bytes,4,rep,name=channel_layout,json=channelLayout,proto3" json:"channel_layout,omitempty"`
	// The mapping for the `Job.edit_list` atoms with audio `EditAtom.inputs`.
	Mapping []*AudioStream_AudioMapping `protobuf:"bytes,5,rep,name=mapping,proto3" json:"mapping,omitempty"`
	// The audio sample rate in Hertz. The default is 48000 Hertz.
	SampleRateHertz int32 `protobuf:"varint,6,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// The BCP-47 language code, such as `en-US` or `sr-Latn`. For more
	// information, see
	// https://www.unicode.org/reports/tr35/#Unicode_locale_identifier. Not
	// supported in MP4 files.
	LanguageCode string `protobuf:"bytes,7,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The name for this particular audio stream that
	// will be added to the HLS/DASH manifest. Not supported in MP4 files.
	DisplayName string `protobuf:"bytes,8,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *AudioStream) Reset() {
	*x = AudioStream{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudioStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioStream) ProtoMessage() {}

func (x *AudioStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioStream.ProtoReflect.Descriptor instead.
func (*AudioStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{15}
}

func (x *AudioStream) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *AudioStream) GetBitrateBps() int32 {
	if x != nil {
		return x.BitrateBps
	}
	return 0
}

func (x *AudioStream) GetChannelCount() int32 {
	if x != nil {
		return x.ChannelCount
	}
	return 0
}

func (x *AudioStream) GetChannelLayout() []string {
	if x != nil {
		return x.ChannelLayout
	}
	return nil
}

func (x *AudioStream) GetMapping() []*AudioStream_AudioMapping {
	if x != nil {
		return x.Mapping
	}
	return nil
}

func (x *AudioStream) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

func (x *AudioStream) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *AudioStream) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Encoding of a text stream. For example, closed captions or subtitles.
type TextStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The codec for this text stream. The default is `webvtt`.
	//
	// Supported text codecs:
	//
	// - `srt`
	// - `ttml`
	// - `cea608`
	// - `cea708`
	// - `webvtt`
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// The BCP-47 language code, such as `en-US` or `sr-Latn`. For more
	// information, see
	// https://www.unicode.org/reports/tr35/#Unicode_locale_identifier. Not
	// supported in MP4 files.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
	Mapping []*TextStream_TextMapping `protobuf:"bytes,3,rep,name=mapping,proto3" json:"mapping,omitempty"`
	// The name for this particular text stream that
	// will be added to the HLS/DASH manifest. Not supported in MP4 files.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *TextStream) Reset() {
	*x = TextStream{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TextStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextStream) ProtoMessage() {}

func (x *TextStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextStream.ProtoReflect.Descriptor instead.
func (*TextStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{16}
}

func (x *TextStream) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *TextStream) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *TextStream) GetMapping() []*TextStream_TextMapping {
	if x != nil {
		return x.Mapping
	}
	return nil
}

func (x *TextStream) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Segment settings for `ts`, `fmp4` and `vtt`.
type SegmentSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration of the segments in seconds. The default is `6.0s`. Note that
	// `segmentDuration` must be greater than or equal to
	// [`gopDuration`](#videostream), and `segmentDuration` must be divisible by
	// [`gopDuration`](#videostream).
	SegmentDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=segment_duration,json=segmentDuration,proto3" json:"segment_duration,omitempty"`
	// Required. Create an individual segment file. The default is `false`.
	IndividualSegments bool `protobuf:"varint,3,opt,name=individual_segments,json=individualSegments,proto3" json:"individual_segments,omitempty"`
}

func (x *SegmentSettings) Reset() {
	*x = SegmentSettings{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SegmentSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentSettings) ProtoMessage() {}

func (x *SegmentSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentSettings.ProtoReflect.Descriptor instead.
func (*SegmentSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{17}
}

func (x *SegmentSettings) GetSegmentDuration() *durationpb.Duration {
	if x != nil {
		return x.SegmentDuration
	}
	return nil
}

func (x *SegmentSettings) GetIndividualSegments() bool {
	if x != nil {
		return x.IndividualSegments
	}
	return false
}

// Encryption settings.
type Encryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Identifier for this set of encryption options.
	Id string `protobuf:"bytes,6,opt,name=id,proto3" json:"id,omitempty"`
	// Encryption mode can be either `aes` or `cenc`.
	//
	// Types that are assignable to EncryptionMode:
	//
	//	*Encryption_Aes_128
	//	*Encryption_SampleAes
	//	*Encryption_MpegCenc
	EncryptionMode isEncryption_EncryptionMode `protobuf_oneof:"encryption_mode"`
	// Defines where content keys are stored.
	//
	// Types that are assignable to SecretSource:
	//
	//	*Encryption_SecretManagerKeySource
	SecretSource isEncryption_SecretSource `protobuf_oneof:"secret_source"`
	// Required. DRM system(s) to use; at least one must be specified. If a
	// DRM system is omitted, it is considered disabled.
	DrmSystems *Encryption_DrmSystems `protobuf:"bytes,8,opt,name=drm_systems,json=drmSystems,proto3" json:"drm_systems,omitempty"`
}

func (x *Encryption) Reset() {
	*x = Encryption{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption) ProtoMessage() {}

func (x *Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption.ProtoReflect.Descriptor instead.
func (*Encryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{18}
}

func (x *Encryption) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (m *Encryption) GetEncryptionMode() isEncryption_EncryptionMode {
	if m != nil {
		return m.EncryptionMode
	}
	return nil
}

func (x *Encryption) GetAes_128() *Encryption_Aes128Encryption {
	if x, ok := x.GetEncryptionMode().(*Encryption_Aes_128); ok {
		return x.Aes_128
	}
	return nil
}

func (x *Encryption) GetSampleAes() *Encryption_SampleAesEncryption {
	if x, ok := x.GetEncryptionMode().(*Encryption_SampleAes); ok {
		return x.SampleAes
	}
	return nil
}

func (x *Encryption) GetMpegCenc() *Encryption_MpegCommonEncryption {
	if x, ok := x.GetEncryptionMode().(*Encryption_MpegCenc); ok {
		return x.MpegCenc
	}
	return nil
}

func (m *Encryption) GetSecretSource() isEncryption_SecretSource {
	if m != nil {
		return m.SecretSource
	}
	return nil
}

func (x *Encryption) GetSecretManagerKeySource() *Encryption_SecretManagerSource {
	if x, ok := x.GetSecretSource().(*Encryption_SecretManagerKeySource); ok {
		return x.SecretManagerKeySource
	}
	return nil
}

func (x *Encryption) GetDrmSystems() *Encryption_DrmSystems {
	if x != nil {
		return x.DrmSystems
	}
	return nil
}

type isEncryption_EncryptionMode interface {
	isEncryption_EncryptionMode()
}

type Encryption_Aes_128 struct {
	// Configuration for AES-128 encryption.
	Aes_128 *Encryption_Aes128Encryption `protobuf:"bytes,3,opt,name=aes_128,json=aes128,proto3,oneof"`
}

type Encryption_SampleAes struct {
	// Configuration for SAMPLE-AES encryption.
	SampleAes *Encryption_SampleAesEncryption `protobuf:"bytes,4,opt,name=sample_aes,json=sampleAes,proto3,oneof"`
}

type Encryption_MpegCenc struct {
	// Configuration for MPEG Common Encryption (MPEG-CENC).
	MpegCenc *Encryption_MpegCommonEncryption `protobuf:"bytes,5,opt,name=mpeg_cenc,json=mpegCenc,proto3,oneof"`
}

func (*Encryption_Aes_128) isEncryption_EncryptionMode() {}

func (*Encryption_SampleAes) isEncryption_EncryptionMode() {}

func (*Encryption_MpegCenc) isEncryption_EncryptionMode() {}

type isEncryption_SecretSource interface {
	isEncryption_SecretSource()
}

type Encryption_SecretManagerKeySource struct {
	// Keys are stored in Google Secret Manager.
	SecretManagerKeySource *Encryption_SecretManagerSource `protobuf:"bytes,7,opt,name=secret_manager_key_source,json=secretManagerKeySource,proto3,oneof"`
}

func (*Encryption_SecretManagerKeySource) isEncryption_SecretSource() {}

// `DASH` manifest configuration.
type Manifest_DashConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The segment reference scheme for a `DASH` manifest. The default is
	// `SEGMENT_LIST`.
	SegmentReferenceScheme Manifest_DashConfig_SegmentReferenceScheme `protobuf:"varint,1,opt,name=segment_reference_scheme,json=segmentReferenceScheme,proto3,enum=google.cloud.video.transcoder.v1.Manifest_DashConfig_SegmentReferenceScheme" json:"segment_reference_scheme,omitempty"`
}

func (x *Manifest_DashConfig) Reset() {
	*x = Manifest_DashConfig{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Manifest_DashConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Manifest_DashConfig) ProtoMessage() {}

func (x *Manifest_DashConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Manifest_DashConfig.ProtoReflect.Descriptor instead.
func (*Manifest_DashConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{9, 0}
}

func (x *Manifest_DashConfig) GetSegmentReferenceScheme() Manifest_DashConfig_SegmentReferenceScheme {
	if x != nil {
		return x.SegmentReferenceScheme
	}
	return Manifest_DashConfig_SEGMENT_REFERENCE_SCHEME_UNSPECIFIED
}

// 2D normalized coordinates. Default: `{0.0, 0.0}`
type Overlay_NormalizedCoordinate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Normalized x coordinate.
	X float64 `protobuf:"fixed64,1,opt,name=x,proto3" json:"x,omitempty"`
	// Normalized y coordinate.
	Y float64 `protobuf:"fixed64,2,opt,name=y,proto3" json:"y,omitempty"`
}

func (x *Overlay_NormalizedCoordinate) Reset() {
	*x = Overlay_NormalizedCoordinate{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Overlay_NormalizedCoordinate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_NormalizedCoordinate) ProtoMessage() {}

func (x *Overlay_NormalizedCoordinate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_NormalizedCoordinate.ProtoReflect.Descriptor instead.
func (*Overlay_NormalizedCoordinate) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{12, 0}
}

func (x *Overlay_NormalizedCoordinate) GetX() float64 {
	if x != nil {
		return x.X
	}
	return 0
}

func (x *Overlay_NormalizedCoordinate) GetY() float64 {
	if x != nil {
		return x.Y
	}
	return 0
}

// Overlaid image.
type Overlay_Image struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. URI of the image in Cloud Storage. For example,
	// `gs://bucket/inputs/image.png`. Only PNG and JPEG images are supported.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Normalized image resolution, based on output video resolution. Valid
	// values: `0.0`–`1.0`. To respect the original image aspect ratio, set
	// either `x` or `y` to `0.0`. To use the original image resolution, set
	// both `x` and `y` to `0.0`.
	Resolution *Overlay_NormalizedCoordinate `protobuf:"bytes,2,opt,name=resolution,proto3" json:"resolution,omitempty"`
	// Target image opacity. Valid values are from  `1.0` (solid, default) to
	// `0.0` (transparent), exclusive. Set this to a value greater than `0.0`.
	Alpha float64 `protobuf:"fixed64,3,opt,name=alpha,proto3" json:"alpha,omitempty"`
}

func (x *Overlay_Image) Reset() {
	*x = Overlay_Image{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Overlay_Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_Image) ProtoMessage() {}

func (x *Overlay_Image) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_Image.ProtoReflect.Descriptor instead.
func (*Overlay_Image) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{12, 1}
}

func (x *Overlay_Image) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Overlay_Image) GetResolution() *Overlay_NormalizedCoordinate {
	if x != nil {
		return x.Resolution
	}
	return nil
}

func (x *Overlay_Image) GetAlpha() float64 {
	if x != nil {
		return x.Alpha
	}
	return 0
}

// Display static overlay object.
type Overlay_AnimationStatic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Normalized coordinates based on output video resolution. Valid
	// values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
	// object. For example, use the x and y coordinates {0,0} to position the
	// top-left corner of the overlay animation in the top-left corner of the
	// output video.
	Xy *Overlay_NormalizedCoordinate `protobuf:"bytes,1,opt,name=xy,proto3" json:"xy,omitempty"`
	// The time to start displaying the overlay object, in seconds. Default: 0
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
}

func (x *Overlay_AnimationStatic) Reset() {
	*x = Overlay_AnimationStatic{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Overlay_AnimationStatic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_AnimationStatic) ProtoMessage() {}

func (x *Overlay_AnimationStatic) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_AnimationStatic.ProtoReflect.Descriptor instead.
func (*Overlay_AnimationStatic) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{12, 2}
}

func (x *Overlay_AnimationStatic) GetXy() *Overlay_NormalizedCoordinate {
	if x != nil {
		return x.Xy
	}
	return nil
}

func (x *Overlay_AnimationStatic) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

// Display overlay object with fade animation.
type Overlay_AnimationFade struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
	FadeType Overlay_FadeType `protobuf:"varint,1,opt,name=fade_type,json=fadeType,proto3,enum=google.cloud.video.transcoder.v1.Overlay_FadeType" json:"fade_type,omitempty"`
	// Normalized coordinates based on output video resolution. Valid
	// values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
	// object. For example, use the x and y coordinates {0,0} to position the
	// top-left corner of the overlay animation in the top-left corner of the
	// output video.
	Xy *Overlay_NormalizedCoordinate `protobuf:"bytes,2,opt,name=xy,proto3" json:"xy,omitempty"`
	// The time to start the fade animation, in seconds. Default: 0
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,3,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// The time to end the fade animation, in seconds. Default:
	// `start_time_offset` + 1s
	EndTimeOffset *durationpb.Duration `protobuf:"bytes,4,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
}

func (x *Overlay_AnimationFade) Reset() {
	*x = Overlay_AnimationFade{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Overlay_AnimationFade) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_AnimationFade) ProtoMessage() {}

func (x *Overlay_AnimationFade) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_AnimationFade.ProtoReflect.Descriptor instead.
func (*Overlay_AnimationFade) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{12, 3}
}

func (x *Overlay_AnimationFade) GetFadeType() Overlay_FadeType {
	if x != nil {
		return x.FadeType
	}
	return Overlay_FADE_TYPE_UNSPECIFIED
}

func (x *Overlay_AnimationFade) GetXy() *Overlay_NormalizedCoordinate {
	if x != nil {
		return x.Xy
	}
	return nil
}

func (x *Overlay_AnimationFade) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

func (x *Overlay_AnimationFade) GetEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.EndTimeOffset
	}
	return nil
}

// End previous overlay animation from the video. Without AnimationEnd, the
// overlay object will keep the state of previous animation until the end of
// the video.
type Overlay_AnimationEnd struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time to end overlay object, in seconds. Default: 0
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
}

func (x *Overlay_AnimationEnd) Reset() {
	*x = Overlay_AnimationEnd{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Overlay_AnimationEnd) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_AnimationEnd) ProtoMessage() {}

func (x *Overlay_AnimationEnd) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_AnimationEnd.ProtoReflect.Descriptor instead.
func (*Overlay_AnimationEnd) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{12, 4}
}

func (x *Overlay_AnimationEnd) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

// Animation types.
type Overlay_Animation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Animations can be static or fade, or they can end the previous animation.
	//
	// Types that are assignable to AnimationType:
	//
	//	*Overlay_Animation_AnimationStatic
	//	*Overlay_Animation_AnimationFade
	//	*Overlay_Animation_AnimationEnd
	AnimationType isOverlay_Animation_AnimationType `protobuf_oneof:"animation_type"`
}

func (x *Overlay_Animation) Reset() {
	*x = Overlay_Animation{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Overlay_Animation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Overlay_Animation) ProtoMessage() {}

func (x *Overlay_Animation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Overlay_Animation.ProtoReflect.Descriptor instead.
func (*Overlay_Animation) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{12, 5}
}

func (m *Overlay_Animation) GetAnimationType() isOverlay_Animation_AnimationType {
	if m != nil {
		return m.AnimationType
	}
	return nil
}

func (x *Overlay_Animation) GetAnimationStatic() *Overlay_AnimationStatic {
	if x, ok := x.GetAnimationType().(*Overlay_Animation_AnimationStatic); ok {
		return x.AnimationStatic
	}
	return nil
}

func (x *Overlay_Animation) GetAnimationFade() *Overlay_AnimationFade {
	if x, ok := x.GetAnimationType().(*Overlay_Animation_AnimationFade); ok {
		return x.AnimationFade
	}
	return nil
}

func (x *Overlay_Animation) GetAnimationEnd() *Overlay_AnimationEnd {
	if x, ok := x.GetAnimationType().(*Overlay_Animation_AnimationEnd); ok {
		return x.AnimationEnd
	}
	return nil
}

type isOverlay_Animation_AnimationType interface {
	isOverlay_Animation_AnimationType()
}

type Overlay_Animation_AnimationStatic struct {
	// Display static overlay object.
	AnimationStatic *Overlay_AnimationStatic `protobuf:"bytes,1,opt,name=animation_static,json=animationStatic,proto3,oneof"`
}

type Overlay_Animation_AnimationFade struct {
	// Display overlay object with fade animation.
	AnimationFade *Overlay_AnimationFade `protobuf:"bytes,2,opt,name=animation_fade,json=animationFade,proto3,oneof"`
}

type Overlay_Animation_AnimationEnd struct {
	// End previous animation.
	AnimationEnd *Overlay_AnimationEnd `protobuf:"bytes,3,opt,name=animation_end,json=animationEnd,proto3,oneof"`
}

func (*Overlay_Animation_AnimationStatic) isOverlay_Animation_AnimationType() {}

func (*Overlay_Animation_AnimationFade) isOverlay_Animation_AnimationType() {}

func (*Overlay_Animation_AnimationEnd) isOverlay_Animation_AnimationType() {}

// Color preprocessing configuration.
//
// **Note:** This configuration is not supported.
type PreprocessingConfig_Color struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Control color saturation of the video. Enter a value between -1 and 1,
	// where -1 is fully desaturated and 1 is maximum saturation. 0 is no
	// change. The default is 0.
	Saturation float64 `protobuf:"fixed64,1,opt,name=saturation,proto3" json:"saturation,omitempty"`
	// Control black and white contrast of the video. Enter a value between -1
	// and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no
	// change. The default is 0.
	Contrast float64 `protobuf:"fixed64,2,opt,name=contrast,proto3" json:"contrast,omitempty"`
	// Control brightness of the video. Enter a value between -1 and 1, where -1
	// is minimum brightness and 1 is maximum brightness. 0 is no change. The
	// default is 0.
	Brightness float64 `protobuf:"fixed64,3,opt,name=brightness,proto3" json:"brightness,omitempty"`
}

func (x *PreprocessingConfig_Color) Reset() {
	*x = PreprocessingConfig_Color{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreprocessingConfig_Color) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Color) ProtoMessage() {}

func (x *PreprocessingConfig_Color) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Color.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Color) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{13, 0}
}

func (x *PreprocessingConfig_Color) GetSaturation() float64 {
	if x != nil {
		return x.Saturation
	}
	return 0
}

func (x *PreprocessingConfig_Color) GetContrast() float64 {
	if x != nil {
		return x.Contrast
	}
	return 0
}

func (x *PreprocessingConfig_Color) GetBrightness() float64 {
	if x != nil {
		return x.Brightness
	}
	return 0
}

// Denoise preprocessing configuration.
//
// **Note:** This configuration is not supported.
type PreprocessingConfig_Denoise struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set strength of the denoise. Enter a value between 0 and 1. The higher
	// the value, the smoother the image. 0 is no denoising. The default is 0.
	Strength float64 `protobuf:"fixed64,1,opt,name=strength,proto3" json:"strength,omitempty"`
	// Set the denoiser mode. The default is `standard`.
	//
	// Supported denoiser modes:
	//
	// - `standard`
	// - `grain`
	Tune string `protobuf:"bytes,2,opt,name=tune,proto3" json:"tune,omitempty"`
}

func (x *PreprocessingConfig_Denoise) Reset() {
	*x = PreprocessingConfig_Denoise{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreprocessingConfig_Denoise) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Denoise) ProtoMessage() {}

func (x *PreprocessingConfig_Denoise) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Denoise.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Denoise) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{13, 1}
}

func (x *PreprocessingConfig_Denoise) GetStrength() float64 {
	if x != nil {
		return x.Strength
	}
	return 0
}

func (x *PreprocessingConfig_Denoise) GetTune() string {
	if x != nil {
		return x.Tune
	}
	return ""
}

// Deblock preprocessing configuration.
//
// **Note:** This configuration is not supported.
type PreprocessingConfig_Deblock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Set strength of the deblocker. Enter a value between 0 and 1. The higher
	// the value, the stronger the block removal. 0 is no deblocking. The
	// default is 0.
	Strength float64 `protobuf:"fixed64,1,opt,name=strength,proto3" json:"strength,omitempty"`
	// Enable deblocker. The default is `false`.
	Enabled bool `protobuf:"varint,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
}

func (x *PreprocessingConfig_Deblock) Reset() {
	*x = PreprocessingConfig_Deblock{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreprocessingConfig_Deblock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Deblock) ProtoMessage() {}

func (x *PreprocessingConfig_Deblock) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Deblock.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Deblock) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{13, 2}
}

func (x *PreprocessingConfig_Deblock) GetStrength() float64 {
	if x != nil {
		return x.Strength
	}
	return 0
}

func (x *PreprocessingConfig_Deblock) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

// Audio preprocessing configuration.
type PreprocessingConfig_Audio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify audio loudness normalization in loudness units relative to full
	// scale (LUFS). Enter a value between -24 and 0 (the default), where:
	//
	//   - -24 is the Advanced Television Systems Committee (ATSC A/85) standard
	//   - -23 is the EU R128 broadcast standard
	//   - -19 is the prior standard for online mono audio
	//   - -18 is the ReplayGain standard
	//   - -16 is the prior standard for stereo audio
	//   - -14 is the new online audio standard recommended by Spotify, as well
	//     as Amazon Echo
	//   - 0 disables normalization
	Lufs float64 `protobuf:"fixed64,1,opt,name=lufs,proto3" json:"lufs,omitempty"`
	// Enable boosting high frequency components. The default is `false`.
	//
	// **Note:** This field is not supported.
	HighBoost bool `protobuf:"varint,2,opt,name=high_boost,json=highBoost,proto3" json:"high_boost,omitempty"`
	// Enable boosting low frequency components. The default is `false`.
	//
	// **Note:** This field is not supported.
	LowBoost bool `protobuf:"varint,3,opt,name=low_boost,json=lowBoost,proto3" json:"low_boost,omitempty"`
}

func (x *PreprocessingConfig_Audio) Reset() {
	*x = PreprocessingConfig_Audio{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreprocessingConfig_Audio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Audio) ProtoMessage() {}

func (x *PreprocessingConfig_Audio) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Audio.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Audio) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{13, 3}
}

func (x *PreprocessingConfig_Audio) GetLufs() float64 {
	if x != nil {
		return x.Lufs
	}
	return 0
}

func (x *PreprocessingConfig_Audio) GetHighBoost() bool {
	if x != nil {
		return x.HighBoost
	}
	return false
}

func (x *PreprocessingConfig_Audio) GetLowBoost() bool {
	if x != nil {
		return x.LowBoost
	}
	return false
}

// Video cropping configuration for the input video. The cropped input video
// is scaled to match the output resolution.
type PreprocessingConfig_Crop struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of pixels to crop from the top. The default is 0.
	TopPixels int32 `protobuf:"varint,1,opt,name=top_pixels,json=topPixels,proto3" json:"top_pixels,omitempty"`
	// The number of pixels to crop from the bottom. The default is 0.
	BottomPixels int32 `protobuf:"varint,2,opt,name=bottom_pixels,json=bottomPixels,proto3" json:"bottom_pixels,omitempty"`
	// The number of pixels to crop from the left. The default is 0.
	LeftPixels int32 `protobuf:"varint,3,opt,name=left_pixels,json=leftPixels,proto3" json:"left_pixels,omitempty"`
	// The number of pixels to crop from the right. The default is 0.
	RightPixels int32 `protobuf:"varint,4,opt,name=right_pixels,json=rightPixels,proto3" json:"right_pixels,omitempty"`
}

func (x *PreprocessingConfig_Crop) Reset() {
	*x = PreprocessingConfig_Crop{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreprocessingConfig_Crop) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Crop) ProtoMessage() {}

func (x *PreprocessingConfig_Crop) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Crop.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Crop) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{13, 4}
}

func (x *PreprocessingConfig_Crop) GetTopPixels() int32 {
	if x != nil {
		return x.TopPixels
	}
	return 0
}

func (x *PreprocessingConfig_Crop) GetBottomPixels() int32 {
	if x != nil {
		return x.BottomPixels
	}
	return 0
}

func (x *PreprocessingConfig_Crop) GetLeftPixels() int32 {
	if x != nil {
		return x.LeftPixels
	}
	return 0
}

func (x *PreprocessingConfig_Crop) GetRightPixels() int32 {
	if x != nil {
		return x.RightPixels
	}
	return 0
}

// Pad filter configuration for the input video. The padded input video
// is scaled after padding with black to match the output resolution.
type PreprocessingConfig_Pad struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of pixels to add to the top. The default is 0.
	TopPixels int32 `protobuf:"varint,1,opt,name=top_pixels,json=topPixels,proto3" json:"top_pixels,omitempty"`
	// The number of pixels to add to the bottom. The default is 0.
	BottomPixels int32 `protobuf:"varint,2,opt,name=bottom_pixels,json=bottomPixels,proto3" json:"bottom_pixels,omitempty"`
	// The number of pixels to add to the left. The default is 0.
	LeftPixels int32 `protobuf:"varint,3,opt,name=left_pixels,json=leftPixels,proto3" json:"left_pixels,omitempty"`
	// The number of pixels to add to the right. The default is 0.
	RightPixels int32 `protobuf:"varint,4,opt,name=right_pixels,json=rightPixels,proto3" json:"right_pixels,omitempty"`
}

func (x *PreprocessingConfig_Pad) Reset() {
	*x = PreprocessingConfig_Pad{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreprocessingConfig_Pad) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Pad) ProtoMessage() {}

func (x *PreprocessingConfig_Pad) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Pad.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Pad) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{13, 5}
}

func (x *PreprocessingConfig_Pad) GetTopPixels() int32 {
	if x != nil {
		return x.TopPixels
	}
	return 0
}

func (x *PreprocessingConfig_Pad) GetBottomPixels() int32 {
	if x != nil {
		return x.BottomPixels
	}
	return 0
}

func (x *PreprocessingConfig_Pad) GetLeftPixels() int32 {
	if x != nil {
		return x.LeftPixels
	}
	return 0
}

func (x *PreprocessingConfig_Pad) GetRightPixels() int32 {
	if x != nil {
		return x.RightPixels
	}
	return 0
}

// Deinterlace configuration for input video.
type PreprocessingConfig_Deinterlace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify the video deinterlacing filter. The default is `yadif`.
	//
	// Types that are assignable to DeinterlacingFilter:
	//
	//	*PreprocessingConfig_Deinterlace_Yadif
	//	*PreprocessingConfig_Deinterlace_Bwdif
	DeinterlacingFilter isPreprocessingConfig_Deinterlace_DeinterlacingFilter `protobuf_oneof:"deinterlacing_filter"`
}

func (x *PreprocessingConfig_Deinterlace) Reset() {
	*x = PreprocessingConfig_Deinterlace{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreprocessingConfig_Deinterlace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Deinterlace) ProtoMessage() {}

func (x *PreprocessingConfig_Deinterlace) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Deinterlace.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Deinterlace) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{13, 6}
}

func (m *PreprocessingConfig_Deinterlace) GetDeinterlacingFilter() isPreprocessingConfig_Deinterlace_DeinterlacingFilter {
	if m != nil {
		return m.DeinterlacingFilter
	}
	return nil
}

func (x *PreprocessingConfig_Deinterlace) GetYadif() *PreprocessingConfig_Deinterlace_YadifConfig {
	if x, ok := x.GetDeinterlacingFilter().(*PreprocessingConfig_Deinterlace_Yadif); ok {
		return x.Yadif
	}
	return nil
}

func (x *PreprocessingConfig_Deinterlace) GetBwdif() *PreprocessingConfig_Deinterlace_BwdifConfig {
	if x, ok := x.GetDeinterlacingFilter().(*PreprocessingConfig_Deinterlace_Bwdif); ok {
		return x.Bwdif
	}
	return nil
}

type isPreprocessingConfig_Deinterlace_DeinterlacingFilter interface {
	isPreprocessingConfig_Deinterlace_DeinterlacingFilter()
}

type PreprocessingConfig_Deinterlace_Yadif struct {
	// Specifies the Yet Another Deinterlacing Filter Configuration.
	Yadif *PreprocessingConfig_Deinterlace_YadifConfig `protobuf:"bytes,1,opt,name=yadif,proto3,oneof"`
}

type PreprocessingConfig_Deinterlace_Bwdif struct {
	// Specifies the Bob Weaver Deinterlacing Filter Configuration.
	Bwdif *PreprocessingConfig_Deinterlace_BwdifConfig `protobuf:"bytes,2,opt,name=bwdif,proto3,oneof"`
}

func (*PreprocessingConfig_Deinterlace_Yadif) isPreprocessingConfig_Deinterlace_DeinterlacingFilter() {
}

func (*PreprocessingConfig_Deinterlace_Bwdif) isPreprocessingConfig_Deinterlace_DeinterlacingFilter() {
}

// Yet Another Deinterlacing Filter Configuration.
type PreprocessingConfig_Deinterlace_YadifConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the deinterlacing mode to adopt.
	// The default is `send_frame`.
	// Supported values:
	//
	// - `send_frame`: Output one frame for each frame
	// - `send_field`: Output one frame for each field
	Mode string `protobuf:"bytes,1,opt,name=mode,proto3" json:"mode,omitempty"`
	// Disable spacial interlacing.
	// The default is `false`.
	DisableSpatialInterlacing bool `protobuf:"varint,2,opt,name=disable_spatial_interlacing,json=disableSpatialInterlacing,proto3" json:"disable_spatial_interlacing,omitempty"`
	// The picture field parity assumed for the input interlaced video.
	// The default is `auto`.
	// Supported values:
	//
	// - `tff`: Assume the top field is first
	// - `bff`: Assume the bottom field is first
	// - `auto`: Enable automatic detection of field parity
	Parity string `protobuf:"bytes,3,opt,name=parity,proto3" json:"parity,omitempty"`
	// Deinterlace all frames rather than just the frames identified as
	// interlaced. The default is `false`.
	DeinterlaceAllFrames bool `protobuf:"varint,4,opt,name=deinterlace_all_frames,json=deinterlaceAllFrames,proto3" json:"deinterlace_all_frames,omitempty"`
}

func (x *PreprocessingConfig_Deinterlace_YadifConfig) Reset() {
	*x = PreprocessingConfig_Deinterlace_YadifConfig{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreprocessingConfig_Deinterlace_YadifConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Deinterlace_YadifConfig) ProtoMessage() {}

func (x *PreprocessingConfig_Deinterlace_YadifConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Deinterlace_YadifConfig.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Deinterlace_YadifConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{13, 6, 0}
}

func (x *PreprocessingConfig_Deinterlace_YadifConfig) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

func (x *PreprocessingConfig_Deinterlace_YadifConfig) GetDisableSpatialInterlacing() bool {
	if x != nil {
		return x.DisableSpatialInterlacing
	}
	return false
}

func (x *PreprocessingConfig_Deinterlace_YadifConfig) GetParity() string {
	if x != nil {
		return x.Parity
	}
	return ""
}

func (x *PreprocessingConfig_Deinterlace_YadifConfig) GetDeinterlaceAllFrames() bool {
	if x != nil {
		return x.DeinterlaceAllFrames
	}
	return false
}

// Bob Weaver Deinterlacing Filter Configuration.
type PreprocessingConfig_Deinterlace_BwdifConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the deinterlacing mode to adopt.
	// The default is `send_frame`.
	// Supported values:
	//
	// - `send_frame`: Output one frame for each frame
	// - `send_field`: Output one frame for each field
	Mode string `protobuf:"bytes,1,opt,name=mode,proto3" json:"mode,omitempty"`
	// The picture field parity assumed for the input interlaced video.
	// The default is `auto`.
	// Supported values:
	//
	// - `tff`: Assume the top field is first
	// - `bff`: Assume the bottom field is first
	// - `auto`: Enable automatic detection of field parity
	Parity string `protobuf:"bytes,2,opt,name=parity,proto3" json:"parity,omitempty"`
	// Deinterlace all frames rather than just the frames identified as
	// interlaced. The default is `false`.
	DeinterlaceAllFrames bool `protobuf:"varint,3,opt,name=deinterlace_all_frames,json=deinterlaceAllFrames,proto3" json:"deinterlace_all_frames,omitempty"`
}

func (x *PreprocessingConfig_Deinterlace_BwdifConfig) Reset() {
	*x = PreprocessingConfig_Deinterlace_BwdifConfig{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreprocessingConfig_Deinterlace_BwdifConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Deinterlace_BwdifConfig) ProtoMessage() {}

func (x *PreprocessingConfig_Deinterlace_BwdifConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Deinterlace_BwdifConfig.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Deinterlace_BwdifConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{13, 6, 1}
}

func (x *PreprocessingConfig_Deinterlace_BwdifConfig) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

func (x *PreprocessingConfig_Deinterlace_BwdifConfig) GetParity() string {
	if x != nil {
		return x.Parity
	}
	return ""
}

func (x *PreprocessingConfig_Deinterlace_BwdifConfig) GetDeinterlaceAllFrames() bool {
	if x != nil {
		return x.DeinterlaceAllFrames
	}
	return false
}

// H264 codec settings.
type VideoStream_H264CodecSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The width of the video in pixels. Must be an even integer.
	// When not specified, the width is adjusted to match the specified height
	// and input aspect ratio. If both are omitted, the input width is used.
	//
	// For portrait videos that contain horizontal ASR and rotation metadata,
	// provide the width, in pixels, per the horizontal ASR. The API calculates
	// the height per the horizontal ASR. The API detects any rotation metadata
	// and swaps the requested height and width for the output.
	WidthPixels int32 `protobuf:"varint,1,opt,name=width_pixels,json=widthPixels,proto3" json:"width_pixels,omitempty"`
	// The height of the video in pixels. Must be an even integer.
	// When not specified, the height is adjusted to match the specified width
	// and input aspect ratio. If both are omitted, the input height is used.
	//
	// For portrait videos that contain horizontal ASR and rotation metadata,
	// provide the height, in pixels, per the horizontal ASR. The API calculates
	// the width per the horizontal ASR. The API detects any rotation metadata
	// and swaps the requested height and width for the output.
	HeightPixels int32 `protobuf:"varint,2,opt,name=height_pixels,json=heightPixels,proto3" json:"height_pixels,omitempty"`
	// Required. The target video frame rate in frames per second (FPS). Must be
	// less than or equal to 120. Will default to the input frame rate if larger
	// than the input frame rate. The API will generate an output FPS that is
	// divisible by the input FPS, and smaller or equal to the target FPS. See
	// [Calculating frame
	// rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
	// more information.
	FrameRate float64 `protobuf:"fixed64,3,opt,name=frame_rate,json=frameRate,proto3" json:"frame_rate,omitempty"`
	// Required. The video bitrate in bits per second. The minimum value is
	// 1,000. The maximum value is 800,000,000.
	BitrateBps int32 `protobuf:"varint,4,opt,name=bitrate_bps,json=bitrateBps,proto3" json:"bitrate_bps,omitempty"`
	// Pixel format to use. The default is `yuv420p`.
	//
	// Supported pixel formats:
	//
	// - `yuv420p` pixel format
	// - `yuv422p` pixel format
	// - `yuv444p` pixel format
	// - `yuv420p10` 10-bit HDR pixel format
	// - `yuv422p10` 10-bit HDR pixel format
	// - `yuv444p10` 10-bit HDR pixel format
	// - `yuv420p12` 12-bit HDR pixel format
	// - `yuv422p12` 12-bit HDR pixel format
	// - `yuv444p12` 12-bit HDR pixel format
	PixelFormat string `protobuf:"bytes,5,opt,name=pixel_format,json=pixelFormat,proto3" json:"pixel_format,omitempty"`
	// Specify the `rate_control_mode`. The default is `vbr`.
	//
	// Supported rate control modes:
	//
	// - `vbr` - variable bitrate
	// - `crf` - constant rate factor
	RateControlMode string `protobuf:"bytes,6,opt,name=rate_control_mode,json=rateControlMode,proto3" json:"rate_control_mode,omitempty"`
	// Target CRF level. Must be between 10 and 36, where 10 is the highest
	// quality and 36 is the most efficient compression. The default is 21.
	CrfLevel int32 `protobuf:"varint,7,opt,name=crf_level,json=crfLevel,proto3" json:"crf_level,omitempty"`
	// Specifies whether an open Group of Pictures (GOP) structure should be
	// allowed or not. The default is `false`.
	AllowOpenGop bool `protobuf:"varint,8,opt,name=allow_open_gop,json=allowOpenGop,proto3" json:"allow_open_gop,omitempty"`
	// GOP mode can be either by frame count or duration.
	//
	// Types that are assignable to GopMode:
	//
	//	*VideoStream_H264CodecSettings_GopFrameCount
	//	*VideoStream_H264CodecSettings_GopDuration
	GopMode isVideoStream_H264CodecSettings_GopMode `protobuf_oneof:"gop_mode"`
	// Use two-pass encoding strategy to achieve better video quality.
	// `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
	EnableTwoPass bool `protobuf:"varint,11,opt,name=enable_two_pass,json=enableTwoPass,proto3" json:"enable_two_pass,omitempty"`
	// Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
	// greater than zero. The default is equal to `VideoStream.bitrate_bps`.
	VbvSizeBits int32 `protobuf:"varint,12,opt,name=vbv_size_bits,json=vbvSizeBits,proto3" json:"vbv_size_bits,omitempty"`
	// Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
	// Must be greater than zero. The default is equal to 90% of
	// `VideoStream.vbv_size_bits`.
	VbvFullnessBits int32 `protobuf:"varint,13,opt,name=vbv_fullness_bits,json=vbvFullnessBits,proto3" json:"vbv_fullness_bits,omitempty"`
	// The entropy coder to use. The default is `cabac`.
	//
	// Supported entropy coders:
	//
	// - `cavlc`
	// - `cabac`
	EntropyCoder string `protobuf:"bytes,14,opt,name=entropy_coder,json=entropyCoder,proto3" json:"entropy_coder,omitempty"`
	// Allow B-pyramid for reference frame selection. This may not be supported
	// on all decoders. The default is `false`.
	BPyramid bool `protobuf:"varint,15,opt,name=b_pyramid,json=bPyramid,proto3" json:"b_pyramid,omitempty"`
	// The number of consecutive B-frames. Must be greater than or equal to
	// zero. Must be less than `VideoStream.gop_frame_count` if set. The default
	// is 0.
	BFrameCount int32 `protobuf:"varint,16,opt,name=b_frame_count,json=bFrameCount,proto3" json:"b_frame_count,omitempty"`
	// Specify the intensity of the adaptive quantizer (AQ). Must be between 0
	// and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
	// higher value equals a lower bitrate but smoother image. The default is 0.
	AqStrength float64 `protobuf:"fixed64,17,opt,name=aq_strength,json=aqStrength,proto3" json:"aq_strength,omitempty"`
	// Enforces the specified codec profile. The following profiles are
	// supported:
	//
	// *   `baseline`
	// *   `main`
	// *   `high` (default)
	//
	// The available options are
	// [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
	// Note that certain values for this field may cause the
	// transcoder to override other fields you set in the `H264CodecSettings`
	// message.
	Profile string `protobuf:"bytes,18,opt,name=profile,proto3" json:"profile,omitempty"`
	// Enforces the specified codec tune. The available options are
	// [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
	// Note that certain values for this field may cause the
	// transcoder to override other fields you set in the `H264CodecSettings`
	// message.
	Tune string `protobuf:"bytes,19,opt,name=tune,proto3" json:"tune,omitempty"`
	// Enforces the specified codec preset. The default is `veryfast`. The
	// available options are
	// [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset).
	// Note that certain values for this field may cause the
	// transcoder to override other fields you set in the `H264CodecSettings`
	// message.
	Preset string `protobuf:"bytes,20,opt,name=preset,proto3" json:"preset,omitempty"`
}

func (x *VideoStream_H264CodecSettings) Reset() {
	*x = VideoStream_H264CodecSettings{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoStream_H264CodecSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoStream_H264CodecSettings) ProtoMessage() {}

func (x *VideoStream_H264CodecSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoStream_H264CodecSettings.ProtoReflect.Descriptor instead.
func (*VideoStream_H264CodecSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{14, 0}
}

func (x *VideoStream_H264CodecSettings) GetWidthPixels() int32 {
	if x != nil {
		return x.WidthPixels
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetHeightPixels() int32 {
	if x != nil {
		return x.HeightPixels
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetFrameRate() float64 {
	if x != nil {
		return x.FrameRate
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetBitrateBps() int32 {
	if x != nil {
		return x.BitrateBps
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetPixelFormat() string {
	if x != nil {
		return x.PixelFormat
	}
	return ""
}

func (x *VideoStream_H264CodecSettings) GetRateControlMode() string {
	if x != nil {
		return x.RateControlMode
	}
	return ""
}

func (x *VideoStream_H264CodecSettings) GetCrfLevel() int32 {
	if x != nil {
		return x.CrfLevel
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetAllowOpenGop() bool {
	if x != nil {
		return x.AllowOpenGop
	}
	return false
}

func (m *VideoStream_H264CodecSettings) GetGopMode() isVideoStream_H264CodecSettings_GopMode {
	if m != nil {
		return m.GopMode
	}
	return nil
}

func (x *VideoStream_H264CodecSettings) GetGopFrameCount() int32 {
	if x, ok := x.GetGopMode().(*VideoStream_H264CodecSettings_GopFrameCount); ok {
		return x.GopFrameCount
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetGopDuration() *durationpb.Duration {
	if x, ok := x.GetGopMode().(*VideoStream_H264CodecSettings_GopDuration); ok {
		return x.GopDuration
	}
	return nil
}

func (x *VideoStream_H264CodecSettings) GetEnableTwoPass() bool {
	if x != nil {
		return x.EnableTwoPass
	}
	return false
}

func (x *VideoStream_H264CodecSettings) GetVbvSizeBits() int32 {
	if x != nil {
		return x.VbvSizeBits
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetVbvFullnessBits() int32 {
	if x != nil {
		return x.VbvFullnessBits
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetEntropyCoder() string {
	if x != nil {
		return x.EntropyCoder
	}
	return ""
}

func (x *VideoStream_H264CodecSettings) GetBPyramid() bool {
	if x != nil {
		return x.BPyramid
	}
	return false
}

func (x *VideoStream_H264CodecSettings) GetBFrameCount() int32 {
	if x != nil {
		return x.BFrameCount
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetAqStrength() float64 {
	if x != nil {
		return x.AqStrength
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetProfile() string {
	if x != nil {
		return x.Profile
	}
	return ""
}

func (x *VideoStream_H264CodecSettings) GetTune() string {
	if x != nil {
		return x.Tune
	}
	return ""
}

func (x *VideoStream_H264CodecSettings) GetPreset() string {
	if x != nil {
		return x.Preset
	}
	return ""
}

type isVideoStream_H264CodecSettings_GopMode interface {
	isVideoStream_H264CodecSettings_GopMode()
}

type VideoStream_H264CodecSettings_GopFrameCount struct {
	// Select the GOP size based on the specified frame count. Must be greater
	// than zero.
	GopFrameCount int32 `protobuf:"varint,9,opt,name=gop_frame_count,json=gopFrameCount,proto3,oneof"`
}

type VideoStream_H264CodecSettings_GopDuration struct {
	// Select the GOP size based on the specified duration. The default is
	// `3s`. Note that `gopDuration` must be less than or equal to
	// [`segmentDuration`](#SegmentSettings), and
	// [`segmentDuration`](#SegmentSettings) must be divisible by
	// `gopDuration`.
	GopDuration *durationpb.Duration `protobuf:"bytes,10,opt,name=gop_duration,json=gopDuration,proto3,oneof"`
}

func (*VideoStream_H264CodecSettings_GopFrameCount) isVideoStream_H264CodecSettings_GopMode() {}

func (*VideoStream_H264CodecSettings_GopDuration) isVideoStream_H264CodecSettings_GopMode() {}

// H265 codec settings.
type VideoStream_H265CodecSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The width of the video in pixels. Must be an even integer.
	// When not specified, the width is adjusted to match the specified height
	// and input aspect ratio. If both are omitted, the input width is used.
	//
	// For portrait videos that contain horizontal ASR and rotation metadata,
	// provide the width, in pixels, per the horizontal ASR. The API calculates
	// the height per the horizontal ASR. The API detects any rotation metadata
	// and swaps the requested height and width for the output.
	WidthPixels int32 `protobuf:"varint,1,opt,name=width_pixels,json=widthPixels,proto3" json:"width_pixels,omitempty"`
	// The height of the video in pixels. Must be an even integer.
	// When not specified, the height is adjusted to match the specified width
	// and input aspect ratio. If both are omitted, the input height is used.
	//
	// For portrait videos that contain horizontal ASR and rotation metadata,
	// provide the height, in pixels, per the horizontal ASR. The API calculates
	// the width per the horizontal ASR. The API detects any rotation metadata
	// and swaps the requested height and width for the output.
	HeightPixels int32 `protobuf:"varint,2,opt,name=height_pixels,json=heightPixels,proto3" json:"height_pixels,omitempty"`
	// Required. The target video frame rate in frames per second (FPS). Must be
	// less than or equal to 120. Will default to the input frame rate if larger
	// than the input frame rate. The API will generate an output FPS that is
	// divisible by the input FPS, and smaller or equal to the target FPS. See
	// [Calculating frame
	// rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
	// more information.
	FrameRate float64 `protobuf:"fixed64,3,opt,name=frame_rate,json=frameRate,proto3" json:"frame_rate,omitempty"`
	// Required. The video bitrate in bits per second. The minimum value is
	// 1,000. The maximum value is 800,000,000.
	BitrateBps int32 `protobuf:"varint,4,opt,name=bitrate_bps,json=bitrateBps,proto3" json:"bitrate_bps,omitempty"`
	// Pixel format to use. The default is `yuv420p`.
	//
	// Supported pixel formats:
	//
	// - `yuv420p` pixel format
	// - `yuv422p` pixel format
	// - `yuv444p` pixel format
	// - `yuv420p10` 10-bit HDR pixel format
	// - `yuv422p10` 10-bit HDR pixel format
	// - `yuv444p10` 10-bit HDR pixel format
	// - `yuv420p12` 12-bit HDR pixel format
	// - `yuv422p12` 12-bit HDR pixel format
	// - `yuv444p12` 12-bit HDR pixel format
	PixelFormat string `protobuf:"bytes,5,opt,name=pixel_format,json=pixelFormat,proto3" json:"pixel_format,omitempty"`
	// Specify the `rate_control_mode`. The default is `vbr`.
	//
	// Supported rate control modes:
	//
	// - `vbr` - variable bitrate
	// - `crf` - constant rate factor
	RateControlMode string `protobuf:"bytes,6,opt,name=rate_control_mode,json=rateControlMode,proto3" json:"rate_control_mode,omitempty"`
	// Target CRF level. Must be between 10 and 36, where 10 is the highest
	// quality and 36 is the most efficient compression. The default is 21.
	CrfLevel int32 `protobuf:"varint,7,opt,name=crf_level,json=crfLevel,proto3" json:"crf_level,omitempty"`
	// Specifies whether an open Group of Pictures (GOP) structure should be
	// allowed or not. The default is `false`.
	AllowOpenGop bool `protobuf:"varint,8,opt,name=allow_open_gop,json=allowOpenGop,proto3" json:"allow_open_gop,omitempty"`
	// GOP mode can be either by frame count or duration.
	//
	// Types that are assignable to GopMode:
	//
	//	*VideoStream_H265CodecSettings_GopFrameCount
	//	*VideoStream_H265CodecSettings_GopDuration
	GopMode isVideoStream_H265CodecSettings_GopMode `protobuf_oneof:"gop_mode"`
	// Use two-pass encoding strategy to achieve better video quality.
	// `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
	EnableTwoPass bool `protobuf:"varint,11,opt,name=enable_two_pass,json=enableTwoPass,proto3" json:"enable_two_pass,omitempty"`
	// Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
	// greater than zero. The default is equal to `VideoStream.bitrate_bps`.
	VbvSizeBits int32 `protobuf:"varint,12,opt,name=vbv_size_bits,json=vbvSizeBits,proto3" json:"vbv_size_bits,omitempty"`
	// Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
	// Must be greater than zero. The default is equal to 90% of
	// `VideoStream.vbv_size_bits`.
	VbvFullnessBits int32 `protobuf:"varint,13,opt,name=vbv_fullness_bits,json=vbvFullnessBits,proto3" json:"vbv_fullness_bits,omitempty"`
	// Allow B-pyramid for reference frame selection. This may not be supported
	// on all decoders. The default is `false`.
	BPyramid bool `protobuf:"varint,14,opt,name=b_pyramid,json=bPyramid,proto3" json:"b_pyramid,omitempty"`
	// The number of consecutive B-frames. Must be greater than or equal to
	// zero. Must be less than `VideoStream.gop_frame_count` if set. The default
	// is 0.
	BFrameCount int32 `protobuf:"varint,15,opt,name=b_frame_count,json=bFrameCount,proto3" json:"b_frame_count,omitempty"`
	// Specify the intensity of the adaptive quantizer (AQ). Must be between 0
	// and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
	// higher value equals a lower bitrate but smoother image. The default is 0.
	AqStrength float64 `protobuf:"fixed64,16,opt,name=aq_strength,json=aqStrength,proto3" json:"aq_strength,omitempty"`
	// Enforces the specified codec profile. The following profiles are
	// supported:
	//
	// *   8-bit profiles
	//   - `main` (default)
	//   - `main-intra`
	//   - `mainstillpicture`
	//
	// *   10-bit profiles
	//   - `main10` (default)
	//   - `main10-intra`
	//   - `main422-10`
	//   - `main422-10-intra`
	//   - `main444-10`
	//   - `main444-10-intra`
	//
	// *   12-bit profiles
	//   - `main12` (default)
	//   - `main12-intra`
	//   - `main422-12`
	//   - `main422-12-intra`
	//   - `main444-12`
	//   - `main444-12-intra`
	//
	// The available options are
	// [FFmpeg-compatible](https://x265.readthedocs.io/).
	// Note that certain values for this field may cause the
	// transcoder to override other fields you set in the `H265CodecSettings`
	// message.
	Profile string `protobuf:"bytes,17,opt,name=profile,proto3" json:"profile,omitempty"`
	// Enforces the specified codec tune. The available options are
	// [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
	// Note that certain values for this field may cause the
	// transcoder to override other fields you set in the `H265CodecSettings`
	// message.
	Tune string `protobuf:"bytes,18,opt,name=tune,proto3" json:"tune,omitempty"`
	// Enforces the specified codec preset. The default is `veryfast`. The
	// available options are
	// [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
	// Note that certain values for this field may cause the
	// transcoder to override other fields you set in the `H265CodecSettings`
	// message.
	Preset string `protobuf:"bytes,19,opt,name=preset,proto3" json:"preset,omitempty"`
}

func (x *VideoStream_H265CodecSettings) Reset() {
	*x = VideoStream_H265CodecSettings{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoStream_H265CodecSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoStream_H265CodecSettings) ProtoMessage() {}

func (x *VideoStream_H265CodecSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoStream_H265CodecSettings.ProtoReflect.Descriptor instead.
func (*VideoStream_H265CodecSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{14, 1}
}

func (x *VideoStream_H265CodecSettings) GetWidthPixels() int32 {
	if x != nil {
		return x.WidthPixels
	}
	return 0
}

func (x *VideoStream_H265CodecSettings) GetHeightPixels() int32 {
	if x != nil {
		return x.HeightPixels
	}
	return 0
}

func (x *VideoStream_H265CodecSettings) GetFrameRate() float64 {
	if x != nil {
		return x.FrameRate
	}
	return 0
}

func (x *VideoStream_H265CodecSettings) GetBitrateBps() int32 {
	if x != nil {
		return x.BitrateBps
	}
	return 0
}

func (x *VideoStream_H265CodecSettings) GetPixelFormat() string {
	if x != nil {
		return x.PixelFormat
	}
	return ""
}

func (x *VideoStream_H265CodecSettings) GetRateControlMode() string {
	if x != nil {
		return x.RateControlMode
	}
	return ""
}

func (x *VideoStream_H265CodecSettings) GetCrfLevel() int32 {
	if x != nil {
		return x.CrfLevel
	}
	return 0
}

func (x *VideoStream_H265CodecSettings) GetAllowOpenGop() bool {
	if x != nil {
		return x.AllowOpenGop
	}
	return false
}

func (m *VideoStream_H265CodecSettings) GetGopMode() isVideoStream_H265CodecSettings_GopMode {
	if m != nil {
		return m.GopMode
	}
	return nil
}

func (x *VideoStream_H265CodecSettings) GetGopFrameCount() int32 {
	if x, ok := x.GetGopMode().(*VideoStream_H265CodecSettings_GopFrameCount); ok {
		return x.GopFrameCount
	}
	return 0
}

func (x *VideoStream_H265CodecSettings) GetGopDuration() *durationpb.Duration {
	if x, ok := x.GetGopMode().(*VideoStream_H265CodecSettings_GopDuration); ok {
		return x.GopDuration
	}
	return nil
}

func (x *VideoStream_H265CodecSettings) GetEnableTwoPass() bool {
	if x != nil {
		return x.EnableTwoPass
	}
	return false
}

func (x *VideoStream_H265CodecSettings) GetVbvSizeBits() int32 {
	if x != nil {
		return x.VbvSizeBits
	}
	return 0
}

func (x *VideoStream_H265CodecSettings) GetVbvFullnessBits() int32 {
	if x != nil {
		return x.VbvFullnessBits
	}
	return 0
}

func (x *VideoStream_H265CodecSettings) GetBPyramid() bool {
	if x != nil {
		return x.BPyramid
	}
	return false
}

func (x *VideoStream_H265CodecSettings) GetBFrameCount() int32 {
	if x != nil {
		return x.BFrameCount
	}
	return 0
}

func (x *VideoStream_H265CodecSettings) GetAqStrength() float64 {
	if x != nil {
		return x.AqStrength
	}
	return 0
}

func (x *VideoStream_H265CodecSettings) GetProfile() string {
	if x != nil {
		return x.Profile
	}
	return ""
}

func (x *VideoStream_H265CodecSettings) GetTune() string {
	if x != nil {
		return x.Tune
	}
	return ""
}

func (x *VideoStream_H265CodecSettings) GetPreset() string {
	if x != nil {
		return x.Preset
	}
	return ""
}

type isVideoStream_H265CodecSettings_GopMode interface {
	isVideoStream_H265CodecSettings_GopMode()
}

type VideoStream_H265CodecSettings_GopFrameCount struct {
	// Select the GOP size based on the specified frame count. Must be greater
	// than zero.
	GopFrameCount int32 `protobuf:"varint,9,opt,name=gop_frame_count,json=gopFrameCount,proto3,oneof"`
}

type VideoStream_H265CodecSettings_GopDuration struct {
	// Select the GOP size based on the specified duration. The default is
	// `3s`. Note that `gopDuration` must be less than or equal to
	// [`segmentDuration`](#SegmentSettings), and
	// [`segmentDuration`](#SegmentSettings) must be divisible by
	// `gopDuration`.
	GopDuration *durationpb.Duration `protobuf:"bytes,10,opt,name=gop_duration,json=gopDuration,proto3,oneof"`
}

func (*VideoStream_H265CodecSettings_GopFrameCount) isVideoStream_H265CodecSettings_GopMode() {}

func (*VideoStream_H265CodecSettings_GopDuration) isVideoStream_H265CodecSettings_GopMode() {}

// VP9 codec settings.
type VideoStream_Vp9CodecSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The width of the video in pixels. Must be an even integer.
	// When not specified, the width is adjusted to match the specified height
	// and input aspect ratio. If both are omitted, the input width is used.
	//
	// For portrait videos that contain horizontal ASR and rotation metadata,
	// provide the width, in pixels, per the horizontal ASR. The API calculates
	// the height per the horizontal ASR. The API detects any rotation metadata
	// and swaps the requested height and width for the output.
	WidthPixels int32 `protobuf:"varint,1,opt,name=width_pixels,json=widthPixels,proto3" json:"width_pixels,omitempty"`
	// The height of the video in pixels. Must be an even integer.
	// When not specified, the height is adjusted to match the specified width
	// and input aspect ratio. If both are omitted, the input height is used.
	//
	// For portrait videos that contain horizontal ASR and rotation metadata,
	// provide the height, in pixels, per the horizontal ASR. The API calculates
	// the width per the horizontal ASR. The API detects any rotation metadata
	// and swaps the requested height and width for the output.
	HeightPixels int32 `protobuf:"varint,2,opt,name=height_pixels,json=heightPixels,proto3" json:"height_pixels,omitempty"`
	// Required. The target video frame rate in frames per second (FPS). Must be
	// less than or equal to 120. Will default to the input frame rate if larger
	// than the input frame rate. The API will generate an output FPS that is
	// divisible by the input FPS, and smaller or equal to the target FPS. See
	// [Calculating frame
	// rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
	// more information.
	FrameRate float64 `protobuf:"fixed64,3,opt,name=frame_rate,json=frameRate,proto3" json:"frame_rate,omitempty"`
	// Required. The video bitrate in bits per second. The minimum value is
	// 1,000. The maximum value is 480,000,000.
	BitrateBps int32 `protobuf:"varint,4,opt,name=bitrate_bps,json=bitrateBps,proto3" json:"bitrate_bps,omitempty"`
	// Pixel format to use. The default is `yuv420p`.
	//
	// Supported pixel formats:
	//
	// - `yuv420p` pixel format
	// - `yuv422p` pixel format
	// - `yuv444p` pixel format
	// - `yuv420p10` 10-bit HDR pixel format
	// - `yuv422p10` 10-bit HDR pixel format
	// - `yuv444p10` 10-bit HDR pixel format
	// - `yuv420p12` 12-bit HDR pixel format
	// - `yuv422p12` 12-bit HDR pixel format
	// - `yuv444p12` 12-bit HDR pixel format
	PixelFormat string `protobuf:"bytes,5,opt,name=pixel_format,json=pixelFormat,proto3" json:"pixel_format,omitempty"`
	// Specify the `rate_control_mode`. The default is `vbr`.
	//
	// Supported rate control modes:
	//
	// - `vbr` - variable bitrate
	RateControlMode string `protobuf:"bytes,6,opt,name=rate_control_mode,json=rateControlMode,proto3" json:"rate_control_mode,omitempty"`
	// Target CRF level. Must be between 10 and 36, where 10 is the highest
	// quality and 36 is the most efficient compression. The default is 21.
	//
	// **Note:** This field is not supported.
	CrfLevel int32 `protobuf:"varint,7,opt,name=crf_level,json=crfLevel,proto3" json:"crf_level,omitempty"`
	// GOP mode can be either by frame count or duration.
	//
	// Types that are assignable to GopMode:
	//
	//	*VideoStream_Vp9CodecSettings_GopFrameCount
	//	*VideoStream_Vp9CodecSettings_GopDuration
	GopMode isVideoStream_Vp9CodecSettings_GopMode `protobuf_oneof:"gop_mode"`
	// Enforces the specified codec profile. The following profiles are
	// supported:
	//
	// *   `profile0` (default)
	// *   `profile1`
	// *   `profile2`
	// *   `profile3`
	//
	// The available options are
	// [WebM-compatible](https://www.webmproject.org/vp9/profiles/).
	// Note that certain values for this field may cause the
	// transcoder to override other fields you set in the `Vp9CodecSettings`
	// message.
	Profile string `protobuf:"bytes,10,opt,name=profile,proto3" json:"profile,omitempty"`
}

func (x *VideoStream_Vp9CodecSettings) Reset() {
	*x = VideoStream_Vp9CodecSettings{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoStream_Vp9CodecSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoStream_Vp9CodecSettings) ProtoMessage() {}

func (x *VideoStream_Vp9CodecSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoStream_Vp9CodecSettings.ProtoReflect.Descriptor instead.
func (*VideoStream_Vp9CodecSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{14, 2}
}

func (x *VideoStream_Vp9CodecSettings) GetWidthPixels() int32 {
	if x != nil {
		return x.WidthPixels
	}
	return 0
}

func (x *VideoStream_Vp9CodecSettings) GetHeightPixels() int32 {
	if x != nil {
		return x.HeightPixels
	}
	return 0
}

func (x *VideoStream_Vp9CodecSettings) GetFrameRate() float64 {
	if x != nil {
		return x.FrameRate
	}
	return 0
}

func (x *VideoStream_Vp9CodecSettings) GetBitrateBps() int32 {
	if x != nil {
		return x.BitrateBps
	}
	return 0
}

func (x *VideoStream_Vp9CodecSettings) GetPixelFormat() string {
	if x != nil {
		return x.PixelFormat
	}
	return ""
}

func (x *VideoStream_Vp9CodecSettings) GetRateControlMode() string {
	if x != nil {
		return x.RateControlMode
	}
	return ""
}

func (x *VideoStream_Vp9CodecSettings) GetCrfLevel() int32 {
	if x != nil {
		return x.CrfLevel
	}
	return 0
}

func (m *VideoStream_Vp9CodecSettings) GetGopMode() isVideoStream_Vp9CodecSettings_GopMode {
	if m != nil {
		return m.GopMode
	}
	return nil
}

func (x *VideoStream_Vp9CodecSettings) GetGopFrameCount() int32 {
	if x, ok := x.GetGopMode().(*VideoStream_Vp9CodecSettings_GopFrameCount); ok {
		return x.GopFrameCount
	}
	return 0
}

func (x *VideoStream_Vp9CodecSettings) GetGopDuration() *durationpb.Duration {
	if x, ok := x.GetGopMode().(*VideoStream_Vp9CodecSettings_GopDuration); ok {
		return x.GopDuration
	}
	return nil
}

func (x *VideoStream_Vp9CodecSettings) GetProfile() string {
	if x != nil {
		return x.Profile
	}
	return ""
}

type isVideoStream_Vp9CodecSettings_GopMode interface {
	isVideoStream_Vp9CodecSettings_GopMode()
}

type VideoStream_Vp9CodecSettings_GopFrameCount struct {
	// Select the GOP size based on the specified frame count. Must be greater
	// than zero.
	GopFrameCount int32 `protobuf:"varint,8,opt,name=gop_frame_count,json=gopFrameCount,proto3,oneof"`
}

type VideoStream_Vp9CodecSettings_GopDuration struct {
	// Select the GOP size based on the specified duration. The default is
	// `3s`. Note that `gopDuration` must be less than or equal to
	// [`segmentDuration`](#SegmentSettings), and
	// [`segmentDuration`](#SegmentSettings) must be divisible by
	// `gopDuration`.
	GopDuration *durationpb.Duration `protobuf:"bytes,9,opt,name=gop_duration,json=gopDuration,proto3,oneof"`
}

func (*VideoStream_Vp9CodecSettings_GopFrameCount) isVideoStream_Vp9CodecSettings_GopMode() {}

func (*VideoStream_Vp9CodecSettings_GopDuration) isVideoStream_Vp9CodecSettings_GopMode() {}

// The mapping for the `Job.edit_list` atoms with audio `EditAtom.inputs`.
type AudioStream_AudioMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `EditAtom.key` that references the atom with audio inputs
	// in the `Job.edit_list`.
	AtomKey string `protobuf:"bytes,1,opt,name=atom_key,json=atomKey,proto3" json:"atom_key,omitempty"`
	// Required. The `Input.key` that identifies the input file.
	InputKey string `protobuf:"bytes,2,opt,name=input_key,json=inputKey,proto3" json:"input_key,omitempty"`
	// Required. The zero-based index of the track in the input file.
	InputTrack int32 `protobuf:"varint,3,opt,name=input_track,json=inputTrack,proto3" json:"input_track,omitempty"`
	// Required. The zero-based index of the channel in the input audio stream.
	InputChannel int32 `protobuf:"varint,4,opt,name=input_channel,json=inputChannel,proto3" json:"input_channel,omitempty"`
	// Required. The zero-based index of the channel in the output audio stream.
	OutputChannel int32 `protobuf:"varint,5,opt,name=output_channel,json=outputChannel,proto3" json:"output_channel,omitempty"`
	// Audio volume control in dB. Negative values decrease volume,
	// positive values increase. The default is 0.
	GainDb float64 `protobuf:"fixed64,6,opt,name=gain_db,json=gainDb,proto3" json:"gain_db,omitempty"`
}

func (x *AudioStream_AudioMapping) Reset() {
	*x = AudioStream_AudioMapping{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudioStream_AudioMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioStream_AudioMapping) ProtoMessage() {}

func (x *AudioStream_AudioMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioStream_AudioMapping.ProtoReflect.Descriptor instead.
func (*AudioStream_AudioMapping) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{15, 0}
}

func (x *AudioStream_AudioMapping) GetAtomKey() string {
	if x != nil {
		return x.AtomKey
	}
	return ""
}

func (x *AudioStream_AudioMapping) GetInputKey() string {
	if x != nil {
		return x.InputKey
	}
	return ""
}

func (x *AudioStream_AudioMapping) GetInputTrack() int32 {
	if x != nil {
		return x.InputTrack
	}
	return 0
}

func (x *AudioStream_AudioMapping) GetInputChannel() int32 {
	if x != nil {
		return x.InputChannel
	}
	return 0
}

func (x *AudioStream_AudioMapping) GetOutputChannel() int32 {
	if x != nil {
		return x.OutputChannel
	}
	return 0
}

func (x *AudioStream_AudioMapping) GetGainDb() float64 {
	if x != nil {
		return x.GainDb
	}
	return 0
}

// The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
type TextStream_TextMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `EditAtom.key` that references atom with text inputs in the
	// `Job.edit_list`.
	AtomKey string `protobuf:"bytes,1,opt,name=atom_key,json=atomKey,proto3" json:"atom_key,omitempty"`
	// Required. The `Input.key` that identifies the input file.
	InputKey string `protobuf:"bytes,2,opt,name=input_key,json=inputKey,proto3" json:"input_key,omitempty"`
	// Required. The zero-based index of the track in the input file.
	InputTrack int32 `protobuf:"varint,3,opt,name=input_track,json=inputTrack,proto3" json:"input_track,omitempty"`
}

func (x *TextStream_TextMapping) Reset() {
	*x = TextStream_TextMapping{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TextStream_TextMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextStream_TextMapping) ProtoMessage() {}

func (x *TextStream_TextMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextStream_TextMapping.ProtoReflect.Descriptor instead.
func (*TextStream_TextMapping) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{16, 0}
}

func (x *TextStream_TextMapping) GetAtomKey() string {
	if x != nil {
		return x.AtomKey
	}
	return ""
}

func (x *TextStream_TextMapping) GetInputKey() string {
	if x != nil {
		return x.InputKey
	}
	return ""
}

func (x *TextStream_TextMapping) GetInputTrack() int32 {
	if x != nil {
		return x.InputTrack
	}
	return 0
}

// Configuration for AES-128 encryption.
type Encryption_Aes128Encryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_Aes128Encryption) Reset() {
	*x = Encryption_Aes128Encryption{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_Aes128Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_Aes128Encryption) ProtoMessage() {}

func (x *Encryption_Aes128Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_Aes128Encryption.ProtoReflect.Descriptor instead.
func (*Encryption_Aes128Encryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{18, 0}
}

// Configuration for SAMPLE-AES encryption.
type Encryption_SampleAesEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_SampleAesEncryption) Reset() {
	*x = Encryption_SampleAesEncryption{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_SampleAesEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_SampleAesEncryption) ProtoMessage() {}

func (x *Encryption_SampleAesEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_SampleAesEncryption.ProtoReflect.Descriptor instead.
func (*Encryption_SampleAesEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{18, 1}
}

// Configuration for MPEG Common Encryption (MPEG-CENC).
type Encryption_MpegCommonEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specify the encryption scheme.
	//
	// Supported encryption schemes:
	//
	// - `cenc`
	// - `cbcs`
	Scheme string `protobuf:"bytes,2,opt,name=scheme,proto3" json:"scheme,omitempty"`
}

func (x *Encryption_MpegCommonEncryption) Reset() {
	*x = Encryption_MpegCommonEncryption{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_MpegCommonEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_MpegCommonEncryption) ProtoMessage() {}

func (x *Encryption_MpegCommonEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_MpegCommonEncryption.ProtoReflect.Descriptor instead.
func (*Encryption_MpegCommonEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{18, 2}
}

func (x *Encryption_MpegCommonEncryption) GetScheme() string {
	if x != nil {
		return x.Scheme
	}
	return ""
}

// Configuration for secrets stored in Google Secret Manager.
type Encryption_SecretManagerSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Secret Version containing the encryption key in
	// the following format:
	// `projects/{project}/secrets/{secret_id}/versions/{version_number}`
	//
	// Note that only numbered versions are supported. Aliases like "latest" are
	// not supported.
	SecretVersion string `protobuf:"bytes,1,opt,name=secret_version,json=secretVersion,proto3" json:"secret_version,omitempty"`
}

func (x *Encryption_SecretManagerSource) Reset() {
	*x = Encryption_SecretManagerSource{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_SecretManagerSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_SecretManagerSource) ProtoMessage() {}

func (x *Encryption_SecretManagerSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_SecretManagerSource.ProtoReflect.Descriptor instead.
func (*Encryption_SecretManagerSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{18, 3}
}

func (x *Encryption_SecretManagerSource) GetSecretVersion() string {
	if x != nil {
		return x.SecretVersion
	}
	return ""
}

// Widevine configuration.
type Encryption_Widevine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_Widevine) Reset() {
	*x = Encryption_Widevine{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_Widevine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_Widevine) ProtoMessage() {}

func (x *Encryption_Widevine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_Widevine.ProtoReflect.Descriptor instead.
func (*Encryption_Widevine) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{18, 4}
}

// Fairplay configuration.
type Encryption_Fairplay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_Fairplay) Reset() {
	*x = Encryption_Fairplay{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_Fairplay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_Fairplay) ProtoMessage() {}

func (x *Encryption_Fairplay) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_Fairplay.ProtoReflect.Descriptor instead.
func (*Encryption_Fairplay) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{18, 5}
}

// Playready configuration.
type Encryption_Playready struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_Playready) Reset() {
	*x = Encryption_Playready{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_Playready) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_Playready) ProtoMessage() {}

func (x *Encryption_Playready) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_Playready.ProtoReflect.Descriptor instead.
func (*Encryption_Playready) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{18, 6}
}

// Clearkey configuration.
type Encryption_Clearkey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Encryption_Clearkey) Reset() {
	*x = Encryption_Clearkey{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_Clearkey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_Clearkey) ProtoMessage() {}

func (x *Encryption_Clearkey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_Clearkey.ProtoReflect.Descriptor instead.
func (*Encryption_Clearkey) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{18, 7}
}

// Defines configuration for DRM systems in use.
type Encryption_DrmSystems struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Widevine configuration.
	Widevine *Encryption_Widevine `protobuf:"bytes,1,opt,name=widevine,proto3" json:"widevine,omitempty"`
	// Fairplay configuration.
	Fairplay *Encryption_Fairplay `protobuf:"bytes,2,opt,name=fairplay,proto3" json:"fairplay,omitempty"`
	// Playready configuration.
	Playready *Encryption_Playready `protobuf:"bytes,3,opt,name=playready,proto3" json:"playready,omitempty"`
	// Clearkey configuration.
	Clearkey *Encryption_Clearkey `protobuf:"bytes,4,opt,name=clearkey,proto3" json:"clearkey,omitempty"`
}

func (x *Encryption_DrmSystems) Reset() {
	*x = Encryption_DrmSystems{}
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption_DrmSystems) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption_DrmSystems) ProtoMessage() {}

func (x *Encryption_DrmSystems) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption_DrmSystems.ProtoReflect.Descriptor instead.
func (*Encryption_DrmSystems) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP(), []int{18, 8}
}

func (x *Encryption_DrmSystems) GetWidevine() *Encryption_Widevine {
	if x != nil {
		return x.Widevine
	}
	return nil
}

func (x *Encryption_DrmSystems) GetFairplay() *Encryption_Fairplay {
	if x != nil {
		return x.Fairplay
	}
	return nil
}

func (x *Encryption_DrmSystems) GetPlayready() *Encryption_Playready {
	if x != nil {
		return x.Playready
	}
	return nil
}

func (x *Encryption_DrmSystems) GetClearkey() *Encryption_Clearkey {
	if x != nil {
		return x.Clearkey
	}
	return nil
}

var File_google_cloud_video_transcoder_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_video_transcoder_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc9, 0x0a, 0x0a, 0x03, 0x4a,
	0x6f, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x08,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x22, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x04, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x26, 0x0a, 0x0b,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f,
	0x62, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x19, 0x74,
	0x74, 0x6c, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x05, 0x52, 0x16,
	0x74, 0x74, 0x6c, 0x41, 0x66, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x61, 0x79, 0x73, 0x12, 0x49, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x48, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x18, 0x15, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x62, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x6f,
	0x64, 0x65, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x63, 0x0a, 0x0c, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x68, 0x0a, 0x0f, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a,
	0x1c, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x04, 0x22, 0x6d, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53,
	0x53, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x52, 0x4f, 0x43, 0x45,
	0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52,
	0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x52, 0x4f, 0x43,
	0x45, 0x53, 0x53, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x42, 0x41, 0x54, 0x43,
	0x48, 0x10, 0x02, 0x22, 0x5b, 0x0a, 0x14, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x25, 0x0a, 0x21, 0x4f,
	0x50, 0x54, 0x49, 0x4d, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41,
	0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x55, 0x54, 0x4f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02,
	0x3a, 0x56, 0xea, 0x41, 0x53, 0x0a, 0x1d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4a, 0x6f, 0x62, 0x12, 0x32, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6a, 0x6f,
	0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x42, 0x0c, 0x0a, 0x0a, 0x6a, 0x6f, 0x62, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xe5, 0x02, 0x0a, 0x0b, 0x4a, 0x6f, 0x62, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f,
	0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x6f, 0xea,
	0x41, 0x6c, 0x0a, 0x25, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f,
	0x62, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f,
	0x7b, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x22, 0xe9,
	0x06, 0x0a, 0x09, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x0a, 0x06,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x47, 0x0a,
	0x09, 0x65, 0x64, 0x69, 0x74, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x64, 0x69, 0x74, 0x41, 0x74, 0x6f, 0x6d, 0x52, 0x08, 0x65, 0x64,
	0x69, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x12, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x11, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x72, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x6d, 0x75, 0x78,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x75, 0x78, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x0a, 0x6d, 0x75, 0x78,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x48, 0x0a, 0x09, 0x6d, 0x61, 0x6e, 0x69, 0x66,
	0x65, 0x73, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x09, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x73, 0x12, 0x40, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x06, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x12, 0x46, 0x0a, 0x09, 0x61, 0x64, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x42, 0x72, 0x65, 0x61,
	0x6b, 0x52, 0x08, 0x61, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x73, 0x12, 0x62, 0x0a, 0x12, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x52, 0x0a, 0x0d, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x68, 0x65, 0x65, 0x74, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x72, 0x69, 0x74, 0x65,
	0x53, 0x68, 0x65, 0x65, 0x74, 0x52, 0x0c, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x53, 0x68, 0x65,
	0x65, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79,
	0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x73, 0x12, 0x4e, 0x0a, 0x0b, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x95, 0x01, 0x0a, 0x05, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x68, 0x0a, 0x14, 0x70, 0x72, 0x65, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x70,
	0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x1a, 0x0a, 0x06, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0xbe,
	0x01, 0x0a, 0x08, 0x45, 0x64, 0x69, 0x74, 0x41, 0x74, 0x6f, 0x6d, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x16, 0x0a,
	0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x41, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22,
	0x50, 0x0a, 0x07, 0x41, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x22, 0xb2, 0x02, 0x0a, 0x10, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x52, 0x0a, 0x0c, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x00, 0x52,
	0x0b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x52, 0x0a, 0x0c,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x12, 0x4f, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x42, 0x13, 0x0a, 0x11, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0x8a, 0x02, 0x0a, 0x09, 0x4d, 0x75, 0x78, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x12, 0x2d, 0x0a, 0x12, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x5f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x12, 0x5c, 0x0a, 0x10, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x22, 0xcc, 0x04, 0x0a, 0x08, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x50, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x24, 0x0a, 0x0b, 0x6d, 0x75, 0x78, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x75, 0x78, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x4b, 0x0a, 0x04, 0x64, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f,
	0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x2e,
	0x44, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x04, 0x64, 0x61,
	0x73, 0x68, 0x1a, 0x88, 0x02, 0x0a, 0x0a, 0x44, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x86, 0x01, 0x0a, 0x18, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x2e, 0x44, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x65, 0x52, 0x16, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x22, 0x71, 0x0a, 0x16, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x24, 0x53, 0x45, 0x47, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10,
	0x0a, 0x0c, 0x53, 0x45, 0x47, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x01,
	0x12, 0x1b, 0x0a, 0x17, 0x53, 0x45, 0x47, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x45, 0x4d, 0x50,
	0x4c, 0x41, 0x54, 0x45, 0x5f, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x10, 0x02, 0x22, 0x40, 0x0a,
	0x0c, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a,
	0x19, 0x4d, 0x41, 0x4e, 0x49, 0x46, 0x45, 0x53, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03,
	0x48, 0x4c, 0x53, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x53, 0x48, 0x10, 0x02, 0x42,
	0x11, 0x0a, 0x0f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x22, 0x29, 0x0a, 0x11, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x22, 0x8e, 0x04,
	0x0a, 0x0b, 0x53, 0x70, 0x72, 0x69, 0x74, 0x65, 0x53, 0x68, 0x65, 0x65, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x33, 0x0a, 0x13, 0x73,
	0x70, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x69, 0x78, 0x65,
	0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x73,
	0x70, 0x72, 0x69, 0x74, 0x65, 0x57, 0x69, 0x64, 0x74, 0x68, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73,
	0x12, 0x35, 0x0a, 0x14, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x68, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x12, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x48, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f,
	0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x72,
	0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x41,
	0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0d, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x21, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x18, 0x0a,
	0x07, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07,
	0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x15, 0x0a, 0x13, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x22, 0xbf,
	0x0a, 0x0a, 0x07, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x12, 0x45, 0x0a, 0x05, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x76, 0x65,
	0x72, 0x6c, 0x61, 0x79, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x12, 0x53, 0x0a, 0x0a, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79,
	0x2e, 0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x61, 0x6e, 0x69, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x32, 0x0a, 0x14, 0x4e, 0x6f, 0x72, 0x6d, 0x61, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x12, 0x0c,
	0x0a, 0x01, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x01, 0x78, 0x12, 0x0c, 0x0a, 0x01,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x01, 0x79, 0x1a, 0x94, 0x01, 0x0a, 0x05, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x5e, 0x0a, 0x0a, 0x72,
	0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x52,
	0x0a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x1a, 0xa8, 0x01, 0x0a, 0x0f, 0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x69, 0x63, 0x12, 0x4e, 0x0a, 0x02, 0x78, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x2e, 0x4e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74,
	0x65, 0x52, 0x02, 0x78, 0x79, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x1a, 0xbf, 0x02, 0x0a,
	0x0d, 0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x64, 0x65, 0x12, 0x54,
	0x0a, 0x09, 0x66, 0x61, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x2e, 0x46, 0x61, 0x64,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x66, 0x61, 0x64, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x4e, 0x0a, 0x02, 0x78, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x2e, 0x4e, 0x6f, 0x72, 0x6d,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65,
	0x52, 0x02, 0x78, 0x79, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x41, 0x0a, 0x0f, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0d, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x1a, 0x55,
	0x0a, 0x0c, 0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x12, 0x45,
	0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x1a, 0xc6, 0x02, 0x0a, 0x09, 0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x10, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x2e, 0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x6e, 0x69, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x12, 0x60, 0x0a, 0x0e, 0x61,
	0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x64, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f,
	0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x2e, 0x41,
	0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x64, 0x65, 0x48, 0x00, 0x52, 0x0d,
	0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x64, 0x65, 0x12, 0x5d, 0x0a,
	0x0d, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x2e,
	0x41, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x0c,
	0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x42, 0x10, 0x0a, 0x0e,
	0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x40,
	0x0a, 0x08, 0x46, 0x61, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x41,
	0x44, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x41, 0x44, 0x45, 0x5f, 0x49, 0x4e,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x41, 0x44, 0x45, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x02,
	0x22, 0xe3, 0x0d, 0x0a, 0x13, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x51, 0x0a, 0x05, 0x63, 0x6f, 0x6c, 0x6f,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43,
	0x6f, 0x6c, 0x6f, 0x72, 0x52, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x57, 0x0a, 0x07, 0x64,
	0x65, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x44, 0x65, 0x6e, 0x6f, 0x69, 0x73, 0x65, 0x52, 0x07, 0x64, 0x65, 0x6e,
	0x6f, 0x69, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x07, 0x64, 0x65, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x65, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x07, 0x64, 0x65, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x51, 0x0a,
	0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f,
	0x12, 0x4e, 0x0a, 0x04, 0x63, 0x72, 0x6f, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x72, 0x6f, 0x70, 0x52, 0x04, 0x63, 0x72, 0x6f, 0x70,
	0x12, 0x4b, 0x0a, 0x03, 0x70, 0x61, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x61, 0x64, 0x52, 0x03, 0x70, 0x61, 0x64, 0x12, 0x63, 0x0a,
	0x0b, 0x64, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6c, 0x61, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x65, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x0b, 0x64, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6c, 0x61,
	0x63, 0x65, 0x1a, 0x63, 0x0a, 0x05, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x73,
	0x61, 0x74, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x0a, 0x73, 0x61, 0x74, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x61, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x61, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x62, 0x72, 0x69, 0x67, 0x68,
	0x74, 0x6e, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x62, 0x72, 0x69,
	0x67, 0x68, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x1a, 0x39, 0x0a, 0x07, 0x44, 0x65, 0x6e, 0x6f, 0x69,
	0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x73, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x75, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x75,
	0x6e, 0x65, 0x1a, 0x3f, 0x0a, 0x07, 0x44, 0x65, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x1a, 0x0a,
	0x08, 0x73, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x08, 0x73, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x1a, 0x57, 0x0a, 0x05, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x12, 0x0a, 0x04,
	0x6c, 0x75, 0x66, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x6c, 0x75, 0x66, 0x73,
	0x12, 0x1d, 0x0a, 0x0a, 0x68, 0x69, 0x67, 0x68, 0x5f, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x68, 0x69, 0x67, 0x68, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x6c, 0x6f, 0x77, 0x5f, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x08, 0x6c, 0x6f, 0x77, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x1a, 0x8e, 0x01, 0x0a,
	0x04, 0x43, 0x72, 0x6f, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x70, 0x5f, 0x70, 0x69, 0x78,
	0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x50, 0x69,
	0x78, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x5f, 0x70,
	0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x62, 0x6f, 0x74,
	0x74, 0x6f, 0x6d, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x65, 0x66,
	0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a,
	0x6c, 0x65, 0x66, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x69,
	0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0b, 0x72, 0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x1a, 0x8d, 0x01,
	0x0a, 0x03, 0x50, 0x61, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x70, 0x5f, 0x70, 0x69, 0x78,
	0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x50, 0x69,
	0x78, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x5f, 0x70,
	0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x62, 0x6f, 0x74,
	0x74, 0x6f, 0x6d, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x65, 0x66,
	0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a,
	0x6c, 0x65, 0x66, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x69,
	0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0b, 0x72, 0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x1a, 0x96, 0x04,
	0x0a, 0x0b, 0x44, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x65, 0x0a,
	0x05, 0x79, 0x61, 0x64, 0x69, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x44, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6c, 0x61, 0x63, 0x65, 0x2e,
	0x59, 0x61, 0x64, 0x69, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x05, 0x79,
	0x61, 0x64, 0x69, 0x66, 0x12, 0x65, 0x0a, 0x05, 0x62, 0x77, 0x64, 0x69, 0x66, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f,
	0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x65, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x42, 0x77, 0x64, 0x69, 0x66, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x05, 0x62, 0x77, 0x64, 0x69, 0x66, 0x1a, 0xaf, 0x01, 0x0a, 0x0b,
	0x59, 0x61, 0x64, 0x69, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12,
	0x3e, 0x0a, 0x1b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x61, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6c, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x61,
	0x74, 0x69, 0x61, 0x6c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6c, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x12,
	0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x65, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x64, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6c, 0x61, 0x63, 0x65, 0x41, 0x6c, 0x6c, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x1a, 0x6f, 0x0a,
	0x0b, 0x42, 0x77, 0x64, 0x69, 0x66, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04,
	0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x65, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x64, 0x65, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6c, 0x61, 0x63, 0x65, 0x41, 0x6c, 0x6c, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x42, 0x16,
	0x0a, 0x14, 0x64, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6c, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x89, 0x11, 0x0a, 0x0b, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x55, 0x0a, 0x04, 0x68, 0x32, 0x36, 0x34, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x48, 0x32, 0x36, 0x34, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x04, 0x68, 0x32, 0x36, 0x34, 0x12, 0x55, 0x0a,
	0x04, 0x68, 0x32, 0x36, 0x35, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x48, 0x32, 0x36, 0x35, 0x43,
	0x6f, 0x64, 0x65, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x00, 0x52, 0x04,
	0x68, 0x32, 0x36, 0x35, 0x12, 0x52, 0x0a, 0x03, 0x76, 0x70, 0x39, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x56, 0x70, 0x39, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x48, 0x00, 0x52, 0x03, 0x76, 0x70, 0x39, 0x1a, 0xf2, 0x05, 0x0a, 0x11, 0x48, 0x32, 0x36,
	0x34, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x21,
	0x0a, 0x0c, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77, 0x69, 0x64, 0x74, 0x68, 0x50, 0x69, 0x78, 0x65, 0x6c,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65,
	0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x69,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x62, 0x70, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x42, 0x70, 0x73,
	0x12, 0x21, 0x0a, 0x0c, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x63, 0x72, 0x66, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x63, 0x72, 0x66, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x24, 0x0a, 0x0e,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x67, 0x6f, 0x70, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4f, 0x70, 0x65, 0x6e, 0x47,
	0x6f, 0x70, 0x12, 0x28, 0x0a, 0x0f, 0x67, 0x6f, 0x70, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0d, 0x67,
	0x6f, 0x70, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x0c,
	0x67, 0x6f, 0x70, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x0b, 0x67, 0x6f, 0x70, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x77, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x77, 0x6f,
	0x50, 0x61, 0x73, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x76, 0x62, 0x76, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x76, 0x62, 0x76,
	0x53, 0x69, 0x7a, 0x65, 0x42, 0x69, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x76, 0x62, 0x76, 0x5f,
	0x66, 0x75, 0x6c, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0f, 0x76, 0x62, 0x76, 0x46, 0x75, 0x6c, 0x6c, 0x6e, 0x65, 0x73, 0x73,
	0x42, 0x69, 0x74, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x70, 0x79, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x6e, 0x74,
	0x72, 0x6f, 0x70, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x5f, 0x70,
	0x79, 0x72, 0x61, 0x6d, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x62, 0x50,
	0x79, 0x72, 0x61, 0x6d, 0x69, 0x64, 0x12, 0x22, 0x0a, 0x0d, 0x62, 0x5f, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x62,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x71,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x11, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x0a, 0x61, 0x71, 0x53, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x75, 0x6e, 0x65, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x75, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x72, 0x65,
	0x73, 0x65, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x72, 0x65, 0x73, 0x65,
	0x74, 0x42, 0x0a, 0x0a, 0x08, 0x67, 0x6f, 0x70, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x1a, 0xcd, 0x05,
	0x0a, 0x11, 0x48, 0x32, 0x36, 0x35, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x69, 0x78,
	0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
	0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x68,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x66,
	0x72, 0x61, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x61, 0x74, 0x65, 0x12,
	0x24, 0x0a, 0x0b, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x62, 0x70, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x69, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x42, 0x70, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x5f, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x69, 0x78,
	0x65, 0x6c, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x61, 0x74, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x72, 0x66, 0x5f, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x63, 0x72, 0x66, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6f, 0x70, 0x65, 0x6e, 0x5f,
	0x67, 0x6f, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x4f, 0x70, 0x65, 0x6e, 0x47, 0x6f, 0x70, 0x12, 0x28, 0x0a, 0x0f, 0x67, 0x6f, 0x70, 0x5f, 0x66,
	0x72, 0x61, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x00, 0x52, 0x0d, 0x67, 0x6f, 0x70, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x3e, 0x0a, 0x0c, 0x67, 0x6f, 0x70, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x6f, 0x70, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x26, 0x0a, 0x0f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x77, 0x6f, 0x5f,
	0x70, 0x61, 0x73, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x54, 0x77, 0x6f, 0x50, 0x61, 0x73, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x76, 0x62, 0x76,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0b, 0x76, 0x62, 0x76, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x69, 0x74, 0x73, 0x12, 0x2a, 0x0a,
	0x11, 0x76, 0x62, 0x76, 0x5f, 0x66, 0x75, 0x6c, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69,
	0x74, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x76, 0x62, 0x76, 0x46, 0x75, 0x6c,
	0x6c, 0x6e, 0x65, 0x73, 0x73, 0x42, 0x69, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x5f, 0x70,
	0x79, 0x72, 0x61, 0x6d, 0x69, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x62, 0x50,
	0x79, 0x72, 0x61, 0x6d, 0x69, 0x64, 0x12, 0x22, 0x0a, 0x0d, 0x62, 0x5f, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x62,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x71,
	0x5f, 0x73, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x10, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x0a, 0x61, 0x71, 0x53, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x75, 0x6e, 0x65, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x75, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x72, 0x65,
	0x73, 0x65, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x72, 0x65, 0x73, 0x65,
	0x74, 0x42, 0x0a, 0x0a, 0x08, 0x67, 0x6f, 0x70, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x1a, 0xa0, 0x03,
	0x0a, 0x10, 0x56, 0x70, 0x39, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x69, 0x78, 0x65,
	0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77, 0x69, 0x64, 0x74, 0x68, 0x50,
	0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f,
	0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x68, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x72,
	0x61, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x61, 0x74, 0x65, 0x12, 0x24,
	0x0a, 0x0b, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x62, 0x70, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x42, 0x70, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x5f, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x69, 0x78, 0x65,
	0x6c, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x72, 0x66, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x63, 0x72, 0x66, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x12, 0x28, 0x0a, 0x0f, 0x67, 0x6f, 0x70, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x6f, 0x70,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x0c, 0x67, 0x6f,
	0x70, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x67,
	0x6f, 0x70, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x67, 0x6f, 0x70, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x42, 0x10, 0x0a, 0x0e, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x22, 0xc7, 0x04, 0x0a, 0x0b, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x69, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x62, 0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x42, 0x70, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x6c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x54, 0x0a, 0x07, 0x6d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x12, 0x2a, 0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x68, 0x65, 0x72, 0x74, 0x7a, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x73, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x12, 0x23, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x1a, 0xe5, 0x01, 0x0a, 0x0c, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x4d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x1e, 0x0a, 0x08, 0x61, 0x74, 0x6f, 0x6d, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x74,
	0x6f, 0x6d, 0x4b, 0x65, 0x79, 0x12, 0x20, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x12, 0x28, 0x0a,
	0x0d, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x2a, 0x0a, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x12, 0x17, 0x0a, 0x07, 0x67, 0x61, 0x69, 0x6e, 0x5f, 0x64, 0x62, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x01, 0x52, 0x06, 0x67, 0x61, 0x69, 0x6e, 0x44, 0x62, 0x22, 0xb5, 0x02, 0x0a,
	0x0a, 0x54, 0x65, 0x78, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x14, 0x0a, 0x05, 0x63,
	0x6f, 0x64, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x6f, 0x64, 0x65,
	0x63, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x52, 0x0a, 0x07, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x75, 0x0a,
	0x0b, 0x54, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x1e, 0x0a, 0x08,
	0x61, 0x74, 0x6f, 0x6d, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x74, 0x6f, 0x6d, 0x4b, 0x65, 0x79, 0x12, 0x20, 0x0a, 0x09,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x24,
	0x0a, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x54,
	0x72, 0x61, 0x63, 0x6b, 0x22, 0x8d, 0x01, 0x0a, 0x0f, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x44, 0x0a, 0x10, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34,
	0x0a, 0x13, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x12, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x22, 0xf4, 0x08, 0x0a, 0x0a, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x69, 0x64, 0x12, 0x58, 0x0a, 0x07, 0x61, 0x65, 0x73, 0x5f,
	0x31, 0x32, 0x38, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x65, 0x73, 0x31, 0x32, 0x38, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x61, 0x65, 0x73, 0x31,
	0x32, 0x38, 0x12, 0x61, 0x0a, 0x0a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x61, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x41, 0x65, 0x73, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x09, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x41, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x09, 0x6d, 0x70, 0x65, 0x67, 0x5f, 0x63, 0x65,
	0x6e, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x70, 0x65, 0x67, 0x43, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x08, 0x6d,
	0x70, 0x65, 0x67, 0x43, 0x65, 0x6e, 0x63, 0x12, 0x7d, 0x0a, 0x19, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x01, 0x52, 0x16,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4b, 0x65, 0x79,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x0b, 0x64, 0x72, 0x6d, 0x5f, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x72, 0x6d, 0x53, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x72, 0x6d, 0x53, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x73, 0x1a, 0x12, 0x0a, 0x10, 0x41, 0x65, 0x73, 0x31, 0x32, 0x38, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x15, 0x0a, 0x13, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x41, 0x65, 0x73, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x33, 0x0a, 0x14, 0x4d, 0x70, 0x65, 0x67, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x65, 0x1a, 0x41, 0x0a, 0x13, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2a, 0x0a, 0x0e,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x0a, 0x0a, 0x08, 0x57, 0x69, 0x64, 0x65,
	0x76, 0x69, 0x6e, 0x65, 0x1a, 0x0a, 0x0a, 0x08, 0x46, 0x61, 0x69, 0x72, 0x70, 0x6c, 0x61, 0x79,
	0x1a, 0x0b, 0x0a, 0x09, 0x50, 0x6c, 0x61, 0x79, 0x72, 0x65, 0x61, 0x64, 0x79, 0x1a, 0x0a, 0x0a,
	0x08, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x6b, 0x65, 0x79, 0x1a, 0xdb, 0x02, 0x0a, 0x0a, 0x44, 0x72,
	0x6d, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x51, 0x0a, 0x08, 0x77, 0x69, 0x64, 0x65,
	0x76, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x57, 0x69, 0x64, 0x65, 0x76, 0x69, 0x6e,
	0x65, 0x52, 0x08, 0x77, 0x69, 0x64, 0x65, 0x76, 0x69, 0x6e, 0x65, 0x12, 0x51, 0x0a, 0x08, 0x66,
	0x61, 0x69, 0x72, 0x70, 0x6c, 0x61, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x61, 0x69, 0x72,
	0x70, 0x6c, 0x61, 0x79, 0x52, 0x08, 0x66, 0x61, 0x69, 0x72, 0x70, 0x6c, 0x61, 0x79, 0x12, 0x54,
	0x0a, 0x09, 0x70, 0x6c, 0x61, 0x79, 0x72, 0x65, 0x61, 0x64, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x50, 0x6c, 0x61, 0x79, 0x72, 0x65, 0x61, 0x64, 0x79, 0x52, 0x09, 0x70, 0x6c, 0x61, 0x79, 0x72,
	0x65, 0x61, 0x64, 0x79, 0x12, 0x51, 0x0a, 0x08, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x6b, 0x65, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6c, 0x65, 0x61, 0x72, 0x6b, 0x65, 0x79, 0x52, 0x08, 0x63,
	0x6c, 0x65, 0x61, 0x72, 0x6b, 0x65, 0x79, 0x42, 0x11, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x7e, 0x0a, 0x24, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x42, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_video_transcoder_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_video_transcoder_v1_resources_proto_rawDescData = file_google_cloud_video_transcoder_v1_resources_proto_rawDesc
)

func file_google_cloud_video_transcoder_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_video_transcoder_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_video_transcoder_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_video_transcoder_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_video_transcoder_v1_resources_proto_rawDescData
}

var file_google_cloud_video_transcoder_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_video_transcoder_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 51)
var file_google_cloud_video_transcoder_v1_resources_proto_goTypes = []any{
	(Job_ProcessingState)(0),                            // 0: google.cloud.video.transcoder.v1.Job.ProcessingState
	(Job_ProcessingMode)(0),                             // 1: google.cloud.video.transcoder.v1.Job.ProcessingMode
	(Job_OptimizationStrategy)(0),                       // 2: google.cloud.video.transcoder.v1.Job.OptimizationStrategy
	(Manifest_ManifestType)(0),                          // 3: google.cloud.video.transcoder.v1.Manifest.ManifestType
	(Manifest_DashConfig_SegmentReferenceScheme)(0),     // 4: google.cloud.video.transcoder.v1.Manifest.DashConfig.SegmentReferenceScheme
	(Overlay_FadeType)(0),                               // 5: google.cloud.video.transcoder.v1.Overlay.FadeType
	(*Job)(nil),                                         // 6: google.cloud.video.transcoder.v1.Job
	(*JobTemplate)(nil),                                 // 7: google.cloud.video.transcoder.v1.JobTemplate
	(*JobConfig)(nil),                                   // 8: google.cloud.video.transcoder.v1.JobConfig
	(*Input)(nil),                                       // 9: google.cloud.video.transcoder.v1.Input
	(*Output)(nil),                                      // 10: google.cloud.video.transcoder.v1.Output
	(*EditAtom)(nil),                                    // 11: google.cloud.video.transcoder.v1.EditAtom
	(*AdBreak)(nil),                                     // 12: google.cloud.video.transcoder.v1.AdBreak
	(*ElementaryStream)(nil),                            // 13: google.cloud.video.transcoder.v1.ElementaryStream
	(*MuxStream)(nil),                                   // 14: google.cloud.video.transcoder.v1.MuxStream
	(*Manifest)(nil),                                    // 15: google.cloud.video.transcoder.v1.Manifest
	(*PubsubDestination)(nil),                           // 16: google.cloud.video.transcoder.v1.PubsubDestination
	(*SpriteSheet)(nil),                                 // 17: google.cloud.video.transcoder.v1.SpriteSheet
	(*Overlay)(nil),                                     // 18: google.cloud.video.transcoder.v1.Overlay
	(*PreprocessingConfig)(nil),                         // 19: google.cloud.video.transcoder.v1.PreprocessingConfig
	(*VideoStream)(nil),                                 // 20: google.cloud.video.transcoder.v1.VideoStream
	(*AudioStream)(nil),                                 // 21: google.cloud.video.transcoder.v1.AudioStream
	(*TextStream)(nil),                                  // 22: google.cloud.video.transcoder.v1.TextStream
	(*SegmentSettings)(nil),                             // 23: google.cloud.video.transcoder.v1.SegmentSettings
	(*Encryption)(nil),                                  // 24: google.cloud.video.transcoder.v1.Encryption
	nil,                                                 // 25: google.cloud.video.transcoder.v1.Job.LabelsEntry
	nil,                                                 // 26: google.cloud.video.transcoder.v1.JobTemplate.LabelsEntry
	(*Manifest_DashConfig)(nil),                         // 27: google.cloud.video.transcoder.v1.Manifest.DashConfig
	(*Overlay_NormalizedCoordinate)(nil),                // 28: google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
	(*Overlay_Image)(nil),                               // 29: google.cloud.video.transcoder.v1.Overlay.Image
	(*Overlay_AnimationStatic)(nil),                     // 30: google.cloud.video.transcoder.v1.Overlay.AnimationStatic
	(*Overlay_AnimationFade)(nil),                       // 31: google.cloud.video.transcoder.v1.Overlay.AnimationFade
	(*Overlay_AnimationEnd)(nil),                        // 32: google.cloud.video.transcoder.v1.Overlay.AnimationEnd
	(*Overlay_Animation)(nil),                           // 33: google.cloud.video.transcoder.v1.Overlay.Animation
	(*PreprocessingConfig_Color)(nil),                   // 34: google.cloud.video.transcoder.v1.PreprocessingConfig.Color
	(*PreprocessingConfig_Denoise)(nil),                 // 35: google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise
	(*PreprocessingConfig_Deblock)(nil),                 // 36: google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock
	(*PreprocessingConfig_Audio)(nil),                   // 37: google.cloud.video.transcoder.v1.PreprocessingConfig.Audio
	(*PreprocessingConfig_Crop)(nil),                    // 38: google.cloud.video.transcoder.v1.PreprocessingConfig.Crop
	(*PreprocessingConfig_Pad)(nil),                     // 39: google.cloud.video.transcoder.v1.PreprocessingConfig.Pad
	(*PreprocessingConfig_Deinterlace)(nil),             // 40: google.cloud.video.transcoder.v1.PreprocessingConfig.Deinterlace
	(*PreprocessingConfig_Deinterlace_YadifConfig)(nil), // 41: google.cloud.video.transcoder.v1.PreprocessingConfig.Deinterlace.YadifConfig
	(*PreprocessingConfig_Deinterlace_BwdifConfig)(nil), // 42: google.cloud.video.transcoder.v1.PreprocessingConfig.Deinterlace.BwdifConfig
	(*VideoStream_H264CodecSettings)(nil),               // 43: google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
	(*VideoStream_H265CodecSettings)(nil),               // 44: google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
	(*VideoStream_Vp9CodecSettings)(nil),                // 45: google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
	(*AudioStream_AudioMapping)(nil),                    // 46: google.cloud.video.transcoder.v1.AudioStream.AudioMapping
	(*TextStream_TextMapping)(nil),                      // 47: google.cloud.video.transcoder.v1.TextStream.TextMapping
	(*Encryption_Aes128Encryption)(nil),                 // 48: google.cloud.video.transcoder.v1.Encryption.Aes128Encryption
	(*Encryption_SampleAesEncryption)(nil),              // 49: google.cloud.video.transcoder.v1.Encryption.SampleAesEncryption
	(*Encryption_MpegCommonEncryption)(nil),             // 50: google.cloud.video.transcoder.v1.Encryption.MpegCommonEncryption
	(*Encryption_SecretManagerSource)(nil),              // 51: google.cloud.video.transcoder.v1.Encryption.SecretManagerSource
	(*Encryption_Widevine)(nil),                         // 52: google.cloud.video.transcoder.v1.Encryption.Widevine
	(*Encryption_Fairplay)(nil),                         // 53: google.cloud.video.transcoder.v1.Encryption.Fairplay
	(*Encryption_Playready)(nil),                        // 54: google.cloud.video.transcoder.v1.Encryption.Playready
	(*Encryption_Clearkey)(nil),                         // 55: google.cloud.video.transcoder.v1.Encryption.Clearkey
	(*Encryption_DrmSystems)(nil),                       // 56: google.cloud.video.transcoder.v1.Encryption.DrmSystems
	(*timestamppb.Timestamp)(nil),                       // 57: google.protobuf.Timestamp
	(*status.Status)(nil),                               // 58: google.rpc.Status
	(*durationpb.Duration)(nil),                         // 59: google.protobuf.Duration
}
var file_google_cloud_video_transcoder_v1_resources_proto_depIdxs = []int32{
	8,  // 0: google.cloud.video.transcoder.v1.Job.config:type_name -> google.cloud.video.transcoder.v1.JobConfig
	0,  // 1: google.cloud.video.transcoder.v1.Job.state:type_name -> google.cloud.video.transcoder.v1.Job.ProcessingState
	57, // 2: google.cloud.video.transcoder.v1.Job.create_time:type_name -> google.protobuf.Timestamp
	57, // 3: google.cloud.video.transcoder.v1.Job.start_time:type_name -> google.protobuf.Timestamp
	57, // 4: google.cloud.video.transcoder.v1.Job.end_time:type_name -> google.protobuf.Timestamp
	25, // 5: google.cloud.video.transcoder.v1.Job.labels:type_name -> google.cloud.video.transcoder.v1.Job.LabelsEntry
	58, // 6: google.cloud.video.transcoder.v1.Job.error:type_name -> google.rpc.Status
	1,  // 7: google.cloud.video.transcoder.v1.Job.mode:type_name -> google.cloud.video.transcoder.v1.Job.ProcessingMode
	2,  // 8: google.cloud.video.transcoder.v1.Job.optimization:type_name -> google.cloud.video.transcoder.v1.Job.OptimizationStrategy
	8,  // 9: google.cloud.video.transcoder.v1.JobTemplate.config:type_name -> google.cloud.video.transcoder.v1.JobConfig
	26, // 10: google.cloud.video.transcoder.v1.JobTemplate.labels:type_name -> google.cloud.video.transcoder.v1.JobTemplate.LabelsEntry
	9,  // 11: google.cloud.video.transcoder.v1.JobConfig.inputs:type_name -> google.cloud.video.transcoder.v1.Input
	11, // 12: google.cloud.video.transcoder.v1.JobConfig.edit_list:type_name -> google.cloud.video.transcoder.v1.EditAtom
	13, // 13: google.cloud.video.transcoder.v1.JobConfig.elementary_streams:type_name -> google.cloud.video.transcoder.v1.ElementaryStream
	14, // 14: google.cloud.video.transcoder.v1.JobConfig.mux_streams:type_name -> google.cloud.video.transcoder.v1.MuxStream
	15, // 15: google.cloud.video.transcoder.v1.JobConfig.manifests:type_name -> google.cloud.video.transcoder.v1.Manifest
	10, // 16: google.cloud.video.transcoder.v1.JobConfig.output:type_name -> google.cloud.video.transcoder.v1.Output
	12, // 17: google.cloud.video.transcoder.v1.JobConfig.ad_breaks:type_name -> google.cloud.video.transcoder.v1.AdBreak
	16, // 18: google.cloud.video.transcoder.v1.JobConfig.pubsub_destination:type_name -> google.cloud.video.transcoder.v1.PubsubDestination
	17, // 19: google.cloud.video.transcoder.v1.JobConfig.sprite_sheets:type_name -> google.cloud.video.transcoder.v1.SpriteSheet
	18, // 20: google.cloud.video.transcoder.v1.JobConfig.overlays:type_name -> google.cloud.video.transcoder.v1.Overlay
	24, // 21: google.cloud.video.transcoder.v1.JobConfig.encryptions:type_name -> google.cloud.video.transcoder.v1.Encryption
	19, // 22: google.cloud.video.transcoder.v1.Input.preprocessing_config:type_name -> google.cloud.video.transcoder.v1.PreprocessingConfig
	59, // 23: google.cloud.video.transcoder.v1.EditAtom.end_time_offset:type_name -> google.protobuf.Duration
	59, // 24: google.cloud.video.transcoder.v1.EditAtom.start_time_offset:type_name -> google.protobuf.Duration
	59, // 25: google.cloud.video.transcoder.v1.AdBreak.start_time_offset:type_name -> google.protobuf.Duration
	20, // 26: google.cloud.video.transcoder.v1.ElementaryStream.video_stream:type_name -> google.cloud.video.transcoder.v1.VideoStream
	21, // 27: google.cloud.video.transcoder.v1.ElementaryStream.audio_stream:type_name -> google.cloud.video.transcoder.v1.AudioStream
	22, // 28: google.cloud.video.transcoder.v1.ElementaryStream.text_stream:type_name -> google.cloud.video.transcoder.v1.TextStream
	23, // 29: google.cloud.video.transcoder.v1.MuxStream.segment_settings:type_name -> google.cloud.video.transcoder.v1.SegmentSettings
	3,  // 30: google.cloud.video.transcoder.v1.Manifest.type:type_name -> google.cloud.video.transcoder.v1.Manifest.ManifestType
	27, // 31: google.cloud.video.transcoder.v1.Manifest.dash:type_name -> google.cloud.video.transcoder.v1.Manifest.DashConfig
	59, // 32: google.cloud.video.transcoder.v1.SpriteSheet.start_time_offset:type_name -> google.protobuf.Duration
	59, // 33: google.cloud.video.transcoder.v1.SpriteSheet.end_time_offset:type_name -> google.protobuf.Duration
	59, // 34: google.cloud.video.transcoder.v1.SpriteSheet.interval:type_name -> google.protobuf.Duration
	29, // 35: google.cloud.video.transcoder.v1.Overlay.image:type_name -> google.cloud.video.transcoder.v1.Overlay.Image
	33, // 36: google.cloud.video.transcoder.v1.Overlay.animations:type_name -> google.cloud.video.transcoder.v1.Overlay.Animation
	34, // 37: google.cloud.video.transcoder.v1.PreprocessingConfig.color:type_name -> google.cloud.video.transcoder.v1.PreprocessingConfig.Color
	35, // 38: google.cloud.video.transcoder.v1.PreprocessingConfig.denoise:type_name -> google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise
	36, // 39: google.cloud.video.transcoder.v1.PreprocessingConfig.deblock:type_name -> google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock
	37, // 40: google.cloud.video.transcoder.v1.PreprocessingConfig.audio:type_name -> google.cloud.video.transcoder.v1.PreprocessingConfig.Audio
	38, // 41: google.cloud.video.transcoder.v1.PreprocessingConfig.crop:type_name -> google.cloud.video.transcoder.v1.PreprocessingConfig.Crop
	39, // 42: google.cloud.video.transcoder.v1.PreprocessingConfig.pad:type_name -> google.cloud.video.transcoder.v1.PreprocessingConfig.Pad
	40, // 43: google.cloud.video.transcoder.v1.PreprocessingConfig.deinterlace:type_name -> google.cloud.video.transcoder.v1.PreprocessingConfig.Deinterlace
	43, // 44: google.cloud.video.transcoder.v1.VideoStream.h264:type_name -> google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
	44, // 45: google.cloud.video.transcoder.v1.VideoStream.h265:type_name -> google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
	45, // 46: google.cloud.video.transcoder.v1.VideoStream.vp9:type_name -> google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
	46, // 47: google.cloud.video.transcoder.v1.AudioStream.mapping:type_name -> google.cloud.video.transcoder.v1.AudioStream.AudioMapping
	47, // 48: google.cloud.video.transcoder.v1.TextStream.mapping:type_name -> google.cloud.video.transcoder.v1.TextStream.TextMapping
	59, // 49: google.cloud.video.transcoder.v1.SegmentSettings.segment_duration:type_name -> google.protobuf.Duration
	48, // 50: google.cloud.video.transcoder.v1.Encryption.aes_128:type_name -> google.cloud.video.transcoder.v1.Encryption.Aes128Encryption
	49, // 51: google.cloud.video.transcoder.v1.Encryption.sample_aes:type_name -> google.cloud.video.transcoder.v1.Encryption.SampleAesEncryption
	50, // 52: google.cloud.video.transcoder.v1.Encryption.mpeg_cenc:type_name -> google.cloud.video.transcoder.v1.Encryption.MpegCommonEncryption
	51, // 53: google.cloud.video.transcoder.v1.Encryption.secret_manager_key_source:type_name -> google.cloud.video.transcoder.v1.Encryption.SecretManagerSource
	56, // 54: google.cloud.video.transcoder.v1.Encryption.drm_systems:type_name -> google.cloud.video.transcoder.v1.Encryption.DrmSystems
	4,  // 55: google.cloud.video.transcoder.v1.Manifest.DashConfig.segment_reference_scheme:type_name -> google.cloud.video.transcoder.v1.Manifest.DashConfig.SegmentReferenceScheme
	28, // 56: google.cloud.video.transcoder.v1.Overlay.Image.resolution:type_name -> google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
	28, // 57: google.cloud.video.transcoder.v1.Overlay.AnimationStatic.xy:type_name -> google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
	59, // 58: google.cloud.video.transcoder.v1.Overlay.AnimationStatic.start_time_offset:type_name -> google.protobuf.Duration
	5,  // 59: google.cloud.video.transcoder.v1.Overlay.AnimationFade.fade_type:type_name -> google.cloud.video.transcoder.v1.Overlay.FadeType
	28, // 60: google.cloud.video.transcoder.v1.Overlay.AnimationFade.xy:type_name -> google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
	59, // 61: google.cloud.video.transcoder.v1.Overlay.AnimationFade.start_time_offset:type_name -> google.protobuf.Duration
	59, // 62: google.cloud.video.transcoder.v1.Overlay.AnimationFade.end_time_offset:type_name -> google.protobuf.Duration
	59, // 63: google.cloud.video.transcoder.v1.Overlay.AnimationEnd.start_time_offset:type_name -> google.protobuf.Duration
	30, // 64: google.cloud.video.transcoder.v1.Overlay.Animation.animation_static:type_name -> google.cloud.video.transcoder.v1.Overlay.AnimationStatic
	31, // 65: google.cloud.video.transcoder.v1.Overlay.Animation.animation_fade:type_name -> google.cloud.video.transcoder.v1.Overlay.AnimationFade
	32, // 66: google.cloud.video.transcoder.v1.Overlay.Animation.animation_end:type_name -> google.cloud.video.transcoder.v1.Overlay.AnimationEnd
	41, // 67: google.cloud.video.transcoder.v1.PreprocessingConfig.Deinterlace.yadif:type_name -> google.cloud.video.transcoder.v1.PreprocessingConfig.Deinterlace.YadifConfig
	42, // 68: google.cloud.video.transcoder.v1.PreprocessingConfig.Deinterlace.bwdif:type_name -> google.cloud.video.transcoder.v1.PreprocessingConfig.Deinterlace.BwdifConfig
	59, // 69: google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.gop_duration:type_name -> google.protobuf.Duration
	59, // 70: google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.gop_duration:type_name -> google.protobuf.Duration
	59, // 71: google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.gop_duration:type_name -> google.protobuf.Duration
	52, // 72: google.cloud.video.transcoder.v1.Encryption.DrmSystems.widevine:type_name -> google.cloud.video.transcoder.v1.Encryption.Widevine
	53, // 73: google.cloud.video.transcoder.v1.Encryption.DrmSystems.fairplay:type_name -> google.cloud.video.transcoder.v1.Encryption.Fairplay
	54, // 74: google.cloud.video.transcoder.v1.Encryption.DrmSystems.playready:type_name -> google.cloud.video.transcoder.v1.Encryption.Playready
	55, // 75: google.cloud.video.transcoder.v1.Encryption.DrmSystems.clearkey:type_name -> google.cloud.video.transcoder.v1.Encryption.Clearkey
	76, // [76:76] is the sub-list for method output_type
	76, // [76:76] is the sub-list for method input_type
	76, // [76:76] is the sub-list for extension type_name
	76, // [76:76] is the sub-list for extension extendee
	0,  // [0:76] is the sub-list for field type_name
}

func init() { file_google_cloud_video_transcoder_v1_resources_proto_init() }
func file_google_cloud_video_transcoder_v1_resources_proto_init() {
	if File_google_cloud_video_transcoder_v1_resources_proto != nil {
		return
	}
	file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[0].OneofWrappers = []any{
		(*Job_TemplateId)(nil),
		(*Job_Config)(nil),
	}
	file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[7].OneofWrappers = []any{
		(*ElementaryStream_VideoStream)(nil),
		(*ElementaryStream_AudioStream)(nil),
		(*ElementaryStream_TextStream)(nil),
	}
	file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[9].OneofWrappers = []any{
		(*Manifest_Dash)(nil),
	}
	file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[11].OneofWrappers = []any{
		(*SpriteSheet_TotalCount)(nil),
		(*SpriteSheet_Interval)(nil),
	}
	file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[14].OneofWrappers = []any{
		(*VideoStream_H264)(nil),
		(*VideoStream_H265)(nil),
		(*VideoStream_Vp9)(nil),
	}
	file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[18].OneofWrappers = []any{
		(*Encryption_Aes_128)(nil),
		(*Encryption_SampleAes)(nil),
		(*Encryption_MpegCenc)(nil),
		(*Encryption_SecretManagerKeySource)(nil),
	}
	file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[27].OneofWrappers = []any{
		(*Overlay_Animation_AnimationStatic)(nil),
		(*Overlay_Animation_AnimationFade)(nil),
		(*Overlay_Animation_AnimationEnd)(nil),
	}
	file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[34].OneofWrappers = []any{
		(*PreprocessingConfig_Deinterlace_Yadif)(nil),
		(*PreprocessingConfig_Deinterlace_Bwdif)(nil),
	}
	file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[37].OneofWrappers = []any{
		(*VideoStream_H264CodecSettings_GopFrameCount)(nil),
		(*VideoStream_H264CodecSettings_GopDuration)(nil),
	}
	file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[38].OneofWrappers = []any{
		(*VideoStream_H265CodecSettings_GopFrameCount)(nil),
		(*VideoStream_H265CodecSettings_GopDuration)(nil),
	}
	file_google_cloud_video_transcoder_v1_resources_proto_msgTypes[39].OneofWrappers = []any{
		(*VideoStream_Vp9CodecSettings_GopFrameCount)(nil),
		(*VideoStream_Vp9CodecSettings_GopDuration)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_video_transcoder_v1_resources_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   51,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_video_transcoder_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_video_transcoder_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_video_transcoder_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_video_transcoder_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_video_transcoder_v1_resources_proto = out.File
	file_google_cloud_video_transcoder_v1_resources_proto_rawDesc = nil
	file_google_cloud_video_transcoder_v1_resources_proto_goTypes = nil
	file_google_cloud_video_transcoder_v1_resources_proto_depIdxs = nil
}
