# 1.6.2

## Significant changes

* Upgrade to weave 1.9.8 fixes issues with NodePorts

## Full changelist

* Weave upgraded to 1.9.8, to fix NodePort issue (thanks @jordanjennings, @justinsb)
* Fixes for (experimental) k8s.local DNS-free configurations (thanks @justinsb)
* Weave now configured with the correct pod CIDR (thanks @jordanjennings)
* Initial support for kube-router networking (thanks @murali-reddy)
* Apply cloud-labels to EBS volumes (thanks @pastjean)
* Support empty `--resolv-conf` (thanks @austinmoore-)
* Add --subnet and --role flags to create ig command (thanks @dtan4)
* Improvements to `kops delete` output (thanks @chrislovecnm)
* Match type (public/private) of DNS zones when matching (thanks @justinsb)
* CoreOS command now finds the latest image (thanks @gianrubio)
* Protokube now checks if kubelet is already running before calling systemctl start (thanks @aledbf)
* Added index to make documentation much easier to navigate (thanks @WillemMali)
* Makefile improvements (thanks @WillemMali)
* Refactor instance group / rolling-update code (thanks @andrewsykim)
* Lots of documentation and polish (thanks @chrislovecnm, @cordoval, @justinsb, @WillemMali)

---

# 1.6.1

## Significant changes

* Calico users have noticed problems using Calico with Kubernetes 1.6
* "hairpin" connections back to the same pod were causing issues for CNI providers

## Full changelist

* `kops get` can now output a complete cluster spec (thanks @geojaz)
* `kops create` can set master/node volume size (thanks @matthew-marchetti)
* Add ability to set cross-subnet mode in Calico (thanks @ottoyiu)
* Make Weave MTU configurable and configure jumbo frame support for new clusters on AWS (thanks @jordanjennings)
* Initial support for external-dns project (thanks @sethpollack)
* Fix calico bootstrapping problems (thanks @ottoyiu, @ozdanborne)
* Update to latest release of calico (thanks @mad01)
* Update canal manifests for 1.6 & RBAC (thanks @heschlie)
* Mark calico-node pods as critical (thanks @andreychernih)
* Fix log rotation of apiserver audit logs (thanks @ottoyiu)
* Update cluster autoscaler addon (thanks @sethpollack)
* Set hairpin mode for flannel (thanks @justinsb)
* Fix GCE disk cleanup on cluster deletion (thanks @andrewsykim)
* Prevent "unbound variable" errors in `kops-mfa` (thanks @hugocf)
* Fix e2e tests for kubernetes 1.8 and 1.9 (thanks @justinsb)
* Fix directory permissions for `.kube` directory on master (thanks @chrislovecnm)
* Lots of documentation and polish (thanks @andrewsykim, @caarlos0, @chrislovecnm, @gianrubio, @Grillz, @justinsb, @mikesplain, @Shimi, @tanner-bruce, @WillemMali, @zanhsieh)

---

# 1.6.0

## Known Issues

* Kubernetes upgrade from 1.5 -> 1.6 requires a configmap to be created in the kube-system namespace to minimize downtime. If `kubectl -n kube-system get configmap kube-dns` does not already have a configmap, BEFORE upgrade you can execute `kubectl create configmap -n kube-system kube-dns`.
* Kubernetes changed taints from an annotation in 1.5, to a field in 1.6.    Editing the taints by hand is a workaround for any issues. See: [#2594](https://github.com/kubernetes/kops/issues/2594)
* Some Kubernetes upgrades from 1.6.x -> 1.6.x have experience issues with secrets and service accounts. Deleting the secrets have been a workaround (not validated). See: #2576

---

# 1.6.0-alpha.1

1.6.0-alpha.1 is a prerelease early-access of kops 1.6, which is the release with full support for kubernetes 1.6.
This version of kops & kubernetes has not yet undergone extensive validation, and there will be improvements
made before release of kops 1.6.0.

This is not a full set of release notes, but rather a summary of the highest impact changes in the 1.6 release:

* RBAC can be enabled by passing the `--authorization=rbac` parameter to `kops create cluster`,
or via `kops edit cluster` and change `authorization` from `alwaysAllow: {}` to `rbac: {}`

* The standard RBAC policy for 1.6 means that all access to the Kubernetes API using the default
service account method will be denied.

* The taints & tolerations have changed as part of their graduation from alpha.  The taint is now a field on the node:

```yaml
spec:
  taints:
  - effect: NoSchedule
    key: node-role.kubernetes.io/master
```

An example toleration (as used in dns-controller) is:

```yaml
spec:
  tolerations:
  - effect: NoSchedule
    key: node-role.kubernetes.io/master
```

Note that the annotation form is ignored.  To schedule a pod on the master, the toleration must be updated
and moved from an annotation to the field.

* A new label for nodes, mirroring the toleration, is added and is now preferred: `node-role.kubernetes.io/master=`
(`node-role.kubernetes.io/master` with an empty value).  `kubernetes.io/role=master` is still present, but
the `node-role.kubernetes.io/<role>=` form is preferred.  `kubernetes.io/role=node` and `node-role.kubernetes.io/node=`
are also present.

Workaround: create the configmap with `kubectl create configmap -n kube-system kube-dns` before updating.

## Known Issues

##### Rolling updates

Rolling update to 1.6 does not succeed because new kube-dns pods mount a configmap with an optional volume map,
but that is enforced by the kubelets, which are upgraded after the master.

##### etcd3

`kops` is not yet recommending etcd3. We do however support a **run at your own risk** option. Right now we are working on resolving issues such as HA upgrade support.