/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Copyright 2025 The Kubernetes Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v4.23.4
// source: staging/src/k8s.io/kubelet/pkg/apis/dra-health/v1alpha1/api.proto

package v1alpha1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	DRAResourceHealth_NodeWatchResources_FullMethodName = "/v1alpha1.DRAResourceHealth/NodeWatchResources"
)

// DRAResourceHealthClient is the client API for DRAResourceHealth service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// DRAResourceHealth service is implemented by DRA plugins and called by Kubelet.
type DRAResourceHealthClient interface {
	// NodeWatchResources allows a DRA plugin to stream health updates for its devices to Kubelet.
	NodeWatchResources(ctx context.Context, in *NodeWatchResourcesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[NodeWatchResourcesResponse], error)
}

type dRAResourceHealthClient struct {
	cc grpc.ClientConnInterface
}

func NewDRAResourceHealthClient(cc grpc.ClientConnInterface) DRAResourceHealthClient {
	return &dRAResourceHealthClient{cc}
}

func (c *dRAResourceHealthClient) NodeWatchResources(ctx context.Context, in *NodeWatchResourcesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[NodeWatchResourcesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &DRAResourceHealth_ServiceDesc.Streams[0], DRAResourceHealth_NodeWatchResources_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[NodeWatchResourcesRequest, NodeWatchResourcesResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type DRAResourceHealth_NodeWatchResourcesClient = grpc.ServerStreamingClient[NodeWatchResourcesResponse]

// DRAResourceHealthServer is the server API for DRAResourceHealth service.
// All implementations must embed UnimplementedDRAResourceHealthServer
// for forward compatibility.
//
// DRAResourceHealth service is implemented by DRA plugins and called by Kubelet.
type DRAResourceHealthServer interface {
	// NodeWatchResources allows a DRA plugin to stream health updates for its devices to Kubelet.
	NodeWatchResources(*NodeWatchResourcesRequest, grpc.ServerStreamingServer[NodeWatchResourcesResponse]) error
	mustEmbedUnimplementedDRAResourceHealthServer()
}

// UnimplementedDRAResourceHealthServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedDRAResourceHealthServer struct{}

func (UnimplementedDRAResourceHealthServer) NodeWatchResources(*NodeWatchResourcesRequest, grpc.ServerStreamingServer[NodeWatchResourcesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method NodeWatchResources not implemented")
}
func (UnimplementedDRAResourceHealthServer) mustEmbedUnimplementedDRAResourceHealthServer() {}
func (UnimplementedDRAResourceHealthServer) testEmbeddedByValue()                           {}

// UnsafeDRAResourceHealthServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DRAResourceHealthServer will
// result in compilation errors.
type UnsafeDRAResourceHealthServer interface {
	mustEmbedUnimplementedDRAResourceHealthServer()
}

func RegisterDRAResourceHealthServer(s grpc.ServiceRegistrar, srv DRAResourceHealthServer) {
	// If the following call pancis, it indicates UnimplementedDRAResourceHealthServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&DRAResourceHealth_ServiceDesc, srv)
}

func _DRAResourceHealth_NodeWatchResources_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(NodeWatchResourcesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DRAResourceHealthServer).NodeWatchResources(m, &grpc.GenericServerStream[NodeWatchResourcesRequest, NodeWatchResourcesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type DRAResourceHealth_NodeWatchResourcesServer = grpc.ServerStreamingServer[NodeWatchResourcesResponse]

// DRAResourceHealth_ServiceDesc is the grpc.ServiceDesc for DRAResourceHealth service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DRAResourceHealth_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "v1alpha1.DRAResourceHealth",
	HandlerType: (*DRAResourceHealthServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "NodeWatchResources",
			Handler:       _DRAResourceHealth_NodeWatchResources_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "staging/src/k8s.io/kubelet/pkg/apis/dra-health/v1alpha1/api.proto",
}
