# Cheat.sh

> Cheatsheets provided by cheat.sh

## Description

[Cheat.sh](https://cheat.sh) describe themselves as:

> The only cheat sheet you need. Unified access to the best community driven
> documentation repositories of the world.

This repository of knowledge can be accessed via the `[f1]` preview screen.

## Enabling cheat.sh

> By default, cheat.sh support is disabled. 

You can enable it by adding the following to your [profile](/docs/user-guide/profile.md):

```
config set cheat.sh enabled true
```

## Source Code

The source code is available on [Github](https://github.com/lmorg/murex/blob/master/integrations/cheat.sh_any.mx)
under `/integrations`.

## See Also

* [ChatGPT](../integrations/chatgpt.md):
  How to enable ChatGPT hints
* [Man Pages (POSIX)](../integrations/man-pages.md):
  Linux/UNIX `man` page integrations
* [Murex Event Subsystem (`event`)](../commands/event.md):
  Event driven programming for shell scripts
* [Murex's Offline Documentation (`murex-docs`)](../commands/murex-docs.md):
  Displays the man pages for Murex builtins
* [Profile Files](../user-guide/profile.md):
  A breakdown of the different files loaded on start up
* [Shell Configuration And Settings (`config`)](../commands/config.md):
  Query or define Murex runtime settings
* [Terminal Hotkeys](../user-guide/terminal-keys.md):
  A list of all the terminal hotkeys and their uses
* [`onPreview`](../events/onpreview.md):
  Full screen previews for files and command documentation

## Other Integrations

* [ChatGPT](../integrations/chatgpt.md):
    How to enable ChatGPT hints
* [Cheat.sh](../integrations/cheatsh.md):
    Cheatsheets provided by cheat.sh
* [Kitty Integrations](../integrations/kitty.md):
    Get more out of Kitty terminal emulator
* [Makefiles / `make`](../integrations/make.md):
    `make` integrations
* [Man Pages (POSIX)](../integrations/man-pages.md):
    Linux/UNIX `man` page integrations
* [Spellcheck](../integrations/spellcheck.md):
    How to enable inline spellchecking
* [Terminology Integrations](../integrations/terminology.md):
    Get more out of Terminology terminal emulator
* [`direnv` Integrations](../integrations/direnv.md):
    Directory specific environmental variables
* [`yarn` Integrations](../integrations/yarn.md):
    Working with `yarn` and `package.json`
* [iTerm2 Integrations](../integrations/iterm2.md):
    Get more out of iTerm2 terminal emulator

<hr/>

This document was generated from [gen/integrations/cheatsh_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/integrations/cheatsh_doc.yaml).