## Description
The root user account is the most privileged user in an AWS account. AWS Access Keys provide programmatic access to a given AWS account. It is recommended that all access keys associated with the root user account be removed.

## Rationale Statement
Removing access keys associated with the root user account limits vectors by which the account can be compromised. Additionally, removing the root access keys encourages the creation and use of role based accounts that are least privileged.

## Remediation Procedure
Perform the following to delete or disable active root user access keys

### From Console:

Sign in to the AWS Management Console as Root and open the IAM console at https://console.aws.amazon.com/iam/.
Click on <Root_Account_Name> at the top right and select My Security Credentials from the drop down list
On the pop out screen Click on Continue to Security Credentials
Click on Access Keys (Access Key ID and Secret Access Key)
Under the Status column if there are any Keys which are Active
Click on Make Inactive - (Temporarily disable Key - may be needed again)
Click Delete - (Deleted keys cannot be recovered)

## References
- http://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html
- http://docs.aws.amazon.com/general/latest/gr/managing-aws-access-keys.html
- http://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountSummary.html
- CCE-78910-7
- https://aws.amazon.com/blogs/security/an-easier-way-to-determine-the-presence-of-aws-account-access-keys/

## Additional Information
IAM User account "root" for us-gov cloud regions is not enabled by default. However, on request to AWS support enables root access only through access-keys (CLI, API methods) for us-gov cloud region.

