// Code generated by go generate; DO NOT EDIT.
package dockerhub

import "errors"

type Permission int

const (
    Invalid Permission = iota
    RepoRead Permission = iota
    RepoWrite Permission = iota
    RepoAdmin Permission = iota
    RepoPublicRead Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        RepoRead: "repo:read",
        RepoWrite: "repo:write",
        RepoAdmin: "repo:admin",
        RepoPublicRead: "repo:public_read",
    }

    StringToPermission = map[string]Permission{
        "repo:read": RepoRead,
        "repo:write": RepoWrite,
        "repo:admin": RepoAdmin,
        "repo:public_read": RepoPublicRead,
    }

    PermissionIDs = map[Permission]int{
        RepoRead: 1,
        RepoWrite: 2,
        RepoAdmin: 3,
        RepoPublicRead: 4,
    }

    IdToPermission = map[int]Permission{
        1: RepoRead,
        2: RepoWrite,
        3: RepoAdmin,
        4: RepoPublicRead,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
