/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build.event.types;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.problems.failure.DefaultFailureFactory;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailurePrinter;
import org.gradle.tooling.internal.protocol.InternalBasicProblemDetailsVersion3;
import org.gradle.tooling.internal.protocol.InternalFailure;

public class DefaultFailure
implements Serializable,
InternalFailure {
    private final String message;
    private final String description;
    private final List<? extends InternalFailure> causes;
    private final List<InternalBasicProblemDetailsVersion3> problems;

    DefaultFailure(String message, String description, List<? extends InternalFailure> causes) {
        this(message, description, causes, Collections.emptyList());
    }

    DefaultFailure(String message, String description, List<? extends InternalFailure> causes, List<InternalBasicProblemDetailsVersion3> problems) {
        this.message = message;
        this.description = description;
        this.causes = causes;
        this.problems = problems;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDescription() {
        return this.description;
    }

    public List<? extends InternalFailure> getCauses() {
        return this.causes;
    }

    public List<InternalBasicProblemDetailsVersion3> getProblems() {
        return this.problems;
    }

    public static InternalFailure fromThrowable(Throwable throwable) {
        return DefaultFailure.fromThrowable(throwable, p -> null);
    }

    public static InternalFailure fromThrowable(Throwable t, Function<InternalProblem, InternalBasicProblemDetailsVersion3> mapper) {
        Failure failure = DefaultFailureFactory.withDefaultClassifier().create(t);
        return DefaultFailure.fromFailure(failure, mapper);
    }

    public static InternalFailure fromFailure(Failure buildFailure, Function<InternalProblem, InternalBasicProblemDetailsVersion3> mapper) {
        String failureString = FailurePrinter.printToString((Failure)buildFailure);
        List<InternalFailure> causeFailures = DefaultFailure.convertCausesToFailures(buildFailure.getCauses(), mapper);
        List<InternalBasicProblemDetailsVersion3> problemDetails = buildFailure.getProblems().stream().map(mapper).collect(Collectors.toList());
        return new DefaultFailure(buildFailure.getMessage(), failureString, causeFailures, problemDetails);
    }

    private static List<InternalFailure> convertCausesToFailures(List<Failure> causes, Function<InternalProblem, InternalBasicProblemDetailsVersion3> mapper) {
        return causes.stream().flatMap(cause -> cause.getOriginal() instanceof MultiCauseException ? cause.getCauses().stream() : Stream.of(cause)).map(cause -> DefaultFailure.fromFailure(cause, mapper)).collect(Collectors.toList());
    }
}

