/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.services;

import java.util.UUID;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.UUIDGenerator;
import org.gradle.internal.remote.MessagingClient;
import org.gradle.internal.remote.MessagingServer;
import org.gradle.internal.remote.internal.IncomingConnector;
import org.gradle.internal.remote.internal.OutgoingConnector;
import org.gradle.internal.remote.internal.hub.MessageHubBackedClient;
import org.gradle.internal.remote.internal.hub.MessageHubBackedServer;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.gradle.internal.remote.internal.inet.TcpIncomingConnector;
import org.gradle.internal.remote.internal.inet.TcpOutgoingConnector;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistrationProvider;

public class MessagingServices
implements ServiceRegistrationProvider {
    private final IdGenerator<UUID> idGenerator = new UUIDGenerator();

    @Provides
    protected InetAddressFactory createInetAddressFactory() {
        return new InetAddressFactory();
    }

    @Provides
    protected OutgoingConnector createOutgoingConnector() {
        return new TcpOutgoingConnector();
    }

    @Provides
    protected IncomingConnector createIncomingConnector(ExecutorFactory executorFactory, InetAddressFactory inetAddressFactory) {
        return new TcpIncomingConnector(executorFactory, inetAddressFactory, this.idGenerator);
    }

    @Provides
    protected MessagingClient createMessagingClient(OutgoingConnector outgoingConnector, ExecutorFactory executorFactory) {
        return new MessageHubBackedClient(outgoingConnector, executorFactory);
    }

    @Provides
    protected MessagingServer createMessagingServer(IncomingConnector incomingConnector, ExecutorFactory executorFactory) {
        return new MessageHubBackedServer(incomingConnector, executorFactory);
    }
}

