/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.remote;

import groovyx.gpars.remote.LocalHost;
import groovyx.gpars.remote.RemoteHost;
import groovyx.gpars.remote.message.HostIdMsg;
import groovyx.gpars.serial.SerialMsg;

public abstract class RemoteConnection {
    private final LocalHost localHost;
    private RemoteHost host;

    protected RemoteConnection(LocalHost provider) {
        this.localHost = provider;
    }

    public void onMessage(SerialMsg msg) {
        if (this.host != null) {
            throw new IllegalStateException("Unexpected message: " + msg);
        }
        this.host = (RemoteHost)this.localHost.getSerialHost(msg.hostId, this);
    }

    public void onException(Throwable cause) {
    }

    public void onConnect() {
        this.write(new HostIdMsg(this.localHost.getId()));
    }

    public void onDisconnect() {
        this.localHost.onDisconnect(this.host);
    }

    public abstract void write(SerialMsg var1);

    public RemoteHost getHost() {
        return this.host;
    }

    public void setHost(RemoteHost host) {
        this.host = host;
    }

    public abstract void disconnect();
}

