// Generated by gmmproc 2.52.0 -- DO NOT MODIFY!
#ifndef _GTKMM_APPLICATION_H
#define _GTKMM_APPLICATION_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2003-2014 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <vector>

#include <gtkmm/actiongroup.h>
#include <giomm/application.h>
#include <giomm/menumodel.h>
#include <giomm/menu.h>
#include <vector>
#include <glibmm/arrayhandle.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkApplication = struct _GtkApplication;
using GtkApplicationClass = struct _GtkApplicationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class Application_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/** 
 *  @var ApplicationInhibitFlags APPLICATION_INHIBIT_LOGOUT
 * Inhibit ending the user session
 * by logging out or by shutting down the computer.
 * 
 *  @var ApplicationInhibitFlags APPLICATION_INHIBIT_SWITCH
 * Inhibit user switching.
 * 
 *  @var ApplicationInhibitFlags APPLICATION_INHIBIT_SUSPEND
 * Inhibit suspending the
 * session or computer.
 * 
 *  @var ApplicationInhibitFlags APPLICATION_INHIBIT_IDLE
 * Inhibit the session being
 * marked as idle (and possibly locked).
 * 
 *  @enum ApplicationInhibitFlags
 * 
 * Types of user actions that may be blocked by Gtk::Application::inhibit().
 * 
 * @newin{3,4}
 *
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>%ApplicationInhibitFlags operator|(ApplicationInhibitFlags, ApplicationInhibitFlags)</tt><br>
 * <tt>%ApplicationInhibitFlags operator&(ApplicationInhibitFlags, ApplicationInhibitFlags)</tt><br>
 * <tt>%ApplicationInhibitFlags operator^(ApplicationInhibitFlags, ApplicationInhibitFlags)</tt><br>
 * <tt>%ApplicationInhibitFlags operator~(ApplicationInhibitFlags)</tt><br>
 * <tt>%ApplicationInhibitFlags& operator|=(ApplicationInhibitFlags&, ApplicationInhibitFlags)</tt><br>
 * <tt>%ApplicationInhibitFlags& operator&=(ApplicationInhibitFlags&, ApplicationInhibitFlags)</tt><br>
 * <tt>%ApplicationInhibitFlags& operator^=(ApplicationInhibitFlags&, ApplicationInhibitFlags)</tt><br>
 */
enum ApplicationInhibitFlags
{
  APPLICATION_INHIBIT_LOGOUT = (1 << 0),
  APPLICATION_INHIBIT_SWITCH = (1 << 1),
  APPLICATION_INHIBIT_SUSPEND = (1 << 2),
  APPLICATION_INHIBIT_IDLE = (1 << 3)
};

/** @ingroup gtkmmEnums */
inline ApplicationInhibitFlags operator|(ApplicationInhibitFlags lhs, ApplicationInhibitFlags rhs)
  { return static_cast<ApplicationInhibitFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline ApplicationInhibitFlags operator&(ApplicationInhibitFlags lhs, ApplicationInhibitFlags rhs)
  { return static_cast<ApplicationInhibitFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline ApplicationInhibitFlags operator^(ApplicationInhibitFlags lhs, ApplicationInhibitFlags rhs)
  { return static_cast<ApplicationInhibitFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline ApplicationInhibitFlags operator~(ApplicationInhibitFlags flags)
  { return static_cast<ApplicationInhibitFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline ApplicationInhibitFlags& operator|=(ApplicationInhibitFlags& lhs, ApplicationInhibitFlags rhs)
  { return (lhs = static_cast<ApplicationInhibitFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline ApplicationInhibitFlags& operator&=(ApplicationInhibitFlags& lhs, ApplicationInhibitFlags rhs)
  { return (lhs = static_cast<ApplicationInhibitFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline ApplicationInhibitFlags& operator^=(ApplicationInhibitFlags& lhs, ApplicationInhibitFlags rhs)
  { return (lhs = static_cast<ApplicationInhibitFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ApplicationInhibitFlags> : public Glib::Value_Flags<Gtk::ApplicationInhibitFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{


class Window;

//TODO: Add overview documentation discussing the techniques show in the examples in gtkmm-docmentation.
//TODO: Add the screenshots from the C API?

/** The Gtk::Application class handles many important aspects
 * of a GTK+ application in a convenient fashion, without enforcing
 * a one-size-fits-all application model.
 *
 * Currently, Gtk::Application handles GTK+ and gtkmm initialization, application
 * uniqueness, session management, provides some basic scriptability and
 * desktop shell integration by exporting actions and menus, and manages a
 * list of toplevel windows whose life-cycle is automatically tied to the
 * life-cycle of your application.
 *
 * While Gtk::Application works fine with plain Gtk::Window%s, it is recommended
 * to use it together with Gtk::ApplicationWindow.
 *
 * When GDK threads are enabled, Gtk::Application will acquire the GDK
 * lock when invoking actions that arrive from other processes.  The GDK
 * lock is not touched for local action invocations.  In order to have
 * actions invoked in a predictable context it is therefore recommended
 * that the GDK lock be held while invoking actions locally with
 * Gio::ActionGroup::activate_action().  The same applies to actions
 * associated with Gtk::ApplicationWindow and to the Gio::Application::activate() and
 * Gio::Application::open() methods.
 *
 * To set an application menu for a Gtk::Application, use
 * set_app_menu(). The Gio::MenuModel that this method
 * expects is usually constructed using Gtk::Builder.
 * To specify a menubar that will be shown by
 * Gtk::ApplicationWindow%s, use set_menubar(). Use the base
 * Gio::ActionMap interface to add actions, to respond to the user
 * selecting these menu items.
 *
 * GTK+ displays these menus as expected, depending on the platform
 * the application is running on.
 *
 * Gtk::Application optionally registers with a session manager
 * of the users session (if you set the register-session
 * property) and offers various functionality related to the session
 * life-cycle.
 *
 * An application can block various ways to end the session with
 * the inhibit() method. Typical use cases for
 * this kind of inhibiting are long-running, uninterruptible operations,
 * such as burning a CD or performing a disk backup. The session
 * manager may not honor the inhibitor, but it can be expected to
 * inform the user about the negative consequences of ending the
 * session while inhibitors are present.
 *
 * @newin{3,4}
 */

class Application
  : public Gio::Application
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Application;
  using CppClassType = Application_Class;
  using BaseObjectType = GtkApplication;
  using BaseClassType = GtkApplicationClass;

  // noncopyable
  Application(const Application&) = delete;
  Application& operator=(const Application&) = delete;

private:  friend class Application_Class;
  static CppClassType application_class_;

protected:
  explicit Application(const Glib::ConstructParams& construct_params);
  explicit Application(GtkApplication* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Application(Application&& src) noexcept;
  Application& operator=(Application&& src) noexcept;

  ~Application() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkApplication*       gobj()       { return reinterpret_cast<GtkApplication*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkApplication* gobj() const { return reinterpret_cast<GtkApplication*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkApplication* gobj_copy();

private:


protected:

  /** Creates a new Application instance.
   *
   * This initializes gtkmm (and the GObject type system) for you.
   *
   * If non-empty, the application ID must be valid.  See
   * g_application_id_is_valid().
   *
   * If no application ID is given then some features (most notably application
   * uniqueness) will be disabled. A null application ID is only allowed with
   * gtkmm 3.6 or later.
   *
   * @param application_id A valid application ID.
   * @param flags The application flags.
   *
   * @newin{3,4}
   */
  explicit Application(const Glib::ustring& application_id = Glib::ustring(), Gio::ApplicationFlags flags = Gio::APPLICATION_FLAGS_NONE);
  
  
  //This constructor does not correspond to anything in the C API.
  //We added it so we can choose to always initialize gtkmm as early as possible.
  //See https://bugzilla.gnome.org/show_bug.cgi?id=639925
  /** Creates a new Application instance.
   *
   * This initializes gtkmm (and the GObject type system) for you, parsing the
   * standard GTK+ command line arguments.
   *
   * You could instead use the constructor that takes no command line arguments
   * and later supply the command line arguments to run().
   *
   * Note that all GTK+ functionality that is available via command line arguments
   * can instead be achieved by setting suitable environment variables
   * such as G_DEBUG.
   *
   * If non-empty, the application ID must be valid.  See
   * g_application_id_is_valid().
   *
   * If no application ID is given then some features (most notably application
   * uniqueness) will be disabled. A null application ID is only allowed with
   * gtkmm 3.6 or later.
   *
   * @param argc The parameter received by your main() function.
   * @param argv The parameter received by your main() function.
   * @param application_id A valid application ID.
   * @param flags The application flags.
   *
   * @newin{3,4}
   */
  explicit Application(int& argc, char**& argv, const Glib::ustring& application_id = Glib::ustring(), Gio::ApplicationFlags flags = Gio::APPLICATION_FLAGS_NONE);

public:

  /** Creates a new Application instance.
   *
   * This initializes gtkmm (and the GObject type system) for you.
   *
   * If non-empty, the application ID must be valid.  See
   * g_application_id_is_valid().
   *
   * If no application ID is given then some features (most notably application
   * uniqueness) will be disabled. A null application ID is only allowed with
   * gtkmm 3.6 or later.
   *
   * @param application_id A valid application ID.
   * @param flags The application flags.
   *
   * @newin{3,4}
   */
  static Glib::RefPtr<Application> create(const Glib::ustring& application_id = Glib::ustring(), Gio::ApplicationFlags flags = Gio::APPLICATION_FLAGS_NONE);

  /** Creates a new Application instance.
   *
   * This initializes gtkmm (and the GObject type system) for you, parsing the
   * standard GTK+ command line arguments.
   *
   * You could instead use the constructor that takes no command line arguments
   * and later supply the command line arguments to run().
   *
   * Note that all GTK+ functionality that is available via command line arguments
   * can instead be achieved by setting suitable environment variables
   * such as G_DEBUG.
   *
   * If non-empty, the application ID must be valid.  See
   * g_application_id_is_valid().
   *
   * If no application ID is given then some features (most notably application
   * uniqueness) will be disabled. A null application ID is only allowed with
   * gtkmm 3.6 or later.
   *
   * @param argc The parameter received by your main() function.
   * @param argv The parameter received by your main() function.
   * @param application_id A valid application ID.
   *
   * @param flags The application flags.
   * @newin{3,4}
   */
  static Glib::RefPtr<Application> create(int& argc, char**& argv, const Glib::ustring& application_id = Glib::ustring(), Gio::ApplicationFlags flags = Gio::APPLICATION_FLAGS_NONE);

 
  /** Gets a list of the Gtk::Windows associated with @a application.
   * 
   * The list is sorted by most recently focused window, such that the first
   * element is the currently focused window. (Useful for choosing a parent
   * for a transient window.)
   * 
   * The list that is returned should not be modified in any way. It will
   * only remain valid until the next focus change or window creation or
   * deletion.
   * 
   * @newin{3,0}
   * 
   * @return A List of Gtk::Window.
   */
  std::vector<Window*> get_windows();

 
  /** Gets a list of the Gtk::Windows associated with @a application.
   * 
   * The list is sorted by most recently focused window, such that the first
   * element is the currently focused window. (Useful for choosing a parent
   * for a transient window.)
   * 
   * The list that is returned should not be modified in any way. It will
   * only remain valid until the next focus change or window creation or
   * deletion.
   * 
   * @newin{3,0}
   * 
   * @return A List of Gtk::Window.
   */
  std::vector<const Window*> get_windows() const;

  //Concerning the note on quit(), see https://bugzilla.gnome.org/show_bug.cgi?id=731126
  /** Adds a window to the Gtk::Application.
   *
   * If all the windows managed by Gtk::Application are closed (hidden) or
   * removed from the application then the call to run() will return.
   *
   * This call is equivalent to calling Gtk::Window::set_application().
   *
   * Normally, the connection between the application and the window
   * will remain until the window is closed (hidden) or destroyed, but you can explicitly
   * remove it with remove_window().
   *
   * @note If you call Gio::Application::quit() while a window is connected to
   * the application, and then return from main() without removing the window
   * from the application, the application's destructor will not be called.
   *
   * @newin{3,4}
   *
   * @param window A toplevel window to add to the application.
   */
  void add_window(Window& window);
  

  /** Remove a window from @a application.
   * 
   * If @a window belongs to @a application then this call is equivalent to
   * setting the Gtk::Window::property_application() property of @a window to
   * <tt>nullptr</tt>.
   * 
   * The application may stop running as a result of a call to this
   * function.
   * 
   * @newin{3,0}
   * 
   * @param window A Gtk::Window.
   */
  void remove_window(Window& window);

  /** Starts the application.
   *
   * The default implementation of this virtual function will simply run
   * a main loop.
   *
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   *
   * @param argc The argc from main() (or 0 if @a argv is <tt>0</tt>).
   * @param argv The argv from main(), or <tt>0</tt>.
   * @return The exit status.
   *
   * @newin{3,4}
   */
  int run(int argc, char** argv);

  /** Starts the application.
   *
   * The default implementation of this virtual function will simply run
   * a main loop.
   *
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   *
   * @note If you call Gio::Application::quit() while a window is connected to
   * the application, and then return from main() without removing the window
   * from the application, the application's destructor will not be called.
   *
   * @param window The window to show. This method will return when the window is hidden.
   * @param argc The argc from main() (or 0 if @a argv is <tt>0</tt>).
   * @param argv The argv from main(), or <tt>0</tt>.
   * @return The exit status.
   *
   * @newin{3,4}
   */
  int run(Window& window, int argc, char** argv);

  //TODO: If argc and argv are necessary at all, document the need to call that constructor first.
  //See https://bugzilla.gnome.org/show_bug.cgi?id=639925#c4
  /** Starts the application.
   *
   * The default implementation of this virtual function will simply run
   * a main loop.
   *
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   *
   * @note If you call Gio::Application::quit() while a window is connected to
   * the application, and then return from main() without removing the window
   * from the application, the application's destructor will not be called.
   *
   * @param window The window to show. This method will return when the window is hidden.
   * @return The exit status.
   *
   * @newin{3,4}
   */
  int run(Window& window);

  //TODO: If argc and argv are necessary at all, document the need to call that constructor first.
  //See https://bugzilla.gnome.org/show_bug.cgi?id=639925#c4
  /** Starts the application.
   *
   * The default implementation of this virtual function will simply run
   * a main loop.
   *
   * It is an error to call this function if @a application is a proxy for
   * a remote application.
   *
   * @return The exit status.
   *
   * @newin{3,4}
   */
  int run();

  
  /** Returns the menu model that has been set with
   * set_app_menu().
   * 
   * @newin{3,4}
   * 
   * @return The application menu of @a application
   * or <tt>nullptr</tt> if no application menu has been set.
   */
  Glib::RefPtr<Gio::MenuModel> get_app_menu();
  
  /** Returns the menu model that has been set with
   * set_app_menu().
   * 
   * @newin{3,4}
   * 
   * @return The application menu of @a application
   * or <tt>nullptr</tt> if no application menu has been set.
   */
  Glib::RefPtr<const Gio::MenuModel> get_app_menu() const;

  
  /** Sets or unsets the application menu for @a application.
   * 
   * This can only be done in the primary instance of the application,
   * after it has been registered.  Application::signal_startup() is a good place
   * to call this.
   * 
   * The application menu is a single menu containing items that typically
   * impact the application as a whole, rather than acting on a specific
   * window or document.  For example, you would expect to see
   * “Preferences” or “Quit” in an application menu, but not “Save” or
   * “Print”.
   * 
   * If supported, the application menu will be rendered by the desktop
   * environment.
   * 
   * Use the base ActionMap interface to add actions, to respond to the user
   * selecting these menu items.
   * 
   * @newin{3,4}
   * 
   * @param app_menu A MenuModel, or <tt>nullptr</tt>.
   */
  void set_app_menu(const Glib::RefPtr<Gio::MenuModel>& app_menu);

  
  /** Returns the menu model that has been set with
   * set_menubar().
   * 
   * @newin{3,4}
   * 
   * @return The menubar for windows of @a application.
   */
  Glib::RefPtr<Gio::MenuModel> get_menubar();
  
  /** Returns the menu model that has been set with
   * set_menubar().
   * 
   * @newin{3,4}
   * 
   * @return The menubar for windows of @a application.
   */
  Glib::RefPtr<const Gio::MenuModel> get_menubar() const;

  
  /** Sets or unsets the menubar for windows of @a application.
   * 
   * This is a menubar in the traditional sense.
   * 
   * This can only be done in the primary instance of the application,
   * after it has been registered.  Application::signal_startup() is a good place
   * to call this.
   * 
   * Depending on the desktop environment, this may appear at the top of
   * each window, or at the top of the screen.  In some environments, if
   * both the application menu and the menubar are set, the application
   * menu will be presented as if it were the first item of the menubar.
   * Other environments treat the two as completely separate — for example,
   * the application menu may be rendered by the desktop shell while the
   * menubar (if set) remains in each individual window.
   * 
   * Use the base ActionMap interface to add actions, to respond to the
   * user selecting these menu items.
   * 
   * @newin{3,4}
   * 
   * @param menubar A MenuModel, or <tt>nullptr</tt>.
   */
  void set_menubar(const Glib::RefPtr<Gio::MenuModel>& menubar);

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Installs an accelerator that will cause the named action
   * to be activated when the key combination specificed by @a accelerator
   * is pressed.
   * 
   *  @a accelerator must be a string that can be parsed by gtk_accelerator_parse(),
   * e.g. "<Primary>q" or “<Control><Alt>p”.
   * 
   *  @a action_name must be the name of an action as it would be used
   * in the app menu, i.e. actions that have been added to the application
   * are referred to with an “app.” prefix, and window-specific actions
   * with a “win.” prefix.
   * 
   * GtkApplication also extracts accelerators out of “accel” attributes
   * in the MenuModels passed to set_app_menu() and
   * set_menubar(), which is usually more convenient
   * than calling this function for each accelerator.
   * 
   * @newin{3,4}
   * 
   * Deprecated: 3.14: Use set_accels_for_action() instead
   * 
   * @deprecated Use set_accels_for_action() instead.
   * 
   * @param accelerator Accelerator string.
   * @param action_name The name of the action to activate.
   * @param parameter Parameter to pass when activating the action,
   * or <tt>nullptr</tt> if the action does not accept an activation parameter.
   */
  void add_accelerator(const Glib::ustring& accelerator, const Glib::ustring& action_name, GVariant* parameter);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED


  /// A add_accelerator() convenience overload.
  void add_accelerator(const Glib::ustring& accelerator, const Glib::ustring& action_name);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** Removes an accelerator that has been previously added
   * with add_accelerator().
   * 
   * @newin{3,4}
   * 
   * Deprecated: 3.14: Use set_accels_for_action() instead
   * 
   * @deprecated Use set_accels_for_action() or unset_accels_for_action() instead.
   * 
   * @param action_name The name of the action to activate.
   * @param parameter Parameter to pass when activating the action,
   * or <tt>nullptr</tt> if the action does not accept an activation parameter.
   */
  void remove_accelerator(const Glib::ustring& action_name, GVariant* parameter);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED


  /// A remove_accelerator() convenience overload.
  void remove_accelerator(const Glib::ustring& action_name);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Inform the session manager that certain types of actions should be
   * inhibited. This is not guaranteed to work on all platforms and for
   * all types of actions.
   * 
   * Applications should invoke this method when they begin an operation
   * that should not be interrupted, such as creating a CD or DVD. The
   * types of actions that may be blocked are specified by the @a flags
   * parameter. When the application completes the operation it should
   * call uninhibit() to remove the inhibitor. Note that
   * an application can have multiple inhibitors, and all of them must
   * be individually removed. Inhibitors are also cleared when the
   * application exits.
   * 
   * Applications should not expect that they will always be able to block
   * the action. In most cases, users will be given the option to force
   * the action to take place.
   * 
   * Reasons should be short and to the point.
   * 
   * If @a window is given, the session manager may point the user to
   * this window to find out more about why the action is inhibited.
   * 
   * @newin{3,4}
   * 
   * @param window A Gtk::Window, or <tt>nullptr</tt>.
   * @param flags What types of actions should be inhibited.
   * @param reason A short, human-readable string that explains
   * why these operations are inhibited.
   * @return A non-zero cookie that is used to uniquely identify this
   * request. It should be used as an argument to uninhibit()
   * in order to remove the request. If the platform does not support
   * inhibiting or the request failed for some reason, 0 is returned.
   */
  guint inhibit(Window& window, ApplicationInhibitFlags flags, const Glib::ustring& reason);
  
  /** Removes an inhibitor that has been established with inhibit().
   * Inhibitors are also cleared when the application exits.
   * 
   * @newin{3,4}
   * 
   * @param cookie A cookie that was returned by inhibit().
   */
  void uninhibit(guint cookie);
  
  /** Determines if any of the actions specified in @a flags are
   * currently inhibited (possibly by another application).
   * 
   * @newin{3,4}
   * 
   * @param flags What types of actions should be queried.
   * @return <tt>true</tt> if any of the actions specified in @a flags are inhibited.
   */
  bool is_inhibited(ApplicationInhibitFlags flags) const;

  
  /** Returns the Gtk::ApplicationWindow with the given ID.
   * 
   * The ID of a Gtk::ApplicationWindow can be retrieved with
   * Gtk::ApplicationWindow::get_id().
   * 
   * @newin{3,6}
   * 
   * @param id An identifier number.
   * @return The window with ID @a id, or
   * <tt>nullptr</tt> if there is no window with this ID.
   */
  Window* get_window_by_id(guint id);
  
  /** Returns the Gtk::ApplicationWindow with the given ID.
   * 
   * The ID of a Gtk::ApplicationWindow can be retrieved with
   * Gtk::ApplicationWindow::get_id().
   * 
   * @newin{3,6}
   * 
   * @param id An identifier number.
   * @return The window with ID @a id, or
   * <tt>nullptr</tt> if there is no window with this ID.
   */
  const Window* get_window_by_id(guint id) const;

  
  /** Gets the “active” window for the application.
   * 
   * The active window is the one that was most recently focused (within
   * the application).  This window may not have the focus at the moment
   * if another application has it — this is just the most
   * recently-focused window within this application.
   * 
   * @newin{3,6}
   * 
   * @return The active window.
   */
  Window* get_active_window();
  
  /** Gets the “active” window for the application.
   * 
   * The active window is the one that was most recently focused (within
   * the application).  This window may not have the focus at the moment
   * if another application has it — this is just the most
   * recently-focused window within this application.
   * 
   * @newin{3,6}
   * 
   * @return The active window.
   */
  const Window* get_active_window() const;

 
  /** Lists the detailed action names which have associated accelerators.
   * See set_accels_for_action().
   * 
   * @newin{3,12}
   * 
   * @return A <tt>nullptr</tt>-terminated array of strings.
   */
  std::vector<Glib::ustring> list_action_descriptions() const;

 
  /** Gets the accelerators that are currently associated with
   * the given action.
   * 
   * @newin{3,12}
   * 
   * @param detailed_action_name A detailed action name, specifying an action
   * and target to obtain accelerators for.
   * @return Accelerators for @a detailed_action_name, as
   * a <tt>nullptr</tt>-terminated array.
   */
  std::vector<Glib::ustring> get_accels_for_action(const Glib::ustring& detailed_action_name) const;

  
  /** Returns the list of actions (possibly empty) that @a accel maps to.
   * Each item in the list is a detailed action name in the usual form.
   * 
   * This might be useful to discover if an accel already exists in
   * order to prevent installation of a conflicting accelerator (from
   * an accelerator editor or a plugin system, for example). Note that
   * having more than one action per accelerator may not be a bad thing
   * and might make sense in cases where the actions never appear in the
   * same context.
   * 
   * In case there are no actions for a given accelerator, an empty array
   * is returned.  <tt>nullptr</tt> is never returned.
   * 
   * It is a programmer error to pass an invalid accelerator string.
   * If you are unsure, check it with gtk_accelerator_parse() first.
   * 
   * @newin{3,14}
   * 
   * @param accel An accelerator that can be parsed by gtk_accelerator_parse().
   * @return A <tt>nullptr</tt>-terminated array of actions for @a accel.
   */
  std::vector<Glib::ustring> get_actions_for_accel(const Glib::ustring& accel) const;

 
  /** Sets zero or more keyboard accelerators that will trigger the
   * given action. The first item in @a accels will be the primary
   * accelerator, which may be displayed in the UI.
   * 
   * To remove all accelerators for an action, use an empty, zero-terminated
   * array for @a accels.
   * 
   * For the @a detailed_action_name, see Glib::action_parse_detailed_name() and
   * Glib::action_print_detailed_name().
   * 
   * @newin{3,12}
   * 
   * @param detailed_action_name A detailed action name, specifying an action
   * and target to associate accelerators with.
   * @param accels A list of accelerators in the format
   * understood by gtk_accelerator_parse().
   */
  void set_accels_for_action(const Glib::ustring& detailed_action_name, const std::vector<Glib::ustring>& accels);

  /** Sets a keyboard accelerator that will trigger the
   * given action. It will be the primary
   * accelerator, which may be displayed in the UI.
   *
   * See unset_accels_for_action().
   *
   * @param detailed_action_name A detailed action name, specifying an action
   * and target to associate accelerators with.
   * @param accel An accelerator in the format understood by gtk_accelerator_parse().
   *
   * @newin{3,12}
   */
  void set_accel_for_action(const Glib::ustring& detailed_action_name, const Glib::ustring& accel);

  /** Unsets a keyboard accelerator that will trigger the
   * given action. See set_accels_for_action() and set_accel_for_action().
   *
   * @param detailed_action_name A detailed action name, specifying an action
   * and target to associate accelerators with.
   *
   * @newin{3,12}
   */
  void unset_accels_for_action(const Glib::ustring& detailed_action_name);

  
  /** Determines if the desktop environment in which the application is
   * running would prefer an application menu be shown.
   * 
   * If this function returns <tt>true</tt> then the application should call
   * set_app_menu() with the contents of an application
   * menu, which will be shown by the desktop environment.  If it returns
   * <tt>false</tt> then you should consider using an alternate approach, such as
   * a menubar.
   * 
   * The value returned by this function is purely advisory and you are
   * free to ignore it.  If you call set_app_menu() even
   * if the desktop environment doesn't support app menus, then a fallback
   * will be provided.
   * 
   * Applications are similarly free not to set an app menu even if the
   * desktop environment wants to show one.  In that case, a fallback will
   * also be created by the desktop environment (GNOME, for example, uses
   * a menu with only a "Quit" item in it).
   * 
   * The value returned by this function never changes.  Once it returns a
   * particular value, it is guaranteed to always return the same value.
   * 
   * You may only call this function after the application has been
   * registered and after the base startup handler has run.  You're most
   * likely to want to use this from your own startup handler.  It may
   * also make sense to consult this function while constructing UI (in
   * activate, open or an action activation handler) in order to determine
   * if you should show a gear menu or not.
   * 
   * This function will return <tt>false</tt> on Mac OS and a default app menu
   * will be created automatically with the "usual" contents of that menu
   * typical to most Mac OS applications.  If you call
   * set_app_menu() anyway, then this menu will be
   * replaced with your own.
   * 
   * @newin{3,14}
   * 
   * @return <tt>true</tt> if you should set an app menu.
   */
  bool prefers_app_menu() const;

  
  /** Gets a menu from automatically loaded resources.
   * See [Automatic resources][automatic-resources]
   * for more information.
   * 
   * @newin{3,14}
   * 
   * @param id The id of the menu to look up.
   * @return Gets the menu with the
   * given id from the automatically loaded resources.
   */
  Glib::RefPtr<Gio::Menu> get_menu_by_id(const Glib::ustring& id);
  
  /** Gets a menu from automatically loaded resources.
   * See [Automatic resources][automatic-resources]
   * for more information.
   * 
   * @newin{3,14}
   * 
   * @param id The id of the menu to look up.
   * @return Gets the menu with the
   * given id from the automatically loaded resources.
   */
  Glib::RefPtr<const Gio::Menu> get_menu_by_id(const Glib::ustring& id) const;

  /** The GMenuModel for the application menu.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> > property_app_menu() ;

/** The GMenuModel for the application menu.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> > property_app_menu() const;

  /** The GMenuModel for the menubar.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> > property_menubar() ;

/** The GMenuModel for the menubar.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> > property_menubar() const;

  /** Set this property to <tt>true</tt> to register with the session manager.
   * 
   * @newin{3,4}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_register_session() ;

/** Set this property to <tt>true</tt> to register with the session manager.
   * 
   * @newin{3,4}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_register_session() const;

  /** The window which most recently had focus.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Window* > property_active_window() const;


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%window_added(Window* window)</tt>
   *
   * Emitted when a Gtk::Window is added to @a application through
   * Gtk::Application::add_window().
   * 
   * @newin{3,2}
   * 
   * @param window The newly-added Gtk::Window.
   */

  Glib::SignalProxy< void,Window* > signal_window_added();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%window_removed(Window* window)</tt>
   *
   * Emitted when a Gtk::Window is removed from @a application,
   * either as a side-effect of being destroyed or explicitly
   * through Gtk::Application::remove_window().
   * 
   * @newin{3,2}
   * 
   * @param window The Gtk::Window that is being removed.
   */

  Glib::SignalProxy< void,Window* > signal_window_removed();


private:
  /** This is just a way to call Glib::init() (which calls g_type_init()) before
   * calling application_class_.init(), so that
   * gtk_application_get_type() will always succeed.
   * See https://bugzilla.gnome.org/show_bug.cgi?id=639925
   */
  const Glib::Class& custom_class_init();

  void on_activate_add_and_show_main_window(Window* window);
  void on_window_hide(Window* window);

  //We need these to call g_application_run(),
  //even if we have already called gtk_init().
  int m_argc;
  char** m_argv;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_window_added().
  virtual void on_window_added(Window* window);
  /// This is a default handler for the signal signal_window_removed().
  virtual void on_window_removed(Window* window);


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Application
   */
  Glib::RefPtr<Gtk::Application> wrap(GtkApplication* object, bool take_copy = false);
}


#endif /* _GTKMM_APPLICATION_H */

