//////////////////////////////////////////////////////////////////////////////
//    Copyright 2004-2014, SenseGraphics AB
//
//    This file is part of MedX3D.
//
//    MedX3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    MedX3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with MedX3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    A commercial license is also available. Please contact us at 
//    www.sensegraphics.com for more information.
//
//
/// \file MedX3DDemoBlendedVolumeStyleOptions.h
/// \brief Header file for MedX3DDemoBlendedVolumeStyleOptions.
/// Subclass of BlendedVolumeStyleOptions, which is generated by
/// wxFormBuilder.
///
//
//
//////////////////////////////////////////////////////////////////////////////
#ifndef __MedX3DDemoBlendedVolumeStyleOptions__
#define __MedX3DDemoBlendedVolumeStyleOptions__

#include <H3D/MedX3D/BlendedVolumeStyle.h>

#include "MedX3DDemo.h"

/** Implementing BlendedVolumeStyle */
class MedX3DDemoBlendedVolumeStyleOptions : public BlendedVolumeStyleOptions
{
protected:
  // Handlers for BlendedVolumeStyle events.
  void OnLoadBlendDataButton( wxCommandEvent& event );
  void OnBlendedVolumeStyleStyleChoice( wxCommandEvent& event );
  void OnBlendFunction1Choice( wxCommandEvent& event );
  void OnBlendFunction2Choice( wxCommandEvent& event );
  void OnBlendConstant1Scroll( wxScrollEvent& event );
  void OnBlendConstant2Scroll( wxScrollEvent& event );
  void OnBlendTable1LoadButton( wxCommandEvent& event );
  void OnBlendTable2LoadButton( wxCommandEvent& event );
  
  H3DUtil::AutoRef< H3D::BlendedVolumeStyle > blended_style;

public:
  /** Constructor */
  MedX3DDemoBlendedVolumeStyleOptions( wxWindow* parent,
                                       H3D::BlendedVolumeStyle *style );
};

#endif // __MedX3DDemoBlendedVolumeStyleOptions__
