# - Find MEDX3D
# Find the native MEDX3D headers and libraries.
#
#  MEDX3D_INCLUDE_DIR -  where to find MEDX3D.h, etc.
#  MEDX3D_LIBRARIES    - List of libraries when using MEDX3D.
#  MEDX3D_FOUND        - True if MEDX3D found.

GET_FILENAME_COMPONENT(module_file_path ${CMAKE_CURRENT_LIST_FILE} PATH )

# Look for the header file.
FIND_PATH(MEDX3D_INCLUDE_DIR NAMES H3D/MedX3D/MedX3D.h
           PATHS $ENV{H3D_ROOT}/../MedX3D/include
                 ../../../../MedX3D/include
                 ${module_file_path}/../../../include
                 ${module_file_path}/../../include
                 ../../../MedX3D/include
                 ${module_file_path}/../../../MedX3D/include                 )

MARK_AS_ADVANCED(MEDX3D_INCLUDE_DIR)

# Look for the library.
IF( MSVC )
  SET( H3D_MSVC_VERSION 6 )
  SET( TEMP_MSVC_VERSION 1299 )
  WHILE( ${MSVC_VERSION} GREATER ${TEMP_MSVC_VERSION} )
    MATH( EXPR H3D_MSVC_VERSION "${H3D_MSVC_VERSION} + 1" )
    MATH( EXPR TEMP_MSVC_VERSION "${TEMP_MSVC_VERSION} + 100" )
  ENDWHILE( ${MSVC_VERSION} GREATER ${TEMP_MSVC_VERSION} )
  SET( MEDX3D_NAME "MedX3D_vc${H3D_MSVC_VERSION}" )
ELSEIF(UNIX)
  SET( MEDX3D_NAME h3dmedx3d )
ELSE()
  SET( MEDX3D_NAME MedX3D )
ENDIF( MSVC )

SET( DEFAULT_LIB_INSTALL "lib" )
IF( WIN32 )
  SET( DEFAULT_LIB_INSTALL "lib32" )
  IF( CMAKE_SIZEOF_VOID_P EQUAL 8 )
    SET( DEFAULT_LIB_INSTALL "lib64" )
  ENDIF( CMAKE_SIZEOF_VOID_P EQUAL 8 )
ENDIF( WIN32 )

FIND_LIBRARY( MEDX3D_LIBRARY NAMES ${MEDX3D_NAME}
              PATHS $ENV{H3D_ROOT}/../${DEFAULT_LIB_INSTALL}
                    $ENV{H3D_ROOT}/../MedX3D/${DEFAULT_LIB_INSTALL}
                    ${module_file_path}/../../../${DEFAULT_LIB_INSTALL}
                    ${module_file_path}/../../${DEFAULT_LIB_INSTALL}
                    ${module_file_path}/../../../MedX3D/${DEFAULT_LIB_INSTALL} )

FIND_LIBRARY( MEDX3D_DEBUG_LIBRARY NAMES ${MEDX3D_NAME}_d
              PATHS $ENV{H3D_ROOT}/../${DEFAULT_LIB_INSTALL}
                    $ENV{H3D_ROOT}/../MedX3D/${DEFAULT_LIB_INSTALL}
                    ${module_file_path}/../../../${DEFAULT_LIB_INSTALL}
                    ${module_file_path}/../../${DEFAULT_LIB_INSTALL}
                    ${module_file_path}/../../../MedX3D/${DEFAULT_LIB_INSTALL} )
MARK_AS_ADVANCED(MEDX3D_LIBRARY)
MARK_AS_ADVANCED(MEDX3D_DEBUG_LIBRARY)

IF(MEDX3D_LIBRARY OR MEDX3D_DEBUG_LIBRARY)
  SET( HAVE_MEDX3D_LIBRARY 1 )
ELSE(MEDX3D_LIBRARY OR MEDX3D_DEBUG_LIBRARY)
  SET( HAVE_MEDX3D_LIBRARY 0 )
ENDIF(MEDX3D_LIBRARY OR MEDX3D_DEBUG_LIBRARY)

# Copy the results to the output variables.
IF(MEDX3D_INCLUDE_DIR AND HAVE_MEDX3D_LIBRARY)
  SET(MEDX3D_FOUND 1)
  IF(MEDX3D_LIBRARY)
    SET(MEDX3D_LIBRARIES ${MEDX3D_LIBRARIES} optimized ${MEDX3D_LIBRARY} )
  ELSE(MEDX3D_LIBRARY)
    SET(MEDX3D_LIBRARIES ${MEDX3D_LIBRARIES} optimized ${MEDX3D_NAME} )
    MESSAGE( STATUS "MEDX3D release libraries not found. Release build might not work." )
  ENDIF(MEDX3D_LIBRARY)

  IF(MEDX3D_DEBUG_LIBRARY)
    SET(MEDX3D_LIBRARIES ${MEDX3D_LIBRARIES} debug ${MEDX3D_DEBUG_LIBRARY} )
  ELSE(MEDX3D_DEBUG_LIBRARY)
    SET(MEDX3D_LIBRARIES ${MEDX3D_LIBRARIES} debug ${MEDX3D_NAME}_d )
    MESSAGE( STATUS "MEDX3D debug libraries not found. Debug build might not work." )
  ENDIF(MEDX3D_DEBUG_LIBRARY)

  SET(MEDX3D_INCLUDE_DIRS ${MEDX3D_INCLUDE_DIR})
ELSE(MEDX3D_INCLUDE_DIR AND HAVE_MEDX3D_LIBRARY)
  SET(MEDX3D_FOUND 0)
  SET(MEDX3D_LIBRARIES)
  SET(MEDX3D_INCLUDE_DIRS)
ENDIF(MEDX3D_INCLUDE_DIR AND HAVE_MEDX3D_LIBRARY)

# Report the results.
IF(NOT MEDX3D_FOUND)
  SET(MEDX3D_DIR_MESSAGE
    "MEDX3D was not found. Make sure MEDX3D_LIBRARY ( and/or MEDX3D_DEBUG_LIBRARY ) and MEDX3D_INCLUDE_DIR are set.")
  IF(MedX3D_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "${MEDX3D_DIR_MESSAGE}")
  ELSEIF(NOT MedX3D_FIND_QUIETLY)
    MESSAGE(STATUS "${MEDX3D_DIR_MESSAGE}")
  ENDIF(MedX3D_FIND_REQUIRED)
ENDIF(NOT MEDX3D_FOUND)
