//////////////////////////////////////////////////////////////////////////////
//    Copyright 2004-2014, SenseGraphics AB
//
//    This file is part of MedX3D.
//
//    MedX3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    MedX3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with MedX3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    A commercial license is also available. Please contact us at 
//    www.sensegraphics.com for more information.
//
//
/// \file MedX3DDemoComposedVolumeStyleOptionsPart.h
/// \brief Header file for MedX3DDemoComposedVolumeStyleOptionsPart. Subclass
/// of ComposedVolumeStyleOptionsPart, which is generated by wxFormBuilder.
///
//
//
//////////////////////////////////////////////////////////////////////////////
#ifndef __MedX3DDemoComposedVolumeStyleOptionsPart__
#define __MedX3DDemoComposedVolumeStyleOptionsPart__

#include <H3D/MedX3D/X3DComposableVolumeRenderStyleNode.h>

#include "MedX3DDemo.h"

/** Implementing ComposedVolumeStyleOptionsPart */
class MedX3DDemoComposedVolumeStyleOptionsPart : public ComposedVolumeStyleOptionsPart
{
protected:
  // Handlers for ComposedVolumeStyleOptionsPart events.
  void OnAddStyleButton( wxCommandEvent& event );
  void OnRemoveStyleButton( wxCommandEvent& event );
  
  // Given any X3DComposableVolumeRenderStyleNode a panel with the
  // gui to change the values of the style is created.
  wxPanel *createPanelForStyle( wxWindow *parent, 
                                H3D::X3DComposableVolumeRenderStyleNode *s );

public:
  /** Constructor */
  MedX3DDemoComposedVolumeStyleOptionsPart( wxWindow* parent,
                                            H3D::X3DComposableVolumeRenderStyleNode *style );
};

#endif // __MedX3DDemoComposedVolumeStyleOptionsPart__
