//////////////////////////////////////////////////////////////////////////////
//    Copyright 2004-2019, SenseGraphics AB
//
//    This file is part of MedX3D.
//
//    MedX3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    MedX3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with MedX3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    A commercial license is also available. Please contact us at 
//    www.sensegraphics.com for more information.
//
//
/// \file MedX3DDemoMainFrame.h
/// \brief Header file for MedX3DDemoMainFrame. Subclass of MainFrame, which is
/// generated by wxFormBuilder.
///
//
//
//////////////////////////////////////////////////////////////////////////////
#ifndef __MedX3DDemoMainFrame__
#define __MedX3DDemoMainFrame__

#include "MedX3DDemo.h"

/** Implementing MainFrame */
class MedX3DDemoMainFrame : public MainFrame
{
protected:
  // Handlers for MainFrame events.
  void OnClose( wxCloseEvent& event );
  void OnQuit( wxCommandEvent& event );
  void OnIdle( wxIdleEvent& event );
  void OnLoadVolumeData( wxCommandEvent& event );
  void OnLoadRawData( wxCommandEvent& event );
  void OnClearCurrentData( wxCommandEvent& event );
  void OnColorVolumeStyleMenuItem( wxCommandEvent& event );
  void OnConsoleWindowsMenu( wxCommandEvent& event );
  
public:
  /** Constructor */
  MedX3DDemoMainFrame( wxWindow* parent );
};

#endif // __MedX3DDemoMainFrame__
