//////////////////////////////////////////////////////////////////////////////
//    Copyright 2004-2019, SenseGraphics AB
//
//    This file is part of MedX3D.
//
//    MedX3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    MedX3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with MedX3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    A commercial license is also available. Please contact us at 
//    www.sensegraphics.com for more information.
//
//
/// \file MedX3DDemoBoundaryEnhancementVolumeStyleOptions.h
/// \brief Header file for MedX3DDemoBoundaryEnhancementVolumeStyleOptions.
/// Subclass of BoundaryEnhancementVolumeStyleOptions, which is generated by
/// wxFormBuilder.
///
//
//
//////////////////////////////////////////////////////////////////////////////
#ifndef __MedX3DDemoBoundaryEnhancementVolumeStyleOptions__
#define __MedX3DDemoBoundaryEnhancementVolumeStyleOptions__

#include <H3D/MedX3D/BoundaryEnhancementVolumeStyle.h>

/**
@file
Subclass of BoundaryEnhancementVolumeStyleOptions, which is generated by wxFormBuilder.
*/

#include "MedX3DDemo.h"

/** Implementing BoundaryEnhancementVolumeStyleOptions */
class MedX3DDemoBoundaryEnhancementVolumeStyleOptions : public BoundaryEnhancementVolumeStyleOptions
{
protected:
  // Handlers for BoundaryEnhancementVolumeStyleOptions events.
  void OnBoundaryOpacityText( wxCommandEvent& event );
  void OnOpacityFactorText( wxCommandEvent& event );
  void OnRetainedOpacityScroll( wxScrollEvent& event );

  H3DUtil::AutoRef< H3D::BoundaryEnhancementVolumeStyle > boundary_enhancement_style;
public:
  /** Constructor */
  MedX3DDemoBoundaryEnhancementVolumeStyleOptions( wxWindow* parent,
                                                   H3D::BoundaryEnhancementVolumeStyle *style);
};

#endif // __MedX3DDemoBoundaryEnhancementVolumeStyleOptions__
