# - Find BULLET
# Find the native BULLET headers and libraries.
#
#  BULLET_INCLUDE_DIR -  where to find ode.h, etc.
#  BULLET_LIBRARIES    - List of libraries when using BULLET.
#  BULLET_FOUND        - True if BULLET found.

GET_FILENAME_COMPONENT(module_file_path ${CMAKE_CURRENT_LIST_FILE} PATH )



SET(BULLET_INSTALL_DIR "$ENV{ProgramFiles}/bullet-2.80" CACHE PATH "Path to bullet installation" )
MARK_AS_ADVANCED(BULLET_INSTALL_DIR)

IF( CMAKE_CL_64 )
  SET( LIB "lib64" )
ELSE( CMAKE_CL_64 )
  SET( LIB "lib32" )
ENDIF( CMAKE_CL_64 )

SET( BULLET_LIBRARY_SEARCH_PATHS "" )
SET( BULLET_INCLUDE_SEARCH_PATHS "" )
IF( MSVC10 )
  SET( BULLET_INCLUDE_SEARCH_PATHS $ENV{H3D_EXTERNAL_ROOT}/include  
                                   $ENV{H3D_ROOT}/../External/include  
                                   ../External/include
                                   ../External/include/bullet
                                   ${module_file_path}/../../External/include
                                   ${module_file_path}/../../../External/include )
  SET( BULLET_LIBRARY_SEARCH_PATHS $ENV{H3D_EXTERNAL_ROOT}/${LIB}/static
                                   $ENV{H3D_ROOT}/../External/${LIB}/static
                                   ../../External/${LIB}/static
                                   ../External/${LIB}
                                   ${module_file_path}/../../External/${LIB}/static
                                   ${module_file_path}/../../../External/${LIB}/static )
ENDIF( MSVC10 )

# Look for the header file.
FIND_PATH( BULLET_INCLUDE_DIR NAMES btBulletCollisionCommon.h
           PATHS /usr/local/include
                 /usr/local/include/bullet
                 /opt/local/include
                 /opt/local/include/bullet
                 ${BULLET_INCLUDE_SEARCH_PATHS}
                 ${BULLET_INSTALL_DIR}/src
                 ${BULLET_INSTALL_DIR}/include/bullet )

MARK_AS_ADVANCED(BULLET_INCLUDE_DIR)

# Look for the library.
IF(WIN32)
  FIND_LIBRARY( BULLET_COLLISION_LIBRARY NAMES BulletCollision libBulletCollision libbulletcollision
                PATHS ${BULLET_LIBRARY_SEARCH_PATHS}
                      ${BULLET_INSTALL_DIR}/lib/release
                      ${BULLET_INSTALL_DIR}/lib )

  FIND_LIBRARY( BULLET_COLLISION_DEBUG_LIBRARY NAMES BulletCollision_Debug
                PATHS ${BULLET_LIBRARY_SEARCH_PATHS}
                      ${BULLET_INSTALL_DIR}/lib/release )

  FIND_LIBRARY( BULLET_DYNAMICS_LIBRARY NAMES BulletDynamics libBulletDynamics libbulletdynamics
                PATHS ${BULLET_LIBRARY_SEARCH_PATHS}
                      ${BULLET_INSTALL_DIR}/lib/release
                      ${BULLET_INSTALL_DIR}/lib )

  FIND_LIBRARY( BULLET_DYNAMICS_DEBUG_LIBRARY NAMES BulletDynamics_Debug
                PATHS ${BULLET_LIBRARY_SEARCH_PATHS}
                      ${BULLET_INSTALL_DIR}/lib/release )

  FIND_LIBRARY( BULLET_MATH_LIBRARY NAMES LinearMath libLinearMath libbulletmath
                PATHS ${BULLET_LIBRARY_SEARCH_PATHS}
                      ${BULLET_INSTALL_DIR}/lib/release
                      ${BULLET_INSTALL_DIR}/lib )

  FIND_LIBRARY( BULLET_MATH_DEBUG_LIBRARY NAMES LinearMath_Debug
                PATHS ${BULLET_LIBRARY_SEARCH_PATHS}
                      ${BULLET_INSTALL_DIR}/lib/release )

  FIND_LIBRARY( BULLET_SOFTBODY_LIBRARY NAMES BulletSoftBody libBulletSoftBody
                PATHS ${BULLET_LIBRARY_SEARCH_PATHS}
                      ${BULLET_INSTALL_DIR}/lib/release
                      ${BULLET_INSTALL_DIR}/lib )

  FIND_LIBRARY( BULLET_SOFTBODY_DEBUG_LIBRARY NAMES BulletSoftBody_Debug
                PATHS ${BULLET_LIBRARY_SEARCH_PATHS}
                      ${BULLET_INSTALL_DIR}/lib/release )

  MARK_AS_ADVANCED(BULLET_COLLISION_DEBUG_LIBRARY)
  MARK_AS_ADVANCED(BULLET_DYNAMICS_DEBUG_LIBRARY)
  MARK_AS_ADVANCED(BULLET_MATH_DEBUG_LIBRARY)
  MARK_AS_ADVANCED(BULLET_SOFTBODY_DEBUG_LIBRARY)
ELSE(WIN32)
  FIND_LIBRARY( BULLET_COLLISION_LIBRARY NAMES BulletCollision )
  FIND_LIBRARY( BULLET_DYNAMICS_LIBRARY NAMES BulletDynamics )
  FIND_LIBRARY( BULLET_MATH_LIBRARY NAMES LinearMath )
  FIND_LIBRARY( BULLET_SOFTBODY_LIBRARY NAMES BulletSoftBody )
ENDIF(WIN32)

MARK_AS_ADVANCED(BULLET_COLLISION_LIBRARY)
MARK_AS_ADVANCED(BULLET_DYNAMICS_LIBRARY)
MARK_AS_ADVANCED(BULLET_MATH_LIBRARY)
MARK_AS_ADVANCED(BULLET_SOFTBODY_LIBRARY)

FIND_PATH( BULLET_COLLISION_OBJECT_WRAPPER_H NAMES BulletCollision/CollisionDispatch/btCollisionObjectWrapper.h
           PATHS /usr/local/include
                 /usr/local/include/bullet
                 /opt/local/include
                 /opt/local/include/bullet
                 ${BULLET_INCLUDE_SEARCH_PATHS}
                 ${BULLET_INSTALL_DIR}/src )
MARK_AS_ADVANCED( BULLET_COLLISION_OBJECT_WRAPPER_H )

IF( BULLET_COLLISION_OBJECT_WRAPPER_H )
  SET( BULLET_HAVE_COLLISION_OBJECT_WRAPPER 1 )
ELSE( BULLET_COLLISION_OBJECT_WRAPPER_H )
  SET( BULLET_HAVE_COLLISION_OBJECT_WRAPPER 0 )
ENDIF( BULLET_COLLISION_OBJECT_WRAPPER_H )

# Copy the results to the output variables.
IF(BULLET_INCLUDE_DIR AND BULLET_COLLISION_LIBRARY AND BULLET_DYNAMICS_LIBRARY AND BULLET_MATH_LIBRARY AND BULLET_SOFTBODY_LIBRARY )
  SET(BULLET_FOUND 1)
  IF( WIN32 )
    SET(BULLET_LIBRARIES "" )
    
    IF( BULLET_COLLISION_DEBUG_LIBRARY )
      SET(BULLET_LIBRARIES ${BULLET_LIBRARIES} optimized ${BULLET_COLLISION_LIBRARY} debug ${BULLET_COLLISION_DEBUG_LIBRARY} )
    ELSE( BULLET_COLLISION_DEBUG_LIBRARY )
      SET(BULLET_LIBRARIES ${BULLET_LIBRARIES} ${BULLET_COLLISION_LIBRARY} )
    ENDIF( BULLET_COLLISION_DEBUG_LIBRARY )
    
    IF( BULLET_DYNAMICS_DEBUG_LIBRARY )
      SET(BULLET_LIBRARIES ${BULLET_LIBRARIES} optimized ${BULLET_DYNAMICS_LIBRARY} debug ${BULLET_DYNAMICS_DEBUG_LIBRARY} )
    ELSE( BULLET_DYNAMICS_DEBUG_LIBRARY )
      SET(BULLET_LIBRARIES ${BULLET_LIBRARIES} ${BULLET_DYNAMICS_LIBRARY} )
    ENDIF( BULLET_DYNAMICS_DEBUG_LIBRARY )
    
    IF( BULLET_MATH_DEBUG_LIBRARY )
      SET(BULLET_LIBRARIES ${BULLET_LIBRARIES} optimized ${BULLET_MATH_LIBRARY} debug ${BULLET_MATH_DEBUG_LIBRARY} )
    ELSE( BULLET_MATH_DEBUG_LIBRARY )
      SET(BULLET_LIBRARIES ${BULLET_LIBRARIES} ${BULLET_MATH_LIBRARY} )
    ENDIF( BULLET_MATH_DEBUG_LIBRARY )
    
    IF( BULLET_SOFTBODY_DEBUG_LIBRARY )
      SET(BULLET_LIBRARIES ${BULLET_LIBRARIES} optimized ${BULLET_SOFTBODY_LIBRARY} debug ${BULLET_SOFTBODY_DEBUG_LIBRARY} )
    ELSE( BULLET_SOFTBODY_DEBUG_LIBRARY )
      SET(BULLET_LIBRARIES ${BULLET_LIBRARIES} ${BULLET_SOFTBODY_LIBRARY} )
    ENDIF( BULLET_SOFTBODY_DEBUG_LIBRARY )

  ELSE( WIN32 )
    SET(BULLET_LIBRARIES ${BULLET_COLLISION_LIBRARY} ${BULLET_DYNAMICS_LIBRARY} ${BULLET_MATH_LIBRARY} ${BULLET_SOFTBODY_LIBRARY} )
  ENDIF( WIN32 )
  SET(BULLET_INCLUDE_DIR ${BULLET_INCLUDE_DIR})
ELSE(BULLET_INCLUDE_DIR AND BULLET_COLLISION_LIBRARY AND BULLET_DYNAMICS_LIBRARY AND BULLET_MATH_LIBRARY AND BULLET_SOFTBODY_LIBRARY )
  SET(BULLET_FOUND 0)
  SET(BULLET_LIBRARIES)
  SET(BULLET_INCLUDE_DIR)
ENDIF(BULLET_INCLUDE_DIR AND BULLET_COLLISION_LIBRARY AND BULLET_DYNAMICS_LIBRARY AND BULLET_MATH_LIBRARY AND BULLET_SOFTBODY_LIBRARY )

IF( WIN32 AND ( NOT BULLET_FIND_QUIETLY ) AND ( ( NOT BULLET_COLLISION_DEBUG_LIBRARY ) OR ( NOT BULLET_DYNAMICS_DEBUG_LIBRARY ) OR ( NOT BULLET_MATH_DEBUG_LIBRARY ) OR ( NOT BULLET_SOFTBODY_DEBUG_LIBRARY ) ) )
  MESSAGE( STATUS "One or several of Bullet debug libraries could not be found. Debug build might not work." )
ENDIF( WIN32 AND ( NOT BULLET_FIND_QUIETLY ) AND ( ( NOT BULLET_COLLISION_DEBUG_LIBRARY ) OR ( NOT BULLET_DYNAMICS_DEBUG_LIBRARY ) OR ( NOT BULLET_MATH_DEBUG_LIBRARY ) OR ( NOT BULLET_SOFTBODY_DEBUG_LIBRARY ) ) )

# Report the results.
IF(NOT BULLET_FOUND)
  SET(BULLET_DIR_MESSAGE
    "BULLET was not found. Try setting BULLET_INSTALL_DIR to the bullet installation path.")
  IF(BULLET_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "${BULLET_DIR_MESSAGE}")
  ELSEIF(NOT BULLET_FIND_QUIETLY)
    MESSAGE(STATUS "${BULLET_DIR_MESSAGE}")
  ENDIF(BULLET_FIND_REQUIRED)
ENDIF(NOT BULLET_FOUND)
