//////////////////////////////////////////////////////////////////////////////
//    Copyright 2004-2014, SenseGraphics AB
//
//    This file is part of H3D API.
//
//    H3D API is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    H3D API is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with H3D API; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    A commercial license is also available. Please contact us at 
//    www.sensegraphics.com for more information.
//
//
/// \file MassSpringPhysicsMaterial.cpp
/// \brief Source file for MassSpringPhysicsMaterial, X3D scene-graph node
///
//
//////////////////////////////////////////////////////////////////////////////
#include <H3D/H3DPhysics/MassSpringPhysicsMaterial.h>
#include <H3D/H3DPhysics/SoftBodyParameters.h>

using namespace H3D;
using namespace PhysicsEngineParameters;

H3DNodeDatabase MassSpringPhysicsMaterial::database( "MassSpringPhysicsMaterial", 
                                                    &(newInstance< MassSpringPhysicsMaterial >), 
                                                    typeid( MassSpringPhysicsMaterial ),
                                                    &H3DPhysicsMaterialNode::database);

namespace MassSpringPhysicsMaterialInternals {
  FIELDDB_ELEMENT( MassSpringPhysicsMaterial, stiffness, INPUT_OUTPUT );
}

MassSpringPhysicsMaterial::MassSpringPhysicsMaterial(
  Inst< SFNode > _metadata,
  Inst< ValueUpdater > _valueUpdater,
  Inst< SFH3DPhysicsMassNode > _mass,
  Inst< SFH3DPhysicsDampingNode > _damping,
  Inst< SFH3DPhysicsFrictionNode > _friction,
  Inst< SFH3DPhysicsStiffnessNode > _stiffness ) :
H3DPhysicsMaterialNode( _metadata, _valueUpdater, _mass, _damping, _friction ),
stiffness( _stiffness ) {

  type_name = "MassSpringPhysicsMaterial";
  database.initFields( this );

  stiffness->route( valueUpdater );
  stiffness->route( materialChanged );

  previousStiffness = stiffness->getValue();
}

PhysicsEngineParameters::H3DPhysicsMaterialParameters* MassSpringPhysicsMaterial::createH3DPhysicsMaterialParameters() {
  return new PhysicsEngineParameters::MassSpringPhysicsMaterialParameters();
}

PhysicsEngineParameters::H3DPhysicsMaterialParameters* MassSpringPhysicsMaterial::getH3DPhysicsMaterialParameters(bool all_params ) {

  MassSpringPhysicsMaterialParameters* params= 
    static_cast<MassSpringPhysicsMaterialParameters*>(H3DPhysicsMaterialNode::getH3DPhysicsMaterialParameters(all_params));

  if ( all_params || valueUpdater->hasCausedEvent ( stiffness ) ) {

    params->setStiffness ( stiffness->getValue() );
    // If the stiffness field is set to a different node
    // create all the stiffness parameters in order to
    // initialize them in the physics_engine layer.
    bool material_params = all_params;
    if( previousStiffness != stiffness->getValue() )
    {
      material_params = true;
      previousStiffness = stiffness->getValue();
    }
    if ( stiffness->getValue() ) {
      params->setStiffnessParameters( dynamic_cast<PhysicsEngineParameters::StiffnessParameters*>
        (stiffness->getValue()->valueUpdater->getMaterialPropertyParameters( material_params ) ) );
    }
  }

  return params;
}
