IF( NOT TARGET H3DPhysics )
  MESSAGE( FATAL_ERROR "Include file H3DPhysicsCPack.cmake require the target H3DPhysics to exist. Please add H3DPhysics/build/CMakeLists.txt as subdirectory first." )
ENDIF( NOT TARGET H3DPhysics )
# Add all sources, they are added to a variable called H3DPhysics_SRCS defined
# in the included file. All header files are added to a variable called
# H3DPhysics_HEADERS.
INCLUDE( ${H3DPhysics_SOURCE_DIR}/H3DPhysicsSourceFiles.txt )

# If cpack should be configured.
IF( GENERATE_CPACK_PROJECT)
  IF( WIN32 )
    # Add a cache variable which indicates where the Externals directory used for packaging
    # RigigBodyPhysics is located. If not set then FIND modules will be used instead.
    IF( NOT DEFINED H3DPhysics_CPACK_EXTERNAL_ROOT )
      SET( H3DPhysics_CPACK_EXTERNAL_ROOT_DEFAULT "" )
      IF( H3D_USE_DEPENDENCIES_ONLY )
        foreach( EXTERNAL_INCLUDE_DIR_TMP ${EXTERNAL_INCLUDE_DIR} )
          IF( EXISTS ${EXTERNAL_INCLUDE_DIR_TMP}/../include/pthread )
            SET( H3DPhysics_CPACK_EXTERNAL_ROOT_DEFAULT "${EXTERNAL_INCLUDE_DIR_TMP}/.." )
          ENDIF( EXISTS ${EXTERNAL_INCLUDE_DIR_TMP}/../include/pthread )
        endforeach( EXTERNAL_INCLUDE_DIR_TMP ${EXTERNAL_INCLUDE_DIR} )
      ELSE( H3D_USE_DEPENDENCIES_ONLY )
        SET( H3DPhysics_CPACK_EXTERNAL_ROOT_DEFAULT "$ENV{H3D_EXTERNAL_ROOT}" )
      ENDIF( H3D_USE_DEPENDENCIES_ONLY )
      SET( H3DPhysics_CPACK_EXTERNAL_ROOT "${H3DPhysics_CPACK_EXTERNAL_ROOT_DEFAULT}" CACHE PATH "Set to the External directory used with H3DPhysics, needed to pack properly. If not set FIND_modules will be used instead." )
      MARK_AS_ADVANCED(H3DPhysics_CPACK_EXTERNAL_ROOT)
    ENDIF( NOT DEFINED H3DPhysics_CPACK_EXTERNAL_ROOT )
  ENDIF( WIN32 )
  
  # Set information properties about the project to install.
  set( CPACK_ALL_INSTALL_TYPES Full Developer )
  SET(CMAKE_MODULE_PATH ${H3DPhysics_SOURCE_DIR}/modules )
  SET(CPACK_PACKAGE_DESCRIPTION_SUMMARY "H3DPhysics, an implementation for H3DPhysics of the H3DPhysics component of X3D.")
  SET(CPACK_PACKAGE_VENDOR "SenseGraphics AB")
  SET(CPACK_PACKAGE_CONTACT "support@sensegraphics.com" )
  SET(CPACK_PACKAGE_DESCRIPTION_FILE "${H3DPhysics_SOURCE_DIR}/../ReadMe")
  SET(CPACK_RESOURCE_FILE_LICENSE "${H3DPhysics_SOURCE_DIR}/../LICENSE")
  
  # Project to install.
  SET(CPACK_INSTALL_CMAKE_PROJECTS "${CMAKE_CURRENT_BINARY_DIR};H3DPhysics;ALL;/")

  # Installation directory for package.
  SET(CPACK_PACKAGE_INSTALL_DIRECTORY "H3D" )

  # Our project depends on these debian packages for Linux.
  SET(DEBIAN_PACKAGE_DEPENDS "libcurl3, libfreetype6-dev, ftgl-dev, python2.4-dev, libaudiofile0, libvorbis-dev, libopenal-dev, zlib1g-dev, libxerces27-dev, libfreeimage-dev, hapi(>= 1.0.0), h3dutil(>=1.0.0)" )
  
  # File patterns to ignore, common for all operating systems.
  SET( H3DPhysics_CPACK_IGNORE_PATTERNS /\\\\.svn/
                                    \\\\.obj$
                                    \\\\.ncb$
                                    \\\\.log$
                                    \\\\.suo$
                                    \\\\.dir/
                                    \\\\.user$
                                    \\\\.cv$
                                    "/Debug(.)*/"
                                    "/debug(.)*/"
                                    /Release
                                    /release
                                    /linux
                                    /build/win32/
                                    /build/vc8
                                    /build/vc7
                                    /build/vc9
                                    /osx
                                    "~$" )

  SET(CPACK_PACKAGE_VERSION_MAJOR ${H3DPHYSICS_MAJOR_VERSION})
  SET(CPACK_PACKAGE_VERSION_MINOR ${H3DPHYSICS_MINOR_VERSION})
  SET(CPACK_PACKAGE_VERSION_PATCH ${H3DPHYSICS_BUILD_VERSION})
  
  IF( WIN32 AND NOT UNIX)
    SET(CPACK_NSIS_INSTALL_ROOT "C:" )
    SET(CPACK_NSIS_ENABLE_UNINSTALL_BEFORE_INSTALL "ON" )
    SET( CPACK_PACKAGE_START_MENU_NAME "H3DPhysics" )
    SET( CPACK_ADD_H3DPhysics_DEMOS_LINKS "ON" )
    
  # EXTERNAL_INCLUDES and EXTERNAL_INCLUDE_INSTALL_PATHS must be of equal lengths.
    # The reason for defining these variables here is in case we want to add functionality
    # to configure installation in some other way (using FIND-modules for example).
    SET( EXTERNAL_INCLUDES "" )
    SET( EXTERNAL_INCLUDE_INSTALL_PATHS "" )
    # The EXTERNAL_INCLUDES_FILES are installed directly in External/include
    SET( EXTERNAL_INCLUDES_FILES "" )
    SET( EXTERNAL_LIBRARIES "" )
    SET( EXTERNAL_STATIC_LIBRARIES "" )
    SET( EXTERNAL_BINARIES "" )
    
    # External binary directory to add to path.
    SET( CPACK_EXTERNAL_BIN "bin32" )
    SET( EXTERNAL_BIN_REPLACE_PATH "bin64" )
    SET( CPACK_H3D_64_BIT "FALSE" )
    IF( CMAKE_SIZEOF_VOID_P EQUAL 8 )
      SET( CPACK_EXTERNAL_BIN "bin64" )
      SET( EXTERNAL_BIN_REPLACE_PATH "bin32" )
      SET( CPACK_H3D_64_BIT "TRUE" )
    ENDIF( CMAKE_SIZEOF_VOID_P EQUAL 8 )
    SET( EXTERNAL_BIN_PATH "${CPACK_EXTERNAL_BIN}" )

  IF( EXISTS ${H3DPhysics_CPACK_EXTERNAL_ROOT} )
      SET( EXTERNAL_INCLUDES ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/ode/
               ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/BulletCollision/
               ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/BulletDynamics/
               ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/BulletMultiThreaded/
               ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/BulletSoftBody/
               ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/LinearMath/
               ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/MiniCL/
               ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/vectormath/)

    SET( EXTERNAL_INCLUDE_INSTALL_PATHS External/include/ode
                      External/include/BulletCollision
                      External/include/BulletDynamics
                      External/include/BulletMultiThreaded
                      External/include/BulletSoftBody
                      External/include/LinearMath
                      External/include/MiniCL
                      External/include/vectormath )

    SET( EXTERNAL_INCLUDES_FILES ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/btBulletCollisionCommon.h
                                 ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/btBulletDynamicsCommon.h
                                 ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/Bullet-C-Api.h
                                 ${H3DPhysics_CPACK_EXTERNAL_ROOT}/include/COPYING-bullet )

    SET( EXTERNAL_LIBRARIES ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/ode_double.lib)

    SET( EXTERNAL_STATIC_LIBRARIES ${EXTERNAL_STATIC_LIBRARIES}
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletCollision.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletCollision_Debug.lib
                   #${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/bulletcollision_debug.pdb
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletDynamics.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletDynamics_Debug.lib
                   #${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/bulletdynamics_debug.pdb
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletFileLoader.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletFileLoader_Debug.lib
                   #${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/bulletfileloader_debug.pdb
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletMultiThreaded.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletMultiThreaded_Debug.lib
                   #${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/bulletmultithreaded_debug.pdb
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletSoftBody.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletSoftBody_Debug.lib
                   #${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/bulletsoftbody_debug.pdb
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletSoftBodySolvers_OpenCL_Mini.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletSoftBodySolvers_OpenCL_Mini_Debug.lib
                   #${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/bulletsoftbodysolvers_opencl_mini_debug.pdb
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletWorldImporter.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletWorldImporter_Debug.lib
                   #${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/bulletworldimporter_debug.pdb
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletXmlWorldImporter.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/BulletXmlWorldImporter_Debug.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/ConvexDecomposition.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/ConvexDecomposition_Debug.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/GIMPACTUtils.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/GIMPACTUtils_Debug.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/GLUI.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/GLUI_Debug.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/HACD.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/HACD_Debug.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/LinearMath.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/LinearMath_Debug.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/MiniCL.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/MiniCL_Debug.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/OpenGLSupport.lib
                   ${H3DPhysics_CPACK_EXTERNAL_ROOT}/lib32/static/OpenGLSupport_Debug.lib
                   )

    SET( EXTERNAL_BINARIES ${EXTERNAL_BINARIES}
                             ${H3DPhysics_CPACK_EXTERNAL_ROOT}/${EXTERNAL_BIN_PATH}/ode_double.dll)

  ELSE( EXISTS ${H3DPhysics_CPACK_EXTERNAL_ROOT} )
    MESSAGE( WARNING "H3DPhysics_CPACK_EXTERNAL_ROOT must be set to the External directory used by H3DPhysics in order to package properly." )
  ENDIF( EXISTS ${H3DPhysics_CPACK_EXTERNAL_ROOT} )

  IF( EXTERNAL_INCLUDES )
      list( LENGTH EXTERNAL_INCLUDES EXTERNAL_INCLUDES_LENGTH )
      math( EXPR EXTERNAL_INCLUDES_LENGTH "${EXTERNAL_INCLUDES_LENGTH} - 1" )
      foreach( val RANGE ${EXTERNAL_INCLUDES_LENGTH} )
        list(GET EXTERNAL_INCLUDES ${val} val1)
        list(GET EXTERNAL_INCLUDE_INSTALL_PATHS ${val} val2)
        INSTALL( DIRECTORY ${val1}
                 DESTINATION ${val2}
                 COMPONENT H3DPhysics_cpack_external_source
                 REGEX "(/.svn)|(/CVS)" EXCLUDE )
      endforeach( val )
    ENDIF( EXTERNAL_INCLUDES )

  foreach( include_file ${EXTERNAL_INCLUDES_FILES} )
      IF( EXISTS ${include_file} )
        INSTALL( FILES ${include_file}
                 DESTINATION External/include
                 COMPONENT H3DPhysics_cpack_external_source )
      ENDIF( EXISTS ${include_file} )
    endforeach( include_file )

  #install all the libraries
  foreach( library ${EXTERNAL_LIBRARIES} )
      IF( EXISTS ${library} )
        INSTALL( FILES ${library}
                 DESTINATION External/lib32
                 COMPONENT H3DPhysics_cpack_external_source )
      ENDIF( EXISTS ${library} )
      # Add the other library path as well
      STRING( REGEX REPLACE "(/lib32/)" "/lib64/" other_library ${library} )
      IF( EXISTS ${other_library} )
        INSTALL( FILES ${other_library}
                 DESTINATION External/lib64
                 COMPONENT H3DPhysics_cpack_external_source )
      ENDIF( EXISTS ${other_library} )
    endforeach( library )

  foreach( library ${EXTERNAL_STATIC_LIBRARIES} )
      IF( EXISTS ${library} )
        INSTALL( FILES ${library}
                 DESTINATION External/lib32/static
                 COMPONENT H3DPhysics_cpack_external_source )
      ENDIF( EXISTS ${library} )
      # Add the other library path as well
      STRING( REGEX REPLACE "(/lib32/)" "/lib64/" other_library ${library} )
      IF( EXISTS ${other_library} )
        INSTALL( FILES ${other_library}
                 DESTINATION External/lib64/static
                 COMPONENT H3DPhysics_cpack_external_source )
      ENDIF( EXISTS ${other_library} )
    endforeach( library )

  #install all the binaries
  foreach( binary ${EXTERNAL_BINARIES} )
      IF( EXISTS ${binary} )
        INSTALL( FILES ${binary}
                 DESTINATION External/${EXTERNAL_BIN_PATH}
                 COMPONENT H3DPhysics_cpack_external_runtime )
      ENDIF( EXISTS ${binary} )

      STRING( REGEX REPLACE "(/${EXTERNAL_BIN_PATH}/)" "/${EXTERNAL_BIN_REPLACE_PATH}/" other_binary ${binary} )
      IF( EXISTS ${other_binary} )
        INSTALL( FILES ${other_binary}
                 DESTINATION External/${EXTERNAL_BIN_REPLACE_PATH}
                 COMPONENT H3DPhysics_cpack_external_runtime )
      ENDIF( EXISTS ${other_binary} )
    endforeach( binary )

  # setting names and dependencies between components and also grouping them.
    set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXTERNAL_RUNTIME_DISPLAY_NAME "External runtime")
    set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXTERNAL_RUNTIME_DESCRIPTION "External runtime binaries needed by H3DPhysics.")
    set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXTERNAL_RUNTIME_DEPENDS H3DAPI_cpack_external_runtime )
    set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXTERNAL_RUNTIME_GROUP "H3DPhysics_cpack_group")
    set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXTERNAL_RUNTIME_INSTALL_TYPES Developer Full)
    
    set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXTERNAL_SOURCE_DISPLAY_NAME "External header/libraries")
    set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXTERNAL_SOURCE_DESCRIPTION "External headers and libraries needed by H3DPhysics.")
    set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXTERNAL_SOURCE_DEPENDS H3DAPI_cpack_external_source H3DPhysics_cpack_external_runtime )
    set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXTERNAL_SOURCE_GROUP "H3DPhysics_cpack_group")
    set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXTERNAL_SOURCE_INSTALL_TYPES Developer Full)

   #Modify path in the the NSIS template.
    SET( CPACK_NSIS_MODIFY_PATH "ON" )
  ENDIF( WIN32 AND NOT UNIX)
  
  #install changlog, license and readme
  INSTALL( FILES ${H3DPhysics_SOURCE_DIR}/../changelog
                 ${H3DPhysics_SOURCE_DIR}/../LICENSE
                 ${H3DPhysics_SOURCE_DIR}/../ReadMe
      DESTINATION H3DPhysics
      COMPONENT H3DPhysics_cpack_sources )

  #install header files
  INSTALL( FILES ${H3DPhysics_HEADERS_NO_COOKING}
      DESTINATION H3DPhysics/include/H3D/H3DPhysics
      COMPONENT H3DPhysics_cpack_headers )
      
  INSTALL( FILES ${H3DPhysics_HEADERS_COOKING}
      DESTINATION H3DPhysics/include/H3D/H3DPhysics/PhysX
      COMPONENT H3DPhysics_cpack_headers )

  # H3DPhysics.cmake that goes to headers is not needed unless sources is required.
  INSTALL( FILES ${H3DPhysics_SOURCE_DIR}/../include/H3D/H3DPhysics/H3DPhysics.cmake
      DESTINATION H3DPhysics/include/H3D/H3DPhysics
      COMPONENT H3DPhysics_cpack_sources )

  #install source files
  INSTALL( FILES ${H3DPhysics_SRCS_NO_COOKING}
      DESTINATION H3DPhysics/src
      COMPONENT H3DPhysics_cpack_sources )

  INSTALL( FILES ${H3DPhysics_SRCS_COOKING}
      DESTINATION H3DPhysics/src/PhysX
      COMPONENT H3DPhysics_cpack_sources )

  #install build directory
  INSTALL( FILES ${H3DPhysics_SOURCE_DIR}/CMakeLists.txt
         ${H3DPhysics_SOURCE_DIR}/H3DPhysics.rc.cmake
         ${H3DPhysics_SOURCE_DIR}/H3DPhysicsCpack.cmake
         ${H3DPhysics_SOURCE_DIR}/H3DPhysicsSourceFiles.txt
         ${H3DPhysics_SOURCE_DIR}/UpdateResourceFile.exe
         DESTINATION H3DPhysics/build
         COMPONENT H3DPhysics_cpack_sources )
  
  #install module directory
  INSTALL( DIRECTORY ${H3DPhysics_SOURCE_DIR}/modules
           DESTINATION H3DPhysics/build
           COMPONENT H3DPhysics_cpack_sources )

  #install example directory
  INSTALL( DIRECTORY ${H3DPhysics_SOURCE_DIR}/../examples
           DESTINATION H3DPhysics
           COMPONENT H3DPhysics_cpack_sources )

  IF( ( EXISTS ${H3DPhysics_SOURCE_DIR}/../doc/H3DPhysics.tag ) AND ( EXISTS ${H3DPhysics_SOURCE_DIR}/../doc/html ) )
    # Install documentation
    INSTALL( FILES ${H3DPhysics_SOURCE_DIR}/../doc/H3DPhysics.tag
             DESTINATION H3DPhysics/doc
             COMPONENT H3DPhysics_cpack_headers)
    INSTALL( DIRECTORY ${H3DPhysics_SOURCE_DIR}/../doc/html
             DESTINATION H3DPhysics/doc
             COMPONENT H3DPhysics_cpack_headers)
  ENDIF( ( EXISTS ${H3DPhysics_SOURCE_DIR}/../doc/H3DPhysics.tag ) AND ( EXISTS ${H3DPhysics_SOURCE_DIR}/../doc/html ) )
  
  IF( EXISTS ${H3DPhysics_SOURCE_DIR}/../doc/python/doc )
    # Install documentation
    INSTALL( DIRECTORY ${H3DPhysics_SOURCE_DIR}/../doc/python/doc
             DESTINATION H3DPhysics/doc/python
             COMPONENT H3DPhysics_cpack_headers)
  ENDIF( EXISTS ${H3DPhysics_SOURCE_DIR}/../doc/python/doc )
  
  # setting names and dependencies between components and also grouping them.
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_RUNTIME_DISPLAY_NAME "Runtime")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_RUNTIME_DESCRIPTION "The runtime libraries (dlls) for H3DPhysics.")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_RUNTIME_DEPENDS  H3DAPI_cpack_runtime H3DPhysics_cpack_external_runtime )
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_RUNTIME_GROUP "H3DPhysics_cpack_group")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_RUNTIME_INSTALL_TYPES Developer Full)
    
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_LIBRARIES_DISPLAY_NAME "Libraries")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_LIBRARIES_DESCRIPTION "H3DPhysics libraries, needed for building against H3DPhysics.")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_LIBRARIES_DEPENDS H3DAPI_cpack_libraries H3DPhysics_cpack_external_source H3DPhysics_cpack_headers )
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_LIBRARIES_GROUP "H3DPhysics_cpack_group")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_LIBRARIES_INSTALL_TYPES Developer Full)
    
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_HEADERS_DISPLAY_NAME "C++ Headers")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_HEADERS_DESCRIPTION "H3DPhysics C++ headers, needed for building against H3DPhysics.")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_HEADERS_DEPENDS H3DAPI_cpack_headers H3DPhysics_cpack_external_source H3DPhysics_cpack_libraries )
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_HEADERS_GROUP "H3DPhysics_cpack_group")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_HEADERS_INSTALL_TYPES Developer Full)
    
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_SOURCES_DISPLAY_NAME "C++ Source")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_SOURCES_DESCRIPTION "Everything needed to build H3DPhysics.")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_SOURCES_DEPENDS H3DAPI_cpack_sources H3DPhysics_cpack_headers )
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_SOURCES_GROUP "H3DPhysics_cpack_group")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_SOURCES_INSTALL_TYPES Full)
  
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXAMPLES_RUNTIME_DISPLAY_NAME "Example applications")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXAMPLES_RUNTIME_DESCRIPTION "The example applications for H3DPhysics.")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXAMPLES_RUNTIME_DEPENDS H3DPhysics_cpack_runtime )
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXAMPLES_RUNTIME_GROUP "H3DPhysics_cpack_group")
  set(CPACK_COMPONENT_H3DPHYSICS_CPACK_EXAMPLES_RUNTIME_INSTALL_TYPES Developer Full)
  
  set(CPACK_COMPONENT_GROUP_H3DPHYSICS_CPACK_GROUP_DISPLAY_NAME "H3DPhysics")
  set(CPACK_COMPONENT_GROUP_H3DPHYSICS_CPACK_GROUP_DESCRIPTION "H3DPhysics implements the RigidBodyPhysics component of the X3D specification with additional nodes for soft body physics.")
  
  # Add a cache variable H3D_cmake_runtime_path to point to cmake binary.
  SET (H3D_cmake_runtime_path_default "")
  IF( NOT DEFINED H3D_cmake_runtime_path )
    IF( WIN32 AND NOT UNIX )
      SET (VERSION_CMAKES "4.0" "3.9" "3.8" "3.7" "3.6" "3.5" "3.4" "3.3" "3.2" "3.1" "3.0" "2.9" "2.8" "2.7" "2.6")
      foreach (version_cmake ${VERSION_CMAKES} )
        IF (EXISTS "C:/Program Files/CMake ${version_cmake}/bin/cmake.exe")
          SET( H3D_cmake_runtime_path_default "C:/Program Files/CMake ${version_cmake}/bin/cmake.exe" )
          break()
        ENDIF (EXISTS "C:/Program Files/CMake ${version_cmake}/bin/cmake.exe")
        
        IF (EXISTS "C:/Program Files (x86)/CMake ${version_cmake}/bin/cmake.exe")
          SET( H3D_cmake_runtime_path_default "C:/Program Files (x86)/CMake ${version_cmake}/bin/cmake.exe" )
          break()
        ENDIF (EXISTS "C:/Program Files (x86)/CMake ${version_cmake}/bin/cmake.exe")
        
        IF ( EXISTS "C:/Program/CMake ${version_cmake}/bin/cmake.exe")
          SET( H3D_cmake_runtime_path_default "C:/Program/CMake ${version_cmake}/bin/cmake.exe" )
          break()
        ENDIF ( EXISTS "C:/Program/CMake ${version_cmake}/bin/cmake.exe")
      endforeach (version_cmake )
    ELSE( WIN32 AND NOT UNIX )
      SET( H3D_cmake_runtime_path_default "cmake" )
    ENDIF( WIN32 AND NOT UNIX )
    SET( H3D_cmake_runtime_path ${H3D_cmake_runtime_path_default} CACHE FILEPATH "The path to the cmake runtime." )
    MARK_AS_ADVANCED(H3D_cmake_runtime_path)
  ENDIF( NOT DEFINED H3D_cmake_runtime_path )
  
  IF(UNIX)
    SET(CPACK_SOURCE_INSTALLED_DIRECTORIES "${H3DPhysics_SOURCE_DIR}/..;/" )  
    SET(CPACK_SOURCE_GENERATOR TGZ ZIP ) 
    SET(CPACK_SOURCE_PACKAGE_FILE_NAME "h3dphysics-${H3DPHYSICS_MAJOR_VERSION}.${H3DPHYSICS_MINOR_VERSION}.${H3DPHYSICS_BUILD_VERSION}") 


    SET( H3DPhysics_CPACK_IGNORE_PATTERNS ${H3DPhysics_CPACK_IGNORE_PATTERNS}
            "/CVS/;/.svn/;/.bzr/;/.hg/;/.git.*/;.swp$;.#;/#;~$")
    SET(CPACK_SOURCE_IGNORE_FILES ${H3DPhysics_CPACK_IGNORE_PATTERNS} )
  ENDIF( UNIX )


  IF( H3D_cmake_runtime_path )
    SET( INSTALL_RUNTIME_AND_LIBRARIES_ONLY_POST_BUILD ${INSTALL_RUNTIME_AND_LIBRARIES_ONLY_POST_BUILD}
                                                       COMMAND ${H3D_cmake_runtime_path} 
                                                       ARGS -DBUILD_TYPE=$(Configuration) -DCOMPONENT=H3DPhysics_cpack_runtime -P cmake_install.cmake 
                                                       COMMAND ${H3D_cmake_runtime_path} 
                                                       ARGS -DBUILD_TYPE=$(Configuration) -DCOMPONENT=H3DPhysics_cpack_libraries -P cmake_install.cmake
                                                       COMMAND ${H3D_cmake_runtime_path} 
                                                       ARGS -DBUILD_TYPE=$(Configuration) -DCOMPONENT=MedX3D_cpack_examples_runtime -P cmake_install.cmake )
    
    IF (NOT H3D_USE_DEPENDENCIES_ONLY)
      ADD_CUSTOM_COMMAND( OUTPUT ${CMAKE_CURRENT_BINARY_DIR}/DummyFile
                          COMMAND echo )
      ADD_CUSTOM_TARGET( INSTALL_RUNTIME_AND_LIBRARIES_ONLY
                         DEPENDS ${CMAKE_CURRENT_BINARY_DIR}/DummyFile )
      
      ADD_CUSTOM_COMMAND( TARGET INSTALL_RUNTIME_AND_LIBRARIES_ONLY
                          POST_BUILD
                          ${INSTALL_RUNTIME_AND_LIBRARIES_ONLY_POST_BUILD} )
      ADD_DEPENDENCIES( INSTALL_RUNTIME_AND_LIBRARIES_ONLY H3DPhysics ${INSTALL_RUNTIME_AND_LIBRARIES_ONLY_DEPENDENCIES} )
    ENDIF (NOT H3D_USE_DEPENDENCIES_ONLY)
  ELSE( H3D_cmake_runtime_path )
    MESSAGE (STATUS "H3D_cmake_runtime_path is not set, please set it to continue")
  ENDIF( H3D_cmake_runtime_path )
  
  IF( NOT H3D_USE_DEPENDENCIES_ONLY)
  INCLUDE(CPack)
  ENDIF( NOT H3D_USE_DEPENDENCIES_ONLY)
  #CPack said: could not find load file Debian
  # INCLUDE(UseDebian)
  # IF(DEBIAN_FOUND)
    # ADD_DEBIAN_TARGETS(H3DPhysics)
  # ENDIF(DEBIAN_FOUND)
ENDIF( GENERATE_CPACK_PROJECT)
