# - Find PHYSX3
# Find the native PHYSX3 headers and libraries.
#
#  PHYSX3_INCLUDE_DIR -  where to find the include files of PHYSX3
#  PHYSX3_LIBRARIES    - List of libraries when using PHYSX3.
#  PHYSX3_FOUND        - True if PHYSX3 found.
#  PHYSX3_FLAGS        - Flags needed for ode to build 

GET_FILENAME_COMPONENT(module_file_path ${CMAKE_CURRENT_LIST_FILE} PATH )

IF( CMAKE_SIZEOF_VOID_P EQUAL 8 )
  SET( LIB "64" )
  SET( ARCH "x64" )
ELSE()
  SET( LIB "32" )
  SET( ARCH "x86" )
ENDIF()

SET(PHYSX3_INSTALL_DIR "" CACHE PATH "Path to external PhysX 3 installation" )
MARK_AS_ADVANCED(PHYSX3_INSTALL_DIR)

# Look for the header file.
FIND_PATH( PHYSX3_INCLUDE_DIR NAMES PxPhysics.h
           PATHS /usr/local/include
                 ${PHYSX3_INSTALL_DIR}/Include
                 $ENV{H3D_EXTERNAL_ROOT}/include  
                 $ENV{H3D_ROOT}/../External/include
                 ../../External/include
                 ${module_file_path}/../../External/include
                 ${module_file_path}/../../../External/include )

MARK_AS_ADVANCED(PHYSX3_INCLUDE_DIR)

SET( PHYSX3_LIBS_FOUND 1 )

# Decide which libraires to add
IF ( NOT DEFINED PHYSX3_LIBS )

  SET( PHYSX3_LIBS 
      "PxTask"
      "RepX3"
      "RepXUpgrader3"
      "PhysX3Common"
      "PhysX3Extensions"
      "PhysX3"
      "PhysX3Vehicle"
      "PhysX3Cooking"
      "PhysX3CharacterKinematic"
      "PhysXProfileSDK"
      "PhysXVisualDebuggerSDK"
      )

  IF( UNIX )
    SET( PHYSX3_LIBS ${PHYSX3_LIBS}
      "PvdRuntime"
      "LowLevel"
      "LowLevelCloth"
      "SceneQuery"
      "SimulationController"
      )
  ENDIF()
  
ENDIF()

# Look for the libraries.
FOREACH( PHYSX3_LIB ${PHYSX3_LIBS})
  STRING(TOUPPER ${PHYSX3_LIB} _upper_lib_name)
  
  FIND_LIBRARY( PHYSX3_${_upper_lib_name}_LIBRARY 
                NAMES ${PHYSX3_LIB}_${ARCH} ${PHYSX3_LIB}
                PATHS ${PHYSX3_INSTALL_DIR}/Lib/win${LIB}
                      ${PHYSX3_INSTALL_DIR}/Lib/linux${LIB}
                      $ENV{H3D_EXTERNAL_ROOT}/lib${LIB}
                      $ENV{H3D_ROOT}/../External/lib${LIB}
                      ../../External/lib${LIB}
                      ${module_file_path}/../../External/lib${LIB}
                      ${module_file_path}/../../../External/lib${LIB} )
  MARK_AS_ADVANCED(PHYSX3_${_upper_lib_name}_LIBRARY)
                      
  IF( PHYSX3_${_upper_lib_name}_LIBRARY )
    IF ( UNIX )
      # To avoid undefined symbols at runtime we need to include the entire static library in our shared library
      SET ( PHYSX3_${_upper_lib_name}_LIBRARY -Wl,-whole-archive ${PHYSX3_${_upper_lib_name}_LIBRARY} -Wl,-no-whole-archive )
    ENDIF()
    SET( PHYSX3_LIBS_PATHS ${PHYSX3_LIBS_PATHS} ${PHYSX3_${_upper_lib_name}_LIBRARY} )
  ELSE()
    SET( PHYSX3_LIBS_FOUND 0 )
    SET( PHYSX3_LIBS_NOTFOUND ${PHYSX3_LIBS_NOTFOUND} ${PHYSX3_LIB} ) 
  ENDIF()
  
ENDFOREACH()
                      
MARK_AS_ADVANCED(PHYSX3_LIBS)

# Copy the results to the output variables.
IF ( PHYSX3_INCLUDE_DIR AND 
     PHYSX3_LIBS_FOUND)
  SET(PHYSX3_FOUND 1)
  SET(PHYSX3_LIBRARIES ${PHYSX3_LIBS_PATHS})
  SET(PHYSX3_INCLUDE_DIR ${PHYSX3_INCLUDE_DIR} )
ELSE()
  SET(PHYSX3_FOUND 0)
  SET(PHYSX3_LIBRARIES)
  SET(PHYSX3_INCLUDE_DIR)
ENDIF()

# Report the results.
IF(NOT PHYSX3_FOUND)
  SET(PHYSX3_DIR_MESSAGE
    "PHYSX3 was not found. Set PHYSX3_INSTALL_DIR to the root directory of the 
installation containing the 'include' and 'lib' folders.")
  IF(PHYSX3_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "${PHYSX3_DIR_MESSAGE}")
  ELSEIF(NOT PHYSX3_FIND_QUIETLY)
    MESSAGE(STATUS "${PHYSX3_DIR_MESSAGE}")
  ENDIF(PHYSX3_FIND_REQUIRED)
ENDIF(NOT PHYSX3_FOUND)
