//////////////////////////////////////////////////////////////////////////////
//    Copyright 2004-2014, SenseGraphics AB
//
//    This file is part of H3D API.
//
//    MedX3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    MedX3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with MedX3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//    A commercial license is also available. Please contact us at 
//    www.sensegraphics.com for more information.
//
//
//
/// \file Config.cpp
/// \brief cpp file for RigidBodyPhyics configuration.
///
//////////////////////////////////////////////////////////////////////////////

#include <H3D/H3DPhysics/H3DPhysics.h>
#include <sstream>
#include <cstring>

using namespace std;

H3D::LibraryInfo getLibraryInfo() {
  H3D::LibraryInfo r = H3D::LibraryInfo::createEmptyInfo();
  std::stringstream s;
  s << H3DPHYSICS_MAJOR_VERSION << "."
    << H3DPHYSICS_MINOR_VERSION << " (build "
    << H3DPHYSICS_BUILD_VERSION << ")";

  strcpy(r.name, "H3DPhysics" );
  strcpy( r.version, s.str().c_str() );
  //strcpy( r.web, "http://www.h3dapi.org/modules/mediawiki/index.php/H3DPhysics" );
  strcpy( r.developer, "SenseGraphics AB" );
  strcpy( r.developer_web, "http://www.sensegraphics.com" );
  strcpy( r.info, "Adds the nodes from the H3DPhysics component of X3D allowing physics simulation. Soft and rigid bodies may be defined and manipulated with haptic devices." );
  return r;

}
