{-# OPTIONS_HADDOCK hide #-}
--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.Rendering.OpenGL.Raw.ARB.Compatibility.Tokens
-- Copyright   :  (c) Sven Panne 2013
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- All tokens from the ARB_compatibility extension, see
-- <http://www.opengl.org/registry/specs/ARB/compatibility.txt>.
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.Raw.ARB.Compatibility.Tokens where

import Graphics.Rendering.OpenGL.Raw.Core31

gl_2D :: GLenum
gl_2D = 0x0600

gl_2_BYTES :: GLenum
gl_2_BYTES = 0x1407

gl_3D :: GLenum
gl_3D = 0x0601

gl_3D_COLOR :: GLenum
gl_3D_COLOR = 0x0602

gl_3D_COLOR_TEXTURE :: GLenum
gl_3D_COLOR_TEXTURE = 0x0603

gl_3_BYTES :: GLenum
gl_3_BYTES = 0x1408

gl_4D_COLOR_TEXTURE :: GLenum
gl_4D_COLOR_TEXTURE = 0x0604

gl_4_BYTES :: GLenum
gl_4_BYTES = 0x1409

gl_ACCUM :: GLenum
gl_ACCUM = 0x0100

gl_ACCUM_ALPHA_BITS :: GLenum
gl_ACCUM_ALPHA_BITS = 0x0D5B

gl_ACCUM_BLUE_BITS :: GLenum
gl_ACCUM_BLUE_BITS = 0x0D5A

gl_ACCUM_BUFFER_BIT :: GLbitfield
gl_ACCUM_BUFFER_BIT = 0x00000200

gl_ACCUM_CLEAR_VALUE :: GLenum
gl_ACCUM_CLEAR_VALUE = 0x0B80

gl_ACCUM_GREEN_BITS :: GLenum
gl_ACCUM_GREEN_BITS = 0x0D59

gl_ACCUM_RED_BITS :: GLenum
gl_ACCUM_RED_BITS = 0x0D58

gl_ADD :: GLenum
gl_ADD = 0x0104

gl_ADD_SIGNED :: GLenum
gl_ADD_SIGNED = 0x8574

gl_ALIASED_POINT_SIZE_RANGE :: GLenum
gl_ALIASED_POINT_SIZE_RANGE = 0x846D

gl_ALL_ATTRIB_BITS :: GLbitfield
gl_ALL_ATTRIB_BITS = 0xFFFFFFFF

gl_ALPHA12 :: GLenum
gl_ALPHA12 = 0x803D

gl_ALPHA16 :: GLenum
gl_ALPHA16 = 0x803E

gl_ALPHA4 :: GLenum
gl_ALPHA4 = 0x803B

gl_ALPHA8 :: GLenum
gl_ALPHA8 = 0x803C

gl_ALPHA_BIAS :: GLenum
gl_ALPHA_BIAS = 0x0D1D

gl_ALPHA_BITS :: GLenum
gl_ALPHA_BITS = 0x0D55

gl_ALPHA_INTEGER :: GLenum
gl_ALPHA_INTEGER = 0x8D97

gl_ALPHA_SCALE :: GLenum
gl_ALPHA_SCALE = 0x0D1C

gl_ALPHA_TEST :: GLenum
gl_ALPHA_TEST = 0x0BC0

gl_ALPHA_TEST_FUNC :: GLenum
gl_ALPHA_TEST_FUNC = 0x0BC1

gl_ALPHA_TEST_REF :: GLenum
gl_ALPHA_TEST_REF = 0x0BC2

gl_AMBIENT :: GLenum
gl_AMBIENT = 0x1200

gl_AMBIENT_AND_DIFFUSE :: GLenum
gl_AMBIENT_AND_DIFFUSE = 0x1602

gl_ATTRIB_STACK_DEPTH :: GLenum
gl_ATTRIB_STACK_DEPTH = 0x0BB0

gl_AUTO_NORMAL :: GLenum
gl_AUTO_NORMAL = 0x0D80

gl_AUX0 :: GLenum
gl_AUX0 = 0x0409

gl_AUX1 :: GLenum
gl_AUX1 = 0x040A

gl_AUX2 :: GLenum
gl_AUX2 = 0x040B

gl_AUX3 :: GLenum
gl_AUX3 = 0x040C

gl_AUX_BUFFERS :: GLenum
gl_AUX_BUFFERS = 0x0C00

gl_BITMAP :: GLenum
gl_BITMAP = 0x1A00

gl_BITMAP_TOKEN :: GLenum
gl_BITMAP_TOKEN = 0x0704

gl_BLUE_BIAS :: GLenum
gl_BLUE_BIAS = 0x0D1B

gl_BLUE_BITS :: GLenum
gl_BLUE_BITS = 0x0D54

gl_BLUE_SCALE :: GLenum
gl_BLUE_SCALE = 0x0D1A

gl_C3F_V3F :: GLenum
gl_C3F_V3F = 0x2A24

gl_C4F_N3F_V3F :: GLenum
gl_C4F_N3F_V3F = 0x2A26

gl_C4UB_V2F :: GLenum
gl_C4UB_V2F = 0x2A22

gl_C4UB_V3F :: GLenum
gl_C4UB_V3F = 0x2A23

gl_CLAMP :: GLenum
gl_CLAMP = 0x2900

gl_CLAMP_FRAGMENT_COLOR :: GLenum
gl_CLAMP_FRAGMENT_COLOR = 0x891B

gl_CLAMP_VERTEX_COLOR :: GLenum
gl_CLAMP_VERTEX_COLOR = 0x891A

gl_CLIENT_ACTIVE_TEXTURE :: GLenum
gl_CLIENT_ACTIVE_TEXTURE = 0x84E1

gl_CLIENT_ALL_ATTRIB_BITS :: GLbitfield
gl_CLIENT_ALL_ATTRIB_BITS = 0xFFFFFFFF

gl_CLIENT_ATTRIB_STACK_DEPTH :: GLenum
gl_CLIENT_ATTRIB_STACK_DEPTH = 0x0BB1

gl_CLIENT_PIXEL_STORE_BIT :: GLbitfield
gl_CLIENT_PIXEL_STORE_BIT = 0x00000001

gl_CLIENT_VERTEX_ARRAY_BIT :: GLbitfield
gl_CLIENT_VERTEX_ARRAY_BIT = 0x00000002

gl_CLIP_PLANE0 :: GLenum
gl_CLIP_PLANE0 = 0x3000

gl_CLIP_PLANE1 :: GLenum
gl_CLIP_PLANE1 = 0x3001

gl_CLIP_PLANE2 :: GLenum
gl_CLIP_PLANE2 = 0x3002

gl_CLIP_PLANE3 :: GLenum
gl_CLIP_PLANE3 = 0x3003

gl_CLIP_PLANE4 :: GLenum
gl_CLIP_PLANE4 = 0x3004

gl_CLIP_PLANE5 :: GLenum
gl_CLIP_PLANE5 = 0x3005

gl_COEFF :: GLenum
gl_COEFF = 0x0A00

gl_COLOR_ARRAY :: GLenum
gl_COLOR_ARRAY = 0x8076

gl_COLOR_ARRAY_BUFFER_BINDING :: GLenum
gl_COLOR_ARRAY_BUFFER_BINDING = 0x8898

gl_COLOR_ARRAY_COUNT :: GLenum
gl_COLOR_ARRAY_COUNT = 0x8084

gl_COLOR_ARRAY_POINTER :: GLenum
gl_COLOR_ARRAY_POINTER = 0x8090

gl_COLOR_ARRAY_SIZE :: GLenum
gl_COLOR_ARRAY_SIZE = 0x8081

gl_COLOR_ARRAY_STRIDE :: GLenum
gl_COLOR_ARRAY_STRIDE = 0x8083

gl_COLOR_ARRAY_TYPE :: GLenum
gl_COLOR_ARRAY_TYPE = 0x8082

gl_COLOR_INDEX :: GLenum
gl_COLOR_INDEX = 0x1900

gl_COLOR_INDEXES :: GLenum
gl_COLOR_INDEXES = 0x1603

gl_COLOR_MATERIAL :: GLenum
gl_COLOR_MATERIAL = 0x0B57

gl_COLOR_MATERIAL_FACE :: GLenum
gl_COLOR_MATERIAL_FACE = 0x0B55

gl_COLOR_MATERIAL_PARAMETER :: GLenum
gl_COLOR_MATERIAL_PARAMETER = 0x0B56

gl_COLOR_MATRIX :: GLenum
gl_COLOR_MATRIX = 0x80B1

gl_COLOR_MATRIX_STACK_DEPTH :: GLenum
gl_COLOR_MATRIX_STACK_DEPTH = 0x80B2

gl_COLOR_SUM :: GLenum
gl_COLOR_SUM = 0x8458

gl_COLOR_TABLE :: GLenum
gl_COLOR_TABLE = 0x80D0

gl_COLOR_TABLE_ALPHA_SIZE :: GLenum
gl_COLOR_TABLE_ALPHA_SIZE = 0x80DD

gl_COLOR_TABLE_BIAS :: GLenum
gl_COLOR_TABLE_BIAS = 0x80D7

gl_COLOR_TABLE_BLUE_SIZE :: GLenum
gl_COLOR_TABLE_BLUE_SIZE = 0x80DC

gl_COLOR_TABLE_FORMAT :: GLenum
gl_COLOR_TABLE_FORMAT = 0x80D8

gl_COLOR_TABLE_GREEN_SIZE :: GLenum
gl_COLOR_TABLE_GREEN_SIZE = 0x80DB

gl_COLOR_TABLE_INTENSITY_SIZE :: GLenum
gl_COLOR_TABLE_INTENSITY_SIZE = 0x80DF

gl_COLOR_TABLE_LUMINANCE_SIZE :: GLenum
gl_COLOR_TABLE_LUMINANCE_SIZE = 0x80DE

gl_COLOR_TABLE_RED_SIZE :: GLenum
gl_COLOR_TABLE_RED_SIZE = 0x80DA

gl_COLOR_TABLE_SCALE :: GLenum
gl_COLOR_TABLE_SCALE = 0x80D6

gl_COLOR_TABLE_WIDTH :: GLenum
gl_COLOR_TABLE_WIDTH = 0x80D9

gl_COMBINE :: GLenum
gl_COMBINE = 0x8570

gl_COMBINE_ALPHA :: GLenum
gl_COMBINE_ALPHA = 0x8572

gl_COMBINE_RGB :: GLenum
gl_COMBINE_RGB = 0x8571

gl_COMPARE_R_TO_TEXTURE :: GLenum
gl_COMPARE_R_TO_TEXTURE = 0x884E

gl_COMPILE :: GLenum
gl_COMPILE = 0x1300

gl_COMPILE_AND_EXECUTE :: GLenum
gl_COMPILE_AND_EXECUTE = 0x1301

gl_COMPRESSED_ALPHA :: GLenum
gl_COMPRESSED_ALPHA = 0x84E9

gl_COMPRESSED_INTENSITY :: GLenum
gl_COMPRESSED_INTENSITY = 0x84EC

gl_COMPRESSED_LUMINANCE :: GLenum
gl_COMPRESSED_LUMINANCE = 0x84EA

gl_COMPRESSED_LUMINANCE_ALPHA :: GLenum
gl_COMPRESSED_LUMINANCE_ALPHA = 0x84EB

gl_COMPRESSED_SLUMINANCE :: GLenum
gl_COMPRESSED_SLUMINANCE = 0x8C4A

gl_COMPRESSED_SLUMINANCE_ALPHA :: GLenum
gl_COMPRESSED_SLUMINANCE_ALPHA = 0x8C4B

gl_CONSTANT :: GLenum
gl_CONSTANT = 0x8576

gl_CONSTANT_ATTENUATION :: GLenum
gl_CONSTANT_ATTENUATION = 0x1207

gl_CONSTANT_BORDER :: GLenum
gl_CONSTANT_BORDER = 0x8151

gl_CONVOLUTION_1D :: GLenum
gl_CONVOLUTION_1D = 0x8010

gl_CONVOLUTION_2D :: GLenum
gl_CONVOLUTION_2D = 0x8011

gl_CONVOLUTION_BORDER_COLOR :: GLenum
gl_CONVOLUTION_BORDER_COLOR = 0x8154

gl_CONVOLUTION_BORDER_MODE :: GLenum
gl_CONVOLUTION_BORDER_MODE = 0x8013

gl_CONVOLUTION_FILTER_BIAS :: GLenum
gl_CONVOLUTION_FILTER_BIAS = 0x8015

gl_CONVOLUTION_FILTER_SCALE :: GLenum
gl_CONVOLUTION_FILTER_SCALE = 0x8014

gl_CONVOLUTION_FORMAT :: GLenum
gl_CONVOLUTION_FORMAT = 0x8017

gl_CONVOLUTION_HEIGHT :: GLenum
gl_CONVOLUTION_HEIGHT = 0x8019

gl_CONVOLUTION_WIDTH :: GLenum
gl_CONVOLUTION_WIDTH = 0x8018

gl_COORD_REPLACE :: GLenum
gl_COORD_REPLACE = 0x8862

gl_COPY_PIXEL_TOKEN :: GLenum
gl_COPY_PIXEL_TOKEN = 0x0706

gl_CURRENT_BIT :: GLbitfield
gl_CURRENT_BIT = 0x00000001

gl_CURRENT_COLOR :: GLenum
gl_CURRENT_COLOR = 0x0B00

gl_CURRENT_FOG_COORD :: GLenum
gl_CURRENT_FOG_COORD = 0x8453

gl_CURRENT_FOG_COORDINATE :: GLenum
gl_CURRENT_FOG_COORDINATE = 0x8453

gl_CURRENT_INDEX :: GLenum
gl_CURRENT_INDEX = 0x0B01

gl_CURRENT_NORMAL :: GLenum
gl_CURRENT_NORMAL = 0x0B02

gl_CURRENT_RASTER_COLOR :: GLenum
gl_CURRENT_RASTER_COLOR = 0x0B04

gl_CURRENT_RASTER_DISTANCE :: GLenum
gl_CURRENT_RASTER_DISTANCE = 0x0B09

gl_CURRENT_RASTER_INDEX :: GLenum
gl_CURRENT_RASTER_INDEX = 0x0B05

gl_CURRENT_RASTER_POSITION :: GLenum
gl_CURRENT_RASTER_POSITION = 0x0B07

gl_CURRENT_RASTER_POSITION_VALID :: GLenum
gl_CURRENT_RASTER_POSITION_VALID = 0x0B08

gl_CURRENT_RASTER_SECONDARY_COLOR :: GLenum
gl_CURRENT_RASTER_SECONDARY_COLOR = 0x845F

gl_CURRENT_RASTER_TEXTURE_COORDS :: GLenum
gl_CURRENT_RASTER_TEXTURE_COORDS = 0x0B06

gl_CURRENT_SECONDARY_COLOR :: GLenum
gl_CURRENT_SECONDARY_COLOR = 0x8459

gl_CURRENT_TEXTURE_COORDS :: GLenum
gl_CURRENT_TEXTURE_COORDS = 0x0B03

gl_DECAL :: GLenum
gl_DECAL = 0x2101

gl_DEPTH_BIAS :: GLenum
gl_DEPTH_BIAS = 0x0D1F

gl_DEPTH_BITS :: GLenum
gl_DEPTH_BITS = 0x0D56

gl_DEPTH_SCALE :: GLenum
gl_DEPTH_SCALE = 0x0D1E

gl_DEPTH_TEXTURE_MODE :: GLenum
gl_DEPTH_TEXTURE_MODE = 0x884B

gl_DIFFUSE :: GLenum
gl_DIFFUSE = 0x1201

gl_DOMAIN :: GLenum
gl_DOMAIN = 0x0A02

gl_DOT3_RGB :: GLenum
gl_DOT3_RGB = 0x86AE

gl_DOT3_RGBA :: GLenum
gl_DOT3_RGBA = 0x86AF

gl_DRAW_PIXEL_TOKEN :: GLenum
gl_DRAW_PIXEL_TOKEN = 0x0705

gl_EDGE_FLAG :: GLenum
gl_EDGE_FLAG = 0x0B43

gl_EDGE_FLAG_ARRAY :: GLenum
gl_EDGE_FLAG_ARRAY = 0x8079

gl_EDGE_FLAG_ARRAY_BUFFER_BINDING :: GLenum
gl_EDGE_FLAG_ARRAY_BUFFER_BINDING = 0x889B

gl_EDGE_FLAG_ARRAY_COUNT :: GLenum
gl_EDGE_FLAG_ARRAY_COUNT = 0x808D

gl_EDGE_FLAG_ARRAY_POINTER :: GLenum
gl_EDGE_FLAG_ARRAY_POINTER = 0x8093

gl_EDGE_FLAG_ARRAY_STRIDE :: GLenum
gl_EDGE_FLAG_ARRAY_STRIDE = 0x808C

gl_EMISSION :: GLenum
gl_EMISSION = 0x1600

gl_ENABLE_BIT :: GLbitfield
gl_ENABLE_BIT = 0x00002000

gl_EVAL_BIT :: GLbitfield
gl_EVAL_BIT = 0x00010000

gl_EXP :: GLenum
gl_EXP = 0x0800

gl_EXP2 :: GLenum
gl_EXP2 = 0x0801

gl_EYE_LINEAR :: GLenum
gl_EYE_LINEAR = 0x2400

gl_EYE_PLANE :: GLenum
gl_EYE_PLANE = 0x2502

gl_FEEDBACK :: GLenum
gl_FEEDBACK = 0x1C01

gl_FEEDBACK_BUFFER_POINTER :: GLenum
gl_FEEDBACK_BUFFER_POINTER = 0x0DF0

gl_FEEDBACK_BUFFER_SIZE :: GLenum
gl_FEEDBACK_BUFFER_SIZE = 0x0DF1

gl_FEEDBACK_BUFFER_TYPE :: GLenum
gl_FEEDBACK_BUFFER_TYPE = 0x0DF2

gl_FLAT :: GLenum
gl_FLAT = 0x1D00

gl_FOG :: GLenum
gl_FOG = 0x0B60

gl_FOG_BIT :: GLbitfield
gl_FOG_BIT = 0x00000080

gl_FOG_COLOR :: GLenum
gl_FOG_COLOR = 0x0B66

gl_FOG_COORD :: GLenum
gl_FOG_COORD = 0x8451

gl_FOG_COORDINATE :: GLenum
gl_FOG_COORDINATE = 0x8451

gl_FOG_COORDINATE_ARRAY :: GLenum
gl_FOG_COORDINATE_ARRAY = 0x8457

gl_FOG_COORDINATE_ARRAY_BUFFER_BINDING :: GLenum
gl_FOG_COORDINATE_ARRAY_BUFFER_BINDING = 0x889D

gl_FOG_COORDINATE_ARRAY_POINTER :: GLenum
gl_FOG_COORDINATE_ARRAY_POINTER = 0x8456

gl_FOG_COORDINATE_ARRAY_STRIDE :: GLenum
gl_FOG_COORDINATE_ARRAY_STRIDE = 0x8455

gl_FOG_COORDINATE_ARRAY_TYPE :: GLenum
gl_FOG_COORDINATE_ARRAY_TYPE = 0x8454

gl_FOG_COORDINATE_SOURCE :: GLenum
gl_FOG_COORDINATE_SOURCE = 0x8450

gl_FOG_COORD_ARRAY :: GLenum
gl_FOG_COORD_ARRAY = 0x8457

gl_FOG_COORD_ARRAY_BUFFER_BINDING :: GLenum
gl_FOG_COORD_ARRAY_BUFFER_BINDING = 0x889D

gl_FOG_COORD_ARRAY_POINTER :: GLenum
gl_FOG_COORD_ARRAY_POINTER = 0x8456

gl_FOG_COORD_ARRAY_STRIDE :: GLenum
gl_FOG_COORD_ARRAY_STRIDE = 0x8455

gl_FOG_COORD_ARRAY_TYPE :: GLenum
gl_FOG_COORD_ARRAY_TYPE = 0x8454

gl_FOG_COORD_SRC :: GLenum
gl_FOG_COORD_SRC = 0x8450

gl_FOG_DENSITY :: GLenum
gl_FOG_DENSITY = 0x0B62

gl_FOG_END :: GLenum
gl_FOG_END = 0x0B64

gl_FOG_HINT :: GLenum
gl_FOG_HINT = 0x0C54

gl_FOG_INDEX :: GLenum
gl_FOG_INDEX = 0x0B61

gl_FOG_MODE :: GLenum
gl_FOG_MODE = 0x0B65

gl_FOG_START :: GLenum
gl_FOG_START = 0x0B63

gl_FRAGMENT_DEPTH :: GLenum
gl_FRAGMENT_DEPTH = 0x8452

gl_GENERATE_MIPMAP :: GLenum
gl_GENERATE_MIPMAP = 0x8191

gl_GENERATE_MIPMAP_HINT :: GLenum
gl_GENERATE_MIPMAP_HINT = 0x8192

gl_GREEN_BIAS :: GLenum
gl_GREEN_BIAS = 0x0D19

gl_GREEN_BITS :: GLenum
gl_GREEN_BITS = 0x0D53

gl_GREEN_SCALE :: GLenum
gl_GREEN_SCALE = 0x0D18

gl_HINT_BIT :: GLbitfield
gl_HINT_BIT = 0x00008000

gl_HISTOGRAM :: GLenum
gl_HISTOGRAM = 0x8024

gl_HISTOGRAM_ALPHA_SIZE :: GLenum
gl_HISTOGRAM_ALPHA_SIZE = 0x802B

gl_HISTOGRAM_BLUE_SIZE :: GLenum
gl_HISTOGRAM_BLUE_SIZE = 0x802A

gl_HISTOGRAM_FORMAT :: GLenum
gl_HISTOGRAM_FORMAT = 0x8027

gl_HISTOGRAM_GREEN_SIZE :: GLenum
gl_HISTOGRAM_GREEN_SIZE = 0x8029

gl_HISTOGRAM_LUMINANCE_SIZE :: GLenum
gl_HISTOGRAM_LUMINANCE_SIZE = 0x802C

gl_HISTOGRAM_RED_SIZE :: GLenum
gl_HISTOGRAM_RED_SIZE = 0x8028

gl_HISTOGRAM_SINK :: GLenum
gl_HISTOGRAM_SINK = 0x802D

gl_HISTOGRAM_WIDTH :: GLenum
gl_HISTOGRAM_WIDTH = 0x8026

gl_INDEX :: GLenum
gl_INDEX = 0x8222

gl_INDEX_ARRAY :: GLenum
gl_INDEX_ARRAY = 0x8077

gl_INDEX_ARRAY_BUFFER_BINDING :: GLenum
gl_INDEX_ARRAY_BUFFER_BINDING = 0x8899

gl_INDEX_ARRAY_COUNT :: GLenum
gl_INDEX_ARRAY_COUNT = 0x8087

gl_INDEX_ARRAY_POINTER :: GLenum
gl_INDEX_ARRAY_POINTER = 0x8091

gl_INDEX_ARRAY_STRIDE :: GLenum
gl_INDEX_ARRAY_STRIDE = 0x8086

gl_INDEX_ARRAY_TYPE :: GLenum
gl_INDEX_ARRAY_TYPE = 0x8085

gl_INDEX_BITS :: GLenum
gl_INDEX_BITS = 0x0D51

gl_INDEX_CLEAR_VALUE :: GLenum
gl_INDEX_CLEAR_VALUE = 0x0C20

gl_INDEX_LOGIC_OP :: GLenum
gl_INDEX_LOGIC_OP = 0x0BF1

gl_INDEX_MODE :: GLenum
gl_INDEX_MODE = 0x0C30

gl_INDEX_OFFSET :: GLenum
gl_INDEX_OFFSET = 0x0D13

gl_INDEX_SHIFT :: GLenum
gl_INDEX_SHIFT = 0x0D12

gl_INDEX_WRITEMASK :: GLenum
gl_INDEX_WRITEMASK = 0x0C21

gl_INTENSITY :: GLenum
gl_INTENSITY = 0x8049

gl_INTENSITY12 :: GLenum
gl_INTENSITY12 = 0x804C

gl_INTENSITY16 :: GLenum
gl_INTENSITY16 = 0x804D

gl_INTENSITY4 :: GLenum
gl_INTENSITY4 = 0x804A

gl_INTENSITY8 :: GLenum
gl_INTENSITY8 = 0x804B

gl_INTERPOLATE :: GLenum
gl_INTERPOLATE = 0x8575

gl_LIGHT0 :: GLenum
gl_LIGHT0 = 0x4000

gl_LIGHT1 :: GLenum
gl_LIGHT1 = 0x4001

gl_LIGHT2 :: GLenum
gl_LIGHT2 = 0x4002

gl_LIGHT3 :: GLenum
gl_LIGHT3 = 0x4003

gl_LIGHT4 :: GLenum
gl_LIGHT4 = 0x4004

gl_LIGHT5 :: GLenum
gl_LIGHT5 = 0x4005

gl_LIGHT6 :: GLenum
gl_LIGHT6 = 0x4006

gl_LIGHT7 :: GLenum
gl_LIGHT7 = 0x4007

gl_LIGHTING :: GLenum
gl_LIGHTING = 0x0B50

gl_LIGHTING_BIT :: GLbitfield
gl_LIGHTING_BIT = 0x00000040

gl_LIGHT_MODEL_AMBIENT :: GLenum
gl_LIGHT_MODEL_AMBIENT = 0x0B53

gl_LIGHT_MODEL_COLOR_CONTROL :: GLenum
gl_LIGHT_MODEL_COLOR_CONTROL = 0x81F8

gl_LIGHT_MODEL_LOCAL_VIEWER :: GLenum
gl_LIGHT_MODEL_LOCAL_VIEWER = 0x0B51

gl_LIGHT_MODEL_TWO_SIDE :: GLenum
gl_LIGHT_MODEL_TWO_SIDE = 0x0B52

gl_LINEAR_ATTENUATION :: GLenum
gl_LINEAR_ATTENUATION = 0x1208

gl_LINE_BIT :: GLbitfield
gl_LINE_BIT = 0x00000004

gl_LINE_RESET_TOKEN :: GLenum
gl_LINE_RESET_TOKEN = 0x0707

gl_LINE_STIPPLE :: GLenum
gl_LINE_STIPPLE = 0x0B24

gl_LINE_STIPPLE_PATTERN :: GLenum
gl_LINE_STIPPLE_PATTERN = 0x0B25

gl_LINE_STIPPLE_REPEAT :: GLenum
gl_LINE_STIPPLE_REPEAT = 0x0B26

gl_LINE_TOKEN :: GLenum
gl_LINE_TOKEN = 0x0702

gl_LIST_BASE :: GLenum
gl_LIST_BASE = 0x0B32

gl_LIST_BIT :: GLbitfield
gl_LIST_BIT = 0x00020000

gl_LIST_INDEX :: GLenum
gl_LIST_INDEX = 0x0B33

gl_LIST_MODE :: GLenum
gl_LIST_MODE = 0x0B30

gl_LOAD :: GLenum
gl_LOAD = 0x0101

gl_LOGIC_OP :: GLenum
gl_LOGIC_OP = 0x0BF1

gl_LUMINANCE :: GLenum
gl_LUMINANCE = 0x1909

gl_LUMINANCE12 :: GLenum
gl_LUMINANCE12 = 0x8041

gl_LUMINANCE12_ALPHA12 :: GLenum
gl_LUMINANCE12_ALPHA12 = 0x8047

gl_LUMINANCE12_ALPHA4 :: GLenum
gl_LUMINANCE12_ALPHA4 = 0x8046

gl_LUMINANCE16 :: GLenum
gl_LUMINANCE16 = 0x8042

gl_LUMINANCE16_ALPHA16 :: GLenum
gl_LUMINANCE16_ALPHA16 = 0x8048

gl_LUMINANCE4 :: GLenum
gl_LUMINANCE4 = 0x803F

gl_LUMINANCE4_ALPHA4 :: GLenum
gl_LUMINANCE4_ALPHA4 = 0x8043

gl_LUMINANCE6_ALPHA2 :: GLenum
gl_LUMINANCE6_ALPHA2 = 0x8044

gl_LUMINANCE8 :: GLenum
gl_LUMINANCE8 = 0x8040

gl_LUMINANCE8_ALPHA8 :: GLenum
gl_LUMINANCE8_ALPHA8 = 0x8045

gl_LUMINANCE_ALPHA :: GLenum
gl_LUMINANCE_ALPHA = 0x190A

gl_MAP1_COLOR_4 :: GLenum
gl_MAP1_COLOR_4 = 0x0D90

gl_MAP1_GRID_DOMAIN :: GLenum
gl_MAP1_GRID_DOMAIN = 0x0DD0

gl_MAP1_GRID_SEGMENTS :: GLenum
gl_MAP1_GRID_SEGMENTS = 0x0DD1

gl_MAP1_INDEX :: GLenum
gl_MAP1_INDEX = 0x0D91

gl_MAP1_NORMAL :: GLenum
gl_MAP1_NORMAL = 0x0D92

gl_MAP1_TEXTURE_COORD_1 :: GLenum
gl_MAP1_TEXTURE_COORD_1 = 0x0D93

gl_MAP1_TEXTURE_COORD_2 :: GLenum
gl_MAP1_TEXTURE_COORD_2 = 0x0D94

gl_MAP1_TEXTURE_COORD_3 :: GLenum
gl_MAP1_TEXTURE_COORD_3 = 0x0D95

gl_MAP1_TEXTURE_COORD_4 :: GLenum
gl_MAP1_TEXTURE_COORD_4 = 0x0D96

gl_MAP1_VERTEX_3 :: GLenum
gl_MAP1_VERTEX_3 = 0x0D97

gl_MAP1_VERTEX_4 :: GLenum
gl_MAP1_VERTEX_4 = 0x0D98

gl_MAP2_COLOR_4 :: GLenum
gl_MAP2_COLOR_4 = 0x0DB0

gl_MAP2_GRID_DOMAIN :: GLenum
gl_MAP2_GRID_DOMAIN = 0x0DD2

gl_MAP2_GRID_SEGMENTS :: GLenum
gl_MAP2_GRID_SEGMENTS = 0x0DD3

gl_MAP2_INDEX :: GLenum
gl_MAP2_INDEX = 0x0DB1

gl_MAP2_NORMAL :: GLenum
gl_MAP2_NORMAL = 0x0DB2

gl_MAP2_TEXTURE_COORD_1 :: GLenum
gl_MAP2_TEXTURE_COORD_1 = 0x0DB3

gl_MAP2_TEXTURE_COORD_2 :: GLenum
gl_MAP2_TEXTURE_COORD_2 = 0x0DB4

gl_MAP2_TEXTURE_COORD_3 :: GLenum
gl_MAP2_TEXTURE_COORD_3 = 0x0DB5

gl_MAP2_TEXTURE_COORD_4 :: GLenum
gl_MAP2_TEXTURE_COORD_4 = 0x0DB6

gl_MAP2_VERTEX_3 :: GLenum
gl_MAP2_VERTEX_3 = 0x0DB7

gl_MAP2_VERTEX_4 :: GLenum
gl_MAP2_VERTEX_4 = 0x0DB8

gl_MAP_COLOR :: GLenum
gl_MAP_COLOR = 0x0D10

gl_MAP_STENCIL :: GLenum
gl_MAP_STENCIL = 0x0D11

gl_MATRIX_MODE :: GLenum
gl_MATRIX_MODE = 0x0BA0

gl_MAX_ATTRIB_STACK_DEPTH :: GLenum
gl_MAX_ATTRIB_STACK_DEPTH = 0x0D35

gl_MAX_CLIENT_ATTRIB_STACK_DEPTH :: GLenum
gl_MAX_CLIENT_ATTRIB_STACK_DEPTH = 0x0D3B

gl_MAX_CLIP_PLANES :: GLenum
gl_MAX_CLIP_PLANES = 0x0D32

gl_MAX_COLOR_MATRIX_STACK_DEPTH :: GLenum
gl_MAX_COLOR_MATRIX_STACK_DEPTH = 0x80B3

gl_MAX_CONVOLUTION_HEIGHT :: GLenum
gl_MAX_CONVOLUTION_HEIGHT = 0x801B

gl_MAX_CONVOLUTION_WIDTH :: GLenum
gl_MAX_CONVOLUTION_WIDTH = 0x801A

gl_MAX_EVAL_ORDER :: GLenum
gl_MAX_EVAL_ORDER = 0x0D30

gl_MAX_LIGHTS :: GLenum
gl_MAX_LIGHTS = 0x0D31

gl_MAX_LIST_NESTING :: GLenum
gl_MAX_LIST_NESTING = 0x0B31

gl_MAX_MODELVIEW_STACK_DEPTH :: GLenum
gl_MAX_MODELVIEW_STACK_DEPTH = 0x0D36

gl_MAX_NAME_STACK_DEPTH :: GLenum
gl_MAX_NAME_STACK_DEPTH = 0x0D37

gl_MAX_PIXEL_MAP_TABLE :: GLenum
gl_MAX_PIXEL_MAP_TABLE = 0x0D34

gl_MAX_PROJECTION_STACK_DEPTH :: GLenum
gl_MAX_PROJECTION_STACK_DEPTH = 0x0D38

gl_MAX_TEXTURE_COORDS :: GLenum
gl_MAX_TEXTURE_COORDS = 0x8871

gl_MAX_TEXTURE_STACK_DEPTH :: GLenum
gl_MAX_TEXTURE_STACK_DEPTH = 0x0D39

gl_MAX_TEXTURE_UNITS :: GLenum
gl_MAX_TEXTURE_UNITS = 0x84E2

gl_MINMAX :: GLenum
gl_MINMAX = 0x802E

gl_MINMAX_FORMAT :: GLenum
gl_MINMAX_FORMAT = 0x802F

gl_MINMAX_SINK :: GLenum
gl_MINMAX_SINK = 0x8030

gl_MODELVIEW :: GLenum
gl_MODELVIEW = 0x1700

gl_MODELVIEW_MATRIX :: GLenum
gl_MODELVIEW_MATRIX = 0x0BA6

gl_MODELVIEW_STACK_DEPTH :: GLenum
gl_MODELVIEW_STACK_DEPTH = 0x0BA3

gl_MODULATE :: GLenum
gl_MODULATE = 0x2100

gl_MULT :: GLenum
gl_MULT = 0x0103

gl_MULTISAMPLE_BIT :: GLbitfield
gl_MULTISAMPLE_BIT = 0x20000000

gl_N3F_V3F :: GLenum
gl_N3F_V3F = 0x2A25

gl_NAME_STACK_DEPTH :: GLenum
gl_NAME_STACK_DEPTH = 0x0D70

gl_NORMALIZE :: GLenum
gl_NORMALIZE = 0x0BA1

gl_NORMAL_ARRAY :: GLenum
gl_NORMAL_ARRAY = 0x8075

gl_NORMAL_ARRAY_BUFFER_BINDING :: GLenum
gl_NORMAL_ARRAY_BUFFER_BINDING = 0x8897

gl_NORMAL_ARRAY_COUNT :: GLenum
gl_NORMAL_ARRAY_COUNT = 0x8080

gl_NORMAL_ARRAY_POINTER :: GLenum
gl_NORMAL_ARRAY_POINTER = 0x808F

gl_NORMAL_ARRAY_STRIDE :: GLenum
gl_NORMAL_ARRAY_STRIDE = 0x807F

gl_NORMAL_ARRAY_TYPE :: GLenum
gl_NORMAL_ARRAY_TYPE = 0x807E

gl_NORMAL_MAP :: GLenum
gl_NORMAL_MAP = 0x8511

gl_OBJECT_LINEAR :: GLenum
gl_OBJECT_LINEAR = 0x2401

gl_OBJECT_PLANE :: GLenum
gl_OBJECT_PLANE = 0x2501

gl_OPERAND0_ALPHA :: GLenum
gl_OPERAND0_ALPHA = 0x8598

gl_OPERAND0_RGB :: GLenum
gl_OPERAND0_RGB = 0x8590

gl_OPERAND1_ALPHA :: GLenum
gl_OPERAND1_ALPHA = 0x8599

gl_OPERAND1_RGB :: GLenum
gl_OPERAND1_RGB = 0x8591

gl_OPERAND2_ALPHA :: GLenum
gl_OPERAND2_ALPHA = 0x859A

gl_OPERAND2_RGB :: GLenum
gl_OPERAND2_RGB = 0x8592

gl_ORDER :: GLenum
gl_ORDER = 0x0A01

gl_PASS_THROUGH_TOKEN :: GLenum
gl_PASS_THROUGH_TOKEN = 0x0700

gl_PERSPECTIVE_CORRECTION_HINT :: GLenum
gl_PERSPECTIVE_CORRECTION_HINT = 0x0C50

gl_PIXEL_MAP_A_TO_A :: GLenum
gl_PIXEL_MAP_A_TO_A = 0x0C79

gl_PIXEL_MAP_A_TO_A_SIZE :: GLenum
gl_PIXEL_MAP_A_TO_A_SIZE = 0x0CB9

gl_PIXEL_MAP_B_TO_B :: GLenum
gl_PIXEL_MAP_B_TO_B = 0x0C78

gl_PIXEL_MAP_B_TO_B_SIZE :: GLenum
gl_PIXEL_MAP_B_TO_B_SIZE = 0x0CB8

gl_PIXEL_MAP_G_TO_G :: GLenum
gl_PIXEL_MAP_G_TO_G = 0x0C77

gl_PIXEL_MAP_G_TO_G_SIZE :: GLenum
gl_PIXEL_MAP_G_TO_G_SIZE = 0x0CB7

gl_PIXEL_MAP_I_TO_A :: GLenum
gl_PIXEL_MAP_I_TO_A = 0x0C75

gl_PIXEL_MAP_I_TO_A_SIZE :: GLenum
gl_PIXEL_MAP_I_TO_A_SIZE = 0x0CB5

gl_PIXEL_MAP_I_TO_B :: GLenum
gl_PIXEL_MAP_I_TO_B = 0x0C74

gl_PIXEL_MAP_I_TO_B_SIZE :: GLenum
gl_PIXEL_MAP_I_TO_B_SIZE = 0x0CB4

gl_PIXEL_MAP_I_TO_G :: GLenum
gl_PIXEL_MAP_I_TO_G = 0x0C73

gl_PIXEL_MAP_I_TO_G_SIZE :: GLenum
gl_PIXEL_MAP_I_TO_G_SIZE = 0x0CB3

gl_PIXEL_MAP_I_TO_I :: GLenum
gl_PIXEL_MAP_I_TO_I = 0x0C70

gl_PIXEL_MAP_I_TO_I_SIZE :: GLenum
gl_PIXEL_MAP_I_TO_I_SIZE = 0x0CB0

gl_PIXEL_MAP_I_TO_R :: GLenum
gl_PIXEL_MAP_I_TO_R = 0x0C72

gl_PIXEL_MAP_I_TO_R_SIZE :: GLenum
gl_PIXEL_MAP_I_TO_R_SIZE = 0x0CB2

gl_PIXEL_MAP_R_TO_R :: GLenum
gl_PIXEL_MAP_R_TO_R = 0x0C76

gl_PIXEL_MAP_R_TO_R_SIZE :: GLenum
gl_PIXEL_MAP_R_TO_R_SIZE = 0x0CB6

gl_PIXEL_MAP_S_TO_S :: GLenum
gl_PIXEL_MAP_S_TO_S = 0x0C71

gl_PIXEL_MAP_S_TO_S_SIZE :: GLenum
gl_PIXEL_MAP_S_TO_S_SIZE = 0x0CB1

gl_PIXEL_MODE_BIT :: GLbitfield
gl_PIXEL_MODE_BIT = 0x00000020

gl_POINT_BIT :: GLbitfield
gl_POINT_BIT = 0x00000002

gl_POINT_DISTANCE_ATTENUATION :: GLenum
gl_POINT_DISTANCE_ATTENUATION = 0x8129

gl_POINT_SIZE_MAX :: GLenum
gl_POINT_SIZE_MAX = 0x8127

gl_POINT_SIZE_MIN :: GLenum
gl_POINT_SIZE_MIN = 0x8126

gl_POINT_SMOOTH :: GLenum
gl_POINT_SMOOTH = 0x0B10

gl_POINT_SMOOTH_HINT :: GLenum
gl_POINT_SMOOTH_HINT = 0x0C51

gl_POINT_SPRITE :: GLenum
gl_POINT_SPRITE = 0x8861

gl_POINT_TOKEN :: GLenum
gl_POINT_TOKEN = 0x0701

gl_POLYGON :: GLenum
gl_POLYGON = 0x0009

gl_POLYGON_BIT :: GLbitfield
gl_POLYGON_BIT = 0x00000008

gl_POLYGON_MODE :: GLenum
gl_POLYGON_MODE = 0x0B40

gl_POLYGON_STIPPLE :: GLenum
gl_POLYGON_STIPPLE = 0x0B42

gl_POLYGON_STIPPLE_BIT :: GLbitfield
gl_POLYGON_STIPPLE_BIT = 0x00000010

gl_POLYGON_TOKEN :: GLenum
gl_POLYGON_TOKEN = 0x0703

gl_POSITION :: GLenum
gl_POSITION = 0x1203

gl_POST_COLOR_MATRIX_ALPHA_BIAS :: GLenum
gl_POST_COLOR_MATRIX_ALPHA_BIAS = 0x80BB

gl_POST_COLOR_MATRIX_ALPHA_SCALE :: GLenum
gl_POST_COLOR_MATRIX_ALPHA_SCALE = 0x80B7

gl_POST_COLOR_MATRIX_BLUE_BIAS :: GLenum
gl_POST_COLOR_MATRIX_BLUE_BIAS = 0x80BA

gl_POST_COLOR_MATRIX_BLUE_SCALE :: GLenum
gl_POST_COLOR_MATRIX_BLUE_SCALE = 0x80B6

gl_POST_COLOR_MATRIX_COLOR_TABLE :: GLenum
gl_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D2

gl_POST_COLOR_MATRIX_GREEN_BIAS :: GLenum
gl_POST_COLOR_MATRIX_GREEN_BIAS = 0x80B9

gl_POST_COLOR_MATRIX_GREEN_SCALE :: GLenum
gl_POST_COLOR_MATRIX_GREEN_SCALE = 0x80B5

gl_POST_COLOR_MATRIX_RED_BIAS :: GLenum
gl_POST_COLOR_MATRIX_RED_BIAS = 0x80B8

gl_POST_COLOR_MATRIX_RED_SCALE :: GLenum
gl_POST_COLOR_MATRIX_RED_SCALE = 0x80B4

gl_POST_CONVOLUTION_ALPHA_BIAS :: GLenum
gl_POST_CONVOLUTION_ALPHA_BIAS = 0x8023

gl_POST_CONVOLUTION_ALPHA_SCALE :: GLenum
gl_POST_CONVOLUTION_ALPHA_SCALE = 0x801F

gl_POST_CONVOLUTION_BLUE_BIAS :: GLenum
gl_POST_CONVOLUTION_BLUE_BIAS = 0x8022

gl_POST_CONVOLUTION_BLUE_SCALE :: GLenum
gl_POST_CONVOLUTION_BLUE_SCALE = 0x801E

gl_POST_CONVOLUTION_COLOR_TABLE :: GLenum
gl_POST_CONVOLUTION_COLOR_TABLE = 0x80D1

gl_POST_CONVOLUTION_GREEN_BIAS :: GLenum
gl_POST_CONVOLUTION_GREEN_BIAS = 0x8021

gl_POST_CONVOLUTION_GREEN_SCALE :: GLenum
gl_POST_CONVOLUTION_GREEN_SCALE = 0x801D

gl_POST_CONVOLUTION_RED_BIAS :: GLenum
gl_POST_CONVOLUTION_RED_BIAS = 0x8020

gl_POST_CONVOLUTION_RED_SCALE :: GLenum
gl_POST_CONVOLUTION_RED_SCALE = 0x801C

gl_PREVIOUS :: GLenum
gl_PREVIOUS = 0x8578

gl_PRIMARY_COLOR :: GLenum
gl_PRIMARY_COLOR = 0x8577

gl_PROJECTION :: GLenum
gl_PROJECTION = 0x1701

gl_PROJECTION_MATRIX :: GLenum
gl_PROJECTION_MATRIX = 0x0BA7

gl_PROJECTION_STACK_DEPTH :: GLenum
gl_PROJECTION_STACK_DEPTH = 0x0BA4

gl_PROXY_COLOR_TABLE :: GLenum
gl_PROXY_COLOR_TABLE = 0x80D3

gl_PROXY_HISTOGRAM :: GLenum
gl_PROXY_HISTOGRAM = 0x8025

gl_PROXY_POST_COLOR_MATRIX_COLOR_TABLE :: GLenum
gl_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D5

gl_PROXY_POST_CONVOLUTION_COLOR_TABLE :: GLenum
gl_PROXY_POST_CONVOLUTION_COLOR_TABLE = 0x80D4

gl_Q :: GLenum
gl_Q = 0x2003

gl_QUADRATIC_ATTENUATION :: GLenum
gl_QUADRATIC_ATTENUATION = 0x1209

gl_QUADS :: GLenum
gl_QUADS = 0x0007

gl_QUAD_STRIP :: GLenum
gl_QUAD_STRIP = 0x0008

gl_R :: GLenum
gl_R = 0x2002

gl_REDUCE :: GLenum
gl_REDUCE = 0x8016

gl_RED_BIAS :: GLenum
gl_RED_BIAS = 0x0D15

gl_RED_BITS :: GLenum
gl_RED_BITS = 0x0D52

gl_RED_SCALE :: GLenum
gl_RED_SCALE = 0x0D14

gl_REFLECTION_MAP :: GLenum
gl_REFLECTION_MAP = 0x8512

gl_RENDER :: GLenum
gl_RENDER = 0x1C00

gl_RENDER_MODE :: GLenum
gl_RENDER_MODE = 0x0C40

gl_REPLICATE_BORDER :: GLenum
gl_REPLICATE_BORDER = 0x8153

gl_RESCALE_NORMAL :: GLenum
gl_RESCALE_NORMAL = 0x803A

gl_RETURN :: GLenum
gl_RETURN = 0x0102

gl_RGBA_MODE :: GLenum
gl_RGBA_MODE = 0x0C31

gl_RGB_SCALE :: GLenum
gl_RGB_SCALE = 0x8573

gl_S :: GLenum
gl_S = 0x2000

gl_SCISSOR_BIT :: GLbitfield
gl_SCISSOR_BIT = 0x00080000

gl_SECONDARY_COLOR_ARRAY :: GLenum
gl_SECONDARY_COLOR_ARRAY = 0x845E

gl_SECONDARY_COLOR_ARRAY_BUFFER_BINDING :: GLenum
gl_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 0x889C

gl_SECONDARY_COLOR_ARRAY_POINTER :: GLenum
gl_SECONDARY_COLOR_ARRAY_POINTER = 0x845D

gl_SECONDARY_COLOR_ARRAY_SIZE :: GLenum
gl_SECONDARY_COLOR_ARRAY_SIZE = 0x845A

gl_SECONDARY_COLOR_ARRAY_STRIDE :: GLenum
gl_SECONDARY_COLOR_ARRAY_STRIDE = 0x845C

gl_SECONDARY_COLOR_ARRAY_TYPE :: GLenum
gl_SECONDARY_COLOR_ARRAY_TYPE = 0x845B

gl_SELECT :: GLenum
gl_SELECT = 0x1C02

gl_SELECTION_BUFFER_POINTER :: GLenum
gl_SELECTION_BUFFER_POINTER = 0x0DF3

gl_SELECTION_BUFFER_SIZE :: GLenum
gl_SELECTION_BUFFER_SIZE = 0x0DF4

gl_SEPARABLE_2D :: GLenum
gl_SEPARABLE_2D = 0x8012

gl_SEPARATE_SPECULAR_COLOR :: GLenum
gl_SEPARATE_SPECULAR_COLOR = 0x81FA

gl_SHADE_MODEL :: GLenum
gl_SHADE_MODEL = 0x0B54

gl_SHININESS :: GLenum
gl_SHININESS = 0x1601

gl_SINGLE_COLOR :: GLenum
gl_SINGLE_COLOR = 0x81F9

gl_SLUMINANCE :: GLenum
gl_SLUMINANCE = 0x8C46

gl_SLUMINANCE8 :: GLenum
gl_SLUMINANCE8 = 0x8C47

gl_SLUMINANCE8_ALPHA8 :: GLenum
gl_SLUMINANCE8_ALPHA8 = 0x8C45

gl_SLUMINANCE_ALPHA :: GLenum
gl_SLUMINANCE_ALPHA = 0x8C44

gl_SMOOTH :: GLenum
gl_SMOOTH = 0x1D01

gl_SOURCE0_ALPHA :: GLenum
gl_SOURCE0_ALPHA = 0x8588

gl_SOURCE0_RGB :: GLenum
gl_SOURCE0_RGB = 0x8580

gl_SOURCE1_ALPHA :: GLenum
gl_SOURCE1_ALPHA = 0x8589

gl_SOURCE1_RGB :: GLenum
gl_SOURCE1_RGB = 0x8581

gl_SOURCE2_ALPHA :: GLenum
gl_SOURCE2_ALPHA = 0x858A

gl_SOURCE2_RGB :: GLenum
gl_SOURCE2_RGB = 0x8582

gl_SPECULAR :: GLenum
gl_SPECULAR = 0x1202

gl_SPHERE_MAP :: GLenum
gl_SPHERE_MAP = 0x2402

gl_SPOT_CUTOFF :: GLenum
gl_SPOT_CUTOFF = 0x1206

gl_SPOT_DIRECTION :: GLenum
gl_SPOT_DIRECTION = 0x1204

gl_SPOT_EXPONENT :: GLenum
gl_SPOT_EXPONENT = 0x1205

gl_SRC0_ALPHA :: GLenum
gl_SRC0_ALPHA = 0x8588

gl_SRC0_RGB :: GLenum
gl_SRC0_RGB = 0x8580

gl_SRC1_ALPHA :: GLenum
gl_SRC1_ALPHA = 0x8589

gl_SRC1_RGB :: GLenum
gl_SRC1_RGB = 0x8581

gl_SRC2_ALPHA :: GLenum
gl_SRC2_ALPHA = 0x858A

gl_SRC2_RGB :: GLenum
gl_SRC2_RGB = 0x8582

gl_STACK_OVERFLOW :: GLenum
gl_STACK_OVERFLOW = 0x0503

gl_STACK_UNDERFLOW :: GLenum
gl_STACK_UNDERFLOW = 0x0504

gl_STENCIL_BITS :: GLenum
gl_STENCIL_BITS = 0x0D57

gl_SUBTRACT :: GLenum
gl_SUBTRACT = 0x84E7

gl_T :: GLenum
gl_T = 0x2001

gl_T2F_C3F_V3F :: GLenum
gl_T2F_C3F_V3F = 0x2A2A

gl_T2F_C4F_N3F_V3F :: GLenum
gl_T2F_C4F_N3F_V3F = 0x2A2C

gl_T2F_C4UB_V3F :: GLenum
gl_T2F_C4UB_V3F = 0x2A29

gl_T2F_N3F_V3F :: GLenum
gl_T2F_N3F_V3F = 0x2A2B

gl_T2F_V3F :: GLenum
gl_T2F_V3F = 0x2A27

gl_T4F_C4F_N3F_V4F :: GLenum
gl_T4F_C4F_N3F_V4F = 0x2A2D

gl_T4F_V4F :: GLenum
gl_T4F_V4F = 0x2A28

gl_TABLE_TOO_LARGE :: GLenum
gl_TABLE_TOO_LARGE = 0x8031

gl_TEXTURE_BIT :: GLbitfield
gl_TEXTURE_BIT = 0x00040000

gl_TEXTURE_COMPONENTS :: GLenum
gl_TEXTURE_COMPONENTS = 0x1003

gl_TEXTURE_COORD_ARRAY :: GLenum
gl_TEXTURE_COORD_ARRAY = 0x8078

gl_TEXTURE_COORD_ARRAY_BUFFER_BINDING :: GLenum
gl_TEXTURE_COORD_ARRAY_BUFFER_BINDING = 0x889A

gl_TEXTURE_COORD_ARRAY_COUNT :: GLenum
gl_TEXTURE_COORD_ARRAY_COUNT = 0x808B

gl_TEXTURE_COORD_ARRAY_POINTER :: GLenum
gl_TEXTURE_COORD_ARRAY_POINTER = 0x8092

gl_TEXTURE_COORD_ARRAY_SIZE :: GLenum
gl_TEXTURE_COORD_ARRAY_SIZE = 0x8088

gl_TEXTURE_COORD_ARRAY_STRIDE :: GLenum
gl_TEXTURE_COORD_ARRAY_STRIDE = 0x808A

gl_TEXTURE_COORD_ARRAY_TYPE :: GLenum
gl_TEXTURE_COORD_ARRAY_TYPE = 0x8089

gl_TEXTURE_ENV :: GLenum
gl_TEXTURE_ENV = 0x2300

gl_TEXTURE_ENV_COLOR :: GLenum
gl_TEXTURE_ENV_COLOR = 0x2201

gl_TEXTURE_ENV_MODE :: GLenum
gl_TEXTURE_ENV_MODE = 0x2200

gl_TEXTURE_FILTER_CONTROL :: GLenum
gl_TEXTURE_FILTER_CONTROL = 0x8500

gl_TEXTURE_GEN_MODE :: GLenum
gl_TEXTURE_GEN_MODE = 0x2500

gl_TEXTURE_GEN_Q :: GLenum
gl_TEXTURE_GEN_Q = 0x0C63

gl_TEXTURE_GEN_R :: GLenum
gl_TEXTURE_GEN_R = 0x0C62

gl_TEXTURE_GEN_S :: GLenum
gl_TEXTURE_GEN_S = 0x0C60

gl_TEXTURE_GEN_T :: GLenum
gl_TEXTURE_GEN_T = 0x0C61

gl_TEXTURE_INTENSITY_SIZE :: GLenum
gl_TEXTURE_INTENSITY_SIZE = 0x8061

gl_TEXTURE_INTENSITY_TYPE :: GLenum
gl_TEXTURE_INTENSITY_TYPE = 0x8C15

gl_TEXTURE_LUMINANCE_SIZE :: GLenum
gl_TEXTURE_LUMINANCE_SIZE = 0x8060

gl_TEXTURE_LUMINANCE_TYPE :: GLenum
gl_TEXTURE_LUMINANCE_TYPE = 0x8C14

gl_TEXTURE_MATRIX :: GLenum
gl_TEXTURE_MATRIX = 0x0BA8

gl_TEXTURE_PRIORITY :: GLenum
gl_TEXTURE_PRIORITY = 0x8066

gl_TEXTURE_RESIDENT :: GLenum
gl_TEXTURE_RESIDENT = 0x8067

gl_TEXTURE_STACK_DEPTH :: GLenum
gl_TEXTURE_STACK_DEPTH = 0x0BA5

gl_TRANSFORM_BIT :: GLbitfield
gl_TRANSFORM_BIT = 0x00001000

gl_TRANSPOSE_COLOR_MATRIX :: GLenum
gl_TRANSPOSE_COLOR_MATRIX = 0x84E6

gl_TRANSPOSE_MODELVIEW_MATRIX :: GLenum
gl_TRANSPOSE_MODELVIEW_MATRIX = 0x84E3

gl_TRANSPOSE_PROJECTION_MATRIX :: GLenum
gl_TRANSPOSE_PROJECTION_MATRIX = 0x84E4

gl_TRANSPOSE_TEXTURE_MATRIX :: GLenum
gl_TRANSPOSE_TEXTURE_MATRIX = 0x84E5

gl_V2F :: GLenum
gl_V2F = 0x2A20

gl_V3F :: GLenum
gl_V3F = 0x2A21

gl_VERTEX_ARRAY :: GLenum
gl_VERTEX_ARRAY = 0x8074

gl_VERTEX_ARRAY_BUFFER_BINDING :: GLenum
gl_VERTEX_ARRAY_BUFFER_BINDING = 0x8896

gl_VERTEX_ARRAY_COUNT :: GLenum
gl_VERTEX_ARRAY_COUNT = 0x807D

gl_VERTEX_ARRAY_POINTER :: GLenum
gl_VERTEX_ARRAY_POINTER = 0x808E

gl_VERTEX_ARRAY_SIZE :: GLenum
gl_VERTEX_ARRAY_SIZE = 0x807A

gl_VERTEX_ARRAY_STRIDE :: GLenum
gl_VERTEX_ARRAY_STRIDE = 0x807C

gl_VERTEX_ARRAY_TYPE :: GLenum
gl_VERTEX_ARRAY_TYPE = 0x807B

gl_VERTEX_PROGRAM_TWO_SIDE :: GLenum
gl_VERTEX_PROGRAM_TWO_SIDE = 0x8643

gl_VIEWPORT_BIT :: GLbitfield
gl_VIEWPORT_BIT = 0x00000800

gl_WEIGHT_ARRAY_BUFFER_BINDING :: GLenum
gl_WEIGHT_ARRAY_BUFFER_BINDING = 0x889E

gl_ZOOM_X :: GLenum
gl_ZOOM_X = 0x0D16

gl_ZOOM_Y :: GLenum
gl_ZOOM_Y = 0x0D17
