--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.Rendering.OpenGL.Raw.NV.TextureShader
-- Copyright   :  (c) Sven Panne 2013
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- All raw functions and tokens from the NV_texture_shader extension not
-- already in the OpenGL 3.1 core, see
-- <http://www.opengl.org/registry/specs/NV/texture_shader.txt>.
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.Raw.NV.TextureShader (
   -- * Tokens
   gl_TEXTURE_SHADER,
   gl_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING,
   gl_SHADER_OPERATION,
   gl_OFFSET_TEXTURE_SCALE,
   gl_OFFSET_TEXTURE_BIAS,
   gl_OFFSET_TEXTURE_2D_SCALE,
   gl_OFFSET_TEXTURE_2D_BIAS,
   gl_PREVIOUS_TEXTURE_INPUT,
   gl_CULL_MODES,
   gl_OFFSET_TEXTURE_MATRIX,
   gl_OFFSET_TEXTURE_2D_MATRIX,
   gl_CONST_EYE,
   gl_SHADER_CONSISTENT,
   gl_PASS_THROUGH,
   gl_CULL_FRAGMENT,
   gl_OFFSET_TEXTURE_2D,
   gl_OFFSET_TEXTURE_RECTANGLE,
   gl_OFFSET_TEXTURE_RECTANGLE_SCALE,
   gl_DEPENDENT_AR_TEXTURE_2D,
   gl_DEPENDENT_GB_TEXTURE_2D,
   gl_DOT_PRODUCT,
   gl_DOT_PRODUCT_DEPTH_REPLACE,
   gl_DOT_PRODUCT_TEXTURE_2D,
   gl_DOT_PRODUCT_TEXTURE_RECTANGLE,
   gl_DOT_PRODUCT_TEXTURE_CUBE_MAP,
   gl_DOT_PRODUCT_DIFFUSE_CUBE_MAP,
   gl_DOT_PRODUCT_REFLECT_CUBE_MAP,
   gl_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP,
   gl_UNSIGNED_IDENTITY,
   gl_EXPAND_NORMAL,
   gl_HILO,
   gl_DSDT,
   gl_DSDT_MAG,
   gl_DSDT_MAG_VIB,
   gl_UNSIGNED_INT_S8_S8_8_8,
   gl_UNSIGNED_INT_8_8_S8_S8_REV,
   gl_SIGNED_RGBA,
   gl_SIGNED_RGBA8,
   gl_SIGNED_RGB,
   gl_SIGNED_RGB8,
   gl_SIGNED_LUMINANCE,
   gl_SIGNED_LUMINANCE8,
   gl_SIGNED_LUMINANCE_ALPHA,
   gl_SIGNED_LUMINANCE8_ALPHA8,
   gl_SIGNED_ALPHA,
   gl_SIGNED_ALPHA8,
   gl_SIGNED_INTENSITY,
   gl_SIGNED_INTENSITY8,
   gl_SIGNED_RGB_UNSIGNED_ALPHA,
   gl_SIGNED_RGB8_UNSIGNED_ALPHA8,
   gl_HILO16,
   gl_SIGNED_HILO,
   gl_SIGNED_HILO16,
   gl_DSDT8,
   gl_DSDT8_MAG8,
   gl_DSDT_MAG_INTENSITY,
   gl_DSDT8_MAG8_INTENSITY8,
   gl_HI_SCALE,
   gl_LO_SCALE,
   gl_DS_SCALE,
   gl_DT_SCALE,
   gl_MAGNITUDE_SCALE,
   gl_VIBRANCE_SCALE,
   gl_HI_BIAS,
   gl_LO_BIAS,
   gl_DS_BIAS,
   gl_DT_BIAS,
   gl_MAGNITUDE_BIAS,
   gl_VIBRANCE_BIAS,
   gl_TEXTURE_BORDER_VALUES,
   gl_TEXTURE_HI_SIZE,
   gl_TEXTURE_LO_SIZE,
   gl_TEXTURE_DS_SIZE,
   gl_TEXTURE_DT_SIZE,
   gl_TEXTURE_MAG_SIZE
) where

import Graphics.Rendering.OpenGL.Raw.Core32
import Graphics.Rendering.OpenGL.Raw.NV.RegisterCombiners

gl_TEXTURE_SHADER :: GLenum
gl_TEXTURE_SHADER = 0x86DE

gl_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING :: GLenum
gl_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING = 0x86D9

gl_SHADER_OPERATION :: GLenum
gl_SHADER_OPERATION = 0x86DF

gl_OFFSET_TEXTURE_SCALE :: GLenum
gl_OFFSET_TEXTURE_SCALE = 0x86E2

gl_OFFSET_TEXTURE_BIAS :: GLenum
gl_OFFSET_TEXTURE_BIAS = 0x86E3

gl_OFFSET_TEXTURE_2D_SCALE :: GLenum
gl_OFFSET_TEXTURE_2D_SCALE = gl_OFFSET_TEXTURE_SCALE

gl_OFFSET_TEXTURE_2D_BIAS :: GLenum
gl_OFFSET_TEXTURE_2D_BIAS = gl_OFFSET_TEXTURE_BIAS

gl_PREVIOUS_TEXTURE_INPUT :: GLenum
gl_PREVIOUS_TEXTURE_INPUT = 0x86E4

gl_CULL_MODES :: GLenum
gl_CULL_MODES = 0x86E0

gl_OFFSET_TEXTURE_MATRIX :: GLenum
gl_OFFSET_TEXTURE_MATRIX = 0x86E1

gl_OFFSET_TEXTURE_2D_MATRIX :: GLenum
gl_OFFSET_TEXTURE_2D_MATRIX = gl_OFFSET_TEXTURE_MATRIX

gl_CONST_EYE :: GLenum
gl_CONST_EYE = 0x86E5

gl_SHADER_CONSISTENT :: GLenum
gl_SHADER_CONSISTENT = 0x86DD

gl_PASS_THROUGH :: GLenum
gl_PASS_THROUGH = 0x86E6

gl_CULL_FRAGMENT :: GLenum
gl_CULL_FRAGMENT = 0x86E7

gl_OFFSET_TEXTURE_2D :: GLenum
gl_OFFSET_TEXTURE_2D = 0x86E8

gl_OFFSET_TEXTURE_RECTANGLE :: GLenum
gl_OFFSET_TEXTURE_RECTANGLE = 0x864C

gl_OFFSET_TEXTURE_RECTANGLE_SCALE :: GLenum
gl_OFFSET_TEXTURE_RECTANGLE_SCALE = 0x864D

gl_DEPENDENT_AR_TEXTURE_2D :: GLenum
gl_DEPENDENT_AR_TEXTURE_2D = 0x86E9

gl_DEPENDENT_GB_TEXTURE_2D :: GLenum
gl_DEPENDENT_GB_TEXTURE_2D = 0x86EA

gl_DOT_PRODUCT :: GLenum
gl_DOT_PRODUCT = 0x86EC

gl_DOT_PRODUCT_DEPTH_REPLACE :: GLenum
gl_DOT_PRODUCT_DEPTH_REPLACE = 0x86ED

gl_DOT_PRODUCT_TEXTURE_2D :: GLenum
gl_DOT_PRODUCT_TEXTURE_2D = 0x86EE

gl_DOT_PRODUCT_TEXTURE_RECTANGLE :: GLenum
gl_DOT_PRODUCT_TEXTURE_RECTANGLE = 0x864E

gl_DOT_PRODUCT_TEXTURE_CUBE_MAP :: GLenum
gl_DOT_PRODUCT_TEXTURE_CUBE_MAP = 0x86F0

gl_DOT_PRODUCT_DIFFUSE_CUBE_MAP :: GLenum
gl_DOT_PRODUCT_DIFFUSE_CUBE_MAP = 0x86F1

gl_DOT_PRODUCT_REFLECT_CUBE_MAP :: GLenum
gl_DOT_PRODUCT_REFLECT_CUBE_MAP = 0x86F2

gl_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP :: GLenum
gl_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP = 0x86F3

gl_HILO :: GLenum
gl_HILO = 0x86F4

gl_DSDT :: GLenum
gl_DSDT = 0x86F5

gl_DSDT_MAG :: GLenum
gl_DSDT_MAG = 0x86F6

gl_DSDT_MAG_VIB :: GLenum
gl_DSDT_MAG_VIB = 0x86F7

gl_UNSIGNED_INT_S8_S8_8_8 :: GLenum
gl_UNSIGNED_INT_S8_S8_8_8 = 0x86DA 

gl_UNSIGNED_INT_8_8_S8_S8_REV :: GLenum
gl_UNSIGNED_INT_8_8_S8_S8_REV = 0x86DB 

gl_SIGNED_RGBA :: GLenum
gl_SIGNED_RGBA = 0x86FB

gl_SIGNED_RGBA8 :: GLenum
gl_SIGNED_RGBA8 = 0x86FC

gl_SIGNED_RGB :: GLenum
gl_SIGNED_RGB = 0x86FE

gl_SIGNED_RGB8 :: GLenum
gl_SIGNED_RGB8 = 0x86FF

gl_SIGNED_LUMINANCE :: GLenum
gl_SIGNED_LUMINANCE = 0x8701

gl_SIGNED_LUMINANCE8 :: GLenum
gl_SIGNED_LUMINANCE8 = 0x8702

gl_SIGNED_LUMINANCE_ALPHA :: GLenum
gl_SIGNED_LUMINANCE_ALPHA = 0x8703

gl_SIGNED_LUMINANCE8_ALPHA8 :: GLenum
gl_SIGNED_LUMINANCE8_ALPHA8 = 0x8704

gl_SIGNED_ALPHA :: GLenum
gl_SIGNED_ALPHA = 0x8705

gl_SIGNED_ALPHA8 :: GLenum
gl_SIGNED_ALPHA8 = 0x8706

gl_SIGNED_INTENSITY :: GLenum
gl_SIGNED_INTENSITY = 0x8707

gl_SIGNED_INTENSITY8 :: GLenum
gl_SIGNED_INTENSITY8 = 0x8708

gl_SIGNED_RGB_UNSIGNED_ALPHA :: GLenum
gl_SIGNED_RGB_UNSIGNED_ALPHA = 0x870C

gl_SIGNED_RGB8_UNSIGNED_ALPHA8 :: GLenum
gl_SIGNED_RGB8_UNSIGNED_ALPHA8 = 0x870D

gl_HILO16 :: GLenum
gl_HILO16 = 0x86F8

gl_SIGNED_HILO :: GLenum
gl_SIGNED_HILO = 0x86F9

gl_SIGNED_HILO16 :: GLenum
gl_SIGNED_HILO16 = 0x86FA

gl_DSDT8 :: GLenum
gl_DSDT8 = 0x8709

gl_DSDT8_MAG8 :: GLenum
gl_DSDT8_MAG8 = 0x870A

gl_DSDT_MAG_INTENSITY :: GLenum
gl_DSDT_MAG_INTENSITY = 0x86DC

gl_DSDT8_MAG8_INTENSITY8 :: GLenum
gl_DSDT8_MAG8_INTENSITY8 = 0x870B

gl_HI_SCALE :: GLenum
gl_HI_SCALE = 0x870E

gl_LO_SCALE :: GLenum
gl_LO_SCALE = 0x870F

gl_DS_SCALE :: GLenum
gl_DS_SCALE = 0x8710

gl_DT_SCALE :: GLenum
gl_DT_SCALE = 0x8711

gl_MAGNITUDE_SCALE :: GLenum
gl_MAGNITUDE_SCALE = 0x8712

gl_VIBRANCE_SCALE :: GLenum
gl_VIBRANCE_SCALE = 0x8713

gl_HI_BIAS :: GLenum
gl_HI_BIAS = 0x8714

gl_LO_BIAS :: GLenum
gl_LO_BIAS = 0x8715

gl_DS_BIAS :: GLenum
gl_DS_BIAS = 0x8716

gl_DT_BIAS :: GLenum
gl_DT_BIAS = 0x8717

gl_MAGNITUDE_BIAS :: GLenum
gl_MAGNITUDE_BIAS = 0x8718

gl_VIBRANCE_BIAS :: GLenum
gl_VIBRANCE_BIAS = 0x8719

gl_TEXTURE_BORDER_VALUES :: GLenum
gl_TEXTURE_BORDER_VALUES = 0x871A

gl_TEXTURE_HI_SIZE :: GLenum
gl_TEXTURE_HI_SIZE = 0x871B

gl_TEXTURE_LO_SIZE :: GLenum
gl_TEXTURE_LO_SIZE = 0x871C

gl_TEXTURE_DS_SIZE :: GLenum
gl_TEXTURE_DS_SIZE = 0x871D

gl_TEXTURE_DT_SIZE :: GLenum
gl_TEXTURE_DT_SIZE = 0x871E

gl_TEXTURE_MAG_SIZE :: GLenum
gl_TEXTURE_MAG_SIZE = 0x871F
